Rem
Rem
Rem    NAME
Rem      md.sql - MultiDimension (icd) kernel functions
Rem    DESCRIPTION
Rem      Routines to encode, decode, and manipulate multidimensional data.
Rem    RETURNS
Rem
Rem    NOTES
Rem      The procedural option is needed to use this facility.
Rem      Script run by MDSYS.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu       09/11/01 - parallel_enable hhencode_bylevel
Rem    jsharma    05/14/98 - Fix sigerr pragma
Rem    gvincent   12/19/97 -
Rem    pfwang     12/13/97 -
Rem    pvretano   06/09/96 -  Expand HHID????() to 128 verticies.
Rem    pvretano   09/21/95 -  Add sigerr() procedure.
Rem    bcao       04/17/95 -  Modification for ICD interface
Rem    pvretano   04/04/95 -  Creation
 
Rem ********************************************************************
Rem This package must not be modified by the customer.  Doing so
Rem could cause internal errors.
Rem ********************************************************************

CREATE OR REPLACE PACKAGE md IS
  -----------------------------
  -- Parameters
  --
  -- Checking flag (TRUE is ON, FALSE is OFF) for correct usage 
  -- of functions.

  -----------------------------
  -- Procedures and Functions
  PROCEDURE set_check (checkflg IN BOOLEAN);
  FUNCTION hhndim (hhc IN RAW)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhndim, WNDS, WNPS);
  FUNCTION hhbytelen (ndim IN BINARY_INTEGER, mlv IN BINARY_INTEGER)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhbytelen, WNDS, WNPS);
  FUNCTION hhprecision (lb IN NUMBER, ub IN NUMBER, lv IN BINARY_INTEGER)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhprecision, WNDS, WNPS);
  FUNCTION hhlevels (lb IN NUMBER, ub IN NUMBER, pr IN BINARY_INTEGER)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhlevels, WNDS, WNPS);
  FUNCTION hhdecode ( hhc IN RAW, dim IN BINARY_INTEGER, 
           lb IN NUMBER, ub IN NUMBER) 
    RETURN NUMBER;
  PRAGMA RESTRICT_REFERENCES (hhdecode, WNDS, WNPS);
  FUNCTION hhencode (
           v01 IN NUMBER,         l01 IN NUMBER, 
           u01 IN NUMBER,         p01 IN BINARY_INTEGER,
           v02 IN NUMBER := NULL, l02 IN NUMBER := NULL, 
           u02 IN NUMBER := NULL, p02 IN BINARY_INTEGER := NULL,
           v03 IN NUMBER := NULL, l03 IN NUMBER := NULL, 
           u03 IN NUMBER := NULL, p03 IN BINARY_INTEGER := NULL,
           v04 IN NUMBER := NULL, l04 IN NUMBER := NULL, 
           u04 IN NUMBER := NULL, p04 IN BINARY_INTEGER := NULL,
           v05 IN NUMBER := NULL, l05 IN NUMBER := NULL, 
           u05 IN NUMBER := NULL, p05 IN BINARY_INTEGER := NULL,
           v06 IN NUMBER := NULL, l06 IN NUMBER := NULL, 
           u06 IN NUMBER := NULL, p06 IN BINARY_INTEGER := NULL)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhencode, WNDS, WNPS);
  FUNCTION hhencode (
           v01 IN NUMBER,         l01 IN NUMBER, 
           u01 IN NUMBER,         p01 IN BINARY_INTEGER,
           v02 IN NUMBER,         l02 IN NUMBER, 
           u02 IN NUMBER,         p02 IN BINARY_INTEGER,
           v03 IN NUMBER,         l03 IN NUMBER, 
           u03 IN NUMBER,         p03 IN BINARY_INTEGER,
           v04 IN NUMBER,         l04 IN NUMBER, 
           u04 IN NUMBER,         p04 IN BINARY_INTEGER,
           v05 IN NUMBER,         l05 IN NUMBER, 
           u05 IN NUMBER,         p05 IN BINARY_INTEGER,
           v06 IN NUMBER,         l06 IN NUMBER, 
           u06 IN NUMBER,         p06 IN BINARY_INTEGER,
           v07 IN NUMBER,         l07 IN NUMBER, 
           u07 IN NUMBER,         p07 IN BINARY_INTEGER,
           v08 IN NUMBER := NULL, l08 IN NUMBER := NULL, 
           u08 IN NUMBER := NULL, p08 IN BINARY_INTEGER := NULL,
           v09 IN NUMBER := NULL, l09 IN NUMBER := NULL, 
           u09 IN NUMBER := NULL, p09 IN BINARY_INTEGER := NULL,
           v10 IN NUMBER := NULL, l10 IN NUMBER := NULL, 
           u10 IN NUMBER := NULL, p10 IN BINARY_INTEGER := NULL,
           v11 IN NUMBER := NULL, l11 IN NUMBER := NULL, 
           u11 IN NUMBER := NULL, p11 IN BINARY_INTEGER := NULL,
           v12 IN NUMBER := NULL, l12 IN NUMBER := NULL, 
           u12 IN NUMBER := NULL, p12 IN BINARY_INTEGER := NULL,
           v13 IN NUMBER := NULL, l13 IN NUMBER := NULL, 
           u13 IN NUMBER := NULL, p13 IN BINARY_INTEGER := NULL,
           v14 IN NUMBER := NULL, l14 IN NUMBER := NULL, 
           u14 IN NUMBER := NULL, p14 IN BINARY_INTEGER := NULL,
           v15 IN NUMBER := NULL, l15 IN NUMBER := NULL, 
           u15 IN NUMBER := NULL, p15 IN BINARY_INTEGER := NULL,
           v16 IN NUMBER := NULL, l16 IN NUMBER := NULL, 
           u16 IN NUMBER := NULL, p16 IN BINARY_INTEGER := NULL,
           v17 IN NUMBER := NULL, l17 IN NUMBER := NULL, 
           u17 IN NUMBER := NULL, p17 IN BINARY_INTEGER := NULL,
           v18 IN NUMBER := NULL, l18 IN NUMBER := NULL, 
           u18 IN NUMBER := NULL, p18 IN BINARY_INTEGER := NULL,
           v19 IN NUMBER := NULL, l19 IN NUMBER := NULL, 
           u19 IN NUMBER := NULL, p19 IN BINARY_INTEGER := NULL,
           v20 IN NUMBER := NULL, l20 IN NUMBER := NULL, 
           u20 IN NUMBER := NULL, p20 IN BINARY_INTEGER := NULL,
           v21 IN NUMBER := NULL, l21 IN NUMBER := NULL, 
           u21 IN NUMBER := NULL, p21 IN BINARY_INTEGER := NULL,
           v22 IN NUMBER := NULL, l22 IN NUMBER := NULL, 
           u22 IN NUMBER := NULL, p22 IN BINARY_INTEGER := NULL,
           v23 IN NUMBER := NULL, l23 IN NUMBER := NULL, 
           u23 IN NUMBER := NULL, p23 IN BINARY_INTEGER := NULL,
           v24 IN NUMBER := NULL, l24 IN NUMBER := NULL, 
           u24 IN NUMBER := NULL, p24 IN BINARY_INTEGER := NULL,
           v25 IN NUMBER := NULL, l25 IN NUMBER := NULL, 
           u25 IN NUMBER := NULL, p25 IN BINARY_INTEGER := NULL,
           v26 IN NUMBER := NULL, l26 IN NUMBER := NULL, 
           u26 IN NUMBER := NULL, p26 IN BINARY_INTEGER := NULL,
           v27 IN NUMBER := NULL, l27 IN NUMBER := NULL, 
           u27 IN NUMBER := NULL, p27 IN BINARY_INTEGER := NULL,
           v28 IN NUMBER := NULL, l28 IN NUMBER := NULL, 
           u28 IN NUMBER := NULL, p28 IN BINARY_INTEGER := NULL,
           v29 IN NUMBER := NULL, l29 IN NUMBER := NULL, 
           u29 IN NUMBER := NULL, p29 IN BINARY_INTEGER := NULL,
           v30 IN NUMBER := NULL, l30 IN NUMBER := NULL, 
           u30 IN NUMBER := NULL, p30 IN BINARY_INTEGER := NULL,
           v31 IN NUMBER := NULL, l31 IN NUMBER := NULL, 
           u31 IN NUMBER := NULL, p31 IN BINARY_INTEGER := NULL,
           v32 IN NUMBER := NULL, l32 IN NUMBER := NULL, 
           u32 IN NUMBER := NULL, p32 IN BINARY_INTEGER := NULL)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhencode, WNDS, WNPS);
  FUNCTION hhcellbndry (hhc IN RAW, dim IN BINARY_INTEGER,
           lb IN NUMBER, ub IN NUMBER,lv IN BINARY_INTEGER, mm IN VARCHAR2) 
    RETURN NUMBER;
  PRAGMA RESTRICT_REFERENCES (hhcellbndry, WNDS, WNPS);
  FUNCTION hhsubstr (hhc IN RAW, slv IN BINARY_INTEGER, elv IN BINARY_INTEGER)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhsubstr, WNDS, WNPS);
  FUNCTION hhcommoncode (hh1 IN RAW, hh2 IN RAW)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhcommoncode, WNDS, WNPS);
  FUNCTION hhsubdivide (hh1 IN RAW, cid IN BINARY_INTEGER)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhsubdivide, WNDS, WNPS);
  FUNCTION hhmatch (hh1 IN RAW, hh2 IN RAW)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhmatch, WNDS, WNPS);
  FUNCTION hhorder (hhc IN RAW)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhorder, WNDS, WNPS);
  FUNCTION hhgroup (hhc IN RAW)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhgroup, WNDS, WNPS);
  FUNCTION hhcldate (jd IN NUMBER, fmt IN VARCHAR2)
    RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES (hhcldate, WNDS, WNPS);
  FUNCTION hhjldate (ds IN VARCHAR2, fmt IN VARCHAR2)
    RETURN NUMBER;
  PRAGMA RESTRICT_REFERENCES (hhjldate, WNDS, WNPS);
  FUNCTION hhlength (hhc IN RAW) 
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhlength, WNDS, WNPS);
  FUNCTION hhlength (hhc IN RAW, dim IN BINARY_INTEGER) 
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhlength, WNDS, WNPS);
  FUNCTION hhcompare (hh1 IN RAW, hh2 IN RAW)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhcompare, WNDS, WNPS);
  FUNCTION hhncompare (hh1 IN RAW, hh2 IN RAW, lv IN BINARY_INTEGER)
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhncompare, WNDS, WNPS);
  FUNCTION hhcollapse( hhc IN RAW,
           d01 IN BINARY_INTEGER,       d02 IN BINARY_INTEGER:=NULL, 
           d03 IN BINARY_INTEGER:=NULL, d04 IN BINARY_INTEGER:=NULL, 
           d05 IN BINARY_INTEGER:=NULL, d06 IN BINARY_INTEGER:=NULL,
           d07 IN BINARY_INTEGER:=NULL, d08 IN BINARY_INTEGER:=NULL, 
           d09 IN BINARY_INTEGER:=NULL, d10 IN BINARY_INTEGER:=NULL, 
           d11 IN BINARY_INTEGER:=NULL, d12 IN BINARY_INTEGER:=NULL,
           d13 IN BINARY_INTEGER:=NULL, d14 IN BINARY_INTEGER:=NULL, 
           d15 IN BINARY_INTEGER:=NULL, d16 IN BINARY_INTEGER:=NULL, 
           d17 IN BINARY_INTEGER:=NULL, d18 IN BINARY_INTEGER:=NULL,
           d19 IN BINARY_INTEGER:=NULL, d20 IN BINARY_INTEGER:=NULL, 
           d21 IN BINARY_INTEGER:=NULL, d22 IN BINARY_INTEGER:=NULL, 
           d23 IN BINARY_INTEGER:=NULL, d24 IN BINARY_INTEGER:=NULL,
           d25 IN BINARY_INTEGER:=NULL, d26 IN BINARY_INTEGER:=NULL, 
           d27 IN BINARY_INTEGER:=NULL, d28 IN BINARY_INTEGER:=NULL, 
           d29 IN BINARY_INTEGER:=NULL, d30 IN BINARY_INTEGER:=NULL,
           d31 IN BINARY_INTEGER:=NULL)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhcollapse, WNDS, WNPS);
  FUNCTION hhcompose( hhc IN RAW,
           d01 IN BINARY_INTEGER,       d02 IN BINARY_INTEGER:=NULL, 
           d03 IN BINARY_INTEGER:=NULL, d04 IN BINARY_INTEGER:=NULL, 
           d05 IN BINARY_INTEGER:=NULL, d06 IN BINARY_INTEGER:=NULL,
           d07 IN BINARY_INTEGER:=NULL, d08 IN BINARY_INTEGER:=NULL, 
           d09 IN BINARY_INTEGER:=NULL, d10 IN BINARY_INTEGER:=NULL, 
           d11 IN BINARY_INTEGER:=NULL, d12 IN BINARY_INTEGER:=NULL,
           d13 IN BINARY_INTEGER:=NULL, d14 IN BINARY_INTEGER:=NULL, 
           d15 IN BINARY_INTEGER:=NULL, d16 IN BINARY_INTEGER:=NULL, 
           d17 IN BINARY_INTEGER:=NULL, d18 IN BINARY_INTEGER:=NULL,
           d19 IN BINARY_INTEGER:=NULL, d20 IN BINARY_INTEGER:=NULL, 
           d21 IN BINARY_INTEGER:=NULL, d22 IN BINARY_INTEGER:=NULL, 
           d23 IN BINARY_INTEGER:=NULL, d24 IN BINARY_INTEGER:=NULL,
           d25 IN BINARY_INTEGER:=NULL, d26 IN BINARY_INTEGER:=NULL, 
           d27 IN BINARY_INTEGER:=NULL, d28 IN BINARY_INTEGER:=NULL, 
           d29 IN BINARY_INTEGER:=NULL, d30 IN BINARY_INTEGER:=NULL,
           d31 IN BINARY_INTEGER:=NULL, d32 IN BINARY_INTEGER:=NULL)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhcompose, WNDS, WNPS);
  FUNCTION hhdistance (type IN VARCHAR2, hh1 IN RAW, hh2 IN RAW,
           l01 IN NUMBER,       u01 IN NUMBER, 
           l02 IN NUMBER:=NULL, u02 IN NUMBER:=NULL,
           l03 IN NUMBER:=NULL, u03 IN NUMBER:=NULL, 
           l04 IN NUMBER:=NULL, u04 IN NUMBER:=NULL,
           l05 IN NUMBER:=NULL, u05 IN NUMBER:=NULL, 
           l06 IN NUMBER:=NULL, u06 IN NUMBER:=NULL,
           l07 IN NUMBER:=NULL, u07 IN NUMBER:=NULL, 
           l08 IN NUMBER:=NULL, u08 IN NUMBER:=NULL,
           l09 IN NUMBER:=NULL, u09 IN NUMBER:=NULL, 
           l10 IN NUMBER:=NULL, u10 IN NUMBER:=NULL,
           l11 IN NUMBER:=NULL, u11 IN NUMBER:=NULL, 
           l12 IN NUMBER:=NULL, u12 IN NUMBER:=NULL,
           l13 IN NUMBER:=NULL, u13 IN NUMBER:=NULL, 
           l14 IN NUMBER:=NULL, u14 IN NUMBER:=NULL,
           l15 IN NUMBER:=NULL, u15 IN NUMBER:=NULL, 
           l16 IN NUMBER:=NULL, u16 IN NUMBER:=NULL,
           l17 IN NUMBER:=NULL, u17 IN NUMBER:=NULL, 
           l18 IN NUMBER:=NULL, u18 IN NUMBER:=NULL,
           l19 IN NUMBER:=NULL, u19 IN NUMBER:=NULL, 
           l20 IN NUMBER:=NULL, u20 IN NUMBER:=NULL,
           l21 IN NUMBER:=NULL, u21 IN NUMBER:=NULL, 
           l22 IN NUMBER:=NULL, u22 IN NUMBER:=NULL,
           l23 IN NUMBER:=NULL, u23 IN NUMBER:=NULL, 
           l24 IN NUMBER:=NULL, u24 IN NUMBER:=NULL,
           l25 IN NUMBER:=NULL, u25 IN NUMBER:=NULL, 
           l26 IN NUMBER:=NULL, u26 IN NUMBER:=NULL,
           l27 IN NUMBER:=NULL, u27 IN NUMBER:=NULL, 
           l28 IN NUMBER:=NULL, u28 IN NUMBER:=NULL,
           l29 IN NUMBER:=NULL, u29 IN NUMBER:=NULL, 
           l30 IN NUMBER:=NULL, u30 IN NUMBER:=NULL,
           l31 IN NUMBER:=NULL, u31 IN NUMBER:=NULL,
           l32 IN NUMBER:=NULL, u32 IN NUMBER:=NULL)
    RETURN NUMBER;
  PRAGMA RESTRICT_REFERENCES (hhdistance, WNDS, WNPS);
  FUNCTION hhcellsize (
      l01 IN NUMBER,      u01 IN NUMBER,      lv01 IN BINARY_INTEGER,
      l02 IN NUMBER:=NULL,u02 IN NUMBER:=NULL,lv02 IN BINARY_INTEGER:=NULL,
      l03 IN NUMBER:=NULL,u03 IN NUMBER:=NULL,lv03 IN BINARY_INTEGER:=NULL,
      l04 IN NUMBER:=NULL,u04 IN NUMBER:=NULL,lv04 IN BINARY_INTEGER:=NULL,
      l05 IN NUMBER:=NULL,u05 IN NUMBER:=NULL,lv05 IN BINARY_INTEGER:=NULL,
      l06 IN NUMBER:=NULL,u06 IN NUMBER:=NULL,lv06 IN BINARY_INTEGER:=NULL,
      l07 IN NUMBER:=NULL,u07 IN NUMBER:=NULL,lv07 IN BINARY_INTEGER:=NULL,
      l08 IN NUMBER:=NULL,u08 IN NUMBER:=NULL,lv08 IN BINARY_INTEGER:=NULL,
      l09 IN NUMBER:=NULL,u09 IN NUMBER:=NULL,lv09 IN BINARY_INTEGER:=NULL,
      l10 IN NUMBER:=NULL,u10 IN NUMBER:=NULL,lv10 IN BINARY_INTEGER:=NULL,
      l11 IN NUMBER:=NULL,u11 IN NUMBER:=NULL,lv11 IN BINARY_INTEGER:=NULL,
      l12 IN NUMBER:=NULL,u12 IN NUMBER:=NULL,lv12 IN BINARY_INTEGER:=NULL,
      l13 IN NUMBER:=NULL,u13 IN NUMBER:=NULL,lv13 IN BINARY_INTEGER:=NULL,
      l14 IN NUMBER:=NULL,u14 IN NUMBER:=NULL,lv14 IN BINARY_INTEGER:=NULL,
      l15 IN NUMBER:=NULL,u15 IN NUMBER:=NULL,lv15 IN BINARY_INTEGER:=NULL,
      l16 IN NUMBER:=NULL,u16 IN NUMBER:=NULL,lv16 IN BINARY_INTEGER:=NULL,
      l17 IN NUMBER:=NULL,u17 IN NUMBER:=NULL,lv17 IN BINARY_INTEGER:=NULL,
      l18 IN NUMBER:=NULL,u18 IN NUMBER:=NULL,lv18 IN BINARY_INTEGER:=NULL,
      l19 IN NUMBER:=NULL,u19 IN NUMBER:=NULL,lv19 IN BINARY_INTEGER:=NULL,
      l20 IN NUMBER:=NULL,u20 IN NUMBER:=NULL,lv20 IN BINARY_INTEGER:=NULL,
      l21 IN NUMBER:=NULL,u21 IN NUMBER:=NULL,lv21 IN BINARY_INTEGER:=NULL,
      l22 IN NUMBER:=NULL,u22 IN NUMBER:=NULL,lv22 IN BINARY_INTEGER:=NULL,
      l23 IN NUMBER:=NULL,u23 IN NUMBER:=NULL,lv23 IN BINARY_INTEGER:=NULL,
      l24 IN NUMBER:=NULL,u24 IN NUMBER:=NULL,lv24 IN BINARY_INTEGER:=NULL,
      l25 IN NUMBER:=NULL,u25 IN NUMBER:=NULL,lv25 IN BINARY_INTEGER:=NULL,
      l26 IN NUMBER:=NULL,u26 IN NUMBER:=NULL,lv26 IN BINARY_INTEGER:=NULL,
      l27 IN NUMBER:=NULL,u27 IN NUMBER:=NULL,lv27 IN BINARY_INTEGER:=NULL,
      l28 IN NUMBER:=NULL,u28 IN NUMBER:=NULL,lv28 IN BINARY_INTEGER:=NULL,
      l29 IN NUMBER:=NULL,u29 IN NUMBER:=NULL,lv29 IN BINARY_INTEGER:=NULL,
      l30 IN NUMBER:=NULL,u30 IN NUMBER:=NULL,lv30 IN BINARY_INTEGER:=NULL,
      l31 IN NUMBER:=NULL,u31 IN NUMBER:=NULL,lv31 IN BINARY_INTEGER:=NULL,
      l32 IN NUMBER:=NULL,u32 IN NUMBER:=NULL,lv32 IN BINARY_INTEGER:=NULL)
    RETURN NUMBER;
  PRAGMA RESTRICT_REFERENCES (hhcellsize, WNDS, WNPS);
  FUNCTION hhstbit (hhc IN RAW, topology IN BINARY_INTEGER, type IN VARCHAR2)
    RETURN RAW; 
  PRAGMA RESTRICT_REFERENCES (hhstbit, WNDS, WNPS);
  FUNCTION hhgtbit (hhc IN RAW, topology IN BINARY_INTEGER)
    RETURN VARCHAR2; 
  PRAGMA RESTRICT_REFERENCES (hhgtbit, WNDS, WNPS);
  FUNCTION hhstype (hhc IN RAW, type_id IN BINARY_INTEGER)
    RETURN RAW; 
  PRAGMA RESTRICT_REFERENCES (hhstype, WNDS, WNPS);
  FUNCTION hhgtype (hhc IN RAW)
    RETURN BINARY_INTEGER; 
  PRAGMA RESTRICT_REFERENCES (hhgtype, WNDS, WNPS);
  FUNCTION hhcbit (hhc IN RAW, bit_number IN BINARY_INTEGER)
    RETURN RAW; 
  PRAGMA RESTRICT_REFERENCES (hhcbit, WNDS, WNPS);
  FUNCTION hhsbit (hhc IN RAW, bit_number IN BINARY_INTEGER)
    RETURN RAW; 
  PRAGMA RESTRICT_REFERENCES (hhsbit, WNDS, WNPS);
  FUNCTION hhgbit (hhc IN RAW, bit_number IN BINARY_INTEGER)
    RETURN BINARY_INTEGER; 
  PRAGMA RESTRICT_REFERENCES (hhgbit, WNDS, WNPS);
  FUNCTION hhincrlev (hhc IN RAW, lv IN BINARY_INTEGER)
    RETURN RAW; 
  PRAGMA RESTRICT_REFERENCES (hhincrlev, WNDS, WNPS);
  FUNCTION hhgetcid ( hhc IN RAW, lv IN BINARY_INTEGER )
    RETURN NUMBER;
  PRAGMA RESTRICT_REFERENCES (hhgetcid, WNDS, WNPS);
  FUNCTION hhsetcid ( hhc IN RAW, lv IN BINARY_INTEGER, cid IN NUMBER )
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhsetcid, WNDS, WNPS);
  FUNCTION hhand ( hh1 IN RAW, hh2 IN RAW )
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhand, WNDS, WNPS);
  FUNCTION hhor ( hh1 IN RAW, hh2 IN RAW )
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhor, WNDS, WNPS);
  FUNCTION hhxor ( hh1 IN RAW, hh2 IN RAW )
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhxor, WNDS, WNPS);
  FUNCTION hhidpart (type IN VARCHAR2,hhc IN RAW,
           v001 IN NUMBER,       v002 IN NUMBER,
           v003 IN NUMBER:=NULL, v004 IN NUMBER:=NULL,
           v005 IN NUMBER:=NULL, v006 IN NUMBER:=NULL,
           v007 IN NUMBER:=NULL, v008 IN NUMBER:=NULL,
           v009 IN NUMBER:=NULL, v010 IN NUMBER:=NULL,
           v011 IN NUMBER:=NULL, v012 IN NUMBER:=NULL,
           v013 IN NUMBER:=NULL, v014 IN NUMBER:=NULL,
           v015 IN NUMBER:=NULL, v016 IN NUMBER:=NULL,
           v017 IN NUMBER:=NULL, v018 IN NUMBER:=NULL,
           v019 IN NUMBER:=NULL, v020 IN NUMBER:=NULL,
           v021 IN NUMBER:=NULL, v022 IN NUMBER:=NULL,
           v023 IN NUMBER:=NULL, v024 IN NUMBER:=NULL,
           v025 IN NUMBER:=NULL, v026 IN NUMBER:=NULL,
           v027 IN NUMBER:=NULL, v028 IN NUMBER:=NULL,
           v029 IN NUMBER:=NULL, v030 IN NUMBER:=NULL,
           v031 IN NUMBER:=NULL, v032 IN NUMBER:=NULL,
           v033 IN NUMBER:=NULL, v034 IN NUMBER:=NULL,
           v035 IN NUMBER:=NULL, v036 IN NUMBER:=NULL,
           v037 IN NUMBER:=NULL, v038 IN NUMBER:=NULL,
           v039 IN NUMBER:=NULL, v040 IN NUMBER:=NULL,
           v041 IN NUMBER:=NULL, v042 IN NUMBER:=NULL,
           v043 IN NUMBER:=NULL, v044 IN NUMBER:=NULL,
           v045 IN NUMBER:=NULL, v046 IN NUMBER:=NULL,
           v047 IN NUMBER:=NULL, v048 IN NUMBER:=NULL,
           v049 IN NUMBER:=NULL, v050 IN NUMBER:=NULL,
           v051 IN NUMBER:=NULL, v052 IN NUMBER:=NULL,
           v053 IN NUMBER:=NULL, v054 IN NUMBER:=NULL,
           v055 IN NUMBER:=NULL, v056 IN NUMBER:=NULL,
           v057 IN NUMBER:=NULL, v058 IN NUMBER:=NULL,
           v059 IN NUMBER:=NULL, v060 IN NUMBER:=NULL,
           v061 IN NUMBER:=NULL, v062 IN NUMBER:=NULL,
           v063 IN NUMBER:=NULL, v064 IN NUMBER:=NULL,
           v065 IN NUMBER:=NULL, v066 IN NUMBER:=NULL,
           v067 IN NUMBER:=NULL, v068 IN NUMBER:=NULL,
           v069 IN NUMBER:=NULL, v070 IN NUMBER:=NULL,
           v071 IN NUMBER:=NULL, v072 IN NUMBER:=NULL,
           v073 IN NUMBER:=NULL, v074 IN NUMBER:=NULL,
           v075 IN NUMBER:=NULL, v076 IN NUMBER:=NULL,
           v077 IN NUMBER:=NULL, v078 IN NUMBER:=NULL,
           v079 IN NUMBER:=NULL, v080 IN NUMBER:=NULL,
           v081 IN NUMBER:=NULL, v082 IN NUMBER:=NULL,
           v083 IN NUMBER:=NULL, v084 IN NUMBER:=NULL,
           v085 IN NUMBER:=NULL, v086 IN NUMBER:=NULL,
           v087 IN NUMBER:=NULL, v088 IN NUMBER:=NULL,
           v089 IN NUMBER:=NULL, v090 IN NUMBER:=NULL,
           v091 IN NUMBER:=NULL, v092 IN NUMBER:=NULL,
           v093 IN NUMBER:=NULL, v094 IN NUMBER:=NULL,
           v095 IN NUMBER:=NULL, v096 IN NUMBER:=NULL,
           v097 IN NUMBER:=NULL, v098 IN NUMBER:=NULL,
           v099 IN NUMBER:=NULL, v100 IN NUMBER:=NULL,
           v101 IN NUMBER:=NULL, v102 IN NUMBER:=NULL,
           v103 IN NUMBER:=NULL, v104 IN NUMBER:=NULL,
           v105 IN NUMBER:=NULL, v106 IN NUMBER:=NULL,
           v107 IN NUMBER:=NULL, v108 IN NUMBER:=NULL,
           v109 IN NUMBER:=NULL, v110 IN NUMBER:=NULL,
           v111 IN NUMBER:=NULL, v112 IN NUMBER:=NULL,
           v113 IN NUMBER:=NULL, v114 IN NUMBER:=NULL,
           v115 IN NUMBER:=NULL, v116 IN NUMBER:=NULL,
           v117 IN NUMBER:=NULL, v118 IN NUMBER:=NULL,
           v119 IN NUMBER:=NULL, v120 IN NUMBER:=NULL,
           v121 IN NUMBER:=NULL, v122 IN NUMBER:=NULL,
           v123 IN NUMBER:=NULL, v124 IN NUMBER:=NULL,
           v125 IN NUMBER:=NULL, v126 IN NUMBER:=NULL,
           v127 IN NUMBER:=NULL, v128 IN NUMBER:=NULL,
           v129 IN NUMBER:=NULL, v130 IN NUMBER:=NULL,
           v131 IN NUMBER:=NULL, v132 IN NUMBER:=NULL,
           v133 IN NUMBER:=NULL, v134 IN NUMBER:=NULL,
           v135 IN NUMBER:=NULL, v136 IN NUMBER:=NULL,
           v137 IN NUMBER:=NULL, v138 IN NUMBER:=NULL,
           v139 IN NUMBER:=NULL, v140 IN NUMBER:=NULL,
           v141 IN NUMBER:=NULL, v142 IN NUMBER:=NULL,
           v143 IN NUMBER:=NULL, v144 IN NUMBER:=NULL,
           v145 IN NUMBER:=NULL, v146 IN NUMBER:=NULL,
           v147 IN NUMBER:=NULL, v148 IN NUMBER:=NULL,
           v149 IN NUMBER:=NULL, v150 IN NUMBER:=NULL,
           v151 IN NUMBER:=NULL, v152 IN NUMBER:=NULL,
           v153 IN NUMBER:=NULL, v154 IN NUMBER:=NULL,
           v155 IN NUMBER:=NULL, v156 IN NUMBER:=NULL,
           v157 IN NUMBER:=NULL, v158 IN NUMBER:=NULL,
           v159 IN NUMBER:=NULL, v160 IN NUMBER:=NULL,
           v161 IN NUMBER:=NULL, v162 IN NUMBER:=NULL,
           v163 IN NUMBER:=NULL, v164 IN NUMBER:=NULL,
           v165 IN NUMBER:=NULL, v166 IN NUMBER:=NULL,
           v167 IN NUMBER:=NULL, v168 IN NUMBER:=NULL,
           v169 IN NUMBER:=NULL, v170 IN NUMBER:=NULL,
           v171 IN NUMBER:=NULL, v172 IN NUMBER:=NULL,
           v173 IN NUMBER:=NULL, v174 IN NUMBER:=NULL,
           v175 IN NUMBER:=NULL, v176 IN NUMBER:=NULL,
           v177 IN NUMBER:=NULL, v178 IN NUMBER:=NULL,
           v179 IN NUMBER:=NULL, v180 IN NUMBER:=NULL,
           v181 IN NUMBER:=NULL, v182 IN NUMBER:=NULL,
           v183 IN NUMBER:=NULL, v184 IN NUMBER:=NULL,
           v185 IN NUMBER:=NULL, v186 IN NUMBER:=NULL,
           v187 IN NUMBER:=NULL, v188 IN NUMBER:=NULL,
           v189 IN NUMBER:=NULL, v190 IN NUMBER:=NULL,
           v191 IN NUMBER:=NULL, v192 IN NUMBER:=NULL,
           v193 IN NUMBER:=NULL, v194 IN NUMBER:=NULL,
           v195 IN NUMBER:=NULL, v196 IN NUMBER:=NULL,
           v197 IN NUMBER:=NULL, v198 IN NUMBER:=NULL,
           v199 IN NUMBER:=NULL, v200 IN NUMBER:=NULL,
           v201 IN NUMBER:=NULL, v202 IN NUMBER:=NULL,
           v203 IN NUMBER:=NULL, v204 IN NUMBER:=NULL,
           v205 IN NUMBER:=NULL, v206 IN NUMBER:=NULL,
           v207 IN NUMBER:=NULL, v208 IN NUMBER:=NULL,
           v209 IN NUMBER:=NULL, v210 IN NUMBER:=NULL,
           v211 IN NUMBER:=NULL, v212 IN NUMBER:=NULL,
           v213 IN NUMBER:=NULL, v214 IN NUMBER:=NULL,
           v215 IN NUMBER:=NULL, v216 IN NUMBER:=NULL,
           v217 IN NUMBER:=NULL, v218 IN NUMBER:=NULL,
           v219 IN NUMBER:=NULL, v220 IN NUMBER:=NULL,
           v221 IN NUMBER:=NULL, v222 IN NUMBER:=NULL,
           v223 IN NUMBER:=NULL, v224 IN NUMBER:=NULL,
           v225 IN NUMBER:=NULL, v226 IN NUMBER:=NULL,
           v227 IN NUMBER:=NULL, v228 IN NUMBER:=NULL,
           v229 IN NUMBER:=NULL, v230 IN NUMBER:=NULL,
           v231 IN NUMBER:=NULL, v232 IN NUMBER:=NULL,
           v233 IN NUMBER:=NULL, v234 IN NUMBER:=NULL,
           v235 IN NUMBER:=NULL, v236 IN NUMBER:=NULL,
           v237 IN NUMBER:=NULL, v238 IN NUMBER:=NULL,
           v239 IN NUMBER:=NULL, v240 IN NUMBER:=NULL,
           v241 IN NUMBER:=NULL, v242 IN NUMBER:=NULL,
           v243 IN NUMBER:=NULL, v244 IN NUMBER:=NULL,
           v245 IN NUMBER:=NULL, v246 IN NUMBER:=NULL,
           v247 IN NUMBER:=NULL, v248 IN NUMBER:=NULL,
           v249 IN NUMBER:=NULL, v250 IN NUMBER:=NULL,
           v251 IN NUMBER:=NULL, v252 IN NUMBER:=NULL)
    RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES (hhidpart, WNDS, WNPS);
  FUNCTION hhidrows (type IN VARCHAR2,hhc IN RAW,
           v001 IN NUMBER,       v002 IN NUMBER,
           v003 IN NUMBER:=NULL, v004 IN NUMBER:=NULL,
           v005 IN NUMBER:=NULL, v006 IN NUMBER:=NULL,
           v007 IN NUMBER:=NULL, v008 IN NUMBER:=NULL,
           v009 IN NUMBER:=NULL, v010 IN NUMBER:=NULL,
           v011 IN NUMBER:=NULL, v012 IN NUMBER:=NULL,
           v013 IN NUMBER:=NULL, v014 IN NUMBER:=NULL,
           v015 IN NUMBER:=NULL, v016 IN NUMBER:=NULL,
           v017 IN NUMBER:=NULL, v018 IN NUMBER:=NULL,
           v019 IN NUMBER:=NULL, v020 IN NUMBER:=NULL,
           v021 IN NUMBER:=NULL, v022 IN NUMBER:=NULL,
           v023 IN NUMBER:=NULL, v024 IN NUMBER:=NULL,
           v025 IN NUMBER:=NULL, v026 IN NUMBER:=NULL,
           v027 IN NUMBER:=NULL, v028 IN NUMBER:=NULL,
           v029 IN NUMBER:=NULL, v030 IN NUMBER:=NULL,
           v031 IN NUMBER:=NULL, v032 IN NUMBER:=NULL,
           v033 IN NUMBER:=NULL, v034 IN NUMBER:=NULL,
           v035 IN NUMBER:=NULL, v036 IN NUMBER:=NULL,
           v037 IN NUMBER:=NULL, v038 IN NUMBER:=NULL,
           v039 IN NUMBER:=NULL, v040 IN NUMBER:=NULL,
           v041 IN NUMBER:=NULL, v042 IN NUMBER:=NULL,
           v043 IN NUMBER:=NULL, v044 IN NUMBER:=NULL,
           v045 IN NUMBER:=NULL, v046 IN NUMBER:=NULL,
           v047 IN NUMBER:=NULL, v048 IN NUMBER:=NULL,
           v049 IN NUMBER:=NULL, v050 IN NUMBER:=NULL,
           v051 IN NUMBER:=NULL, v052 IN NUMBER:=NULL,
           v053 IN NUMBER:=NULL, v054 IN NUMBER:=NULL,
           v055 IN NUMBER:=NULL, v056 IN NUMBER:=NULL,
           v057 IN NUMBER:=NULL, v058 IN NUMBER:=NULL,
           v059 IN NUMBER:=NULL, v060 IN NUMBER:=NULL,
           v061 IN NUMBER:=NULL, v062 IN NUMBER:=NULL,
           v063 IN NUMBER:=NULL, v064 IN NUMBER:=NULL,
           v065 IN NUMBER:=NULL, v066 IN NUMBER:=NULL,
           v067 IN NUMBER:=NULL, v068 IN NUMBER:=NULL,
           v069 IN NUMBER:=NULL, v070 IN NUMBER:=NULL,
           v071 IN NUMBER:=NULL, v072 IN NUMBER:=NULL,
           v073 IN NUMBER:=NULL, v074 IN NUMBER:=NULL,
           v075 IN NUMBER:=NULL, v076 IN NUMBER:=NULL,
           v077 IN NUMBER:=NULL, v078 IN NUMBER:=NULL,
           v079 IN NUMBER:=NULL, v080 IN NUMBER:=NULL,
           v081 IN NUMBER:=NULL, v082 IN NUMBER:=NULL,
           v083 IN NUMBER:=NULL, v084 IN NUMBER:=NULL,
           v085 IN NUMBER:=NULL, v086 IN NUMBER:=NULL,
           v087 IN NUMBER:=NULL, v088 IN NUMBER:=NULL,
           v089 IN NUMBER:=NULL, v090 IN NUMBER:=NULL,
           v091 IN NUMBER:=NULL, v092 IN NUMBER:=NULL,
           v093 IN NUMBER:=NULL, v094 IN NUMBER:=NULL,
           v095 IN NUMBER:=NULL, v096 IN NUMBER:=NULL,
           v097 IN NUMBER:=NULL, v098 IN NUMBER:=NULL,
           v099 IN NUMBER:=NULL, v100 IN NUMBER:=NULL,
           v101 IN NUMBER:=NULL, v102 IN NUMBER:=NULL,
           v103 IN NUMBER:=NULL, v104 IN NUMBER:=NULL,
           v105 IN NUMBER:=NULL, v106 IN NUMBER:=NULL,
           v107 IN NUMBER:=NULL, v108 IN NUMBER:=NULL,
           v109 IN NUMBER:=NULL, v110 IN NUMBER:=NULL,
           v111 IN NUMBER:=NULL, v112 IN NUMBER:=NULL,
           v113 IN NUMBER:=NULL, v114 IN NUMBER:=NULL,
           v115 IN NUMBER:=NULL, v116 IN NUMBER:=NULL,
           v117 IN NUMBER:=NULL, v118 IN NUMBER:=NULL,
           v119 IN NUMBER:=NULL, v120 IN NUMBER:=NULL,
           v121 IN NUMBER:=NULL, v122 IN NUMBER:=NULL,
           v123 IN NUMBER:=NULL, v124 IN NUMBER:=NULL,
           v125 IN NUMBER:=NULL, v126 IN NUMBER:=NULL,
           v127 IN NUMBER:=NULL, v128 IN NUMBER:=NULL,
           v129 IN NUMBER:=NULL, v130 IN NUMBER:=NULL,
           v131 IN NUMBER:=NULL, v132 IN NUMBER:=NULL,
           v133 IN NUMBER:=NULL, v134 IN NUMBER:=NULL,
           v135 IN NUMBER:=NULL, v136 IN NUMBER:=NULL,
           v137 IN NUMBER:=NULL, v138 IN NUMBER:=NULL,
           v139 IN NUMBER:=NULL, v140 IN NUMBER:=NULL,
           v141 IN NUMBER:=NULL, v142 IN NUMBER:=NULL,
           v143 IN NUMBER:=NULL, v144 IN NUMBER:=NULL,
           v145 IN NUMBER:=NULL, v146 IN NUMBER:=NULL,
           v147 IN NUMBER:=NULL, v148 IN NUMBER:=NULL,
           v149 IN NUMBER:=NULL, v150 IN NUMBER:=NULL,
           v151 IN NUMBER:=NULL, v152 IN NUMBER:=NULL,
           v153 IN NUMBER:=NULL, v154 IN NUMBER:=NULL,
           v155 IN NUMBER:=NULL, v156 IN NUMBER:=NULL,
           v157 IN NUMBER:=NULL, v158 IN NUMBER:=NULL,
           v159 IN NUMBER:=NULL, v160 IN NUMBER:=NULL,
           v161 IN NUMBER:=NULL, v162 IN NUMBER:=NULL,
           v163 IN NUMBER:=NULL, v164 IN NUMBER:=NULL,
           v165 IN NUMBER:=NULL, v166 IN NUMBER:=NULL,
           v167 IN NUMBER:=NULL, v168 IN NUMBER:=NULL,
           v169 IN NUMBER:=NULL, v170 IN NUMBER:=NULL,
           v171 IN NUMBER:=NULL, v172 IN NUMBER:=NULL,
           v173 IN NUMBER:=NULL, v174 IN NUMBER:=NULL,
           v175 IN NUMBER:=NULL, v176 IN NUMBER:=NULL,
           v177 IN NUMBER:=NULL, v178 IN NUMBER:=NULL,
           v179 IN NUMBER:=NULL, v180 IN NUMBER:=NULL,
           v181 IN NUMBER:=NULL, v182 IN NUMBER:=NULL,
           v183 IN NUMBER:=NULL, v184 IN NUMBER:=NULL,
           v185 IN NUMBER:=NULL, v186 IN NUMBER:=NULL,
           v187 IN NUMBER:=NULL, v188 IN NUMBER:=NULL,
           v189 IN NUMBER:=NULL, v190 IN NUMBER:=NULL,
           v191 IN NUMBER:=NULL, v192 IN NUMBER:=NULL,
           v193 IN NUMBER:=NULL, v194 IN NUMBER:=NULL,
           v195 IN NUMBER:=NULL, v196 IN NUMBER:=NULL,
           v197 IN NUMBER:=NULL, v198 IN NUMBER:=NULL,
           v199 IN NUMBER:=NULL, v200 IN NUMBER:=NULL,
           v201 IN NUMBER:=NULL, v202 IN NUMBER:=NULL,
           v203 IN NUMBER:=NULL, v204 IN NUMBER:=NULL,
           v205 IN NUMBER:=NULL, v206 IN NUMBER:=NULL,
           v207 IN NUMBER:=NULL, v208 IN NUMBER:=NULL,
           v209 IN NUMBER:=NULL, v210 IN NUMBER:=NULL,
           v211 IN NUMBER:=NULL, v212 IN NUMBER:=NULL,
           v213 IN NUMBER:=NULL, v214 IN NUMBER:=NULL,
           v215 IN NUMBER:=NULL, v216 IN NUMBER:=NULL,
           v217 IN NUMBER:=NULL, v218 IN NUMBER:=NULL,
           v219 IN NUMBER:=NULL, v220 IN NUMBER:=NULL,
           v221 IN NUMBER:=NULL, v222 IN NUMBER:=NULL,
           v223 IN NUMBER:=NULL, v224 IN NUMBER:=NULL,
           v225 IN NUMBER:=NULL, v226 IN NUMBER:=NULL,
           v227 IN NUMBER:=NULL, v228 IN NUMBER:=NULL,
           v229 IN NUMBER:=NULL, v230 IN NUMBER:=NULL,
           v231 IN NUMBER:=NULL, v232 IN NUMBER:=NULL,
           v233 IN NUMBER:=NULL, v234 IN NUMBER:=NULL,
           v235 IN NUMBER:=NULL, v236 IN NUMBER:=NULL,
           v237 IN NUMBER:=NULL, v238 IN NUMBER:=NULL,
           v239 IN NUMBER:=NULL, v240 IN NUMBER:=NULL,
           v241 IN NUMBER:=NULL, v242 IN NUMBER:=NULL,
           v243 IN NUMBER:=NULL, v244 IN NUMBER:=NULL,
           v245 IN NUMBER:=NULL, v246 IN NUMBER:=NULL,
           v247 IN NUMBER:=NULL, v248 IN NUMBER:=NULL,
           v249 IN NUMBER:=NULL, v250 IN NUMBER:=NULL,
           v251 IN NUMBER:=NULL, v252 IN NUMBER:=NULL)
    RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES (hhidrows, WNDS, WNPS);
  FUNCTION hhbits ( hhc IN RAW )
    RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES (hhbits, WNDS, WNPS);
  FUNCTION hhidlrows (type IN VARCHAR2,hhc IN RAW,
           v001 IN NUMBER,       v002 IN NUMBER,
           v003 IN NUMBER:=NULL, v004 IN NUMBER:=NULL,
           v005 IN NUMBER:=NULL, v006 IN NUMBER:=NULL,
           v007 IN NUMBER:=NULL, v008 IN NUMBER:=NULL,
           v009 IN NUMBER:=NULL, v010 IN NUMBER:=NULL,
           v011 IN NUMBER:=NULL, v012 IN NUMBER:=NULL,
           v013 IN NUMBER:=NULL, v014 IN NUMBER:=NULL,
           v015 IN NUMBER:=NULL, v016 IN NUMBER:=NULL,
           v017 IN NUMBER:=NULL, v018 IN NUMBER:=NULL,
           v019 IN NUMBER:=NULL, v020 IN NUMBER:=NULL,
           v021 IN NUMBER:=NULL, v022 IN NUMBER:=NULL,
           v023 IN NUMBER:=NULL, v024 IN NUMBER:=NULL,
           v025 IN NUMBER:=NULL, v026 IN NUMBER:=NULL,
           v027 IN NUMBER:=NULL, v028 IN NUMBER:=NULL,
           v029 IN NUMBER:=NULL, v030 IN NUMBER:=NULL,
           v031 IN NUMBER:=NULL, v032 IN NUMBER:=NULL,
           v033 IN NUMBER:=NULL, v034 IN NUMBER:=NULL,
           v035 IN NUMBER:=NULL, v036 IN NUMBER:=NULL,
           v037 IN NUMBER:=NULL, v038 IN NUMBER:=NULL,
           v039 IN NUMBER:=NULL, v040 IN NUMBER:=NULL,
           v041 IN NUMBER:=NULL, v042 IN NUMBER:=NULL,
           v043 IN NUMBER:=NULL, v044 IN NUMBER:=NULL,
           v045 IN NUMBER:=NULL, v046 IN NUMBER:=NULL,
           v047 IN NUMBER:=NULL, v048 IN NUMBER:=NULL,
           v049 IN NUMBER:=NULL, v050 IN NUMBER:=NULL,
           v051 IN NUMBER:=NULL, v052 IN NUMBER:=NULL,
           v053 IN NUMBER:=NULL, v054 IN NUMBER:=NULL,
           v055 IN NUMBER:=NULL, v056 IN NUMBER:=NULL,
           v057 IN NUMBER:=NULL, v058 IN NUMBER:=NULL,
           v059 IN NUMBER:=NULL, v060 IN NUMBER:=NULL,
           v061 IN NUMBER:=NULL, v062 IN NUMBER:=NULL,
           v063 IN NUMBER:=NULL, v064 IN NUMBER:=NULL,
           v065 IN NUMBER:=NULL, v066 IN NUMBER:=NULL,
           v067 IN NUMBER:=NULL, v068 IN NUMBER:=NULL,
           v069 IN NUMBER:=NULL, v070 IN NUMBER:=NULL,
           v071 IN NUMBER:=NULL, v072 IN NUMBER:=NULL,
           v073 IN NUMBER:=NULL, v074 IN NUMBER:=NULL,
           v075 IN NUMBER:=NULL, v076 IN NUMBER:=NULL,
           v077 IN NUMBER:=NULL, v078 IN NUMBER:=NULL,
           v079 IN NUMBER:=NULL, v080 IN NUMBER:=NULL,
           v081 IN NUMBER:=NULL, v082 IN NUMBER:=NULL,
           v083 IN NUMBER:=NULL, v084 IN NUMBER:=NULL,
           v085 IN NUMBER:=NULL, v086 IN NUMBER:=NULL,
           v087 IN NUMBER:=NULL, v088 IN NUMBER:=NULL,
           v089 IN NUMBER:=NULL, v090 IN NUMBER:=NULL,
           v091 IN NUMBER:=NULL, v092 IN NUMBER:=NULL,
           v093 IN NUMBER:=NULL, v094 IN NUMBER:=NULL,
           v095 IN NUMBER:=NULL, v096 IN NUMBER:=NULL,
           v097 IN NUMBER:=NULL, v098 IN NUMBER:=NULL,
           v099 IN NUMBER:=NULL, v100 IN NUMBER:=NULL,
           v101 IN NUMBER:=NULL, v102 IN NUMBER:=NULL,
           v103 IN NUMBER:=NULL, v104 IN NUMBER:=NULL,
           v105 IN NUMBER:=NULL, v106 IN NUMBER:=NULL,
           v107 IN NUMBER:=NULL, v108 IN NUMBER:=NULL,
           v109 IN NUMBER:=NULL, v110 IN NUMBER:=NULL,
           v111 IN NUMBER:=NULL, v112 IN NUMBER:=NULL,
           v113 IN NUMBER:=NULL, v114 IN NUMBER:=NULL,
           v115 IN NUMBER:=NULL, v116 IN NUMBER:=NULL,
           v117 IN NUMBER:=NULL, v118 IN NUMBER:=NULL,
           v119 IN NUMBER:=NULL, v120 IN NUMBER:=NULL,
           v121 IN NUMBER:=NULL, v122 IN NUMBER:=NULL,
           v123 IN NUMBER:=NULL, v124 IN NUMBER:=NULL,
           v125 IN NUMBER:=NULL, v126 IN NUMBER:=NULL,
           v127 IN NUMBER:=NULL, v128 IN NUMBER:=NULL,
           v129 IN NUMBER:=NULL, v130 IN NUMBER:=NULL,
           v131 IN NUMBER:=NULL, v132 IN NUMBER:=NULL,
           v133 IN NUMBER:=NULL, v134 IN NUMBER:=NULL,
           v135 IN NUMBER:=NULL, v136 IN NUMBER:=NULL,
           v137 IN NUMBER:=NULL, v138 IN NUMBER:=NULL,
           v139 IN NUMBER:=NULL, v140 IN NUMBER:=NULL,
           v141 IN NUMBER:=NULL, v142 IN NUMBER:=NULL,
           v143 IN NUMBER:=NULL, v144 IN NUMBER:=NULL,
           v145 IN NUMBER:=NULL, v146 IN NUMBER:=NULL,
           v147 IN NUMBER:=NULL, v148 IN NUMBER:=NULL,
           v149 IN NUMBER:=NULL, v150 IN NUMBER:=NULL,
           v151 IN NUMBER:=NULL, v152 IN NUMBER:=NULL,
           v153 IN NUMBER:=NULL, v154 IN NUMBER:=NULL,
           v155 IN NUMBER:=NULL, v156 IN NUMBER:=NULL,
           v157 IN NUMBER:=NULL, v158 IN NUMBER:=NULL,
           v159 IN NUMBER:=NULL, v160 IN NUMBER:=NULL,
           v161 IN NUMBER:=NULL, v162 IN NUMBER:=NULL,
           v163 IN NUMBER:=NULL, v164 IN NUMBER:=NULL,
           v165 IN NUMBER:=NULL, v166 IN NUMBER:=NULL,
           v167 IN NUMBER:=NULL, v168 IN NUMBER:=NULL,
           v169 IN NUMBER:=NULL, v170 IN NUMBER:=NULL,
           v171 IN NUMBER:=NULL, v172 IN NUMBER:=NULL,
           v173 IN NUMBER:=NULL, v174 IN NUMBER:=NULL,
           v175 IN NUMBER:=NULL, v176 IN NUMBER:=NULL,
           v177 IN NUMBER:=NULL, v178 IN NUMBER:=NULL,
           v179 IN NUMBER:=NULL, v180 IN NUMBER:=NULL,
           v181 IN NUMBER:=NULL, v182 IN NUMBER:=NULL,
           v183 IN NUMBER:=NULL, v184 IN NUMBER:=NULL,
           v185 IN NUMBER:=NULL, v186 IN NUMBER:=NULL,
           v187 IN NUMBER:=NULL, v188 IN NUMBER:=NULL,
           v189 IN NUMBER:=NULL, v190 IN NUMBER:=NULL,
           v191 IN NUMBER:=NULL, v192 IN NUMBER:=NULL,
           v193 IN NUMBER:=NULL, v194 IN NUMBER:=NULL,
           v195 IN NUMBER:=NULL, v196 IN NUMBER:=NULL,
           v197 IN NUMBER:=NULL, v198 IN NUMBER:=NULL,
           v199 IN NUMBER:=NULL, v200 IN NUMBER:=NULL,
           v201 IN NUMBER:=NULL, v202 IN NUMBER:=NULL,
           v203 IN NUMBER:=NULL, v204 IN NUMBER:=NULL,
           v205 IN NUMBER:=NULL, v206 IN NUMBER:=NULL,
           v207 IN NUMBER:=NULL, v208 IN NUMBER:=NULL,
           v209 IN NUMBER:=NULL, v210 IN NUMBER:=NULL,
           v211 IN NUMBER:=NULL, v212 IN NUMBER:=NULL,
           v213 IN NUMBER:=NULL, v214 IN NUMBER:=NULL,
           v215 IN NUMBER:=NULL, v216 IN NUMBER:=NULL,
           v217 IN NUMBER:=NULL, v218 IN NUMBER:=NULL,
           v219 IN NUMBER:=NULL, v220 IN NUMBER:=NULL,
           v221 IN NUMBER:=NULL, v222 IN NUMBER:=NULL,
           v223 IN NUMBER:=NULL, v224 IN NUMBER:=NULL,
           v225 IN NUMBER:=NULL, v226 IN NUMBER:=NULL,
           v227 IN NUMBER:=NULL, v228 IN NUMBER:=NULL,
           v229 IN NUMBER:=NULL, v230 IN NUMBER:=NULL,
           v231 IN NUMBER:=NULL, v232 IN NUMBER:=NULL,
           v233 IN NUMBER:=NULL, v234 IN NUMBER:=NULL,
           v235 IN NUMBER:=NULL, v236 IN NUMBER:=NULL,
           v237 IN NUMBER:=NULL, v238 IN NUMBER:=NULL,
           v239 IN NUMBER:=NULL, v240 IN NUMBER:=NULL,
           v241 IN NUMBER:=NULL, v242 IN NUMBER:=NULL,
           v243 IN NUMBER:=NULL, v244 IN NUMBER:=NULL,
           v245 IN NUMBER:=NULL, v246 IN NUMBER:=NULL,
           v247 IN NUMBER:=NULL, v248 IN NUMBER:=NULL,
           v249 IN NUMBER:=NULL, v250 IN NUMBER:=NULL,
           v251 IN NUMBER:=NULL, v252 IN NUMBER:=NULL)
    RETURN VARCHAR2; 
  PRAGMA RESTRICT_REFERENCES (hhidlrows, WNDS, WNPS);
  FUNCTION hhidlpart (type IN VARCHAR2, hhc IN RAW,
           v001 IN NUMBER,       v002 IN NUMBER,
           v003 IN NUMBER:=NULL, v004 IN NUMBER:=NULL,
           v005 IN NUMBER:=NULL, v006 IN NUMBER:=NULL,
           v007 IN NUMBER:=NULL, v008 IN NUMBER:=NULL,
           v009 IN NUMBER:=NULL, v010 IN NUMBER:=NULL,
           v011 IN NUMBER:=NULL, v012 IN NUMBER:=NULL,
           v013 IN NUMBER:=NULL, v014 IN NUMBER:=NULL,
           v015 IN NUMBER:=NULL, v016 IN NUMBER:=NULL,
           v017 IN NUMBER:=NULL, v018 IN NUMBER:=NULL,
           v019 IN NUMBER:=NULL, v020 IN NUMBER:=NULL,
           v021 IN NUMBER:=NULL, v022 IN NUMBER:=NULL,
           v023 IN NUMBER:=NULL, v024 IN NUMBER:=NULL,
           v025 IN NUMBER:=NULL, v026 IN NUMBER:=NULL,
           v027 IN NUMBER:=NULL, v028 IN NUMBER:=NULL,
           v029 IN NUMBER:=NULL, v030 IN NUMBER:=NULL,
           v031 IN NUMBER:=NULL, v032 IN NUMBER:=NULL,
           v033 IN NUMBER:=NULL, v034 IN NUMBER:=NULL,
           v035 IN NUMBER:=NULL, v036 IN NUMBER:=NULL,
           v037 IN NUMBER:=NULL, v038 IN NUMBER:=NULL,
           v039 IN NUMBER:=NULL, v040 IN NUMBER:=NULL,
           v041 IN NUMBER:=NULL, v042 IN NUMBER:=NULL,
           v043 IN NUMBER:=NULL, v044 IN NUMBER:=NULL,
           v045 IN NUMBER:=NULL, v046 IN NUMBER:=NULL,
           v047 IN NUMBER:=NULL, v048 IN NUMBER:=NULL,
           v049 IN NUMBER:=NULL, v050 IN NUMBER:=NULL,
           v051 IN NUMBER:=NULL, v052 IN NUMBER:=NULL,
           v053 IN NUMBER:=NULL, v054 IN NUMBER:=NULL,
           v055 IN NUMBER:=NULL, v056 IN NUMBER:=NULL,
           v057 IN NUMBER:=NULL, v058 IN NUMBER:=NULL,
           v059 IN NUMBER:=NULL, v060 IN NUMBER:=NULL,
           v061 IN NUMBER:=NULL, v062 IN NUMBER:=NULL,
           v063 IN NUMBER:=NULL, v064 IN NUMBER:=NULL,
           v065 IN NUMBER:=NULL, v066 IN NUMBER:=NULL,
           v067 IN NUMBER:=NULL, v068 IN NUMBER:=NULL,
           v069 IN NUMBER:=NULL, v070 IN NUMBER:=NULL,
           v071 IN NUMBER:=NULL, v072 IN NUMBER:=NULL,
           v073 IN NUMBER:=NULL, v074 IN NUMBER:=NULL,
           v075 IN NUMBER:=NULL, v076 IN NUMBER:=NULL,
           v077 IN NUMBER:=NULL, v078 IN NUMBER:=NULL,
           v079 IN NUMBER:=NULL, v080 IN NUMBER:=NULL,
           v081 IN NUMBER:=NULL, v082 IN NUMBER:=NULL,
           v083 IN NUMBER:=NULL, v084 IN NUMBER:=NULL,
           v085 IN NUMBER:=NULL, v086 IN NUMBER:=NULL,
           v087 IN NUMBER:=NULL, v088 IN NUMBER:=NULL,
           v089 IN NUMBER:=NULL, v090 IN NUMBER:=NULL,
           v091 IN NUMBER:=NULL, v092 IN NUMBER:=NULL,
           v093 IN NUMBER:=NULL, v094 IN NUMBER:=NULL,
           v095 IN NUMBER:=NULL, v096 IN NUMBER:=NULL,
           v097 IN NUMBER:=NULL, v098 IN NUMBER:=NULL,
           v099 IN NUMBER:=NULL, v100 IN NUMBER:=NULL,
           v101 IN NUMBER:=NULL, v102 IN NUMBER:=NULL,
           v103 IN NUMBER:=NULL, v104 IN NUMBER:=NULL,
           v105 IN NUMBER:=NULL, v106 IN NUMBER:=NULL,
           v107 IN NUMBER:=NULL, v108 IN NUMBER:=NULL,
           v109 IN NUMBER:=NULL, v110 IN NUMBER:=NULL,
           v111 IN NUMBER:=NULL, v112 IN NUMBER:=NULL,
           v113 IN NUMBER:=NULL, v114 IN NUMBER:=NULL,
           v115 IN NUMBER:=NULL, v116 IN NUMBER:=NULL,
           v117 IN NUMBER:=NULL, v118 IN NUMBER:=NULL,
           v119 IN NUMBER:=NULL, v120 IN NUMBER:=NULL,
           v121 IN NUMBER:=NULL, v122 IN NUMBER:=NULL,
           v123 IN NUMBER:=NULL, v124 IN NUMBER:=NULL,
           v125 IN NUMBER:=NULL, v126 IN NUMBER:=NULL,
           v127 IN NUMBER:=NULL, v128 IN NUMBER:=NULL,
           v129 IN NUMBER:=NULL, v130 IN NUMBER:=NULL,
           v131 IN NUMBER:=NULL, v132 IN NUMBER:=NULL,
           v133 IN NUMBER:=NULL, v134 IN NUMBER:=NULL,
           v135 IN NUMBER:=NULL, v136 IN NUMBER:=NULL,
           v137 IN NUMBER:=NULL, v138 IN NUMBER:=NULL,
           v139 IN NUMBER:=NULL, v140 IN NUMBER:=NULL,
           v141 IN NUMBER:=NULL, v142 IN NUMBER:=NULL,
           v143 IN NUMBER:=NULL, v144 IN NUMBER:=NULL,
           v145 IN NUMBER:=NULL, v146 IN NUMBER:=NULL,
           v147 IN NUMBER:=NULL, v148 IN NUMBER:=NULL,
           v149 IN NUMBER:=NULL, v150 IN NUMBER:=NULL,
           v151 IN NUMBER:=NULL, v152 IN NUMBER:=NULL,
           v153 IN NUMBER:=NULL, v154 IN NUMBER:=NULL,
           v155 IN NUMBER:=NULL, v156 IN NUMBER:=NULL,
           v157 IN NUMBER:=NULL, v158 IN NUMBER:=NULL,
           v159 IN NUMBER:=NULL, v160 IN NUMBER:=NULL,
           v161 IN NUMBER:=NULL, v162 IN NUMBER:=NULL,
           v163 IN NUMBER:=NULL, v164 IN NUMBER:=NULL,
           v165 IN NUMBER:=NULL, v166 IN NUMBER:=NULL,
           v167 IN NUMBER:=NULL, v168 IN NUMBER:=NULL,
           v169 IN NUMBER:=NULL, v170 IN NUMBER:=NULL,
           v171 IN NUMBER:=NULL, v172 IN NUMBER:=NULL,
           v173 IN NUMBER:=NULL, v174 IN NUMBER:=NULL,
           v175 IN NUMBER:=NULL, v176 IN NUMBER:=NULL,
           v177 IN NUMBER:=NULL, v178 IN NUMBER:=NULL,
           v179 IN NUMBER:=NULL, v180 IN NUMBER:=NULL,
           v181 IN NUMBER:=NULL, v182 IN NUMBER:=NULL,
           v183 IN NUMBER:=NULL, v184 IN NUMBER:=NULL,
           v185 IN NUMBER:=NULL, v186 IN NUMBER:=NULL,
           v187 IN NUMBER:=NULL, v188 IN NUMBER:=NULL,
           v189 IN NUMBER:=NULL, v190 IN NUMBER:=NULL,
           v191 IN NUMBER:=NULL, v192 IN NUMBER:=NULL,
           v193 IN NUMBER:=NULL, v194 IN NUMBER:=NULL,
           v195 IN NUMBER:=NULL, v196 IN NUMBER:=NULL,
           v197 IN NUMBER:=NULL, v198 IN NUMBER:=NULL,
           v199 IN NUMBER:=NULL, v200 IN NUMBER:=NULL,
           v201 IN NUMBER:=NULL, v202 IN NUMBER:=NULL,
           v203 IN NUMBER:=NULL, v204 IN NUMBER:=NULL,
           v205 IN NUMBER:=NULL, v206 IN NUMBER:=NULL,
           v207 IN NUMBER:=NULL, v208 IN NUMBER:=NULL,
           v209 IN NUMBER:=NULL, v210 IN NUMBER:=NULL,
           v211 IN NUMBER:=NULL, v212 IN NUMBER:=NULL,
           v213 IN NUMBER:=NULL, v214 IN NUMBER:=NULL,
           v215 IN NUMBER:=NULL, v216 IN NUMBER:=NULL,
           v217 IN NUMBER:=NULL, v218 IN NUMBER:=NULL,
           v219 IN NUMBER:=NULL, v220 IN NUMBER:=NULL,
           v221 IN NUMBER:=NULL, v222 IN NUMBER:=NULL,
           v223 IN NUMBER:=NULL, v224 IN NUMBER:=NULL,
           v225 IN NUMBER:=NULL, v226 IN NUMBER:=NULL,
           v227 IN NUMBER:=NULL, v228 IN NUMBER:=NULL,
           v229 IN NUMBER:=NULL, v230 IN NUMBER:=NULL,
           v231 IN NUMBER:=NULL, v232 IN NUMBER:=NULL,
           v233 IN NUMBER:=NULL, v234 IN NUMBER:=NULL,
           v235 IN NUMBER:=NULL, v236 IN NUMBER:=NULL,
           v237 IN NUMBER:=NULL, v238 IN NUMBER:=NULL,
           v239 IN NUMBER:=NULL, v240 IN NUMBER:=NULL,
           v241 IN NUMBER:=NULL, v242 IN NUMBER:=NULL,
           v243 IN NUMBER:=NULL, v244 IN NUMBER:=NULL,
           v245 IN NUMBER:=NULL, v246 IN NUMBER:=NULL,
           v247 IN NUMBER:=NULL, v248 IN NUMBER:=NULL,
           v249 IN NUMBER:=NULL, v250 IN NUMBER:=NULL,
           v251 IN NUMBER:=NULL, v252 IN NUMBER:=NULL)
    RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES (hhidlpart, WNDS, WNPS);

  FUNCTION hhmkdim (
       v01 IN BINARY_INTEGER,       p01 IN BINARY_INTEGER,
       v02 IN BINARY_INTEGER:=NULL, p02 IN BINARY_INTEGER:=NULL,
       v03 IN BINARY_INTEGER:=NULL, p03 IN BINARY_INTEGER:=NULL,
       v04 IN BINARY_INTEGER:=NULL, p04 IN BINARY_INTEGER:=NULL,
       v05 IN BINARY_INTEGER:=NULL, p05 IN BINARY_INTEGER:=NULL,
       v06 IN BINARY_INTEGER:=NULL, p06 IN BINARY_INTEGER:=NULL,
       v07 IN BINARY_INTEGER:=NULL, p07 IN BINARY_INTEGER:=NULL,
       v08 IN BINARY_INTEGER:=NULL, p08 IN BINARY_INTEGER:=NULL,
       v09 IN BINARY_INTEGER:=NULL, p09 IN BINARY_INTEGER:=NULL,
       v10 IN BINARY_INTEGER:=NULL, p10 IN BINARY_INTEGER:=NULL,
       v11 IN BINARY_INTEGER:=NULL, p11 IN BINARY_INTEGER:=NULL,
       v12 IN BINARY_INTEGER:=NULL, p12 IN BINARY_INTEGER:=NULL,
       v13 IN BINARY_INTEGER:=NULL, p13 IN BINARY_INTEGER:=NULL,
       v14 IN BINARY_INTEGER:=NULL, p14 IN BINARY_INTEGER:=NULL,
       v15 IN BINARY_INTEGER:=NULL, p15 IN BINARY_INTEGER:=NULL,
       v16 IN BINARY_INTEGER:=NULL, p16 IN BINARY_INTEGER:=NULL,
       v17 IN BINARY_INTEGER:=NULL, p17 IN BINARY_INTEGER:=NULL,
       v18 IN BINARY_INTEGER:=NULL, p18 IN BINARY_INTEGER:=NULL,
       v19 IN BINARY_INTEGER:=NULL, p19 IN BINARY_INTEGER:=NULL,
       v20 IN BINARY_INTEGER:=NULL, p20 IN BINARY_INTEGER:=NULL,
       v21 IN BINARY_INTEGER:=NULL, p21 IN BINARY_INTEGER:=NULL,
       v22 IN BINARY_INTEGER:=NULL, p22 IN BINARY_INTEGER:=NULL,
       v23 IN BINARY_INTEGER:=NULL, p23 IN BINARY_INTEGER:=NULL,
       v24 IN BINARY_INTEGER:=NULL, p24 IN BINARY_INTEGER:=NULL,
       v25 IN BINARY_INTEGER:=NULL, p25 IN BINARY_INTEGER:=NULL,
       v26 IN BINARY_INTEGER:=NULL, p26 IN BINARY_INTEGER:=NULL,
       v27 IN BINARY_INTEGER:=NULL, p27 IN BINARY_INTEGER:=NULL,
       v28 IN BINARY_INTEGER:=NULL, p28 IN BINARY_INTEGER:=NULL,
       v29 IN BINARY_INTEGER:=NULL, p29 IN BINARY_INTEGER:=NULL,
       v30 IN BINARY_INTEGER:=NULL, p30 IN BINARY_INTEGER:=NULL,
       v31 IN BINARY_INTEGER:=NULL, p31 IN BINARY_INTEGER:=NULL,
       v32 IN BINARY_INTEGER:=NULL, p32 IN BINARY_INTEGER:=NULL)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhmkdim, WNDS, WNPS);

-- This function is very similar to hhencode, except it takes level instead of precision
  FUNCTION hhencode_bylevel (
     v01 IN NUMBER, l01 IN NUMBER, u01 IN NUMBER, p01 IN INTEGER,
     v02 IN NUMBER:=NULL, l02 IN NUMBER:=NULL, u02 IN NUMBER:=NULL, p02 IN INTEGER:=NULL,
     v03 IN NUMBER:=NULL, l03 IN NUMBER:=NULL, u03 IN NUMBER:=NULL, p03 IN INTEGER:=NULL,
     v04 IN NUMBER:=NULL, l04 IN NUMBER:=NULL, u04 IN NUMBER:=NULL, p04 IN INTEGER:=NULL)
  RETURN RAW PARALLEL_ENABLE DETERMINISTIC;
  PRAGMA RESTRICT_REFERENCES (hhencode_bylevel, WNDS, WNPS);

  FUNCTION hhmkcode (
       v01 IN RAW,       v02 IN RAW:=NULL,
       v03 IN RAW:=NULL, v04 IN RAW:=NULL,
       v05 IN RAW:=NULL, v06 IN RAW:=NULL,
       v07 IN RAW:=NULL, v08 IN RAW:=NULL,
       v09 IN RAW:=NULL, v10 IN RAW:=NULL,
       v11 IN RAW:=NULL, v12 IN RAW:=NULL,
       v13 IN RAW:=NULL, v14 IN RAW:=NULL,
       v15 IN RAW:=NULL, v16 IN RAW:=NULL,
       v17 IN RAW:=NULL, v18 IN RAW:=NULL,
       v19 IN RAW:=NULL, v20 IN RAW:=NULL,
       v21 IN RAW:=NULL, v22 IN RAW:=NULL,
       v23 IN RAW:=NULL, v24 IN RAW:=NULL,
       v25 IN RAW:=NULL, v26 IN RAW:=NULL,
       v27 IN RAW:=NULL, v28 IN RAW:=NULL,
       v29 IN RAW:=NULL, v30 IN RAW:=NULL,
       v31 IN RAW:=NULL, v32 IN RAW:=NULL)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhmkcode, WNDS, WNPS);
  FUNCTION hhckref ( hhc1 IN RAW, hhc2 IN RAW )
    RETURN BINARY_INTEGER;
  PRAGMA RESTRICT_REFERENCES (hhckref, WNDS, WNPS);

  procedure sigerr( errn binary_integer, 
                    sv01 varchar2:='',
                    sv02 varchar2:='',
                    sv03 varchar2:='',
                    sv04 varchar2:='',
                    sv05 varchar2:='',
                    clrs boolean:=FALSE );
  pragma restrict_references(sigerr, rnds, wnds, rnps, wnps);

  FUNCTION hhmaxcode (hhc IN RAW, maxlen IN NUMBER)
    RETURN RAW;
  PRAGMA RESTRICT_REFERENCES (hhmaxcode, WNDS, RNDS);

END md;
/

SHOW ERRORS;
