set define off;
set serveroutput on;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_UNITS_OF_MEASURE;
  if(rec_count = 0) then
    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9001,
        'metre',
        NULL,
        'length',
        9001,
        1,
        1,
        'ISO 1000.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9002,
        'foot',
        NULL,
        'length',
        9001,
        .3048,
        1,
        'ISO 1000; 1958',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9003,
        'US survey foot',
        NULL,
        'length',
        9001,
        12,
        39.37,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9005,
        'Clarke''s foot',
        NULL,
        'length',
        9001,
        .304797265,
        1,
        'Australian Land Information Group  www.auslig.gov.au/geodesy/histry.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9014,
        'fathom',
        NULL,
        'length',
        9001,
        1.8288,
        1,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9030,
        'nautical mile',
        NULL,
        'length',
        9001,
        1852,
        1,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9031,
        'German legal metre',
        NULL,
        'length',
        9001,
        1.0000135965,
        1,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9033,
        'US survey chain',
        NULL,
        'length',
        9001,
        792,
        39.37,
        'Bureau of Land Management technical bulletin 6 (1973) and Standard Field Tables 8th edition (1956).',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9034,
        'US survey link',
        NULL,
        'length',
        9001,
        7.92,
        39.37,
        'Bureau of Land Management technical bulletin 6 (1973) and Standard Field Tables 8th edition (1956).',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9035,
        'US survey mile',
        NULL,
        'length',
        9001,
        63360,
        39.37,
        'Bureau of Land Management technical bulletin 6 (1973) and Standard Field Tables 8th edition (1956).',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9036,
        'kilometre',
        NULL,
        'length',
        9001,
        1000,
        1,
        'ISO 1000.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9037,
        'Clarke''s yard',
        NULL,
        'length',
        9001,
        .914391795,
        1,
        'Australian Land Information Group  www.auslig.gov.au/geodesy/histry.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9038,
        'Clarke''s chain',
        NULL,
        'length',
        9001,
        20.11661949,
        1,
        'Australian Land Information Group  www.auslig.gov.au/geodesy/histry.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9039,
        'Clarke''s link',
        NULL,
        'length',
        9001,
        .2011661949,
        1,
        'Australian Land Information Group  www.auslig.gov.au/geodesy/histry.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9040,
        'British yard (Sears 1922)',
        NULL,
        'length',
        9001,
        36,
        39.370147,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9041,
        'British foot (Sears 1922)',
        NULL,
        'length',
        9001,
        12,
        39.370147,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9042,
        'British chain (Sears 1922)',
        NULL,
        'length',
        9001,
        792,
        39.370147,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9043,
        'British link (Sears 1922)',
        NULL,
        'length',
        9001,
        7.92,
        39.370147,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9050,
        'British yard (Benoit 1895 A)',
        NULL,
        'length',
        9001,
        .9143992,
        1,
        'J.S.Clark; "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9051,
        'British foot (Benoit 1895 A)',
        NULL,
        'length',
        9001,
        .9143992,
        3,
        'J.S.Clark; "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9052,
        'British chain (Benoit 1895 A)',
        NULL,
        'length',
        9001,
        20.1167824,
        1,
        'J.S.Clark; "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9053,
        'British link (Benoit 1895 A)',
        NULL,
        'length',
        9001,
        .201167824,
        1,
        'J.S.Clark; "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9060,
        'British yard (Benoit 1895 B)',
        NULL,
        'length',
        9001,
        36,
        39.370113,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9061,
        'British foot (Benoit 1895 B)',
        NULL,
        'length',
        9001,
        12,
        39.370113,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9062,
        'British chain (Benoit 1895 B)',
        NULL,
        'length',
        9001,
        792,
        39.370113,
        'G. Bomford "Geodesy" 2nd edition 1962; after J.S.Clark "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9063,
        'British link (Benoit 1895 B)',
        NULL,
        'length',
        9001,
        7.92,
        39.370113,
        'G. Bomford; "Geodesy"; 3rd edition 1975',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9070,
        'British foot (1865)',
        NULL,
        'length',
        9001,
        .9144025,
        3,
        'J.S.Clark; "Remeasurement of the Old Length Standards"; Empire Survey Review no. 90; 1953.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9080,
        'Indian foot',
        NULL,
        'length',
        9001,
        12,
        39.370142,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9081,
        'Indian foot (1937)',
        NULL,
        'length',
        9001,
        .30479841,
        1,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9082,
        'Indian foot (1962)',
        NULL,
        'length',
        9001,
        .3047996,
        1,
        'G. Bomford; "Geodesy"; 2nd edition 1962',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9083,
        'Indian foot (1975)',
        NULL,
        'length',
        9001,
        .3047995,
        1,
        'G. Bomford; "Geodesy"; 3rd edition 1975',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9084,
        'Indian yard',
        NULL,
        'length',
        9001,
        36,
        39.370142,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9085,
        'Indian yard (1937)',
        NULL,
        'length',
        9001,
        .91439523,
        1,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9086,
        'Indian yard (1962)',
        NULL,
        'length',
        9001,
        .9143988,
        1,
        'G. Bomford; "Geodesy"; 2nd edition 1962',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9087,
        'Indian yard (1975)',
        NULL,
        'length',
        9001,
        .9143985,
        1,
        'G. Bomford; "Geodesy"; 3rd edition 1975',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9093,
        'Statute mile',
        NULL,
        'length',
        9001,
        1609.344,
        1,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9094,
        'Gold Coast foot',
        NULL,
        'length',
        9001,
        6378300,
        20926201,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9101,
        'radian',
        NULL,
        'angle',
        9101,
        1,
        1,
        'ISO 1000:1992',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9102,
        'degree',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        180,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9103,
        'arc-minute',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        10800,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9104,
        'arc-second',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        648000,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9105,
        'grad',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        200,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9106,
        'gon',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        200,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9107,
        'degree minute second',
        NULL,
        'angle',
        9102,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9108,
        'degree minute second hemisphere',
        NULL,
        'angle',
        9102,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9109,
        'microradian',
        NULL,
        'angle',
        9101,
        1,
        1000000,
        'ISO 1000.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9110,
        'sexagesimal DMS',
        NULL,
        'angle',
        9102,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9111,
        'sexagesimal DM',
        NULL,
        'angle',
        9102,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9112,
        'centesimal minute',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        20000,
        'http://www.geodesy.matav.hu/xgonmil.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9113,
        'centesimal second',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        2000000,
        'http://www.geodesy.matav.hu/xgonmil.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9114,
        'mil_6400',
        NULL,
        'angle',
        9101,
        3.14159265358979,
        3200,
        'http://www.geodesy.matav.hu/xgonmil.htm',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9201,
        'unity',
        NULL,
        'scale',
        9201,
        1,
        1,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9202,
        'parts per million',
        NULL,
        'scale',
        9201,
        1,
        1000000,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9203,
        'coefficient',
        NULL,
        'scale',
        9201,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9204,
        'Bin width 330 US survey feet',
        NULL,
        'length',
        9001,
        3960,
        39.37,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9205,
        'Bin width 165 US survey feet',
        NULL,
        'length',
        9001,
        1980,
        39.37,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9206,
        'Bin width 82.5 US survey feet',
        NULL,
        'length',
        9001,
        990,
        39.37,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9207,
        'Bin width 37.5 metres',
        NULL,
        'length',
        9001,
        37.5,
        1,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9208,
        'Bin width 25 metres',
        NULL,
        'length',
        9001,
        25,
        1,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9209,
        'Bin width 12.5 metres',
        NULL,
        'length',
        9001,
        12.5,
        1,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9210,
        'Bin width 6.25 metres',
        NULL,
        'length',
        9001,
        6.25,
        1,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9211,
        'Bin width 3.125 metres',
        NULL,
        'length',
        9001,
        3.125,
        1,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10001,
        'Decimal Degree',
        'Degree',
        'angle',
        10002,
        .017453292519943295769236907684886,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10002,
        'Radian',
        'Radian',
        'angle',
        10002,
        1,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10003,
        'Decimal Second',
        'Second',
        'angle',
        10002,
        .0000048481368110953599358991410235795,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10004,
        'Decimal Minute',
        'Minute',
        'angle',
        10002,
        .00029088820866572159615394846141477,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10005,
        'Gon',
        'Gon',
        'angle',
        10002,
        .015707963267948966192313216916398,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10006,
        'Grad',
        'Grad',
        'angle',
        10002,
        .015707963267948966192313216916398,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10007,
        'Square Meter',
        'SQ_M',
        'area',
        10008,
        1,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10008,
        'Square Meter',
        'SQ_METER',
        'area',
        10008,
        1,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10009,
        'Square Kilometer',
        'SQ_KM',
        'area',
        10008,
        1000000,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10010,
        'Square Centimeter',
        'SQ_CM',
        'area',
        10008,
        .0001,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10011,
        'Square Millimeter',
        'SQ_MM',
        'area',
        10008,
        .000001,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10012,
        'Square Kilometer',
        'SQ_KILOMETER',
        'area',
        10008,
        1000000,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10013,
        'Square Centimeter',
        'SQ_CENTIMETER',
        'area',
        10008,
        .0001,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_UNITS_OF_MEASURE where uom_id = 10014;
  if(rec_count = 0) then

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10014,
        'Square Millimeter',
        'SQ_MILLIMETER',
        'area',
        10008,
        .000001,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10015,
        'Square Chain',
        'SQ_CH',
        'area',
        10008,
        404.6856,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10016,
        'Square Foot',
        'SQ_FT',
        'area',
        10008,
        .09290304,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10017,
        'Square Inch',
        'SQ_IN',
        'area',
        10008,
        .00064516,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10018,
        'Square Link',
        'SQ_LI',
        'area',
        10008,
        .04046856,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10019,
        'Square Chain',
        'SQ_CHAIN',
        'area',
        10008,
        404.6856,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10020,
        'Square Foot',
        'SQ_FOOT',
        'area',
        10008,
        .09290304,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10021,
        'Square Inch',
        'SQ_INCH',
        'area',
        10008,
        .00064516,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10022,
        'Square Link',
        'SQ_LINK',
        'area',
        10008,
        .04046856,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10023,
        'Square Mile',
        'SQ_MILE',
        'area',
        10008,
        2589988,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10024,
        'Square Rod',
        'SQ_ROD',
        'area',
        10008,
        25.29285,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10025,
        'Square Survey Feet',
        'SQ_SURVEY_FOOT',
        'area',
        10008,
        .09290341,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10026,
        'Square Yard',
        'SQ_YARD',
        'area',
        10008,
        .8361274,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10027,
        'Acre',
        'ACRE',
        'area',
        10008,
        4046.856,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10028,
        'Hectare',
        'HECTARE',
        'area',
        10008,
        10000,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10029,
        'Perch',
        'PERCH',
        'area',
        10008,
        25.29285,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10030,
        'Rood',
        'ROOD',
        'area',
        10008,
        1011.714,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10031,
        'Meter',
        'M',
        'length',
        10032,
        1,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10032,
        'Meter',
        'METER',
        'length',
        10032,
        1,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10033,
        'Kilometer',
        'KM',
        'length',
        10032,
        1000,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10034,
        'Kilometer',
        'KILOMETER',
        'length',
        10032,
        1000,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10035,
        'Centimeter',
        'CM',
        'length',
        10032,
        .01,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10036,
        'Centimeter',
        'CENTIMETER',
        'length',
        10032,
        .01,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10037,
        'Millimeter',
        'MM',
        'length',
        10032,
        .001,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10038,
        'Millimeter',
        'MILLIMETER',
        'length',
        10032,
        .001,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10039,
        'Mile',
        'MILE',
        'length',
        10032,
        1609.344,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10040,
        'Nautical Mile',
        'NAUT_MILE',
        'length',
        10032,
        1852,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10041,
        'U.S. Foot',
        'SURVEY_FOOT',
        'length',
        10032,
        .3048006096012,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10042,
        'Foot (International)',
        'FOOT',
        'length',
        10032,
        .3048,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10043,
        'Inch',
        'INCH',
        'length',
        10032,
        .0254,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10044,
        'Yard',
        'YARD',
        'length',
        10032,
        .9144,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10045,
        'Chain',
        'CHAIN',
        'length',
        10032,
        20.1168,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10046,
        'Rod',
        'ROD',
        'length',
        10032,
        5.0292,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10047,
        'Link',
        'LINK',
        'length',
        10032,
        .20116619497596571965479068149417,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10048,
        'Modified American Foot',
        'MOD_USFT',
        'length',
        10032,
        .30481225298450596901193802387605,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10049,
        'Clarke''s Foot',
        'CL_FT',
        'length',
        10032,
        .30479726511509957523453133559723,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10050,
        'Indian Foot',
        'IND_FT',
        'length',
        10032,
        .30479951799004225054718498468167,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10051,
        'Link (Benoit)',
        'LINK_BEN',
        'length',
        10032,
        .20116782494375873394114972441151,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10052,
        'Link (Sears)',
        'LINK_SRS',
        'length',
        10032,
        .20116765121552632252046201402296,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10053,
        'Chain (Benoit)',
        'CHN_BEN',
        'length',
        10032,
        20.116782494375873394114972441151,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10054,
        'Chain (Sears)',
        'CHN_SRS',
        'length',
        10032,
        20.116765121552632252046201402296,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10055,
        'Yard (Indian)',
        'IND_YARD',
        'length',
        10032,
        .914398553970126751641554954045,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10056,
        'Yard (Sears)',
        'SRS_YARD',
        'length',
        10032,
        .91439841461602873872937279101345,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10057,
        'Fathom',
        'FATHOM',
        'length',
        10032,
        1.8288,
        1,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9095,
        'British foot (1936)',
        'British foot (1936)',
        'length',
        9001,
        0.3048007491,
        1,
        '1. "The Retriangulation of Great Britain", Ordnance Survey of Great Britain.\n\n2. "The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        'FALSE',
        NULL);
 
    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9115,
        'degree minute',
        'degree minute',
        'angle',
        9102,
        Null,
        Null,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9116,
        'degree hemisphere',
        'degree hemisphere',
        'angle',
        9102,
        Null,
        Null,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9117,
        'hemisphere degree',
        'hemisphere degree',
        'angle',
        9102,
        Null,
        Null,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9118,
        'degree minute hemisphere',
        'degree minute hemisphere',
        'angle',
        9102,
        Null,
        Null,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9119,
        'hemisphere degree minute',
        'hemisphere degree minute',
        'angle',
        9102,
        Null,
        Null,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9120,
        'hemisphere degree minute second',
        'hemisphere degree minute second',
        'angle',
        9102,
        Null,
        Null,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9121,
        'sexagesimal DMS.s',
        'sexagesimal DMS.s',
        'angle',
        9102,
        Null,
        Null,
        'ISO 6709:1983.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9122,
        'degree (supplier to define representation)',
        'degree (supplier to define representation)',
        'angle',
        9101,
        3.14159265358979,
        180,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    






    











    UPDATE MDSYS.SDO_UNITS_OF_MEASURE SET LEGACY_UNIT_NAME = 'Decimal Degree' WHERE UOM_ID = 9102 ;
    UPDATE MDSYS.SDO_UNITS_OF_MEASURE SET LEGACY_UNIT_NAME = 'Decimal Degree' WHERE UOM_ID = 9122 ;
    UPDATE MDSYS.SDO_UNITS_OF_MEASURE SET LEGACY_UNIT_NAME = 'Radian'         WHERE UOM_ID = 9101 ;
    UPDATE MDSYS.SDO_UNITS_OF_MEASURE SET LEGACY_UNIT_NAME = 'Meter'          WHERE UOM_ID = 9001 ;
    UPDATE MDSYS.SDO_UNITS_OF_MEASURE SET LEGACY_UNIT_NAME = 'U.S. Foot'      WHERE UOM_ID = 9003 ;
    UPDATE MDSYS.SDO_UNITS_OF_MEASURE SET LEGACY_UNIT_NAME = 'Link'           WHERE UOM_ID = 9039 ;

  end if;
 
  
  delete from MDSYS.SDO_UNITS_OF_MEASURE where UOM_ID = 1000001;
    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        1000001,
        'USER-HALF-METER',
        NULL,
        'length',
        9001,
        .5,
        1,
        'User Defined Half-Meter',
        'USER_DEFINED',
        'FALSE',
        NULL);

  
  delete from MDSYS.SDO_UNITS_OF_MEASURE where UOM_ID = 1000002;
    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        1000002,
        'USER-SQ-HALF-METER',
        NULL,
        'area',
        10008,
        .25,
        1,
        'User Defined SQ-Half-Meter',
        'USER_DEFINED',
        'FALSE',
        NULL);
end;
/
select
  uom_id,
  target_uom_id,
  factor_b,
  factor_c
from
  mdsys.sdo_units_of_measure
where
  not (target_uom_id in (9001, 9101, 9201, 10008, 19501))
order by
  target_uom_id,
  uom_id;
begin
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9107; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9108; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9110; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9111; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9203; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9115; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9116; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9117; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9118; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9119; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9120; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1 where uom_id = 9121; 
end;
/
select uom_id from mdsys.sdo_units_of_measure where factor_b is null or factor_c is null;
begin
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9107; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9108; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9110; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9111; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9115; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9116; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9117; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9118; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9119; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9120; 
  update mdsys.sdo_units_of_measure set factor_b = 3.14159265358979, factor_c = 180, target_uom_id = 9101 where uom_id = 9121; 
end;
/
begin
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1, target_uom_id = 9001 where uom_id = 10031; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1, target_uom_id = 9001 where uom_id = 10032; 
  update mdsys.sdo_units_of_measure set factor_b = 1000, factor_c = 1, target_uom_id = 9001 where uom_id = 10033; 
  update mdsys.sdo_units_of_measure set factor_b = 1000, factor_c = 1, target_uom_id = 9001 where uom_id = 10034; 
  update mdsys.sdo_units_of_measure set factor_b = .01, factor_c = 1, target_uom_id = 9001 where uom_id = 10035; 
  update mdsys.sdo_units_of_measure set factor_b = .01, factor_c = 1, target_uom_id = 9001 where uom_id = 10036; 
  update mdsys.sdo_units_of_measure set factor_b = .001, factor_c = 1, target_uom_id = 9001 where uom_id = 10037; 
  update mdsys.sdo_units_of_measure set factor_b = .001, factor_c = 1, target_uom_id = 9001 where uom_id = 10038; 
  update mdsys.sdo_units_of_measure set factor_b = 1609.344, factor_c = 1, target_uom_id = 9001 where uom_id = 10039; 
  update mdsys.sdo_units_of_measure set factor_b = 1852, factor_c = 1, target_uom_id = 9001 where uom_id = 10040; 
  update mdsys.sdo_units_of_measure set factor_b = .3048006096012, factor_c = 1, target_uom_id = 9001 where uom_id = 10041; 
  update mdsys.sdo_units_of_measure set factor_b = .3048, factor_c = 1, target_uom_id = 9001 where uom_id = 10042; 
  update mdsys.sdo_units_of_measure set factor_b = .0254, factor_c = 1, target_uom_id = 9001 where uom_id = 10043; 
  update mdsys.sdo_units_of_measure set factor_b = .9144, factor_c = 1, target_uom_id = 9001 where uom_id = 10044; 
  update mdsys.sdo_units_of_measure set factor_b = 20.1168, factor_c = 1, target_uom_id = 9001 where uom_id = 10045; 
  update mdsys.sdo_units_of_measure set factor_b = 5.0292, factor_c = 1, target_uom_id = 9001 where uom_id = 10046; 
  update mdsys.sdo_units_of_measure set factor_b = .20116619497596571965479068149417, factor_c = 1, target_uom_id = 9001 where uom_id = 10047; 
  update mdsys.sdo_units_of_measure set factor_b = .30481225298450596901193802387605, factor_c = 1, target_uom_id = 9001 where uom_id = 10048; 
  update mdsys.sdo_units_of_measure set factor_b = .30479726511509957523453133559723, factor_c = 1, target_uom_id = 9001 where uom_id = 10049; 
  update mdsys.sdo_units_of_measure set factor_b = .30479951799004225054718498468167, factor_c = 1, target_uom_id = 9001 where uom_id = 10050; 
  update mdsys.sdo_units_of_measure set factor_b = .20116782494375873394114972441151, factor_c = 1, target_uom_id = 9001 where uom_id = 10051; 
  update mdsys.sdo_units_of_measure set factor_b = .20116765121552632252046201402296, factor_c = 1, target_uom_id = 9001 where uom_id = 10052; 
  update mdsys.sdo_units_of_measure set factor_b = 20.116782494375873394114972441151, factor_c = 1, target_uom_id = 9001 where uom_id = 10053; 
  update mdsys.sdo_units_of_measure set factor_b = 20.116765121552632252046201402296, factor_c = 1, target_uom_id = 9001 where uom_id = 10054; 
  update mdsys.sdo_units_of_measure set factor_b = .914398553970126751641554954045, factor_c = 1, target_uom_id = 9001 where uom_id = 10055; 
  update mdsys.sdo_units_of_measure set factor_b = .91439841461602873872937279101345, factor_c = 1, target_uom_id = 9001 where uom_id = 10056; 
  update mdsys.sdo_units_of_measure set factor_b = 1.8288, factor_c = 1, target_uom_id = 9001 where uom_id = 10057; 
end;
/
begin
  update mdsys.sdo_units_of_measure set factor_b = .017453292519943295769236907684886, factor_c = 1, target_uom_id = 9101 where uom_id = 10001; 
  update mdsys.sdo_units_of_measure set factor_b = 1, factor_c = 1, target_uom_id = 9101 where uom_id = 10002; 
  update mdsys.sdo_units_of_measure set factor_b = .0000048481368110953599358991410235795, factor_c = 1, target_uom_id = 9101 where uom_id = 10003; 
  update mdsys.sdo_units_of_measure set factor_b = .00029088820866572159615394846141477, factor_c = 1, target_uom_id = 9101 where uom_id = 10004; 
  update mdsys.sdo_units_of_measure set factor_b = .015707963267948966192313216916398, factor_c = 1, target_uom_id = 9101 where uom_id = 10005; 
  update mdsys.sdo_units_of_measure set factor_b = .015707963267948966192313216916398, factor_c = 1, target_uom_id = 9101 where uom_id = 10006; 
end;
/
select
  target_uom_id,
  count(*)
from
  sdo_units_of_measure
where
  not (target_uom_id in (9001, 9101, 9201, 10008, 19501))
group by
  target_uom_id
order by
  target_uom_id;
commit;
select 'commit 1' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'UNIT_OF_MEASURE_FOREIGN_LEGACY';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_UNITS_OF_MEASURE ADD (
        constraint uom_unique1 unique(uom_id, unit_of_meas_type),
        CONSTRAINT UNIT_OF_MEASURE_FOREIGN_LEGACY FOREIGN KEY(LEGACY_CODE) REFERENCES MDSYS.SDO_UNITS_OF_MEASURE(UOM_ID),
        CONSTRAINT UNIT_OF_MEASURE_FOREIGN_UOM FOREIGN KEY(TARGET_UOM_ID) REFERENCES MDSYS.SDO_UNITS_OF_MEASURE(UOM_ID),
        CONSTRAINT UNIT_OF_MEASURE_PRIM PRIMARY KEY(UOM_ID) USING INDEX,
        constraint uom_type_constr check(lower(unit_of_meas_type) in (''area'', ''angle'', ''length'', ''scale'', ''volume'')),
        constraint only_std_target_uoms check(target_uom_id in (9001, 9101, 9201, 10008, 19501)),
        CONSTRAINT FACTOR_B_MUST_BE_POS CHECK(FACTOR_B IS NULL OR FACTOR_B > 0),
        CONSTRAINT FACTOR_C_MUST_BE_POS CHECK(FACTOR_C IS NULL OR FACTOR_C > 0))';
    execute immediate stm;
  end if;
end;
/
begin
  execute immediate 'ALTER TABLE MDSYS.SDO_UNITS_OF_MEASURE drop constraint uom_type_constr';
  execute immediate 'ALTER TABLE MDSYS.SDO_UNITS_OF_MEASURE drop constraint only_std_target_uoms';
  exception
    when others then
      null;
end;
/
begin
  execute immediate 'ALTER TABLE MDSYS.SDO_UNITS_OF_MEASURE add (
                       constraint uom_type_constr check(lower(unit_of_meas_type) in (''area'', ''angle'', ''length'', ''scale'', ''volume'')),
                       constraint only_std_target_uoms check(target_uom_id in (9001, 9101, 9201, 10008, 19501)))';
end;
/
declare
  v number;
begin
  select count(*) into v from mdsys.sdo_units_of_measure where unit_of_meas_type = 'volume';
  if(v = 0) then
    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        19501,
        'Cubic meter',
        'CUBIC_METER',
        'volume',
        19501,
        1,
        1,
        null,
        null,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_UNITS_OF_MEASURE (
        UOM_ID,
        UNIT_OF_MEAS_NAME,
        SHORT_NAME,
        UNIT_OF_MEAS_TYPE,
        TARGET_UOM_ID,
        FACTOR_B,
        FACTOR_C,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        19502,
        'Cubic foot',
        'CUBIC_FOOT',
        'volume',
        19501,
        .3048 * .3048 * .3048,
        1,
        null,
        null,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
select 'commit 2' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'PRIME_MERIDIAN_FOREIGN_UOM';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_PRIME_MERIDIANS ADD (
        CONSTRAINT PRIME_MERIDIAN_FOREIGN_UOM FOREIGN KEY(UOM_ID) REFERENCES MDSYS.SDO_UNITS_OF_MEASURE(UOM_ID),
        CONSTRAINT PRIME_MERIDIAN_PRIM PRIMARY KEY(PRIME_MERIDIAN_ID) USING INDEX)';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 3' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_PRIME_MERIDIANS;
  if(rec_count = 0) then

    
    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        1000000123,
        'Ellipsoid without EPSG parameters',
        NULL,
        NULL,
        'Oracle',
        'Oracle');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8901,
        'Greenwich',
        0,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8902,
        'Lisbon',
        -9.0754862,
        9110,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8903,
        'Paris',
        2.5969213,
        9105,
        'Institut Geographique National (IGN); Paris',
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8904,
        'Bogota',
        -74.04513,
        9110,
        'Instituto Geografico "Augustin Cadazzi" (IGAC); Bogota',
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8905,
        'Madrid',
        -3.411658,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8906,
        'Rome',
        12.27084,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8907,
        'Bern',
        7.26225,
        9110,
        'Bundesamt fur Landestopographie',
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8908,
        'Jakarta',
        106.482779,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8909,
        'Ferro',
        -17.4,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8910,
        'Brussels',
        4.220471,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8911,
        'Stockholm',
        18.03298,
        9110,
        NULL,
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8912,
        'Athens',
        23.4258815,
        9110,
        'Topography Department; National Technical University of Athens.',
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8913,
        'Oslo',
        10.43225,
        9110,
        'Statens Kartverk - Geodesidivisjonen',
        'EPSG');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8950,
        'Greenwich (degree)',
        0,
        9102,
        'Derived from  with different unit of measure',
        'Derived from EPSG with different unit of measure');

    insert into MDSYS.SDO_PRIME_MERIDIANS (
        PRIME_MERIDIAN_ID,
        PRIME_MERIDIAN_NAME,
        GREENWICH_LONGITUDE,
        UOM_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        8951,
        'Airy-0',
        0,
        9102,
        'legacy WKT',
        'legacy WKT');
  end if;
end;
/
commit;
select 'commit 4' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'ELLIPSOID_FOREIGN_UOM';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_ELLIPSOIDS ADD (
        CONSTRAINT ELLIPSOID_FOREIGN_UOM FOREIGN KEY(UOM_ID) REFERENCES MDSYS.SDO_UNITS_OF_MEASURE(UOM_ID),
        CONSTRAINT ELLIPSOID_PRIM PRIMARY KEY(ELLIPSOID_ID) USING INDEX)';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 5' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_ELLIPSOIDS;
  if(rec_count = 0) then

    
    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        1000000123,
        'Ellipsoid without EPSG parameters',
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        'Oracle',
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7001,
        'Airy 1830',
        6377563.396,
        9001,
        299.3249646,
        NULL,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        'FALSE',
        8001);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7002,
        'Airy Modified 1849',
        6377340.189,
        9001,
        299.3249646,
        NULL,
        '"The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        'FALSE',
        8002);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7003,
        'Australian National Spheroid',
        6378160,
        9001,
        298.25,
        NULL,
        '"Australian Map Grid Technical Manual"; National Mapping Council of Australia Special Publication #7; 1972',
        'EPSG',
        'FALSE',
        8003);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7004,
        'Bessel 1841',
        6377397.155,
        9001,
        299.1528128,
        NULL,
        'US Army Map Service Technical Manual; 1943.',
        'EPSG',
        'FALSE',
        8004);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7005,
        'Bessel Modified',
        6377492.018,
        9001,
        299.1528128,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8005);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7007,
        'Clarke 1858',
        20926348,
        9005,
        NULL,
        20855233,
        '"Ellipsoidisch Parameter der Erdfigur (1800-1950)" by Georg Strasser.',
        'EPSG',
        'FALSE',
        8007);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7008,
        'Clarke 1866',
        6378206.4,
        9001,
        NULL,
        6356583.8,
        'US Army Map Service Technical Manual No. 7; 1943.',
        'EPSG',
        'FALSE',
        8008);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7009,
        'Clarke 1866 Michigan',
        20926631.531,
        9003,
        NULL,
        20855688.674,
        'USGS Professional Paper #1395.',
        'EPSG',
        'FALSE',
        8009);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7010,
        'Clarke 1880 (Benoit)',
        6378300.789,
        9001,
        NULL,
        6356566.435,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7011,
        'Clarke 1880 (IGN)',
        6378249.2,
        9001,
        NULL,
        6356515,
        NULL,
        'EPSG',
        'FALSE',
        8012);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7012,
        'Clarke 1880 (RGS)',
        6378249.145,
        9001,
        293.465,
        NULL,
        'Empire Survey Review #32; 1939.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7013,
        'Clarke 1880 (Arc)',
        6378249.145,
        9001,
        293.4663077,
        NULL,
        'Chief Directorate: Surveys and Mapping, Mowbray, South Africa.',
        'EPSG',
        'FALSE',
        8011);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_ELLIPSOIDS where ellipsoid_id = 7014;
  if(rec_count = 0) then

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7014,
        'Clarke 1880 (SGA 1922)',
        6378249.2,
        9001,
        293.46598,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8014);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7015,
        'Everest 1830 (1937 Adjustment)',
        6377276.345,
        9001,
        300.8017,
        NULL,
        'Survey of India professional paper #28; 1939',
        'EPSG',
        'FALSE',
        8016);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7016,
        'Everest 1830 (1967 Definition)',
        6377298.556,
        9001,
        300.8017,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8019);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7018,
        'Everest 1830 Modified',
        6377304.063,
        9001,
        300.8017,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8018);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7019,
        'GRS 1980',
        6378137,
        9001,
        298.257222101,
        NULL,
        '"Geodetic Reference System 1980" by H. Moritz; Bulletin Geodesique',
        'EPSG',
        'FALSE',
        8024);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7020,
        'Helmert 1906',
        6378200,
        9001,
        298.3,
        NULL,
        '"Ellipsoidisch Parameter der Erdfigur (1800-1950)" by Georg Strasser',
        'EPSG',
        'FALSE',
        8026);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7021,
        'Indonesian National Spheroid',
        6378160,
        9001,
        298.247,
        NULL,
        'Rais paper.',
        'EPSG',
        'FALSE',
        8029);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7022,
        'International 1924',
        6378388,
        9001,
        297,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8030);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7024,
        'Krassowsky 1940',
        6378245,
        9001,
        298.3,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8031);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7025,
        'NWL 9D',
        6378145,
        9001,
        298.25,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8034);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7027,
        'Plessis 1817',
        6376523,
        9001,
        308.64,
        NULL,
        'IGN Paris "Constants d''Ellipsoides" February 1972.',
        'EPSG',
        'FALSE',
        8038);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7028,
        'Struve 1860',
        6378298.3,
        9001,
        294.73,
        NULL,
        '"Geodesia y Cartografia Matematica" by Fernando Martin Asin; ISBN 84-398-0248-X.',
        'EPSG',
        'FALSE',
        8041);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7029,
        'War Office',
        6378300,
        9001,
        296,
        NULL,
        'Tables for the use of the Gold Coast Survey Department, 1935.',
        'EPSG',
        'FALSE',
        8047);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7030,
        'WGS 84',
        6378137,
        9001,
        298.257223563,
        NULL,
        'DMA Technical Manual 8350.2-B ',
        'EPSG',
        'FALSE',
        8045);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7031,
        'GEM 10C',
        6378137,
        9001,
        298.257223563,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7032,
        'OSU86F',
        6378136.2,
        9001,
        298.257223563,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8036);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7033,
        'OSU91A',
        6378136.3,
        9001,
        298.257223563,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8037);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7034,
        'Clarke 1880',
        20926202,
        9005,
        293.465,
        20854895,
        '"Ellipsoidisch Parameter der Erdfigur (1800-1950)" by Georg Strasser.',
        'EPSG',
        'FALSE',
        8010);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7036,
        'GRS 1967',
        6378160,
        9001,
        298.247167427,
        NULL,
        '"Geodetic Reference System 1967"; International Association of Geodesy special publication number 3; August 1971.',
        'EPSG',
        'FALSE',
        8023);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7041,
        'Average Terrestrial System 1977',
        6378135,
        9001,
        298.257,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7042,
        'Everest (1830 Definition)',
        20922931.8,
        9080,
        300.8017,
        20853374.58,
        '"Ellipsoidisch Parameter der Erdfigur (1800-1950)" by Georg Strasser',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7043,
        'WGS 72',
        6378135,
        9001,
        298.26,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8044);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7044,
        'Everest 1830 (1962 Definition)',
        6377301.243,
        9001,
        300.8017255,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        8017);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7045,
        'Everest 1830 (1975 Definition)',
        6377299.151,
        9001,
        300.8017255,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7046,
        'Bessel Namibia (GLM)',
        6377397.155,
        9031,
        299.1528128,
        NULL,
        'Chief Directorate: Surveys and Mapping, Mowbray, South Africa.',
        'ISO Project Team 19127',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7048,
        'GRS 1980 Authalic Sphere',
        6371007,
        9001,
        NULL,
        6371007,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7049,
        'Xian 1980',
        6378140,
        9001,
        298.257,
        NULL,
        'BP',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8001,
        'Airy 1830',
        6377563.396,
        9001,
        299.3249646,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8002,
        'Airy 1830(Ireland 1965)',
        6377340.189,
        9001,
        299.3249646,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8003,
        'Australian',
        6378160,
        9001,
        298.25,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8004,
        'Bessel 1841',
        6377397.155,
        9001,
        299.1528128,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8005,
        'Bessel 1841 (NGO 1948)',
        6377492.0176,
        9001,
        299.15281,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8006,
        'Bessel 1841 (Schwarzeck)',
        6377483.865,
        9001,
        299.1528128,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8007,
        'Clarke 1858',
        6378293.639,
        9001,
        294.26068,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8008,
        'Clarke 1866',
        6378206.4,
        9001,
        294.9786982,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8009,
        'Clarke 1866 (Michigan)',
        6378450.047484481,
        9001,
        294.9786982,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8010,
        'Clarke 1880',
        6378249.145,
        9001,
        293.465,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8011,
        'Clarke 1880 (Arc 1950)',
        6378249.145326,
        9001,
        293.4663076,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8012,
        'Clarke 1880 (IGN)',
        6378249.2,
        9001,
        293.4660213,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8013,
        'Clarke 1880 (Jamaica)',
        6378249.136,
        9001,
        293.46631,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8014,
        'Clarke 1880 (Merchich)',
        6378249.2,
        9001,
        293.46598,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8015,
        'Clarke 1880 (Palestine)',
        6378300.79,
        9001,
        293.46623,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8016,
        'Everest',
        6377276.345,
        9001,
        300.8017,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_ELLIPSOIDS where ellipsoid_id = 8017;
  if(rec_count = 0) then

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8017,
        'Everest (Kalianpur)',
        6377301.243,
        9001,
        300.80174,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8018,
        'Everest (Kertau)',
        6377304.063,
        9001,
        300.8017,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8019,
        'Everest (Timbalai)',
        6377298.556,
        9001,
        300.8017,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8020,
        'Fischer 1960 (Mercury)',
        6378166,
        9001,
        298.3,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8021,
        'Fischer 1960 (South Asia)',
        6378155,
        9001,
        298.3,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8022,
        'Fischer 1968',
        6378150,
        9001,
        298.3,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8023,
        'GRS 67',
        6378160,
        9001,
        298.247167427,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8024,
        'GRS 80',
        6378137,
        9001,
        298.257222101,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8025,
        'Hayford',
        6378388,
        9001,
        297,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8026,
        'Helmert 1906',
        6378200,
        9001,
        298.3,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8027,
        'Hough',
        6378270,
        9001,
        297,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8028,
        'IAG 75',
        6378140,
        9001,
        298.257222,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8029,
        'Indonesian',
        6378160,
        9001,
        298.247,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8030,
        'International 1924',
        6378388,
        9001,
        297,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8031,
        'Krassovsky',
        6378245,
        9001,
        298.3,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8032,
        'MERIT 83',
        6378137,
        9001,
        298.257,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8033,
        'NWL 10D',
        6378135,
        9001,
        298.26,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8034,
        'NWL 9D',
        6378145,
        9001,
        298.25,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8035,
        'New International 1967',
        6378157.5,
        9001,
        298.25,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8036,
        'OSU86F',
        6378136.2,
        9001,
        298.25722,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8037,
        'OSU91A',
        6378136.3,
        9001,
        298.25722,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8038,
        'Plessis 1817',
        6376523,
        9001,
        308.64,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8039,
        'South American 1969',
        6378160,
        9001,
        298.25,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8040,
        'Sphere (6370997m)',
        6370997,
        9001,
        1000000000000,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8041,
        'Struve 1860',
        6378297,
        9001,
        294.73,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8042,
        'WGS 60',
        6378165,
        9001,
        298.3,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8043,
        'WGS 66',
        6378145,
        9001,
        298.25,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8044,
        'WGS 72',
        6378135,
        9001,
        298.26,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8045,
        'WGS 84',
        6378137,
        9001,
        298.257223563,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8046,
        'Walbeck',
        6376896,
        9001,
        302.78,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8047,
        'War Office',
        6378300.583,
        9001,
        296,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8100,
        'UnitSphere',
        1,
        9001,
        1000000000000,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        8101,
        'Mars',
        3390592.987983,
        9001,
        1000000000000,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7006,
        'Bessel Namibia',
        6377483.865,
        9001,
        299.1528128,
        Null,
        'Chief Directorate: Surveys and Mapping, Mowbray, South Africa.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7035,
        'Sphere',
        6371000,
        9001,
        Null,
        6371000,
        '',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7047,
        'GRS 1980 Authalic Sphere',
        6370997,
        9001,
        Null,
        6370997,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7050,
        'GRS 1967 (SAD69)',
        6378160,
        9001,
        298.25,
        Null,
        '"Geodetic Reference System 1967"; International Association of Geodesy special publication number 3; August 1971.',
        'EPSG',
        'FALSE',
        NULL);

    insert into MDSYS.SDO_ELLIPSOIDS (
        ELLIPSOID_ID,
        ELLIPSOID_NAME,
        SEMI_MAJOR_AXIS,
        UOM_ID,
        INV_FLATTENING,
        SEMI_MINOR_AXIS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        7051,
        'Danish 1876',
        6377019.27,
        9001,
        300,
        Null,
        'Kort og Matrikelstyrelsen (KMS), Copenhagen.',
        'EPSG',
        'FALSE',
        NULL);

    UPDATE
      MDSYS.SDO_ELLIPSOIDS
    SET
      INV_FLATTENING = (SEMI_MAJOR_AXIS/(SEMI_MAJOR_AXIS - SEMI_MINOR_AXIS))
    WHERE
      INV_FLATTENING IS NULL
      AND
      NOT SEMI_MINOR_AXIS IS NULL
      AND
      NOT SEMI_MAJOR_AXIS IS NULL
      AND
      (SEMI_MINOR_AXIS < SEMI_MAJOR_AXIS);

    UPDATE
      MDSYS.SDO_ELLIPSOIDS
    SET
      SEMI_MINOR_AXIS = (SEMI_MAJOR_AXIS - SEMI_MAJOR_AXIS / INV_FLATTENING)
    WHERE
      NOT INV_FLATTENING IS NULL
      AND
      SEMI_MINOR_AXIS IS NULL
      AND
      NOT SEMI_MAJOR_AXIS IS NULL;

    UPDATE
      MDSYS.SDO_ELLIPSOIDS
    SET
      SEMI_MAJOR_AXIS = ((INV_FLATTENING * SEMI_MINOR_AXIS) / (INV_FLATTENING - 1))
    WHERE
      NOT INV_FLATTENING IS NULL
      AND
      NOT SEMI_MINOR_AXIS IS NULL
      AND
      SEMI_MAJOR_AXIS IS NULL;
  end if;
end;
/
commit;
select 'commit 6' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'ELLIPSOID_FOREIGN_LEGACY';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_UNITS_OF_MEASURE ADD (
        CONSTRAINT ELLIPSOID_FOREIGN_LEGACY FOREIGN KEY(LEGACY_CODE) REFERENCES MDSYS.SDO_ELLIPSOIDS(ELLIPSOID_ID))';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 7' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'DATUM_FOREIGN_ELLIPSOID';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_DATUMS ADD (
        CONSTRAINT DATUM_FOREIGN_ELLIPSOID FOREIGN KEY(ELLIPSOID_ID) REFERENCES MDSYS.SDO_ELLIPSOIDS(ELLIPSOID_ID),
        CONSTRAINT DATUM_FOREIGN_MERIDIAN FOREIGN KEY(PRIME_MERIDIAN_ID) REFERENCES MDSYS.SDO_PRIME_MERIDIANS(PRIME_MERIDIAN_ID),
        CONSTRAINT DATUM_PRIM PRIMARY KEY(DATUM_ID) USING INDEX)';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 8' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS;
  if(rec_count = 0) then

    
    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        1000000123,
        'Datum without EPSG parameters',
        'GEODETIC',
        1000000123,
        1000000123,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5100,
        'Mean Sea Level',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5101,
        'Ordnance Datum Newlyn',
        'VERTICAL',
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5102,
        'National Geodetic Vertical Datum 1929',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5103,
        'North American Vertical Datum 1988',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5104,
        'Yellow Sea 1956',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5105,
        'Baltic Sea',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5106,
        'Caspian Sea',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5109,
        'Normaal Amsterdams Peil',
        'VERTICAL',
        NULL,
        NULL,
        'Nederlandse Commissie voor Geodesie publication 30; 1993',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5110,
        'Oostende',
        'VERTICAL',
        NULL,
        NULL,
        'Nederlandse Commissie voor Geodesie publication 30; 1993',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5111,
        'Australian Height Datum',
        'VERTICAL',
        NULL,
        NULL,
        'http://www.auslig.gov.au/geodesy',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5112,
        'Australian Height Datum (Tasmania)',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5113,
        'Sea Level',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5114,
        'Canadian Vertical Datum of 1928',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5115,
        'Piraeus Harbour 1986',
        'VERTICAL',
        NULL,
        NULL,
        'Geodesy Department; Public Pertoleum Corporation of Greece',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5116,
        'Helsinki 1960',
        'VERTICAL',
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5117,
        'Rikets hojdsystem 1970',
        'VERTICAL',
        NULL,
        NULL,
        'National Land Survey of Sweden',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5118,
        'Nivellement general de la France - Lalle',
        'VERTICAL',
        NULL,
        NULL,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5119,
        'Nivellement general de la France - IGN69',
        'VERTICAL',
        NULL,
        NULL,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5120,
        'Nivellement general de la France - IGN78',
        'VERTICAL',
        NULL,
        NULL,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5121,
        'Maputo',
        'VERTICAL',
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5122,
        'Japanese Standard Levelling Datum 1949',
        'VERTICAL',
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/tokyodatum.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5123,
        'PDO Height Datum 1993',
        'VERTICAL',
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5124,
        'Fahud Height Datum',
        'VERTICAL',
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5125,
        'Ha Tien 1960',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5126,
        'Hon Dau 1992',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5127,
        'Landesnivellement 1902',
        'VERTICAL',
        NULL,
        NULL,
        'Bundesamt fur Landestopographie',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5128,
        'Landeshohennetz 1995',
        'VERTICAL',
        NULL,
        NULL,
        'Bundesamt fur Landestopographie',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5129,
        'European Vertical Reference Frame 2000',
        'VERTICAL',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
select 'commit 8' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 5130;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5130,
        'Malin Head',
        'VERTICAL',
        NULL,
        NULL,
        'Ordnance Survey of Ireland',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5131,
        'Belfast Lough',
        'VERTICAL',
        NULL,
        NULL,
        'Ordnance Survey of Northern Ireland',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5132,
        'Dansk Normal Nul',
        'VERTICAL',
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5133,
        'AIOC 1995',
        'VERTICAL',
        NULL,
        NULL,
        'BP',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        5134,
        'Black Sea',
        'VERTICAL',
        NULL,
        NULL,
        'BP',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6120,
        'Greek',
        'GEODETIC',
        7004,
        8901,
        'Topography Department; National Technical University of Athens',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6121,
        'Greek Geodetic Reference System 1987',
        'GEODETIC',
        7019,
        8901,
        'L. Portokalakis; Public Petroleum Corporation of Greece',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6122,
        'Average Terrestrial System 1977',
        'GEODETIC',
        7041,
        8901,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6123,
        'Kartasto Koordinaati Jarjestelma 1966',
        'GEODETIC',
        7022,
        8901,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6124,
        'Rikets koordinatsystem 1990',
        'GEODETIC',
        7004,
        8901,
        'National Land Survey of Sweden',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6125,
        'Samboja',
        'GEODETIC',
        7004,
        8901,
        'Total Indonesia.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6126,
        'Lithuania 1994 (ETRS89)',
        'GEODETIC',
        7019,
        8901,
        'HNIT-Baltic GeoInfoServisas',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6127,
        'Tete',
        'GEODETIC',
        7008,
        8901,
        'Mozambique Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6128,
        'Madzansua',
        'GEODETIC',
        7008,
        8901,
        'Mozambique Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6129,
        'Observatario',
        'GEODETIC',
        7008,
        8901,
        'Mozambique Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6130,
        'Moznet (ITRF94)',
        'GEODETIC',
        7030,
        8901,
        'Mozambique Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6131,
        'Indian 1960',
        'GEODETIC',
        7015,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6132,
        'Final Datum 1958',
        'GEODETIC',
        7012,
        8901,
        'IOEPC records',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6133,
        'Estonia 1992',
        'GEODETIC',
        7019,
        8901,
        'http://www.geo.ut.ee/~raivo/estcoord.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6134,
        'PDO Survey Datum 1993',
        'GEODETIC',
        7012,
        8901,
        'Petroleum Development Oman',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6135,
        'Old Hawaiian',
        'GEODETIC',
        7008,
        8901,
        'http://www.ngs.noaa.gov/ (NADCON readme file) and the NIMA publication http://164.214.2.59/publications/guides/Datum_Pamphlet/datum.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10087);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6136,
        'St. Lawrence Island',
        'GEODETIC',
        7008,
        8901,
        'http://www.ngs.noaa.gov/ (NADCON readme file)',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6137,
        'St. Paul Island',
        'GEODETIC',
        7008,
        8901,
        'http://www.ngs.noaa.gov/ (NADCON readme file)',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6138,
        'St. George Island',
        'GEODETIC',
        7008,
        8901,
        'http://www.ngs.noaa.gov/ (NADCON readme file)',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6139,
        'Puerto Rico',
        'GEODETIC',
        7008,
        8901,
        'Ordnance Survey of Great Britain and http://www.ngs.noaa.gov/ (NADCON readme file).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10093);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6140,
        'NAD83 Canadian Spatial Reference System',
        'GEODETIC',
        7019,
        8901,
        'Service New Brunswick Land and Information Standards Manual',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6141,
        'Israel',
        'GEODETIC',
        7019,
        8901,
        'Survey of Israel.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6142,
        'Locodjo 1965',
        'GEODETIC',
        7012,
        8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6143,
        'Abidjan 1987',
        'GEODETIC',
        7012,
        8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6144,
        'Kalianpur 1937',
        'GEODETIC',
        7015,
        8901,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6145;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6145,
        'Kalianpur 1962',
        'GEODETIC',
        7044,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6146,
        'Kalianpur 1975',
        'GEODETIC',
        7045,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6147,
        'Hanoi 1972',
        'GEODETIC',
        7024,
        8901,
        'PetroVietnam',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6148,
        'Hartebeesthoek94',
        'GEODETIC',
        7030,
        8901,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6149,
        'CH1903',
        'GEODETIC',
        7004,
        8901,
        'Bundesamt fur Landestopographie',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6150,
        'CH1903+',
        'GEODETIC',
        7004,
        8901,
        'Bundesamt fur Landestopographie.  Aufbau der Landesvermessung der Schweiz ''LV95'' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6151,
        'Swiss Terrestrial Reference Frame 1995',
        'GEODETIC',
        7019,
        8901,
        'Bundesamt fur Landestopographie.  Aufbau der Landesvermessung der Schweiz ''LV95'' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6152,
        'NAD83 (High Accuracy Regional Network)',
        'GEODETIC',
        7019,
        8901,
        'National Geodetic Survey',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6153,
        'Rassadiran',
        'GEODETIC',
        7022,
        8901,
        'Total-Fina',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6154,
        'European Datum 1950(1977)',
        'GEODETIC',
        7022,
        8901,
        'National Cartographic Centre of Iran',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6155,
        'Dabola 1981',
        'GEODETIC',
        7011,
        8901,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6156,
        'Jednotne Trigonometricke Site Katastralni',
        'GEODETIC',
        7004,
        8901,
        'Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6157,
        'Mount Dillon',
        'GEODETIC',
        7007,
        8901,
        'University of the West Indies Geodetic Services.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6158,
        'Naparima 1955',
        'GEODETIC',
        7022,
        8901,
        'Ordnance Survey International.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6159,
        'European Libyan Datum 1979',
        'GEODETIC',
        7022,
        8901,
        'Brown and Root',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6160,
        'Chos Malal 1914',
        'GEODETIC',
        7022,
        8901,
        'Various oil company records.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6161,
        'Pampa del Castillo',
        'GEODETIC',
        7022,
        8901,
        'Various oil company records.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6162,
        'Korean Datum 1985',
        'GEODETIC',
        7004,
        8901,
        'Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1999. http://www.asprs.org/resources.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6163,
        'Yemen National Geodetic Network 1996',
        'GEODETIC',
        7030,
        8901,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6164,
        'South Yemen',
        'GEODETIC',
        7024,
        8901,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6165,
        'Bissau',
        'GEODETIC',
        7022,
        8901,
        'NIMA TR8350.2',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6166,
        'Korean Datum 1995',
        'GEODETIC',
        7030,
        8901,
        'NIMA TR8350.2  ftp://164.214.2.65/pub/gg/tr8350.2/changes.pdf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6167,
        'New Zealand Geodetic Datum 2000',
        'GEODETIC',
        7019,
        8901,
        'Land Information New Zealand. http://www.linz.govt.nz/rcs/linz/pub/web/root/core/SurveySystem/GeodeticInfo/GeodeticDatums/nzgd2000factsheet/index.jsp',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6168,
        'Accra',
        'GEODETIC',
        7029,
        8901,
        'Ordnance Survey International',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6169,
        'American Samoa 1962',
        'GEODETIC',
        7008,
        8901,
        'NIMA TR8350.2 revision of January 2000. Oil industry sources for origin description details.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6170,
        'Sistema de Referencia Geocentrico para America del Sur',
        'GEODETIC',
        7019,
        8901,
        'NIMA TR8350.2 revision of January 2000.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6171,
        'Reseau Geodesique Francais 1993',
        'GEODETIC',
        7019,
        8901,
        'http://www.ign.fr/fr/PI/activites/geodesie/rgf93/RGF/rgf93.html via TotalFinaElf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6173;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6173,
        'IRENET95',
        'GEODETIC',
        7019,
        8901,
        'Ordnance Survey of Ireland',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6174,
        'Sierra Leone Colony 1924',
        'GEODETIC',
        7029,
        8901,
        'Ordnance Survey International.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6175,
        'Sierra Leone 1968',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey International.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6176,
        'Australian Antarctic Datum 1998',
        'GEODETIC',
        7019,
        8901,
        'Standards Australia',
        'ISO 19127',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6178,
        'Pulkovo 1942/83',
        'GEODETIC',
        7024,
        8901,
        'Bundesamt fur Kartographie und Geodasie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6179,
        'Pulkovo 1942/58',
        'GEODETIC',
        7024,
        8901,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6180,
        'Estonia 1997',
        'GEODETIC',
        7019,
        8901,
        'Estonian National Land Board via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6181,
        'Luxembourg 1930',
        'GEODETIC',
        7022,
        8901,
        'Administration du Cadastre et de la Topographie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6182,
        'Azores Occidental Islands 1939',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6183,
        'Azores Central Islands 1948',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/  Oil industry sources for origin description details.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6184,
        'Azores Oriental Islands 1940',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6185,
        'Madeira 1936',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6188,
        'OSNI 1952',
        'GEODETIC',
        7001,
        8901,
        'Ordnance Survey of Northern Ireland.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6189,
        'Red Geodesica Venezolana',
        'GEODETIC',
        7019,
        8901,
        'Servicio Autonomo de Geografia y Cartografia Nacional.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6190,
        'Posiciones Geodesicas Argentinas 1998',
        'GEODETIC',
        7019,
        8901,
        'http://www.igm.gov.ar/posgar.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6191,
        'Albanian 1987',
        'GEODETIC',
        7024,
        8901,
        'EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6192,
        'Douala 1948',
        'GEODETIC',
        7022,
        8901,
        'TotalFinaElf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6193,
        'Manoca 1962',
        'GEODETIC',
        7011,
        8901,
        'TotalFinaElf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6194,
        'Qornoq 1927',
        'GEODETIC',
        7022,
        8901,
        'Kort & Matrikelstyrelsen, Copenhagen. Origin coordinates from NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10096);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6195,
        'Scoresbysund 1952',
        'GEODETIC',
        7022,
        8901,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6196,
        'Ammassalik 1958',
        'GEODETIC',
        7022,
        8901,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6197,
        'Garoua',
        'GEODETIC',
        7012,
        8901,
        'TotalFinaElf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6198,
        'Kousseri',
        'GEODETIC',
        7012,
        8901,
        'TotalFinaElf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6199,
        'Egypt 1930',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6200,
        'Pulkovo 1995',
        'GEODETIC',
        7024,
        8901,
        '"Main Terms of Reference for the State Geodetic Network"; Federal Geodetic Service of Russia; 1994',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6201,
        'Adindan',
        'GEODETIC',
        7012,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10001);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6202,
        'Australian Geodetic Datum 1966',
        'GEODETIC',
        7003,
        8901,
        'Australian Map Grid Technical Manual. National Mapping Council of Australia Technical Publication 7; 1972.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10012);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6203,
        'Australian Geodetic Datum 1984',
        'GEODETIC',
        7003,
        8901,
        '"GDA technical manual v2_2", Intergovernmental Committee on Surveying and Mapping. www.anzlic.org.au/icsm/gdtm/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10013);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6204,
        'Ain el Abd 1970',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10003);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6205,
        'Afgooye',
        'GEODETIC',
        7024,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10002);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6206,
        'Agadez',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
select 'commit 9' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6207;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6207,
        'Lisbon 1937',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6208,
        'Aratu',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6209,
        'Arc 1950',
        'GEODETIC',
        7013,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10005);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6210,
        'Arc 1960',
        'GEODETIC',
        7012,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10006);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6211,
        'Batavia',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6212,
        'Barbados 1938',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6213,
        'Beduaram',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6214,
        'Beijing 1954',
        'GEODETIC',
        7024,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6215,
        'Reseau National Belge 1950',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6216,
        'Bermuda 1957',
        'GEODETIC',
        7008,
        8901,
        'Various oil industry sources.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10016);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6218,
        'Bogota 1975',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico Agustin Caduzzi (IGAC) special publication no. 1, 4th edition (1975) "Geodesia: Resultados Definitvos de Parte de las Redes Geodesicas Establecidas en el Pais".',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6219,
        'Bukit Rimpah',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6220,
        'Camacupa',
        'GEODETIC',
        7012,
        8901,
        'Clifford J. Mugnier, PE&RS journal, March 2001.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6221,
        'Campo Inchauspe',
        'GEODETIC',
        7022,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10019);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6222,
        'Cape',
        'GEODETIC',
        7013,
        8901,
        'Private Communication, Directorate of Surveys and Land Information, Cape Town.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10021);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6223,
        'Carthage',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6224,
        'Chua',
        'GEODETIC',
        7022,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6225,
        'Corrego Alegre',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10026);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6227,
        'Deir ez Zor',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6229,
        'Egypt 1907',
        'GEODETIC',
        7020,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6230,
        'European Datum 1950',
        'GEODETIC',
        7022,
        8901,
        'EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6231,
        'European Datum 1987',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10033);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6232,
        'Fahud',
        'GEODETIC',
        7012,
        8901,
        'Petroleum Development Oman.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6233,
        'Gandajika 1970',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6235,
        'Guyane Francaise',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6236,
        'Hu Tzu Shan',
        'GEODETIC',
        7022,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10043);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6237,
        'Hungarian Datum 1972',
        'GEODETIC',
        7036,
        8901,
        'http://lazarus.elte.hu/gb/geodez/geod3.htm',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6238;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6238,
        'Indonesian Datum 1974',
        'GEODETIC',
        7021,
        8901,
        'Bakosurtanal 1979 paper by Jacob Rais.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6239,
        'Indian 1954',
        'GEODETIC',
        7015,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6240,
        'Indian 1975',
        'GEODETIC',
        7015,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6241,
        'Jamaica 1875',
        'GEODETIC',
        7034,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6242,
        'Jamaica 1969',
        'GEODETIC',
        7008,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6243,
        'Kalianpur 1880',
        'GEODETIC',
        7042,
        8901,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6244,
        'Kandawala',
        'GEODETIC',
        7015,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10049);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6245,
        'Kertau',
        'GEODETIC',
        7018,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6246,
        'Kuwait Oil Company',
        'GEODETIC',
        7012,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6247,
        'La Canoa',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6248,
        'Provisional South American Datum 1956',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10092);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6249,
        'Lake',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6250,
        'Leigon',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey International',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6251,
        'Liberia 1964',
        'GEODETIC',
        7012,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10053);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6252,
        'Lome',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6253,
        'Luzon 1911',
        'GEODETIC',
        7008,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6254,
        'Hito XVIII 1963',
        'GEODETIC',
        7022,
        8901,
        'Various oil company records.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10040);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6255,
        'Herat North',
        'GEODETIC',
        7022,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6256,
        'Mahe 1971',
        'GEODETIC',
        7012,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10057);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6257,
        'Makassar',
        'GEODETIC',
        7004,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6258,
        'European Terrestrial Reference System 1989',
        'GEODETIC',
        7019,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6259,
        'Malongo 1987',
        'GEODETIC',
        7022,
        8901,
        'Chevron Petroleum Technology.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6261,
        'Merchich',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10061);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6262,
        'Massawa',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10059);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6263,
        'Minna',
        'GEODETIC',
        7012,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10063);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6264,
        'Mhast',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6265,
        'Monte Mario',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6266,
        'M''poraloko',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6267;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6267,
        'North American Datum 1927',
        'GEODETIC',
        7008,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6268,
        'NAD Michigan',
        'GEODETIC',
        7009,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6269,
        'North American Datum 1983',
        'GEODETIC',
        7019,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6270,
        'Nahrwan 1967',
        'GEODETIC',
        7012,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6271,
        'Naparima 1972',
        'GEODETIC',
        7022,
        8901,
        'Ordnance Survey International.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6272,
        'New Zealand Geodetic Datum 1949',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6273,
        'NGO 1948',
        'GEODETIC',
        7005,
        8901,
        'EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6274,
        'Datum 73',
        'GEODETIC',
        7022,
        8901,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6275,
        'Nouvelle Triangulation Francaise',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6276,
        'NSWC 9Z-2',
        'GEODETIC',
        7025,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6277,
        'OSGB 1936',
        'GEODETIC',
        7001,
        8901,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6278,
        'OSGB 1970 (SN)',
        'GEODETIC',
        7001,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6279,
        'OS (SN) 1980',
        'GEODETIC',
        7001,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6280,
        'Padang 1884',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6281,
        'Palestine 1923',
        'GEODETIC',
        7010,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6282,
        'Congo 1960 Pointe Noire',
        'GEODETIC',
        7011,
        8901,
        'Elf',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6283,
        'Geocentric Datum of Australia 1994',
        'GEODETIC',
        7019,
        8901,
        'Australian Surveying and Land Information Group Internet WWW page. http://www.auslig.gov.au/geodesy/datums/gda.htm#specs',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        30001131,
        'Lithuanian Pulkovo 1942',
        'GEODETIC',
        7024,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6284,
        'Pulkovo 1942',
        'GEODETIC',
        7024,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10094);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6285,
        'Qatar 1974',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6286,
        'Qatar 1948',
        'GEODETIC',
        7020,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6288,
        'Loma Quintana',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6289,
        'Amersfoort',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6291,
        'South American Datum 1969',
        'GEODETIC',
        7036,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10104);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6292,
        'Sapper Hill 1943',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10102);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6293,
        'Schwarzeck',
        'GEODETIC',
        7046,
        8901,
        'Private Communication, Directorate of Surveys and Land Information, Cape Town.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10103);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6294,
        'Segora',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6295,
        'Serindung',
        'GEODETIC',
        7004,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6296,
        'Sudan',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6297;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6297,
        'Tananarive 1925',
        'GEODETIC',
        7022,
        8901,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6298,
        'Timbalai 1948',
        'GEODETIC',
        7016,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10108);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6299,
        'TM65',
        'GEODETIC',
        7002,
        8901,
        '"The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6300,
        'Geodetic Datum of 1965',
        'GEODETIC',
        7002,
        8901,
        '"The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6301,
        'Tokyo',
        'GEODETIC',
        7004,
        8901,
        'Geographic Survey Institute; Japan; Bulletin 40 (March 1994).  Also http://vldb.gsi.go.jp/sokuchi/datum/tokyodatum.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10109);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6302,
        'Trinidad 1903',
        'GEODETIC',
        7007,
        8901,
        'Clifford J. Mugnier, PE&RS November 2000.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6303,
        'Trucial Coast 1948',
        'GEODETIC',
        7020,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6304,
        'Voirol 1875',
        'GEODETIC',
        7011,
        8901,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6306,
        'Bern 1938',
        'GEODETIC',
        7004,
        8901,
        '"Die Projektionen der schweizerischen Plan- und Kartenwerke"; J. Bolliger 1967',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6307,
        'Nord Sahara 1959',
        'GEODETIC',
        7012,
        8901,
        '"Le System Geodesique Nord-Sahara"; IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6308,
        'Stockholm 1938',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6309,
        'Yacare',
        'GEODETIC',
        7022,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10117);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6310,
        'Yoff',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6311,
        'Zanderij',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        10118);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6312,
        'Militar-Geographische Institut',
        'GEODETIC',
        7004,
        8901,
        'Bundesamt fur Eich- und Vermessungswesen; Wien',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6313,
        'Reseau National Belge 1972',
        'GEODETIC',
        7022,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6314,
        'Deutsches Hauptdreiecksnetz',
        'GEODETIC',
        7004,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6315,
        'Conakry 1905',
        'GEODETIC',
        7011,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6316,
        'Dealul Piscului 1933',
        'GEODETIC',
        7022,
        8901,
        'Institute for Geodesy Photogrametry and Land Management',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6317,
        'Dealul Piscului 1970',
        'GEODETIC',
        7024,
        8901,
        'Institute for Geodesy Photogrametry and Land Management',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6318,
        'National Geodetic Network',
        'GEODETIC',
        7030,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6319,
        'Kuwait Utility',
        'GEODETIC',
        7019,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6322,
        'World Geodetic System 1972',
        'GEODETIC',
        7043,
        8901,
        'NIMA http://earth-info.nima.mil/GandG/historic/hdatums.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6324,
        'WGS 72 Transit Broadcast Ephemeris',
        'GEODETIC',
        7043,
        8901,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6326,
        'World Geodetic System 1984',
        'GEODETIC',
        7030,
        8901,
        'NIMA TR8350.2 January 2000 revision. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6600,
        'Anguilla 1957',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6601,
        'Antigua 1943',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6602,
        'Dominica 1945',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6603,
        'Grenada 1953',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6604;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6604,
        'Montserrat 1958',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6605,
        'St. Kitts 1955',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6606,
        'St. Lucia 1955',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6607,
        'St. Vincent 1945',
        'GEODETIC',
        7012,
        8901,
        'Ordnance Survey of Great Britain.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6608,
        'North American Datum 1927 (1976)',
        'GEODETIC',
        7008,
        8901,
        'Geodetic Survey of Canada.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6609,
        'North American Datum 1927 (CGQ77)',
        'GEODETIC',
        7008,
        8901,
        'Geodetic Service of Quebec.  Contact alain.bernard@mrn.gouv.qc.ca',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6610,
        'Xian 1980',
        'GEODETIC',
        7049,
        8901,
        'BP',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6801,
        'CH1903 (Bern)',
        'GEODETIC',
        7004,
        8907,
        'Bundesamt fur Landestopographie',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6802,
        'Bogota 1975 (Bogota)',
        'GEODETIC',
        7022,
        8904,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6803,
        'Lisbon 1937 (Lisbon)',
        'GEODETIC',
        7022,
        8902,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6804,
        'Makassar (Jakarta)',
        'GEODETIC',
        7004,
        8908,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6805,
        'Militar-Geographische Institut (Ferro)',
        'GEODETIC',
        7004,
        8909,
        'Bundesamt fur Eich- und Vermessungswesen; Wien',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6806,
        'Monte Mario (Rome)',
        'GEODETIC',
        7022,
        8906,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6807,
        'Nouvelle Triangulation Francaise (Paris)',
        'GEODETIC',
        7011,
        8903,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6808,
        'Padang 1884 (Jakarta)',
        'GEODETIC',
        7004,
        8908,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6809,
        'Reseau National Belge 1950 (Brussels)',
        'GEODETIC',
        7022,
        8910,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6810,
        'Tananarive 1925 (Paris)',
        'GEODETIC',
        7022,
        8903,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6811,
        'Voirol 1875 (Paris)',
        'GEODETIC',
        7011,
        8903,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6813,
        'Batavia (Jakarta)',
        'GEODETIC',
        7004,
        8908,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6814,
        'Stockholm 1938 (Stockholm)',
        'GEODETIC',
        7004,
        8911,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6815,
        'Greek (Athens)',
        'GEODETIC',
        7004,
        8912,
        'Topography Department; National Technical University of Athens',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6816,
        'Carthage (Paris)',
        'GEODETIC',
        7011,
        8903,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6817,
        'NGO 1948 (Oslo)',
        'GEODETIC',
        7005,
        8913,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6818,
        'S-JTSK (Ferro)',
        'GEODETIC',
        7004,
        8909,
        'Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6819,
        'Nord Sahara 1959 (Paris)',
        'GEODETIC',
        7012,
        8903,
        '"Le System Geodesique Nord-Sahara"; IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6901,
        'Ancienne Triangulation Francaise (Paris)',
        'GEODETIC',
        7027,
        8903,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6902,
        'Nord de Guerre (Paris)',
        'GEODETIC',
        7027,
        8903,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        6903,
        'Madrid 1870 (Madrid)',
        'GEODETIC',
        7028,
        8905,
        'Institut de Geomatica; Barcelona',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9300,
        'Astra Minas',
        'ENGINEERING',
        NULL,
        NULL,
        NULL,
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9301,
        'Barcelona',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
select 'commit 10' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS WHERE DATUM_ID = 9302;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9302,
        'Maturin',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9303,
        'Maracaibo Cross',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9304,
        'La Rosa',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9305,
        'Mene Grande',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9306,
        'El Cubo',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9307,
        'Dabajuro',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9308,
        'Tucupita',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9309,
        'El Mene',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9310,
        'Santa Maria de Ipire',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9311,
        'Barinas west base',
        'ENGINEERING',
        NULL,
        NULL,
        'Ministry of Mines standards manual, 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9312,
        'EPSG example  X',
        'ENGINEERING',
        NULL,
        NULL,
        'UKOOA P6/98 documentation',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        9313,
        'EPSG example Platform Y',
        'ENGINEERING',
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10001,
        'Adindan',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -162,
        -12,
        206,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10002,
        'Afgooye',
        'GEODETIC',
        8031,
        8950,
        NULL,
        NULL,
        -43,
        -163,
        45,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10003,
        'Ain el Abd 1970',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -150,
        -251,
        -2,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10004,
        'Anna 1 Astro 1965',
        'GEODETIC',
        8003,
        8950,
        NULL,
        NULL,
        -491,
        -22,
        435,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10005,
        'Arc 1950',
        'GEODETIC',
        8011,
        8950,
        NULL,
        NULL,
        -143,
        -90,
        -294,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10006,
        'Arc 1960',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -160,
        -8,
        -300,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10007,
        'Ascension Island 1958',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -207,
        107,
        52,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10008,
        'Astro B4 Sorol Atoll',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        114,
        -116,
        -333,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10009,
        'Astro Beacon E',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        145,
        75,
        -272,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10010,
        'Astro DOS 71/4',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -320,
        550,
        -494,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10011,
        'Astronomic Station 1952',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        124,
        -234,
        -25,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10012,
        'Australian Geodetic 1966',
        'GEODETIC',
        8003,
        8950,
        NULL,
        NULL,
        -133,
        -48,
        148,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10013,
        'Australian Geodetic 1984',
        'GEODETIC',
        8003,
        8950,
        NULL,
        NULL,
        -134,
        -48,
        149,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10014,
        'Belgium Hayford',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        81,
        120,
        129,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 10015;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10015,
        'Bellevue (IGN)',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -127,
        -769,
        472,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10016,
        'Bermuda 1957',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -73,
        213,
        296,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10017,
        'Bogota Observatory',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        307,
        304,
        -318,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10018,
        'CH 1903 (Switzerland)',
        'GEODETIC',
        8004,
        8950,
        NULL,
        NULL,
        660.077,
        13.551,
        369.344,
        .804816,
        .577692,
        .952236,
        5.66,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10019,
        'Campo Inchauspe',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -148,
        136,
        90,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10020,
        'Canton Astro 1966',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        298,
        -304,
        -375,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10021,
        'Cape',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -136,
        -108,
        -292,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10022,
        'Cape Canaveral',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -2,
        150,
        181,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10023,
        'Carthage',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -263,
        6,
        431,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10024,
        'Chatham 1971',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        175,
        -38,
        113,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10025,
        'Chua Astro',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -134,
        229,
        -29,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10026,
        'Corrego Alegre',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -206,
        172,
        -6,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10027,
        'DHDN (Potsdam/Rauenberg)',
        'GEODETIC',
        NULL,
        8950,
        NULL,
        NULL,
        582,
        105,
        414,
        -1.04,
        -.35,
        3.08,
        8.3,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10028,
        'DOS 1968',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        230,
        -199,
        -752,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10029,
        'Djakarta (Batavia)',
        'GEODETIC',
        NULL,
        8950,
        NULL,
        NULL,
        -377,
        681,
        -50,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10030,
        'Easter Island 1967',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        211,
        147,
        111,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10031,
        'European 1950',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -87,
        -98,
        -121,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10032,
        'European 1979',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -86,
        -98,
        -119,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10033,
        'European 1987',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -83,
        -96,
        -113,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10034,
        'GRS 67',
        'GEODETIC',
        8023,
        8950,
        NULL,
        NULL,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10035,
        'GRS 80',
        'GEODETIC',
        8024,
        8950,
        NULL,
        NULL,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10036,
        'GUX 1 Astro',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        252,
        -209,
        -751,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10037,
        'Gandajika Base',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -133,
        -321,
        50,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10038,
        'Geodetic Datum 1949',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        84,
        -22,
        209,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10039,
        'Guam 1963',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -100,
        -248,
        259,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10040,
        'Hito XVIII 1963',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        16,
        196,
        93,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10041,
        'Hjorsey 1955',
        'GEODETIC',
        NULL,
        8950,
        NULL,
        NULL,
        -73,
        46,
        -86,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10042,
        'Hong Kong 1963',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -156,
        -271,
        -189,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 10043;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10043,
        'Hu-Tzu-Shan',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -634,
        -549,
        -201,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10044,
        'ISTS 073 Astro 1969',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        208,
        -435,
        -229,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10045,
        'Indian (Bangladesh, etc.)',
        'GEODETIC',
        8016,
        8950,
        NULL,
        NULL,
        289,
        734,
        257,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10046,
        'Indian (Thailand/Vietnam)',
        'GEODETIC',
        8016,
        8950,
        NULL,
        NULL,
        214,
        836,
        303,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10047,
        'Ireland 1965',
        'GEODETIC',
        8002,
        8950,
        NULL,
        NULL,
        506,
        -122,
        611,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10048,
        'Johnston Island 1961',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        191,
        -77,
        -204,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10049,
        'Kandawala',
        'GEODETIC',
        8016,
        8950,
        NULL,
        NULL,
        -97,
        787,
        86,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10050,
        'Kerguelen Island',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        145,
        -187,
        103,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10051,
        'Kertau 1948',
        'GEODETIC',
        8018,
        8950,
        NULL,
        NULL,
        -11,
        851,
        5,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10052,
        'L.C. 5 Astro',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        42,
        124,
        147,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10053,
        'Liberia 1964',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -90,
        40,
        88,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10054,
        'Lisboa (DLx)',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -303,
        -62,
        105,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10055,
        'Luzon (Mindanao Island)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -133,
        -79,
        -72,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10056,
        'Luzon (Philippines)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -133,
        -77,
        -51,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10057,
        'Mahe 1971',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        41,
        -220,
        -134,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10058,
        'Marco Astro',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -289,
        -124,
        60,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10059,
        'Massawa',
        'GEODETIC',
        8004,
        8950,
        NULL,
        NULL,
        639,
        405,
        60,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10060,
        'Melrica 1973 (D73)',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -223,
        110,
        37,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10061,
        'Merchich',
        'GEODETIC',
        8014,
        8950,
        NULL,
        NULL,
        31,
        146,
        47,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10062,
        'Midway Astro 1961',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        912,
        -58,
        1227,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10063,
        'Minna',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -92,
        -93,
        122,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10064,
        'NAD 27 (Alaska)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -5,
        135,
        172,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10065,
        'NAD 27 (Bahamas)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -4,
        154,
        178,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10066,
        'NAD 27 (Canada)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -10,
        158,
        187,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10067,
        'NAD 27 (Canal Zone)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        0,
        125,
        201,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10068,
        'NAD 27 (Caribbean)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -7,
        152,
        178,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10069,
        'NAD 27 (Central America)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        0,
        125,
        194,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10070,
        'NAD 27 (Continental US)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -8,
        160,
        176,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 10071;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10071,
        'NAD 27 (Cuba)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        -9,
        152,
        178,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10072,
        'NAD 27 (Greenland)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        11,
        114,
        195,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10073,
        'NAD 27 (Mexico)',
        'GEODETIC',
        NULL,
        8950,
        NULL,
        NULL,
        -12,
        130,
        190,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10074,
        'NAD 27 (Michigan)',
        'GEODETIC',
        8009,
        8950,
        NULL,
        NULL,
        -8,
        160,
        176,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10075,
        'NAD 27 (San Salvador)',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        1,
        140,
        165,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10076,
        'NAD 83',
        'GEODETIC',
        8024,
        8950,
        NULL,
        NULL,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10077,
        'NTF (Greenwich meridian)',
        'GEODETIC',
        8012,
        8950,
        NULL,
        NULL,
        -168,
        -60,
        320,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10078,
        'NTF (Paris meridian)',
        'GEODETIC',
        8012,
        8903,
        NULL,
        NULL,
        -168,
        -60,
        320,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10079,
        'NWGL 10',
        'GEODETIC',
        8044,
        8950,
        NULL,
        NULL,
        -1,
        15,
        1,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10080,
        'Nahrwan (Masirah Island)',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -247,
        -148,
        369,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10081,
        'Nahrwan (Saudi Arabia)',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -231,
        -196,
        482,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10082,
        'Nahrwan (Un. Arab Emirates)',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -249,
        -156,
        381,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10083,
        'Naparima, BWI',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -2,
        374,
        172,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10084,
        'Netherlands Bessel',
        'GEODETIC',
        8004,
        8950,
        NULL,
        NULL,
        593,
        26,
        478,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10085,
        'Observatorio 1966',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -425,
        -169,
        81,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10086,
        'Old Egyptian',
        'GEODETIC',
        8026,
        8950,
        NULL,
        NULL,
        -130,
        110,
        -13,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10087,
        'Old Hawaiian',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        61,
        -285,
        -181,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10088,
        'Oman',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        -346,
        -1,
        224,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10089,
        'Ordnance Survey Great Brit',
        'GEODETIC',
        8001,
        8950,
        NULL,
        NULL,
        375,
        -111,
        431,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10090,
        'Pico de las Nieves',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -307,
        -92,
        127,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10091,
        'Pitcairn Astro 1967',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        185,
        165,
        42,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10092,
        'Provisional South American',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -288,
        175,
        -376,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10093,
        'Puerto Rico',
        'GEODETIC',
        8008,
        8950,
        NULL,
        NULL,
        11,
        72,
        -101,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10094,
        'Pulkovo 1942',
        'GEODETIC',
        8031,
        8950,
        NULL,
        NULL,
        24,
        -123,
        -94,
        -.02,
        .25,
        .13,
        1.1,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10095,
        'Qatar National',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -128,
        -283,
        22,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10096,
        'Qornoq',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        164,
        138,
        -189,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10097,
        'RT 90 (Sweden)',
        'GEODETIC',
        8004,
        8950,
        NULL,
        NULL,
        498,
        -36,
        568,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10098,
        'Reunion',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        94,
        -948,
        -1262,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 10099;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10099,
        'Rome 1940',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -225,
        -65,
        9,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10100,
        'Santo (DOS)',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        170,
        42,
        84,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10101,
        'Sao Braz',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -203,
        141,
        53,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10102,
        'Sapper Hill 1943',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -355,
        16,
        74,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10103,
        'Schwarzeck',
        'GEODETIC',
        8006,
        8950,
        NULL,
        NULL,
        616,
        97,
        -251,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10104,
        'South American 1969',
        'GEODETIC',
        8039,
        8950,
        NULL,
        NULL,
        -57,
        1,
        -41,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10105,
        'South Asia',
        'GEODETIC',
        8021,
        8950,
        NULL,
        NULL,
        7,
        -10,
        -26,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10106,
        'Southeast Base',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -499,
        -249,
        314,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10107,
        'Southwest Base',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -104,
        167,
        -38,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10108,
        'Timbalai 1948',
        'GEODETIC',
        8016,
        8950,
        NULL,
        NULL,
        -689,
        691,
        -46,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10109,
        'Tokyo',
        'GEODETIC',
        8004,
        8950,
        NULL,
        NULL,
        -128,
        481,
        664,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10110,
        'Tristan Astro 1968',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -632,
        438,
        -609,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10111,
        'Viti Levu 1916',
        'GEODETIC',
        8010,
        8950,
        NULL,
        NULL,
        51,
        391,
        -36,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10112,
        'WGS 60',
        'GEODETIC',
        8042,
        8950,
        NULL,
        NULL,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10113,
        'WGS 66',
        'GEODETIC',
        8043,
        8950,
        NULL,
        NULL,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10114,
        'WGS 72',
        'GEODETIC',
        8044,
        8950,
        NULL,
        NULL,
        0,
        8,
        10,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10115,
        'WGS 84',
        'GEODETIC',
        8045,
        8950,
        NULL,
        NULL,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10116,
        'Wake-Eniwetok 1960',
        'GEODETIC',
        8027,
        8950,
        NULL,
        NULL,
        101,
        52,
        -39,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10117,
        'Yacare',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -155,
        171,
        37,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        10118,
        'Zanderij',
        'GEODETIC',
        8030,
        8950,
        NULL,
        NULL,
        -265,
        120,
        -358,
        0,
        0,
        0,
        0,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20001,
        'NAD 83 (Alaska)',
        'GEODETIC',
        8024,
        8950,
        'legacy WKT',
        'legacy WKT',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20002,
        'European 1950 (Denmark)',
        'GEODETIC',
        8030,
        8950,
        'legacy WKT',
        'legacy WKT',
        -81.0703,
        -89.3603,
        -115.7526,
        .48488,
        .02436,
        .41321,
        -.540645,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20004,
        'ETRS 89',
        'GEODETIC',
        8024,
        8950,
        'legacy WKT',
        'legacy WKT',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20005,
        'GDA 94',
        'GEODETIC',
        8024,
        8950,
        'legacy WKT',
        'legacy WKT',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20006,
        'NAD 83 (Continental US)',
        'GEODETIC',
        8024,
        8950,
        'legacy WKT',
        'legacy WKT',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20007,
        'New AGD 84',
        'GEODETIC',
        8003,
        8950,
        'legacy WKT',
        'legacy WKT',
        -117.76,
        -51.51,
        139.06,
        -.29,
        -.44,
        -.28,
        -.19,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20008,
        'AGD 66 NT',
        'GEODETIC',
        8003,
        8950,
        'legacy WKT',
        'legacy WKT',
        -124.13,
        -42,
        137.4,
        .01,
        -.56,
        -.18,
        -1.85,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20009,
        'AGD 66 VIC NSW',
        'GEODETIC',
        8003,
        8950,
        'legacy WKT',
        'legacy WKT',
        -119.35,
        -48.3,
        139.48,
        -.42,
        -.26,
        -.44,
        -.61,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20010,
        'AGD 66 TAS',
        'GEODETIC',
        8003,
        8950,
        'legacy WKT',
        'legacy WKT',
        -120.27,
        -64.54,
        161.63,
        -.22,
        -.07,
        .13,
        2.5,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20011,
        'AGD 66 ACT',
        'GEODETIC',
        8003,
        8950,
        'legacy WKT',
        'legacy WKT',
        -129.19,
        -41.21,
        130.73,
        -.25,
        -.37,
        -.33,
        -2.96,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20012,
        'UnitSphere',
        'GEODETIC',
        8100,
        NULL,
        'legacy WKT',
        'legacy WKT',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (
        20013,
        'Mars',
        'GEODETIC',
        8101,
        8951,
        'legacy WKT',
        'legacy WKT',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'TRUE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5107, 'Nivellement general de la France','VERTICAL',
        Null, Null,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
select 'commit 11' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS WHERE DATUM_ID = 5135;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5135, 'Hong Kong Principal Datum',
        'VERTICAL',
        Null, Null,
        'Survey and Mapping Office, Lands Department. Http://www.info.gov.hk/landsd/mapping/tindex.htm',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5136, 'Hong Kong Chart Datum',
        'VERTICAL',
        Null, Null,
        'Survey and Mapping Office, Lands Department. Http://www.info.gov.hk/landsd/mapping/tindex.htm',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5137, 'Yellow Sea 1985',
        'VERTICAL',
        Null, Null,
        'Guangdong Province Land Resource Information Centre',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5138, 'Ordnance Datum Newlyn (Orkney Isles)',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5139, 'Fair Isle',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5140, 'Lerwick',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5141, 'Foula',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5142, 'Sule Skerry',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5143, 'North Rona',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5144, 'Stornoway',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5145, 'St. Kilda',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5146, 'Flannan Isles',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5147, 'St. Marys',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5148, 'Douglas',
        'VERTICAL',
        Null, Null,
        'Ordnance Survey of Great Britain',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5149, 'Fao',
        'VERTICAL',
        Null, Null,
        'National Iranian Oil Company (NIOC).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5150, 'Bandar Abbas',
        'VERTICAL',
        Null, Null,
        'National Cartographic Centre of Iran',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5151, 'Nivellement General Nouvelle Caledonie',
        'VERTICAL',
        Null, Null,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5152, 'Poolbeg',
        'VERTICAL',
        Null, Null,
        '"The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5153, 'Nivellement General Guyanais 1977',
        'VERTICAL',
        Null, Null,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5154, 'IGN 1987',
        'VERTICAL',
        Null, Null,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5155, 'IGN 1988',
        'VERTICAL',
        Null, Null,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (5156, 'IGN 1989',
        'VERTICAL',
        Null, Null,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6001, 'Not specified (based on Airy 1830 ellipsoid)',
        'GEODETIC',
        7001, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6002, 'Not specified (based on Airy Modified 1849 ellipsoid)',
        'GEODETIC',
        7002, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6003, 'Not specified (based on Australian National Spheroid)',
        'GEODETIC',
        7003, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6004, 'Not specified (based on Bessel 1841 ellipsoid)',
        'GEODETIC',
        7004, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6005;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6005, 'Not specified (based on Bessel Modified ellipsoid)',
        'GEODETIC',
        7005, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6006, 'Not specified (based on Bessel Namibia ellipsoid)',
        'GEODETIC',
        7046, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6007, 'Not specified (based on Clarke 1858 ellipsoid)',
        'GEODETIC',
        7007, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6008, 'Not specified (based on Clarke 1866 ellipsoid)',
        'GEODETIC',
        7008, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6009, 'Not specified (based on Clarke 1866 Michigan ellipsoid)',
        'GEODETIC',
        7009, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6010, 'Not specified (based on Clarke 1880 (Benoit) ellipsoid)',
        'GEODETIC',
        7010, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6011, 'Not specified (based on Clarke 1880 (IGN) ellipsoid)',
        'GEODETIC',
        7011, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6012, 'Not specified (based on Clarke 1880 (RGS) ellipsoid)',
        'GEODETIC',
        7012, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6013, 'Not specified (based on Clarke 1880 (Arc) ellipsoid)',
        'GEODETIC',
        7013, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6014, 'Not specified (based on Clarke 1880 (SGA 1922) ellipsoid)',
        'GEODETIC',
        7014, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6015, 'Not specified (based on Everest 1830 (1937 Adjustment) ellipsoid)',
        'GEODETIC',
        7015, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6016, 'Not specified (based on Everest 1830 (1967 Definition) ellipsoid)',
        'GEODETIC',
        7016, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6018, 'Not specified (based on Everest 1830 Modified ellipsoid)',
        'GEODETIC',
        7018, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6019, 'Not specified (based on GRS 1980 ellipsoid)',
        'GEODETIC',
        7019, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6020, 'Not specified (based on Helmert 1906 ellipsoid)',
        'GEODETIC',
        7020, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6021, 'Not specified (based on Indonesian National Spheroid)',
        'GEODETIC',
        7021, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6022, 'Not specified (based on International 1924 ellipsoid)',
        'GEODETIC',
        7022, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6024, 'Not specified (based on Krassowsky 1940 ellipsoid)',
        'GEODETIC',
        7024, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6025, 'Not specified (based on NWL 9D ellipsoid)',
        'GEODETIC',
        7025, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6027, 'Not specified (based on Plessis 1817 ellipsoid)',
        'GEODETIC',
        7027, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6028, 'Not specified (based on Struve 1860 ellipsoid)',
        'GEODETIC',
        7028, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6029, 'Not specified (based on War Office ellipsoid)',
        'GEODETIC',
        7029, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6030, 'Not specified (based on WGS 84 ellipsoid)',
        'GEODETIC',
        7030, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6031, 'Not specified (based on GEM 10C ellipsoid)',
        'GEODETIC',
        7031, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6032, 'Not specified (based on OSU86F ellipsoid)',
        'GEODETIC',
        7032, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6033, 'Not specified (based on OSU91A ellipsoid)',
        'GEODETIC',
        7033, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6034, 'Not specified (based on Clarke 1880 ellipsoid)',
        'GEODETIC',
        7034, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6035, 'Not specified (based on Authalic Sphere)',
        'GEODETIC',
        7035, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6036, 'Not specified (based on GRS 1967 ellipsoid)',
        'GEODETIC',
        7036, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6041, 'Not specified (based on Average Terrestrial System 1977 ellipsoid)',
        'GEODETIC',
        7041, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6042, 'Not specified (based on Everest (1830 Definition) ellipsoid)',
        'GEODETIC',
        7042, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6043;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6043, 'Not specified (based on WGS 72 ellipsoid)',
        'GEODETIC',
        7043, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6044, 'Not specified (based on Everest 1830 (1962 Definition) ellipsoid)',
        'GEODETIC',
        7044, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6045, 'Not specified (based on Everest 1830 (1975 Definition) ellipsoid)',
        'GEODETIC',
        7045, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6047, 'Not specified (based on GRS 1980 Authalic Sphere)',
        'GEODETIC',
        7047, 8901,
        'EPSG',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6172, 'Posiciones Geodesicas Argentinas',
        'GEODETIC',
        7019, 8901,
        'http://www.igm.gov.ar/posgar.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6226, 'Cote d''Ivoire',
        'GEODETIC',
        7011, 8901,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6228, 'Douala',
        'GEODETIC',
        7011, 8901,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6234, 'Garoua',
        'GEODETIC',
        7011, 8901,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6260, 'Manoca',
        'GEODETIC',
        7012, 8901,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6287, 'Qornoq',
        'GEODETIC',
        7022, 8901,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6611, 'Hong Kong 1980',
        'GEODETIC',
        7022, 8901,
        'Survey and Mapping Office, Lands Department. http://www.info.gov.hk/landsd/mapping/tindex.htm',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6612, 'Japanese Geodetic Datum 2000',
        'GEODETIC',
        7019, 8901,
        'Japanese Survey Federation and Geographical Survey Institute http://www.gsi.go.jp/ENGLISH/RESEARCH/BULLETIN/vol-45/45abst1.htm',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6613, 'Gunung Segara',
        'GEODETIC',
        7004, 8901,
        'TotalFinaElf.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6614, 'Qatar National Datum 1995',
        'GEODETIC',
        7022, 8901,
        'Qatar Centre for Geographic Information.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6615, 'Porto Santo 1936',
        'GEODETIC',
        7022, 8901,
        'Instituto Geografico e Cadastral Lisbon http://www.igeo.pt',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6616, 'Selvagem Grande',
        'GEODETIC',
        7022, 8901,
        'Instituto Geografico e Cadastral Lisbon http://www.igeo.pt',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6618, 'South American Datum 1969',
        'GEODETIC',
        7050, 8901,
        'DMA 1974.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6619, 'SWEREF99',
        'GEODETIC',
        7019, 8901,
        'National Land Survey of Sweden http://www.lantmateriet.se',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6620, 'Point 58',
        'GEODETIC',
        7012, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6621, 'Fort Marigot',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6622, 'Sainte Anne',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6623, 'Centre Spatial Guyanais 1967',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6624, 'Reseau Geodesique Francais Guyane 1995',
        'GEODETIC',
        7019, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6625, 'Fort Desaix',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6626, 'Piton des Neiges',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6627, 'Reseau Geodesique de la Reunion 1992',
        'GEODETIC',
        7019, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6628, 'Tahiti',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6629, 'Tahaa',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6630, 'IGN72 Nuku Hiva',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6631, 'K0 1949',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6632, 'Combani 1950',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_DATUMS where datum_id = 6633;
  if(rec_count = 0) then

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6633, 'IGN56 Lifou',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6634, 'IGN72 Grande Terre',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6635, 'ST87 Ouvea',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6636, 'Petrels 1972',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6637, 'Pointe Geologie Perroud 1950',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6638, 'Saint Pierre et Miquelon 1950',
        'GEODETIC',
        7008, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6639, 'MOP78',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6640, 'Reseau de Reference des Antilles Francaises 1991',
        'GEODETIC',
        7030, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6641, 'IGN53 Mare',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6642, 'ST84 Ile des Pins',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6643, 'ST71 Belep',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6644, 'NEA74 Noumea',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6645, 'Reseau Geodesique Nouvelle Caledonie 1991',
        'GEODETIC',
        7022, 8901,
        'Service Topographique de la Nouvelle Caledonie.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6646, 'Grand Comoros',
        'GEODETIC',
        7022, 8901,
        'IGN Paris.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6647, 'IERS Terrestrial Reference Frame 1988',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Annual Report for 1988. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6648, 'IERS Terrestrial Reference Frame 1989',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 6. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6649, 'IERS Terrestrial Reference Frame 1990',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 9. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6650, 'IERS Terrestrial Reference Frame 1991',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 12. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6651, 'IERS Terrestrial Reference Frame 1992',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 15. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6652, 'IERS Terrestrial Reference Frame 1993',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 18. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6653, 'IERS Terrestrial Reference Frame 1994',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 20. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6654, 'IERS Terrestrial Reference Frame 1996',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 24. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6655, 'IERS Terrestrial Reference Frame 1997',
        'GEODETIC',
        7019, 8901,
        'International Earth Rotation Service (IERS) Technical Note No. 27. Also IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6656, 'IERS Terrestrial Reference Frame 2000',
        'GEODETIC',
        7019, 8901,
        'IGN Paris http://lareg.ensg.ign.fr/ITRF',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6657, 'Reykjavik 1900',
        'GEODETIC',
        7051, 8901,
        'Landmaelingar Islands (National Survey of Iceland).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6658, 'Hjorsey 1955',
        'GEODETIC',
        7022, 8901,
        'Landmaelingar Islands (National Survey of Iceland).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6659, 'Islands Network 1993',
        'GEODETIC',
        7019, 8901,
        'Landmaelingar Islands (National Survey of Iceland).',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6660, 'Helle 1954',
        'GEODETIC',
        7022, 8901,
        'Statens kartverk.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6661, 'Latvia 1992',
        'GEODETIC',
        7019, 8901,
        'Latvijas Republikas Valsts zemes dienests (State Land Service of the Republic of Latvia) via EuroGeographics. http://crs.ifag.de',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6663, 'Porto Santo 1995',
        'GEODETIC',
        7022, 8901,
        'Instituto Geografico e Cadastral Lisbon; http://www.igeo.pt/IGEO/portugues/Frameset-produtos.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6664, 'Azores Oriental Islands 1995',
        'GEODETIC',
        7022, 8901,
        'Instituto Geografico e Cadastral Lisbon; http://www.igeo.pt/IGEO/portugues/Frameset-produtos.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6665, 'Azores Central Islands 1995',
        'GEODETIC',
        7022, 8901,
        'Instituto Geografico e Cadastral Lisbon; http://www.igeo.pt/IGEO/portugues/Frameset-produtos.html',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6666, 'Lisbon 1890',
        'GEODETIC',
        7004, 8901,
        'Instituto Geografico e Cadastral Lisbon http://www.igeo.pt',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6667, 'Iraq-Kuwait Boundary Datum 1992',
        'GEODETIC',
        7030, 8901,
        'United Nations Iraq-Kuwait Boundary Demarcation Commission, Final Report, May 1993.',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6668, 'European Datum 1979',
        'GEODETIC',
        7022, 8901,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6670, 'Istituto Geografico Militaire 1995',
        'GEODETIC',
        7030, 8901,
        'ENI',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6671, 'Voirol 1879',
        'GEODETIC',
        7011, 8901,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6820, 'Gunung Segara (Jakarta)',
        'GEODETIC',
        7004, 8908,
        '',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6821, 'Voirol 1879 (Paris)',
        'GEODETIC',
        7011, 8903,
        'IGN Paris',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

    insert into MDSYS.SDO_DATUMS (
        DATUM_ID,
        DATUM_NAME,
        DATUM_TYPE,
        ELLIPSOID_ID,
        PRIME_MERIDIAN_ID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHIFT_X,
        SHIFT_Y,
        SHIFT_Z,
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        SCALE_ADJUST,
        IS_LEGACY,
        LEGACY_CODE)
      VALUES (6904, 'Lisbon 1890 (Lisbon)',
        'GEODETIC',
        7004, 8902,
        'Instituto Geografico e Cadastral Lisbon http://www.igeo.pt',
        'EPSG',
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'FALSE',
        NULL);

  end if;
end;
/
commit;
select 'commit 12' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'DATUM_FOREIGN_LEGACY';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_DATUMS ADD (
        CONSTRAINT DATUM_FOREIGN_LEGACY FOREIGN KEY(LEGACY_CODE) REFERENCES MDSYS.SDO_DATUMS(DATUM_ID))';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 13' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'COORDINATE_SYSTEM_PRIM';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_COORD_SYS ADD (
        CONSTRAINT COORDINATE_SYSTEM_PRIM PRIMARY KEY(COORD_SYS_ID) USING INDEX)';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 14' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'COORD_AXIS_NAME_PRIM';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_coord_axis_names ADD (
        CONSTRAINT COORD_AXIS_NAME_PRIM PRIMARY KEY(COORD_AXIS_NAME_ID) USING INDEX)';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 15' from dual;
declare
  stm VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_CONSTRAINTS where owner = 'MDSYS' and constraint_name = 'COORD_AXIS_PRIM';
  if(rec_count = 0) then
    stm :=
      'ALTER TABLE MDSYS.SDO_coord_axes ADD (
        CONSTRAINT COORD_AXIS_PRIM PRIMARY KEY(COORD_SYS_ID, "ORDER") USING INDEX,
        CONSTRAINT COORD_AXIS_FOREIGN_CS FOREIGN KEY(COORD_SYS_ID) REFERENCES MDSYS.SDO_COORD_SYS(COORD_SYS_ID),
        CONSTRAINT COORD_AXIS_FOREIGN_UOM FOREIGN KEY(UOM_ID) REFERENCES MDSYS.SDO_UNITS_OF_MEASURE(UOM_ID),
        CONSTRAINT COORD_AXIS_FOREIGN_AXIS FOREIGN KEY(COORD_AXIS_NAME_ID) REFERENCES MDSYS.SDO_COORD_AXIS_NAMES(COORD_AXIS_NAME_ID))';
    execute immediate stm;
  end if;
end;
/
commit;
select 'commit 16' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_SYS;
  if(rec_count = 0) then
    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4400,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4400001,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: Mile.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4400002,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: Yard.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4401,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: chBnB.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4402,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: chSe.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4403,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: ftCla.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4404,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: ftGC.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4405,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: ftSe.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4406,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: km.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4407,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: lkCla.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4408,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: ydInd.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4409,
        'Cartesian 2D CS.  Axes: easting, northing (E,N). Orientations: east, north.  UoM: ydSe.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4495,
        'Cartesian 2D CS.  Axes: easting, northing (X,Y). Orientations: east, north.  UoM: ft.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4496,
        'Cartesian 2D CS.  Axes: easting, northing [E(X),N(Y)]. Orientations: east, north.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4497,
        'Cartesian 2D CS.  Axes: easting, northing (X,Y). Orientations: east, north.  UoM: ftUS.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4498,
        'Cartesian 2D CS.  Axes: easting, northing (Y,X). Orientations: east, north.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4499,
        'Cartesian 2D CS.  Axes: easting, northing (X,Y). Orientations: east, north.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4500,
        'Cartesian 2D CS.  Axes: northing, easting (N,E). Orientations: north, east.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4501,
        'Cartesian 2D CS.  Axes: northing, westing (N,E). Orientations: north, west.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4530,
        'Cartesian 2D CS.  Axes: northing, easting (X,Y). Orientations: north, east.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4531,
        'Cartesian 2D CS.  Axes: northing, easting (x,y). Orientations: north, east.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4532,
        'Cartesian 2D CS.  Axes: northing, easting (Y,X). Orientations: north, east.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6401,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: DMSH, DMSH, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6402,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: DMSH.',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6403,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: grads.',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6404,
        'Spherical 3D CS. Axes: latitude, longitude, radius. Orientations: north, east, up.  UoM: degrees, degrees, metres.',
        'spherical',
        3,
        'Open GIS Consortium',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6497,
        'Gravity-related CS. Axis: height (H). Orientation: up.  UoM: ftUS.',
        'gravity-related',
        1,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6498,
        'Gravity-related CS. Axis: depth (D). Orientation: down.  UoM: m.',
        'gravity-related',
        1,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6499,
        'Gravity-related CS. Axis: height (H). Orientation: up.  UoM: m.',
        'gravity-related',
        1,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6500,
        'Earth centred, earth fixed, righthanded 3D coordinate system, consisting of 3 orthogonal axes with X and Y axes in the equatorial plane,  positive Z-axis parallel to mean earth rotation axis and pointing towards North Pole. UoM: m.',
        'Cartesian',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6501,
        'Cartesian 2D CS.  Axes: southing, westing (X,Y). Orientations: south, west.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6502,
        'Cartesian 2D CS.  Axes: westing, southing (Y,X). Orientations: west, south.  UoM: GLM.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6503,
        'Cartesian 2D CS.  Axes: westing, southing (Y,X). Orientations: west, south.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6504,
        'Cartesian 2D CS.  Axes: plant N, Plant E (n,e). Orientations: northwest, northeast.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6505,
        'Cartesian 2D CS.  Axes: 1st local axis, 2nd local axis (n,e). Orientations: northwest, northeast.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6506,
        'Cartesian 2D CS.  Axes: 1st local axis, 2nd local axis (I,J). Orientations: ese/nne.  UoM: 165 x 330 ftUS.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6507,
        'Cartesian 2D CS.  Axes: 1st local axis, 2nd local axis (X,Y). Orientations: north, west.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6508,
        'Cartesian 2D CS.  Axes: bin grid J, bin grid I (J,I). Orientations: nne/ese.  UoM: 12.5 x 25m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4489,
        'Cartesian 2D CS for AAPS.  Axes: E,N. Orientations: E along 160 deg East, N along 70 deg East meridians.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4490,
        'Cartesian 2D CS for APS.  Axes: E,N. Orientations: E along 90 deg East, N along 0 deg meridians.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4491,
        'Cartesian 2D CS.  Axes: westing, northing (W,N). Orientations: west, north.  UoM: m.',
        'Cartesian',
        2,
        'Landmaelingar Islands (National Land Survey of Iceland).',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4492,
        'Cartesian 2D CS for Terre Adelie PS.  Axes: X,Y. Orientations: X along 130 deg West, Y along 140 deg East meridians.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4493,
        'Cartesian 2D CS for UPS north.  Axes: N,E. Orientations: N along 0 then180 deg meridians, E along 90 deg East meridian.  UoM: m.',
        'Cartesian',
        2,
        'DMA TM8358.2',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        4494,
        'Cartesian 2D CS for UPS south.  Axes: N,E. Orientations: N along 0 deg, E along 90 deg East meridians.  UoM: m.',
        'Cartesian',
        2,
        'DMA TM8358.2',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6405,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: dec deg',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6406,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: degH',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6407,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: Hdeg',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6408,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: DM',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6409,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: DMH',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6410,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: HDM',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6411,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: DMS',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6412,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: HDMS',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6413,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: dec deg, dec deg, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6414,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: degH, degH, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6415,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: Hdeg, Hdeg, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6416,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: DM, DM, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6417,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: DMH, DMH, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6418,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: HDM, HDM, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6419,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: DMS, DMS, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6420,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: HDMS, HDMS, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6421,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: grads, grads, metres.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6422,
        'Ellipsoidal 2D CS. Axes: latitude, longitude. Orientations: north, east.  UoM: deg',
        'ellipsoidal',
        2,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6423,
        'Ellipsoidal 3D CS. Axes: latitude, longitude, ellipsoidal height. Orientations: north, east, up.  UoM: deg, deg, m.',
        'ellipsoidal',
        3,
        'EPSG',
        'EPSG');

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6496,
        'Gravity-related CS. Axis: height (H). Orientation: up.  UoM: ft(Br36).',
        'gravity-related',
        1,
        'EPSG',
        'EPSG'); 

    insert into MDSYS.SDO_COORD_SYS (
        COORD_SYS_ID,
        COORD_SYS_NAME,
        COORD_SYS_TYPE,
        DIMENSION,
        INFORMATION_SOURCE,
        DATA_SOURCE)
      VALUES (
        6509,
        'Cartesian 2D CS.  Axes: southing, westing (P,M). Orientations: south, west.  UoM: m.',
        'Cartesian',
        2,
        'EPSG',
        'EPSG');

  end if;
end;
/
commit;
select 'commit 17' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_AXIS_NAMES;
  if(rec_count = 0) then
    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9901,
        'Geodetic latitude');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9902,
        'Geodetic longitude');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9903,
        'Ellipsoidal height');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9904,
        'Gravity-related height');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9905,
        'Gravity-related depth');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9906,
        'Easting');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9907,
        'Northing');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9908,
        'Westing');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9909,
        'Southing');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9910,
        'Geocentric X');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9911,
        'Geocentric Y');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9912,
        'Geocentric Z');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9913,
        'First local axis');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9914,
        'Second local axis');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9915,
        'Third local axis');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9916,
        'Local height');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9917,
        'Local depth');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9918,
        'Plant East');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9919,
        'Plant North');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9920,
        'Bin grid I');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9921,
        'Bin grid J');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9922,
        'Inline');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9923,
        'Crossline');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9924,
        'Platform East');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9925,
        'Platform North');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9926,
        'Spherical latitude');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9927,
        'Spherical longitude');

    insert into MDSYS.SDO_COORD_AXIS_NAMES (
        COORD_AXIS_NAME_ID,
        COORD_AXIS_NAME)
      VALUES (
        9928,
        'Geocentric radius');
  end if;
end;
/
commit;
select 'commit 18' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_AXES;
  if(rec_count = 0) then
    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4400,
        9906,
        'east',
        'E',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4400,
        9907,
        'north',
        'N',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4400001,
        9906,
        'east',
        'E',
        9093,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4400001,
        9907,
        'north',
        'N',
        9093,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4400002,
        9906,
        'east',
        'E',
        10044,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4400002,
        9907,
        'north',
        'N',
        10044,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4401,
        9906,
        'east',
        'E',
        9062,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4401,
        9907,
        'north',
        'N',
        9062,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4402,
        9906,
        'east',
        'E',
        9042,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4402,
        9907,
        'north',
        'N',
        9042,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4403,
        9906,
        'east',
        'E',
        9005,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4403,
        9907,
        'north',
        'N',
        9005,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4404,
        9906,
        'east',
        'E',
        9094,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4404,
        9907,
        'north',
        'N',
        9094,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4405,
        9906,
        'east',
        'E',
        9041,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4405,
        9907,
        'north',
        'N',
        9041,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4406,
        9906,
        'east',
        'X',
        9036,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4406,
        9907,
        'north',
        'Y',
        9036,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4407,
        9906,
        'east',
        'E',
        9039,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4407,
        9907,
        'north',
        'N',
        9039,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4408,
        9906,
        'east',
        'E',
        9084,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4408,
        9907,
        'north',
        'N',
        9084,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4409,
        9906,
        'east',
        'E',
        9040,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4409,
        9907,
        'north',
        'N',
        9040,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4495,
        9906,
        'east',
        'X',
        9002,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4495,
        9907,
        'north',
        'Y',
        9002,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4496,
        9906,
        'east',
        'E(X)',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4496,
        9907,
        'north',
        'N(Y)',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4497,
        9906,
        'east',
        'X',
        9003,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4497,
        9907,
        'north',
        'Y',
        9003,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4498,
        9906,
        'east',
        'Y',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4498,
        9907,
        'north',
        'X',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4499,
        9906,
        'east',
        'X',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4499,
        9907,
        'north',
        'Y',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4500,
        9907,
        'north',
        'N',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4500,
        9906,
        'east',
        'E',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4501,
        9907,
        'north',
        'N',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4501,
        9908,
        'west',
        'E',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4530,
        9907,
        'north',
        'X',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4530,
        9906,
        'east',
        'Y',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4531,
        9907,
        'north',
        'x',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4531,
        9906,
        'east',
        'y',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4532,
        9907,
        'north',
        'Y',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4532,
        9906,
        'east',
        'X',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6401,
        9901,
        'north',
        'Lat',
        9108,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6401,
        9902,
        'east',
        'Long',
        9108,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6401,
        9903,
        'up',
        'h',
        9001,
        3);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6402,
        9901,
        'north',
        'Lat',
        9108,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6402,
        9902,
        'east',
        'Long',
        9108,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6403,
        9901,
        'north',
        'Lat',
        9105,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6403,
        9902,
        'east',
        'Long',
        9105,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6404,
        9926,
        'north',
        'Lat',
        9122,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6404,
        9927,
        'east',
        'Long',
        9122,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6404,
        9928,
        'up',
        'R',
        9001,
        3);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6497,
        9904,
        'up',
        'H',
        9003,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6498,
        9905,
        'down',
        'D',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6499,
        9904,
        'up',
        'H',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6500,
        9910,
        'Geocentre > equator/PM',
        'X',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6500,
        9911,
        'Geocentre > equator/90dE',
        'Y',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6500,
        9912,
        'Geocentre > north pole',
        'Z',
        9001,
        3);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6501,
        9909,
        'south',
        'X',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6501,
        9908,
        'west',
        'Y',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6502,
        9908,
        'west',
        'Y',
        9031,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6502,
        9909,
        'south',
        'X',
        9031,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6503,
        9908,
        'west',
        'Y',
        9001,
        1);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_AXES where coord_sys_id = 6503 and "ORDER" = 2;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6503,
        9909,
        'south',
        'X',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6504,
        9919,
        'north-west',
        'n',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6504,
        9918,
        'north-east',
        'e',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6505,
        9913,
        'north-west',
        'n',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6505,
        9914,
        'north-east',
        'e',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6506,
        9913,
        'east-south-east',
        'I',
        9205,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6506,
        9914,
        'north-north-east',
        'J',
        9204,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6507,
        9913,
        'north',
        'X',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6507,
        9914,
        'west',
        'Y',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6508,
        9921,
        'north north east',
        'J',
        9209,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6508,
        9920,
        'east south east',
        'I',
        9208,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4489,
        9906,
        'North along 160 deg East',
        'E',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4489,
        9907,
        'North along 70 deg East',
        'N',
        9001,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4490,
        9906,
        'North along 90 deg East',
        'E',
        9001,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4490,
        9907,
        'North along 0 deg East',
        'N',
        9001,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4491,
        9907,
        'north',
        'N',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4491,
        9908,
        'west',
        'W',
        9001,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4492,
        9913,
        'North along 130 deg West',
        'X',
        9001,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4492,
        9914,
        'North along 140 deg East',
        'Y',
        9001,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4493,
        9906,
        'South along 90 deg East',
        'E',
        9001,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4493,
        9907,
        'South along 180 deg East',
        'N',
        9001,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4494,
        9906,
        'North along 90 deg East',
        'E',
        9001,
        2);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        4494,
        9907,
        'North along 0 deg East',
        'N',
        9001,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6405,
        9901,
        'north',
        'Lat',
        9102,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6405,
        9902,
        'east',
        'Long',
        9102,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6406,
        9901,
        'north',
        'Lat',
        9116,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6406,
        9902,
        'east',
        'Long',
        9116,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6407,
        9901,
        'north',
        'Lat',
        9117,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6407,
        9902,
        'east',
        'Long',
        9117,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6408,
        9901,
        'north',
        'Lat',
        9115,
        1);

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6408,
        9902,
        'east',
        'Long',
        9115,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6409,
        9901,
        'north',
        'Lat',
        9118,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6409,
        9902,
        'east',
        'Long',
        9118,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6410,
        9901,
        'north',
        'Lat',
        9119,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6410,
        9902,
        'east',
        'Long',
        9119,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6411,
        9901,
        'north',
        'Lat',
        9107,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6411,
        9902,
        'east',
        'Long',
        9107,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6412,
        9901,
        'north',
        'Lat',
        9120,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6412,
        9902,
        'east',
        'Long',
        9120,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6413,
        9901,
        'north',
        'Lat',
        9102,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6413,
        9902,
        'east',
        'Long',
        9102,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6413,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6414,
        9901,
        'north',
        'Lat',
        9116,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6414,
        9902,
        'east',
        'Long',
        9116,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6414,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6415,
        9901,
        'north',
        'Lat',
        9117,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6415,
        9902,
        'east',
        'Long',
        9117,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6415,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6416,
        9901,
        'north',
        'Lat',
        9115,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6416,
        9902,
        'east',
        'Long',
        9115,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6416,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6417,
        9901,
        'north',
        'Lat',
        9118,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6417,
        9902,
        'east',
        'Long',
        9118,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6417,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6418,
        9901,
        'north',
        'Lat',
        9119,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6418,
        9902,
        'east',
        'Long',
        9119,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6418,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6419,
        9901,
        'north',
        'Lat',
        9107,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6419,
        9902,
        'east',
        'Long',
        9107,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6419,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6420,
        9901,
        'north',
        'Lat',
        9120,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6420,
        9902,
        'east',
        'Long',
        9120,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6420,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6421,
        9901,
        'north',
        'Lat',
        9105,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6421,
        9902,
        'east',
        'Long',
        9105,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6421,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6422,
        9901,
        'north',
        'Lat',
        9122,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6422,
        9902,
        'east',
        'Long',
        9122,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6423,
        9901,
        'north',
        'Lat',
        9122,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6423,
        9902,
        'east',
        'Long',
        9122,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6423,
        9903,
        'up',
        'h',
        9001,
        3); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6496,
        9904,
        'up',
        'H',
        9095,
        1); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6509,
        9908,
        'west',
        'M',
        9001,
        2); 

    insert into MDSYS.SDO_COORD_AXES (
        COORD_SYS_ID,
        COORD_AXIS_NAME_ID,
        COORD_AXIS_ORIENTATION,
        COORD_AXIS_ABBREVIATION,
        UOM_ID,
        "ORDER")
      VALUES (
        6509,
        9909,
        'south',
        'P',
        9001,
        1); 

  end if;
end;
/
commit;
select 'commit 19' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 999999;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        999999,
        'unknown CRS',
        'PROJECTED',
        4400,
        NULL,
        4600,
        999999,
        NULL,
        NULL,
        'Oracle',
        'Oracle',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        999998,
        'NaC',
        'PROJECTED',
        4400,
        NULL,
        4600,
        999999,
        NULL,
        NULL,
        'Oracle',
        'Oracle',
        'FALSE',
        NULL,
        NULL,
        NULL);

    

    INSERT INTO sdo_coord_ref_system (
      srid,
      coord_ref_sys_name,
      coord_ref_sys_kind,
      coord_sys_id,
      datum_id,
      geog_crs_datum_id,
      source_geog_srid,
      projection_conv_id,
      cmpd_horiz_srid,
      cmpd_vert_srid,
      information_source,
      data_source,
      is_legacy,
      legacy_code,
      legacy_wktext,
      legacy_cs_bounds,
      is_valid,
      supports_sdo_geometry)
    VALUES (
      3078,
      'NAD83 / Michigan Oblique Mercator',
      'PROJECTED',
      4499,
      null,
      6269,
      4269,
      12150,
      Null,
      Null,
      'Michigan Department of Natural Resources,  http://www.michigan.gov/documents/DNR_Map_Proj_and_MI_Georef_Info_20889_7.pdf',
      'EPSG',
      'FALSE',
      null,
      null,
      null,
      'TRUE',
      'TRUE');

    

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        999989,
        'Edmonton Transverse Mercator',
        'PROJECTED',
        4400,
        NULL,
        4140,
        999989,
        NULL,
        NULL,
        'Oracle',
        'Oracle',
        'FALSE',
        NULL,
        NULL,
        NULL);

    

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000101,
        'LKS-94',
        'PROJECTED',
        4530,
        Null,
        3000103,
        30001012,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000102,
        'Baltija-92',
        'PROJECTED',
        4530,
        Null,
        3000103,
        30001022,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000104,
        'GK_Central_Meridian_24 Lithuanian (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001042,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000105,
        'GK Lithuanian Zone 4 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001052,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000106,
        'GK Lithuanian Zone 5 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001062,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000107,
        'GK_3Degree Lithuanian Zone 7 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001072,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000108,
        'GK_3Degree Lithuanian Zone 8 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001082,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000109,
        'GK_3Degree Lithuanian Zone 9 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001092,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000110,
        'GK1963 Lithuanian Zone 0 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001102,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000111,
        'GK1963 Lithuanian Zone 1 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001112,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000112,
        'GK1963 Lithuanian Zone 2 (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001122,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000114,
        'Vilnius (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001142,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000115,
        'Kaunas (Lithuanian Pulkovo 1942)',
        'PROJECTED',
        4530,
        Null,
        3000113,
        30001152,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000116,
        'LKS-92',
        'PROJECTED',
        4530,
        Null,
        3000103,
        30001162,
        Null,
        Null,
        '-',
        '-',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000103,
        'Longitude / Latitude (LKS-94)',
        'GEOGRAPHIC2D',
        6422,
        10035,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3000113,
        'Lithuanian Pulkovo 1942',
        'GEOGRAPHIC2D',
        6422,
        30001131,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    
    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2000067,
        'TWD67',
        'GEOGRAPHIC2D',
        6422,
        6202,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle Taiwan',
        'Oracle Taiwan',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        20000671,
        'TM67 / TWD67',
        'PROJECTED',
        4400,
        NULL,
        2000067,
        2000067,
        NULL,
        NULL,
        'Oracle Taiwan',
        'Oracle Taiwan',
        'FALSE',
        NULL,
        NULL,
        NULL);

    
    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2000097,
        'TWD97',
        'GEOGRAPHIC2D',
        6422,
        6326,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle Taiwan',
        'Oracle Taiwan',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        20000971,
        'TM97 / TWD97',
        'PROJECTED',
        4400,
        NULL,
        2000097,
        2000097,
        NULL,
        NULL,
        'Oracle Taiwan',
        'Oracle Taiwan',
        'FALSE',
        NULL,
        NULL,
        NULL);

    
    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS,
        GEOG_CRS_DATUM_ID)
      VALUES (
        1000000123,
        'Geographic system without EPSG parameters',
        'GEOGRAPHIC2D',
        NULL,
        1000000123,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        'Oracle',
        'TRUE',
        NULL,
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        1,
        'Sinusoidal (WGS 84)',
        'PROJECTED',
        NULL,
        NULL,
        8307,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'PROJCS["Sinusoidal (WGS 84)", GEOGCS [ "Longitude / Latitude (WGS 84)", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Sinusoidal"], UNIT ["Meter", 1.000000000000]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2,
        'Unit Sphere',
        'GEOGRAPHIC2D',
        NULL,
        20012,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Unit Sphere Longitude/Latitude", DATUM [ "UnitSphere", SPHEROID ["UnitSphere", 1.0, 1000000000000]], PRIMEM ["NONE", 0.0000000], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2000;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2000,
        'Anguilla 1957 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4600,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2001,
        'Antigua 1943 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4601,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2002,
        'Dominica 1945 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4602,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2003,
        'Grenada 1953 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4603,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2004,
        'Montserrat 58 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4604,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2005,
        'St Kitts 1955 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4605,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2006,
        'St Lucia 1955 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4606,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2007,
        'St Vincent 45 / British West Indies Grid',
        'PROJECTED',
        4400,
        NULL,
        4607,
        19942,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2008,
        'NAD27(CGQ77) / SCoPQ zone 2',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17700,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2009,
        'NAD27(CGQ77) / SCoPQ zone 3',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17703,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2010,
        'NAD27(CGQ77) / SCoPQ zone 4',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17704,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2011,
        'NAD27(CGQ77) / SCoPQ zone 5',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17705,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2012,
        'NAD27(CGQ77) / SCoPQ zone 6',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17706,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2013,
        'NAD27(CGQ77) / SCoPQ zone 7',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17707,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2014,
        'NAD27(CGQ77) / SCoPQ zone 8',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17708,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2015,
        'NAD27(CGQ77) / SCoPQ zone 9',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17709,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2016,
        'NAD27(CGQ77) / SCoPQ zone 10',
        'PROJECTED',
        4499,
        NULL,
        4609,
        17710,
        NULL,
        NULL,
        'Geodetic Service of Quebec; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2017,
        'NAD27(76) / MTM zone 8',
        'PROJECTED',
        4499,
        NULL,
        4608,
        17708,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2018,
        'NAD27(76) / MTM zone 9',
        'PROJECTED',
        4499,
        NULL,
        4608,
        17709,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2019,
        'NAD27(76) / MTM zone 10',
        'PROJECTED',
        4499,
        NULL,
        4608,
        17710,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2020,
        'NAD27(76) / MTM zone 11',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17711,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2021,
        'NAD27(76) / MTM zone 12',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17712,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2022,
        'NAD27(76) / MTM zone 13',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17713,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2023,
        'NAD27(76) / MTM zone 14',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17714,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2024,
        'NAD27(76) / MTM zone 15',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17715,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2025,
        'NAD27(76) / MTM zone 16',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17716,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2026,
        'NAD27(76) / MTM zone 17',
        'PROJECTED',
        4400,
        NULL,
        4608,
        17717,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2027,
        'NAD27(76) / UTM zone 15N',
        'PROJECTED',
        4400,
        NULL,
        4608,
        16015,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2028,
        'NAD27(76) / UTM zone 16N',
        'PROJECTED',
        4400,
        NULL,
        4608,
        16016,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2029,
        'NAD27(76) / UTM zone 17N',
        'PROJECTED',
        4400,
        NULL,
        4608,
        16017,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2030,
        'NAD27(76) / UTM zone 18N',
        'PROJECTED',
        4400,
        NULL,
        4608,
        16018,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2031,
        'NAD27(CGQ77) / UTM zone 17N',
        'PROJECTED',
        4400,
        NULL,
        4609,
        16017,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2032;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2032,
        'NAD27(CGQ77) / UTM zone 18N',
        'PROJECTED',
        4400,
        NULL,
        4609,
        16018,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2033,
        'NAD27(CGQ77) / UTM zone 19N',
        'PROJECTED',
        4400,
        NULL,
        4609,
        16019,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2034,
        'NAD27(CGQ77) / UTM zone 20N',
        'PROJECTED',
        4400,
        NULL,
        4609,
        16020,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2035,
        'NAD27(CGQ77) / UTM zone 21N',
        'PROJECTED',
        4400,
        NULL,
        4609,
        16021,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2036,
        'NAD83(CSRS98) / New Brunswick Stereo',
        'PROJECTED',
        4500,
        NULL,
        4140,
        19946,
        NULL,
        NULL,
        'Service New Brunswick Land and Information Standards Manual',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2037,
        'NAD83(CSRS98) / UTM zone 19N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16019,
        NULL,
        NULL,
        'Service New Brunswick Land and Information Standards Manual',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2038,
        'NAD83(CSRS98) / UTM zone 20N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16020,
        NULL,
        NULL,
        'Service New Brunswick Land and Information Standards Manual',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2039,
        'Israel / Israeli TM Grid',
        'PROJECTED',
        4400,
        NULL,
        4141,
        18204,
        NULL,
        NULL,
        'Survey of Israel.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2040,
        'Locodjo 1965 / UTM zone 30N',
        'PROJECTED',
        4400,
        NULL,
        4142,
        16030,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2041,
        'Abidjan 1987 / UTM zone 30N',
        'PROJECTED',
        4400,
        NULL,
        4143,
        16030,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2042,
        'Locodjo 1965 / UTM zone 29N',
        'PROJECTED',
        4400,
        NULL,
        4142,
        16029,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2043,
        'Abidjan 1987 / UTM zone 29N',
        'PROJECTED',
        4400,
        NULL,
        4143,
        16029,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2044,
        'Hanoi 1972 / Gauss-Kruger zone 18',
        'PROJECTED',
        4530,
        NULL,
        4147,
        16218,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2045,
        'Hanoi 1972 / Gauss-Kruger zone 19',
        'PROJECTED',
        4530,
        NULL,
        4147,
        16219,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2046,
        'Hartebeesthoek94 / Lo15',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17515,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2047,
        'Hartebeesthoek94 / Lo17',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17517,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2048,
        'Hartebeesthoek94 / Lo19',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17519,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2049,
        'Hartebeesthoek94 / Lo21',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17521,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2050,
        'Hartebeesthoek94 / Lo23',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17523,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2051,
        'Hartebeesthoek94 / Lo25',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17525,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2052,
        'Hartebeesthoek94 / Lo27',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17527,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2053,
        'Hartebeesthoek94 / Lo29',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17529,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2054,
        'Hartebeesthoek94 / Lo31',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17531,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2055,
        'Hartebeesthoek94 / Lo33',
        'PROJECTED',
        6503,
        NULL,
        4148,
        17533,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2056,
        'CH1903+ / LV95',
        'PROJECTED',
        4498,
        NULL,
        4150,
        19950,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2057,
        'Rassadiran / Nakhl e Taqi',
        'PROJECTED',
        4400,
        NULL,
        4153,
        19951,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2058,
        'ED50(ED77) / UTM zone 38N',
        'PROJECTED',
        4400,
        NULL,
        4154,
        16038,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2059,
        'ED50(ED77) / UTM zone 39N',
        'PROJECTED',
        4400,
        NULL,
        4154,
        16039,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2060,
        'ED50(ED77) / UTM zone 40N',
        'PROJECTED',
        4400,
        NULL,
        4154,
        16040,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2061,
        'ED50(ED77) / UTM zone 41N',
        'PROJECTED',
        4400,
        NULL,
        4154,
        16041,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2062,
        'Madrid 1870 (Madrid) / Spain',
        'PROJECTED',
        4499,
        NULL,
        4903,
        19921,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2063,
        'Dabola 1981 / UTM zone 28N',
        'PROJECTED',
        4400,
        NULL,
        4315,
        16028,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2064,
        'Dabola 1981 / UTM zone 29N',
        'PROJECTED',
        4400,
        NULL,
        4315,
        16029,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2065,
        'S-JTSK (Ferro) / Krovak',
        'PROJECTED',
        6501,
        NULL,
        4818,
        19952,
        NULL,
        NULL,
        'Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2066,
        'Mount Dillon / Tobago Grid',
        'PROJECTED',
        4407,
        NULL,
        4157,
        19924,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
select 'commit 20' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2067;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2067,
        'Naparima 1955 / UTM zone 20N',
        'PROJECTED',
        4400,
        NULL,
        4158,
        16020,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2068,
        'ELD79 / Libya zone 5',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18240,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2069,
        'ELD79 / Libya zone 6',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18241,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2070,
        'ELD79 / Libya zone 7',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18242,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2071,
        'ELD79 / Libya zone 8',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18243,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2072,
        'ELD79 / Libya zone 9',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18244,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2073,
        'ELD79 / Libya zone 10',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18245,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2074,
        'ELD79 / Libya zone 11',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18246,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2075,
        'ELD79 / Libya zone 12',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18247,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2076,
        'ELD79 / Libya zone 13',
        'PROJECTED',
        4499,
        NULL,
        4159,
        18248,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2077,
        'ELD79 / UTM zone 32N',
        'PROJECTED',
        4400,
        NULL,
        4159,
        16032,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2078,
        'ELD79 / UTM zone 33N',
        'PROJECTED',
        4400,
        NULL,
        4159,
        16033,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2079,
        'ELD79 / UTM zone 34N',
        'PROJECTED',
        4400,
        NULL,
        4159,
        16034,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2080,
        'ELD79 / UTM zone 35N',
        'PROJECTED',
        4400,
        NULL,
        4159,
        16035,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2081,
        'Chos Malal 1914 / Argentina zone 2',
        'PROJECTED',
        4530,
        NULL,
        4160,
        18032,
        NULL,
        NULL,
        'Various oil industry records',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2082,
        'Pampa del Castillo / Argentina zone 2',
        'PROJECTED',
        4530,
        NULL,
        4161,
        18032,
        NULL,
        NULL,
        'Various oil industry records',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2083,
        'Hito XVIII 1963 / Argentina zone 2',
        'PROJECTED',
        4530,
        NULL,
        4254,
        18032,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2084,
        'Hito XVIII 1963 / UTM zone 19S',
        'PROJECTED',
        4400,
        NULL,
        4254,
        16119,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2085,
        'NAD27 / Cuba Norte',
        'PROJECTED',
        4532,
        NULL,
        4267,
        18061,
        NULL,
        NULL,
        'Institut Cubano di Hidrografia (ICH)',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2086,
        'NAD27 / Cuba Sur',
        'PROJECTED',
        4532,
        NULL,
        4267,
        18062,
        NULL,
        NULL,
        'Institut Cubano di Hidrografia (ICH)',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2087,
        'ELD79 / TM 12 NE',
        'PROJECTED',
        4400,
        NULL,
        4159,
        16412,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2088,
        'Carthage / TM 11 NE',
        'PROJECTED',
        4400,
        NULL,
        4223,
        16411,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2089,
        'Yemen NGN96 / UTM zone 38N',
        'PROJECTED',
        4400,
        NULL,
        4163,
        16038,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2090;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2090,
        'Yemen NGN96 / UTM zone 39N',
        'PROJECTED',
        4400,
        NULL,
        4163,
        16039,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2091,
        'South Yemen / Gauss Kruger zone 8',
        'PROJECTED',
        4530,
        NULL,
        4164,
        16208,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2092,
        'South Yemen / Gauss Kruger zone 9',
        'PROJECTED',
        4530,
        NULL,
        4164,
        16209,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2093,
        'Hanoi 1972 / GK 106 NE',
        'PROJECTED',
        4530,
        NULL,
        4147,
        16586,
        NULL,
        NULL,
        'BP Amoco',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2094,
        'WGS 72BE / TM 106 NE',
        'PROJECTED',
        4400,
        NULL,
        4324,
        16506,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2095,
        'Bissau / UTM zone 28N',
        'PROJECTED',
        4400,
        NULL,
        4165,
        16028,
        NULL,
        NULL,
        'US National Imagery and Mapping Agency TR8350.2.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2096,
        'Korean 1985 / Korea East Belt',
        'PROJECTED',
        4530,
        NULL,
        4162,
        18251,
        NULL,
        NULL,
        'Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1999. http://www.asprs.org/resources.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2097,
        'Korean 1985 / Korea Central Belt',
        'PROJECTED',
        4530,
        NULL,
        4162,
        18252,
        NULL,
        NULL,
        'Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1999. http://www.asprs.org/resources.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2098,
        'Korean 1985 / Korea West Belt',
        'PROJECTED',
        4530,
        NULL,
        4162,
        18253,
        NULL,
        NULL,
        'Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1999. http://www.asprs.org/resources.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2099,
        'Qatar 1948 / Qatar Grid',
        'PROJECTED',
        4400,
        NULL,
        4286,
        19953,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2100,
        'GGRS87 / Greek Grid',
        'PROJECTED',
        4400,
        NULL,
        4121,
        19930,
        NULL,
        NULL,
        'Geodesy Department; Public Petroleum Corporation of Greece.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2101,
        'Lake / Maracaibo Grid M1',
        'PROJECTED',
        4499,
        NULL,
        4249,
        18260,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2102,
        'Lake / Maracaibo Grid',
        'PROJECTED',
        4499,
        NULL,
        4249,
        18261,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2103,
        'Lake / Maracaibo Grid M3',
        'PROJECTED',
        4499,
        NULL,
        4249,
        18262,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2104,
        'Lake / Maracaibo La Rosa Grid',
        'PROJECTED',
        4499,
        NULL,
        4249,
        18263,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2105,
        'NZGD2000 / Mount Eden Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17931,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2106,
        'NZGD2000 / Bay of Plenty Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17932,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2107,
        'NZGD2000 / Poverty Bay Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17933,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2108,
        'NZGD2000 / Hawkes Bay Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17934,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2109,
        'NZGD2000 / Taranaki Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17935,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2110,
        'NZGD2000 / Tuhirangi Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17936,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2111,
        'NZGD2000 / Wanganui Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17937,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2112,
        'NZGD2000 / Wairarapa Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17938,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2113,
        'NZGD2000 / Wellington Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17939,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2114,
        'NZGD2000 / Collingwood Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17940,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2115,
        'NZGD2000 / Nelson Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17941,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2116,
        'NZGD2000 / Karamea Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17942,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2117,
        'NZGD2000 / Buller Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17943,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2118,
        'NZGD2000 / Grey Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17944,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2119,
        'NZGD2000 / Amuri Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17945,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2120;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2120,
        'NZGD2000 / Marlborough Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17946,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2121,
        'NZGD2000 / Hokitika Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17947,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2122,
        'NZGD2000 / Okarito Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17948,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2123,
        'NZGD2000 / Jacksons Bay Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17949,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2124,
        'NZGD2000 / Mount Pleasant Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17950,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2125,
        'NZGD2000 / Gawler Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17951,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2126,
        'NZGD2000 / Timaru Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17952,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2127,
        'NZGD2000 / Lindis Peak Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17953,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2128,
        'NZGD2000 / Mount Nicholas Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17954,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2129,
        'NZGD2000 / Mount York Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17955,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2130,
        'NZGD2000 / Observation Point Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17956,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2131,
        'NZGD2000 / North Taieri Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17957,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2132,
        'NZGD2000 / Bluff Circuit 2000',
        'PROJECTED',
        4500,
        NULL,
        4167,
        17958,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; 16 April 1999.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2133,
        'NZGD2000 / UTM zone 58S',
        'PROJECTED',
        4400,
        NULL,
        4167,
        16158,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2134,
        'NZGD2000 / UTM zone 59S',
        'PROJECTED',
        4400,
        NULL,
        4167,
        16159,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2135,
        'NZGD2000 / UTM zone 60S',
        'PROJECTED',
        4400,
        NULL,
        4167,
        16160,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2136,
        'Accra / Ghana National Grid',
        'PROJECTED',
        4404,
        NULL,
        4168,
        19959,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2137,
        'Accra / TM 1 NW',
        'PROJECTED',
        4400,
        NULL,
        4168,
        17001,
        NULL,
        NULL,
        'Various oil industry sources',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2138,
        'NAD27(CGQ77) / Quebec Lambert',
        'PROJECTED',
        4499,
        NULL,
        4609,
        19944,
        NULL,
        NULL,
        'Service de la Cartographie; Ministere des Ressources Naturelles; Quebec',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2139,
        'NAD83(CSRS98) / SCoPQ zone 2',
        'PROJECTED',
        4499,
        NULL,
        4140,
        17700,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2140,
        'NAD83(CSRS98) / MTM zone 3',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17703,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2141,
        'NAD83(CSRS98) / MTM zone 4',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17704,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2142,
        'NAD83(CSRS98) / MTM zone 5',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17705,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2143,
        'NAD83(CSRS98) / MTM zone 6',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17706,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2144,
        'NAD83(CSRS98) / MTM zone 7',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17707,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2145,
        'NAD83(CSRS98) / MTM zone 8',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17708,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2146,
        'NAD83(CSRS98) / MTM zone 9',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17709,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2147,
        'NAD83(CSRS98) / MTM zone 10',
        'PROJECTED',
        4496,
        NULL,
        4140,
        17710,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2148,
        'NAD83(CSRS98) / UTM zone 21N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16021,
        NULL,
        NULL,
        'Geomatics Canada.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2149,
        'NAD83(CSRS98) / UTM zone 18N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16018,
        NULL,
        NULL,
        'Geomatics Canada.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2150;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2150,
        'NAD83(CSRS98) / UTM zone 17N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16017,
        NULL,
        NULL,
        'Geomatics Canada.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2151,
        'NAD83(CSRS98) / UTM zone 13N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16013,
        NULL,
        NULL,
        'Geomatics Canada.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2152,
        'NAD83(CSRS98) / UTM zone 12N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16012,
        NULL,
        NULL,
        'Geomatics Canada.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2153,
        'NAD83(CSRS98) / UTM zone 11N',
        'PROJECTED',
        4400,
        NULL,
        4140,
        16011,
        NULL,
        NULL,
        'Geomatics Canada.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2154,
        'RGF93 / Lambert-93',
        'PROJECTED',
        4499,
        NULL,
        4171,
        18085,
        NULL,
        NULL,
        'IGN - Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2157,
        'IRENET95 / Irish Transverse Mercator',
        'PROJECTED',
        4400,
        NULL,
        4173,
        19962,
        NULL,
        NULL,
        'Ordnance Survey of Ireland',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2158,
        'IRENET95 / UTM zone 29N',
        'PROJECTED',
        4400,
        NULL,
        4173,
        16029,
        NULL,
        NULL,
        'Ordnance Survey of Ireland',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2159,
        'Sierra Leone 1924 / New Colony Grid',
        'PROJECTED',
        4404,
        NULL,
        4174,
        19963,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2160,
        'Sierra Leone 1924 / New War Office Grid',
        'PROJECTED',
        4404,
        NULL,
        4174,
        19964,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2161,
        'Sierra Leone 1968 / UTM zone 28N',
        'PROJECTED',
        4400,
        NULL,
        4175,
        16028,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2162,
        'Sierra Leone 1968 / UTM zone 29N',
        'PROJECTED',
        4400,
        NULL,
        4175,
        16029,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2164,
        'Locodjo 1965 / TM 5 NW',
        'PROJECTED',
        4400,
        NULL,
        4142,
        17005,
        NULL,
        NULL,
        'Various oil industry sources',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2165,
        'Abidjan 1987 / TM 5 NW',
        'PROJECTED',
        4400,
        NULL,
        4143,
        17005,
        NULL,
        NULL,
        'Various oil industry sources',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2166,
        'Pulkovo 1942(83) / Gauss Kruger zone 3',
        'PROJECTED',
        4530,
        NULL,
        4178,
        16263,
        NULL,
        NULL,
        'EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2167,
        'Pulkovo 1942(83) / Gauss Kruger zone 4',
        'PROJECTED',
        4530,
        NULL,
        4178,
        16264,
        NULL,
        NULL,
        'Bundesamt fur Kartographie und Geodasie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2168,
        'Pulkovo 1942(83) / Gauss Kruger zone 5',
        'PROJECTED',
        4530,
        NULL,
        4178,
        16265,
        NULL,
        NULL,
        'Bundesamt fur Kartographie und Geodasie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2169,
        'Luxembourg 1930 / Gauss',
        'PROJECTED',
        4530,
        NULL,
        4181,
        19966,
        NULL,
        NULL,
        'Administration du Cadastre et de la Topographie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2170,
        'MGI / Slovenia Grid',
        'PROJECTED',
        4530,
        NULL,
        4312,
        19967,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2171,
        'Pulkovo 1942(58) / Poland zone I',
        'PROJECTED',
        4530,
        NULL,
        4179,
        18281,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2172,
        'Pulkovo 1942(58) / Poland zone II',
        'PROJECTED',
        4530,
        NULL,
        4179,
        18282,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2173,
        'Pulkovo 1942(58) / Poland zone III',
        'PROJECTED',
        4530,
        NULL,
        4179,
        18283,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2174,
        'Pulkovo 1942(58) / Poland zone IV',
        'PROJECTED',
        4530,
        NULL,
        4179,
        18284,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2175,
        'Pulkovo 1942(58) / Poland zone V',
        'PROJECTED',
        4530,
        NULL,
        4179,
        18285,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2176,
        'ETRS89 / Poland CS2000 zone 5',
        'PROJECTED',
        4531,
        NULL,
        4258,
        18305,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2177,
        'ETRS89 / Poland CS2000 zone 6',
        'PROJECTED',
        4531,
        NULL,
        4258,
        18306,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2178,
        'ETRS89 / Poland CS2000 zone 7',
        'PROJECTED',
        4531,
        NULL,
        4258,
        18307,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2179,
        'ETRS89 / Poland CS2000 zone 8',
        'PROJECTED',
        4531,
        NULL,
        4258,
        18308,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2180,
        'ETRS89 / Poland CS92',
        'PROJECTED',
        4531,
        NULL,
        4258,
        18300,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2188,
        'Azores Occidental 1939 / UTM zone 25N',
        'PROJECTED',
        4400,
        NULL,
        4182,
        16025,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2189,
        'Azores Central 1948 / UTM zone 26N',
        'PROJECTED',
        4400,
        NULL,
        4183,
        16026,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2190,
        'Azores Oriental 1940 / UTM zone 26N',
        'PROJECTED',
        4400,
        NULL,
        4184,
        16026,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2191;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2191,
        'Madeira 1936 / UTM zone 28N',
        'PROJECTED',
        4400,
        NULL,
        4185,
        16028,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2192,
        'ED50 / France EuroLambert',
        'PROJECTED',
        4499,
        NULL,
        4230,
        18086,
        NULL,
        NULL,
        'IGN Paris via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2193,
        'NZGD2000 / New Zealand Transverse Mercator',
        'PROJECTED',
        4500,
        NULL,
        4167,
        19971,
        NULL,
        NULL,
        'Shell Todd Oil Services.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2194,
        'American Samoa 1962 / American Samoa Lambert',
        'PROJECTED',
        4497,
        NULL,
        4169,
        15301,
        NULL,
        NULL,
        'US National Geodetic Survey (NGS)  http://www.ngs.noaa.gov/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2195,
        'NAD83(HARN) / UTM zone 2S',
        'PROJECTED',
        4400,
        NULL,
        4152,
        16102,
        NULL,
        NULL,
        'US National Geodetic Survey (NGS)  http://www.ngs.noaa.gov/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2196,
        'ETRS89 / Kp2000 Jutland',
        'PROJECTED',
        4400,
        NULL,
        4258,
        18401,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2197,
        'ETRS89 / Kp2000 Zealand',
        'PROJECTED',
        4400,
        NULL,
        4258,
        18402,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2198,
        'ETRS89 / Kp2000 Bornholm',
        'PROJECTED',
        4400,
        NULL,
        4258,
        18403,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2199,
        'Albanian 1987 / Gauss Kruger zone 4',
        'PROJECTED',
        4530,
        NULL,
        4191,
        16204,
        NULL,
        NULL,
        'EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2200,
        'ATS77 / New Brunswick Stereographic (ATS77)',
        'PROJECTED',
        4500,
        NULL,
        4122,
        19945,
        NULL,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2201,
        'REGVEN / UTM zone 18N',
        'PROJECTED',
        4400,
        NULL,
        4189,
        16018,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2202,
        'REGVEN / UTM zone 19N',
        'PROJECTED',
        4400,
        NULL,
        4189,
        16019,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2203,
        'REGVEN / UTM zone 20N',
        'PROJECTED',
        4400,
        NULL,
        4189,
        16020,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2204,
        'NAD27 / Tennessee',
        'PROJECTED',
        4497,
        NULL,
        4267,
        15302,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2205,
        'NAD83 / Kentucky North',
        'PROJECTED',
        4499,
        NULL,
        4269,
        15303,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2206,
        'ED50 / 3-degree Gauss-Kruger zone 9',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16269,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2207,
        'ED50 / 3-degree Gauss-Kruger zone 10',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16270,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2208,
        'ED50 / 3-degree Gauss-Kruger zone 11',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16271,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2209,
        'ED50 / 3-degree Gauss-Kruger zone 12',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16272,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2210,
        'ED50 / 3-degree Gauss-Kruger zone 13',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16273,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2211,
        'ED50 / 3-degree Gauss-Kruger zone 14',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16274,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2212,
        'ED50 / 3-degree Gauss-Kruger zone 15',
        'PROJECTED',
        4530,
        NULL,
        4230,
        16275,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2213,
        'ETRS89 / TM 30 NE',
        'PROJECTED',
        4400,
        NULL,
        4258,
        16430,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2214,
        'Douala 1948 / AOF west',
        'PROJECTED',
        4400,
        NULL,
        4192,
        18415,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2215,
        'Manoca 1962 / UTM zone 32N',
        'PROJECTED',
        4400,
        NULL,
        4193,
        16032,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2216,
        'Qornoq 1927 / UTM zone 22N',
        'PROJECTED',
        4400,
        NULL,
        4194,
        16022,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2217,
        'Qornoq 1927 / UTM zone 23N',
        'PROJECTED',
        4400,
        NULL,
        4194,
        16023,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2218,
        'Scoresbysund 1952 / Greenland zone 5 east',
        'PROJECTED',
        4501,
        NULL,
        4195,
        18425,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2219,
        'ATS77 / UTM zone 19N',
        'PROJECTED',
        4400,
        NULL,
        4122,
        16019,
        NULL,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2220,
        'ATS77 / UTM zone 20N',
        'PROJECTED',
        4400,
        NULL,
        4122,
        16020,
        NULL,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2221,
        'Scoresbysund 1952 / Greenland zone 6 east',
        'PROJECTED',
        4501,
        NULL,
        4195,
        18426,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2222,
        'NAD83 / Arizona East (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15304,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2223,
        'NAD83 / Arizona Central (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15305,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2224,
        'NAD83 / Arizona West (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15306,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2225,
        'NAD83 / California zone 1 (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15307,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2226,
        'NAD83 / California zone 2 (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15308,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2227,
        'NAD83 / California zone 3 (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15309,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
select 'commit 21' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2228;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2228,
        'NAD83 / California zone 4 (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15310,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2229,
        'NAD83 / California zone 5 (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15311,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2230,
        'NAD83 / California zone 6 (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15312,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2231,
        'NAD83 / Colorado North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15313,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2232,
        'NAD83 / Colorado Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15314,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2233,
        'NAD83 / Colorado South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15315,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2234,
        'NAD83 / Connecticut (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15316,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2235,
        'NAD83 / Delaware (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15317,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2236,
        'NAD83 / Florida East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15318,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2237,
        'NAD83 / Florida West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15319,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2238,
        'NAD83 / Florida North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15320,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2239,
        'NAD83 / Georgia East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15321,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2240,
        'NAD83 / Georgia West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15322,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2241,
        'NAD83 / Idaho East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15323,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2242,
        'NAD83 / Idaho Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15324,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2243,
        'NAD83 / Idaho West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15325,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2244,
        'NAD83 / Indiana East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15326,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2245,
        'NAD83 / Indiana West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15327,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2246,
        'NAD83 / Kentucky North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15328,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2247,
        'NAD83 / Kentucky South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15329,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2248,
        'NAD83 / Maryland (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15330,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2249;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2249,
        'NAD83 / Massachusetts Mainland (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15331,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2250,
        'NAD83 / Massachusetts Island (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15332,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2251,
        'NAD83 / Michigan North (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15333,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2252,
        'NAD83 / Michigan Central (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15334,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2253,
        'NAD83 / Michigan South (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15335,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2254,
        'NAD83 / Mississippi East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15336,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2255,
        'NAD83 / Mississippi West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15337,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2256,
        'NAD83 / Montana (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15338,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2257,
        'NAD83 / New Mexico East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15339,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2258,
        'NAD83 / New Mexico Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15340,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2259,
        'NAD83 / New Mexico West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15341,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2260,
        'NAD83 / New York East (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15342,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2261,
        'NAD83 / New York Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15343,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2262,
        'NAD83 / New York West (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15344,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2263,
        'NAD83 / New York Long Island (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15345,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2264,
        'NAD83 / North Carolina (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15346,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2265,
        'NAD83 / North Dakota North (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15347,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2266,
        'NAD83 / North Dakota South (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15348,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2267,
        'NAD83 / Oklahoma North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15349,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2268,
        'NAD83 / Oklahoma South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15350,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2269,
        'NAD83 / Oregon North (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15351,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2270,
        'NAD83 / Oregon South (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15352,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2271,
        'NAD83 / Pennsylvania North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15353,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2272,
        'NAD83 / Pennsylvania South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15354,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2273,
        'NAD83 / South Carolina (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15355,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2274,
        'NAD83 / Tennessee (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15356,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2275,
        'NAD83 / Texas North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15357,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2276,
        'NAD83 / Texas North Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15358,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2277,
        'NAD83 / Texas Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15359,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2278,
        'NAD83 / Texas South Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15360,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2279;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2279,
        'NAD83 / Texas South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15361,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2280,
        'NAD83 / Utah North (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15362,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2281,
        'NAD83 / Utah Central (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15363,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2282,
        'NAD83 / Utah South (ft)',
        'PROJECTED',
        4495,
        NULL,
        4269,
        15364,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2283,
        'NAD83 / Virginia North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15365,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2284,
        'NAD83 / Virginia South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15366,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2285,
        'NAD83 / Washington North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15367,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2286,
        'NAD83 / Washington South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15368,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2287,
        'NAD83 / Wisconsin North (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15369,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2288,
        'NAD83 / Wisconsin Central (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15370,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2289,
        'NAD83 / Wisconsin South (ftUS)',
        'PROJECTED',
        4497,
        NULL,
        4269,
        15371,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2290,
        'ATS77 / Prince Edward Isl. Stereographic (ATS77)',
        'PROJECTED',
        4496,
        NULL,
        4122,
        19933,
        NULL,
        NULL,
        'Geomatics Centre; Nova Scotia Ministry of Housing and Municipal Affairs.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2292,
        'NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83)',
        'PROJECTED',
        4496,
        NULL,
        4140,
        19960,
        NULL,
        NULL,
        'PEI Department of Transportation & Public Works',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2294,
        'ATS77 / MTM Nova Scotia zone 4',
        'PROJECTED',
        4400,
        NULL,
        4122,
        17794,
        NULL,
        NULL,
        'Geomatics Centre; Nova Scotia Ministry of Housing and Municipal Affairs.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2295,
        'ATS77 / MTM Nova Scotia zone 5',
        'PROJECTED',
        4400,
        NULL,
        4122,
        17795,
        NULL,
        NULL,
        'Geomatics Centre; Nova Scotia Ministry of Housing and Municipal Affairs.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2296,
        'Ammassalik 1958 / Greenland zone 7 east',
        'PROJECTED',
        4501,
        NULL,
        4196,
        18427,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2297,
        'Qornoq 1927 / Greenland zone 1 east',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18421,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2298,
        'Qornoq 1927 / Greenland zone 2 east',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18422,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2299,
        'Qornoq 1927 / Greenland zone 2 west',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18432,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2300,
        'Qornoq 1927 / Greenland zone 3 east',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18423,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2301,
        'Qornoq 1927 / Greenland zone 3 west',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18433,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2302,
        'Qornoq 1927 / Greenland zone 4 east',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18424,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2303,
        'Qornoq 1927 / Greenland zone 4 west',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18434,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2304,
        'Qornoq 1927 / Greenland zone 5 west',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18435,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2305,
        'Qornoq 1927 / Greenland zone 6 west',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18436,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2306,
        'Qornoq 1927 / Greenland zone 7 west',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18437,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2307,
        'Qornoq 1927 / Greenland zone 8 east',
        'PROJECTED',
        4501,
        NULL,
        4194,
        18428,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2308,
        'Batavia / TM 109 SE',
        'PROJECTED',
        4400,
        NULL,
        4211,
        16709,
        NULL,
        NULL,
        'BP Indonesia.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2309,
        'WGS 84 / TM 116 SE',
        'PROJECTED',
        4400,
        NULL,
        4326,
        16716,
        NULL,
        NULL,
        'BP Indonesia.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2310,
        'WGS 84 / TM 132 SE',
        'PROJECTED',
        4400,
        NULL,
        4326,
        16732,
        NULL,
        NULL,
        'BP Indonesia.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 2311;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2311,
        'WGS 84 / TM 6 NE',
        'PROJECTED',
        4400,
        NULL,
        4326,
        16406,
        NULL,
        NULL,
        'ExxonMobil.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2312,
        'Garoua / UTM zone 33N',
        'PROJECTED',
        4400,
        NULL,
        4197,
        16033,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2313,
        'Kousseri / UTM zone 33N',
        'PROJECTED',
        4400,
        NULL,
        4198,
        16033,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2314,
        'Trinidad 1903 / Trinidad Grid (ftCla)',
        'PROJECTED',
        4403,
        NULL,
        4302,
        19975,
        NULL,
        NULL,
        'BP',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2315,
        'Campo Inchauspe / UTM zone 19S',
        'PROJECTED',
        4400,
        NULL,
        4221,
        16119,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2316,
        'Campo Inchauspe / UTM zone 20S',
        'PROJECTED',
        4400,
        NULL,
        4221,
        16120,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2317,
        'PSAD56 / ICN Regional',
        'PROJECTED',
        4499,
        NULL,
        4248,
        19976,
        NULL,
        NULL,
        'Institute Cartografica Nacional',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2318,
        'Ain el Abd / Aramco Lambert',
        'PROJECTED',
        4400,
        NULL,
        4204,
        19977,
        NULL,
        NULL,
        'Saudi Aramco',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2391,
        'KKJ / Finland zone 1',
        'PROJECTED',
        4530,
        NULL,
        4123,
        18191,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2392,
        'KKJ / Finland zone 2',
        'PROJECTED',
        4530,
        NULL,
        4123,
        18192,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2393,
        'KKJ / Finland Uniform Coordinate System',
        'PROJECTED',
        4530,
        NULL,
        4123,
        18193,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2394,
        'KKJ / Finland zone 4',
        'PROJECTED',
        4530,
        NULL,
        4123,
        18194,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2400,
        'RT90 2.5 gon W',
        'PROJECTED',
        4530,
        NULL,
        4124,
        19929,
        NULL,
        NULL,
        'National Land Survey of Sweden',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2550,
        'Samboja / UTM zone 50S',
        'PROJECTED',
        4400,
        NULL,
        4125,
        16150,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2600,
        'Lietuvos Koordinoei Sistema 1994',
        'PROJECTED',
        4530,
        NULL,
        4126,
        19934,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2736,
        'Tete / UTM zone 36S',
        'PROJECTED',
        4400,
        NULL,
        4127,
        16136,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        2737,
        'Tete / UTM zone 37S',
        'PROJECTED',
        4400,
        NULL,
        4127,
        16137,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3036,
        'Moznet / UTM zone 36S',
        'PROJECTED',
        4400,
        NULL,
        4130,
        16136,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3037,
        'Moznet / UTM zone 37S',
        'PROJECTED',
        4400,
        NULL,
        4130,
        16137,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3148,
        'Indian 1960 / UTM zone 48N',
        'PROJECTED',
        4400,
        NULL,
        4131,
        16048,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3149,
        'Indian 1960 / UTM zone 49N',
        'PROJECTED',
        4400,
        NULL,
        4131,
        16049,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3176,
        'Indian 1960 / TM 106 NE',
        'PROJECTED',
        4400,
        NULL,
        4131,
        16506,
        NULL,
        NULL,
        'Petrovietnam',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3200,
        'FD58 / Iraq zone',
        'PROJECTED',
        4400,
        NULL,
        4132,
        19906,
        NULL,
        NULL,
        'IOEPC records.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3300,
        'Estonian Coordinate System of 1992',
        'PROJECTED',
        4530,
        NULL,
        4133,
        19938,
        NULL,
        NULL,
        'http://www.geo.ut.ee/~raivo/estcoord.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3301,
        'Estonian Coordinate System of 1997',
        'PROJECTED',
        4530,
        NULL,
        4180,
        19938,
        NULL,
        NULL,
        'Estonian National Land Board via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3439,
        'PSD93 / UTM zone 39N',
        'PROJECTED',
        4400,
        NULL,
        4134,
        16039,
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3440,
        'PSD93 / UTM zone 40N',
        'PROJECTED',
        4400,
        NULL,
        4134,
        16040,
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3561,
        'Old Hawaiian / Hawaii zone 1',
        'PROJECTED',
        4497,
        NULL,
        4135,
        15101,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3562,
        'Old Hawaiian / Hawaii zone 2',
        'PROJECTED',
        4497,
        NULL,
        4135,
        15102,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3563,
        'Old Hawaiian / Hawaii zone 3',
        'PROJECTED',
        4497,
        NULL,
        4135,
        15103,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 3564;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3564,
        'Old Hawaiian / Hawaii zone 4',
        'PROJECTED',
        4497,
        NULL,
        4135,
        15104,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3565,
        'Old Hawaiian / Hawaii zone 5',
        'PROJECTED',
        4497,
        NULL,
        4135,
        15105,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3920,
        'Puerto Rico / UTM zone 20N',
        'PROJECTED',
        4400,
        NULL,
        4139,
        16020,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3991,
        'Puerto Rico State Plane CS of 1927',
        'PROJECTED',
        4497,
        NULL,
        4139,
        15201,
        NULL,
        NULL,
        'US National Geodetic Survey',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        3992,
        'Puerto Rico / St. Croix',
        'PROJECTED',
        4497,
        NULL,
        4139,
        15202,
        NULL,
        NULL,
        'US National Geodetic Survey',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4120,
        'Greek',
        'GEOGRAPHIC2D',
        6422,
        6120,
        NULL,
        NULL,
        NULL,
        NULL,
        'Topography Department; National Technical University of Greece.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4121,
        'GGRS87',
        'GEOGRAPHIC2D',
        6422,
        6121,
        NULL,
        NULL,
        NULL,
        NULL,
        'Geodesy Department; Public Petroleum Corporation of Greece.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4122,
        'ATS77',
        'GEOGRAPHIC2D',
        6422,
        6122,
        NULL,
        NULL,
        NULL,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4123,
        'KKJ',
        'GEOGRAPHIC2D',
        6422,
        6123,
        NULL,
        NULL,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4124,
        'RT90',
        'GEOGRAPHIC2D',
        6422,
        6124,
        NULL,
        NULL,
        NULL,
        NULL,
        'National Land Survey of Sweden',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4125,
        'Samboja',
        'GEOGRAPHIC2D',
        6402,
        6125,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4126,
        'LKS94 (ETRS89)',
        'GEOGRAPHIC2D',
        6402,
        6126,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4127,
        'Tete',
        'GEOGRAPHIC2D',
        6422,
        6127,
        NULL,
        NULL,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4128,
        'Madzansua',
        'GEOGRAPHIC2D',
        6422,
        6128,
        NULL,
        NULL,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4129,
        'Observatario',
        'GEOGRAPHIC2D',
        6422,
        6129,
        NULL,
        NULL,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4130,
        'Moznet',
        'GEOGRAPHIC2D',
        6422,
        6130,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4131,
        'Indian 1960',
        'GEOGRAPHIC2D',
        6422,
        6131,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4132,
        'FD58',
        'GEOGRAPHIC2D',
        6422,
        6132,
        NULL,
        NULL,
        NULL,
        NULL,
        'IOEPC records.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4133,
        'EST92',
        'GEOGRAPHIC2D',
        6422,
        6133,
        NULL,
        NULL,
        NULL,
        NULL,
        'http://www.geo.ut.ee/~raivo/estcoord.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4134,
        'PDO Survey Datum 1993',
        'GEOGRAPHIC2D',
        6422,
        6134,
        NULL,
        NULL,
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4135,
        'Old Hawaiian',
        'GEOGRAPHIC2D',
        6422,
        6135,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4136,
        'St. Lawrence Island',
        'GEOGRAPHIC2D',
        6422,
        6136,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4137,
        'St. Paul Island',
        'GEOGRAPHIC2D',
        6422,
        6137,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4138,
        'St. George Island',
        'GEOGRAPHIC2D',
        6422,
        6138,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4139,
        'Puerto Rico',
        'GEOGRAPHIC2D',
        6422,
        6139,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4140,
        'NAD83(CSRS98)',
        'GEOGRAPHIC2D',
        6402,
        6140,
        NULL,
        NULL,
        NULL,
        NULL,
        'Service New Brunswick Land and Information Standards Manual',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4141,
        'Israel',
        'GEOGRAPHIC2D',
        6422,
        6141,
        NULL,
        NULL,
        NULL,
        NULL,
        'Survey of Israel',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4142,
        'Locodjo 1965',
        'GEOGRAPHIC2D',
        6422,
        6142,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4143,
        'Abidjan 1987',
        'GEOGRAPHIC2D',
        6422,
        6143,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4144,
        'Kalianpur 1937',
        'GEOGRAPHIC2D',
        6422,
        6144,
        NULL,
        NULL,
        NULL,
        NULL,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4145;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4145,
        'Kalianpur 1962',
        'GEOGRAPHIC2D',
        6422,
        6145,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4146,
        'Kalianpur 1975',
        'GEOGRAPHIC2D',
        6422,
        6146,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4147,
        'Hanoi 1972',
        'GEOGRAPHIC2D',
        6422,
        6147,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4148,
        'Hartebeesthoek94',
        'GEOGRAPHIC2D',
        6422,
        6148,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4149,
        'CH1903',
        'GEOGRAPHIC2D',
        6422,
        6149,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4150,
        'CH1903+',
        'GEOGRAPHIC2D',
        6422,
        6150,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4151,
        'CHTRF95',
        'GEOGRAPHIC2D',
        6422,
        6151,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4152,
        'NAD83(HARN)',
        'GEOGRAPHIC2D',
        6422,
        6152,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4153,
        'Rassadiran',
        'GEOGRAPHIC2D',
        6422,
        6153,
        NULL,
        NULL,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4154,
        'ED50(ED77)',
        'GEOGRAPHIC2D',
        6422,
        6154,
        NULL,
        NULL,
        NULL,
        NULL,
        'National Cartographic Centre of Iran',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4155,
        'Dabola 1981',
        'GEOGRAPHIC2D',
        6422,
        6155,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4156,
        'S-JTSK',
        'GEOGRAPHIC2D',
        6422,
        6156,
        NULL,
        NULL,
        NULL,
        NULL,
        'Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4157,
        'Mount Dillon',
        'GEOGRAPHIC2D',
        6422,
        6157,
        NULL,
        NULL,
        NULL,
        NULL,
        'University of the West Indies Geodetic Services.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4158,
        'Naparima 1955',
        'GEOGRAPHIC2D',
        6422,
        6158,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey International.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4159,
        'ELD79',
        'GEOGRAPHIC2D',
        6422,
        6159,
        NULL,
        NULL,
        NULL,
        NULL,
        'Various oil company records.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4160,
        'Chos Malal 1914',
        'GEOGRAPHIC2D',
        6422,
        6160,
        NULL,
        NULL,
        NULL,
        NULL,
        'Various oil company records.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4161,
        'Pampa del Castillo',
        'GEOGRAPHIC2D',
        6422,
        6161,
        NULL,
        NULL,
        NULL,
        NULL,
        'Various oil company records.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4162,
        'Korean 1985',
        'GEOGRAPHIC2D',
        6422,
        6162,
        NULL,
        NULL,
        NULL,
        NULL,
        'Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1999. http://www.asprs.org/resources.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4163,
        'Yemen NGN96',
        'GEOGRAPHIC2D',
        6422,
        6163,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4164,
        'South Yemen',
        'GEOGRAPHIC2D',
        6422,
        6164,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4165,
        'Bissau',
        'GEOGRAPHIC2D',
        6422,
        6165,
        NULL,
        NULL,
        NULL,
        NULL,
        'NIMA',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4166,
        'Korean 1995',
        'GEOGRAPHIC2D',
        6422,
        6166,
        NULL,
        NULL,
        NULL,
        NULL,
        'NIMA TR8350.2  ftp://164.214.2.65/pub/gg/tr8350.2/changes.pdf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4167,
        'NZGD2000',
        'GEOGRAPHIC2D',
        6422,
        6167,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4168,
        'Accra',
        'GEOGRAPHIC2D',
        6422,
        6168,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4169,
        'American Samoa 1962',
        'GEOGRAPHIC2D',
        6422,
        6169,
        NULL,
        NULL,
        NULL,
        NULL,
        'NIMA TR8350.2 revision of January 2000 and ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon/samoa_readme.txt',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4170,
        'SIRGAS',
        'GEOGRAPHIC2D',
        6422,
        6170,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4171,
        'RGF93',
        'GEOGRAPHIC2D',
        6422,
        6171,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4173,
        'IRENET95',
        'GEOGRAPHIC2D',
        6422,
        6173,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4174,
        'Sierra Leone 1924',
        'GEOGRAPHIC2D',
        6422,
        6174,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4175,
        'Sierra Leone 1968',
        'GEOGRAPHIC2D',
        6422,
        6175,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey International.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4176;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4176,
        'Australian Antarctic',
        'GEOGRAPHIC2D',
        6422,
        6176,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'ISO 19127',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4178,
        'Pulkovo 1942(83)',
        'GEOGRAPHIC2D',
        6422,
        6178,
        NULL,
        NULL,
        NULL,
        NULL,
        'Bundesamt fur Kartographie und Geodasie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4179,
        'Pulkovo 1942(58)',
        'GEOGRAPHIC2D',
        6422,
        6179,
        NULL,
        NULL,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4180,
        'EST97',
        'GEOGRAPHIC2D',
        6422,
        6180,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4181,
        'Luxembourg 1930',
        'GEOGRAPHIC2D',
        6422,
        6181,
        NULL,
        NULL,
        NULL,
        NULL,
        'Administration du Cadastre et de la Topographie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4182,
        'Azores Occidental 1939',
        'GEOGRAPHIC2D',
        6422,
        6182,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4183,
        'Azores Central 1948',
        'GEOGRAPHIC2D',
        6422,
        6183,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4184,
        'Azores Oriental 1940',
        'GEOGRAPHIC2D',
        6422,
        6184,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4185,
        'Madeira 1936',
        'GEOGRAPHIC2D',
        6402,
        6185,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4188,
        'OSNI 1952',
        'GEOGRAPHIC2D',
        6422,
        6188,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey of Northern Ireland.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4189,
        'REGVEN',
        'GEOGRAPHIC2D',
        6422,
        6189,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4190,
        'POSGAR 98',
        'GEOGRAPHIC2D',
        6422,
        6190,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4191,
        'Albanian 1987',
        'GEOGRAPHIC2D',
        6422,
        6191,
        NULL,
        NULL,
        NULL,
        NULL,
        'EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4192,
        'Douala 1948',
        'GEOGRAPHIC2D',
        6422,
        6192,
        NULL,
        NULL,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4193,
        'Manoca 1962',
        'GEOGRAPHIC2D',
        6422,
        6193,
        NULL,
        NULL,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4194,
        'Qornoq 1927',
        'GEOGRAPHIC2D',
        6422,
        6194,
        NULL,
        NULL,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4195,
        'Scoresbysund 1952',
        'GEOGRAPHIC2D',
        6422,
        6195,
        NULL,
        NULL,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4196,
        'Ammassalik 1958',
        'GEOGRAPHIC2D',
        6422,
        6196,
        NULL,
        NULL,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4197,
        'Garoua',
        'GEOGRAPHIC2D',
        6422,
        6197,
        NULL,
        NULL,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4198,
        'Kousseri',
        'GEOGRAPHIC2D',
        6422,
        6198,
        NULL,
        NULL,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
select 'commit 22' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4199;
  if(rec_count = 0) then
    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4199,
        'Egypt 1930',
        'GEOGRAPHIC2D',
        6422,
        6199,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4200,
        'Pulkovo 1995',
        'GEOGRAPHIC2D',
        6422,
        6200,
        NULL,
        NULL,
        NULL,
        NULL,
        '"Main Terms of Reference for the State Geodetic Network"; Federal Geodetic Service of Russia; 1994',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4201,
        'Adindan',
        'GEOGRAPHIC2D',
        6422,
        6201,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4202,
        'AGD66',
        'GEOGRAPHIC2D',
        6422,
        6202,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        81920,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4203,
        'AGD84',
        'GEOGRAPHIC2D',
        6422,
        6203,
        NULL,
        NULL,
        NULL,
        NULL,
        '"GDA technical manual v2_2", Intergovernmental Committee on Surveying and Mapping. www.anzlic.org.au/icsm/gdtm/',
        'EPSG',
        'FALSE',
        81921,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4204,
        'Ain el Abd',
        'GEOGRAPHIC2D',
        6422,
        6204,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4205,
        'Afgooye',
        'GEOGRAPHIC2D',
        6422,
        6205,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4206,
        'Agadez',
        'GEOGRAPHIC2D',
        6422,
        6206,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4207,
        'Lisbon',
        'GEOGRAPHIC2D',
        6422,
        6207,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4208;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4208,
        'Aratu',
        'GEOGRAPHIC2D',
        6422,
        6208,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4209,
        'Arc 1950',
        'GEOGRAPHIC2D',
        6422,
        6209,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4210,
        'Arc 1960',
        'GEOGRAPHIC2D',
        6422,
        6210,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4211,
        'Batavia',
        'GEOGRAPHIC2D',
        6422,
        6211,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4212,
        'Barbados 1938',
        'GEOGRAPHIC2D',
        6422,
        6212,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4213,
        'Beduaram',
        'GEOGRAPHIC2D',
        6422,
        6213,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4214,
        'Beijing 1954',
        'GEOGRAPHIC2D',
        6422,
        6214,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4215,
        'Belge 1950',
        'GEOGRAPHIC2D',
        6422,
        6215,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4216,
        'Bermuda 1957',
        'GEOGRAPHIC2D',
        6422,
        6216,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4218,
        'Bogota 1975',
        'GEOGRAPHIC2D',
        6422,
        6218,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGAC special publication no. 1, "Geodesia" 4th edition, 1975.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4219,
        'Bukit Rimpah',
        'GEOGRAPHIC2D',
        6422,
        6219,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4220,
        'Camacupa',
        'GEOGRAPHIC2D',
        6422,
        6220,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4221,
        'Campo Inchauspe',
        'GEOGRAPHIC2D',
        6422,
        6221,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4222,
        'Cape',
        'GEOGRAPHIC2D',
        6422,
        6222,
        NULL,
        NULL,
        NULL,
        NULL,
        'Directorate of Surveys and Mapping, Mowbray, South Africa.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4223,
        'Carthage',
        'GEOGRAPHIC2D',
        6422,
        6223,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4224,
        'Chua',
        'GEOGRAPHIC2D',
        6422,
        6224,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4225,
        'Corrego Alegre',
        'GEOGRAPHIC2D',
        6422,
        6225,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4227,
        'Deir ez Zor',
        'GEOGRAPHIC2D',
        6422,
        6227,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4229,
        'Egypt 1907',
        'GEOGRAPHIC2D',
        6422,
        6229,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4230,
        'ED50',
        'GEOGRAPHIC2D',
        6422,
        6230,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4231,
        'ED87',
        'GEOGRAPHIC2D',
        6422,
        6231,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4232,
        'Fahud',
        'GEOGRAPHIC2D',
        6422,
        6232,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4233,
        'Gandajika 1970',
        'GEOGRAPHIC2D',
        6422,
        6233,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4235,
        'Guyane Francaise',
        'GEOGRAPHIC2D',
        6402,
        6235,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4236,
        'Hu Tzu Shan',
        'GEOGRAPHIC2D',
        6422,
        6236,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4237,
        'HD72',
        'GEOGRAPHIC2D',
        6422,
        6237,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4238,
        'ID74',
        'GEOGRAPHIC2D',
        6422,
        6238,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4239,
        'Indian 1954',
        'GEOGRAPHIC2D',
        6422,
        6239,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4240,
        'Indian 1975',
        'GEOGRAPHIC2D',
        6422,
        6240,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4241,
        'Jamaica 1875',
        'GEOGRAPHIC2D',
        6422,
        6241,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4242;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4242,
        'JAD69',
        'GEOGRAPHIC2D',
        6422,
        6242,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4243,
        'Kalianpur 1880',
        'GEOGRAPHIC2D',
        6422,
        6243,
        NULL,
        NULL,
        NULL,
        NULL,
        'G. Bomford; "The Re-adjustment of the Indian Triangulation"; Survey of India Professional Paper 28; 1939.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4244,
        'Kandawala',
        'GEOGRAPHIC2D',
        6422,
        6244,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4245,
        'Kertau',
        'GEOGRAPHIC2D',
        6422,
        6245,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4246,
        'KOC',
        'GEOGRAPHIC2D',
        6422,
        6246,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4247,
        'La Canoa',
        'GEOGRAPHIC2D',
        6422,
        6247,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4248,
        'PSAD56',
        'GEOGRAPHIC2D',
        6422,
        6248,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4249,
        'Lake',
        'GEOGRAPHIC2D',
        6422,
        6249,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4250,
        'Leigon',
        'GEOGRAPHIC2D',
        6422,
        6250,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4251,
        'Liberia 1964',
        'GEOGRAPHIC2D',
        6422,
        6251,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4252,
        'Lome',
        'GEOGRAPHIC2D',
        6422,
        6252,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4253,
        'Luzon 1911',
        'GEOGRAPHIC2D',
        6422,
        6253,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4254,
        'Hito XVIII 1963',
        'GEOGRAPHIC2D',
        6422,
        6254,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4255,
        'Herat North',
        'GEOGRAPHIC2D',
        6422,
        6255,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4256,
        'Mahe 1971',
        'GEOGRAPHIC2D',
        6422,
        6256,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4257,
        'Makassar',
        'GEOGRAPHIC2D',
        6422,
        6257,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4258,
        'ETRS89',
        'GEOGRAPHIC2D',
        6422,
        6258,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4259,
        'Malongo 1987',
        'GEOGRAPHIC2D',
        6422,
        6259,
        NULL,
        NULL,
        NULL,
        NULL,
        'Chevron Petroleum Technology',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4261,
        'Merchich',
        'GEOGRAPHIC2D',
        6422,
        6261,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4262,
        'Massawa',
        'GEOGRAPHIC2D',
        6422,
        6262,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4263,
        'Minna',
        'GEOGRAPHIC2D',
        6422,
        6263,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4264,
        'Mhast',
        'GEOGRAPHIC2D',
        6422,
        6264,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4265,
        'Monte Mario',
        'GEOGRAPHIC2D',
        6422,
        6265,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4266,
        'M''poraloko',
        'GEOGRAPHIC2D',
        6422,
        6266,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4267,
        'NAD27',
        'GEOGRAPHIC2D',
        6422,
        6267,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4268,
        'NAD27 Michigan',
        'GEOGRAPHIC2D',
        6422,
        6268,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4269,
        'NAD83',
        'GEOGRAPHIC2D',
        6422,
        6269,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4270,
        'Nahrwan 1967',
        'GEOGRAPHIC2D',
        6422,
        6270,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4271,
        'Naparima 1972',
        'GEOGRAPHIC2D',
        6422,
        6271,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey International.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4272,
        'NZGD49',
        'GEOGRAPHIC2D',
        6422,
        6272,
        NULL,
        NULL,
        NULL,
        NULL,
        'New Zealand Department of Lands and Surveys Technical Report No. 1; 1978.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4273;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4273,
        'NGO 1948',
        'GEOGRAPHIC2D',
        6422,
        6273,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4274,
        'Datum 73',
        'GEOGRAPHIC2D',
        6422,
        6274,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4275,
        'NTF',
        'GEOGRAPHIC2D',
        6422,
        6275,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4276,
        'NSWC 9Z-2',
        'GEOGRAPHIC2D',
        6422,
        6276,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4277,
        'OSGB 1936',
        'GEOGRAPHIC2D',
        6422,
        6277,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4278,
        'OSGB70',
        'GEOGRAPHIC2D',
        6422,
        6278,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4279,
        'OS(SN)80',
        'GEOGRAPHIC2D',
        6422,
        6279,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4280,
        'Padang',
        'GEOGRAPHIC2D',
        6422,
        6280,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4281,
        'Palestine 1923',
        'GEOGRAPHIC2D',
        6422,
        6281,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4282,
        'Pointe Noire',
        'GEOGRAPHIC2D',
        6422,
        6282,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4283,
        'GDA94',
        'GEOGRAPHIC2D',
        6422,
        6283,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4284,
        'Pulkovo 1942',
        'GEOGRAPHIC2D',
        6422,
        6284,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4285,
        'Qatar 1974',
        'GEOGRAPHIC2D',
        6422,
        6285,
        NULL,
        NULL,
        NULL,
        NULL,
        'Qatar Centre for Geographic Information.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4286,
        'Qatar 1948',
        'GEOGRAPHIC2D',
        6422,
        6286,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4288,
        'Loma Quintana',
        'GEOGRAPHIC2D',
        6422,
        6288,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4289,
        'Amersfoort',
        'GEOGRAPHIC2D',
        6422,
        6289,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4291,
        'SAD69',
        'GEOGRAPHIC2D',
        6402,
        6291,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4292,
        'Sapper Hill 1943',
        'GEOGRAPHIC2D',
        6422,
        6292,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4293,
        'Schwarzeck',
        'GEOGRAPHIC2D',
        6422,
        6293,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4294,
        'Segora',
        'GEOGRAPHIC2D',
        6402,
        6294,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4295,
        'Serindung',
        'GEOGRAPHIC2D',
        6422,
        6295,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4296,
        'Sudan',
        'GEOGRAPHIC2D',
        6402,
        6296,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4297,
        'Tananarive',
        'GEOGRAPHIC2D',
        6422,
        6297,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4298,
        'Timbalai 1948',
        'GEOGRAPHIC2D',
        6422,
        6298,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4299,
        'TM65',
        'GEOGRAPHIC2D',
        6422,
        6299,
        NULL,
        NULL,
        NULL,
        NULL,
        '"The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4300,
        'TM75',
        'GEOGRAPHIC2D',
        6422,
        6300,
        NULL,
        NULL,
        NULL,
        NULL,
        '"The Irish Grid - A Description of the Co-ordinate Reference System" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4301,
        'Tokyo',
        'GEOGRAPHIC2D',
        6422,
        6301,
        NULL,
        NULL,
        NULL,
        NULL,
        'Geographic Survey Institute; Japan; Bulletin 40 (March 1994).  Also http://vldb.gsi.go.jp/sokuchi/datum/tokyodatum.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4302,
        'Trinidad 1903',
        'GEOGRAPHIC2D',
        6422,
        6302,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4303,
        'TC(1948)',
        'GEOGRAPHIC2D',
        6422,
        6303,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4304,
        'Voirol 1875',
        'GEOGRAPHIC2D',
        6422,
        6304,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4306;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4306,
        'Bern 1938',
        'GEOGRAPHIC2D',
        6422,
        6306,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4307,
        'Nord Sahara 1959',
        'GEOGRAPHIC2D',
        6422,
        6307,
        NULL,
        NULL,
        NULL,
        NULL,
        '"Le System Geodesique Nord-Sahara"; IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4308,
        'RT38',
        'GEOGRAPHIC2D',
        6422,
        6308,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4309,
        'Yacare',
        'GEOGRAPHIC2D',
        6422,
        6309,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4310,
        'Yoff',
        'GEOGRAPHIC2D',
        6422,
        6310,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4311,
        'Zanderij',
        'GEOGRAPHIC2D',
        6422,
        6311,
        NULL,
        NULL,
        NULL,
        NULL,
        'Shell International',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4312,
        'MGI',
        'GEOGRAPHIC2D',
        6422,
        6312,
        NULL,
        NULL,
        NULL,
        NULL,
        'Bundesamt fur Eich- und Vermessungswesen; Wien',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4313,
        'Belge 1972',
        'GEOGRAPHIC2D',
        6422,
        6313,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4314,
        'DHDN',
        'GEOGRAPHIC2D',
        6422,
        6314,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4315,
        'Conakry 1905',
        'GEOGRAPHIC2D',
        6422,
        6315,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4316,
        'Dealul Piscului 1933',
        'GEOGRAPHIC2D',
        6422,
        6316,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4317,
        'Dealul Piscului 1970',
        'GEOGRAPHIC2D',
        6422,
        6317,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4318,
        'NGN',
        'GEOGRAPHIC2D',
        6422,
        6318,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4319,
        'KUDAMS',
        'GEOGRAPHIC2D',
        6422,
        6319,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4322,
        'WGS 72',
        'GEOGRAPHIC2D',
        6422,
        6322,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4324,
        'WGS 72BE',
        'GEOGRAPHIC2D',
        6422,
        6324,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4326,
        'WGS 84',
        'GEOGRAPHIC2D',
        6422,
        6326,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG. See 3D CRS for original information source.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4327,
        'WGS 84 (geographic 3D)',
        'GEOGRAPHIC3D',
        6401,
        6326,
        NULL,
        NULL,
        NULL,
        NULL,
        'NIMA TR8350.2 January 2000 revision. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4328,
        'WGS 84 (geocentric)',
        'GEOCENTRIC',
        6500,
        6326,
        NULL,
        NULL,
        NULL,
        NULL,
        'NIMA TR8350.2 January 2000 revision. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4600,
        'Anguilla 1957',
        'GEOGRAPHIC2D',
        6422,
        6600,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4601,
        'Antigua 1943',
        'GEOGRAPHIC2D',
        6422,
        6601,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4602,
        'Dominica 1945',
        'GEOGRAPHIC2D',
        6422,
        6602,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4603,
        'Grenada 1953',
        'GEOGRAPHIC2D',
        6422,
        6603,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4604,
        'Montserrat 1958',
        'GEOGRAPHIC2D',
        6422,
        6604,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4605,
        'St. Kitts 1955',
        'GEOGRAPHIC2D',
        6422,
        6605,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4606,
        'St. Lucia 1955',
        'GEOGRAPHIC2D',
        6422,
        6606,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4607,
        'St. Vincent 1945',
        'GEOGRAPHIC2D',
        6422,
        6607,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4608,
        'NAD27(76)',
        'GEOGRAPHIC2D',
        6422,
        6608,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4609,
        'NAD27(CGQ77)',
        'GEOGRAPHIC2D',
        6422,
        6609,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4610,
        'Xian 1980',
        'GEOGRAPHIC2D',
        6422,
        6610,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4801;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4801,
        'Bern 1898 (Bern)',
        'GEOGRAPHIC2D',
        6422,
        6801,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4802,
        'Bogota 1975 (Bogota)',
        'GEOGRAPHIC2D',
        6422,
        6802,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGAC special publication no. 1, "Geodesia" 4th edition, 1975.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4803,
        'Lisbon (Lisbon)',
        'GEOGRAPHIC2D',
        6422,
        6803,
        NULL,
        NULL,
        NULL,
        NULL,
        'Instituto Geografico e Cadastral; Lisbon',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4804,
        'Makassar (Jakarta)',
        'GEOGRAPHIC2D',
        6422,
        6804,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4805,
        'MGI (Ferro)',
        'GEOGRAPHIC2D',
        6422,
        6805,
        NULL,
        NULL,
        NULL,
        NULL,
        'Bundesamt fur Eich- und Vermessungswesen; Wien',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4806,
        'Monte Mario (Rome)',
        'GEOGRAPHIC2D',
        6422,
        6806,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4807,
        'NTF (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6807,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4808,
        'Padang (Jakarta)',
        'GEOGRAPHIC2D',
        6422,
        6808,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4809,
        'Belge 1950 (Brussels)',
        'GEOGRAPHIC2D',
        6422,
        6809,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4810,
        'Tananarive (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6810,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4811,
        'Voirol 1875 (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6811,
        NULL,
        NULL,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4813,
        'Batavia (Jakarta)',
        'GEOGRAPHIC2D',
        6422,
        6813,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4814,
        'RT38 (Stockholm)',
        'GEOGRAPHIC2D',
        6422,
        6814,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
select 'commit 23' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 4815;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4815,
        'Greek (Athens)',
        'GEOGRAPHIC2D',
        6422,
        6815,
        NULL,
        NULL,
        NULL,
        NULL,
        'Topography Department; National Technical University of Greece.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4816,
        'Carthage (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6816,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4817,
        'NGO 1948 (Oslo)',
        'GEOGRAPHIC2D',
        6422,
        6817,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4818,
        'S-JTSK (Ferro)',
        'GEOGRAPHIC2D',
        6422,
        6818,
        NULL,
        NULL,
        NULL,
        NULL,
        'Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4819,
        'Nord Sahara 1959 (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6819,
        NULL,
        NULL,
        NULL,
        NULL,
        '"Le System Geodesique Nord-Sahara"; IGN Paris',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4901,
        'ATF (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6901,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4902,
        'NDG (Paris)',
        'GEOGRAPHIC2D',
        6403,
        6902,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        4903,
        'Madrid 1870 (Madrid)',
        'GEOGRAPHIC2D',
        6422,
        6903,
        NULL,
        NULL,
        NULL,
        NULL,
        'Institut de Geomatica; Barcelona.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5701,
        'Newlyn',
        'VERTICAL',
        6499,
        5101,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5702,
        'National Geodetic Vertical Datum of 1929',
        'VERTICAL',
        6497,
        5102,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5703,
        'North American Vertical Datum of 1988',
        'VERTICAL',
        6499,
        5103,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5704,
        'Yellow Sea',
        'VERTICAL',
        6499,
        5104,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5705,
        'Baltic',
        'VERTICAL',
        6499,
        5105,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5706,
        'Caspian',
        'VERTICAL',
        6498,
        5106,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5709,
        'Normaal Amsterdams Peil',
        'VERTICAL',
        6499,
        5109,
        NULL,
        NULL,
        NULL,
        NULL,
        'Nederlandse Commissie voor Geodesie publication 30; 1993',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5710,
        'Oostende',
        'VERTICAL',
        6499,
        5110,
        NULL,
        NULL,
        NULL,
        NULL,
        'Nederlandse Commissie voor Geodesie publication 30; 1993',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5711,
        'Australian Height Datum',
        'VERTICAL',
        6499,
        5111,
        NULL,
        NULL,
        NULL,
        NULL,
        'http://www.auslig.gov.au/geodesy',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 5712;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5712,
        'Australian Height Datum (Tasmania)',
        'VERTICAL',
        6499,
        5112,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5713,
        'Canadian Vertical Datum of 1928',
        'VERTICAL',
        6499,
        5114,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5714,
        'mean sea level height',
        'VERTICAL',
        6499,
        5100,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5715,
        'mean sea level depth',
        'VERTICAL',
        6498,
        5100,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5716,
        'Piraeus',
        'VERTICAL',
        6499,
        5115,
        NULL,
        NULL,
        NULL,
        NULL,
        'Geodesy Department; Public Petroleum Corporation of Greece.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5717,
        'N60',
        'VERTICAL',
        6499,
        5116,
        NULL,
        NULL,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5718,
        'RH70',
        'VERTICAL',
        6499,
        5117,
        NULL,
        NULL,
        NULL,
        NULL,
        'National and Survey of Sweden',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5719,
        'NGF Lallemand',
        'VERTICAL',
        6499,
        5118,
        NULL,
        NULL,
        NULL,
        NULL,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5720,
        'NGF IGN69',
        'VERTICAL',
        6499,
        5119,
        NULL,
        NULL,
        NULL,
        NULL,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5721,
        'NGF IGN78',
        'VERTICAL',
        6499,
        5120,
        NULL,
        NULL,
        NULL,
        NULL,
        'Conseil National de l''Information Geographique groupe de travail "Reseaux de Nivellement" recommendations v5.1 April 1994',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5722,
        'Maputo',
        'VERTICAL',
        6499,
        5121,
        NULL,
        NULL,
        NULL,
        NULL,
        'Direcao Nacional de Geografia e Cadastral (DINAGECA).',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5723,
        'Japanese Standard Levelling Datum',
        'VERTICAL',
        6499,
        5122,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi-mc.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5724,
        'PDO Height Datum 1993',
        'VERTICAL',
        6499,
        5123,
        NULL,
        NULL,
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5725,
        'Fahud Height Datum 1993',
        'VERTICAL',
        6499,
        5124,
        NULL,
        NULL,
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5726,
        'Ha Tien 1960',
        'VERTICAL',
        6499,
        5125,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5727,
        'Hon Dau 1992',
        'VERTICAL',
        6499,
        5126,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5728,
        'Landesnivellement 1902',
        'VERTICAL',
        6499,
        5127,
        NULL,
        NULL,
        NULL,
        NULL,
        'Bundesamt fur Landestopographie',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5729,
        'Landeshohennetz 1995',
        'VERTICAL',
        6499,
        5128,
        NULL,
        NULL,
        NULL,
        NULL,
        'Bundesamt fur Landestopographie',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5730,
        'European Vertical Reference System 2000',
        'VERTICAL',
        6499,
        5129,
        NULL,
        NULL,
        NULL,
        NULL,
        'IAG subcommission for Europe',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5731,
        'Malin Head',
        'VERTICAL',
        6499,
        5130,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey of Ireland.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5732,
        'Belfast',
        'VERTICAL',
        6499,
        5131,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ordnance Survey of Northern Ireland.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5733,
        'Dansk Normal Nul',
        'VERTICAL',
        6499,
        5132,
        NULL,
        NULL,
        NULL,
        NULL,
        'Kort & Matrikelstyrelsen',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5734,
        'AIOC95 depths',
        'VERTICAL',
        6498,
        5133,
        NULL,
        NULL,
        NULL,
        NULL,
        'BP',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5735,
        'Black Sea',
        'VERTICAL',
        6499,
        5134,
        NULL,
        NULL,
        NULL,
        NULL,
        'BP',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5800,
        'Astra Minas Grid',
        'ENGINEERING',
        6507,
        9300,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5801,
        'Barcelona Grid B1',
        'ENGINEERING',
        4500,
        9301,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5802,
        'Barcelona Grid B2',
        'ENGINEERING',
        4500,
        9301,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5803,
        'Maturin Grid',
        'ENGINEERING',
        4500,
        9302,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5804,
        'EPSG seismic bin grid example A',
        'ENGINEERING',
        6508,
        9312,
        NULL,
        NULL,
        NULL,
        NULL,
        'UKOOA P6/98 seismic bin grid guideline.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 5805;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5805,
        'EPSG seismic bin grid example B',
        'ENGINEERING',
        6506,
        9312,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5806,
        'EPSG local engineering grid example A',
        'ENGINEERING',
        6505,
        9313,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5807,
        'EPSG local engineering grid example B',
        'ENGINEERING',
        6504,
        9313,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5808,
        'Maracaibo Cross Grid M4',
        'ENGINEERING',
        4500,
        9303,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5809,
        'Maracaibo Cross Grid M5',
        'ENGINEERING',
        4500,
        9303,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5810,
        'La Rosa Grid',
        'ENGINEERING',
        4500,
        9304,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5811,
        'Mene Grande',
        'ENGINEERING',
        4500,
        9305,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5812,
        'El Cubo',
        'ENGINEERING',
        4500,
        9306,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5813,
        'Dabajuro',
        'ENGINEERING',
        4500,
        9307,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5814,
        'Tucupita',
        'ENGINEERING',
        4500,
        9308,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5815,
        'Santa Maria de Ipire',
        'ENGINEERING',
        4500,
        9310,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        5816,
        'Barinas west base',
        'ENGINEERING',
        4500,
        9311,
        NULL,
        NULL,
        NULL,
        NULL,
        'Ministry of Mines standards manual of 1974.',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7400,
        'NTF (Paris) + NGF IGN69',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        4807,
        5720,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7404,
        'RT90 + RH70',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        4124,
        5718,
        'National Land Survey of Sweden',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7405,
        'OSGB36 / British National Grid + ODN',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        27700,
        5701,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7406,
        'NAD27 + NGVD29',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        4267,
        5702,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7407,
        'NAD27 / Texas North + NGVD29',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        32037,
        5702,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7408,
        'RD/NAP',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        4289,
        5709,
        'http://rdnap.kadaster.nl/rd/index.html',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7409,
        'ETRS89 + EVRS2000',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        4258,
        5730,
        'IAG subcommission for Europe',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7410,
        'PSHD93',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        4134,
        5724,
        'Petroleum Development Oman',
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7411,
        'NTF (Paris) / Lambert zone II + NGF Lallemand',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        27572,
        5719,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7412,
        'NTF (Paris) / Lambert zone II + NGF IGN69',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        27572,
        5719,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        7413,
        'NTF (Paris) / Lambert zone III + NGF IGN69',
        'COMPOUND',
        NULL,
        NULL,
        NULL,
        NULL,
        27573,
        5719,
        NULL,
        'EPSG',
        'FALSE',
        NULL,
        NULL,
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8192,
        'Longitude / Latitude',
        'GEOGRAPHIC2D',
        NULL,
        10115,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (WGS 84)", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8193,
        'Longitude / Latitude (AGD 66)',
        'GEOGRAPHIC2D',
        NULL,
        10012,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (AGD 66)", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8194,
        'Longitude / Latitude (AGD 84)',
        'GEOGRAPHIC2D',
        NULL,
        10013,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (AGD 84)", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8195,
        'Longitude / Latitude (Adindan)',
        'GEOGRAPHIC2D',
        NULL,
        10001,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (Adindan)", DATUM ["Adindan", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8196,
        'Longitude / Latitude (Afgooye)',
        'GEOGRAPHIC2D',
        NULL,
        10002,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (Afgooye)", DATUM ["Afgooye", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8197,
        'Longitude / Latitude (Ain el Abd 1970)',
        'GEOGRAPHIC2D',
        NULL,
        10003,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (Ain el Abd 1970)", DATUM ["Ain el Abd 1970", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8198,
        'Longitude / Latitude (Anna 1 Astro 1965)',
        'GEOGRAPHIC2D',
        NULL,
        10004,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracle',
        NULL,
        'TRUE',
        NULL,
        'GEOGCS [ "Longitude / Latitude (Anna 1 Astro 1965)", DATUM ["Anna 1 Astro 1965", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]',
        NULL);
  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_REF_SYS where srid = 8199;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_REF_SYS (
        SRID,
        COORD_REF_SYS_NAME,
        COORD_REF_SYS_KIND,
        COORD_SYS_ID,
        DATUM_ID,
        SOURCE_GEOG_SRID,
        PROJECTION_CONV_ID,
        CMPD_HORIZ_SRID,
        CMPD_VERT_SRID,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        IS_LEGACY,
        LEGACY_CODE,
        LEGACY_WKTEXT,
        LEGACY_CS_BOUNDS)
      VALUES (
        8199,
        'Longitude / Latitude (Arc 1950)',
        'GEOGRAPHIC2D',
        NULL,
        10005,
        NULL,
        NULL,
        NULL,
        NULL,
        'Oracl