Rem
Rem $Header: sdo/admin/sdoutlh.sql /st_sdo_11.2.0.2_xe/1 2010/09/29 14:33:30 sravada Exp $
Rem
Rem sdoutlh.sql
Rem
Rem Copyright (c) 2001, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdoutlh.sql - SDO_UTIL package Header
Rem
Rem    DESCRIPTION
Rem      Declaration of the SDO_UTIL package.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yhu         05/17/10 - Backport yhu_bug-9526679 from main
Rem    rjanders    04/05/10 - Rename extractall() to extract_all()
Rem    rjanders    03/23/10 - Add sdo_util.extractall() API
Rem    bkazar      01/06/10 - add get_2d_footprint function to get footprint of
Rem                           3D objects
Rem    bkazar      09/03/09 - reactivating the second sdo_util.extrude signature
Rem    sravada     03/04/09 - bug 8307426
Rem    sravada     02/05/09 - add 11 dimensions to vertex_type
Rem    bkazar      12/22/08 - Bug 7627660: arcs and 2D invalid polygon for
Rem                           extrusion; deprecating extrude with cond
Rem                           parameter
Rem    bkazar      12/10/08 - bug 7629848: add number_of_components
Rem    bkazar      06/20/08 - add getlabelbyelement (commutable with extract3d)
Rem    bkazar      06/12/08 - bug 7158744 - extrusion fixes
Rem    sravada     06/02/08 - bug 7135496
Rem    sravada     05/01/08 - add GeometryToClob
Rem    sravada     03/31/08 - add get quad_tiles
Rem    ningan      02/29/08 - add point_to_line
Rem    bkazar      01/21/08 - add optional 3d srid for extrude
Rem    bkazar      09/29/07 - add from_kmlgeometry (to convert from KML 2.1 to sdo_geometry)
Rem    bkazar      09/28/07 - add to_kmlgeometry (to convert from sdo_geometry to KML 2.1)
Rem    rkothuri    06/19/07 - add remove_inner_rings
Rem    bkazar      06/12/07 - expand_geom added
Rem    bkazar      05/11/07 - add extract3d
Rem    bkazar      04/25/07 - append_to_collection is combined with append
Rem    bkazar      03/29/07 - add pl/sql wrapper for appendToCollection
Rem    bkazar      03/26/07 - pl/sql interface for extrusion and affine
Rem                           transforms
Rem    rkothuri    01/09/07 - add drop_work_tables
Rem    bkazar      12/08/06 - add from_GML311geometry (to convert GML311 to JGeometry)
Rem    bkazar      11/03/06 - add to_gml311geometry (to convert from JGeometry to GML311)
Rem    rkothuri    09/15/06 - 
Rem    mhorhamm    08/21/06 - Add signature to_wktgeometry_varchar
Rem    sravada     03/08/06 - add convert_distance 
Rem    sravada     02/16/06 - move to_gml to Java 
Rem    rkothuri    01/26/06 - change comments 
Rem    rkothuri    01/18/06 - add ptn_mbr_tbl 
Rem    rkothuri    01/13/06 - Add usage for ptntbl 
Rem    sravada     01/05/06 - add GML to Geometry 
Rem    rkothuri    12/28/05 - Add partition_table 
Rem    mhorhamm    05/06/05 - Before returning WKT for geom, first check CRS 
Rem                           kind 
Rem    mhorhamm    09/07/04 - Add function getNumRings 
Rem    sravada     07/30/04 - add create/replace 
Rem    mhorhamm    04/07/04 - Change param name 
Rem    sravada     03/09/04 - fix GTYPE_COLLECTION 
Rem    ningan      01/28/04 - add rectify_geometry
Rem    ningan      11/11/03 - bug 3217106
Rem    mhorhamm    08/13/03 - add validate functions for WKB and WKT 
Rem    mhorhamm    08/12/03 - add from_wktgeometry(VARCHAR2) 
Rem    mhorhamm    08/07/03 - Add functions to_wkbgeometry and to_wktgeometry 
Rem    sravada     07/11/03 - performance fix for get_geometry
Rem    sravada     06/30/03 - 
Rem    sravada     06/11/03 - add TTS init
Rem    sravada     06/09/03 - add Point from bearing and distance
Rem    sravada     06/05/03 - add reverse_linestring
Rem    sravada     04/11/03 - add sdo_concat
Rem    bblackwe    04/02/03 - collapse overloads of ellipse and circle gen; tolerance version only
Rem    bblackwe    02/14/03 - add tolerance overloads of circle and ellipse gen
Rem    sravada     02/13/03 - bug 2784667
Rem    jsharma     10/15/02 - Add TO_GML_GEOMETRY and related functions
Rem    sravada     09/17/02 - add TTS support
Rem    sravada     07/22/02 - add locus generator
Rem    jcwang      07/10/02 - Add Vertex ID in TYPE vertex_type for sorting
Rem    sravada     05/16/02 - add remove dup vertices
Rem    rkothuri    05/20/02 - Change name to spatial_join.
Rem    rkothuri    04/22/02 - add SpatialJoin function
Rem    ningan      02/08/02 - add GetNumElem(...)
Rem    ningan      02/05/02 - add RefineMGon(...)
Rem    ningan      02/04/02 - add OuterLn(...)
Rem    ningan      01/30/02 - add ExtractVoids(...)
Rem    ningan      01/01/02 - add GetNumVertices(...)
Rem    ningan      12/21/01 - add the geometry simplification functionality
Rem    sravada     04/01/02 - add polygon to line
Rem    jcwang      12/18/01 - add convert_number
Rem    sravada     08/15/01 - add vertex table functions
Rem    sravada     08/15/01 - Cleanup the headers, signatures
Rem    wexu        06/13/01 - Merged wexu_sdo_extract
Rem    wexu        05/24/01 - Created
Rem

-- Create the types needed for GetVertices function
declare
begin
  begin
   execute immediate 
    'drop type vertex_set_type ';
   execute immediate 
    'drop type vertex_type ';
   exception when others then NULL;
  end;
end;
/


Create type vertex_type as object
(X  number,
 Y  number,
 Z  number,
 W  number,
 v5 number,
 v6 number,
 v7 number,
 v8 number,
 v9 number,
 v10 number,
 v11 number,
 ID number );
/

create type vertex_set_type as TABLE of vertex_type;
/

grant execute on vertex_type to public;
grant execute on vertex_set_type to public;


CREATE OR REPLACE PACKAGE sdo_util AUTHID current_user AS

-- CONSTANT DECLARATION
  SDO_GTYPE_POLYGON       CONSTANT  NUMBER := 3;   
  SDO_GTYPE_MULTIPOLYGON  CONSTANT  NUMBER := 7;
  SDO_GTYPE_COLLECTION    CONSTANT  NUMBER := 4;


  Function expand_multi_point (geometry IN mdsys.sdo_geometry)
  RETURN SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

  FUNCTION expand_geom (geometry IN mdsys.sdo_geometry)
  RETURN mdsys.sdo_geometry DETERMINISTIC PARALLEL_ENABLE;

  FUNCTION extract(geometry IN mdsys.sdo_geometry,
                   element  IN NUMBER,
                   ring     IN NUMBER DEFAULT 0) 
    RETURN mdsys.sdo_geometry DETERMINISTIC  PARALLEL_ENABLE;
    PRAGMA restrict_references(extract, wnds, rnps, wnps, trust);

  FUNCTION extract_all(geometry IN mdsys.sdo_geometry,
                       flatten  IN NUMBER DEFAULT 1)
    RETURN mdsys.sdo_geometry_array DETERMINISTIC;
    PRAGMA restrict_references(extract_all, wnds, rnps, wnps, trust);

  FUNCTION append(geometry1 IN MDSYS.sdo_geometry,
                  geometry2 IN MDSYS.sdo_geometry)
    RETURN mdsys.sdo_geometry DETERMINISTIC PARALLEL_ENABLE;
    PRAGMA restrict_references(append, wnds, wnps);


  FUNCTION ExtractVoids(geometry IN mdsys.sdo_geometry,
                        dim      IN mdsys.sdo_dim_array)
    RETURN mdsys.sdo_geometry DETERMINISTIC PARALLEL_ENABLE;
    PRAGMA restrict_references(ExtractVoids, rnds, wnds, rnps, wnps, trust);

 FUNCTION GetVertices(geometry IN mdsys.sdo_geometry) 
 RETURN vertex_set_type;
-- PRAGMA restrict_references(GetVertices, wnds, rnps, wnps);

  FUNCTION GetNumElem(geometry IN mdsys.sdo_geometry)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    PRAGMA restrict_references(GetNumElem, rnds, wnds, rnps, wnps, trust);

  FUNCTION GetNumRings(
    geom IN MDSYS.SDO_GEOMETRY)
      RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
  PRAGMA restrict_references(GetNumRings, rnds, wnds, rnps, wnps, trust);

  FUNCTION GetNumVertices(geometry IN mdsys.sdo_geometry) 
    RETURN NUMBER PARALLEL_ENABLE;
    PRAGMA restrict_references(GetNumVertices, rnds, wnds, rnps, wnps, trust);

  FUNCTION OuterLn(geometry IN mdsys.sdo_geometry,
                   dim      IN mdsys.sdo_dim_array)
    RETURN mdsys.sdo_geometry DETERMINISTIC PARALLEL_ENABLE;
    PRAGMA restrict_references(OuterLn,rnds,wnds,rnps,wnps,trust);

  FUNCTION RefineMGon(mgon IN mdsys.sdo_geometry,
                      gon  IN mdsys.sdo_geometry,
                      dim  IN mdsys.sdo_dim_array)
    RETURN mdsys.sdo_geometry DETERMINISTIC;
    PRAGMA restrict_references(RefineMGon,rnds,wnds,rnps,wnps,trust);

 -- truncate the original number up to no_of_digits 
 -- no_of_digits positive:  truncate the number to no_of_digits AFTER the decimal point
 -- ex: truncate_number(1.123456789,5) returns 1.12345
 -- no_of_digits negative:  truncate the number up to no_of_digits BEFORE the decimal point
 -- ex: truncate_number(987654321.123456789,-5) returns 987600000.0
 
 FUNCTION truncate_number(value NUMBER, no_of_digits NUMBER)
    RETURN NUMBER PARALLEL_ENABLE;
 PRAGMA restrict_references(truncate_number, wnds, rnps, wnps);

 FUNCTION rectify_geometry(
    geometry     IN MDSYS.SDO_GEOMETRY,
    tolerance    IN NUMBER)
   RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;
   PRAGMA RESTRICT_REFERENCES(rectify_geometry, rnds, wnds, rnps, wnps, trust);

  /* simplify a geometry */
  FUNCTION simplify(
   geometry       IN mdsys.sdo_geometry,
   threshold      IN NUMBER,
   tolerance      IN NUMBER := 0.0000005) 
    RETURN mdsys.sdo_geometry DETERMINISTIC PARALLEL_ENABLE;
    PRAGMA restrict_references(simplify, rnds, wnds, rnps, wnps, trust);

 FUNCTION polygontoline(geometry IN mdsys.sdo_geometry)
    return MDSYS.SDO_GEOMETRY deterministic PARALLEL_ENABLE;

 FUNCTION point_to_line(
   geom1 IN mdsys.sdo_geometry,
   geom2 IN mdsys.sdo_geometry,
   tol   IN number := 10e-16)
   RETURN MDSYS.SDO_GEOMETRY deterministic PARALLEL_ENABLE;

 FUNCTION remove_duplicates(geometry IN sdo_geometry, dim in sdo_dim_array)
    return MDSYS.SDO_GEOMETRY deterministic PARALLEL_ENABLE;

 FUNCTION remove_duplicate_vertices(geometry IN sdo_geometry, 
                                                tolerance in NUMBER)
    return MDSYS.SDO_GEOMETRY deterministic PARALLEL_ENABLE;

 FUNCTION circle_polygon (center_longitude     number, 
                          center_latitude      number, 
                          radius               number,
                          arc_tolerance            number) 
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 FUNCTION ellipse_polygon (center_longitude                number, 
                           center_latitude                 number, 
                           semi_major_axis                 number,
                           semi_minor_axis                 number,
                           azimuth                         number,
                           arc_tolerance                       number) 
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 FUNCTION point_at_bearing(start_point sdo_geometry,
                   bearing number,
                   distance number)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 PROCEDURE bearing_tilt_for_points(
                   start_point sdo_geometry,
                   end_point sdo_geometry,
                   tol number,
                   bearing OUT number,
                   tilt OUT number) ;

 FUNCTION convert_unit(value NUMBER, in_unit varchar2, out_unit varchar2)
 RETURN number PARALLEL_ENABLE;

 FUNCTION convert_distance(srid  number, distance NUMBER, unit_spec  varchar2)
 RETURN number PARALLEL_ENABLE;

 PROCEDURE Prepare_For_TTS (table_space IN VARCHAR2);

 PROCEDURE Initialize_Indexes_For_TTS ;

 FUNCTION to_clob(Geometry IN MDSYS.SDO_GEOMETRY)
  RETURN CLOB DETERMINISTIC PARALLEL_ENABLE;

 FUNCTION from_clob(ClobGeom IN CLOB)
  RETURN SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

$IF utl_ident.is_oracle_xe <> TRUE $THEN 
 FUNCTION to_gmlgeometry(Geometry IN MDSYS.SDO_GEOMETRY) 
 RETURN CLOB DETERMINISTIC  PARALLEL_ENABLE AS LANGUAGE JAVA NAME
    'oracle.spatial.util.GML2.to_GMLGeometryCLOB(oracle.sql.STRUCT) return oracle.sql.CLOB' ;

 FUNCTION to_gmlgeometry(Geometry IN MDSYS.SDO_GEOMETRY, 
                            srsNameSpace IN varchar2, srsNSAlias IN varchar2) 
 RETURN CLOB DETERMINISTIC  PARALLEL_ENABLE AS LANGUAGE JAVA NAME
    'oracle.spatial.util.GML2.to_GMLGeometryCLOB(oracle.sql.STRUCT, java.lang.String, java.lang.String) return oracle.sql.CLOB' ;
    
 FUNCTION to_gml311geometry(Geometry IN MDSYS.SDO_GEOMETRY) 
 RETURN CLOB DETERMINISTIC  PARALLEL_ENABLE AS LANGUAGE JAVA NAME
    'oracle.spatial.util.GML3.to_GML3GeometryCLOB(oracle.sql.STRUCT) return oracle.sql.CLOB' ;

 FUNCTION to_gml311geometry(Geometry IN MDSYS.SDO_GEOMETRY, 
                            srsNameSpace IN varchar2, srsNSAlias IN varchar2) 
 RETURN CLOB DETERMINISTIC  PARALLEL_ENABLE AS LANGUAGE JAVA NAME
    'oracle.spatial.util.GML3.to_GML3GeometryCLOB(oracle.sql.STRUCT, java.lang.String, java.lang.String) return oracle.sql.CLOB' ;

FUNCTION to_kmlgeometry(Geometry IN MDSYS.SDO_GEOMETRY) 
 RETURN CLOB DETERMINISTIC  PARALLEL_ENABLE AS LANGUAGE JAVA NAME
    'oracle.spatial.util.KML2.to_KMLGeometryCLOB(oracle.sql.STRUCT) return oracle.sql.CLOB' ;

$END
 FUNCTION to_wkbgeometry(geometry IN MDSYS.SDO_GEOMETRY)
 RETURN BLOB DETERMINISTIC PARALLEL_ENABLE;
-- AS LANGUAGE JAVA NAME
-- 'oracle.spatial.util.Adapters.structToWkb(oracle.sql.STRUCT) return oracle.sql.BLOB';

 FUNCTION to_wktgeometry(geometry IN MDSYS.SDO_GEOMETRY)
 RETURN CLOB DETERMINISTIC PARALLEL_ENABLE;
-- AS LANGUAGE JAVA NAME
-- 'oracle.spatial.util.Adapters.structToWkt(oracle.sql.STRUCT) return oracle.sql.CLOB';

 FUNCTION to_wktgeometry_varchar(geometry IN MDSYS.SDO_GEOMETRY)
 RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE;

$IF utl_ident.is_oracle_xe = TRUE $THEN
 FUNCTION from_wktgeometry(geometry IN CLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;
 FUNCTION from_wkbgeometry(geometry IN BLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;
$END
$IF utl_ident.is_oracle_xe <> TRUE $THEN
 FUNCTION from_wkbgeometry(geometry IN BLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.wkbToSTRUCT(oracle.sql.BLOB) return oracle.sql.STRUCT';

 FUNCTION from_wktgeometry(geometry IN CLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.wktToSTRUCT(oracle.sql.CLOB) return oracle.sql.STRUCT';

 FUNCTION from_wktgeometry(geometry IN VARCHAR2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.wktToSTRUCT(java.lang.String) return oracle.sql.STRUCT';

 FUNCTION from_GMLgeometry(geometry IN CLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gmlToSTRUCT(oracle.sql.CLOB) return oracle.sql.STRUCT';
                                                                                
 FUNCTION from_GMLgeometry(geometry IN CLOB, srsNameSpace IN varchar2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gmlToSTRUCT(oracle.sql.CLOB, java.lang.String) return oracle.sql.STRUCT';
                                                                                
 FUNCTION from_GMLgeometry(geometry IN VARCHAR2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gmlToSTRUCT(java.lang.String) return oracle.sql.STRUCT';
                                                                                
 FUNCTION from_GMLgeometry(geometry IN VARCHAR2, srsNameSpace IN varchar2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gmlToSTRUCT(java.lang.String, java.lang.String) return oracle.sql.STRUCT';

 FUNCTION from_GML311geometry(geometry IN CLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gml311ToSTRUCT(oracle.sql.CLOB) return oracle.sql.STRUCT';

 FUNCTION from_GML311geometry(geometry IN CLOB, srsNameSpace IN varchar2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gml311ToSTRUCT(oracle.sql.CLOB, java.lang.String) return oracle.sql.STRUCT';

 FUNCTION from_GML311geometry(geometry IN VARCHAR2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gml311ToSTRUCT(java.lang.String) return oracle.sql.STRUCT';

 FUNCTION from_GML311geometry(geometry IN VARCHAR2, srsNameSpace IN varchar2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.gml311ToSTRUCT(java.lang.String, java.lang.String) return oracle.sql.STRUCT';
 
 FUNCTION from_KMLgeometry(geometry IN CLOB)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.kmlToSTRUCT(oracle.sql.CLOB) return oracle.sql.STRUCT';

 FUNCTION from_KMLgeometry(geometry IN VARCHAR2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.kmlToSTRUCT(java.lang.String) return oracle.sql.STRUCT';

$END
 FUNCTION extrude(geometry IN MDSYS.SDO_GEOMETRY,
                  grdHeight IN SDO_NUMBER_ARRAY,
                  height IN SDO_NUMBER_ARRAY,
                  cond IN VARCHAR2,
                  tol IN NUMBER)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;
-- AS LANGUAGE JAVA NAME
-- 'oracle.spatial.util.Adapters.extrusion1(oracle.sql.STRUCT, oracle.spatial.type.SdoNumberArray, oracle.spatial.type.SdoNumberArray, java.lang.String, oracle.sql.NUMBER) return oracle.sql.STRUCT';

 FUNCTION extrude(geometry IN MDSYS.SDO_GEOMETRY,
                  grdHeight IN SDO_NUMBER_ARRAY,
                  height IN SDO_NUMBER_ARRAY,
                  tol IN NUMBER,
                  optional3dSrid IN NUMBER DEFAULT NULL)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;
-- AS LANGUAGE JAVA NAME
-- 'oracle.spatial.util.Adapters.extrusion2(oracle.sql.STRUCT, oracle.spatial.type.SdoNumberArray, oracle.spatial.type.SdoNumberArray, oracle.sql.NUMBER, oracle.sql.NUMBER) return oracle.sql.STRUCT';

-- FUNCTION append_to_collection(geometry1 IN MDSYS.SDO_GEOMETRY,
--                               geometry2 IN MDSYS.SDO_GEOMETRY )
-- RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC
-- AS LANGUAGE JAVA NAME
-- 'oracle.spatial.util.Adapters.appendToCollection(oracle.sql.STRUCT, oracle.sql.STRUCT) return oracle.sql.STRUCT';

$IF utl_ident.is_oracle_xe <> TRUE $THEN

 FUNCTION affinetransforms(geometry IN MDSYS.SDO_GEOMETRY,
                           translation IN VARCHAR2, tx IN NUMBER, ty IN NUMBER, tz IN NUMBER,
                           scaling IN VARCHAR2, Psc1 IN MDSYS.SDO_GEOMETRY, sx IN NUMBER, sy IN NUMBER, sz IN NUMBER,
                           rotation IN VARCHAR2, P1 IN MDSYS.SDO_GEOMETRY, line1 IN MDSYS.SDO_GEOMETRY, angle IN NUMBER, dir IN NUMBER, 
                           shearing IN VARCHAR2, SHxy IN NUMBER, SHyx IN NUMBER, SHxz IN NUMBER, SHzx IN NUMBER, SHyz IN NUMBER, SHzy IN NUMBER,
                           reflection IN VARCHAR2, Pref IN MDSYS.SDO_GEOMETRY, lineR IN MDSYS.SDO_GEOMETRY, dirR IN NUMBER, planeR IN VARCHAR2, n IN SDO_NUMBER_ARRAY, bigD IN SDO_NUMBER_ARRAY)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.affineTransforms(oracle.sql.STRUCT, java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER,
java.lang.String, oracle.sql.STRUCT, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER,
java.lang.String, oracle.sql.STRUCT, oracle.sql.STRUCT, oracle.sql.NUMBER, oracle.sql.NUMBER,
java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER,
java.lang.String, oracle.sql.STRUCT, oracle.sql.STRUCT, oracle.sql.NUMBER, java.lang.String, oracle.spatial.type.SdoNumberArray, oracle.spatial.type.SdoNumberArray) return oracle.sql.STRUCT';

 FUNCTION extract3d(geometry IN MDSYS.SDO_GEOMETRY, label IN VARCHAR2)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.extract3d(oracle.sql.STRUCT, java.lang.String) return oracle.sql.STRUCT';
 
 FUNCTION getlabelbyelement(sourceGeometry IN MDSYS.SDO_GEOMETRY, queryElement IN MDSYS.SDO_GEOMETRY, tol IN NUMBER)
 RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.getlabelbyelement(oracle.sql.STRUCT, oracle.sql.STRUCT, oracle.sql.NUMBER) return java.lang.String';

 FUNCTION validate_wkbgeometry(geometry IN BLOB)
 RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.validateWkb(oracle.sql.BLOB) return java.lang.String';

 FUNCTION validate_wktgeometry(geometry IN CLOB)
 RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.validateWkt(oracle.sql.CLOB) return java.lang.String';

 FUNCTION validate_wktgeometry(geometry IN VARCHAR2)
 RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE
 AS LANGUAGE JAVA NAME
 'oracle.spatial.util.Adapters.validateWkt(java.lang.String) return java.lang.String';
$END

 FUNCTION concat_lines (geometry1 IN MDSYS.SDO_GEOMETRY,
                        geometry2 IN MDSYS.SDO_GEOMETRY)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 PROCEDURE internal_ordinate_copy(src IN MDSYS.SDO_ORDINATE_ARRAY, 
                            src_position IN INTEGER,
                            dst IN OUT NOCOPY MDSYS.SDO_ORDINATE_ARRAY,
                            dst_position IN INTEGER,
                            length IN INTEGER);

 FUNCTION reverse_linestring(geometry IN MDSYS.SDO_GEOMETRY)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 FUNCTION internal_merge_linestrings(geometry IN MDSYS.SDO_GEOMETRY)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 FUNCTION internal_merge_linestrings(geomArr IN MDSYS.SDO_GEOMETRY_ARRAY)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC;

 FUNCTION internal_make_line_out_of_elem(      
     multilinestring IN MDSYS.SDO_GEOMETRY, element_index IN INTEGER)
 RETURN MDSYS.SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 PROCEDURE internal_reverse_line_points(
       ordinates IN OUT NOCOPY MDSYS.SDO_ORDINATE_ARRAY);

------------------------------------------------------------------
-- Name 	
--   Partition_Table
-- Purpose 
--   Partitions the input "schema.tablename" into buckets of at 
--   most ptn_capacity each. The partitioning is based on the 
--   spatial extent or MBR stored as the intervals <min_di, max_di> 
--   in each dimension di.  The data is written back with 
--   the ptn_id into the "output_table" which is assumed to be
--   be pre-created by the user.  
--   The input <tablename> table is expected to have the following columns:
--      "rid" -- unique id for each row (e.g., the table rowid)
--      min_d1, max_d1 -- minimum and maximum values in dimension 1 
--      min_d2, max_d2 -- minimum and maximum values in dimension 2
--      ..
--      min_dn, max_dn -- minimum and maximum values in dimension n
--      where n is the dimensionality specified by inp arg "numdim"
--   The input "wrk_tblspc" specifies the tablespace where "scratch-pad"
--	tables are created and dropped. Keep this tablespace different from 
--      the tablespace in which the input <tablename> and output_table are.  
--      (typical usage: create wrk_tblspc and drop after this procedure)
--   The arg "output_table" specifies where to write the output partitions
--     This routine assumes the output_table is pre-created and has the 
--     following columns:
--     ptn_id number, rid varchar2(24), min_d1 number, max_d1 number,
--     min_d2, max_d2, ...., min_dn, max_dn (all number columns).  
--     This routine writes the rows from <tablename> back to <output_table>
--       with the ptn_id set. 
--  The arg <output_ptn_table> specifies where to write ptn extent information 
--     This table should have the following numeric columns:
--     ptn_id, min_d1, max_d1, min_d2, max_d2, ...., min_dn, max_dn.
--  Parameter "numdim" specifies the number of dimensions. 
--  Parameter "commit_interval" "n" specifies that commits happen 
--  after every batch of n rows that are written to the <output_table>.
--  Parameter "packed_ptns" tries to pack the partitions.  
  	
 
 PROCEDURE partition_table(schemaname in varchar2, tablename in varchar2,
                           output_data_table in varchar2, 
                           output_ptn_table in varchar2, 
                           ptn_capacity in number default 100,
                           numdim in number default 2,
		           wrk_tblspc in varchar2 default null,
		           ptn_type in varchar2 default null,
                           dop in number default 1);


------------------------------------------------------------------
-- Name
--   DROP_WORK_TABLES
-- Purpose
--   This function drops any work tables and views in the current schema 
--   created as part of partition_table, index creation, or 
--   TIN/Point Cloud utilities.
--
--   DROPS all tables/views that match 'M%_<oidstr>$$%'
--   Input oidstr has to contain only hexadecimal numbers w/o spaces

 PROCEDURE DROP_WORK_TABLES(oidstr varchar2);

 FUNCTION remove_inner_rings(inpgeom SDO_GEOMETRY, inptol number) 
 RETURN SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

 FUNCTION quad_tiles(geom SDO_GEOMETRY, sdo_level number, tol number:=0.0000000005) 
 RETURN mdsys.F81_index_obj_array DETERMINISTIC;

 FUNCTION interior_point (geom SDO_GEOMETRY, tol number := 0.00000000005)
 RETURN SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;
 
 FUNCTION number_of_components(geometry SDO_GEOMETRY, requested_type varchar2)
 RETURN NUMBER PARALLEL_ENABLE;

 FUNCTION get_2d_footprint(geometry SDO_GEOMETRY, tolerance number := 0.05)
 RETURN SDO_GEOMETRY DETERMINISTIC PARALLEL_ENABLE;

END sdo_util;
/

show errors;


