# Entering odbc.mk

# Entering /ade/b/865225302/oracle/buildtools/mkfile/prefix.mk

# Entering /ade/b/865225302/oracle/buildtools/mkfile/defs.mk

SHELL=/bin/sh

AS_EXT=s
CC_EXT=cpp
LIB_EXT=a
OBJ_EXT=o
PLB_EXT=plb
SO_EXT=so
LOCK_EXT=lk
SQL_EXT=sql
SYM_EXT=sym
JAVA_EXT=java
CLASS_EXT=class
JAR_EXT=jar
ZIP_EXT=zip
DEF_EXT=def

LIB_PREFIX=lib
LDLIBFLAG=-l
LDPATHFLAG=-L
PATHSEP= :
DEPLIB_EXT=$(LIB_EXT)
DEPSO_EXT=$(SO_EXT)

AR=ar
AS=as
AWK=awk
CAT=cat
CC=cc
CCC=CC
CD=cd
CHMOD=chmod
CP=cp
CPP=cpp
CPP_WITH_COMMENTS=cpp -C -std=c9x
CODECOV_TOOL_CCB=stattool.STABLE
CODECOV_TOOL_HTML=stattool.STABLE --ed-commands
DATE=date
ECHO=echo
ECHON=echo -n
EXEC=exec
FIND=find
FOLLOW=-follow
NOLEAF=-noleaf
GREP=grep
KILL=kill
SLEEP=sleep
LD=ld
LMAKE=make
LN=ln
LNS=ln -s
MKDIR=mkdir
MKDIRP=mkdir -p
MV=mv
MVF=mv -f
NM=nm
PERL=perl
RM=rm
RMF=rm -f
CPF=cp -f
RMRF=rm -rf
SED=sed
SORT=sort
TOUCH=touch
TR=tr
XARGS=xargs
LS=ls
ED=ed - -s

PERL_EXEC=$(PERL_EXEC_5_6)

ANT=ant

NULL_DEVICE=/dev/null

BINDIR=bin
LIBDIR=lib
JSRCDIR=jsrc
JLIBDIR=jlib
BINHOME=$(ORACLE_HOME)/$(BINDIR)/
LIBHOME=$(ORACLE_HOME)/$(LIBDIR)/

PRODHOME=$(ORACLE_HOME)/$(PRODUCT)/
PRODJORACLE_HOME=$(PRODHOME)$(JSRCDIR)/
PRODLIBHOME=$(PRODHOME)$(LIBDIR)/
PRODSOHOME=$(PRODLIBHOME)
PRODADMIN=$(PRODHOME)admin/
PRODDEFHOME=$(PRODADMIN)

ECHODO=$(BINHOME)echodo
GENSYSLIB=$(BINHOME)gensyslib
GENCLNTSH=$(BINHOME)genclntsh
GENCLNTST=$(BINHOME)genclntst
GENOCCISH=$(BINHOME)genoccish
GENAGTSH=$(BINHOME)genagtsh
GENNAFLG=$(BINHOME)gennaflg
GENAUTAB=$(BINHOME)genautab
MKMANIFEST=$(ORACLE_HOME)/buildtools/bin/mkjmanifest
GENORASDKBASE=$(BINHOME)genorasdksh -base
GENORASDKSH=$(BINHOME)genorasdksh

ARCHIVE=$(ECHODO) $(ARCREATE) $(LIB) $?
ARCHIVE2=$(ECHODO) $(ARCREATE) $(LIB2) $?
ARCHIVE_PIC=$(ECHODO) $(ARCREATE) $(PIC_LIB) $?
ARCHIVE2_PIC=$(ECHODO) $(ARCREATE) $(PIC_LIB2) $?
ARCHIVE_NOPIC=$(ECHODO) $(ARCREATE) $(NOPIC_LIB) $?
ARCHIVE2_NOPIC=$(ECHODO) $(ARCREATE) $(NOPIC_LIB2) $?
ARCHIVE_OBJ=$(AR) r $@ $*.$(OBJ_EXT)
ARCREATE=$(AR) cr$(ARLOCAL)
ARDELETE=$(AR) d$(ARLOCAL)
AREXTRACT=$(AR) x 
ARPRINT=$(AR) t
ARREPLACE=$(AR) r 
DOAR=$(ARCREATE) $@ $? 

JARCHIVE_OBJ=$(JAR) cv0f $@ $(JPKG_FILES) $(EXTRA_CLASS_FILES)
JARCREATE=$(JAR) cv0f
JARDELETE=$(ECHO) "no such thing"
JAREXTRACT=$(JAR) xf
JARPRINT=$(JAR) tvf
JARREPLACE=$(JAR) uf

CCARCREATE=$(CCC) -xar -o 

MAKE=$(LMAKE)
QUIET=>/dev/null 2>&1
QUIETE=2>/dev/null
SILENT=@

CTSCLEAN=clean
CTSCOMPTYPE=comp_ar1 _UNLOCK='$$(_unlock)' _LOCK='$$(_lock)' _RM='$$(_rm)' 
CTSDEPLIST=DEPLIST=/dev/null
CTSMAKEFLAGS=$(SILENT:@=--no-print-directory -s) $(CTSCLEAN) $(CTSCOMPTYPE) $(CTSDEPLIST)

CFLAGS=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGS) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
CFLAGSCC=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGSCC) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
PFLAGS=$(INCLUDE) $(SPFLAGS) $(LPFLAGS) $(PLSQLNCGFLAGS)

LD_SHARED_FLAG=$(SHARED_CFLAG)

LDCCOM=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CC) $(GFLAG) $(CCFLAGS) $(EXOSFLAGS) $(LDFLAGS)
LDCCOMCC=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CCC) $(GFLAG) $(CCFLAGSCC) $(EXOSFLAGS) $(LDFLAGS)
PURECMDS=$(PURELINK) $(PURIFY) $(PURECOV) $(QUANTIFY)
LINK=$(LDCCOM)
LINKCC=$(LDCCOMCC)
LDFLAGS=-o $@ $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME)
LDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(EXSYSLIBS) $(MATHLIB) $(USRLIBS)
MATHLIB=-lm
LINKLDLIBS=$(LDLIBS)
COBLDLIBS=$(LDLIBS)

SYSLIBLIST=$(LIBHOME)sysliblist
SYSLIBS=`$(CAT) $(SYSLIBLIST)`

NAETTOBJS=$(NAUTAB) $(NAETAB) $(NAEDHS)
TTLIBD=$(NETLIBD) $(LIBRDBMS_CLT) $(LIBMM) $(CORELIBD) $(LIBEPC) $(LIBCLNTSH)
ORACLETTLIBS1=$(NTZEOBJ) $(NETLIBS) $(NZLIBS) $(LLIBZTKG) $(LLIBRDBMS_CLT) $(LLIBMM) $(CORELIBS)\
       $(NETLIBS) $(LLIBRDBMS_CLT) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) \
       $(LLIBRDBMS_CLT) $(CORELIBS)
ORACLETTLIBS=$(ORACLETTLIBS1)
STATICTTLIBS=$(ORACLETTLIBS) $(LDLIBS)
TTLIBS=$(LLIBCLNTSH) $(STATICTTLIBS)
DEVTTLIBS=$(TTLIBS)
LINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(LINKLDLIBS)
COBTTLIBS=$(ORACLETTLIBS) $(COBLDLIBS)
SUIDLINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(SUIDLINKLDLIBS)

STATIC_ORACLETTLIBS=$(NTZEOBJ) $(NETLIBS) $(NZLIBS) $(LIBRDBMS_CLT) \
    $(LIBMM) $(CORELIBS) $(NETLIBS) $(LIBRDBMS_CLT) $(LIBPLS_CLT) \
    $(LIBEPC) $(CORELIBS) $(LIBRDBMS_CLT) $(CORELIBS)

SHARED_CLIENTLIBS=$(LLIBCLNTSH) $(LDFLAGSLIST)
STATIC_CLIENTLIBS=$(LLIBCLNTST) $(LDFLAGSLIST)
SHARED_LDCLIENTLIBS=$(SHARED_CLIENTLIBS) $(LDLIBS)
STATIC_LDCLIENTLIBS=$(STATIC_CLIENTLIBS) $(LDLIBS)

I_SYM=-I

LD_SHLIBS=$(SHLIBS)
DLOPENLIB_COMMAND=$(LD_SHLIB_COMMAND)
DLOPEN_SYM_COMMAND=$(SYM_COMMAND)
LD_SHLIB_COMMAND=$(SO_COMMAND)

MAJORVSN=11
MINORVSN=2
MIDTIERVSN=0
PATCHMAJORVSN=2
PATCHMINORVSN=0
BANNERVERSION=$(MAJORVSN).$(MINORVSN).$(MIDTIERVSN).$(PATCHMAJORVSN).$(PATCHMINORVSN)

# Exiting /ade/b/865225302/oracle/buildtools/mkfile/defs.mk
# Entering /ade/b/865225302/oracle/buildtools/mkfile/platform.mk

FAMILY=unix
ifeq ($(BUILD32),T)
BUILD_CC=
PLATFORM=linux
else
PLATFORM=x86_64
endif

ISCERT=`/bin/cat /etc/issue | /bin/grep -v "Red Hat Enterprise Linux AS release 3"`

MOTIFHOME=
OPENWINHOME=
GUILIBHOME= 

DIRSEP=/
PSEP=:

ORACLUSTERDIR=/opt/ORCLcluster/lib/

SO_EXT=so

GMAKE=make
LMAKE=make
FIND=/usr/bin/find 
PS=ps -feda


JARCHIVE=@`if echo ${JLIB} | egrep '\.jar' > /dev/null 2>&1;then $(JARCREATE) $(JLIB) $? ; else echo ""; fi`

GROUP=/etc/group

LDOBJSZ=-m64
LDFLAGS=-o $@ $(LDOBJSZ) $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME) $(LDPATHFLAG)$(LIBHOME)stubs/

AMD32FLAGS=-m32
LIBHOME32=$(ORACLE_HOME)/lib32/
PRODLIBHOME32=$(PRODHOME)/lib32/

LDFLAGS32=$(AMD32FLAGS) -o $@ $(LDPATHFLAG)$(PRODLIBHOME32) $(LDPATHFLAG)$(LIBHOME32) $(LDPATHFLAG)$(LIBHOME32)stubs/
ifeq ($(BUILD32),T)
LDFLAGS=$(LDFLAGS32)
endif

LINK=$(FORT_CMD) $(PURECMDS) gcc $(LDFLAGS) $(COMPSOBJS)
LINK32=$(FORT_CMD) $(PURECMDS) gcc $(LDFLAGS32) $(COMPSOBJS)

LLIBTHREAD=

MOTIFLIBS= -lXm -lXt -lX11 -lgen -lm -lXext -lX11 -lm
XLIBS=
EXOSFLAGS=

COMPOBJS=

RFLAG=-Wl,-rpath,
XEOH=/u01/app/oracle/product/11.2.0/xe
ORIGIN='$$ORIGIN'
ifeq ($(ORACLE_XE),)
SHAREDLIBPATH=$(RFLAG)$(ORACLE_HOME)/$(LIBDIR)
else
SHAREDLIBPATH=$(RFLAG)$(XEOH)/lib $(RFLAG)$(XEOH)/$(PRODUCT)/lib
endif

EXSYSLIBS=-ldl

LLPPATH=$(LD_LIBRARY_PATH)
LINKEXSYSLIBS= $(SHAREDLIBPATH)

LINKLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(LINKEXSYSLIBS) $(MATHLIB) $(USRLIBS) $(LDLIBS) $(COMPEOBJS) -L$(ORACLE_HOME)/$(LIBDIR)
SUIDLINKLDLIBS=$(LINKLDLIBS:$(SHAREDLIBPATH)=)

OPTIMIZE0=-O0
OPTIMIZE1=-O1
OPTIMIZE2=-O2
OPTIMIZE3=-O3
OPTIMIZE6=-O6
OPTIMIZEG=-g

ifdef BUILD_CC
OPTIMIZE=$(OPTIMIZE2)
else
OPTIMIZE=$(OPTIMIZE3)
endif

ROFLAGS=-c
SPFLAGS=-DLINUX -DORAX86_64 -D_GNU_SOURCE -D_LARGEFILE64_SOURCE=1 -D_LARGEFILE_SOURCE=1 -DSLTS_ENABLE -DSLMXMX_ENABLE -D_REENTRANT -DNS_THREADS -DLONG_IS_64 -DSS_64BIT_SERVER
SPFLAGS32=-DLINUX -D_GNU_SOURCE -D_LARGEFILE64_SOURCE=1 -D_LARGEFILE_SOURCE=1 -DSLTS_ENABLE -DSLMXMX_ENABLE -D_REENTRANT -DNS_THREADS
ifeq ($(BUILD32),T)
SPFLAGS=$(SPFLAGS32)
endif

ifdef TEST_CC
        SPFLAGS += -D__NO_CTYPE=1
endif

AR=$(FORT_CMD)/usr/bin/ar
AS=/usr/bin/as
LD=$(FORT_CMD)/usr/bin/gcc
NM=/usr/bin/nm
TR=/usr/bin/tr
CPP=/lib/cpp
CHMOD=/bin/chmod
CHGRP=/bin/chgrp
CHOWN=/bin/chown
ZIP=/usr/bin/zip
UNZIP_DIR_FLAG=-d

KPIC_OPTION=-fPIC

_SLEEP=$(SLEEP)

COMPDIR=/usr
CC=$(COMPDIR)/bin/gcc
CCC=$(COMPDIR)/bin/g++
CPP=/lib/cpp
TRIGRAPHS_CCFLAGS=-trigraphs
CCFLAGSCC=-DOCCI_NO_WSTRING=1

CCFLAGSCC=-DOCCI_NO_WSTRING=1 $(KPIC_OPTION)
CCFLAGSCC32=-DOCCI_NO_WSTRING=1 $(KPIC_OPTION) $(AMD32FLAGS)
ifeq ($(BUILD32),T)
CCFLAGSCC=$(CCFLAGSCC32)
endif

CCARCREATE=$(AR) cr$(ARLOCAL)

ASPFLAGS=
NOKPIC_ASFLAGS=
ASFLAGS=
ASRO=$(AS) $<
ASROFLAGS=$(ASFLAGS)

ANSI=-ansi

COMPXA=$(subst -ansi,,$(COMPO))
COMPXACC=$(subst -ansi,,$(COMPOCC))


SHARED_LDFLAG=-shared -L$(ORACLE_HOME)/lib -o
SHARED_LDFLAG32=$(AMD32FLAGS) -shared -L$(ORACLE_HOME)/lib -o
ifeq ($(BUILD32),T)
SHARED_LDFLAG=$(SHARED_LDFLAG32)
endif
SHARED_CFLAG=

NOKPIC_CCFLAGS=$(TRIGRAPHS_CCFLAGS)
NOKPIC_CCFLAGS32=$(AMD32FLAGS) $(TRIGRAPHS_CCFLAGS)
ifeq ($(BUILD32),T)
NOKPIC_CCFLAGS=$(NOKPIC_CCFLAGS32)
endif

SHLIBCCFLAGS=$(NOKPIC_CCFLAGS) $(KPIC_OPTION)

CCFLAGS= $(SHLIBCCFLAGS)
CCFLAGS32 = $(NOKPIC_CCFLAGS32) $(KPIC_OPTION)

FASTCCFLAGS= $(NOKPIC_CCFLAGS) $(TLS_STATIC)

ECC_PGO1= -prof_gen
ECC_PGO2= -prof_use -prof_dir $(PROFILEDIR) 
LLIBIRC= -lirc -lipgo

SHLIB_LD=$(FORT_CMD)gcc -o $(_FULL_LIBNAME) -shared -L$(BOOTSTRAPLIB) -L$(LIBHOME) -L$(PRODLIBHOME) -L$(LIBHOME)stubs/
BOOTSTRAPLIB=/tmp/bootstraplib/
SHLIB_MAP=-Wl,--version-script=$(PRODDEFHOME)$(_LIBNAME).$(DEF_EXT)
SHLIB_NAME=-Wl,-h,$(_LIBNAME).$(SO_EXT)
SHLIB_OBJS=-Wl,--whole-archive $(_LIBDIR)$(_LIBNAME).$(LIB_EXT) -Wl,--no-whole-archive
SHLIB_OBJS_OLD=-Wl,--whole-archive $(_LIBDIR)$(_LIBNAME).$(LIB_EXT) -Wl,--no-whole-archive
SHLIB_OTHER=$(_LIBNAME_LIBS) $(_VAR_LIBS)
SHLIB_BOOTSTRAP_OTHER=$(_LIBNAME_EXTRALIBS) $(_VAR_EXTRALIBS)
SHLIB_CLOSED=-Wl,-z,defs

ifeq ($(ORACLE_XE),)
SHLIB_RP=$(RFLAG)$(LIBHOME) $(RFLAG)$(PRODLIBHOME)
else
SHLIB_RP=$(RFLAG)$(XEOH)/lib $(RFLAG)$(XEOH)/$(PRODUCT)/lib
endif

LD_SHLIB_COMMAND=$(SHLIB_LD) $(SHLIB_MAP) $(SHLIB_OBJS_OLD) $(SHLIB_OTHER_DEP) $(LLIBIRC)
LD_SHLIB_COMMAND32=$(SHLIB_LD) $(AMD32FLAGS) $(SHLIB_MAP) $(SHLIB_OBJS_OLD) $(SHLIB_OTHER_DEP) $(LLIBIRC)

DLOPENLIB_COMMAND=$(LD_SHLIB_COMMAND) $(PROD_DLLIBS) $(_LIBNAME_LIBS) $(LLIBIRC)

NEW_LD_SHLIB_COMMAND=$(SHLIB_LD) $(SHLIB_MAP) $(SHLIB_NAME) $(SHLIB_OBJS) \
$(SHLIB_RP) $(SHLIB_OTHER) $(SHLIB_CLOSED) $(LLIBIRC)
NEW_DLOPENLIB_COMMAND=$(NEW_LD_SHLIB_COMMAND) $(LLIBIRC)
BOOTSTRAP_COMMAND=$(NEW_LD_SHLIB_COMMAND) $(SHLIB_BOOTSTRAP_OTHER) $(LLIBIRC)
NEW_LD_SHLIB_DEP=$(PRODDEFHOME)%.$(DEF_EXT) $(PRODLIBHOME)%.$(LIB_EXT)
NEW_DLOPENLIB_DEP=$(NEW_LD_SHLIB_DEP)
BOOTSTRAPLIB_DEP=$(NEW_LD_SHLIB_DEP)

LINKSHLIB=$(BINHOME)linkshlib
LINKSHLIB_CALL=$(LINKSHLIB) $@ $(MAKEFILE) $(SO_EXT)
CUS_NEW_SHLIB_COMMAND=$(LINKSHLIB_CALL) new_ld_shlib $(VAR)
CUS_NEW_DLOPENLIB_COMMAND=$(LINKSHLIB_CALL) new_dlopenlib $(VAR)
CUS_SHLIB_COMMAND=$(LINKSHLIB_CALL) ld_shlib $(VAR)
CUS_DLOPENLIB_COMMAND=$(LINKSHLIB_CALL) dlopenlib $(VAR)
CUS_VARLIB_COMMAND=$(LINKSHLIB_CALL) var $(PRODHOME)admin
CUS_BOOTSTRAPLIB_COMMAND=$(LINKSHLIB_CALL) bootstrap

# Exiting /ade/b/865225302/oracle/buildtools/mkfile/platform.mk
# Entering /ade/b/865225302/oracle/buildtools/mkfile/rules.mk
 
# Exiting /ade/b/865225302/oracle/buildtools/mkfile/rules.mk
# Exiting /ade/b/865225302/oracle/buildtools/mkfile/prefix.mk
# Entering /ade/b/865225302/oracle/oracore/exports.mk

COREHOME    = $(ORACLE_HOME)/oracore/
ORACOREHOME = $(COREHOME)



CORE_LIB_NAME     = core
CORE_LIB_VER      = 11
CORE_LIB          = $(CORE_LIB_NAME)$(CORE_LIB_VER)

LIBCORE_STATIC    = $(LIB_PREFIX)$(CORE_LIB).$(LIB_EXT)
LIBCORE_SHARED    = $(LIB_PREFIX)$(CORE_LIB).$(SO_EXT)
LIBCORE_SH        = $(LIB_PREFIX)$(CORE_LIB_NAME)sh$(CORE_LIB_VER).$(SO_EXT)
LIBCORE_SLH       = $(LIB_PREFIX)$(CORE_LIB).$(ILIB_EXT)

LIBCORE           = $(LIBHOME)$(LIBCORE_STATIC)
LLIBCORE          = $(LDLIBFLAG)$(CORE_LIB)
LLIBCORE_SH       = $(LDLIBFLAG)$(CORE_LIB_NAME)sh$(CORE_LIB_VER)

LIBCORE_ARC_LIB   = $(LIBCORE)
LIBCORE_SHARE_LIB = $(LIBHOME)$(LIBCORE_SHARED)

ORAZLIB              = oraz

LIBORAZLIB_STATIC    = $(LIB_PREFIX)$(ORAZLIB).$(LIB_EXT)
LIBORAZLIB_SHARED    = $(LIB_PREFIX)$(ORAZLIB).$(SO_EXT)

LIBORAZLIB           = $(LIBHOME)$(LIBORAZLIB_STATIC)
LLIBORAZLIB          = $(LDLIBFLAG)$(ORAZLIB)

LIBORAZLIB_ARC_LIB   = $(LIBORAZLIB)
LIBORAZLIB_SHARE_LIB = $(LIBHOME)$(LIBORAZLIB_SHARED)

LZOPROLIB           = lzopro

LIBLZOPRO_STATIC    = $(LIB_PREFIX)$(LZOPROLIB).$(LIB_EXT)
LIBLZOPRO_SHARED    = $(LIB_PREFIX)$(LZOPROLIB).$(SO_EXT)

LIBLZOPRO           = $(LIBHOME)$(LIBLZOPRO_STATIC)
LLIBLZOPRO          = $(LDLIBFLAG)$(LZOPROLIB)

LIBLZOPRO_ARC_LIB   = $(LIBLZOPRO)
LIBLZOPRO_SHARE_LIB = $(LIBHOME)$(LIBLZOPRO_SHARED)

ORABZ2LIB              = bz2

LIBORABZ2LIB_STATIC    = $(LIB_PREFIX)$(ORABZ2LIB).$(LIB_EXT)
LIBORABZ2LIB_SHARED    = $(LIB_PREFIX)$(ORABZ2LIB).$(SO_EXT)

LIBORABZ2LIB           = $(LIBHOME)$(LIBORABZ2LIB_STATIC)
LLIBORABZ2LIB          = $(LDLIBFLAG)$(ORABZ2LIB)

LIBORABZ2LIB_ARC_LIB   = $(LIBORABZ2LIB)
LIBORABZ2LIB_SHARE_LIB = $(LIBHOME)$(LIBORABZ2LIB_SHARED)

CORECOMPRESSLIBS = $(LLIBORAZLIB) $(LLIBLZOPRO) $(LLIBORABZ2LIB) \
                  $(PL_CORECOMPRESSLIBS)


















LIB816  = /oracore/sun5/8.1.6.0.0/lib
CORE816 = $(LIB816)/$(LIBCORE_STATIC)
NLS816  = $(LIB816)/$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)


LIB817  = /oracore/sun5/8.1.7.0.0/lib
CORE817 = $(LIB817)/$(LIBCORE_STATIC)
NLS817  = $(LIB817)/$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)


S0MAIN   = $(LIBHOME)s0main.$(OBJ_EXT)
S1MAIN_C = $(COREHOME)src/corehl/lpm/sosd/main/s1main.c
SCOREPT  = $(LIBHOME)scorept.$(OBJ_EXT)
SSCOREED = $(LIBHOME)sscoreed.$(OBJ_EXT)

COREPUBLIC=$(COREHOME)include $(COREHOME)public/ $(XDKPUBLIC)

ORACOREPUBH=$(I_SYM)$(COREHOME)include $(I_SYM)$(COREHOME)public $(I_SYM)$(COREHOME)port/include $(XDKPUBH)


CORELIBD = $(LIBSNLSRTL) $(LIBNLSRTL) $(LIBCV6) $(LIBCORE) $(LIBSNLSRTL) \
           $(LIBNLSRTL) $(LIBCORE) $(LIBSNLSRTL) $(LIBNLSRTL)  $(LIBUNLSRTL) \
           $(LIBSNLSRTL) $(LIBNLSRTL)
CORELIBS = $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBCV6) $(LLIBCORE) $(LLIBSNLSRTL) \
           $(LLIBNLSRTL) $(LLIBCORE) $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBXML) \
           $(LLIBCORE) $(LLIBUNLSRTL) $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBCORE)\
	   $(LLIBNLSRTL)


# Entering /ade/b/865225302/oracle/oracore/s_exports.mk

PL_CORECOMPRESSLIBS=$(IPPCOMPRESSLIBS)

IPP_DIR=/usr/local/packages/ipp_remote/6.1.5/

IPPCORE=ippcore
LIBIPPCORE=$(LIB_PREFIX)$(IPPCORE).$(LIB_EXT)
LLIBIPPCORE=$(LDLIBFLAG)$(IPPCORE)

IPPDCEMERGED=ippdcemerged
LIBIPPDCEMERGED=$(LIB_PREFIX)$(IPPDCEMERGED).$(LIB_EXT)
LLIBIPPDCEMERGED=$(LDLIBFLAG)$(IPPDCEMERGED)

IPPDCMERGED =ippdcmerged
LIBIPPDCMERGED=$(LIB_PREFIX)$(IPPDCMERGED).$(LIB_EXT)
LLIBIPPDCMERGED=$(LDLIBFLAG)$(IPPDCMERGED)


IPPSEMERGED=ippsemerged
LIBIPPSEMERGED=$(LIB_PREFIX)$(IPPSEMERGED).$(LIB_EXT)
LLIBIPPSEMERGED=$(LDLIBFLAG)$(IPPSEMERGED)

IPPSMERGED=ippsmerged
LIBIPPSMERGED=$(LIB_PREFIX)$(IPPSMERGED).$(LIB_EXT)
LLIBIPPSMERGED=$(LDLIBFLAG)$(IPPSMERGED)

IPPSAMPLEZLIB=ipp_z
LIBIPPSAMPLEZLIB=$(LIB_PREFIX)$(IPPSAMPLEZLIB).$(LIB_EXT)
LLIBIPPSAMPLEZLIB=$(LDLIBFLAG)$(IPPSAMPLEZLIB)

IPPSAMPLEBZ2 =ipp_bz2
LIBIPPSAMPLEBZ2=$(LIB_PREFIX)$(IPPSAMPLEBZ2).$(LIB_EXT)
LLIBIPPSAMPLEBZ2=$(LDLIBFLAG)$(IPPSAMPLEBZ2)

IPPCOMPLIBS  = $(LLIBIPPDCEMERGED) $(LLIBIPPSEMERGED) \
               $(LLIBIPPDCMERGED)  $(LLIBIPPSMERGED)
IPPCORELIBS  = $(LLIBIPPCORE)
IPPSAMPLELIBS= $(LLIBIPPSAMPLEZLIB) $(LLIBIPPSAMPLEBZ2)
IPPCOMPRESSLIBS = $(IPPSAMPLELIBS) $(IPPCOMPLIBS) $(IPPCORELIBS) 


ORABZ2LIB = orabz2
 
# Exiting /ade/b/865225302/oracle/oracore/s_exports.mk
# Exiting /ade/b/865225302/oracle/oracore/exports.mk
# Entering /ade/b/865225302/oracle/nlsrtl/exports.mk

NLSRTLHOME= $(ORACLE_HOME)/nlsrtl/


ORA_NLS = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS33 = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS10 = $(ORACLE_HOME)/nls/data/

NLSRTL_VERSION=11
NLSRTL_DEBUG_LIBTAG = 

LIBNLSRTLNAME = nls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)
LLIBNLSRTL= $(LDLIBFLAG)$(LIBNLSRTLNAME)$(LIB_SUFFIX)

LIBUNLSRTLNAME = unls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBUNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBUNLSRTLNAME).$(LIB_EXT)
LLIBUNLSRTL= $(LDLIBFLAG)$(LIBUNLSRTLNAME)$(LIB_SUFFIX)

LIBSNLSRTLNAME = snls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBSNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBSNLSRTLNAME).$(LIB_EXT)
LLIBSNLSRTL= $(LDLIBFLAG)$(LIBSNLSRTLNAME)$(LIB_SUFFIX)

NLSRTLPUBH = $(I_SYM)$(NLSRTLHOME)include

GSSHOME = $(ORACLE_HOME)/nlsrtl3/java
GSSCLASSES11 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCLASSES12 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCHARSET11 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCHARSET12 = $(ORACLE_HOME)/jlib/orai18n.jar

GDKHOME = $(ORACLE_HOME)/nlsrtl3/java
GDKCLASSES = $(ORACLE_HOME)/jlib/orai18n.jar$(PATHSEP)$(ORACLE_HOME)/jlib/orai18n-lcsd.jar
NLSRTL_JARS = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-translation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-net.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-servlet.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-tools.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-lcsd.jar

NLSRTL_JARS_FOR_GENERAL = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar

NLSRTL_JARS_FOR_DBJAVA_JAVAVM = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-net.jar

NLSRTL_JARS_FOR_DBJAVA_CLIENT = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar

NLSRTL_SHIPHOME_JARS_FOR_DBJAVA_CLIENT = \
  $(ORACLE_HOME)/jlib/orai18n.jar \
  $(ORACLE_HOME)/jlib/orai18n-mapping.jar

# Entering /ade/b/865225302/oracle/nlsrtl/s_exports.mk

LIBNLSRTLSHNAME = nlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBUNLSRTLSHNAME = unlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBSNLSRTLSHNAME = snlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)

LLIBNLSSH=-lnlssh$(NLSRTL_VERSION)
LLIBSNLSSH=-lsnlssh$(NLSRTL_VERSION)
LLIBUNLSSH=-lunlssh$(NLSRTL_VERSION)

# Exiting /ade/b/865225302/oracle/nlsrtl/s_exports.mk
# Exiting /ade/b/865225302/oracle/nlsrtl/exports.mk
# Entering /ade/b/865225302/oracle/rdbms/exports.mk


RDBMS_VERSION=11
RDBMS_MINOR_VERSION=1

LIBCLNTSTNAME=clntst$(RDBMS_VERSION)
LIBCLNTST=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSTNAME).$(LIB_EXT)
LLIBCLNTST=$(LDLIBFLAG)$(LIBCLNTSTNAME)

LIBSERVERNAME=server$(RDBMS_VERSION)
LIBSERVER=$(LIBHOME)$(LIB_PREFIX)$(LIBSERVERNAME).$(LIB_EXT)
LLIBSERVER=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSERVERNAME)$(LIB_SUFFIX)

LIBCLIENTNAME=client$(RDBMS_VERSION)
LIBCLIENT=$(LIBHOME)$(LIB_PREFIX)$(LIBCLIENTNAME).$(DEPLIB_EXT)
LLIBCLIENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLIENTNAME)$(ILIB_SUFFIX)

LIBGENERICNAME=generic$(RDBMS_VERSION)
LIBGENERIC=$(LIBHOME)$(LIB_PREFIX)$(LIBGENERICNAME).$(DEPLIB_EXT)
LLIBGENERIC=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGENERICNAME)$(ILIB_SUFFIX)

LIBSKGXPNAME=skgxp$(RDBMS_VERSION)
LIBSKGXP=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXPNAME).$(SKGXP_EXT)
LLIBSKGXP=$(LDLIBFLAG)$(LIBSKGXPNAME)

LIBSKGTRNAME=skgtr$(RDBMS_VERSION)
LIBSKGTR_MPMT=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGTRNAME).$(SKGTR_EXT)
LIBSKGTR_=
LIBSKGTR=$(LIBSKGTR_$(MPMT_SERVER))
LLIBSKGTR_MPMT=$(LDLIBFLAG)$(LIBSKGTRNAME)
LLIBSKGTR_=
LLIBSKGTR=$(LLIBSKGTR_$(MPMT_SERVER))

LIBASMCLNTNAME=asmclnt$(RDBMS_VERSION)
LIBASMCLNT=$(LIBHOME)$(LIB_PREFIX)$(LIBASMCLNTNAME).$(DEPLIB_EXT)
LLIBASMCLNT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBASMCLNTNAME)$(ILIB_SUFFIX)
LIBASMCLNT_DEPS=$(LLIBCLNTSH) $(LLIBHASGEN) $(LLIBSKGXN) $(LLIBCOMMON) $(LLIBOCR) $(LLIBGENERIC) $(LLIBSAGE) $(LLIBSKGXP) $(LLIBXML)

LIBASMCLNTSHNAME=asmclntsh$(RDBMS_VERSION)
LIBASMCLNTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBASMCLNTSHNAME).$(DEPSO_EXT)
LLIBASMCLNTSH=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBASMCLNTSHNAME)$(ILIB_SUFFIX)
LIBASMCLNTSH_DEPS=$(LLIBCLNTSH) $(LLIBHASGEN) $(LLIBSKGXN) $(LLIBCOMMON) $(LLIBOCR) $(LLIBGENERIC) $(LLIBSAGE) $(LLIBSKGXP) $(LLIBXML)

ENCRYPTLIBS = $(PL_ENCRYPTLIBS)

LIBSKGXNNAME=skgxn$(RDBMS_VERSION)
LIBSKGXN=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)
LLIBSKGXN=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSKGXNNAME)$(LIB_SUFFIX)
LIBSKGXNI=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)

LIBOCCINAME=occi
LIBOCCI=$(LIBHOME)$(LIB_PREFIX)$(LIBOCCINAME)$(RDBMS_VERSION).$(LIB_EXT)
LLIBOCCI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCCINAME)$(RDBMS_VERSION)$(ILIB_SUFFIX)
LLIBOCCISTATIC=$(LDLIBFLAG)$(LIBOCCINAME)$(RDBMS_VERSION)

LIBCDFNAME=cdf
LIBCDF=$(LIBHOME)$(LIB_PREFIX)$(LIBCDFNAME)$(RDBMS_VERSION).$(LIB_EXT)
LLIBCDF=$(LDLIBFLAG)$(LIBCDFNAME)$(RDBMS_VERSION)

LIBWSECNAME=wsec
LIBWSEC=$(LIBHOME)$(LIB_PREFIX)wsec$(RDBMS_VERSION).$(LIB_EXT)
LLIBWSEC=$(LDLIBFLAG)$(LIB_PREFIX)$(LIBWSECNAME)$(RDBMS_VERSION)$(ILIB_SUFFIX)

LIBSKGXP_CLT=
LLIBSKGXP_CLT=

LIBCOMMONNAME=common$(RDBMS_VERSION)
LIBCOMMON=$(LIBHOME)$(LIB_PREFIX)$(LIBCOMMONNAME).$(DEPLIB_EXT)
LLIBCOMMON=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCOMMONNAME)$(ILIB_SUFFIX)

LIBEVANAME=eva$(RDBMS_VERSION)
LIBEVA=$(LIBHOME)$(LIB_PREFIX)$(LIBEVANAME).$(LIB_EXT)
LLIBEVA=$(LDLIBFLAG)$(LIBEVANAME)

LIBVSNNAME=vsn$(RDBMS_VERSION)
LIBVSN=$(LIBHOME)$(LIB_PREFIX)$(LIBVSNNAME).$(DEPLIB_EXT)
LLIBVSN=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBVSNNAME)$(ILIB_SUFFIX)

LIBAGENTNAME=agent$(RDBMS_VERSION)
LIBAGENT=$(LIBHOME)$(LIB_PREFIX)$(LIBAGENTNAME).$(LIB_EXT)
LLIBAGENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAGENTNAME)$(LIB_SUFFIX)

LIBHGOSHNAME=hgosh$(RDBMS_VERSION)
LIBHGOSH=$(LIBHOME)$(LIB_PREFIX)$(LIBHGOSHNAME).$(LIB_EXT)
LLIBHGOSH=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGOSHNAME)$(LIB_SUFFIX)

LIBHGMSQLNAME=hgmsql$(RDBMS_VERSION)
LIBHGMSQL=$(LIBHOME)$(LIB_PREFIX)$(LIBHGMSQLNAME).$(LIB_EXT)
LLIBHGMSQL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGMSQLNAME)$(LIB_SUFFIX)

LIBHGSYBSNAME=hgsybs$(RDBMS_VERSION)
LIBHGSYBS=$(LIBHOME)$(LIB_PREFIX)$(LIBHGSYBSNAME).$(LIB_EXT)
LLIBHGSYBS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGSYBSNAME)$(LIB_SUFFIX)

LIBHGIFMXNAME=hgifmx$(RDBMS_VERSION)
LIBHGIFMX=$(LIBHOME)$(LIB_PREFIX)$(LIBHGIFMXNAME).$(LIB_EXT)
LLIBHGIFMX=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGIFMXNAME)$(LIB_SUFFIX)

LIBHGTERANAME=hgtera$(RDBMS_VERSION)
LIBHGTERA=$(LIBHOME)$(LIB_PREFIX)$(LIBHGTERANAME).$(LIB_EXT)
LLIBHGTERA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGTERANAME)$(LIB_SUFFIX)

LIBHGDB2NAME=hgdb2$(RDBMS_VERSION)
LIBHGDB2=$(LIBHOME)$(LIB_PREFIX)$(LIBHGDB2NAME).$(LIB_EXT)
LLIBHGDB2=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGDB2NAME)$(LIB_SUFFIX)

LIBHGGCONNAME=hggcon$(RDBMS_VERSION)
LIBHGGCON=$(LIBHOME)$(LIB_PREFIX)$(LIBHGGCONNAME).$(LIB_EXT)
LLIBHGGCON=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGGCONNAME)$(LIB_SUFFIX)

LIBHGOTRACENAME=hgotrace$(RDBMS_VERSION)
LIBHGOTRACE=$(LIBHOME)$(LIB_PREFIX)$(LIBHGOTRACENAME).$(SO_EXT)
LLIBHGOTRACE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGOTRACENAME)$(LIB_SUFFIX)

LIBDBTOOLSNAME=dbtools$(RDBMS_VERSION)
LIBDBTOOLS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBTOOLSNAME).$(LIB_EXT)
LLIBDBTOOLS=$(LDLIBFLAG)$(LIBDBTOOLSNAME)

LIBNNETNAME=nnet$(RDBMS_VERSION)
LIBNNET=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNNETNAME).$(LIB_EXT)
LLIBNNET=$(LDLIBFLAG)$(LIBNNETNAME)

LIBNNETDNAME=nnetd$(RDBMS_VERSION)
LIBNNETD=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNNETDNAME).$(LIB_EXT)
LLIBNNETD=$(LDLIBFLAG)$(LIBNNETDNAME)

LIBNNET_CLT=$(LIBNNETD)
LLIBNNET_CLT=$(LLIBNNETD)

DLMHOME=$(ORACLE_HOME)/odlm/

LIBMMNAME=mm
LIBMM=$(LIBHOME)$(LIB_PREFIX)$(LIBMMNAME).$(LIB_EXT)
LLIBMM=$(LDLIBFLAG)$(LIBMMNAME)


LIBRDBMS_CLT=$(LIBCLIENT) $(LIBNNET_CLT) $(LIBSKGXP_CLT) $(LIBVSN) \
	$(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_CLT=$(LLIBCLIENT) $(LLIBNNET_CLT) $(LLIBSKGXP_CLT) $(LLIBVSN) \
	$(LLIBCOMMON) $(LLIBGENERIC)

LIBRDBMS_SERVER=$(LIBCLIENT) $(LIBSKGXP_CLT) $(LIBVSN) \
	$(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_SERVER=$(LLIBCLIENT) $(LLIBSKGXP_CLT) $(LLIBVSN) \
	$(LLIBCOMMON) $(LLIBGENERIC)

LIBCLNTSHNAME=clntsh
LIBCLNTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSHNAME).$(SO_EXT)
LLIBCLNTSH=$(LDLIBFLAG)$(LIBCLNTSHNAME)
LIBCLNTSH_NPT=
LLIBCLNTSH_NPT=

LIBAGTSHNAME=agtsh
LIBAGTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBAGTSHNAME).$(SO_EXT)
LLIBAGTSH=$(LDLIBFLAG)$(LIBAGTSHNAME)

LIBKNLOPTNAME=knlopt
LIBKNLOPT=$(RDBMSLIB)$(LIB_PREFIX)$(LIBKNLOPTNAME).$(LIB_EXT)
LLIBKNLOPT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBKNLOPTNAME)$(LIB_SUFFIX)

LIBAVSTUBNAME=avstub$(RDBMS_VERSION)
LIBAVSTUB=$(LIBHOME)$(LIB_PREFIX)$(LIBAVSTUBNAME).$(LIB_EXT)
LLIBAVSTUB=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAVSTUBNAME)$(LIB_SUFFIX)

LIBAVSERVERNAME=avserver$(RDBMS_VERSION)
LIBAVSERVER=$(LIBHOME)$(LIB_PREFIX)$(LIBAVSERVERNAME).$(LIB_EXT)
LLIBAVSERVER=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAVSERVERNAME)$(LIB_SUFFIX)

LIBAVCLIENTNAME=avclient$(RDBMS_VERSION)
LIBAVCLIENT=$(LIBHOME)$(LIB_PREFIX)$(LIBAVCLIENTNAME).$(LIB_EXT)
LLIBAVCLIENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAVCLIENTNAME)$(LIB_SUFFIX)

AVLIBS = `if [ -f $(LIBAVSERVER) ] ; then echo "$(LLIBAVSERVER)" ; else echo "$(LLIBAVSTUB)"; fi` `if [ -f $(LIBAVCLIENT) ] ; then echo "$(LLIBAVCLIENT)" ; fi`

LIBORASDKBASENAME=orasdkbase
LIBORASDKBASE=$(LIBHOME)$(LIB_PREFIX)$(LIBORASDKBASENAME).$(SO_EXT)
LLIBORASDKBASE=$(LDLIBFLAG)$(LIBORASDKBASENAME)

LIBORASDKSHNAME=orasdk
LIBORASDKSH=$(LIBHOME)$(LIB_PREFIX)$(LIBORASDKSHNAME).$(SO_EXT)
LLIBORASDKSH=$(LDLIBFLAG)$(LIBORASDKSHNAME)

CONFIG = $(RDBMSLIB)config.$(OBJ_EXT)


LLIBORDSDO=$(LDLIBFLAG)$(LIBORDSDONAME)$(LIB_SUFFIX)
SDOLIBS = `if ${AR} tv $(LIBKNLOPT) | $(GREP) "kxmnsd.$(OBJ_EXT)" > /dev/null 2>&1 ; then echo " " ; else echo "${LLIBORDSDO}"; fi`

RDBMSHOME=$(ORACLE_HOME)/rdbms/
RDBMSLIB=$(RDBMSHOME)$(LIBDIR)/
RDBMSADMIN=$(RDBMSHOME)admin/

ORAMAPLIB=$(RDBMSLIB)

LIBNIDNAME=nid
LIBNID=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNIDNAME).$(LIB_EXT)
LLIBNID=$(LDLIBFLAG)$(LIBNIDNAME)

THREAD_ORALIBS_MPMT=-lpthread
THREAD_ORALIBS_=
THREAD_ORALIBS=$(THREAD_ORALIBS_$(MPMT_SERVER))


ORACLE_KERNEL_LIBS=$(LLIBSKGTR) $(LLIBPERFSRV) $(NAETTOBJS) $(CONFIG)\
	$(SPOBJS) $(LLIBSERVER) $(LLIBODM) $(LLIBSAGE) \
	$(LLIBNNET) $(LLIBSKGXP) $(CORELIBS) $(LLIBRDBMS_SERVER) \
	$(LLIBKNLOPT) $(OLAPLINKOPTS) \
	$(LLIBSLAX) $(LLIBPLSQL) $(LLIBSERVER) $(LLIBRDBMS_SERVER) $(AVLIBS) \
	$(LLIBKNLOPT) $(LLIBSLAX) $(LLIBPLSQL) $(LLIBJAVAVMORJOX) \
	$(LLIBOCIJDBCST) $(LLIBWWG) $(NTZEOBJ) $(NETLIBS) $(NZLIBS) $(LLIBMM) $(CORELIBS) $(LLIBZTKG)\
	$(NETLIBS) $(NZLIBS) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) $(SDOLIBS) $(CARTLIBS) \
	$(CLSRLIBS_SERVER) $(CSSCLNTLIBS_SERVER) \
        $(CORECOMPRESSLIBS) $(ENCRYPTLIBS)  \
	$(CORELIBS) $(LLIBSNLSRTL) $(LLIBUNLSRTL) $(LLIBXSD) $(CORELIBS) \
	$(LLIBASMCLNT) $(LLIBCOMMON) $(LLIBCORE) $(PL_ORALIBS) $(THREAD_ORALIBS)
LIBCLIENTSHNAME=clientsh$(RDBMS_VERSION)
LLIBCLIENTSH=$(LDLIBFLAG)$(LIBCLIENTSHNAME)$(LIB_SUFFIX)
LIBGENERICSHNAME=genericsh$(RDBMS_VERSION)
LLIBGENERICSH=$(LDLIBFLAG)$(LIBGENERICSHNAME)$(LIB_SUFFIX)
LIBCOMMONSHNAME=commonsh$(RDBMS_VERSION)
LLIBCOMMONSH=$(LDLIBFLAG)$(LIBCOMMONSHNAME)$(LIB_SUFFIX)
LIBMMSHNAME=mmsh
LLIBMMSH=$(LDLIBFLAG)$(LIBMMSHNAME)$(LIB_SUFFIX)
LIBVSNSHNAME=vsnsh$(RDBMS_VERSION)
LLIBVSNSH=$(LDLIBFLAG)$(LIBVSNSHNAME)$(LIB_SUFFIX)
LIBNNETSHNAME=nnetsh$(RDBMS_VERSION)
LLIBNNETSH=$(LDLIBFLAG)$(LIBNNETSHNAME)$(LIB_SUFFIX)

LIBORIONNAME=orion$(RDBMS_VERSION)
LIBORION=$(LIBHOME)$(LIB_PREFIX)$(LIBORIONNAME).$(LIB_EXT)
LLIBORION=$(LDLIBFLAG)$(LIBORIONNAME)

LIBDSGANAME=dsga$(RDBMS_VERSION)
LIBDSGA=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDSGANAME).$(LIB_EXT)
LLIBDSGA=$(LDLIBFLAG)$(LIBDSGANAME)
LOC_LIBDSGA=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDSGANAME).$(LIB_EXT)

LIBDBGUISSNAME=dbguiss
LOC_LIBDBGUISS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBGUISSNAME).$(LIB_EXT)
LIBDBGUISS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBGUISSNAME).$(SO_EXT)
LLIBDBGUISS=$(LDLIBFLAG)$(LIBDBGUISSNAME)

ASMCLNT_LIBS=$(LLIBASMCLNT) $(LLIBCOMMON) $(LLIBSAGE) $(LLIBSKGXP) \
             $(LLIBGENERIC)
ASMCLNTSH_LIBS=$(LLIBASMCLNTSH) $(LLIBSAGE) $(LLIBSKGXP)
ASMCLNT_OCR_LIBS=$(ASMCLNT_LIBS)
ASMCLNT_CSS_LIBS=$(ASMCLNT_LIBS)


LINK_JOX_STATICALLY=yes

# Entering /ade/b/865225302/oracle/rdbms/export_banner.mk

# Exiting /ade/b/865225302/oracle/rdbms/export_banner.mk
# Entering /ade/b/865225302/oracle/rdbms/s_exports.mk


LIBPERFSRVNAME=perfsrv$(RDBMS_VERSION)
LIBPERFSRV=$(LIBHOME)$(LIB_PREFIX)$(LIBPERFSRVNAME).$(LIB_EXT)
LLIBPERFSRV=-Wl,--whole-archive $(LDLIBFLAG)$(LIBPERFSRVNAME)$(LIB_SUFFIX) -Wl,--no-whole-archive

SKGXP_EXT=$(SO_EXT)



SKGXN_EXT=$(SO_EXT)


SKGXN_VERSION=2
LLIBOCCI=$(LDLIBFLAG)$(LIBOCCINAME)
LIBOCCI=$(LIBHOME)$(LIB_PREFIX)$(LIBOCCINAME).$(SO_EXT).$(RDBMS_VERSION).$(RDBMS_MINOR_VERSION)


LIBSKGXNNAME=skgxn$(SKGXN_VERSION)
LIBSKGXN=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)


DSGALIBLIST=$(RDBMSLIB)dsgaliblist

IPPCPMERGED=ippcpmerged
LIBIPPCPMERGED=$(LIB_PREFIX)$(IPPCPMERGED).$(LIB_EXT)
LLIBIPPCPMERGED=$(LDLIBFLAG)$(IPPCPMERGED)

IPPCPEMERGED=ippcpemerged
LIBIPPCPEMERGED=$(LIB_PREFIX)$(IPPCPEMERGED).$(LIB_EXT)
LLIBIPPCPEMERGED=$(LDLIBFLAG)$(IPPCPEMERGED)

PL_ENCRYPTLIBS = $(LLIBIPPCPEMERGED) $(LLIBIPPCPMERGED) 

# Exiting /ade/b/865225302/oracle/rdbms/s_exports.mk
# Exiting /ade/b/865225302/oracle/rdbms/exports.mk
# Entering /ade/b/865225302/oracle/network/exports.mk

NETWORKHOME=$(ORACLE_HOME)/network/
NETWORKADMIN=$(NETWORKHOME)admin/
NETWORKINSTALL=$(NETWORKHOME)install/
NETWORKDEMO=$(NETWORKHOME)demo/

# Entering /ade/b/865225302/oracle/network/adapters.mk

# Entering /ade/b/865225302/oracle/network/s_adapters.mk

# Exiting /ade/b/865225302/oracle/network/s_adapters.mk

# Entering /ade/b/865225302/oracle/network/libnames.mk

NETWORK_VERSION=11
BASENAME=n
NETWORKLIB=$(NETWORKHOME)$(LIBDIR)/
NETWORKJLIB=$(NETWORKHOME)$(JLIBDIR)/

COMMONNAME=${BASENAME}${NETWORK_VERSION}
NLNAME=${BASENAME}l${NETWORK_VERSION}
TCPNAME=${BASENAME}tcp${NETWORK_VERSION}
QUENAME=${BASENAME}que${NETWORK_VERSION}
DECNETNAME=${BASENAME}dec${NETWORK_VERSION}
LU62NAME=${BASENAME}lu62${NETWORK_VERSION}
MBNAME=${BASENAME}mb${NETWORK_VERSION}
DCENAME=${BASENAME}dce${NETWORK_VERSION}
BEQNAME=${BASENAME}beq${NETWORK_VERSION}
IPCNAME=${BASENAME}ipc${NETWORK_VERSION}
SPXNAME=${BASENAME}spx${NETWORK_VERSION}
TLINAME=${BASENAME}tli${NETWORK_VERSION}
TLITNAME=${BASENAME}tlit${NETWORK_VERSION}
TLISNAME=${BASENAME}tlis${NETWORK_VERSION}
TLIDNAME=${BASENAME}tlid${NETWORK_VERSION}
USNAME=${BASENAME}us${NETWORK_VERSION}
SHMNAME=${BASENAME}shm${NETWORK_VERSION}
TCPSNAME=${BASENAME}tcps${NETWORK_VERSION}
TCPAIONAME=${BASENAME}tcpaio${NETWORK_VERSION}
ENTRUSTNAME=${BASENAME}nzentr${NETWORK_VERSION}
NSGRNAME=${BASENAME}sgr${NETWORK_VERSION}
LSNRNAME=${BASENAME}lsnr${NETWORK_VERSION}
LSNRCNAME=${BASENAME}lsnrc${NETWORK_VERSION}
ONNAME=${BASENAME}on${NETWORK_VERSION}
ONDNAME=${BASENAME}ond${NETWORK_VERSION}
ONCNAME=${BASENAME}onc${NETWORK_VERSION}
ONCJNAME=${BASENAME}oncj${NETWORK_VERSION}
RONAME=${BASENAME}ro${NETWORK_VERSION}
ROCNAME=${BASENAME}roc${NETWORK_VERSION}
ROXNAME=${BASENAME}rox${NETWORK_VERSION}
ROTNAME=${BASENAME}rot${NETWORK_VERSION}
CMNAME=${BASENAME}cm${NETWORK_VERSION}
NHOSTNAME=${BASENAME}host${NETWORK_VERSION}
TNSNAME=${BASENAME}tns${NETWORK_VERSION}
ORACLENAME=${BASENAME}oname${NETWORK_VERSION}
NISNAME=${BASENAME}nis${NETWORK_VERSION}
CDSNAME=${BASENAME}cds${NETWORK_VERSION}
NDSNAME=${BASENAME}nds${NETWORK_VERSION}
LDAPNAME=${BASENAME}ldap${NETWORK_VERSION}
LDAPJNAME=${BASENAME}ldapj${NETWORK_VERSION}
NUJNINAME=${BASENAME}jni${NETWORK_VERSION}
NZJSNAME=${BASENAME}zjs${NETWORK_VERSION}
JSSLNAME=${BASENAME}jssl${NETWORK_VERSION}

NMPNAME=${BASENAME}nmp${NETWORK_VERSION}

TANAME=${BASENAME}ta${NETWORK_VERSION}
TALNAME=${BASENAME}tal${NETWORK_VERSION}


SNLPTDUM         =  $(NETWORKLIB)snlptdum.$(OBJ_EXT) 
OSNTABST         = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT            = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

LIBNETWORK	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBTHINNCR       =  $(NETWORKLIB)$(LIB_PREFIX)$(ROTNAME).$(LIB_EXT)

LOC_LIBNUJNI     =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(LIB_EXT)
LOC_LIBJSSL      =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(LIB_EXT)
LIBONCJ          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCJNAME).$(SO_EXT)
LIBNUJNI         =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(SO_EXT)
LIBJSSL          =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(SO_EXT)
LIBLDAPJ         =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(SO_EXT)
LOC_LIBONCJ      =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCJNAME).$(LIB_EXT)
LOC_LIBLDAPJ     =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(LIB_EXT)

LIBNCR           =  $(NETWORKLIB)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LIBNFP           =  $(NETWORKLIB)$(LIB_PREFIX)$(CMNAME).$(LIB_EXT)
LIBNI            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCC          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCNAME).$(LIB_EXT)
LIBNND           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONDNAME).$(LIB_EXT)
LIBNNO           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONNAME).$(LIB_EXT)
LIBNSGR          =  $(NETWORKLIB)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LIBNSGL          =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRNAME).$(LIB_EXT)
LIBNSGLC         =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRCNAME).$(LIB_EXT)

LLIBNCR           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)
LLIBNFP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CMNAME)$(ILIB_SUFFIX)
LLIBNI            =  $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)
LLIBNNCC          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONCNAME)$(ILIB_SUFFIX)
LLIBNND           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONDNAME)$(ILIB_SUFFIX)
LLIBNNO           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONNAME)$(ILIB_SUFFIX)
LLIBNSGR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)
LLIBNSGL          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRNAME)$(ILIB_SUFFIX)
LLIBNSGLC         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRCNAME)$(ILIB_SUFFIX)


LIBNTT           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LIBNTTAIO        =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(SO_EXT)
LOC_LIBNTTAIO    =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(LIB_EXT)
LOC_LIBNTVI      =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(LIB_EXT)
LIBNTVI          =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(SO_EXT)
LOC_LIBNTEVQ     =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(LIB_EXT)
LIBNTEVQ         =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(SO_EXT)
LIBNTZ           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME).$(LIB_EXT)
LIBNTZSTUB       =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME)_std.$(LIB_EXT)
LOC_LIBNZTWVE    =  $(NETWORKLIB)$(LIB_PREFIX)$(ENTRUSTNAME).$(LIB_EXT)
LIBNZTWVE        =  $(NETWORKLIB)$(LIB_PREFIX)$(ENTRUSTNAME).$(SO_EXT)
LIBNTS           =  $(NETWORKLIB)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LIBNTD           =  $(NETWORKLIB)$(LIB_PREFIX)$(DECNETNAME).$(LIB_EXT)
LIBNTOD          =  $(NETWORKLIB)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LIBCDS           =  $(NETWORKLIB)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LIBNTLU62        =  $(NETWORKLIB)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LIBNTTLI	 =  $(NETWORKLIB)$(LIB_PREFIX)$(TLINAME).$(LIB_EXT)
LIBNTUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(USNAME).$(LIB_EXT)
LIBNTSHM         =  $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME).$(LIB_EXT)
LIBNTP           =  $(NETWORKLIB)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNTNP          =  $(NETWORKLIB)$(LIB_PREFIX)$(NMPNAME).$(LIB_EXT)

LLIBNTT           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)
LLIBNTVI          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(VINAME)$(ILIB_SUFFIX)
LLIBNTEVQ         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(QUENAME).$(ILIB_SUFFIX)
LLIBNTZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPSNAME)$(ILIB_SUFFIX)
LLIBNTS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)
LLIBNTD           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DECNETNAME)$(ILIB_SUFFIX)
LLIBNTOD          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)
LLIBCDS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)
LLIBNTLU62        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)
LLIBNTTLI	 =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TLINAME)$(ILIB_SUFFIX)
LLIBNTUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(USNAME)$(ILIB_SUFFIX)
LLIBNTSHM        = $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME)$(ILIB_SUFFIX)
LLIBNTP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(BEQNAME)$(ILIB_SUFFIX)
LLIBNTNP          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NMPNAME)$(ILIB_SUFFIX)

LIBNL1           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBNL2           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LIBNL            =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LLIBNL           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NLNAME)$(ILIB_SUFFIX)


LIBNUAPI         =  $(NETWORKLIB)$(LIB_PREFIX)$(TANAME).$(LIB_EXT)
LIBNULOCAL       =  $(NETWORKLIB)$(LIB_PREFIX)$(TALNAME).$(LIB_EXT)

LLIBNUAPI         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)


LLIBNUAPI	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)
LLIBSSL          = #$(LDLIBFLAG)$(ILIB_PREFIX)sslref-bsafe$(ILIB_SUFFIX)
LLIBNZJS 	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)

LIBNA            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAE           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAU           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMP           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCI          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNFG          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNG           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNPL           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNR            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNS            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNTR           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMS0          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBSSLREF 	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBZT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)


LIBNZJS          =  $(NETWORKLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

LIBNLNV          =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LDAPSYSLIBD = $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTNAME).$(LIB_EXT)
LDAPSYSLIBS = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBLDAPCLNTNAME)$(ILIB_SUFFIX)

COMMONSHNAME=$(BASENAME)sh$(NETWORK_VERSION)
NLSHNAME=$(BASENAME)lsh$(NETWORK_VERSION)
LDAPSHNAME=$(BASENAME)ldapsh$(NETWORK_VERSION)
ROSHNAME=$(BASENAME)rosh$(NETWORK_VERSION)
LIBNETWORKSH=$(NETWORKLIB)$(LIB_PREFIX)$(COMMONSHNAME).$(SO_EXT)
LIBNLSH=$(NETWORKLIB)$(LIB_PREFIX)$(NLSHNAME).$(SO_EXT)
LIBLDAPSH=$(NETWORKLIB)$(LIB_PREFIX)$(LDAPSHNAME).$(SO_EXT)
LIBRPCSH=$(NETWORKLIB)$(LIB_PREFIX)$(ROSHNAME).$(SO_EXT)
LLIBNETWORKSH=$(LDLIBFLAG)$(COMMONSHNAME)$(ILIB_SUFFIX)
LLIBNLSH=$(LDLIBFLAG)$(NLSHNAME)$(ILIB_SUFFIX)
LLIBLDAPSH=$(LDLIBFLAG)$(LDAPSHNAME)$(ILIB_SUFFIX)
LLIBRPCSH=$(LDLIBFLAG)$(ROSHNAME)$(ILIB_SUFFIX)
# Exiting /ade/b/865225302/oracle/network/libnames.mk

# Exiting /ade/b/865225302/oracle/network/adapters.mk

LIBNTTCP     = $(LIBHOME)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LLIBNTTCP    = $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)

LIBNTOD      = $(LIBHOME)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LLIBNTOD     = $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)

LIBCDS       = $(LIBHOME)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LLIBCDS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)

LIBNTLU62    = $(LIBHOME)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LLIBNTLU62   = $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)

LIBNTS       = $(LIBHOME)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LLIBNTS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)

LIBNETWORK   = $(LIBHOME)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LLIBNETWORK  = $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)

LIBNSGR      = $(LIBHOME)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LLIBNSGR     = $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)

LIBSQLNET  = $(LDFLAGSFILE) $(PROTOCOLLIBD) $(NATIVELIBD) $(NATIVESYSLIBD) $(LIBNSGR) $(LIBNZJS) $(LIBNETWORK) $(LIBNL)
LLIBSQLNET = $(LDFLAGSLIST) $(PROTOCOLLIBS) $(NATIVELIBS) $(NATIVESYSLIBS) $(LLIBNCRYPT) $(LLIBNSGR) $(LLIBNZJS) $(LLIBNETWORK) $(LLIBNL)

LIBRPC       = $(LIBHOME)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LLIBRPC      = $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)

TNSLSNR	     = $(BINHOME)tnslsnr$(EXE_SUFFIX)
LSNRCTL	     = $(BINHOME)lsnrctl$(EXE_SUFFIX)

NIGTAB       = $(LIBHOME)nigtab.$(OBJ_EXT)
NIGCON       = $(LIBHOME)nigcon.$(OBJ_EXT) 
NTCONTAB     = $(LIBHOME)ntcontab.$(OBJ_EXT)
MTS_NCR	     = $(LIBHOME)ncrstab.$(OBJ_EXT)

OSNTABST     = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT        = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

NAETAB       = $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS	     = $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB_OBJ   = nautab.$(OBJ_EXT)
NAUTAB	     = $(LIBHOME)$(NAUTAB_OBJ)

NETLIBS      = $(LLIBSQLNET) $(LLIBRPC) $(LLIBSQLNET)
NETLIBD      = $(LIBSQLNET) $(LIBRPC)

LDFLAGSFILE=$(LIBHOME)ldflags
LDFLAGSLIST=`$(CAT) $(LDFLAGSFILE)`

LIBNTP       = $(LIBHOME)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNL        = $(LIBHOME)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)


# Entering /ade/b/865225302/oracle/network/s_exports.mk


NAETAB64	= $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS64	= $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB64	= $(LIBHOME)$(NAUTAB_OBJ)


# Exiting /ade/b/865225302/oracle/network/s_exports.mk
# Exiting /ade/b/865225302/oracle/network/exports.mk
# Entering /ade/b/865225302/oracle/plsql/exports.mk

PLSQL_VERSION=11

WRAP=$(BINHOME)wrap

LIBPLSNAME=pls
LIBPLSN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBPLS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION)$(ILIB_SUFFIX) 
LIBPLSNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(SO_EXT)
ILIBPLSN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(ILIB_EXT)
LIBPLPNAME=plp
LIBPLPN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBPLP=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION)$(ILIB_SUFFIX)
LIBPLPNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(SO_EXT)
ILIBPLPN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(ILIB_EXT)
LIBPLCNAME=plc
LIBPLCN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBPLC=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION)$(ILIB_SUFFIX)
LIBPLCSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(SO_EXT)
ILIBPLCN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(ILIB_EXT)

LIBEXTP=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBEXTP=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION)

LIBPLSF=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(LIB_EXT) 
LLIBPLSF=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION) $(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)

LIBPLSB=$(LIBHOME)$(LIBPLSNAME)$(PLSQL_VERSION)
LLIBPLSB=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION)

PLSQLLIBS=$(LIBPLSN) $(LIBPLPN)
LPLSQLLIBS=$(LLIBPLS)


LLIBPLSQL= $(LPLSQLLIBS) $(LLIBPLP)

LIBPSANAME=psa
LIBICD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBICD=$(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)
LIBPSD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPSD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION)$(LIB_SUFFIX)
LIBPSA=$(LIBHOME)$(LIB_PREFIX)$(LIBPSANAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPSA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPSANAME)$(PLSQL_VERSION)$(LIB_SUFFIX)

PLSQLHOME=$(ORACLE_HOME)/plsql/

PLSSHNAME=plssh$(PLSQL_VERSION)
LLIBPLSSH=$(LDLIBFLAG)$(PLSSHNAME)$(LIB_SUFFIX)
PLPSHNAME=plpsh$(PLSQL_VERSION)
LLIBPLPSH=$(LDLIBFLAG)$(PLPSHNAME)$(LIB_SUFFIX)
# Entering /ade/b/865225302/oracle/plsql/s_exports.mk


LLIBPLS+=-lrt

# Exiting /ade/b/865225302/oracle/plsql/s_exports.mk
# Exiting /ade/b/865225302/oracle/plsql/exports.mk
# Entering /ade/b/865225302/oracle/has/exports.mk


HAS_VERSION = 11

HAS_SKGXNLIBS=$(LLIBSKGXN)

HAS_CORELIBS=$(LLIBCLNTSH) $(CORELIBS)
HAS_LLIBCORE=$(LLIBCORE)

HAS_NZLIBS=$(LLIBNZ) $(LLIBZT)

HAS_XMLLIBS=$(LLIBXML)

CSSGCNAME=clssgc
CSSGC_OBJ=$(HASLIB)$(CSSGCNAME).$(OBJ_EXT)

SCLSINAME=sclsi
SCLSI_OBJ=$(HASLIB)$(SCLSINAME).$(OBJ_EXT)

HASGENNAME=hasgen
LIBHASGENNAME=$(HASGENNAME)$(HAS_VERSION)
LIBHASGEN=$(LIBHOME)$(LIB_PREFIX)$(LIBHASGENNAME).$(HASGEN_EXT)
LLIBHASGEN=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHASGENNAME)$(ILIB_SUFFIX)

HASGENLIBS=$(LLIBHASGEN) $(OCRLIBS_DEFAULT) $(HAS_CORELIBS) $(HAS_SKGXNLIBS) \
	$(HAS_NZLIBS) $(HAS_XMLLIBS) $(LLIBCLNTSH)
HASGENLIBS_OCR=$(LLIBHASGEN) $(HAS_CORELIBS) \
	$(HAS_SKGXNLIBS) 
HASGENLIBS_SERVER=$(LLIBHASGEN) $(HAS_SKGXNLIBS) $(HAS_NZLIBS) $(HAS_XMLLIBS)

CSSCLNTLIBS=$(HASGENLIBS)

CSSCLNTLIBS_SERVER=$(HASGENLIBS_SERVER) $(OCRLIBS_SERVER) \
	$(CSSCLNTLIBS_SERVER_XLIBS)

CSSCLNTLIBS_SERVER_XLIBS=
CSSCLNTLIBS_SERVER_STATICLIBS=$(CSSGC_OBJ)


LIBEVMNAME=oevm
LLIBEVM=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBEVMNAME)$(LIB_SUFFIX)

LLIBORAAGENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBORAAGENTNAME)$(LIB_SUFFIX)

LIBORAAGENTNAME=oraagent
LIBORAROOTAGENTNAME=orarootagent
LIBORADAEMONAGENTNAME=oradaemonagent

LIBCLSRNAME=clsr$(HAS_VERSION)
LIBCLSR=$(HASLIB)$(LIB_PREFIX)$(LIBCLSRNAME).$(LIB_EXT)
LLIBCLSR=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSRNAME)$(LIB_SUFFIX)
CLSRLIBS=$(LLIBCLSR) $(LIBDBTOOLS) $(LLIBONS) \
	$(LLIBEVM) $(HASGENLIBS) \
	$(OCRLIBS_NONCACHING) $(HAS_CORELIBS) $(LLIBDBCFG) $(SUIDLINKLDLIBS) 

LIBCLSRANAME=clsra$(HAS_VERSION)
LIBCLSRA=$(HASLIB)$(LIB_PREFIX)$(LIBCLSRANAME).$(SO_EXT)
LLIBCLSRA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSRANAME)$(ILIB_SUFFIX)
CLSRLIBS_SERVER=$(LLIBCLSRA) $(LLIBDBCFG)

RDLIBS=$(HAS_CORELIBS) $(HAS_SKGXNLIBS) $(RDPROVIDERLIBS)

LIBRDJNINAME=rdjni$(HAS_VERSION)
LIBRDJNI=$(HASLIB)$(LIB_PREFIX)$(LIBRDJNINAME).$(SO_EXT)
LLIBRDJNI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDJNINAME)$(ILIB_SUFFIX)

RD_JARNAME=rd
RD_JAR=$(HASJLIB)$(RD_JARNAME).$(JAR_EXT)

RDTOOL_JARNAME=rdtool
RDTOOL_JAR=$(HASJLIB)$(RDTOOL_JARNAME).$(JAR_EXT)


LIBDNSSDNAME=dns_sd
LIBDNSSD=$(HASLIB)$(LIB_PREFIX)$(LIBDNSSDNAME).$(SO_EXT)
LLIBDNSSD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDNSSDNAME)$(ILIB_SUFFIX)

LIBMDNSNAME=omdns$(HAS_VERSION)
LIBMDNS=$(HASLIB)$(LIB_PREFIX)$(LIBMDNSNAME).$(SO_EXT)
LLIBMDNS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBMDNSNAME)$(ILIB_SUFFIX)

MDNSRESPONDERNAME=mdnsd
MDNSRESPONDER=$(HASBIN)$(MDNSRESPONDERNAME)$(EXE_SUFFIX)

MDNSNETMONITORNAME=oranetmonitor
MDNSNETMONITOR=$(HASBIN)$(MDNSNETMONITORNAME)$(EXE_SUFFIX)

DNS_SDNAME=oradnssd
DNS_SD=$(HASBIN)$(DNS_SDNAME)$(EXE_SUFFIX)


RDPROVIDERNAMEPREFIX=rdp

LIBRDPAPPLENAME=$(RDPROVIDERNAMEPREFIX)apple$(HAS_VERSION)
LIBRDPAPPLE=$(HASLIB)$(LIB_PREFIX)$(LIBRDPAPPLENAME).$(SO_EXT)
LLIBRDPAPPLE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPAPPLENAME)$(ILIB_SUFFIX)

LIBRDPEAPPLENAME=$(RDPROVIDERNAMEPREFIX)eapple$(HAS_VERSION)
LIBRDPEAPPLE=$(HASLIB)$(LIB_PREFIX)$(LIBRDPEAPPLENAME).$(SO_EXT)
LLIBRDPEAPPLE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPEAPPLENAME)$(ILIB_SUFFIX)

LIBRDPSLPNAME=$(RDPROVIDERNAMEPREFIX)slp$(HAS_VERSION)
LIBRDPSLP=$(HASLIB)$(LIB_PREFIX)$(LIBRDPSLPNAME).$(LIB_EXT)
LLIBRDPSLP=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPSLPNAME)$(ILIB_SUFFIX)

LIBRDPNULLNAME=$(RDPROVIDERNAMEPREFIX)null$(HAS_VERSION)
LIBRDPNULL=$(HASLIB)$(LIB_PREFIX)$(LIBRDPNULLNAME).$(SO_EXT)
LLIBRDPNULL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPNULLNAME)$(ILIB_SUFFIX)

LIBGPNPTNAME=gpnpt$(HAS_VERSION)
LLIBGPNPT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGPNPTNAME)$(LIB_SUFFIX)

GPNPSETUP_JARNAME=gpnpsetup
GPNPSETUP_JAR=$(HASJLIB)$(GPNPSETUP_JARNAME).$(JAR_EXT)

LIBGNSNAME=gns$(HAS_VERSION)
LIBGNS=$(HASLIB)$(LIB_PREFIX)$(LIBGNSNAME).$(SO_EXT)
LLIBGNS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGNSNAME)$(ILIB_SUFFIX)

LIBGNSUTLNAME=gnsutl$(HAS_VERSION)
LIBGNSUTL=$(HASLIB)$(LIB_PREFIX)$(LIBGNSUTLNAME).$(SO_EXT)
LLIBGNSUTL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGNSUTLNAME)$(ILIB_SUFFIX)

GNSLIBS=$(HAS_CORELIBS)

LIBGNSJARNAME=gns
LIBGNSJAR=$(HASJLIB)$(LIBGNSJARNAME).$(JAR_EXT)

LIBGNSJNINAME=gnsjni$(HAS_VERSION)
LIBGNSJNI=$(HASLIB)$(LIB_PREFIX)$(LIBGNSJNINAME).$(SO_EXT)
LLIBGNSJNI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGNSJNINAME)$(ILIB_SUFFIX)

LIBCLSDNAME=clsd$(HAS_VERSION)
LIBCLSD=$(HASLIB)$(LIB_PREFIX)$(LIBCLSDNAME).$(LIB_EXT)
LLIBCLSD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSDNAME)$(LIB_SUFFIX)
CLSDLIBS=$(LLIBCLSD) $(HAS_CORELIBS)

LIBAGFWNAME=agfw$(HAS_VERSION)
LIBAGFW=$(HASLIB)$(LIB_PREFIX)$(LIBAGFWNAME).$(LIB_EXT)
LLIBAGFW=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAGFWNAME)$(LIB_SUFFIX)
AGFWLIBS=$(LLIBAGFW) $(HAS_CORELIBS) $(HASLIBS) $(OCRLIBS_DEFAULT)

LIBDBNAME=db
LIBDB46NAME=db-4.6

LIBCRFNAME=crf$(HAS_VERSION)
LIBCRF=$(HASLIB)$(LIB_PREFIX)$(LIBCRFNAME).$(LIB_EXT)
LLIBCRF=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCRFNAME)$(LIB_SUFFIX)
CRFLIBS=$(LLIBCRF) $(HAS_CORELIBS)
CRF_CLIENT_JAR=$(HASHOME)$(JLIBDIR)/crf-client.jar
CRF_JAR=$(HASHOME)$(JLIBDIR)/crf.jar
CRF_TEST_JAR=$(HASHOME)$(JLIBDIR)/crf-test.jar

OPMNLIB=$(ORACLE_HOME)/opmn/lib/

LIBONSNAME=ons
LIBONS=$(OPMNLIB)$(LIB_PREFIX)$(LIBONSNAME).$(LIB_EXT)
LLIBONS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBONSNAME)$(LIB_SUFFIX)

LIBSCCLNTNAME=scclnt$(HAS_VERSION)
LIBSCCLNT=$(HASLIB)$(LIB_PREFIX)$(LIBSCCLNTNAME).$(SO_EXT)
LLIBSCCLNT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSCCLNTNAME)$(ILIB_SUFFIX)

HASHOME=$(ORACLE_HOME)/has/
HASLIB=$(HASHOME)$(LIBDIR)/
HASJLIB=$(HASHOME)$(JLIBDIR)/
HASADMIN=$(HASHOME)admin/
HASPUBH=$(I_SYM)$(HASHOME)include


HASLIBS=$(LLIBCSSCLNT) $(LLIBHASGEN) $(LLIBSCLS)
SCCLNTLIBS=$(LLIBSCCLNT) $(LLIBEONS)

# Entering /ade/b/865225302/oracle/has/s_exports.mk


CSSCLNT_EXT=$(SO_EXT)

SCLS_EXT=$(SO_EXT)

HASGEN_EXT=$(SO_EXT)

SSCLSINAME=ssclsi
SCLSI_OBJ=$(HASLIB)$(SCLSINAME).$(OBJ_EXT) $(HASLIB)$(SSCLSINAME).$(OBJ_EXT)


# Exiting /ade/b/865225302/oracle/has/s_exports.mk
# Exiting /ade/b/865225302/oracle/has/exports.mk
# Entering /ade/b/865225302/oracle/opsm/exports.mk

OPSMHOME=$(ORACLE_HOME)/opsm/
OPSMJLIB   = $(OPSMHOME)/jlib
OPSMLIB =$(ORACLE_HOME)/opsm/lib/
OPSM_VERSION=$(HAS_VERSION)

SRVMNAME=srvm
LIBOPSMNAME=$(SRVMNAME)$(OPSM_VERSION)
LIBOPSM=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOPSMNAME).$(SO_EXT)
LIBOPSM_STATIC=$(LIB_PREFIX)$(LIBOPSMNAME).$(LIB_EXT)
LLIBOPSM=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOPSMNAME)$(ILIB_SUFFIX)

SRVMOCRNAME=srvmocr
LIBSRVMOCRNAME=$(SRVMOCRNAME)$(OPSM_VERSION)
LIBSRVMOCR=$(PRODSOHOME)$(LIB_PREFIX)$(LIBSRVMOCRNAME).$(SO_EXT)
LIBSRVMOCR_STATIC=$(LIB_PREFIX)$(LIBSRVMOCRNAME).$(LIB_EXT)
LLIBSRVMOCR=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSRVMOCRNAME)$(ILIB_SUFFIX)

SRVMHASNAME=srvmhas
LIBSRVMHASNAME=$(SRVMHASNAME)$(OPSM_VERSION)
LIBSRVMHAS=$(PRODSOHOME)$(LIB_PREFIX)$(LIBSRVMHASNAME).$(SO_EXT)
LIBSRVMHAS_STATIC=$(LIB_PREFIX)$(LIBSRVMHASNAME).$(LIB_EXT)
LLIBSRVMHAS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSRVMHASNAME)$(ILIB_SUFFIX)

OCRUTLNAME=ocrutl
LIBOCRUTLNAME=$(OCRUTLNAME)$(OPSM_VERSION)
LIBOCRUTL_STATIC=$(OPSMLIB)$(LIB_PREFIX)$(LIBOCRUTLNAME).$(LIB_EXT)
LOC_LIBOCRUTL=$(LIBOCRUTL_STATIC)
LIBOCRUTL=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOCRUTLNAME).$(SO_EXT)
LLIBOCRUTL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCRUTLNAME)$(ILIB_SUFFIX)

OCRBACKENDNAME=ocrb
LIBOCRBACKENDNAME=$(OCRBACKENDNAME)$(OPSM_VERSION)
LIBOCRBACKEND_STATIC=$(OPSMLIB)$(LIB_PREFIX)$(LIBOCRBACKENDNAME).$(LIB_EXT)
LOC_LIBOCRBACKEND=$(LIBOCRBACKEND_STATIC)
LIBOCRBACKEND=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOCRBACKENDNAME).$(SO_EXT)
LLIBOCRBACKEND=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCRBACKENDNAME)$(ILIB_SUFFIX)

OCRNAME=ocr
LIBOCRNAME=$(OCRNAME)$(OPSM_VERSION)
LIBOCR_STATIC=$(OPSMLIB)$(LIB_PREFIX)$(LIBOCRNAME).$(LIB_EXT)
LOC_LIBOCR=$(LIBOCR_STATIC)
LIBOCR=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOCRNAME).$(SO_EXT)
LLIBOCR=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCRNAME)$(ILIB_SUFFIX)

EMMASNAME=emmas
LIBEMMASNAME=$(EMMASNAME)$(OPSM_VERSION)
LIBEMMAS=$(PRODSOHOME)$(LIB_PREFIX)$(LIBEMMASNAME).$(SO_EXT)
LLIBEMMAS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBEMMASNAME)$(ILIB_SUFFIX)

DBCFGNAME=dbcfg
LIBDBCFGNAME=$(DBCFGNAME)$(OPSM_VERSION)
LIBDBCFG=$(PRODSOHOME)$(LIB_PREFIX)$(LIBDBCFGNAME).$(SO_EXT)
LLIBDBCFG=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDBCFGNAME)$(ILIB_SUFFIX)

UININAME=uini
LIBUININAME=$(UININAME)$(OPSM_VERSION)
LIBUINI=$(PRODSOHOME)$(LIB_PREFIX)$(LIBUININAME).$(SO_EXT)
LLIBUINI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBUININAME)$(ILIB_SUFFIX)


OCRLIBS_CACHING =  $(LLIBOCR)  $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
		   $(HASGENLIBS_OCR) $(HAS_CORELIBS) $(SYSLIBS) \
		   $(LLIBTHREAD) $(ASMCLNTSH_LIBS)

OCRLIBS_DEFAULT =  $(LLIBOCR) $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
                   $(HASGENLIBS_OCR) $(HAS_CORELIBS) $(SYSLIBS) \
		   $(ASMCLNTSH_LIBS)

OCRLIBS_NONCACHING =  $(LLIBOCR) $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
                      $(HASGENLIBS_OCR) $(HAS_CORELIBS) $(SYSLIBS) \
                      $(ASMCLNTSH_LIBS)

OCRLIBS_SERVER =  $(LLIBOCR) $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
                  $(HASGENLIBS_SERVER)

DBCFGLIBS = $(LLIBDBCFG) $(OCRLIBS_DEFAULT)

EMMASLIBS = $(LLIBEMMAS) $(OCRLIBS_DEFAULT)

UINILIBS = $(LLIBUINI) $(OCRLIBS_NONCACHING)

# Entering /ade/b/865225302/oracle/opsm/s_exports.mk

# Exiting /ade/b/865225302/oracle/opsm/s_exports.mk
# Exiting /ade/b/865225302/oracle/opsm/exports.mk
# Entering /ade/b/865225302/oracle/javavm/exports.mk
JAVAVMFORRDBMSBASENAME = javavm$(RDBMS_VERSION)
LIBJAVAVMFORRDBMSBASENAME = $(LIB_PREFIX)$(JAVAVMFORRDBMSBASENAME)
LIBJAVAVM=$(LIBHOME)$(LIBJAVAVMFORRDBMSBASENAME).$(LIB_EXT)
LLIBJAVAVM=$(LDLIBFLAG)$(JAVAVMFORRDBMSBASENAME)

# Entering /ade/b/865225302/oracle/javavm/javavm_common.mk

# Exiting /ade/b/865225302/oracle/javavm/javavm_common.mk
# Entering /ade/b/865225302/oracle/javavm/s_exports.mk

# Exiting /ade/b/865225302/oracle/javavm/s_exports.mk
# Exiting /ade/b/865225302/oracle/javavm/exports.mk
# Entering /ade/b/865225302/oracle/xdk/exports.mk

XDKHOME    = $(ORACLE_HOME)/xdk/

XDK_LIB_VER    = 11



XML_LIB_NAME     = xml
XML_LIB_VER      = $(XDK_LIB_VER)
XML_LIB          = $(XML_LIB_NAME)$(XML_LIB_VER)

LIBXML_STATIC    = $(LIB_PREFIX)$(XML_LIB).$(LIB_EXT)
LIBXML_SHARED    = $(LIB_PREFIX)$(XML_LIB).$(SO_EXT)
LIBXML_SLH       = $(LIB_PREFIX)$(XML_LIB).$(ILIB_EXT)

LIBXML           = $(LIBHOME)$(LIBXML_STATIC)
LLIBXML          = $(LDLIBFLAG)$(XML_LIB)

LIBXML_ARC_LIB   = $(LIBXML)
LIBXML_SHARE_LIB = $(LIBHOME)$(LIBXML_SHARED)

XDKPUBLIC=$(XDKHOME)include $(XDKHOME)public

XDKPUBH=$(I_SYM)$(XDKHOME)include $(I_SYM)$(XDKHOME)public



XMLORGJAR = $(XDKSRC)java/lib/xmlorg.jar
XMLORG1JAR = $(XDKSRC)java/lib/xmlorg1.jar
JAXP_SERVICESJAR = $(XDKSRC)java/lib/jaxp_services.jar

XMLORG2JAR = $(XDKSRC)java/lib/xmlorg2.jar

JAXB2JAR = $(XDKSRC)java/lib/jaxb-api.jar


XML = xml
XMLJAR = $(LIBHOME)$(XML).$(JAR_EXT)

XMLPARSERV2 = xmlparserv2
XMLPARSERV2A = xmlparserv2_sans_jaxp_services
XMLPARSERV2B = xmlparserv2_jaxp_services

XMLPARSERV2JAR = $(LIBHOME)$(XMLPARSERV2).$(JAR_EXT)
XMLPARSERV2AJAR = $(LIBHOME)$(XMLPARSERV2A).$(JAR_EXT)
XMLPARSERV2BJAR = $(LIBHOME)$(XMLPARSERV2B).$(JAR_EXT)

XMLMESG = xmlmesg
XMLMESGJAR = $(LIBHOME)$(XMLMESG).$(JAR_EXT)

XMLCOMP = xmlcomp
XMLCOMPJAR = $(LIBHOME)$(XMLCOMP).$(JAR_EXT)

XMLCOMP2 = xmlcomp2
XMLCOMP2JAR = $(LIBHOME)$(XMLCOMP2).$(JAR_EXT)

XMLDEMO = xmldemo

CLASSGEN = classgen
CLASSGENJAR = $(LIBHOME)$(CLASSGEN).$(JAR_EXT)

XSCHEMA = xschema
XSCHEMAJAR  = $(LIBHOME)$(XSCHEMA).$(JAR_EXT)

XSQL = oraclexsql
XSQLJAR = $(LIBHOME)$(XSQL).$(JAR_EXT)

XSQLSERIAL = xsqlserializers
XSQLSERIALJAR = $(LIBHOME)$(XSQLSERIAL).$(JAR_EXT)

XSU = xsu12
XSUJAR = $(LIBHOME)$(XSU).$(JAR_EXT)

TRANSX = transx
TRANSXJAR  = $(LIBHOME)$(TRANSX).$(ZIP_EXT)

JAXBJAR = $(XDKSRC)java/lib/jaxb-api.jar

XQUERY = xquery
XQUERYJAR  = $(LIBHOME)$(XQUERY).$(JAR_EXT)

XQJAPI = xqjapi
XQJAPIJAR  = $(LIBHOME)$(XQJAPI).$(JAR_EXT)

XQJORI = xqjori
XQJORIJAR  = $(LIBHOME)$(XQJORI).$(JAR_EXT)

OJCR = ojcr
OJCRJAR  = $(LIBHOME)$(OJCR).$(JAR_EXT)


# Entering /ade/b/865225302/oracle/xdk/s_exports.mk
 
# Exiting /ade/b/865225302/oracle/xdk/s_exports.mk

# Exiting /ade/b/865225302/oracle/xdk/exports.mk
PRECOMPHOME = $(ORACLE_HOME)/precomp/

# Entering /ade/b/865225302/oracle/odbc/exports.mk


ODBCHOME    = $(ORACLE_HOME)/odbc/
ODBCLIB     = $(ODBCHOME)$(LIBDIR)/
ODBCBIN     = $(ODBCHOME)bin/
ODBCSRC     = $(ODBCHOME)src/
ODBCINSTALL = $(ODBCHOME)install/
ODBCDEMO    = $(ODBCHOME)demo/

ODBC_MESG = odbc/mesg


# Exiting /ade/b/865225302/oracle/odbc/exports.mk

PRODUCT = odbc

DEMO_ODBC_BUILD_SHARED = $(CC) $(LDOBJSZ) -o $(EXE) $(OBJS) $(LDLIBFLAG)$(DEMO_ODBCLIBS) $(LDPATHFLAG)$(ODBCDM_LIBHOME)
DEMO_ODBC_BUILD_SHARED_32 = $(DEMO_ODBC_BUILD_SHARED)


DEMO_ODBC_BUILD_STATIC = $(CC) $(LDOBJSZ) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(ODBCDM_LIBHOME) $(STATICPROLDLIBS)
DEMO_ODBC_BUILD_STATIC_32 = $(DEMO_ODBC_BUILD_STATIC)


C2O=$(CC) $(LDOBJSZ) $(DEMO_INCLUDE) -c $*.c
C2O_32 = $(C2O)




ODBCHCACHE  = $(ORACLE_HOME)/odbc/hcache
ODBCINCLUDE = $(ORACLE_HOME)/odbc/include
ODBCSQRES   = $(ORACLE_HOME)/odbc/src/sqres
ODBCSQORA   = $(ORACLE_HOME)/odbc/src/sqora
ODBCPERFTOOL = $(ORACLE_HOME)/odbc/src/odbcperftool


ODBCSNAP =

OCILIB      =
ODBC_LDLIBS = 
ODBCEXE_LDLIBS = 
ODBC_IC =
LINK_IC =
COMP_IC =

SQSAPILIBS  =
ORANLSLIB   =
ORAUNLSLIB  =
ORACORELIB  =

UTILITYLIB           = $(ODBCLIB)utility.$(ILIB_EXT)
UTILITYNOUNICODELIB  = $(ODBCLIB)utilitynounicode.$(ILIB_EXT)
WRAPWIN32UNICODELIB  = 
SQRESLIB             = $(ODBCLIB)sqres.$(ILIB_EXT)
SQOCILIB             = $(ODBCLIB)sqoci.$(ILIB_EXT)
SQORALIB             = $(ODBCLIB)sqora.$(ILIB_EXT)
SQORASLIB            = $(ODBCLIB)sqoras.$(ILIB_EXT)
ODBCPERFTOOLLIB      = $(ODBCLIB)odbcperftool.$(ILIB_EXT)

SQRESUSDLL    =
SQORASDLL     =
SQORADLL      =

STOPDB=
CLNTST=
COPYDB=
STARTDB=

UNIXODBC_VERSION=       # now exposed to customer in s_odbc.mk
UNIXODBC_SIGNATURE=     # now exposed to customer in s_odbc.mk
CD_PUB_OSDS=
UNTAR_UNIXODBC=
BUILD_ODBCDM=
PATCH_ODBCDM=

RM_UNIXODBCDM=

INCLUDE =

LPFLAGS =

EXECS = $(SQORADLL) 

SQORA_MAIN = 
SQVER_RES =

SQORA_LINK_FILES = $(SQORA_MAIN) $(SQORALIB) $(SQVER_RES)
SQORA_LIB_FILES  =
SQORA_LINKLINE   = $(LINK) $(ODBCDLL_LDFLAGS) $(LDLIBS) \
                   $(SQORA_LINK_OPTS) $(SQORA_LIB_FILES) \
		   $(ODBC_LDLIBS) $(SQVER_RES)




INSTALL_SHORTCUT_TARGETS=$(SQORADLL)
INSTALL_SHORTCUT_32_64_TARGETS=

# Entering /ade/b/865225302/oracle/odbc/s_odbc.mk

DMFLAGS= -DBUILD_REAL_64_BIT_MODE -DSIZEOF_LONG=8 -fshort-wchar
UNIXODBC_VERSION=2.2.14
UNIXODBC_SIGNATURE=unixODBC
UNIXODBC_BUNDLE_NAME= $(UNIXODBC_SIGNATURE)-$(UNIXODBC_VERSION)

ifndef DM_HOME
	ODBCDM_HOME=$(ORACLE_HOME)/odbc/public/osds/$(UNIXODBC_SIGNATURE)
else
	ODBCDM_HOME=$(DM_HOME)
endif

ODBCDM_INCLUDE=$(ODBCDM_HOME)/include
ODBCDM_LIBHOME=$(ODBCDM_HOME)/lib
ODBCDM_LIBHOME32=$(ODBCDM_HOME)/lib32
DEMO_ODBCLIBS=odbc
DEMO_INCLUDE=$(I_SYM)$(ODBCDM_INCLUDE) $(I_SYM)$(OTHER_H) $(I_SYM).


ILIB_EXT = $(LIB_EXT)

OCILIB      = -lclntsh 
DMLIB       = -lodbcinst
ORANLSLIB   = $(ORACLE_HOME)/lib/libnls$(RDBMS_VERSION).$(LIB_EXT)
ORAUNLSLIB  = $(ORACLE_HOME)/lib/libunls$(RDBMS_VERSION).$(LIB_EXT)
ORACORELIB  = $(ORACLE_HOME)/lib/libcore$(RDBMS_VERSION).$(LIB_EXT)

SQORADLL = $(ODBCLIB)libsqora.$(SO_EXT).$(RDBMS_VERSION).$(RDBMS_MINOR_VERSION)

INCLUDE = $(I_SYM)$(ODBCHOME)public/osds/unixODBC/include

INCLUDE += $(I_SYM)$(ODBCINCLUDE)        \
           $(I_SYM)$(ODBCHOME)/include/osds      \
           $(I_SYM)$(RDBMSHOME)public     \
           $(I_SYM)$(RDBMSHOME)include    \
           $(I_SYM)$(ORACOREHOME)public   \
           $(I_SYM)$(ORACOREHOME)include  \
           $(I_SYM)$(NLSRTLHOME)include   \
           $(I_SYM)$(NETWORKHOME)public   \
           $(I_SYM)$(NETWORKHOME)include

LPFLAGS = -DOLDLK $(DMFLAGS)

LPFLAGS += -fshort-wchar

C2O=$(CC) $(LPFLAGS) $(DEMO_INCLUDE) -c $*.c

SQORA_LINK_OPTS = -shared -Wl,-soname,libsqora.$(SO_EXT).$(RDBMS_VERSION).$(RDBMS_MINOR_VERSION) 

SQORA_LIB_FILES = -Wl,-whole-archive $(SQOCILIB) $(UTILITYLIB) \
                  -Wl,-no-whole-archive \
                  -L$(ORACLE_HOME)/lib  -Bdynamic $(OCILIB) \
                   $(ORACORELIB) $(ORAUNLSLIB) \
                  -L$(ODBCDM_LIBHOME) $(DMLIB) \
                  -Wl,-whole-archive $(SQORALIB) -Wl,-no-whole-archive



DEMO_ODBC_BUILD_SHARED_32 = $(CC) $(AMD32FLAGS) -o $(EXE) $(OBJS) $(LDLIBFLAG)$(DEMO_ODBCLIBS) \
                         $(LDPATHFLAG)$(ODBCDM_LIBHOME32)

DEMO_ODBC_BUILD_STATIC_32 = $(CC) $(AMD32FLAGS) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(ODBCDM_LIBHOME32) $(STATICPROLDLIBS)

C2O_32=$(CC) $(DEMO_INCLUDE) $(AMD32FLAGS) -c $*.c

SQORA_LINKLINE += -L$(ORACLE_HOME)/lib $(LLIBIRC) -ldl 

INSTALL_SHORTCUT_TARGETS=libsqora.$(SO_EXT).$(RDBMS_VERSION).$(RDBMS_MINOR_VERSION)


# Exiting /ade/b/865225302/oracle/odbc/s_odbc.mk
# Exiting odbc.mk
# Entering /ade/b/865225302/oracle/buildtools/mkfile/libclntsh.mk
$(LIBCLNTSH_NPT) $(LIBCLNTSH): ${LIBHOME}libclient11.$(LIB_EXT) ${LIBHOME}libsql11.$(LIB_EXT) \
	${LIBHOME}libntcp11.$(LIB_EXT)	${LIBHOME}libn11.$(LIB_EXT) \
        ${LIBHOME}libnl11.$(LIB_EXT)	${LIBHOME}libnldap11.$(LIB_EXT) \
        ${LIBHOME}libnhost11.$(LIB_EXT)	${LIBHOME}libntns11.$(LIB_EXT) \
        ${LIBHOME}libnoname11.$(LIB_EXT) ${LIBHOME}libnus11.$(LIB_EXT) \
        ${LIBHOME}libntcps11.$(LIB_EXT)	${LIBHOME}libnro11.$(LIB_EXT) \
	${LIBHOME}libnsslb11.$(LIB_EXT)	${LIBHOME}libcommon11.$(LIB_EXT)\
	${LIBHOME}libgeneric11.$(LIB_EXT) ${LIBHOME}libmm.$(LIB_EXT)\
	${LIBHOME}libnls11.$(LIB_EXT)	${LIBHOME}libcore11.$(LIB_EXT)\
	${RDBMSLIB}xaondy.$(OBJ_EXT)
	$(SILENT)$(ECHO) "Building client shared library libclntsh.$(SO_EXT) ..."
	$(SILENT)$(ECHO) "Call script $$ORACLE_HOME/bin/genclntsh ..."
	$(GENCLNTSH)
	$(SILENT)$(ECHO) "Built $$ORACLE_HOME/${LIBDIR}/libclntsh.$(SO_EXT) ... DONE"

ALLSHLIBS=$(VARLIBS) $(LD_SHLIBS) $(DLOPENLIBS) $(NEW_LD_SHLIBS) $(NEW_DLOPENLIBS)
shlibs: $(ALLSHLIBS)
bootstraplibs: $(CUS_BOOTSTRAPLIBS)

$(LD_SHLIBS) ld_shlibs_target: $(ALWAYS)
	$(CUS_SHLIB_COMMAND)

$(DLOPENLIBS) dlopenlibs_target: $(ALWAYS)
	$(CUS_DLOPENLIB_COMMAND)

$(NEW_LD_SHLIBS) new_ld_shlibs_target: $(ALWAYS)
	$(CUS_NEW_SHLIB_COMMAND)

$(NEW_DLOPENLIBS) new_dlopenlibs_target: $(ALWAYS)
	$(CUS_NEW_DLOPENLIB_COMMAND)

$(VARLIBS) varlibs_target: $(ALWAYS)
	$(CUS_VARLIB_COMMAND)

$(CUS_BOOTSTRAPLIBS) bootstraplib_target: $(ALWAYS)
	$(CUS_BOOTSTRAPLIB_COMMAND)

ld_shlib:
	$(LD_SHLIB_COMMAND)

dlopenlib:
	$(DLOPENLIB_COMMAND)

new_ld_shlib:
	$(NEW_LD_SHLIB_COMMAND)

new_dlopenlib:
	$(NEW_DLOPENLIB_COMMAND)

bootstrap:
	$(BOOTSTRAPLIB_COMMAND)

always:
# Exiting /ade/b/865225302/oracle/buildtools/mkfile/libclntsh.mk
