Rem Copyright (c) 1987, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem NAME
Rem    CATMETA.SQL - Object views of the Oracle dictionary for Metadata API.
Rem  FUNCTION
Rem     Creates an object model of the Oracle dictionary for use by the
Rem     DataPump Metadata API.
Rem  NOTES
Rem     Must be run when connected to SYS or INTERNAL.
Rem     IMPORTANT! Keep the files catnomtt.sql and catnomta.sql in synch with
Rem     this file. These are invoked by catnodp.sql during downgrade.
Rem
Rem     All types must have EXECUTE granted to PUBLIC.
Rem     All top-level views used by the mdAPI to actually fetch full object
Rem     metadata (eg, KU$_TABLE_VIEW) must have SELECT granted to PUBLIC, but
Rem     must have CURRENT_USERID checking security clause.
Rem     All views subordinate to the top level views (eg, KU$_SCHEMAOBJ_VIEW)
Rem     must have SELECT granted to SELECT_CATALOG_ROLE.
Rem
Rem  MODIFIED
Rem     dgagne     07/29/10 - add tstz parse item for table
Rem     tbhukya    07/20/10 - Bug 9921787: Backout the fix of bug 9263473
Rem     lbarton    06/18/10 - bug 9828495: correct freelists/freelist groups
Rem                           for deferred segs
Rem     tbhukya    06/15/10 - bug 9786285: Exclude system generated, hidden and
Rem                           stored in lob cols from ku$_objgrant_view which is 
Rem                           generated with Xmltype columns.
Rem     mjangir    06/04/10 - bug 9535916: Remap_schema for dbms job 
Rem     ebatbout   05/24/10 - bug 9491530: Add Ku$_10_2_fhtable_view and new
Rem                           reason (condition 9) to ku$_unload_method_view
Rem     sdavidso   05/17/10 - lrg 3603060: problem with procobj ordering
Rem     lbarton    04/21/10 - bug 9491539
Rem     sdavidso   04/16/10 - bug9480755: export dependant xmlschemas
Rem     sdavidso   01/27/10  - Bug 8847153: reduce resources for xmlschema
Rem                            export
Rem     rapayne    04/08/10 - bug 9368254: fix ora-1427 in ku$_iotpart_data_view
Rem     rapayne    03/14/09 - bug 9439234: add parse_alter parameter and add hook
Rem                           for parsing $default for diff/alter paths.
Rem     dgagne     04/05/10 - fetch stats on if collected
Rem     ebatbout   03/28/10 - Add transform parameter, streamd_version, that 
Rem                           will contain stream metadata version.
Rem     tbhukya    02/19/10 - Bug 9263473: add schema_obj in 
Rem                                        ku$_procact_instance_t
Rem     tbhukya    02/15/10 - Bug 9277709: Exclude nested table column 
Rem                                        from KU$_OBJGRANT_VIEW
Rem     rapayne    01/27/10 - bug 8692663: modify htspart_data_view and 
Rem                           htpart_data_view to fetch obj_num rather than
Rem                           dataobj_num.
Rem     ebatbout   01/20/10 - bug 8465341: Define parse item, sqlvalid. Add 
Rem                           base_col_name to the stream metadata (used
Rem                           for nested tables) and bump stream minor version
Rem                           from 1 to 2 to account for this new field.
Rem     mjangir    01/08/10  - bug 6644244: IOT w/mapping table in TTS mode 
Rem     rapayne    01/05/09 - bug 8367909: add a view for exppkgact$ checking.
Rem     rapayne    01/05/09 - bug 9214753: fix ku$_iotpart_data_view - data layer obj#
Rem                           returning more than one row.
Rem     tbhukya    01/07/10  - Bug 9160088: Generate cachehint value based on version
Rem     dgagne     12/22/09  - fix version 10 tab stat views
Rem     sdavidso   12/18/09  - bug 8395233: avoid export of invalid nested
Rem                            table
Rem     tbhukya    12/04/09  - Bug 8307012: Add support for domain index whose
Rem                                         support interface is 1
Rem     ebatbout   12/02/09 - Bug 9080222: Ensure that inclcol_name is not
Rem                           a system generated name in ku$_iotable_view
Rem     rapayne    12/01/09 - bug 8402872: modify ku$_context_view to check for 'owner'.
Rem     lbarton    11/02/09 - deferred segment creation for partitions
Rem     tbhukya    11/24/09 - Bug 8822995: Add OLDEXPORT parameter
Rem     tbhukya    11/18/09 - Bug 8983880: Use clob for default_val 
Rem                                        in ku$_simple_col_t
Rem     sdavidso   11/03/09 - lrg 4065313: fix home content dif
Rem     sdavidso   10/30/09 - bug 8477142 constraints and ref partitioning
Rem     rapayne    10/01/09 - cm_synch: change transform parameter 
Rem                               MAKE_DIFF_READY to CM_MODE
Rem     prakumar   09/16/09 - Bug 8857211: Handle NULL flag3 in ku$_m_view_view
Rem     msaunder   09/15/09 - Change object_grant version to 11.2 from 11.1
Rem     lbarton    09/11/09 - bug 8856467: do not fetch grants on nested tables
Rem     ebatbout   09/10/09 - Bug 8523879: exclude MGDSYS user
Rem     tbhukya    09/07/09 - Bug 8794227: Get the stats info even though stats 
Rem                                        deleted but locked.
Rem     mjangir    08/24/09 - Bug 8467825: remove v$datafile, bad performance 
Rem     tbhukya    08/10/09 - Do not use  RBO for CONSTRAINT_T
Rem     dgagne     08/07/09 - add convert parse items
Rem     ebatbout   07/24/09 - Bug 8722752: Add parse items for dropped columns
Rem     tbhukya    07/10/09 - Bug 8666013: get the password_date in varchar2 
Rem                           to get the full date format.
Rem     tbhukya    07/08/09 - Bug 8617779: Increase the size of role 
Rem                                        in ku$_proxy_role_item_t
Rem     spetride   06/15/09 - 8561406: add SCHEMAOID parse item for XMLSCHEMA 
Rem     dgagne     06/04/09 - add property to index col type and view
Rem     sdavidso   06/03/09 - bug 8352607: support minimize records_per_block
Rem     rapayne    05/30/09 - bug 8539628: add SCHEMA_LEVEL parse item for
Rem                           xmlschema objects.
Rem     lbarton    03/26/09 - bug 8354702: add EXPORT_PATHS views
Rem     rapayne    05/10/09 - bug 8355496: add deferred_stg ind_part_t
Rem     sdavidso   04/21/09 - bug 7597578: support NT partition properties
Rem     lbarton    11/25/08 - archive level compression
Rem     lbarton    03/19/09 - lrg 3762023: unusable index subpartitions
Rem     lbarton    03/23/09 - bug 8347514: parse read-only view query
Rem     ebatbout   04/09/09 - bug 8367506: fix to ku$_trigger_view
Rem     ebatbout   04/09/09 - bug 8397778: prefix session_roles with SYS
Rem     sdavidso   02/27/09 - bug 7567327: ORA-904 importing xmltype
Rem     mjangir    04/06/09 - bug 8372834: add tablespace transform for MV
Rem     mjangir    03/25/09 - bug 7658844:  hard connect when creating refresh
Rem                           group 
Rem     ebatbout   03/25/09 - bug 7229037: add OVERRIDE_* parameters for the
Rem                           Modify transform
Rem     sdavidso   03/03/09 - bug 8328108: add xdb_ntable objnum view
Rem     mjangir    03/17/09 - bug 7722575: predicate issue
Rem     sdavidso   03/03/09 - bug 8328108: add xdb_ntable objnum view
Rem     lbarton    11/13/08 - TSTZ support
Rem     rapayne    03/05/09 - bug 8295513: 'editionify' type views.
Rem     lbarton    10/08/08 - bug 5661474: network exp/imp of (sub)partitions
Rem     lbarton    02/18/09 - bug 8252494: ku$_deferred_stg_t/_view
Rem     rapayne    02/26/09 - lrg 3784210: add REUSE transform parameter to
Rem                           tablespace sxml-ddl transforms list.
Rem     sdavidso   01/22/09 - bug 5672035: fix quote handling for
Rem                           remap_column_name
Rem     lbarton    02/09/09 - bug 5323844: fix synonym OWNER_NAME filter
Rem     slynn      02/06/09 - Fix bug-7023008: SecureFile Retention incorrect
Rem     lbarton    12/30/08 - Bug 7354560: add trailing_nl to ku_source_t
Rem     lbarton    12/19/08 - bug 6269507: soft connect when creating packages
Rem     sdavidso   12/16/08 - bug 7620558: problems w/xmltype,ADT,nested tables
Rem     rapayne    01/06/08 - bug 7605276: in 11.2 obj$.spare3 maps the original
Rem                           owner# while owner# will potentially map the internal
Rem                           adjunct schema when editions have been enabled. 
Rem                           This txn changes schemaobj_view to additionally 
Rem                           collect this new mapping.
Rem     sdavidso   12/09/08 - lrg 3718808: extend OCT fix to equipartitioned
Rem                           tables
Rem     rapayne    11/10/08 - bug7393931: add parameters for modifysxml:
Rem                           STORAGE, SEGMENT_ATTRIBUTES, TABLESPACE, 
Rem                           CONSTRAINTS, REF_CONSTRAINTS
Rem     lbarton    11/03/08 - always export equipart NT table data
Rem     sdavidso   10/21/08 - bug 7320642: don`t export xmltype nested tables
Rem     sdavidso   09/26/08 - bug7362589: excessive time for table_data
Rem     rlong      09/25/08 - 
Rem     ssonawan   07/11/08 - bug 5921164: add column powner to fga$
Rem     htseng     08/28/08 - 
Rem     mjangir    08/08/08 - bug 6460304: set properties=+1024(do not use RBO)
Rem                           in metaview$ for INDEX
Rem     ebatbout   07/09/08 - Bug 6075698: Add Streamsxml transform; add new
Rem                           hidden_columns parameter for sxml transforms;
Rem                           add new stylesheet, kuetable, that converts a
Rem                           diff doc. to SQL statements using external table
Rem     wesmith    06/30/08 - modify ku$_m_view_view, ku$_m_view_log_view to
Rem                           filter out new types of MVs, MV logs
Rem     dsemler    06/09/08 - fix merge error on view
Rem     pknaggs    07/07/08 - bug 6938028: Factor and Rule support for DVPS.
Rem     cchiappa   06/23/08 - Add ordering to COT views
Rem     lbarton    06/18/08 - bug 6624138: exclude history tables
Rem     dgagne     06/16/08 - make new object grant version 2.0, not 2.1
Rem     sdavidso   06/06/08 - bug 6910214: mv log in transportable
Rem     pknaggs    06/03/08 - bug 6938028: Database Vault Protected Schema.
Rem     lbarton    04/22/08 - bug 6730161: get version-specific hashcode
Rem     lbarton    06/02/08 - bug 6767780: view trigger on nested table col
Rem     sdavidso   05/23/08 - fix edition support
Rem     sdavidso   05/20/08 - bug 6861416: transportable fails
Rem                           w/exp_full_database
Rem     lbarton    04/22/08 - bug 6730161: get version-specific hashcode
Rem     dgagne     05/19/08 - add TSMSYS to the noexp table
Rem     rapayne    04/16/08 - bug 7129765 - add kuatype.xsl to handle alter 
Rem                           transforms for TYPE objects.
Rem     sdavidso   04/08/08 - bug 6953611: alter_package_spec also editionable
Rem     lbarton    02/05/08 - Bug 6029076: query parsing. PARSE_EXPRESSIONS
Rem                           defaults to TRUE. Parse_* in prvtmeta.
Rem     wesmith    03/20/08 - Project 25482: add snap$.flag3 to ku$_m_view_t,
Rem                           ku$_m_view_view
Rem     lbarton    02/05/08 - Bug 6029076: query parsing. PARSE_EXPRESSIONS
Rem                           defaults to TRUE. Parse_* in prvtmeta.
Rem     lbarton    04/01/08 - bug 6857781: editioning view for mv logs
Rem     rapayne    03/25/08 - bug 3337571: expand type definition for
Rem                           REGEN_DEFN support.
Rem     wesmith    03/20/08 - Project 25482: add snap$.flag3 to ku$_m_view_t,
Rem                           ku$_m_view_view
Rem     dsemler    03/06/08 - exclude the APPQOSSYS user
Rem     lbarton    02/05/08 - Bug 6029076: query parsing. PARSE_EXPRESSIONS
Rem                           defaults to TRUE. Parse_* in prvtmeta.
Rem     lbarton    01/24/08 - Bug 6724820: table compression
Rem     wesmith    12/21/07 - MV log purge optimization
Rem     lbarton    02/11/08 - Bug 6804815: pparse item for JOB schema
Rem     lbarton    01/31/08 - bug 5961283: get uncorrupted hashcode
Rem     zqiu       01/28/08 - bug 6750821, order ku$_m_view_view by
Rem                           snap$.parent_vname
Rem     smashimo   12/21/07 - Bug 6635956: replace null with '-' in audit$ col
Rem     mjangir    12/19/07 - bug 5211477: fix SEQUENCE start value
Rem     smashimo   11/27/07 - Bug 6603832: run catmetx.sql if XDB is installed
Rem     lbarton    11/26/07 - bug 6454237: parse trigger definition
Rem     sdavidso   11/06/07 - bug 5451654 - table ordering for equipartition NT
Rem     tbhukya    11/19/07 - bug 6484209: Disable storage for MV when storage 
Rem                           param set to false with set_transform_param
Rem     sdavidso   11/14/07 - Bug 6355515: exclude OLAP cube views
Rem     dgagne     11/13/07 - add network_name transform
Rem     lbarton    11/02/07 - bug 6060058: flashback archived tables
Rem     lbarton    10/31/07 - bug 6051635: domain index on xmltype col
Rem     htseng     10/25/07 - lrg 3194978: need order by clause for cluster
Rem                           column_list
Rem     smashimo   10/16/07 - Bug 6017760: Modify ku$_file_view for bitmaped
Rem                           tablespace
Rem     smashimo   10/12/07 - Bug 6063940: exculde tablespace group from 
Rem                           ku$_tablespace_view and ku$_tsquota_view
Rem     smashimo   10/03/07 - Bug 5891213: strip nulls from ind$.spare4 
Rem     dgagne     09/26/07 - fix stats of system generated indexes and columns
Rem     rapayne    08/06/07 - bug 6276904: fix freelist collection for
Rem                           'next generation' lobs
Rem     rapayne    07/26/07 - allow owner queries on rls_policy_view.
Rem     mjangir    08/12/07 - bug 5523375 - dont filter the pk constraint
Rem     mjangir    08/07/07 - bug 6156708 - add filter for index order by
Rem     htseng     07/16/07 - bug 6051635 -index on XML type column
Rem     sdavidso   07/10/07 - bug 5950173 - xmlschema dependencies
Rem     htseng     06/20/07 - equipartition nested table support
Rem     dgagne     06/29/07 - 
Rem     jkaloger   06/12/07 - Use version 11.0
Rem     achoi      04/26/07 - use defining_edition
Rem     dgagne     06/13/07 - Don`t force "analyze table" if table has 
Rem                           functional indexes
Rem     dgagne     05/17/07 - bulk object_grant by object
Rem     htseng     05/04/07 - Bug 5567364: DEFAULT profile
Rem     htseng     04/26/07 - bug 5690152: add 2 new fields in source_list_t
Rem     lbarton    02/02/07 - IMPORT_CONVENTIONAL
Rem     smashimo   04/19/07 - Bug 5095025: set properties=+1024(don't use RBO)
Rem                           in metaview$ for PROCDEPOBJ
Rem     sdavidso   04/23/07 - Note xmltype tables with hierarchy enabled
Rem     smashimo   04/06/07 - Bug 5464834: remove 'don't use rbo' bit from
Rem                           metaview$.properties
Rem     lbarton    04/05/07 - strmtable column sorting
Rem     sdavidso   03/22/07 - 5903231 - maintain binary storage for xmlschemas
Rem     cchiappa   03/22/07 - Cube DIMENSION USING support
Rem     lbarton    01/09/07 - kusparsd.xsl
Rem     sdavidso   02/15/07 - add LRG xsl parameter for DDL conversions
Rem     htseng     02/09/07 - bug 5727911: encrypted columns bit
Rem     sdavidso   01/31/07 - add XMLschemas for transportable
Rem     lbarton    01/18/07 - bug 5584945: restrict password access to
Rem                           EXP_FULL_DATABASE
Rem     htseng     01/16/07 - add RLS support for differ
Rem     htseng     01/08/07 - AQ_QUEUE, AQ_QUEUE_TABLE support for differ.
Rem     lbarton    11/03/06 - USING_INDEX transform param
Rem     lbarton    09/22/06 - ALTERDDL transform
Rem     rapayne    07/14/06 - Further differ/alter work.
Rem     achoi      12/21/06 - new definition for _CURRENT_EDITION_OBJ
Rem     smashimo   01/11/07 - bug 5520154: not null constraints on XMLType cols
Rem     smashimo   12/20/06 - bug 5589140: exclude ADT col in ku$_objgrant_view
Rem     cchiappa   12/15/06 - Match col# rather than colname in cube_tab_view
Rem     smashimo   12/05/06 - bug 5515882: Add 'rownum < 2' to query on secobj$
Rem     lbarton    11/03/06 - bug 5607195: subpartition template in interval
Rem                           partition
Rem     dgagne     12/01/06 - add property parse item for table_data
Rem     lbarton    11/17/06 - bug 5663744: add MODIFY transform for XMLSCHEMA
Rem     slynn      10/12/06 - smartfile->securefile
Rem     lbarton    10/05/06 - more interval partitioning
Rem     sramakri   10/20/06 - use get_version in ku$_m_view_view
Rem     sdavidso   10/18/06 - allow xml version based on metadata version
Rem     sdavidso   09/07/06 - Editions support
Rem     rdecker    08/15/06 - ADd PLScope parameter
Rem     lbarton    09/13/06 - interval partitioning
Rem     cchiappa   09/13/06 - Expand cube table metadata
Rem     akruglik   09/07/06 - Column Map Views got rechristened as Editioning
Rem                           Views
Rem     lbarton    09/18/06 - bug 5212908: PARALLEL_HINT
Rem     rapayne    09/10/06 - exclude XS$NULL from export
Rem     rapayne    09/07/06 - lrg 2526933: add order by to jijoin_table_view
Rem     lbarton    08/25/06 - Bug 5414416: transient types
Rem     lbarton    08/31/06 - lrg 2453260: dpstream compatibility
Rem     rapayne    08/22/06 - Add pfname to FGA_POLICY total_order filter
Rem     sdavidso   07/14/06 - parent_object parse items for refpar 
Rem     dgagne     08/21/06 - add user pref stats
Rem     sdavidso   07/25/06 - new view for 10_1_audit 
Rem     lbarton    07/12/06 - bug 5386908: XMLType fixes 
Rem     lbarton    06/01/06 - Editioning View (EV) transform 
Rem     ataracha   07/13/06 - add user anonymous to be excluded from all views
Rem     lbarton    10/05/05 - bug 4516042: xmlschemas and SB tables in Data 
Rem                           Pump 
Rem     rapayne    06/27/06 - lrg 2374146 - add ORDER BY to jijoin_view to
Rem                           make mdapi test (e.g., where clauses) more
Rem                           deterministic.
Rem     dkapoor    06/29/06 - don't export ORACLE_OCM 
Rem     clei       06/22/06 - add XDS policy types for fusion security
Rem     weizhang   06/12/06 - proj 18567: support LOBRETENTION and MAXSIZE 
Rem     htseng     05/30/06 - add support for column default replace null with 
Rem     sdavidso   05/23/06 - Add partition transportable support 
Rem     sdavidso   05/12/06 - support for ref partitioning 
Rem     rapayne    05/24/06 - proj 15998 - add xmlalter stylesheets.
Rem     wesmith    06/01/06 - create 10.2 view for triggers
Rem     wesmith    05/15/06 - add support for triggerdep$
Rem     sramakri   05/15/06 - set minor version to 2 in ku$_m_view_view
Rem     sramakri   04/12/06 - ku$_10_2_index_view
Rem     sdavidso   04/25/06 - support for invisible index attr 
Rem     suelee     03/31/06 - Add procedures for IORM 
Rem     sdavidso   04/28/06 - default parameters - part domain index 
Rem     dgagne     04/14/06 - add parse item for parttype in table_data 
Rem     shshanka   04/25/06 - (jstenois) changes to disallow direct path
Rem     sdavidso   04/12/06 - Add support for dependent tables 
Rem     dgagne     04/21/06 - add parseitem for tablespace num and index prop
Rem                         - add views to fetch subnames for tables + indexes
Rem     cchiappa   04/10/06 - ORGANIZATION CUBE tables 
Rem     lbarton    04/05/06 - bug 5120417: use ku$_prepost_view 
Rem     lbarton    03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS 
Rem                           params for SXML(DDL) 
Rem     lbarton    01/20/06 - partition transportable
Rem     lbarton    01/20/06 - bug 3328206: add QUOTE_SYMBOL 
Rem     dgagne     01/27/06 - add views to get tablespaces based on partitions 
Rem     lbarton    01/13/06 - bug 4951322: grants WITH HIERARCHY OPTION 
Rem     lbarton    12/29/05 - REMAP_COLUMN_NAME
Rem     rapayne    12/14/05 - bug 4868804: ku$_index_view workaround for a 
Rem                           typed view bug 4886241.
Rem     htseng     12/16/05 - add transform param PARTITIONING 
Rem     sdavidso   11/07/05 - Bug 4660745: Add fully qualified name expansion
Rem                           of attrname, for XMLtype naming issues.
Rem     lbarton    11/09/05 - bug 4724986: add kusidxwk.xsl 
Rem     rapayne    11/11/05 - bug 4634712: ensure local attributes are large
Rem                           enough to double up quotes.
Rem     cmlim      11/30/05 - support dml error logging 
Rem     sdavidso   10/19/05 - add group name for temporary tablespaces 
Rem     rapayne    10/07/05 - Fix bug 4628170 - fail to fetch index metadata
Rem                           for materialized views.
Rem     sdavidso   08/22/05 - add OMF indicator for files 
Rem     sdavidso   08/01/05 - add tranform_param type check info 
Rem     htseng     06/03/05 - metadata diffing
Rem     lbarton    05/27/05 - metadata diffing 
Rem     lbarton    05/25/05 - metadata diffing 
Rem     dgagne     06/27/05 - return ancestor info as base info for indexes, 
Rem                           if ancestor is available 
Rem     rapayne    06/13/05 - Bug 4321610: allow constraint conditions to
Rem                           exceed 4k chars.
Rem     lbarton    06/17/05 - bug 4352110: strip nulls from trigger 
Rem                           definition, whenclause 
Rem     dgagne     05/24/05 - fix problems with not uniquely identifying 
Rem                           objects with parse items 
Rem     dgagne     06/02/05 - add index_statistics parse item for index flags 
Rem                           to see if system generated 
Rem     lbarton    05/09/05 - Bug 4331909: fetch dataobj with ov_tabpart
Rem                           and ov_table 
Rem     lbarton    05/03/05 - Bug 4338735: dont export WMSYS 
Rem     dgagne     04/13/05 - fix bug 4134884 - do not decode public schema 
Rem                           for db_link 
Rem     dgagne     03/16/05 - fix find_sgc_view to look in con$ not ind$ for 
Rem                           constraints 
Rem     htseng     03/09/05 - more fixe for bug 4067141 
Rem     htseng     03/03/05 - bug 4067141: set up correct base_obj_num for pkg
Rem     dgagne     03/03/05 - return has_xmlschemacols for all types of 
Rem                           table_data objects 
Rem     dgagne     02/15/05 - bug 3738015 - give parse item for fgac on 
Rem                           table_data objects 
Rem     lbarton    01/07/05 - Bug 4109444: exclude schemas 
Rem     lbarton    12/21/04 - bug 4081635: not null constraint on ADT column 
Rem     lbarton    12/20/04 - bug 3995788: exclude type body for SQLJ type 
Rem     htseng     11/29/04 - bug 4004882: get updated default comsumer group 
Rem                           value. 
Rem     rpfau      10/25/04 - More on bug 3599656 - Do versioning. Make it 
Rem                           VERS_MAJOR=2, VERS_MINOR=2 for the 4 non-heap
Rem                           tables to get them all in sync, for checking
Rem                           whether to make check_type calls for
Rem                           transportable tablespace imports in kutable.xsl.
Rem     rpfau      09/10/04 - Bug 3599656 - Add hashcode and typeid to 
Rem                           subcoltype_t, hashcode to coltype_t, and
Rem                           version to type_t for type checking for
Rem                           transportable tablespace import.
Rem     araghava   10/29/04 - 3448802: get blocksize from 1st lob fragment if 
Rem                           deftsn is null in partlob$ 
Rem     htseng     10/18/04 - fix bug 3955213 not exclude private synonym when 
Rem                           exclude_noexp 
Rem     rapayne    10/13/04 - bug 3928528: Add table parse item, PRS_TRIGFLAG.
Rem                           Also, modify ku$_strmcol_view to utilize new
Rem                           get_col_property function to clear 
Rem                           encryption bits if appropriate.
Rem     dgagne     10/14/04 - add transform parameter stats_lock to lock 
Rem                           statistics 
Rem     htseng     10/05/04 - bug 3884290:add condition linkname is NULL for 
Rem                           ku$_base_proc_view
Rem     lbarton    09/01/04 - Bug 3827736: use NULLTOCHR0 with epvalue 
Rem     htseng     08/19/04 - bug 3794006:correct Tablespace size after resize
Rem     lbarton    08/05/04 - Bug 3813945: encryption password 
Rem     lbarton    07/16/04 - add encryption support 
Rem     dgagne     07/27/04 - add index_flags parse item for indexes 
Rem     dgagne     07/21/04 - get more index stats if both index name and cols 
Rem                           are not system generated 
Rem     rpfau      06/15/04 - Fix opaque type (also anydata type) in 
Rem                           partitioned tables - bug 3618089.
Rem     lbarton    06/30/04 - Bug 3722008: comment parse item: NAME (colname)
Rem     lbarton    06/29/04 - Bug 3730124: table_data parse items:
Rem                             HAS_NFT_VARRAY, HAS_NONSCOPED_REF
Rem     lbarton    06/22/04 - Bug 3695154: obsolete initmeta.sql 
Rem     htseng     06/21/04 - add support plsql_ccflags 
Rem     dgagne     06/25/04 - add stat_table and stat_schema as transforms for 
Rem                           statistics 
Rem     lbarton    06/10/04 - Bug 3675944: PCTSPACE for CLUSTER/CONSTRAINT;
Rem                           versioning support for dblink, statistics
Rem     lbarton    06/01/04 - Bug 3617842: SAMPLE and PCTSPACE 
Rem     jnarasin   05/28/04 - Alter User changes for EUS Proxy project 
Rem     dgagne     06/14/04 - add values to table stats for using stats table 
Rem     rvissapr   05/06/04 - dblink encoding - proj 5523 
Rem     lbarton    05/18/04 - Bug 3622808: comments on operators/idxtypes
Rem     lbarton    05/14/04 - trigflag
Rem     dgagne     05/12/04 - add trigflag as parse item for table_data 
Rem     dgagne     05/18/04 - add old stats types and stats for compatibility 
Rem     htseng     05/04/04 - bug 3599070: timestamp format 
Rem     htseng     05/11/04 - bug 3601775: fix SEQUENCE maxvalue 
Rem     lbarton    05/14/04 - Add TRANSPORTABLE_CLASSIC 
Rem     rpfau      05/12/04 - Add logic to control closure checking. 
Rem     lbarton    01/28/04 - split off catmet2.sql 
Rem     dgagne     04/28/04 - add privname as parse item to object_grant and
Rem                           sys_grant
Rem     htseng     04/27/04 - bug 3566300: support subtitutable column
Rem     lbarton    04/14/04 - Bug 3561663: fetch NOT NULL and check constr
Rem     htseng     04/08/04 - bug 3554691: add storage_clause for 
Rem                           AQ_QUEUE_TABLE 
Rem     lbarton    04/02/04 - Bug 3549198: parse item last_ddl_time 
Rem     htseng     04/02/04 - bug 3464376: subpartitions were created via 
Rem                           the tables's subpartition template clause 
Rem     lbarton    04/14/04 - Bug 3546038: MODIFY transform for STRMTABLE_T 
Rem     htseng     04/05/04 - add set_transform_param for CLUSTER 
Rem     mxiao      03/24/04 - support synonym in materialized view
Rem     rpfau      03/17/04 - Bump version number. 
Rem     rpfau      03/16/04 - Bug 3368895: add HAS_LONG_COL parse item to
Rem                           table_data. 
Rem     lbarton    03/30/04 - Bug 3540185: allow table_export of SYS tables 
Rem     lbarton    02/16/04 - Bug 3440387: exclude_noexp for types in tte 
Rem     emagrath   02/10/04 - Transportable OID/SETID constraints/indexes
Rem     dgagne     02/23/04 - fix statistics view performance 
Rem     htseng     02/02/04 - bug 3412625 : enlarge AQ_QUEUE comments size 
Rem     lbarton    01/30/04 - table data not schema object 
Rem     dgagne     01/20/04 - put back stats locking and caching changes 
Rem     lbarton    01/07/04 - Bug 3358912: force lob big endian 
Rem     dgagne     12/26/03 - get trigflags in stats for locking 
Rem     jdavison   12/18/03 - Add workaround of no_merge hint for optimizer 
Rem     dgagne     12/08/03 - escape epvalue single ' with 2 single ''
Rem     lbarton    12/03/03 - Bug 3209757: enable remap_schema for procdepobjg 
Rem     lbarton    10/17/03 - bug fixes from vision db testing
Rem     lbarton    11/21/03 - Bug 3264014: skip PIOT mapping table partitions 
Rem     dgagne     12/02/03 - add view for subpartitioned index stats 
Rem     dgagne     11/19/03 - fix sgc view - don't exclude unanalyzed indexes 
Rem     lbarton    11/07/03 - Bug 3238141: SEGMENT_ATTRIBUTES for constr, etc. 
Rem     lbarton    11/10/03 - lrg1589893: pkref constraints in iots 
Rem     htseng     11/14/03 - fix bug 3114752 - connect to user for db link
Rem     dgagne     11/05/03 - change system generated constraint view 
Rem     dgagne     10/21/03 - connect to owner for index and materialized 
Rem     lbarton    10/02/03 - Bug 3167541: run domain index metadata code as 
Rem                           cur user 
Rem     lbarton    09/22/03 - Bug 3105223: PARTITION_NAME parse item 
Rem     lbarton    09/17/03 - Bug 3130275: domain index fix 
Rem     lbarton    09/16/03 - Bug 3121396: run procobj code as cur user 
Rem     rvissapr   09/10/03 - bug 3095609 - add all_columns 
Rem     htseng     09/15/03 - bug3116063(v9.2):use long2clob to fix 
Rem                           query_text >36K 
Rem     nmanappa   09/03/03 - Adding audit trail option to fga policy 
Rem     dgagne     09/08/03 - add convert parse item for PATCHTABLEMETADATA 
Rem     clei       09/03/03 - Add VPD security relevant column option
Rem     wesmith    08/28/03 - add additional filters, parse items for MV logs
Rem     lbarton    08/15/03 - Bug 3097576: parse item HAS_XMLSCHEMA_COLS 
Rem     dgagne     08/20/03 - return base and anc info for secodnary tables 
Rem     lbarton    08/06/03 - Bug 3056720: use long2clob for view text 
Rem     htseng     08/05/03 - sql compiler switch support 
Rem     lbarton    07/16/03 - Bug 3042522: export procobjs in SYS
Rem     lbarton    06/23/03 - Bug 2994218: REMAP_TABLESPACE remap CREATE TS
Rem     lbarton    07/18/03 - Bug 3045926: PRS_GRANTOR for proc objs
Rem     clei       07/15/03 - synonym policies no longer attached to base obj
Rem     lbarton    07/10/03 - Bug 3045654: VERSION transform param
Rem     htseng     07/24/03 - add logname for object_grants
Rem     lbarton    07/02/03 - Bug 3016951: fetch more type metadata
Rem     emagrath   07/01/03 - Restore IOT/pkOID Pkeys to CONSTRAINT object,
Rem                           filter for heterogeneous types
Rem     lbarton    06/16/03 - Bug 2983400: get nested tables in ku$_tts_view
Rem     dgagne     06/24/03 - add grantor parse item for role grants and
Rem                           system privileges
Rem     htseng     06/11/03 - bug 2999418: large dbtimezone to be varchar2(64)
Rem     gclaborn   06/16/03 - 3000737: Fix grant ordering problem
Rem     emagrath   06/06/03 - Correct index info for constraints
Rem     lbarton    06/02/03 - Bug 2971302: PRIMARY filter for all schema objs
Rem     lbarton    05/27/03 - add MV/MVlogs to transportable_export
Rem     wesmith    05/20/03 - fix MV-related types/views for snap_colmap$ 
Rem                           metadata
Rem     gclaborn   06/04/03 - Add OID transform for INC_TYPE
Rem     lbarton    05/16/03 - bug 2949397: support INDEXTYPE options
Rem     htseng     05/28/03 - bug 2978647: connect to user for JAVA creating
Rem     gclaborn   05/20/03 - Move data_int.choose_unloadpath functionality to
Rem                           ku$_unload_method_view
Rem     emagrath   05/20/03 - Revamp constraint processing
Rem     htseng     05/23/03 - bug 2969613:Cluster table columns order
Rem     htseng     05/21/03 - bug 2967731:Trigger body > 4000
Rem     lbarton    05/07/03 - bug 2944274: bitmap join indexes
Rem     lbarton    05/05/03 - fix PRIMARY/SECONDARY for TRIGGER
Rem     htseng     05/12/03 - change parse LONGNAME to LONG_NAME for JAVA
Rem     dgagne     05/05/03 - add view for transform/object type matching
Rem     gclaborn   05/02/03 - bug 2939384: Add obj_num to property views
Rem     dgagne     05/07/03 - use parent table as base object for table
Rem                           statistics on nested tables
Rem     lbarton    04/15/03 - bug 2848977: skip IOT mapping tables
Rem     lbarton    04/04/03 - bug 2844111: move ku$_source_t to dbmsmetu.sql
Rem     htseng     04/16/03 - bug 2907529:cluster hash is clause
Rem     lbarton    04/01/03 - bug 2875448: 2ndary table fix
Rem     lbarton    03/28/03 - Bug 2833951: add LONGNAME parse item
Rem     lbarton    03/14/03 - bug 2837703: fix table_data bytes_alloc
Rem     htseng     03/25/03 - bug 2862458: Table varopq type column
Rem     dgagne     03/28/03 - change index to soft connect
Rem     gclaborn   04/03/03 - Allow bind vars for certain filters
Rem     lbarton    03/04/03 - bug 2828224: null procact_schema stmts
Rem     lbarton    02/25/03 - bug 2816302 - mask unused col bit in fhtable_view
Rem     lbarton    01/27/03 - add types to transportable_export
Rem     lbarton    01/23/03 - sort types
Rem     dgagne     01/27/03 - add index type parse item for index stats
Rem     htseng     01/29/03 - fix rollback segment optimal value
Rem     lbarton    01/17/03 - remove empty audit_default xml documents
Rem     lbarton    01/07/03 - rework INCLUDE_NULL filter; cache objnum
Rem     clei       01/15/03 - fix ku$_rls_policy_view
Rem     lbarton    01/22/03 - new transform params SQLFILE, CURRENT_SCHEMA
Rem     dgagne     01/20/03 - indicate which objects can be loaded in parallel
Rem     gclaborn   01/15/03 - Change NOEXP filter for synonyms
Rem     dgagne     01/16/03 - Change grantor for tablespace_quota to be system
Rem     gclaborn   01/09/03 - Fix metaview$ entry for system callouts
Rem     lbarton    12/30/02 - add lobmd to pcolumn_t for transportable
Rem     nmanappa   12/27/02 - Adding AUDIT_DEFAULT type
Rem     dgagne     01/02/03 - update materialized view types and views
Rem     lbarton    12/11/02 - get more trigger metadata
Rem     lbarton    11/12/02 - new types for procedural objects
Rem     htseng     12/06/02 - fix bug 2670085- when dimension length >4000
Rem     dgagne     12/17/02 - add Data Pump imp information to metaview$ flags
Rem     clei       11/25/02 - add Index statement type for VPD policies
Rem     lbarton    12/02/02 - fix busted merge
Rem     lbarton    11/26/02 - strmcoltype_view: get hashcode from matching vsn
Rem     lbarton    11/12/02 - more bugfixes
Rem     lbarton    11/11/02 - bugfix
Rem     lbarton    11/05/02 - comment on materialized views
Rem     lbarton    10/29/02 - RECYCLED filter
Rem     dgagne     12/03/02 - fix select for stats for subpartitioned tables
Rem     dgagne     11/21/02 - fix statistics view
Rem     jdavison   11/27/02 - Exclude invalid rollback segs
Rem     gclaborn   11/08/02 - Add parse_attr to metaxslparam$
Rem     masubram   10/06/02 - add knredef1
Rem     dgagne     10/09/02 - remove empty audit_obj xml documents
Rem     lbarton    10/09/02 - add PRS_ROW for DDL
Rem     wfisher    10/06/02 - Add final path to datapump_paths view
Rem     htseng     10/11/02 - fix bug 2616047 - when query length > 4000 
Rem                           in ku$_m_view_t
Rem     lbarton    09/20/02 - add DATAPUMP_PATHMAP view
Rem     rvissapr   10/01/02 - fga changes
Rem     htseng     10/01/02 - fix EXCLUDE_NAME_EXPR for XMLSCHEMA
Rem     tkeefe     09/19/02 - Move proxy_data$ and proxy_role_data$ out of
Rem                           bootstrap region
Rem     lbarton    09/30/02 - more strm metadata
Rem     clei       09/03/02 - add 10i rls policy api extension
Rem     gclaborn   08/23/02 - accomodate CORE`s new file name length of 1025
Rem     dgagne     08/27/02 - fix rls to fetch only bits needed for stmttype
Rem     bmccarth   08/22/02 - XDB: 92->main merge of stripschema
Rem     htseng     08/02/02 - correct variable name
Rem     htseng     08/07/02 - add parse CONSTRAINTS for VIEW 
Rem     lbarton    08/02/02 - transportable export
Rem     lbarton    07/12/02 - clean up schema export
Rem     htseng     07/02/02 - add attriv property to table_data
Rem     htseng     06/25/02 - add post/pre table action support
Rem     lbarton    06/07/02 - implement set_remap_param
Rem     lbarton    06/03/02 - transform params for data layer & network support
Rem     htseng     05/31/02 - add filter package for PROCACT_SYSTEM.
Rem     htseng     05/29/02 - add supplemental log support.
Rem     lbarton    05/17/02 - simplify DPSTREAM_TABLE object
Rem     lbarton    05/09/02 - EXCLUDE_NOEXP filter
Rem     lbarton    05/06/02 - support subviews
Rem     htseng     04/26/02 - add procedural objects and actions API support.
Rem     lbarton    04/25/02 - domain index support
Rem     lbarton    04/17/02 - new parse items
Rem     gclaborn   04/11/02 - Change usage text
Rem     lbarton    04/10/02 - add DPSTREAM_TABLE object
Rem     htseng     04/02/02 - add refresh_group object support.
Rem     lbarton    04/01/02 - add column lists to insert statements
Rem     lbarton    03/21/02 - parse items for BL0
Rem     htseng     03/05/02 - add rmgr object support.
Rem     bmccarth   03/01/02 - add schemaoid to xmlschema
Rem     lbarton    02/14/02 - Fix iot issue
Rem     lbarton    02/06/02 - new 10i infrastructure
Rem     emagrath   01/31/02 - Complete support for REF constraints
Rem     htseng     01/22/02 - add AQ_QUEUE_TABLE support from export.
Rem     lbarton    12/13/01 - filter out empty AUDIT_OBJ docs
Rem     dgagne     12/11/01 - fix security views so only DBA can use
Rem     htseng     12/07/01 - add java object support.
Rem     dgagne     12/06/01 - remove not-null constraints from constraint view
Rem     htseng     11/27/01 - add password_history object support.
Rem     htseng     11/15/01 - add rmgr objects support.
Rem     htseng     11/05/01 - privilege checking.
Rem     htseng     10/22/01 - change AQ. to AQ_
Rem     lbarton    10/25/01 - xdb support
Rem     vmarwah    10/18/01 - LOB retention compatibility changes.
Rem     htseng     10/18/01 - change privilege for ku$_user_view..
Rem     lbarton    10/05/01 - Support Ordered Collections in Tables
Rem     vmarwah    10/08/01 - renaming spare1 and spare2 fields for LOB$.
Rem     lbarton    10/10/01 - Improve performance of mviews and mview logs
Rem     dgagne     10/10/01 - add support for table/index/cluster statistics
Rem     htseng     09/24/01 - fix missing kujob.xsl.
Rem     htseng     09/17/01 - add syn_long_name for java_source.
Rem     htseng     09/04/01 - add more objects support.
Rem     dgagne     09/14/01 - add subpartition template support
Rem     lbarton    09/24/01 - tablespace filter
Rem     dgagne     09/05/01 - add support for range/list composite support
Rem     lbarton    09/05/01 - package reorg
Rem     lbarton    07/11/01 - tweak query on source$ for perf
Rem     dgagne     06/14/01 - add more object support
Rem     lbarton    01/19/01 - add BUILTIN_COL filter
Rem     lbarton    01/12/01 - add comments
Rem     lbarton    01/10/01 - add USER_COL to constraint_col_t
Rem     lbarton    01/08/01 - support 8.1 compatibility
Rem     lbarton    12/01/00 - bugfix
Rem     gclaborn   11/22/00 - Update base dir for stylesheets
Rem     lbarton    11/10/00 - support long views
Rem     lbarton    10/24/00 - sort in views, not in xsl
Rem     lbarton    10/13/00 - bugfixes
Rem     gclaborn   11/03/00 - Change xsl script names to kufoo format
Rem     lbarton    10/05/00 - synonym support
Rem     gclaborn   10/11/00 - perf. enhancements
Rem     svivian    09/14/00 - add support for logical instantiation
Rem     lbarton    09/13/00 - version strings; new transform params
Rem     lbarton    08/18/00 - functions now in dbms_metadata_int
Rem     elu        08/15/00 - add replication xsl scripts for flavors
Rem     lbarton    07/28/00 - datapump: add metastylesheet
Rem     lbarton    06/23/00 - Multinested collections; populate dictionary
Rem     lbarton    06/12/00 - facility name change
Rem     rmurthy    06/20/00 - change objauth.option column to hold flag bits
Rem     gclaborn   05/04/00 - Update operators/indextypes to use multinesting
Rem     lbarton    05/18/00 - bugfix: piotable_view
Rem     gclaborn   04/24/00 - Update outline metadata to new 8.2 format
Rem     gclaborn   04/06/00 - Add outline support
Rem     lbarton    03/30/00 - Changes for partitioning
Rem     lbarton    03/17/00 - multinested collections
Rem     lbarton    03/01/00 - new table views, etc.
Rem     gclaborn   12/29/99 - Remove ref. to dbms_metadata_int
Rem     lbarton    12/03/99 - domain index support
Rem     gclaborn   11/24/99 - Add trigger support
Rem     akalra/lbarton/gclaborn
Rem                11/17/99 -  created


-------------------------------------------------------------------------------
--                              SCHEMA OBJECTS
-------------------------------------------------------------------------------

-- ADT for schema objects.  Based on obj$
create or replace type ku$_schemaobj_t as object
(
  obj_num       number,                                     /* object number */
  dataobj_num   number,                          /* data layer object number */
  owner_num     number,                                 /* owner user number */
  owner_name    varchar2(30),                                  /* owner name */
  name          varchar2(30),                                 /* object name */
  namespace     number,                               /* namespace of object */
  subname       varchar2(30),                     /* subordinate to the name */
  type_num      number,                                       /* object type */
  type_name     varchar2(30),                            /* object type name */
  ctime         varchar2(19),                        /* object creation time */
  mtime         varchar2(19),                       /* DDL modification time */
  stime         varchar2(19),           /* specification timestamp (version) */
  status        number,                                  /* status of object */
  remoteowner   varchar2(30),           /* remote owner name (remote object) */
  linkname      varchar2(128),                  /* link name (remote object) */
  flags         number,                                             /* flags */
  oid           raw(16),        /* OID for typed table, typed view, and type */
  spare1        number,                 
  spare2        number,
  spare3        number,                              /* 11.2 original owner# */
  spare4        varchar2(1000),
  spare5        varchar2(1000),
  spare6        varchar2(19),
  owner_name2   varchar2(30)                     /* 11.2 original owner_name */
)
/

grant execute on ku$_schemaobj_t to public
/

-- view for schema objects
create or replace force view ku$_schemaobj_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select o.obj#, o.dataobj#, o.owner#, u.name, o.name, o.namespace, o.subname,
         o.type#,
         -- translate type# to name: type# values are defined in kgl.h
         decode(o.type#,
                 0, 'CURSOR',                    1, 'INDEX',
                 2, 'TABLE',                     3, 'CLUSTER',
                 4, 'VIEW',                      5, 'SYNONYM',
                 6, 'SEQUENCE',                  7, 'PROCEDURE',
                 8, 'FUNCTION',                  9, 'PACKAGE',
                11, 'PACKAGE_BODY',             12, 'TRIGGER',
                13, 'TYPE',                     14, 'TYPE_BODY',
                15, 'OBJECT',                   16, 'USER',
                17, 'LINK',                     18, 'PIPE',
                19, 'TABLE PARTITION',          20, 'INDEX PARTITION',
                21, 'LOB',                      22, 'LIBRARY',
                23, 'DIRECTORY',                24, 'QUEUE',
                25, 'IOT',                      26, 'REPLICATION OBJECT GROUP',
                27, 'REPLICATION PROPAGATOR',   28, 'JAVA_SOURCE',
                29, 'JAVA_CLASS',               30, 'JAVA_RESOURCE',
                31, 'JAVA JAR',                 32, 'INDEXTYPE',
                33, 'OPERATOR',                 34, 'TABLE SUBPARTITION',
                35, 'INDEX SUBPARTITION',       36, 'SERVER-SIDE REPAPI',
                37, 'REPLICATION INTERNAL PACKAGE',
                38, 'CONTEXT POLICY OBJECT',
                39, 'PUB_SUB INTERNAL INFORMATION',
                40, 'LOB PARTITION',            41, 'LOB SUBPARTITION',
                42, 'SUMMARY',                  43, 'DIMENSION',
                44, 'CONTEXT',                  45, 'OUTLINE',
                46, 'RULESET OBJECT',           47, 'SCHEDULER PLAN',
                48, 'SCHEDULER CLASS',          49, 'PENDING SCHEDULER PLAN',
                50, 'PENDING SCHEDULER CLASS',  51, 'SUBSCRIPTION INFORMATION',
                52, 'LOCATION INFORMATION',     53, 'REMOTE OBJECTS INFO',
                54, 'REPAPI SNAPSHOT METADATA', 55, 'IFS DATA',
                56, 'JAVA SHARED DATA',         57, 'SECURITY PROFILE',
                58, 'TRANSFORMATION',           59, 'RULE',
                60, 'CAPTURE PROCESS',          61, 'APPLY PROCESS',
                62, 'RULE EVALUATION CONTEXT',  63, 'LOG-BASED REPL SOURCE',
                64, 'STREAM DDL',               65, 'KGL TEST',
                66, 'SCHEDULER JOB',            67, 'SCHEDULER PROGRAM',
                68, 'SCHEDULER CLASS',          69, 'SCHEDULER WINDOW',
                70, 'MULTI-VERSIONED OBJECT',   71, 'SCHEDULER JOB SLAVE',
                72, 'SCHEDULER WINDOW GROUP',   73, 'CDC CHANGE SET',
                74, 'SCHEDULER SCHEDULE',       'ERROR'),
         to_char(o.ctime,'YYYY-MM-DD HH24:MI:SS'),
         to_char(o.mtime,'YYYY-MM-DD HH24:MI:SS'),
         to_char(o.stime,'YYYY-MM-DD HH24:MI:SS'),
         o.status, o.remoteowner,
         o.linkname, o.flags, o.oid$, 
         o.spare1, o.spare2, o.spare3,
         o.spare4, o.spare5, to_char(o.spare6,'YYYY/MM/DD HH24:MI:SS'),
         case when (o.spare3 > 0) then
             (select u.name from user$ u where o.spare3 = u.user#)
         else null
         end
  from obj$ o, user$ u
  where o.owner# = u.user#;

grant select on ku$_schemaobj_view to select_catalog_role
/
-- view for schema objects, filtered by object numbers
create or replace force view ku$_schemaobjnum_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select *
  from ku$_schemaobj_view ku$
  where ku$.obj_num in (select * from table(dbms_metadata.fetch_objnums));

grant select on ku$_schemaobjnum_view to select_catalog_role
/
--
-- FAMILY "EDITION OBJ" - Objects annotated with edition information.
-- These views are based on "_CURRENT_EDITION_OBJ" in cdcore.sql, and
-- are intended for internal use only. The difference from cdcore is
-- that the edition name may be taken from a filter, rather than session
-- context.
--
-- ku$_edition_obj_view - used in place of obj$, when edition semantics
--  are required.
--
-- ku$_edition_schemaobj_view - used in place of ku$_schemaobj, when edition
--  semantics are required.
--
-- In both views, the owner# in is the base user# (not the adjunct schema).
--
-- In modifying our references to OBJ$, we will consider the following
-- substitutions:
--    sys.ku$_edition_obj_view for obj$
--    sys.ku$_edition_schemaobj_view for ku$_schemaobj_view

create or replace view ku$_edition_obj_view
 (    obj#,
      dataobj#,
      defining_owner#,
      name,
      namespace,
      subname,
      type#,
      ctime,
      mtime,
      stime,
      status,
      remoteowner,
      linkname,
      flags,
      oid$,
      spare1,
      spare2,
      spare3,
      spare4,
      spare5,
      spare6,
      owner#,
      defining_edition
 )
as
select o.*,
       o.spare3, 
       case when (o.type# not in (4,5,7,8,9,10,11,12,13,14,22,87) or
                  bitand(u.spare1, 16) = 0) then
         null
       when (u.type# = 2) then
        (select eo.name from obj$ eo where eo.obj# = u.spare2)
       else
        'ORA$BASE'
       end
from obj$ o, user$ u
where o.owner# = u.user#
  and (   /* non-versionable object */
          (   o.type# not in (4,5,7,8,9,10,11,12,13,14,22,87,88)
           or bitand(u.spare1, 16) = 0)
          /* versionable object visible in designated edition */
       or (    o.type# in (4,5,7,8,9,10,11,12,13,14,22,87)
           and (   (u.type# <> 2 and 
                    (select distinct sys.dbms_metadata.get_edition from dual) 
                        = 'ORA$BASE')
                or (u.type# = 2 and
                    u.spare2 = 
                        (select distinct sys.dbms_metadata.get_edition_id from dual))
                or exists (select 1 from obj$ o2, user$ u2
                           where o2.type# = 88
                             and o2.dataobj# = o.obj#
                             and o2.owner# = u2.user#
                             and u2.type#  = 2
                             and u2.spare2 = 
                        (select distinct sys.dbms_metadata.get_edition_id from dual))
               )
          )
      )
/

-- view for schema objects
create or replace force view ku$_edition_schemaobj_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select o.obj#, o.dataobj#, o.owner#, u.name, o.name, o.namespace, o.subname,
         o.type#,
         -- translate type# to name: type# values are defined in kgl.h
         decode(o.type#,
                 0, 'CURSOR',                    1, 'INDEX',
                 2, 'TABLE',                     3, 'CLUSTER',
                 4, 'VIEW',                      5, 'SYNONYM',
                 6, 'SEQUENCE',                  7, 'PROCEDURE',
                 8, 'FUNCTION',                  9, 'PACKAGE',
                11, 'PACKAGE_BODY',             12, 'TRIGGER',
                13, 'TYPE',                     14, 'TYPE_BODY',
                15, 'OBJECT',                   16, 'USER',
                17, 'LINK',                     18, 'PIPE',
                19, 'TABLE PARTITION',          20, 'INDEX PARTITION',
                21, 'LOB',                      22, 'LIBRARY',
                23, 'DIRECTORY',                24, 'QUEUE',
                25, 'IOT',                      26, 'REPLICATION OBJECT GROUP',
                27, 'REPLICATION PROPAGATOR',   28, 'JAVA_SOURCE',
                29, 'JAVA_CLASS',               30, 'JAVA_RESOURCE',
                31, 'JAVA JAR',                 32, 'INDEXTYPE',
                33, 'OPERATOR',                 34, 'TABLE SUBPARTITION',
                35, 'INDEX SUBPARTITION',       36, 'SERVER-SIDE REPAPI',
                37, 'REPLICATION INTERNAL PACKAGE',
                38, 'CONTEXT POLICY OBJECT',
                39, 'PUB_SUB INTERNAL INFORMATION',
                40, 'LOB PARTITION',            41, 'LOB SUBPARTITION',
                42, 'SUMMARY',                  43, 'DIMENSION',
                44, 'CONTEXT',                  45, 'OUTLINE',
                46, 'RULESET OBJECT',           47, 'SCHEDULER PLAN',
                48, 'SCHEDULER CLASS',          49, 'PENDING SCHEDULER PLAN',
                50, 'PENDING SCHEDULER CLASS',  51, 'SUBSCRIPTION INFORMATION',
                52, 'LOCATION INFORMATION',     53, 'REMOTE OBJECTS INFO',
                54, 'REPAPI SNAPSHOT METADATA', 55, 'IFS DATA',
                56, 'JAVA SHARED DATA',         57, 'SECURITY PROFILE',
                58, 'TRANSFORMATION',           59, 'RULE',
                60, 'CAPTURE PROCESS',          61, 'APPLY PROCESS',
                62, 'RULE EVALUATION CONTEXT',  63, 'LOG-BASED REPL SOURCE',
                64, 'STREAM DDL',               65, 'KGL TEST',
                66, 'SCHEDULER JOB',            67, 'SCHEDULER PROGRAM',
                68, 'SCHEDULER CLASS',          69, 'SCHEDULER WINDOW',
                70, 'MULTI-VERSIONED OBJECT',   71, 'SCHEDULER JOB SLAVE',
                72, 'SCHEDULER WINDOW GROUP',   73, 'CDC CHANGE SET',
                74, 'SCHEDULER SCHEDULE',       'ERROR'),
         to_char(o.ctime,'YYYY-MM-DD HH24:MI:SS'),
         to_char(o.mtime,'YYYY-MM-DD HH24:MI:SS'),
         to_char(o.stime,'YYYY-MM-DD HH24:MI:SS'),
         o.status, o.remoteowner,
         o.linkname, o.flags, o.oid$, 
         o.spare1, o.spare2, o.spare3,
         o.spare4, o.spare5, to_char(o.spare6,'YYYY/MM/DD HH24:MI:SS'),
         case when (o.spare3 > 0) then
             (select u.name from user$ u where o.spare3 = u.user#)
         else null
         end
  from sys.ku$_edition_obj_view o, user$ u
  where o.owner# = u.user#;

grant select on ku$_edition_schemaobj_view to select_catalog_role;
grant select on ku$_edition_obj_view to select_catalog_role;
/

-------------------------------------------------------------------------------
--                              STORAGE
-------------------------------------------------------------------------------

-- ADT for storage characteristics
create or replace type ku$_storage_t as object
(
  file_num      number,                        /* segment header file number */
  block_num     number,                       /* segment header block number */
  type_num      number,                                      /* segment type */
  ts_num        number,                       /* tablespace for this segment */
  blocks        number,                /* blocks allocated to segment so far */
                                           /* zero for bitmapped tablespaces */
  extents       number,               /* extents allocated to segment so far */
  iniexts       number,                               /* initial extent size */
  minexts       number,                         /* minimum number of extents */
  maxexts       number,                         /* maximum number of extents */
  extsize       number,                          /* current next extent size */
                                           /* zero for bitmapped tablespaces */
  extpct        number,                             /* percent size increase */
  user_num      number,                        /* user who owns this segment */
  lists         number,                        /* freelists for this segment */
  groups        number,                  /* freelist groups for this segment */
  bitmapranges  number,                          /* ranges per bit map entry */
  cachehint     number,                                 /* hints for caching */
  scanhint      number,                                /* hints for scanning */
  hwmincr       number,                      /* Amount by which HWM is moved */
  flags         number,                                     /* Segment flags */
  /* These flags are defined in ktscts.h. Significant flags are        */
                   /* #define KTSSEGM_FLAG_COMPRESSED 0x0800    (2048) */
                   /* #define KTSSEGM_FLAG_OLTP  0x1000000  (16777216) */
                   /* #define KTSSEGM_FLAG_ARCH1 0x2000000  (33554432) */
                   /* #define KTSSEGM_FLAG_ARCH2 0x4000000  (67108864) */
                   /* #define KTSSEGM_FLAG_ARCH3 0x8000000 (134217728) */
  spare2        number
)
/

grant execute on ku$_storage_t to public
/

-- view for storage ADT
create or replace force view ku$_storage_view of ku$_storage_t 
  with object identifier (file_num, block_num, ts_num) as
  select s.file#, s.block#, s.type#, s.ts#, s.blocks, s.extents,
         s.iniexts, s.minexts, s.maxexts, s.extsize, s.extpct,
         s.user#,
-- SecureFiles use groups and lists for storing other information related
-- to RETENTION.  When we have a SecureFile column, the groups and
-- lists parameters need to be passed back as is.  However, if we
-- are attempting to import into a 10g compatible or earlier RDBMS via
-- DBLinks, then we need to interpret 0 as 1 for SecureFile because
-- the SecureFile will be created as a BasicFile, and in this case, the
-- groups and lists setting needs to be consistent with the BasicFile
-- behavior.  dbms_metadata.get_version tells us what version the
-- client in the DBLink is using as its compatible setting.
-- We can tell that the LOB segment is a SecureFile segment by looking
-- at seg$.spare1 bit 0x200000 (2097152 in decimal).
         case when dbms_metadata.get_version >= '11.00.00.00.00' then 
                decode(bitand(s.spare1, 2097152), 2097152, s.lists,
                       (decode(s.lists, 0, 1, s.lists)))
              else
                decode(s.lists, 0, 1, s.lists)
         end,
         case when dbms_metadata.get_version >= '11.00.00.00.00' then 
                decode(bitand(s.spare1, 2097152), 2097152, s.groups,
                       (decode(s.groups, 0, 1, s.groups)))
              else
                decode(s.groups, 0, 1, s.groups)
         end,
         decode(bitand(s.spare1, 4194304), 4194304, s.bitmapranges, NULL),
         case when dbms_metadata.get_version >= '11.02.00.00.00' then
                   s.cachehint
              else
                   decode(mod(s.cachehint,4),
                          1, 1,
                          2, 2,
                          0)
         end, 
         s.scanhint, s.hwmincr, 
         -- Convert 'flags' to a value that the pre-11.2 xsl stylesheet
         -- can process: if archive compressed and version < 11.2,
         -- turn off compression.  The block format for archive compression
         -- is not supported pre-11.2, so the compression bits must be
         -- set to NOCOMPRESS.
         case when bitand(s.spare1,33554432+67108864+134217728)=0 then s.spare1
              when dbms_metadata.get_version >= '11.02.00.00.00' then s.spare1
              else s.spare1 - bitand(s.spare1,2048+33554432+67108864+134217728)
         end,
         s.spare2
  from seg$ s
/
grant select on ku$_storage_view to select_catalog_role
/

-- UDT for deferred storage characteristics
-- (from dcore.bsq)
create or replace type ku$_deferred_stg_t as object
(
  obj_num       number,                            /* object number */
  pctfree_stg   number,                                  /* PCTFREE */
  pctused_stg   number,                                  /* PCTUSED */
  size_stg      number,                                     /* SIZE */   
  initial_stg   number,                                  /* INITIAL */
  next_stg      number,                                     /* NEXT */
  minext_stg    number,                               /* MINEXTENTS */
  maxext_stg    number,                               /* MAXEXTENTS */
  maxsiz_stg    number,                                  /* MAXSIZE */
  lobret_stg    number,                             /* LOBRETENTION */
  mintim_stg    number,                                  /* MIN tim */
  pctinc_stg    number,                              /* PCTINCREASE */
  initra_stg    number,                                 /* INITRANS */
  maxtra_stg    number,                                 /* MAXTRANS */
  optimal_stg   number,                                  /* OPTIMAL */
  maxins_stg    number,                             /* MAXINSTANCES */
  frlins_stg    number,                           /* LISTS/instance */
  flags_stg     number,                                    /* flags */
  bfp_stg       number,                              /* BUFFER_POOL */
  enc_stg       number,                               /* encryption */
  cmpflag_stg   number,                         /* compression type */
  cmplvl_stg    number                         /* compression level */
)
/

grant execute on ku$_deferred_stg_t to public
/

-- view for deferred storage UDT
create or replace force view ku$_deferred_stg_view 
  of ku$_deferred_stg_t 
  with object identifier (obj_num) as select
  obj#          ,                            /* object number */
  pctfree_stg   ,                                  /* PCTFREE */
  pctused_stg   ,                                  /* PCTUSED */
  size_stg      ,                                     /* SIZE */   
  initial_stg   ,                                  /* INITIAL */
  next_stg      ,                                     /* NEXT */
  minext_stg    ,                               /* MINEXTENTS */
  maxext_stg    ,                               /* MAXEXTENTS */
  maxsiz_stg    ,                                  /* MAXSIZE */
  lobret_stg    ,                             /* LOBRETENTION */
  mintim_stg    ,                                  /* MIN tim */
  pctinc_stg    ,                              /* PCTINCREASE */
  initra_stg    ,                                 /* INITRANS */
  maxtra_stg    ,                                 /* MAXTRANS */
  optimal_stg   ,                                  /* OPTIMAL */
  decode(maxins_stg,0,1,maxins_stg) ,      /* FREELIST GROUPS */
  decode(frlins_stg,0,1,frlins_stg) ,            /* FREELISTS */
  flags_stg     ,                                    /* flags */
  bfp_stg       ,                              /* BUFFER_POOL */
  enc_stg       ,                               /* encryption */
  cmpflag_stg   ,                         /* compression type */
  cmplvl_stg                             /* compression level */
 from sys.deferred_stg$
/
grant select on ku$_deferred_stg_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              FILESPEC
-------------------------------------------------------------------------------

-- ADT for filespec

create or replace type ku$_file_t as object
(
  name          varchar2(923),   /* raw fname:limited to 923 bytes (max OID) */
  fname         varchar2(2050),  /* fixed filename with sgl. ' escaped as '' */
  fsize         number,                            /* size of file in blocks */
  resize        number,                          /* resize of file in blocks */
  maxextend     number,                                 /* maximum file size */
  inc           number,                                 /* increment ammount */
  ts_num        number,                                 /* tablespace number */
  is_omf        number                   /* 1 if file is an OMF, 0 otherwise */
)
/
grant execute on ku$_file_t to public
/

-- NOTE!! NOTE!! NOTE!!
--
-- Per bug-8467825 it is not recommended to use v$datafile view
-- if you need just name of datafile, then query x$kccfn and
-- if you need datafile information, then query x$kccfe and x$kcvfh.

create or replace force view ku$_file_view of ku$_file_t
       with object identifier (name) as
-- obj. IDs are currently limited to 923 chars. CORE increased SLMXFNMLEN to
-- 1025 around 8/21/02. OID is right-most 923 of 1025 bytes.
        select  substrb(fn.fnnam, -(least(lengthb(fn.fnnam),923)), 923),
                replace(fn.fnnam, '''', ''''''),
                f.blocks, fh.fhfsz, f.maxextend, f.inc, f.ts#,
                sys.dbms_metadata_util.is_omf(
                  substrb(fn.fnnam, -(least(lengthb(fn.fnnam),923)), 923))
        from    sys.x$kccfn fn, sys.file$ f, x$kcvfh fh
        where   f.file# = fn.fnfno AND
                fn.fnfno = fh.hxfil AND
                fn.fntyp = 4 AND
                f.spare1 is NULL
      union all
        select  substrb(fn.fnnam, -(least(lengthb(fn.fnnam),923)), 923),
                replace (fn.fnnam, '''', ''''''),
                f.blocks,
                DECODE(hc.ktfbhccval, 0, hc.ktfbhcsz, NULL),
                DECODE(hc.ktfbhccval, 0, hc.ktfbhcmaxsz, NULL),
                DECODE(hc.ktfbhccval, 0, hc.ktfbhcinc, NULL),
                ts.ts#,
                sys.dbms_metadata_util.is_omf(
                  substrb(fn.fnnam, -(least(lengthb(fn.fnnam),923)), 923))
        FROM    sys.x$kccfn fn, sys.file$ f, sys.x$ktfbhc hc, sys.ts$ ts
        WHERE   fn.fnfno = f.file# AND
                f.spare1 is NOT NULL AND
                fn.fnfno = hc.ktfbhcafno AND
                hc.ktfbhctsn = ts.ts#
      union all
        select                                       /*+ ordered use_nl(hc) +*/
                substrb(fn.fnnam, -(least(lengthb(fn.fnnam),923)), 923),
                replace (fn.fnnam, '''', ''''''),
                DECODE(hc.ktfthccval, 0, hc.ktfthcsz, -1),
                DECODE(hc.ktfthccval, 0, hc.ktfthcsz, -1),
                DECODE(hc.ktfthccval, 0, hc.ktfthcmaxsz, NULL),
                DECODE(hc.ktfthccval, 0, hc.ktfthcinc, NULL),
                ts.ts#,
                sys.dbms_metadata_util.is_omf(
                  substrb(fn.fnnam, -(least(lengthb(fn.fnnam),923)), 923))
        FROM    sys.x$kccfn fn, sys.x$ktfthc hc, sys.ts$ ts
        WHERE   fn.fntyp = 7 AND
                fn.fnnam IS NOT NULL AND
                fn.fnfno = hc.ktfthctfno AND
                hc.ktfthctsn(+) = ts.ts#
/
grant select on ku$_file_view to select_catalog_role
/

create or replace type ku$_file_list_t
  as table of ku$_file_t
/
grant execute on ku$_file_list_t to public
/

-------------------------------------------------------------------------------
--                              TABLESPACE
-------------------------------------------------------------------------------

-- ADT for tablespaces
create or replace type ku$_tablespace_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  ts_num        number,                      /* tablespace identifier number */
  name          varchar2(30),                          /* name of tablespace */
  owner_num     number,                               /* owner of tablespace */
  status        number,                                            /* status */
                      /* 1 = ONLINE, 2 = OFFLINE, 3 = INVALID, 4 = READ ONLY */
  contents      number,                      /* TEMPORARY = 1 / PERMANENT = 0*/
  undofile_num  number,  /* undo_off segment file number (status is OFFLINE) */
  undoblock_num number,               /* undo_off segment header file number */
  blocksize     number,                            /* size of block in bytes */
  inc_num       number,                      /* incarnation number of extent */
  scnwrp        number,     /* clean offline scn - zero if not offline clean */
  scnbas        number,              /* scnbas - scn base, scnwrp - scn wrap */
  dflminext     number,                 /* default minimum number of extents */
  dflmaxext     number,                 /* default maximum number of extents */
  dflinit       number,                       /* default initial extent size */
  dflincr       number,                          /* default next extent size */
  dflminlen     number,                       /* default minimum extent size */
  dflextpct     number,              /* default percent extent size increase */
  dflogging     number,                         /* default logging attribute */
  affstrength   number,                                 /* Affinity strength */
  bitmapped     number,      /* If not bitmapped, 0 else unit size in blocks */
  plugged       number,                                        /* If plugged */
  directallowed number,    /* Operation which invalidate standby are allowed */
  flags         number,                                     /* various flags */
                                     /* 0x01 = system managed allocation     */
                                     /* 0x02 = uniform allocation            */
                                /* if above 2 bits not set then user managed */
                                     /* 0x04 = migrated tablespace           */
                                     /* 0x08 = tablespace being migrated     */
                                     /* 0x10 = undo tablespace               */
                                     /* 0x20 = auto segment space management */
                       /* if above bit not set then freelist segment managed */
                                     /* 0x40 (64) = COMPRESS                 */
                                     /* 0x80 = ROW MOVEMENT                  */
                                     /* 0x100 = SFT                          */
                                     /* 0x200 = undo retention guarantee     */
                                    /* 0x400 = tablespace belongs to a group */
                                  /* 0x800 = this actually describes a group */
                                   /* 0x1000 = tablespace has MAXSIZE set */
                                   /* 0x2000 = enc property initialized */
                                   /* 0x4000 = encrypted tablespace */
            /* 0x8000 = has its own key and not using the default DB enc key */
                                  /* 0x10000 = OLTP Compression */
                                  /* 0x20000 (131072) = ARCH1_COMPRESSION */
                                  /* 0x40000 (262144) = ARCH2_COMPRESSION */
                                  /* 0x80000 (524288) = ARCH3_COMPRESSION */
  pitrscnwrp    number,                      /* scn wrap when ts was created */
  pitrscnbas    number,                      /* scn base when ts was created */
  ownerinstance varchar(30),                          /* Owner instance name */
  backupowner   varchar(30),                   /* Backup owner instance name */
  groupname     varchar(30),                                   /* Group name */
  spare1        number,                                  /* plug-in SCN wrap */
  spare2        number,                                  /* plug-in SCN base */
  spare3        varchar2(1000),
  spare4        varchar2(19),
  filespec      ku$_file_list_t
)
/

grant execute on ku$_tablespace_t to public
/

-- view for tablespaces
create or replace force view ku$_tablespace_view of ku$_tablespace_t
  with object identifier (ts_num) as
  select '1', '0',
          t.ts#, t.name,  t.owner#, t.online$, t.contents$, t.undofile#, 
          t.undoblock#, t.blocksize, t.inc#, t.scnwrp, t.scnbas, t.dflminext,
          t.dflmaxext, t.dflinit, t.dflincr, t.dflminlen, t.dflextpct, 
          t.dflogging, t.affstrength, t.bitmapped, t.plugged, t.directallowed,
          -- Convert 'flags' to a value that the pre-11.2 xsl stylesheet
          -- can process: if archive compressed and version < 11.2,
          -- turn off compression.  The block format for archive compression
          -- is not supported pre-11.2, so the compression bits must be
          -- set to NOCOMPRESS.
          case when bitand (t.flags,131072+262144+524288) = 0 then t.flags
               when dbms_metadata.get_version >= '11.02.00.00.00' then t.flags
               else t.flags - bitand(t.flags,64+131072+262144+524288)
          end,
          t.pitrscnwrp, t.pitrscnbas, t.ownerinstance, t.backupowner,
          case bitand(t.flags,1024)
            when 1024 then
              (select t2.name 
               from ts$ t2 
               where t.dflmaxext  = t2.ts#)
            else NULL end,
          t.spare1, t.spare2, t.spare3, to_char(t.spare4,'YYYY/MM/DD HH24:MI:SS'),
          cast(multiset(select value(f) from ku$_file_view f
                       where f.ts_num = t.ts#
                      ) as ku$_file_list_t
             )
 from ts$ t
 where  t.online$  IN (1, 2, 4)
 and    bitand(t.flags,2048) = 0
 and    (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_tablespace_view to public
/

--
-------------------------------------------------------------------------------
--                      SQL COMPILER SWITCHES 
-------------------------------------------------------------------------------
--
create or replace type ku$_switch_compiler_t as object
(
  obj_num       number,                                     /* object number */
  optlevel      VARCHAR2(4000), 
  codetype      VARCHAR2(4000),
  debug         VARCHAR2(4000),
  ccflags       VARCHAR2(4000),
  plscope       VARCHAR2(4000)
)
/
grant execute on ku$_switch_compiler_t to public
/

create or replace force view ku$_switch_compiler_view of ku$_switch_compiler_t
  with object identifier (obj_num) as
  select /*+ no_merge */
         b.obj#, b.value, c.value, d.value, e.value, f.value
         FROM    sys.settings$ b, sys.settings$ c,  sys.settings$ d, 
                 sys.settings$ e, sys.settings$ f,  sys.ku$_schemaobj_view o
         WHERE   o.obj_num  = b.obj# AND
                b.obj#  = c.obj# AND
                c.obj#  = d.obj# AND
                d.obj#  = e.obj# AND
                e.obj#  = f.obj# AND
                b.param = 'plsql_optimize_level'         AND
                c.param = 'plsql_code_type'              AND
                d.param = 'plsql_debug'                  AND
                e.param = 'plsql_ccflags'                AND
                f.param = 'plscope_settings'             AND
                (UID IN (o.owner_num, 0) OR
                 EXISTS (
                    SELECT  role
                    FROM    sys.session_roles
                    WHERE   role = 'SELECT_CATALOG_ROLE')) 
/
grant select on ku$_switch_compiler_view to public
/

-------------------------------------------------------------------------------
--                              TYPE
-------------------------------------------------------------------------------
-- 
-- from type$ (dobj.bsq)
create or replace type ku$_simple_type_t as object
(
  toid          raw(16),                                             /* toid */
  version_num   number,                                /* internal version # */
  version       varchar2(30),                         /* UDT minor version # */
  type_num      number,                      /* type encoding (see sqldef.h) */
  properties    number,                                   /* type properties */
  attribute_num number,                              /* number of attributes */
  local_attrs   number,                        /* number of local attributes */
  method_num    number,                                 /* number of methods */
  hidmethod_num number,                         /* number of hiddend methods */
  typeid        raw(16), /* short typeid value (for non final and sub types) */
  roottoid      raw(16),          /* TOID of root type (null if not subtype) */
  hashcode      raw(17),                                 /* Version hashcode */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  type_name     varchar2(30)                                    /* type name */
)
/
grant execute on ku$_simple_type_t to public
/
create or replace force view ku$_simple_type_view of ku$_simple_type_t
  with object identifier (toid) as
  select
   toid,          
   version#,   
   version,       
   typecode,      
   properties,    
   attributes,
   local_attrs, 
   methods,    
   hiddenMethods, 
   typeid,       
   roottoid,      
   hashcode,
  (select value(so) from ku$_edition_schemaobj_view so
    where so.oid = toid and so.type_num = 13),
  (select name from obj$ o where o.oid$ = toid and o.type#=13)
  from type$ t
/
grant select on ku$_simple_type_view to public
/
-- from collection$ (dobj.bsq)
create or replace type ku$_collection_t as object
(
  toid          raw(16),                                             /* TOID */
  version       number,                      /* internal type version number */
  coll_toid     raw(16),            /* collection TOID (TABLE, VARRAY, etc.) */
  coll_version  number,         /* collection type's internal version number */
  elem_toid     raw(16),                                   /* element's TOID */
  elem_version  number,          /* element's type's internal version number */
  synobj        number,                              /* obj# of type synonym */
  properties    number,                             /* element's properties: */
  /* 0x4000 =   16384 = is a PONTER element */
  /* 0x8000 =   32768 = is a REF element */
  /* 0x10000 =  65536  = no NULL is stored with each element */
  /* 0x20000 =  131072 = number/float elements stored in min. fixed size */
  /* 0x40000 =  262144 = number/float elements stored in varying size    */
  charsetid     number,                                  /* character set id */
  charsetform   number,                                /* character set form */
  /* 1 = implicit: for CHAR, VARCHAR2, CLOB w/o a specified set */
  /* 2 = nchar: for NCHAR, NCHAR VARYING, NCLOB */
  /* 3 = explicit: for CHAR, etc. with "CHARACTER SET ..." clause */
  /* 4 = flexible: for PL/SQL "flexible" parameters */
  length        number,                  /* fixed character string length or */
                                  /* maximum varying character string length */
  precision     number,       /* fixed- or floating-point numeric precision */
  scale         number,                         /* fixed-point numeric scale */
  upper_bound   number,     /* fixed array size or varying array upper bound */
  spare1        number,                      /* fractional seconds precision */
  spare2        number,                  /* interval leading field precision */
  spare3        number,
  coll_type     ku$_simple_type_t,           /* type info for the collection */
  typemd        ku$_simple_type_t        /* type info for collection element */
)
/
grant execute on ku$_collection_t to public
/
create or replace force view ku$_collection_view of ku$_collection_t
  with object identifier (toid) as
  select
  toid,                                                              /* TOID */
  version#,                                  /* internal type version number */
  coll_toid,                        /* collection TOID (TABLE, VARRAY, etc.) */
  coll_version#,                /* collection type's internal version number */
  elem_toid,                                               /* element's TOID */
  elem_version#,                 /* element's type's internal version number */
  synobj#,                                           /* obj# of type synonym */
  properties,                                       /* element's properties: */
  charsetid,                                             /* character set id */
  charsetform,                                         /* character set form */
  length,                                /* fixed character string length or */
                                  /* maximum varying character string length */
  precision,                  /* fixed- or floating-point numeric precision */
  scale,                                        /* fixed-point numeric scale */
  upper_bound,              /* fixed array size or varying array upper bound */
  spare1,                                    /* fractional seconds precision */
  spare2,                                /* interval leading field precision */
  spare3,
  (select value(st) from ku$_simple_type_View st
                where st.toid = c.coll_toid and 
                      st.version = (SELECT MAX(ST2.VERSION) FROM ku$_simple_type_View st2
                                    WHERE ST2.TOID = c.coll_toid)),
  (select value(st) from ku$_simple_type_View st
                where st.toid = c.elem_toid and
                      st.version = (SELECT MAX(ST2.VERSION) FROM ku$_simple_type_View st2
                                    WHERE ST2.TOID = c.elem_toid))
  FROM sys.collection$ c
/
grant select on ku$_collection_view to public
/
-- type info for Method arguments
--    from argument$ (dplsql.bsq)
create or replace type ku$_argument_t as object
(
  obj_num        number,                                    /* object number */
  procedure_val  varchar2(30),       /* procedure name (if within a package) */
  overload_num   number,         
                /* 0 - not overloaded, n - unique id of overloaded procedure */
  procedure_num  number,                       /* procedure or method number */
  position_num   number,           /* argument position (0 for return value) */
  sequence_num   number,         
  level_num      number,         
  argument       varchar2(30),      /* argument name (null for return value) */
  type_num       number,                                    /* argument type */
  charsetid      number,                                 /* character set id */
  charsetform    number,                               /* character set form */
  /* 1 = implicit: for CHAR, VARCHAR2, CLOB w/o a specified set */
  /* 2 = nchar: for NCHAR, NCHAR VARYING, NCLOB */
  /* 3 = explicit: for CHAR, etc. with "CHARACTER SET ..." clause */
  /* 4 = flexible: for PL/SQL "flexible" parameters */
  default_num    number,   /* null - no default value, 1 - has default value */
  in_out         number,                   /* null - IN, 1 - OUT, 2 - IN/OUT */
  properties     number,                           /* argument's properties: */
  /* 0x0100 =     256 = IN parameter (pass by value, default) */
  /* 0x0200 =     512 = OUT parameter */
  /* 0x0400 =    1024 = pass by reference parameter */
  /* 0x0800 =    2048 = required parameter (no default) */
  /* 0x4000 =   16384 = is a PONTER parameter */
  /* 0x8000 =   32768 = is a REF parameter */
  length         number,                                      /* data length */
  precision_num  number,                                /* numeric precision */
  scale          number,                                    /* numeric scale */
  radix          number,                                    /* numeric radix */
  deflength      number,             /* default value expression text length */
  default_val    varchar2(4000),            /* default value expression text */
--  default$       long,                      /* default value expression text */
  type_owner     varchar2(30),          /* owner name component of type name */
  type_name      varchar2(30),                                  /* type name */
  type_subname   varchar2(30),             /* subname component of type name */
  type_linkname  varchar2(30),             /* db link component of type name */
  pls_type       varchar2(30)                            /* pl/sql type name */
)
/
grant execute on ku$_argument_t to public
/
create or replace type ku$_argument_list_t
   as table of ku$_argument_t
/
grant execute on ku$_argument_list_t to public
/

create or replace force view ku$_argument_view of ku$_argument_t
  with object identifier (procedure_num) as
  select
   obj#,
   procedure$,
   overload#,
   procedure#,
   position#,
   sequence#,
   level#,
   argument,
   type#,
   charsetid,
   charsetform,
   default#,
   in_out,
   properties,
   length,
   precision#,
   scale,
   radix,
   deflength,
   sys.dbms_metadata_util.long2varchar(deflength,
                                        'SYS.ARGUMENT$',
                                        'DEFAULT$',
                                        rowid),           
   type_owner,
   type_name,
   type_subname,
   type_linkname,
   pls_type
from sys.argument$
/
grant select on ku$_argument_view to public
/
-- type info for Procedures
--     from method$ (dplsql.bsq)
create or replace type ku$_procinfo_t as object
(
  obj_num       number,
  procedure_num number,
  objerload_num number,
  procedurename varchar2(30),                              /* procedure name */
  properties    number,                              /* procedure properties */
                /* 0x00001 =     1 = HIDDEN (internally generated) procedure */
                /* 0x00002 =     2 = C implementation (in spec)              */
                /* 0x00004 =     4 = Java implementation (in spec)           */
                /* 0x00008 =     8 = Aggregate function                      */
                /* 0x00010 =    16 = Pipelined function                      */
                /* 0x00020 =    32 = Parallel enabled                        */
                /* 0x00040 =    64 = Retrun Self as result (SQLJ)            */
                /* 0x00080 =   128 = Constructor function (SQLJ)             */
                /* 0x00100 =   256 = deterministic                           */
                /* 0x00200 =   512 = Pipelined func; interface impl          */
                /* 0x00400 =  1024 = Function with invokers rights           */
                /* 0x00800 =  2048 = Func with partitioned argument(s)       */
                /* 0x01000 =  4096 = Func with clustered argument(s)         */
                /* 0x02000 =  8192 = Func with ordered i/p argument(s)       */
                /* 0x04000 =  16384 = Partitioned arg: Hash partitioning     */
                /* 0x08000 = 32768 = Partitioned arg: Range partitioning     */
                /* 0x10000 = 65536 = Partitioned using any partitioning      */
  /* The following field is relevant only for aggregate and pipelined        */
  /*  functions that are implemented using an implementation type            */
  itypeobj_num  number,                 /* implementation type object number */
  spare1        number,
  spare2        number,
  spare3        number,
  spare4        number
)
/
grant execute on ku$_procinfo_t to public
/
create or replace force view ku$_procinfo_view of ku$_procinfo_t
  with object identifier (obj_num) as
  select
  obj#,
  procedure#,
  overload#,
  procedurename,
  properties,
  itypeobj#,
  spare1,
  spare2,
  spare3,
  spare4
  from procedureinfo$
/
grant select on ku$_procinfo_view to public
/

-- from dplsql.bsql
create or replace type ku$_procjava_t as object
( obj_num       number,                 /* spec/body object number */
  procedure_num number,                  /* procedure# or position */
  ownername     varchar2(30),            /* class owner name */
  ownerlength   number,              /* length of class owner name */
  usersignature varchar2(4000),              /* User signature for java */
  usersiglen    number,                /* Length of user signature for java */
  classname     varchar2(4000),           /* method class name */
  classlength   number,             /* length of method class name */
  methodname    varchar2(4000),            /* java method name */
  methodlength  number,              /* length of java method name */
  flags         varchar2(4000),              /* internal flags */
  flagslength   number,                /* length of internal flags */
  cookiesize    number)                                      /* cookie size */
/
grant execute on ku$_procjava_t to public
/
create or replace force view ku$_procjava_view of ku$_procjava_t
  with object identifier (obj_num) as
  select
  obj#,
  procedure#,
  ownername,
  ownerlength,
  usersignature,
  usersiglen,
  classname,
  classlength,
  methodname,
  methodlength,
  flags,
  flagslength,
  cookiesize  
  from procedurejava$
/
grant select on ku$_procjava_view to public
/

create or replace type ku$_procc_t as object
( obj_num        number,                 /* spec/body object number */
  procedure_num   number,                  /* procedure# or position */
  entrypoint_num number)                 /* entrypoint table entry# */
/
grant execute on ku$_procc_t to public
/
create or replace force view ku$_procc_view of ku$_procc_t
  with object identifier (obj_num) as
  select
  obj#,
  procedure#,
  entrypoint#
  from procedurec$
/
grant select on ku$_procc_view to public
/

create or replace type ku$_procplsql_t as object
( obj_num          number,                 /* spec/body object number */
  procedure_num    number,                  /* procedure# or position */
  entrypoint_num   number)                 /* entrypoint table entry# */
/
grant execute on ku$_procplsql_t to public
/
create or replace force view ku$_procplsql_view of ku$_procplsql_t
  with object identifier (obj_num) as
  select
  obj#,
  procedure#,
  entrypoint#
  from procedureplsql$
/
grant select on ku$_procplsql_view to public
/

-- type info for Methods
--     from method$ (dobj.bsq)
create or replace type ku$_method_t as object
(
  toid           raw(16),                                            /* TOID */
  version_num    number,                     /* internal type version number */
  method_num     number,                        /* method number or position */
  name           varchar2(30),                                /* method name */
  properties     number,                             /* method's properties: */
  /* 0x00001 =      1 = PRIVATE method */
  /* 0x00002 =      2 = PUBLIC method (default) */
  /* 0x00004 =      4 = INLINE method */
  /* 0x00008 =      8 = VIRTUAL method => NOT FINAL */
  /* 0x00010 =     16 = CONSTANT method */
  /* 0x00020 =     32 = contructor method */
  /* 0x00040 =     64 = destructor method */
  /* 0x00080 =    128 = operator method */
  /* 0x00100 =    256 = selfish method */
  /* 0x00200 =    512 = MAP method */
  /* 0x00800 =   2048 = ORDER method */
  /* 0x01000 =   4096 = Read No Data State method (default) */
  /* 0x02000 =   8192 = Write No Data State method */
  /* 0x04000 =  16384 = Read No Process State method */
  /* 0x08000 =  32768 = Write No Process State method */
  /* 0x10000 =  65536 = Not Instantiable method */
  /* 0x20000 = 131072 = Overriding method */
  /* 0x40000 = 262144 = Returns SELF as result */
  parameters_num number,                             /* number of parameters */
  results        number,                                /* number of results */
  xflags         number,                          /* Flags not stored in TDO */
  /* 0x01 - Inherited method */
  spare1         number,                                         /* reserved */
  spare2         number,                                         /* reserved */
  spare3         number,                                         /* reserved */
  externVarName  varchar2(114),   /*"M_VCSZ" external variable name for SQLJ */
  argument_list  ku$_argument_list_t,            /* argument list for method */
  procedureinfo  ku$_procinfo_t,                           /* procedure info */
  procjava       ku$_procjava_t,                       /*java procedure info */
  procplsql      ku$_procplsql_t,                     /*plsql procedure info */
  procc          ku$_procc_t,                             /*C procedure info */
  obj_num        number
)
/
create or replace type ku$_method_list_t
   as table of ku$_method_t
/
grant execute on ku$_method_list_t to public
/

create or replace force view ku$_method_view of ku$_method_t
  with object identifier (toid) as
  select
  m.toid,
  m.version#,
  m.method#,
  m.name,
  m.properties,
  m.parameters#,
  m.results,
  m.xflags,
  m.spare1,
  m.spare2,
  m.spare3,
  m.externVarName,
  cast(multiset(select * from  ku$_argument_view a
                where m.name = a.procedure_val and
                      a.obj_num = o.obj# 
               ) as ku$_argument_list_t
      ),
  (select value(pi) from ku$_procinfo_view pi
   where pi.obj_num = o.obj# and
         pi.procedure_num = m.method#),
  (select value(pj) from ku$_procjava_view pj
   where pj.obj_num=o.obj# and 
         pj.procedure_num = m.method#),
  (select value(pq) from ku$_procplsql_view pq
   where pq.obj_num=o.obj# and 
         pq.procedure_num = m.method#),
  (select value(pc) from ku$_procc_view pc
   where pc.obj_num=o.obj# and 
         pc.procedure_num = m.method#),
  o.obj#
from  sys.obj$ o, sys.method$ m
where m.toid = o.oid$
/
grant select on ku$_method_view to public
/

-- Type attribute info:
--      from attribute$
create or replace type ku$_type_attr_t as object
(
  toid          raw(16),                                             /* TOID */
  version_num   number,                      /* internal type version number */
  name          varchar2(30),                              /* attribute name */
  attribute_num number,                       /* attribute identifier number */
  attr_vers_num number,        /* attribute's type's internal version number */
  attr_toid     raw(16),                                 /* attribute's TOID */
  synobj_num    number,                              /* obj# of type synonym */
  properties    number,                           /* attribute's properties: */
  /* 0x4000 =   16384 = is a PONTER attribute */
  /* 0x8000 =   32768 = is a REF attribute */
  charsetid     number,                                  /* character set id */
  charsetform   number,                                /* character set form */
  length        number,                  /* fixed character string length or */
                                  /* maximum varying character string length */
  precision_num number,        /* fixed- or floating-point numeric precision */
  scale         number,                         /* fixed-point numeric scale */
  externname    varchar2(4000),        /* field in java class for SQLJ types */
  xflags        number,                           /* flags not stored in TDO */
  /* 0x01 - inherited attribute */
  spare1        number,                      /* fractional seconds precision */
  spare2        number,                  /* interval leading field precision */
  spare3        number,                                          /* reserved */
  spare4        number,                                          /* reserved */
  spare5        number,                                          /* reserved */
  setter        number,                        /* Setter function no. (SQLJ) */
  getter        number,                        /* Getter function no. (SQLJ) */
  typemd        ku$_simple_type_t                           /* schema object */
)
/

grant execute  on ku$_type_attr_t to public
/

create or replace type ku$_type_attr_list_t 
  as table of ku$_type_attr_t
/
grant execute on ku$_type_attr_list_t to public
/
create or replace force view ku$_type_attr_view of ku$_type_attr_t
  with object identifier (toid) as
select 
  a.toid,
  a.version#,
  a.name,
  a.attribute#,
  a.attr_version#,
  a.attr_toid,    
  a.synobj#,
  a.properties,
  a.charsetid,
  a.charsetform,
  a.length,     
  a.precision#, 
  a.scale,         
  a.externname,    
  a.xflags,
  a.spare1,
  a.spare2,
  a.spare3,
  a.spare4,
  a.spare5,
  a.setter,
  a.getter,
  (select value(st) from ku$_simple_type_view st
   where a.attr_toid = st.toid 
         and st.version = (SELECT MAX(ST2.VERSION)
                           FROM ku$_simple_type_View st2
                           WHERE ST2.TOID = a.attr_toid))
from  sys.attribute$ a
/
grant select on ku$_type_attr_view to public
/

-- udt for types
-- Note: ku$_source_list_t is defined in dbmsmetu.sql
create or replace type ku$_type_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  oid           raw(16),                                             /* toid */
  typeid        raw(16), /* short typeid value (for non final and sub types) */
  version       number,                      /* internal type version number */
  hashcode      raw(17),                                 /* Version hashcode */
  type_num      number,                      /* type encoding (see sqldef.h) */
  properties    number,                                   /* type properties */
  attribute_num number,                              /* number of attributes */
  method_num    number,                                 /* number of methods */
  hidmethod_num number,                         /* number of hiddend methods */
  externtype    number,                                     /* external type */
                                                    /* 1 = SQLData SQLJ type */
                                                /* 2 = CustomDatum SQLJ type */
                                               /* 3 = serializable SQLJ type */
                                      /* 4 = internal serializable SQLJ type */
                                                    /* 5 = ORAData SQLJ type */
  externname    varchar(114),    /* (M_VCSZ)java class implementing the type */
  source_lines  ku$_source_list_t,                           /* source lines */
  compiler_info ku$_switch_compiler_t,
  supertype_obj ku$_schemaobj_t,                    /* supertype object info */
  collection    ku$_collection_t,                        /* collection$ data */
  attr_list     ku$_type_attr_list_t,                      /* attribute list */
  method_list   ku$_method_list_t
)
/

grant execute on ku$_type_t to public
/

create or replace force view ku$_type_view of ku$_type_t
  with object identifier (obj_num) as
  select '1','2',
         oo.obj#,
         value(o),
         oo.oid$,
         t.typeid, t.version#, 
         sys.dbms_metadata.get_hashcode(o.owner_name,o.name),
         t.typecode, t.properties,
         t.attributes, t.methods, t.hiddenMethods,
         t.externtype, t.externname,
         sys.dbms_metadata_util.get_source_lines(oo.name,oo.obj#,oo.type#),
         (select value(c) from ku$_switch_compiler_view c 
                 where c.obj_num =oo.obj#),
         (select value(stso) from ku$_schemaobj_view stso 
                 where stso.oid = t.supertoid),
         (select value(c) from ku$_collection_view c
              where oo.oid$ = c.toid),
         cast(multiset(select value(a)
                       from   sys.ku$_type_attr_view a
                       where  a.toid = oo.oid$)
                       as     ku$_type_attr_list_t),
         cast(multiset(select value(m)
                       from   sys.ku$_method_view m
                       where  m.toid = oo.oid$ and m.xflags=0 and m.obj_num=oo.obj#)
                       as     ku$_method_list_t)
  from sys.obj$ oo, sys.ku$_edition_schemaobj_view o, type$ t
  where oo.type# = 13
    and oo.obj#  = o.obj_num
    and oo.subname is null      /* latest type version */
    and oo.oid$ = t.toid
        /* type$ properties bits:
           262144=0     - latest type version
           other bits=0 - not system-generated type
        */
    and bitand(t.properties,262144+2048+64+16)=0
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_type_view to public
/

create or replace type ku$_type_body_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  source_lines  ku$_source_list_t,                           /* source lines */
  compiler_info ku$_switch_compiler_t
)
/

grant execute on ku$_type_body_t to public
/

-- bug 3995788: a dummy type body row is created in obj$ for SQLJ types
-- with no entries in source$. So for the type body view we exclude
-- type bodies where type_misc$.properties has either 0x10 or 0x20 set.

create or replace force view ku$_type_body_view of ku$_type_body_t
  with object identifier (obj_num) as
  select '1','1',
         oo.obj#,
         value(o),
         sys.dbms_metadata_util.get_source_lines(oo.name,oo.obj#,oo.type#),
         (select value(c) from ku$_switch_compiler_view c 
                 where c.obj_num =oo.obj#)
  from sys.obj$ oo, sys.ku$_edition_schemaobj_view o, type_misc$ t
  where oo.type# = 14
    and oo.obj#  = o.obj_num
    and t.obj#   = o.obj_num
    and bitand(t.properties,16+32)=0  /* exclude SQLJ type bodies (see above)*/
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_type_body_view to public
/

create or replace type ku$_full_type_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  type_t        ku$_type_t,                                   /* type object */
  type_body_t   ku$_type_body_t                          /* type body object */
)
/

grant execute on ku$_full_type_t to public
/

create or replace force view ku$_full_type_view of ku$_full_type_t
  with object identifier (obj_num) as
  select '1','2',
         oo.obj#,
         value(o),
         value(t),
         (select value(tb) from ku$_type_body_view tb
          where oo.name  = tb.schema_obj.name
          and o.owner_name  = tb.schema_obj.owner_name)
  from sys.obj$ oo, sys.ku$_edition_schemaobj_view o,
        ku$_type_view t
  where oo.type# = 13
    and oo.obj#  = o.obj_num
    and oo.obj#  = t.schema_obj.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_full_type_view to public
/

-- type and view used by export
-- includes base_obj_num (obj# of the type_spec) so that the base_obj_num
-- can be used as a filter

create or replace type ku$_exp_type_body_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  base_obj_num  number,                                /* base object number */
  obj_num       number,                                     /* object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  source_lines  ku$_source_list_t,                          /* source lines */
  compiler_info ku$_switch_compiler_t
)
/

grant execute on ku$_exp_type_body_t to public
/
-- the no_merge optimizer hint is added to work around a 
-- sigsegv at evaopn2()+231, when processing a query on 
-- ku$_exp_type_body_view.
--
-- Sriram Krishnamurthy wrote:
--  Please give the hint  no_merge in the select statement of
--  ku$_exp_type_body_view and it works. The problem is that after view 
--  merge the 4th columns kafco doesn't get allocated.  Interestingly 
--  the 3rd operand point to same column and it does seem to have colkafco. 
-- Please file a bug if you are fine with workaround and fix can be done later. 

create or replace force view ku$_exp_type_body_view of ku$_exp_type_body_t
  with object identifier (obj_num) as
  select /*+ no_merge */
         '1','1',
         o1.obj#,o2.obj#,
         (select value(o) from sys.ku$_edition_schemaobj_view o 
                          where o.obj_num=o2.obj#),
       sys.dbms_metadata_util.get_source_lines(o2.name,o2.obj#,o2.type#),
       (select value(c) from sys.ku$_switch_compiler_view c 
                 where c.obj_num = o2.obj#)
  from sys.ku$_edition_obj_view o1, sys.ku$_edition_obj_view o2,
       sys.type$ ty, type_misc$ tm
  where o1.type# = 13 and o2.type#=14
    and o1.name=o2.name and o1.owner#=o2.owner#
    and ty.toid=o1.oid$
    and o1.subname is null      /* latest type version */
        /* type$ properties bits:
           8388608=0    - not transient type
           262144=0     - latest type version
           other bits=0 - not system-generated type
        */
    and bitand(ty.properties,8388608+262144+2048+64+16)=0
    and tm.obj#  = o2.obj#
    and bitand(tm.properties,16+32)=0   /* exclude SQLJ type bodies */
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o2.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_exp_type_body_view to public
/

-- incomplete types: types that are targets of REF dependency from
-- some other type

create or replace view ku$_inc_type_view of ku$_schemaobj_t
  with object identifier (obj_num) as
select value (oo)
  from sys.ku$_edition_schemaobj_view oo, sys.obj$ o, sys.obj$ do,
       sys.dependency$ d, sys.type$ ty
  where o.oid$ = ty.toid
    and oo.obj_num = o.obj#
    and o.owner# != 0                   /* not owned by SYS */
    and bitand(o.flags,16)!=16          /* not secondary object */
    and o.obj# = d.p_obj#
    and do.obj# = d.d_obj#
    and bitand(d.property,2)=2          /* only REF dependency */
    and do.type# = 13
    and bitand(ty.properties,8388608)=0 /* exclude transient types */
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_inc_type_view to public
/

-- get dependency information needed to sort types
-- note: excluding SYS-owned types saves .38 sec

create or replace view ku$_deptypes_base_view(
 typeobjno, typename, typeownerno, typeowner, dobjno, dname)
as
 select unique o.obj#,o.name,o.owner#,u.name, d.d_obj#, do.name
from ku$_edition_obj_view o, obj$ do, type$ dt, user$ u, dependency$ d, type$ t
where o.oid$ = t.toid
  and bitand(t.properties,8388608+2128)=0 /* not transient or sys-generated */
  and bitand(o.flags,16)!=16          /* not secondary object */
  and o.owner# != 0                   /* not owned by SYS */
  and o.owner# = u.user#
  and o.obj# = d.p_obj#
  and do.obj# = d.d_obj#
  and bitand(d.property,1)=1          /* only hard dependency */
  and do.type# = 13
  and do.oid$ = dt.toid
  and dt.toid = dt.tvoid    /* only the latest type */
union
 select o.obj#,o.name,o.owner#,u.name,0,NULL
from ku$_edition_obj_view o, user$ u, type$ t
where o.oid$ = t.toid
  and bitand(t.properties,8388608+2128)=0 /* not transient or sys-generated */
  and bitand(o.flags,16)!=16          /* not secondary object */
  and o.owner# != 0                   /* not owned by SYS */
  and o.owner# = u.user#
  and not exists (select * from obj$ do, dependency$ d
                  where o.obj# = d.p_obj#
                  and do.obj# = d.d_obj#
                  and do.type# = 13
                  and bitand(d.property,1)=1 )
/
grant select on ku$_deptypes_base_view to select_catalog_role
/
create or replace view ku$_deptypes_view(
 typeobjno, typename, typeownerno, typeowner, dobjno, dname)
as
 select b.typeobjno, b.typename, b.typeownerno, b.typeowner, b.dobjno, b.dname
 from ku$_deptypes_base_view b
 where (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (b.typeownerno, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_deptypes_view to public
/

-------------------------------------------------------------------------------
--                              SIMPLE COLUMNS
-------------------------------------------------------------------------------

-- UDT for simple column info. This is the foundation for a number of different
-- column variants and is sufficient for simple column name lists.

create or replace type ku$_simple_col_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                          /* column number as created */
  intcol_num    number,                            /* internal column number */
  segcol_num    number,                          /* column number in segment */
  property      number,                     /* column properties (bit flags) */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000),/* name of type attr. column: null if != type */
  type_num      number,                               /* data type of column */
  deflength     number,    /* virtual column text length (for func. indexes) */
  default_val   clob,                      /* virtual column expression text */
  col_expr      sys.xmltype            /* parsed functional index expression */
)
/
grant execute on ku$_simple_col_t to public
/
create or replace type ku$_simple_col_list_t
 as table of ku$_simple_col_t
/
grant execute on ku$_simple_col_list_t to public
/
-- view to get a simple set of column attributes.
-- NOTE: Originally we had just an attribute called 'name' that was either
-- c.name or attrcol$.name selected via a DECODE of c.property bit 1.
-- However, for an as yet unexplained reason, this causes a full table scan
-- on col$ in outer views that used this view.

create or replace force view ku$_simple_col_view of ku$_simple_col_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#,
         c.col#,
         c.intcol#,
         c.segcol#,
         c.property,
         c.name,
         case
          when c.type#=123 
          then sys.dbms_metadata_util.get_fullattrname( 
                        c.obj#, c.col#, c.intcol#, c.type#)
          else sys.dbms_metadata_util.get_attrname( 
                        c.obj#, c.intcol#)
         end,
         c.type#,
         c.deflength,
         sys.dbms_metadata_util.long2clob(c.deflength,
                                          'SYS.COL$',
                                          'DEFAULT$',
                                          c.rowid),
         case 
           when c.deflength is null or bitand(c.property,32+65536)=0
           then null
           else
            (select sys.dbms_metadata.parse_default(u.name,o.name,
                                                    c.deflength,c.rowid)
             from obj$ o, user$ u
             where o.obj#=c.obj# and o.owner#=u.user#)
         end
  from col$ c
/
grant select on ku$_simple_col_view to select_catalog_role
/

-- view to get simple column information for a nested table setid column.
-- used solely for constraint and index column names - sets the column
-- name/attribute to the 'real' column/attribute name.
--
-- This is only valid for setid columns referenced from a foreign key
-- constraint (i.e. foreign key (nested_table_id) references <outer-table>
-- (<setid-column-name>)).  The 'resolved' column name is illegal when used
-- in a hidden setid constraint or index (i.e. unique (<setid-column-name>).
-- For those cases the only valid column name is the system generated one
-- (SYS_NCnnnnnmmmmm$).  However, the hidden setid constraint and index
-- info only appears with TABLE objects, and it is ignored except for
-- transportable mode, where the column names are not used. 

create or replace force view ku$_simple_setid_col_view of ku$_simple_col_t
  with object identifier (obj_num, intcol_num) as
  select c.obj#,
         c.col#,
         c.intcol#,
         c.segcol#,
         (c.property + BITAND(c2.property,1)),
         c2.name,
         (select a.name
          from attrcol$ a
          where a.obj# = c2.obj# and
                a.intcol# = c2.intcol#),
         c.type#,
         c.deflength,
         sys.dbms_metadata_util.long2clob(c.deflength,
                                          'SYS.COL$',
                                          'DEFAULT$',
                                          c.rowid),
         case 
           when c.deflength is null or bitand(c.property,32+65536)=0
           then null
           else
            (select sys.dbms_metadata.parse_default(u.name,o.name,
                                                    c.deflength,c.rowid)
             from obj$ o, user$ u
             where o.obj#=c.obj# and o.owner#=u.user#)
         end
  from col$ c, col$ c2
  where BITAND(c.property, 1024) = 1024 and                  /* SETID column */
        c2.obj# = c.obj# and
        c2.col# = c.col# and
        c2.intcol# = (c.intcol# - 1) and
        c2.segcol# = 0
/
grant select on ku$_simple_setid_col_view to select_catalog_role
/

-- view to get simple column information for a pkRef REF column.
-- used soley for constraint column name resolution - sets the constraint
-- column name/attribute to the 'real' column/attribute name for each
-- internal column referenced in the intcol#s ub2 intcol# array.
-- invoked only for columns with property REA (REF attribute).

create or replace force view ku$_simple_pkref_col_view of ku$_simple_col_t
  with object identifier (obj_num, intcol_num) as
  select c.obj#,
         c.col#,
         c.intcol#,
         c.segcol#,
         c.property,
         c2.name,
         (select a.name
          from attrcol$ a
          where a.obj# = c2.obj# and
                a.intcol# = c2.intcol#),
         c.type#,
         c.deflength,
         sys.dbms_metadata_util.long2clob(c.deflength,
                                             'SYS.COL$',
                                             'DEFAULT$',
                                             c.rowid),
         case 
           when c.deflength is null or bitand(c.property,32+65536)=0
           then null
           else
            (select sys.dbms_metadata.parse_default(u.name,o.name,
                                                    c.deflength,c.rowid)
             from obj$ o, user$ u
             where o.obj#=c.obj# and o.owner#=u.user#)
         end
  from  col$ c, col$ c2, ccol$ cc, cdef$ cd, coltype$ ct   
  where cc.obj# = c.obj# and
        cc.intcol# = c.intcol# and
        cd.con# = cc.con# and
        ct.obj# = c.obj# and
        ct.col# = c.col# and
        ct.intcols = cd.intcols and
        UTL_RAW.CAST_TO_BINARY_INTEGER(
          SUBSTRB(ct.intcol#s, (cc.pos# * 2 - 1), 2), 3) = c.intcol# and
        c2.obj# = c.obj# and
        c2.intcol# = ct.intcol#
/
grant select on ku$_simple_pkref_col_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              INDEX COLUMNS
-------------------------------------------------------------------------------


-- ADT for index columns
create or replace type ku$_index_col_t as object
(
  obj_num       number,                               /* index object number */
  bo_num        number,                                /* base object number */
  intcol_num    number,                            /* internal column number */
  col           ku$_simple_col_t,                                  /* column */
  pos_num       number,                 /* column position number as created */
  segcol_num    number,                          /* column number in segment */
  segcollen     number,                      /* length of the segment column */
  offset        number,                                  /* offset of column */
  flags         number,                                             /* flags */
  spare2        number,
  spare3        number,
  spare4        varchar2(1000),
  spare5        varchar2(1000),
  spare6        varchar2(19),
  oid_or_setid  number    /* !0 = hidden unique constraint on OID column (1) */
                                  /* or nested tbl column's SETID column (2) */
)
/

create or replace type ku$_index_col_list_t as table of ku$_index_col_t;
/

grant execute on ku$_index_col_t to public
/

grant execute on ku$_index_col_list_t to public
/

-- view for index columns
create or replace force view ku$_index_col_view of ku$_index_col_t
  with object identifier(obj_num, intcol_num) as
  select ic.obj#, ic.bo#, ic.intcol#,
          value(c), ic.pos#, 
          ic.segcol#, ic.segcollength, ic.offset, ic.spare1,
          ic.spare2, ic.spare3, ic.spare4, ic.spare5, to_char(ic.spare6,'YYYY/MM/DD HH24:MI:SS'),
          decode(bitand(c.property,1024+2),0,0,2,1,1024,2,0)
  from ku$_simple_col_view c, ind$ i, icol$ ic
  where ic.bo#     = c.obj_num
  and   i.obj# = ic.obj#
  and c.intcol_num =
   case 
      /* join index : 0x0400 */
    when (bitand(i.property, 1024) = 1024) then ic.spare2
      /* not a join index */
    else dbms_metadata.get_index_intcol(ic.bo#, ic.intcol#)
   end 
/
grant select on ku$_index_col_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              LOB COLUMNS
-------------------------------------------------------------------------------
-- UDT for lob index
create or replace type ku$_lobindex_t as object
(
  obj_num       number,                                          /* object # */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                          /* data layer object number */
  cols          number,                                 /* number of columns */
  pct_free      number,          /* minimum free space percentage in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                    /* maximum number of transactions */
  pct_thres     number,           /* iot overflow threshold, null if not iot */
  type_num      number,                       /* what kind of index is this? */
  flags         number,                                     /* mutable flags */
  property      number,             /* immutable flags for life of the index */
  blevel        number,                                       /* btree level */
  leafcnt       number,                                  /* # of leaf blocks */
  distkey       number,                                   /* # distinct keys */
  lblkkey       number,                          /* avg # of leaf blocks/key */
  dblkkey       number,                          /* avg # of data blocks/key */
  clufac        number,                                 /* clustering factor */
  analyzetime   varchar2(19),                        /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  rowcnt        number,                       /* number of rows in the index */
  intcols       number,                        /* number of internal columns */
  degree        number,           /* # of parallel query slaves per instance */
  instances     number,             /* # of OPS instances for parallel query */
  trunccnt      number,                        /* re-used for iots 'inclcol' */
  numcolsdep    number,         /* number of columns depended on, >= intcols */
  numkeycols    number,             /* # of key columns in compressed prefix */
  spare3        number,
  spare4        varchar2(1000),     /* used for parameter str for domain idx */
  spare5        varchar2(1000),
  spare6        varchar2(19)
)
/
grant execute on ku$_lobindex_t to public
/
-- view for lob indexes
create or replace force view ku$_lobindex_view of ku$_lobindex_t
  with object identifier(obj_num) as
  select i.obj#, value(o),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where i.file#  = s.file_num
          and   i.block# = s.block_num
          and   i.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = i.obj#),
         i.dataobj#,
         i.cols, i.pctfree$,
         i.initrans, i.maxtrans, i.pctthres$, i.type#, i.flags, i.property,
         i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
         to_char(i.analyzetime,'YYYY/MM/DD HH24:MI:SS'), i.samplesize, i.rowcnt, i.intcols, i.degree,
         i.instances, i.trunccnt, i.spare1, i.spare2,
         i.spare3,  replace(i.spare4, chr(0)), i.spare5, to_char(i.spare6,'YYYY/MM/DD HH24:MI:SS')
   from  ku$_schemaobj_view o, ind$ i, ts$ ts
   where o.obj_num = i.obj#
         AND  i.ts# = ts.ts#
/
grant select on ku$_lobindex_view to select_catalog_role
/

-- ADT for LOB columns in non-partitioned tables
create or replace type ku$_lob_t as object
(
  obj_num       number,                                /* obj# of base table */
  col_num       number,                                     /* column number */
  intcol_num    number,                            /* internal column number */
  schema_obj    ku$_schemaobj_t,                        /* LOB schema object */
  storage       ku$_storage_t,                          /* LOB storage       */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  ind_num       number,                                 /* LOB index obj #   */
  lobindex      ku$_lobindex_t,                          /* LOB index object */
  chunk         number,                    /* oracle blocks in one lob chunk */
  pctversion    number,                                      /* version pool */
  flags         number,                                             /* flags */
                                                 /* 0x0001 = NOCACHE LOGGING */
                                               /* 0x0002 = NOCACHE NOLOGGING */
                                             /* 0x0008 = CACHE READS LOGGING */
                                           /* 0x0010 = CACHE READS NOLOGGING */
  property      number,                    /* 0x00 = user defined lob column */
                                    /* 0x01 = kernel column(s) stored as lob */
                                     /* 0x02 = user lob column with row data */
                                            /* 0x04 = partitioned LOB column */
                                   /* 0x0008 = LOB In Global Temporary Table */
                                          /* 0x0010 = Session-specific table */
  retention     number,                              /* LOB Retention period */
  freepools     number,                             /* LOB segment FREEPOOLS */
  spare1        number,
  spare2        number,
  spare3        varchar2(255)
)
/
grant execute on ku$_lob_t to public
/

-- view for lobs in nonpartitioned tables
create or replace force view ku$_lob_view of ku$_lob_t
  with object OID(obj_num, intcol_num)
  as select l.obj#, l.col#, l.intcol#, 
        (select value(o) from ku$_schemaobj_view o
         where o.obj_num = l.lobj#),
        (select value(s) from ku$_storage_view s
         where s.file_num  = l.file#
         and   s.block_num = l.block#
         and   s.ts_num    = l.ts#),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = l.lobj#),
        (select ts.name from ts$ ts where l.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where l.ts# = ts.ts#),
        l.ind#, 
        (select value(i) from ku$_lobindex_view i where i.obj_num=l.ind#),
        l.chunk, l.pctversion$, l.flags, l.property,
        l.retention, l.freepools, l.spare1, l.spare2, l.spare3
  from lob$ l
/
grant select on ku$_lob_view to select_catalog_role
/

-- ADT for table level defaults for LOBs (from partlob$)
create or replace type ku$_partlob_t as object
(
  obj_num       number,                                /* obj# of base table */
  intcol_num    number,                            /* internal column number */
  schema_obj    ku$_schemaobj_t,            /* LOB schema object (for lobj#) */
  defts_name    varchar2(30),                     /* default tablespace name */
  defblocksize  number,                    /* default size of block in bytes */
  defchunk      number,                    /* oracle blocks in one lob chunk */
  defpctversion number,                              /* default version pool */
  defflags      number,                                             /* flags */
                                                 /* 0x0001 = NOCACHE LOGGING */
                                               /* 0x0002 = NOCACHE NOLOGGING */
                                             /* 0x0008 = CACHE READS LOGGING */
                                           /* 0x0010 = CACHE READS NOLOGGING */
  defpro        number,                        /* default partition property */
                                             /* 0x02 = enable storage in row */
  definiexts    number,  /* default INITIAL extent size; NULL if unspecified */
  defextsize    number,     /* default NEXT extent size; NULL if unspecified */
  defminexts    number,           /* default MINEXTENTS; NULL if unspecified */
  defmaxexts    number,           /* default MAXEXTENTS; NULL if unspecified */
  defextpct     number,          /* default PCTINCREASE; NULL if unspecified */
  deflists      number,      /* default FREELISTS value; NULL if unspecified */
  defgroups     number,      /* default FREELIST GROUPS; NULL if unspecified */
  defbufpool    number,          /* default BUFFER_POOL; NULL if unspecified */
  spare1        number,
  spare2        number,
  spare3        number,
  defmaxsize    number,              /* default MAXSIZE; NULL if unspecified */
  defretention  number,            /* default RETENTION; NULL if unspecified */
  defmintime    number    /* default MIN retention time; NULL if unspecified */
)
/
grant execute on ku$_partlob_t to public
/

create or replace force view ku$_partlob_view of ku$_partlob_t
  with object OID(obj_num, intcol_num)
  as select l.tabobj#, l.intcol#, 
        (select value(o) from ku$_schemaobj_view o
         where o.obj_num = l.lobj#),
        (select ts.name from ts$ ts where l.defts# = ts.ts#),
        NVL(
          (select ts.blocksize from ts$ ts where l.defts# = ts.ts#),
          NVL(         /* should be avail. thru lobcompart, lobfrag if null */
            (select ts.blocksize
             from   ts$ ts, lobfrag$ lf
             where  l.lobj# = lf.parentobj# and
                    lf.ts# = ts.ts# and rownum < 2),
            (select ts.blocksize
             from   ts$ ts, lobcomppart$ lcp, lobfrag$ lf
             where  l.lobj# = lcp.lobj# and 
                    lcp.partobj# = lf.parentobj# and 
                    lf.ts# = ts.ts# and rownum < 2))),
        l.defchunk, l.defpctver$, l.defflags, l.defpro,
        l.definiexts, l.defextsize, l.defminexts, l.defmaxexts,
        l.defextpct, l.deflists, l.defgroups, l.defbufpool,
        l.spare1, l.spare2, l.spare3, 
        l.defmaxsize, l.defretention, l.defmintime
  from partlob$ l
/

grant select on ku$_partlob_view to select_catalog_role
/

-- UDT for lobfrag index
create or replace type ku$_lobfragindex_t as object
(
  obj_num       number,                                          /* object # */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                        /* base index */
  part_num      number,                                  /* partition number */
  flags         number,                                     /* mutable flags */
  pct_free      number,          /* minimum free space percentage in a block */
  pct_thres     number,           /* iot overflow threshold, null if not iot */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                    /* maximum number of transactions */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  rowcnt        number,                       /* number of rows in the index */
  blevel        number,                                       /* btree level */
  leafcnt       number,                                  /* # of leaf blocks */
  distkey       number,                                   /* # distinct keys */
  lblkkey       number,                          /* avg # of leaf blocks/key */
  dblkkey       number,                          /* avg # of data blocks/key */
  clufac        number,                                 /* clustering factor */
  spare1        number,
  spare2        number,
  spare3        number,
  inclcol       number                     /* iot include col#, null if !iot */
)
/
grant execute on ku$_lobfragindex_t to public
/
-- view for lobfrag indexes
create or replace force view ku$_lobfragindex_view of ku$_lobfragindex_t
  with object identifier(obj_num) as
  select i.obj#, value(o),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where i.file#  = s.file_num
          and   i.block# = s.block_num
          and   i.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = i.obj#),
         i.dataobj#, i.bo#, i.part#, i.flags,
         i.pctfree$, i.pctthres$, i.initrans, i.maxtrans,
         to_char(i.analyzetime,'YYYY/MM/DD HH24:MI:SS'), i.samplesize, i.rowcnt,
         i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
         i.spare1, i.spare2, i.spare3, i.inclcol
   from  ku$_schemaobj_view o, indpart$ i, ts$ ts
   where o.obj_num = i.obj#
         AND  i.ts# = ts.ts#
/
grant select on ku$_lobfragindex_view to select_catalog_role
/

-- view for lobfrag indexes in subpartitions
create or replace force view ku$_sublobfragindex_view of ku$_lobfragindex_t
  with object identifier(obj_num) as
  select i.obj#, value(o),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where i.file#  = s.file_num
          and   i.block# = s.block_num
          and   i.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = i.obj#),
         i.dataobj#, i.pobj#, i.subpart#, i.flags,
         i.pctfree$, NULL, i.initrans, i.maxtrans,
         to_char(i.analyzetime,'YYYY/MM/DD HH24:MI:SS'), i.samplesize, i.rowcnt,
         i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
         i.spare1, i.spare2, i.spare3, NULL
   from  ku$_schemaobj_view o, indsubpart$ i, ts$ ts
   where o.obj_num = i.obj#
         AND  i.ts# = ts.ts#
/
grant select on ku$_sublobfragindex_view to select_catalog_role
/

-- ADT for actual partition- or subpartition-level LOB attributes
create or replace type ku$_lobfrag_t as object
(
  obj_num       number,                            /* fragment object number */
  parent_obj_num number,                             /* parent object number */
  part_obj_num  number,                           /* partition object number */
  base_obj_num  number,                               /* obj# of base table */
  intcol_num    number,                            /* internal column number */
  part_num      number,                                  /* partition number */
  schema_obj    ku$_schemaobj_t,                        /* LOB schema object */
  storage       ku$_storage_t,                          /* LOB storage       */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  ind_num       number,                                 /* LOB index obj #   */
  lobindex      ku$_lobfragindex_t,                      /* LOB index object */
  chunk         number,                    /* oracle blocks in one lob chunk */
  pctversion    number,                                      /* version pool */
  flags         number,                                             /* flags */
                                                 /* 0x0001 = NOCACHE LOGGING */
                                               /* 0x0002 = NOCACHE NOLOGGING */
                                             /* 0x0008 = CACHE READS LOGGING */
                                           /* 0x0010 = CACHE READS NOLOGGING */
  property      number,                    /* 0x00 = user defined lob column */
                                    /* 0x01 = kernel column(s) stored as lob */
                                     /* 0x02 = user lob column with row data */
                                            /* 0x04 = partitioned LOB column */
                                   /* 0x0008 = LOB In Global Temporary Table */
                                          /* 0x0010 = Session-specific table */
  spare1        number,
  spare2        number,
  spare3        number       
)
/
grant execute on ku$_lobfrag_t to public
/

create or replace type ku$_lobfrag_list_t as table of ku$_lobfrag_t
/
grant execute on ku$_lobfrag_list_t to public
/

-- view for partition-level LOB attributes
create or replace force view ku$_lobfrag_view of ku$_lobfrag_t
  with object OID(obj_num)
  as select lf.fragobj#, lf.parentobj#, lf.tabfragobj#,
        l.obj#, l.intcol#, lf.frag#,
        (select value(o) from ku$_schemaobj_view o
         where o.obj_num = lf.fragobj#),
        (select value(s) from ku$_storage_view s
         where s.file_num  = lf.file#
         and   s.block_num = lf.block#
         and   s.ts_num    = lf.ts#),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = lf.fragobj#),
        (select ts.name from ts$ ts where lf.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where lf.ts# = ts.ts#),
        lf.indfragobj#, 
        (select value(i) from ku$_lobfragindex_view i
                 where i.obj_num=lf.indfragobj#),
        lf.chunk, lf.pctversion$, lf.fragflags, lf.fragpro,
        lf.spare1, lf.spare2, lf.spare3
  from  lob$ l, lobfrag$ lf
        where l.lobj#=lf.parentobj#
/
grant select on ku$_lobfrag_view to select_catalog_role
/

-- view for partition-level LOB attributes in partitioned IOTs
create or replace force view ku$_piotlobfrag_view of ku$_lobfrag_t
  with object OID(obj_num)
  as select lf.fragobj#, lf.parentobj#, pl.tabobj#,
        l.obj#, l.intcol#, lf.frag#,
        (select value(o) from ku$_schemaobj_view o
         where o.obj_num = lf.fragobj#),
        (select value(s) from ku$_storage_view s
         where s.file_num  = lf.file#
         and   s.block_num = lf.block#
         and   s.ts_num    = lf.ts#),
        (select value(s) from ku$_deferred_stg_view s
         where s.obj_num = lf.fragobj#),
        (select ts.name from ts$ ts where lf.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where lf.ts# = ts.ts#),
        lf.indfragobj#, 
        (select value(i) from ku$_lobfragindex_view i
                 where i.obj_num=lf.indfragobj#),
        lf.chunk, lf.pctversion$, lf.fragflags, lf.fragpro,
        lf.spare1, lf.spare2, lf.spare3
  from  lob$ l, partlob$ pl, lobfrag$ lf
        where l.lobj#=lf.parentobj# and pl.lobj#=lf.parentobj#
/
grant select on ku$_piotlobfrag_view to select_catalog_role
/

-- view for subpartition-level LOB attributes
create or replace force view ku$_sublobfrag_view of ku$_lobfrag_t
  with object OID(obj_num)
  as select lf.fragobj#, lf.parentobj#, lf.tabfragobj#,
        l.obj#, l.intcol#, lf.frag#,
        (select value(o) from ku$_schemaobj_view o
         where o.obj_num = lf.fragobj#),
        (select value(s) from ku$_storage_view s
         where s.file_num  = lf.file#
         and   s.block_num = lf.block#
         and   s.ts_num    = lf.ts#),
        (select value(s) from ku$_deferred_stg_view s
         where s.obj_num = lf.fragobj#),
        (select ts.name from ts$ ts where lf.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where lf.ts# = ts.ts#),
        lf.indfragobj#, 
        (select value(i) from ku$_sublobfragindex_view i
                 where i.obj_num=lf.indfragobj#),
        lf.chunk, lf.pctversion$, lf.fragflags, lf.fragpro,
        lf.spare1, lf.spare2, lf.spare3
  from  lob$ l, lobcomppart$ lc, lobfrag$ lf
        where lc.partobj#=lf.parentobj#
          and l.lobj#=lc.lobj#
/
grant select on ku$_sublobfrag_view to select_catalog_role
/

-- ADT for partition-level defaults in composite partitioned tables
-- (from lobcomppart$)
create or replace type ku$_lobcomppart_t as object
(
  obj_num       number,                             /* obj# of LOB partition */
  part_obj_num  number,                     /* table partition object number */
  part_num      number,                                  /* partition number */
  intcol_num    number,                            /* internal column number */
  schema_obj    ku$_schemaobj_t,            /* LOB schema object (for lobj#) */
  defts_name    varchar2(30),                     /* default tablespace name */
  defblocksize  number,                    /* default size of block in bytes */
  defchunk      number,                    /* oracle blocks in one lob chunk */
  defpctversion number,                              /* default version pool */
  defflags      number,                                             /* flags */
                                                           /* 0x0000 = CACHE */
                                                 /* 0x0001 = NOCACHE LOGGING */
                                               /* 0x0002 = NOCACHE NOLOGGING */
                                             /* 0x0008 = CACHE READS LOGGING */
                                           /* 0x0010 = CACHE READS NOLOGGING */
  defpro        number,                        /* default partition property */
                                             /* 0x02 = enable storage in row */
  definiexts    number,  /* default INITIAL extent size; NULL if unspecified */
  defextsize    number,     /* default NEXT extent size; NULL if unspecified */
  defminexts    number,           /* default MINEXTENTS; NULL if unspecified */
  defmaxexts    number,           /* default MAXEXTENTS; NULL if unspecified */
  defextpct     number,          /* default PCTINCREASE; NULL if unspecified */
  deflists      number,      /* default FREELISTS value; NULL if unspecified */
  defgroups     number,      /* default FREELIST GROUPS; NULL if unspecified */
  defbufpool    number,          /* default BUFFER_POOL; NULL if unspecified */
  spare1        number,
  spare2        number,
  spare3        number, 
  defmaxsize    number,              /* default MAXSIZE; NULL if unspecified */
  defretention  number,            /* default RETENTION; NULL if unspecified */
  defmintime    number    /* default MIN retention time; NULL if unspecified */
)
/
grant execute on ku$_lobcomppart_t to public
/

create or replace type ku$_lobcomppart_list_t as table of ku$_lobcomppart_t
/
grant execute on ku$_lobcomppart_list_t to public
/

create or replace force view ku$_lobcomppart_view of ku$_lobcomppart_t
  with object OID(obj_num)
  as select lc.partobj#, lc.tabpartobj#, lc.part#,
        (select l.intcol# from lob$ l where l.lobj#=lc.lobj#),
        (select value(o) from ku$_schemaobj_view o
         where o.obj_num = lc.partobj#),
        (select ts.name from ts$ ts where lc.defts# = ts.ts#),
        (select ts.blocksize from ts$ ts where lc.defts# = ts.ts#),
        lc.defchunk, lc.defpctver$, lc.defflags, lc.defpro,
        lc.definiexts, lc.defextsize, lc.defminexts, lc.defmaxexts,
        lc.defextpct, lc.deflists, lc.defgroups, lc.defbufpool,
        lc.spare1, lc.spare2, lc.spare3,
        lc.defmaxsize, lc.defretention, lc.defmintime
  from lobcomppart$ lc
/
grant select on ku$_lobcomppart_view to select_catalog_role
/
Rem
Rem Lob information for template subpartition lob store as clause
Rem
create or replace type ku$_tlob_comppart_t as object
(
  base_objnum    number,                           /* object number of table */
  colname        varchar2(30),
  intcol_num     number,                      /* column number of lob column */
  spart_pos      number,                            /* subpartition position */
  flags          number,          /* Type of lob column - 1 varray, 2 opaque */
  lob_spart_name varchar2(34),          /* segment name for lob subpartition */
  ts_name        varchar2(30),          /* tablespace name (if any) assigned */
  ts_num         number                      /* tablespace (if any) assigned */
)
/
grant execute on ku$_tlob_comppart_t to public
/

create or replace type ku$_tlob_comppart_list_t as table of ku$_tlob_comppart_t
/

grant execute on ku$_tlob_comppart_list_t to public
/

create or replace force view ku$_tlob_comppart_view of ku$_tlob_comppart_t
  with object OID(base_objnum)
  as select  dspl.bo#, '"'||c.name||'"', dspl.intcol#,
             dspl.spart_position, dspl.flags, dspl.lob_spart_name,
             (select(t.name) from sys.ts$ t where t.ts# = dspl.lob_spart_ts#),
             dspl.lob_spart_ts#
     from    sys.col$ c, sys.defsubpartlob$ dspl
     where   dspl.bo# = c.obj#
         and dspl.intcol# = c.col#
/
grant select on ku$_tlob_comppart_view to select_catalog_role
/

-------------------------------------------------------------------------------
-- for Checking sub-partition were created via 
--the tables's subpartition template clause.
-- using for function check_match_template 
-------------------------------------------------------------------------------
create or replace type ku$_temp_subpart_t as object
(
  obj_num       number,                             /* obj# of subpartition */
  ts_num        number,
  pobj_num      number,     /* object# of partition containing subpartition */
  subpartno     number,
  bhiboundval   blob
)
/
grant execute on ku$_temp_subpart_t to public
/
create or replace force view ku$_temp_subpart_view of ku$_temp_subpart_t
  with object identifier(obj_num) as
      SELECT 
            tsp.obj#,
            tsp.ts#,
            tsp.pobj#,
            row_number() OVER 
                         (partition by tsp.pobj# order by tsp.subpart#)-1,
            tsp.bhiboundval
        FROM tabsubpart$ tsp
/
grant select on ku$_temp_subpart_view to select_catalog_role
/
create or replace type ku$_temp_subpartdata_t as object
(
  obj_num       number, 
  spts  number,
  dspts number, 
  pdefts number, 
  tdefts number, 
  udefts number,
  spbnd  blob, -- varchar2(4000), 
  dspbnd blob  -- varchar2(4000) 
)
/
grant execute on ku$_temp_subpartdata_t to public
/
CREATE OR REPLACE VIEW  ku$_temp_subpartdata_view  of ku$_temp_subpartdata_t
  with object identifier(obj_num) as 
        SELECT 
              p.obj#,
              sp.ts_num,
              dsp.ts#,
              p.defts#,
              tpo.defts#,
              u.datats#, 
              sp.bhiboundval,
              dsp.bhiboundval
        FROM sys.tabcompart$ p, sys.partobj$ tpo,  ku$_temp_subpart_view sp,
             sys.defsubpart$ dsp, sys.obj$ po, sys.obj$ spo, sys.user$ u
        WHERE
             p.bo# = tpo.obj# AND
             p.subpartcnt = MOD(TRUNC(tpo.spare2/65536), 65536) AND
             sp.pobj_num = p.obj# AND
             po.obj# = p.obj# AND
             spo.obj# = sp.obj_num AND
             sp.subpartno = dsp.spart_position AND
             dsp.bo# = p.bo# AND
             u.user# = po.owner# AND
             (spo.subname = (po.subname || '_' || dsp.spart_name) OR
                            (po.subname LIKE 'SYS_P%' AND 
                             spo.subname LIKE 'SYS_SUBP%'))
/
GRANT SELECT ON  ku$_temp_subpartdata_view TO PUBLIC;
/

create or replace type ku$_temp_subpartlobfrg_t as object
(
  obj_num     number,  /* parentobj num */
  ts_num      number,
  fragobj_num   number,
  frag_num        number,
  tabfragobj_num  number
)
/
grant execute on ku$_temp_subpartlobfrg_t to public
/
create or replace force view ku$_temp_subpartlobfrg_view of 
          ku$_temp_subpartlobfrg_t
  with object identifier(obj_num) as
        SELECT 
              lf.parentobj#,
              lf.ts#,  
              lf.fragobj#,
              row_number() OVER 
                 (partition by lf.parentobj# order by lf.frag#) - 1,
              lf.tabfragobj# 
        FROM sys.lobfrag$ lf
/ 
grant select on ku$_temp_subpartlobfrg_view to select_catalog_role
/
create or replace type ku$_temp_subpartlob_t as object
(
  obj_num         number,
  lpdefts number,
  lfts    number,
  lcdefts number,
  lspdefts number, 
  spts     number
)
/
grant execute on ku$_temp_subpartlob_t to public
/
create or replace force view ku$_temp_subpartlob_view of 
          ku$_temp_subpartlob_t
  with object identifier(obj_num) as
       SELECT
              tp.obj#,
              lp.defts#,
              lf.ts_num,
              lb.defts#,
              dsp.lob_spart_ts#,
              tsp.ts#
        FROM  sys.tabcompart$ tp, sys.lobcomppart$ lp, sys.partlob$ lb, 
              sys.ku$_temp_subpartlobfrg_view lf, sys.defsubpartlob$ dsp, 
              sys.obj$ lspo, sys.obj$ tpo, sys.tabsubpart$ tsp
        WHERE 
              lp.tabpartobj# = tp.obj# AND
              lp.lobj# = lb.lobj# and
              lf.obj_num = lp.partobj# AND
              dsp.bo# = tp.bo# and
              dsp.intcol# = lb.intcol# AND
              lspo.obj# = lf.fragobj_num AND
              tpo.obj# = tp.obj# AND
              (lspo.subname = tpo.subname || '_' || dsp.lob_spart_name OR
               (tpo.subname LIKE 'SYS_P%' AND lspo.subname 
                                 LIKE 'SYS_LOB_SUBP%')) AND
              dsp.spart_position = lf.frag_num AND 
              tsp.obj# = lf.tabfragobj_num
     UNION   -- ALL
        SELECT tp.obj#,
               lp.defts#,
               lf.ts_num,
               lb.defts#,
               NULL, 
               tsp.ts#
        FROM sys.tabcompart$ tp, sys.lobcomppart$ lp, sys.partlob$ lb, 
             sys.ku$_temp_subpartlobfrg_view lf, sys.obj$ lspo, sys.obj$ tpo, 
             sys.tabsubpart$ tsp
        WHERE lp.tabpartobj# = tp.obj# AND
              lp.lobj# = lb.lobj# AND
              lf.obj_num = lp.partobj# AND
              lb.intcol# NOT IN 
                (SELECT distinct dsp.intcol#
                  FROM sys.defsubpartlob$ dsp 
                  WHERE dsp.bo# = tp.bo#) AND
              lspo.obj# = lf.fragobj_num AND
              tpo.obj# = tp.obj# AND
              lspo.subname LIKE 'SYS_LOB_SUBP%' AND
              tsp.obj# = lf.tabfragobj_num
/
GRANT SELECT ON  ku$_temp_subpartlob_view TO PUBLIC;
/

-------------------------------------------------------------------------------
--                              NESTED TABLE PARTITION
-------------------------------------------------------------------------------

-- UDT for table partition data for partitioned heap nested table
create or replace type ku$_hntp_t as object
(
  obj_num       number,                              /* obj# of nested table */
  property      number,                                  /* table properties */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number                                              /* flags */
)
/
grant execute on ku$_hntp_t to public
/

-- view for table data for heap nested table partition
create or replace force view ku$_hntp_view
  of ku$_hntp_t with object identifier(obj_num) as
  select tp.obj#, t.property,
        (select value(s) from ku$_storage_view s
         where     tp.file#  = s.file_num
             and   tp.block# = s.block_num
             and   tp.ts#    = s.ts_num),
        (select value(s) from ku$_deferred_stg_view s
         where s.obj_num = tp.obj#),
        (select ts.name from ts$ ts where tp.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where tp.ts# = ts.ts#),
        tp.pctfree$, tp.pctused$, tp.initrans, tp.maxtrans, tp.flags
  from tabpart$ tp, tab$ t
  where tp.bo# = t.obj# and 
        bitand(t.property,64+512) = 0 -- skip IOT and overflow segs
/
grant select on ku$_hntp_view to select_catalog_role
/

-- UDT for nested table partition
create or replace type ku$_ntpart_t as object
(
  obj_num       number,                                /* obj# of base table */
  part_num      number,                               /* part# of base table */
  intcol_num    number,              /* internal column number in base table */
  ntab_num      number,              /* object number of nested table object */
  schema_obj    ku$_schemaobj_t,           /* schema object for nested table */
  col           ku$_simple_col_t,                                  /* column */
  property      number,                           /* nested table properties */
  flags         number,                                /* nested table flags */
  hnt           ku$_hntp_t                      /* heap table partition data */
)
/
grant execute on ku$_ntpart_t to public
/
create or replace force view ku$_ntpart_view
  of ku$_ntpart_t with object identifier(obj_num) as
  select
                nt.obj#, ntp.part#, nt.intcol#, nt.ntab#,
                (select value(o) from ku$_schemaobj_view o
                 where o.obj_num = ntp.obj#),
                (select value(c) from ku$_simple_col_view c
                 where c.obj_num = nt.obj#
                 and   c.intcol_num = nt.intcol#),
                (select t.property from tab$ t where t.obj# = nt.ntab#),
                (select ct.flags from coltype$ ct
                        where ct.obj# = nt.obj#
                        and   ct.intcol# = nt.intcol#),
                (select value(hntp) from ku$_hntp_view hntp
                 where hntp.obj_num = ntp.obj#)
            from ntab$ nt,
               tabpart$ ntp
            where ntp.bo#=nt.ntab#
/
grant select on ku$_ntpart_view to select_catalog_role
/
create or replace type ku$_ntpart_list_t as table of ku$_ntpart_t
/
grant execute on ku$_ntpart_list_t to public
/

-- UDT for collection of nested table partitions of a parent table
create or replace type ku$_ntpart_parent_t as object
(
  obj_num       number,                                /* obj# of base table */
  part_num      number,                     /* part# of base table partition */
  nts           ku$_ntpart_list_t                 /* nested table partitions */
)
/
grant execute on ku$_ntpart_parent_t to public
/
create or replace force view ku$_ntpart_parent_view
  of ku$_ntpart_parent_t with object identifier(obj_num) as
  select t.obj#, tp.part#,
    cast(multiset(select
                      obj_num,
                      part_num,
                      intcol_num,
                      ntab_num,
                      schema_obj,
                      col,
                      property,
                      flags,
                      hnt
            from  ku$_ntpart_view  ntp
            where ntp.part_num=tp.part# and
                  ntp.obj_num in ( 
                    select obj# from ntab$ nt 
                      start with nt.obj#=t.obj#
                        connect by prior nt.ntab#=nt.obj#)
                ) as ku$_ntpart_list_t
        )
  from tab$ t, tabpart$ tp
  where tp.bo# = t.obj# and 
        bitand(t.property,32+4) = 32+4 -- has nested tables, and is partitioned
/
grant select on ku$_ntpart_parent_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              PARTITIONS
-------------------------------------------------------------------------------

-- ADT for index partitions.  Based on indpart$
create or replace type ku$_ind_part_t as object
(
  obj_num       number,                                 /* obj# of partition */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  storage       ku$_storage_t,                    /* storage characteristics */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                        /* base index */
  part_num      number,                                  /* partition number */
  tab_part_name varchar2(30),                        /* table partition name */
  hiboundlen    number,                     /* len. of high bound val. expr. */
  hiboundval    varchar2(4000),                                 /* text of " */
-- hiboundval   long,                                           /* text of " */
  flags         number,                                             /* flags */
  pct_free      number,                   /* min. free space %age in a block */
  pct_thres     number,                 /* iot overflow thresh. null if !iot */
  initrans      number,                         /* initial # of transactions */
  maxtrans      number,                            /* max. # of transactions */
  analyzetime   varchar2(19),                     /* timestamp last analyzed */
  samplesize    number,                                     /* for histogram */
  rowcnt        number,                                         /* # of rows */
  blevel        number,                                      /* B-tree level */
  leafcnt       number,                             /* number of leaf blocks */
  distkey       number,                                /* # of distinct keys */
  lblkkey       number,                      /* av. # of leaf blocks per key */
  dblkkey       number,                      /* av. # of data blocks per key */
  clufac        number,                                 /* clustering factor */
  spare1        number,
  spare2        number,
  spare3        number,
  inclcol       number,                    /* iot include col#, null if !iot */
  parameters    varchar2(1000)                        /* from indpart_param$ */
)
/

grant execute on ku$_ind_part_t to public
/

create or replace type ku$_ind_part_list_t as table of ku$_ind_part_t
/

grant execute on ku$_ind_part_list_t to public
/

-- view for index partitions
create or replace force view ku$_ind_part_view of ku$_ind_part_t
  with object identifier(obj_num) as
  select ip.obj#, 
         (select value(so) from ku$_schemaobj_view so
          where so.obj_num = ip.obj#),
         ts.name, ts.blocksize, 
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = ip.obj#),
         (select value(s) from ku$_storage_view s
          where ip.ts# = s.ts_num
          AND ip.file# = s.file_num
          AND ip.block# = s.block_num),
         ip.dataobj#, ip.bo#, ip.part#,
         (select tpo.subname 
           from obj$ tpo, tabpart$ tp, ind$ i
           where i.obj#=ip.bo# and
                 tp.bo#=i.bo# and
                 tp.part#=ip.part# and
                 tpo.obj#=tp.obj#),
         ip.hiboundlen, 
         sys.dbms_metadata_util.long2varchar(ip.hiboundlen,
                                    'SYS.INDPART$',
                                    'HIBOUNDVAL',
                                     ip.rowid),
         ip.flags, ip.pctfree$, ip.pctthres$,
         ip.initrans, ip.maxtrans, to_char(ip.analyzetime,'YYYY/MM/DD HH24:MI:SS'), ip.samplesize,
         ip.rowcnt, ip.blevel, ip.leafcnt, ip.distkey, ip.lblkkey,
         ip.dblkkey, ip.clufac, ip.spare1, ip.spare2, ip.spare3,
         ip.inclcol,
         (select ipp.parameters from indpart_param$ ipp
          where ipp.obj#=ip.obj#)
  from  indpart$ ip, ts$ ts
  where ts.ts#=ip.ts#
/
grant select on ku$_ind_part_view to select_catalog_role
/

-- ADT for PIOT partitions.  Based on indpart$
create or replace type ku$_piot_part_t as object
(
  obj_num       number,                                 /* obj# of partition */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                    /* storage characteristics */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                        /* base index */
  part_num      number,                                  /* partition number */
  hiboundlen    number,                     /* len. of high bound val. expr. */
  hiboundval    varchar2(4000),                                 /* text of " */
-- hiboundval   long,                                           /* text of " */
  lobs          ku$_lobfrag_list_t,                                  /* lobs */
  flags         number,                                             /* flags */
  pct_free      number,                   /* min. free space %age in a block */
  pct_thres     number,                 /* iot overflow thresh. null if !iot */
  initrans      number,                         /* initial # of transactions */
  maxtrans      number,                            /* max. # of transactions */
  analyzetime   varchar2(19),                     /* timestamp last analyzed */
  samplesize    number,                                     /* for histogram */
  rowcnt        number,                                         /* # of rows */
  blevel        number,                                      /* B-tree level */
  leafcnt       number,                             /* number of leaf blocks */
  distkey       number,                                /* # of distinct keys */
  lblkkey       number,                      /* av. # of leaf blocks per key */
  dblkkey       number,                      /* av. # of data blocks per key */
  clufac        number,                                 /* clustering factor */
  spare1        number,
  spare2        number,
  spare3        number,
  inclcol       number                     /* iot include col#, null if !iot */
)
/

grant execute on ku$_piot_part_t to public
/

create or replace type ku$_piot_part_list_t as table of ku$_piot_part_t
/
grant execute on ku$_piot_part_list_t to public
/

-- view for PIOT partitions
create or replace force view ku$_piot_part_view of ku$_piot_part_t
  with object identifier(obj_num) as
  select ip.obj#, 
         (select value(so) from ku$_schemaobj_view so
          where so.obj_num = ip.obj#),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where ip.file#  = s.file_num
          and   ip.block# = s.block_num
          and   ip.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = ip.obj#),
         ip.dataobj#, ip.bo#,
         ip.part#, ip.hiboundlen, 
         sys.dbms_metadata_util.long2varchar(ip.hiboundlen,
                                    'SYS.INDPART$',
                                    'HIBOUNDVAL',
                                     ip.rowid),
         cast(multiset(select lf.* from ind$ i, ku$_piotlobfrag_view lf
                        where lf.part_num=ip.part#
                          and ip.bo#=i.obj# and i.bo#=lf.base_obj_num
                        order by lf.intcol_num
                      ) as ku$_lobfrag_list_t
             ),
         ip.flags, ip.pctfree$, ip.pctthres$,
         ip.initrans, ip.maxtrans, to_char(ip.analyzetime,'YYYY/MM/DD HH24:MI:SS'), ip.samplesize,
         ip.rowcnt, ip.blevel, ip.leafcnt, ip.distkey, ip.lblkkey,
         ip.dblkkey, ip.clufac, ip.spare1, ip.spare2, ip.spare3,
         ip.inclcol
  from  indpart$ ip, ts$ ts
  where ip.ts# = ts.ts#
/
grant select on ku$_piot_part_view to select_catalog_role
/


-- ADT for table partitions.  Based on tabpart$
create or replace type ku$_tab_part_t as object
(
  obj_num       number,                                     /* object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                    /* storage characteristics */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                 /* base table object */
  part_num      number,                                  /* partition number */
  hiboundlen    number,                   /* length of high bound value expr */
  hiboundval    varchar2(4000),             /* text of high bound value expr */
-- hiboundval   long,                       /* text of high bound value expr */
  lobs          ku$_lobfrag_list_t,                                  /* lobs */
  nt            ku$_ntpart_parent_t,               /* nested table partitions */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                         /* initial # of transactions */
  maxtrans      number,                            /* max. # of transactions */
  flags         number,                                             /* flags */
  analyzetime   varchar2(19),                     /* timestamp last analyzed */
  samplesize    number,                          /* samplesize for histogram */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  spare1        number,
  spare2        number,
  spare3        number
)
/

grant execute on ku$_tab_part_t to public
/

create or replace type ku$_tab_part_list_t as table of ku$_tab_part_t
/

grant execute on ku$_tab_part_list_t to public
/

-- view for table partitions
create or replace force view ku$_tab_part_view of ku$_tab_part_t
  with object identifier(obj_num) as
  select tp.obj#, value(o),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where tp.file#  = s.file_num
          and   tp.block# = s.block_num
          and   tp.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = tp.obj#),
         tp.dataobj#, tp.bo#,
         tp.part#, tp.hiboundlen,
         sys.dbms_metadata_util.long2varchar(tp.hiboundlen,
                                        'SYS.TABPART$',
                                        'HIBOUNDVAL',
                                        tp.rowid),
         cast(multiset(select * from ku$_lobfrag_view lf
                        where lf.part_obj_num=tp.obj#
                        order by lf.intcol_num
                      ) as ku$_lobfrag_list_t
             ),
         (select value(ntp) from ku$_ntpart_parent_view ntp
          where ntp.obj_num = tp.bo# and ntp.part_num=tp.part#),
         tp.pctfree$, tp.pctused$, tp.initrans,
         tp.maxtrans, tp.flags, to_char(tp.analyzetime,'YYYY/MM/DD HH24:MI:SS'), tp.samplesize, tp.rowcnt,
         tp.blkcnt, tp.empcnt, tp.avgspc, tp.chncnt, tp.avgrln, tp.spare1,
         tp.spare2, tp.spare3
  from ku$_schemaobj_view o, tabpart$ tp, ts$ ts
  where tp.obj# = o.obj_num
        AND tp.ts# = ts.ts#
/
grant select on ku$_tab_part_view to select_catalog_role
/
-- ADT for table subpartitions.  Based on tabsubpart$.  These hang off
-- of their parents: table composite partitions.
create or replace type ku$_tab_subpart_t as object
(
  obj_num       number,                              /* obj# of subpartition */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                    /* storage characteristics */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                                   /* data layer obj# */
  pobj_num      number,                          /* obj# of parent partition */
  subpart_num   number,                                     /* subpartition# */
  lobs          ku$_lobfrag_list_t,                                  /* lobs */
  flags         number,                                             /* flags */
  pct_free      number,                      /* min. free space % in a block */
  pct_used      number,                      /* min. used spare % in a block */
  initrans      number,                         /* initial # of transactions */
  maxtrans      number,                            /* max. # of transactions */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                      /* # of rows sampled by analyze */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  spare1        number,
  spare2        number,
  spare3        number,
  hiboundlen    number,                     /* len. of high bound val. expr. */
  hiboundval    varchar2(4000)                                 /* text of " */
)
/

grant execute on ku$_tab_subpart_t to public
/

create or replace type ku$_tab_subpart_list_t as table of ku$_tab_subpart_t
/

grant execute on ku$_tab_subpart_list_t to public
/

-- view for table subpartitions
create or replace force view ku$_tab_subpart_view of ku$_tab_subpart_t
  with object identifier(obj_num) as
  select tsp.obj#, value(o),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where tsp.file#  = s.file_num
          and   tsp.block# = s.block_num
          and   tsp.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = tsp.obj#),
         tsp.dataobj#,
         tsp.pobj#, tsp.subpart#,
         cast(multiset(select * from ku$_sublobfrag_view lf
                        where lf.part_obj_num=tsp.obj#
                        order by lf.intcol_num
                      ) as ku$_lobfrag_list_t
             ),
         tsp.flags, tsp.pctfree$, tsp.pctused$,
         tsp.initrans, tsp.maxtrans, to_char(tsp.analyzetime,'YYYY/MM/DD HH24:MI:SS'), tsp.samplesize,
         tsp.rowcnt, tsp.blkcnt, tsp.empcnt, tsp.avgspc, tsp.chncnt,
         tsp.avgrln, tsp.spare1, tsp.spare2, tsp.spare3, tsp.hiboundlen,
         sys.dbms_metadata_util.long2varchar(tsp.hiboundlen,
                                    'SYS.TABSUBPART$',
                                    'HIBOUNDVAL',
                                     tsp.rowid)
  from ku$_schemaobj_view o, tabsubpart$ tsp, ts$ ts
  where tsp.obj# = o.obj_num
        AND tsp.ts# = ts.ts#
/
grant select on ku$_tab_subpart_view to select_catalog_role
/

-- ADT for table template subpartitions.  Based on defsubpart$.  These hang off
-- of their parents: table template subpartitions.
create or replace type ku$_tab_tsubpart_t as object
(
  base_objnum   number,                            /* Object number of table */
  spart_pos     number,                             /* subpartition position */
  spart_name    varchar2(34),                       /* name assigned by user */
  ts_name       varchar2(30),                            /* tablespace name */
  ts_num        number,                   /* Default tablespace NULL if none */
  flags         number,
  hiboundlen    number,              /* high bound text of this subpartition */
  hiboundval    varchar2(4000),                        /* length of the text */
  tlobs         ku$_tlob_comppart_list_t                             /* lobs */
)
/

grant execute on ku$_tab_tsubpart_t to public
/

create or replace type ku$_tab_tsubpart_list_t as table of ku$_tab_tsubpart_t
/

grant execute on ku$_tab_tsubpart_list_t to public
/

-- view for table template subpartitions

create or replace force view ku$_tab_tsubpart_view of ku$_tab_tsubpart_t
  with object identifier (base_objnum,spart_name,spart_pos) as
  select  dsp.bo#, dsp.spart_position, dsp.spart_name,
          (select( ts.name) from sys.ts$ ts where ts.ts# = dsp.ts#),
          dsp.ts#, dsp.flags, dsp.hiboundlen,
          sys.dbms_metadata_util.long2varchar( dsp.hiboundlen,
                                              'SYS.DEFSUBPART$',
                                              'HIBOUNDVAL',
                                              dsp.rowid),
          cast(multiset(select * from ku$_tlob_comppart_view tlcv
                        where  tlcv.base_objnum = dsp.bo#
                           and tlcv.spart_pos = dsp.spart_position
                        order by tlcv.intcol_num
                      ) as ku$_tlob_comppart_list_t)
  from    sys.defsubpart$ dsp
/
grant select on ku$_tab_tsubpart_view to select_catalog_role
/

-- ADT for table composite partitions.  Based on tabcompart$
create or replace type ku$_tab_compart_t as object
(
  obj_num       number,                           /* obj# of comp. partition */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                     /* obj# of table */
  part_num      number,                                  /* partition number */
  hiboundlen    number,             /* length of high bound value expression */
  hiboundval    varchar2(4000),       /* text of high-bound value expression */
  subpartcnt    number,                           /* number of subpartitions */
  smatch_tpl    number,                  /* 1 = subpartitions match template */
  subparts      ku$_tab_subpart_list_t,                     /* subpartitions */
  lmatch_tpl    number,                           /* 1 = lobs match template */
  lobs          ku$_lobcomppart_list_t,                              /* lobs */
  flags         number,                                             /* flags */
  defts_name    varchar2(30),                          /* default TABLESPACE */
  defblocksize  number,          /* blocksize in bytes of default TABLESPACE */
  defpctfree    number,                                   /* default PCTFREE */
  defpctused    number,                                   /* default PCTUSED */
  definitrans   number,                                  /* default INITRANS */
  defmaxtrans   number,                                  /* default MAXTRANS */
  definiexts    number,  /* default INITIAL extent size; NULL if unspecified */
  defextsize    number,     /* default NEXT extent size; NULL if unspecified */
  defminexts    number,           /* default MINEXTENTS; NULL if unspecified */
  defmaxexts    number,           /* default MAXEXTENTS; NULL if unspecified */
  defextpct     number,          /* default PCTINCREASE; NULL if unspecified */
  deflists      number,      /* default FREELISTS value; NULL if unspecified */
  defgroups     number,      /* default FREELIST GROUPS; NULL if unspecified */
  deflogging    number,                        /* default LOGGING attribute  */
  defbufpool    number,                         /* default BUFFER_POOL value */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                          /* samplesize for histogram */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  spare1        number,                       
  spare2        number,                                  /* compression info */
  /* from dpart.bsq:                              */
  /* Only 2 bytes of spare2 are currently spoken for */
  /* byte 0   : compression attribute of the partition */
  /*            following bit patterns are possible: */
  /*            00000000 : Compression not specified */
  /*            00000001 : Compression enabled for direct load operations */
  /*            00000010 : Compression disabled      */
  /*            00000101 : Compression enabled for all operations */
  /*            00001001 : Archive Compression: level 1 */
  /*            00010001 : Archive Compression: level 2 */
  /*            00011001 : Archive Compression: level 3 */
  /*            00100001 : Archive Compression: level 4 */
  /*            00101001 : Archive Compression: level 5 */
  /*            00110001 : Archive Compression: level 6 */
  /*            00111001 : Archive Compression: level 7 */
  /*            All other bit patterns are incorrect. */
  /* byte 1   : segment creation attributes of the partition */
  /*            00000001 : Deferred segment creation is the default */
  /*            00000010 : Immediate segment creation is the default */
  /*            Other bits can be used as needed */
  spare3        number,
  defmaxsize    number               /* default MAXSIZE; NULL if unspecified */
)
/

grant execute on ku$_tab_compart_t to public
/

create or replace type ku$_tab_compart_list_t as table of ku$_tab_compart_t
/

grant execute on ku$_tab_compart_list_t to public
/
-- view for table composite partitions
create or replace force view ku$_tab_compart_view of ku$_tab_compart_t
  with object identifier(obj_num) as
  select tcp.obj#, value(o), tcp.dataobj#, tcp.bo#, tcp.part#,
         tcp.hiboundlen, 
         sys.dbms_metadata_util.long2varchar(tcp.hiboundlen,
                                    'SYS.TABCOMPART$',
                                    'HIBOUNDVAL',
                                    tcp.rowid),
         tcp.subpartcnt,
         sys.dbms_metadata.check_match_template_par(tcp.obj#, tcp.subpartcnt),
         cast(multiset(select * from ku$_tab_subpart_view tsp
                       where tsp.pobj_num = tcp.obj#
                       order by tsp.subpart_num
                      ) as ku$_tab_subpart_list_t
                  ),
         sys.dbms_metadata.check_match_template_lob(tcp.obj#, tcp.subpartcnt),
         cast(multiset(select * from ku$_lobcomppart_view lc
                       where lc.part_obj_num = tcp.obj#
                        order by lc.intcol_num
                      ) as ku$_lobcomppart_list_t
                  ),
         tcp.flags, ts.name, ts.blocksize,
         tcp.defpctfree, tcp.defpctused, tcp.definitrans,
         tcp.defmaxtrans, tcp.definiexts, tcp.defextsize, tcp.defminexts,
         tcp.defmaxexts, tcp.defextpct, tcp.deflists, tcp.defgroups,
         tcp.deflogging, tcp.defbufpool, to_char(tcp.analyzetime,'YYYY/MM/DD HH24:MI:SS'), tcp.samplesize,
         tcp.rowcnt, tcp.blkcnt, tcp.empcnt, tcp.avgspc, tcp.chncnt,
         tcp.avgrln, tcp.spare1,
         -- Convert 'spare2' to a value that the pre-11.2 xsl stylesheet
         -- can process: if archive compressed and version < 11.2,
         -- turn off compression.  The block format for archive compression
         -- is not supported pre-11.2, so the compression bits must be
         -- set to NOCOMPRESS.
         case when bitand(tcp.spare2,8+16+32)=0 then tcp.spare2
              when dbms_metadata.get_version >= '11.02.00.00.00'
                   then tcp.spare2
              else 2
         end,
         tcp.spare3, tcp.defmaxsize
  from ku$_schemaobj_view o, tabcompart$ tcp, ts$ ts
  where tcp.obj# = o.obj_num
        AND tcp.defts# = ts.ts#
/
grant select on ku$_tab_compart_view to select_catalog_role
/

-- ADT for index subpartitions.  Based in indsubpart$.  These hang off of
-- their parents: index composite partitions.
create or replace type ku$_ind_subpart_t as object
(
  obj_num       number,                              /* obj# of subpartition */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                          /* data layer object number */
  pobj_num      number,                              /* parent object number */
  subpart_num   number,                               /* subpartition number */
  tab_subpart_name varchar2(30),                  /* table subpartition name */
  flags         number,                                             /* flags */
  pct_free      number,          /* minimum free space percentage in a block */
  initrans      number,                    /* initial number of transactions */
  maxtrans      number,                    /* maximum number of transactions */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                          /* samplesize for histogram */
  rowcnt        number,                                    /* number of rows */
  blevel        number,                                      /* B-tree level */
  leafcnt       number,                             /* number of leaf blocks */
  distkey       number,                           /* number of distinct keys */
  lblkkey       number,             /* average number of leaf blocks per key */
  dblkkey       number,             /* average number of data blocks per key */
  clufac        number,                                 /* clustering factor */
  spare1        number,
  spare2        number,
  spare3        number
)
/

grant execute on ku$_ind_subpart_t to public
/

create or replace type ku$_ind_subpart_list_t as table of ku$_ind_subpart_t
/

grant execute on ku$_ind_subpart_list_t to public
/

-- view for index subpartitions
create or replace force view ku$_ind_subpart_view of ku$_ind_subpart_t
  with object identifier(obj_num) as
  select isp.obj#,
         (select value(so) from ku$_schemaobj_view so
          where so.obj_num = isp.obj#),
         ts.name, ts.blocksize, 
         (select value(s) from ku$_storage_view s
          where isp.ts# = s.ts_num
          AND isp.file# = s.file_num
          AND isp.block# = s.block_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = isp.obj#),
         isp.dataobj#,
         isp.pobj#, isp.subpart#,
         (select tspo.subname
            from obj$ tspo, tabsubpart$ tsp, tabcompart$ tcp, ind$ i,
                 indcompart$ icp
            where icp.obj#=isp.pobj# and
                  i.obj#=icp.bo# and
                  tcp.bo#=i.bo# and
                  tcp.part#=icp.part# and
                  tsp.pobj#=tcp.obj# and
                  tsp.subpart#=isp.subpart# and
                  tspo.obj#=tsp.obj#),
         isp.flags, isp.pctfree$, isp.initrans,
         isp.maxtrans, to_char(isp.analyzetime,'YYYY/MM/DD HH24:MI:SS'), isp.samplesize, isp.rowcnt,
         isp.blevel, isp.leafcnt, isp.distkey, isp.lblkkey, isp.dblkkey,
         isp.clufac, isp.spare1, isp.spare2, isp.spare3
  from indsubpart$ isp, ts$ ts
  where isp.ts# = ts.ts#
/
grant select on ku$_ind_subpart_view to select_catalog_role
/

-- ADT for index composite partitions.  Based on indcompart$
create or replace type ku$_ind_compart_t as object
(
  obj_num       number,                           /* obj# of comp. partition */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                     /* obj# of table */
  part_num      number,                                  /* partition number */
  hiboundlen    number,             /* length of high bound value expression */
  hiboundval    varchar2(4000),       /* text of high-bound value expression */
  subpartcnt    number,                           /* number of subpartitions */
  subparts      ku$_ind_subpart_list_t,                     /* subpartitions */
  flags         number,                                     /* for any flags */
  defts_name    varchar2(30),     /* default TABLESPACE; NULL if unspecified */
  defblocksize  number,          /* blocksize in bytes of default TABLESPACE */
  defpctfree    number,                                   /* default PCTFREE */
  definitrans   number,                                  /* default INITRANS */
  defmaxtrans   number,                                  /* default MAXTRANS */
  definiexts    number,  /* default INITIAL extent size; NULL if unspecified */
  defextsize    number,     /* default NEXT extent size; NULL if unspecified */
  defminexts    number,           /* default MINEXTENTS; NULL if unspecified */
  defmaxexts    number,           /* default MAXEXTENTS; NULL if unspecified */
  defextpct     number,          /* default PCTINCREASE; NULL if unspecified */
  deflists      number,      /* default FREELISTS value; NULL if unspecified */
  defgroups     number,         /* default FREELIST GROUPS (N/A for indexes) */
  deflogging    number,                         /* default LOGGING attribute */
  defbufpool    number,                         /* default BUFFER_POOL value */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                          /* samplesize for histogram */
  rowcnt        number,                                    /* number of rows */
  blevel        number,                                      /* B-tree level */
  leafcnt       number,                             /* number of leaf blocks */
  distkey       number,                           /* number of distinct keys */
  lblkkey       number,             /* average number of leaf blocks per key */
  dblkkey       number,             /* average number of data blocks per key */
  clufac        number,                                 /* clustering factor */
  spare1        number,
  spare2        number,
  spare3        number,
  defmaxsize    number               /* default MAXSIZE; NULL if unspecified */
)
/

grant execute on ku$_ind_compart_t to public
/

create or replace type ku$_ind_compart_list_t as table of ku$_ind_compart_t
/

grant execute on ku$_ind_compart_list_t to public
/

-- view for index composite partitions
create or replace force view ku$_ind_compart_view of ku$_ind_compart_t
  with object identifier(obj_num) as
  select icp.obj#, value(o), icp.dataobj#, icp.bo#, icp.part#,
         icp.hiboundlen, 
         sys.dbms_metadata_util.long2varchar(icp.hiboundlen,
                                    'SYS.INDCOMPART$',
                                    'HIBOUNDVAL',
                                    icp.rowid),
         icp.subpartcnt,
         cast(multiset(select * from ku$_ind_subpart_view isp
                       where isp.pobj_num = icp.obj#
                        order by isp.subpart_num
                      ) as ku$_ind_subpart_list_t
             ),
          icp.flags, 
          -- hoist the next 2 queries up here because icp.defts# may be null
          -- and this avoids an outer join which is slooooow
          (select ts.name from ts$ ts where icp.defts# = ts.ts#),
          (select ts.blocksize from ts$ ts where icp.defts# = ts.ts#),
          icp.defpctfree, icp.definitrans,
          icp.defmaxtrans, icp.definiexts, icp.defextsize, icp.defminexts,
          icp.defmaxexts, icp.defextpct, icp.deflists, icp.defgroups,
          icp.deflogging, icp.defbufpool, to_char(icp.analyzetime,'YYYY/MM/DD HH24:MI:SS'), icp.samplesize,
          icp.rowcnt, icp.blevel, icp.leafcnt, icp.distkey, icp.lblkkey,
          icp.dblkkey, icp.clufac, icp.spare1, icp.spare2, icp.spare3,
          icp.defmaxsize
  from ku$_schemaobj_view o, indcompart$ icp
  where icp.obj# = o.obj_num
/
grant select on ku$_ind_compart_view to select_catalog_role
/

-- ADT for partitioning columns.  Based on partcol$
create or replace type ku$_part_col_t as object
(
  obj_num       number,                      /* object number of base object */
  intcol_num    number,                            /* internal column number */
  col           ku$_simple_col_t,       /* the column object */
  pos_num       number,                 /* position of col. in key */
  spare1        number                  /* spare column */
)
/

grant execute on ku$_part_col_t to public
/

create or replace type ku$_part_col_list_t as table of ku$_part_col_t
/
grant execute on ku$_part_col_list_t to public
/

-- view for table partitioning columns

create or replace force view ku$_tab_part_col_view of
  ku$_part_col_t with object identifier (obj_num, intcol_num) as
  select pc.obj#, pc.intcol#, value(c), pc.pos#, pc.spare1
  from ku$_simple_col_view c, partcol$ pc
  where   pc.obj#=c.obj_num
  and     pc.intcol#=c.intcol_num
/
grant select on ku$_tab_part_col_view to select_catalog_role
/

-- view for table subpartitioning columns. Based on tabsubpart$. Also uses
-- ku$_part_col_t.

create or replace force view ku$_tab_subpart_col_view of
  ku$_part_col_t with object identifier(obj_num, intcol_num) as
  select sc.obj#, sc.intcol#, value(c), sc.pos#, sc.spare1
  from ku$_simple_col_view c, subpartcol$ sc
  where  sc.obj#=c.obj_num
  and    sc.intcol#=c.intcol_num
/
grant select on ku$_tab_subpart_col_view to select_catalog_role
/


-- view for index partitioning columns

create or replace force view ku$_ind_part_col_view of
  ku$_part_col_t with object identifier (obj_num, intcol_num) as
  select pc.obj#, pc.intcol#, value(c), pc.pos#, pc.spare1
  from ku$_simple_col_view c, ind$ i, partcol$ pc
  where   pc.obj#=i.obj#
  and     i.bo#=c.obj_num
  and     pc.intcol#=c.intcol_num
/
grant select on ku$_ind_part_col_view to select_catalog_role
/

-- view for index subpartitioning columns. Based on tabsubpart$. Also uses
-- ku$_part_col_t.

create or replace force view ku$_ind_subpart_col_view of
  ku$_part_col_t with object identifier(obj_num, intcol_num) as
  select sc.obj#, sc.intcol#, value(c), sc.pos#, sc.spare1
  from ku$_simple_col_view c, ind$ i, subpartcol$ sc
  where  sc.obj#=i.obj#
  and    i.bo#=c.obj_num
  and    sc.intcol#=c.intcol_num
/
grant select on ku$_ind_subpart_col_view to select_catalog_role
/

-- insert_tsn_list$: for the store-in clause for interval partitioned tables.
-- see dpart.bsq
create or replace type ku$_insert_ts_t as object
(
  base_obj_num  number,           /* object number of base partitioned table */
  position_num  number,          /* position of tablespace specified by user */
  ts_num        number,                                 /* tablespace number */
  name          varchar2(30)                           /* name of tablespace */
)
/
grant execute on ku$_insert_ts_t to public
/
create or replace type ku$_insert_ts_list_t as table of ku$_insert_ts_t
/
grant execute on ku$_insert_ts_list_t to public
/
-- and the view
create or replace force view ku$_insert_ts_view of
  ku$_insert_ts_t with object identifier (base_obj_num,position_num) as
  select itl.bo#, itl.position#, itl.ts#, ts.name
  from sys.ts$ ts, sys.insert_tsn_list$ itl
  where ts.ts#=itl.ts#
/
grant select on ku$_insert_ts_view to select_catalog_role
/

-- ADT for partitioned objects; included in table/index-specific types.
-- Based on partobj$

create or replace type ku$_partobj_t as object
(
  obj_num       number,                 /* obj# of partitioned tab. or index */
  parttype      number,                                 /* partitioning type */
             /* 1 = range, 2 = hash, 3 = system 4 = List, 5 = Ref;           */
             /* If range/list/hash, subparttype may be non-zero to indicate  */
             /* type of composite partitioning method.                       */
             /* see subparttype(spare1) for form of subpartitioning used.    */
  partcnt       number,                              /* number of partitions */
  partkeycols   number,                  /* # of columns in partitioning key */
  flags         number,                                             /* flags */
                                    /* 0x01 = local      index      */
                                    /* 0x02 = prefixed   index      */
                                    /* 0x04 = no-align   index      */
                                    /* 0x08 = domain     index      */
                                    /* 0x10 = compressed index      */
                                    /* 0x20 = table has ref ptn'ed children */
                                    /* 0x40 = table is interval partitioned */
                                    /* 0x80 = System managed domain index   */
                                   /* 0x100 = IOT Top index         */ 
                                   /* 0x200 = LOB column index      */
                                   /* 0x400 = Tracked Table IOT Top index  */
                                   /* 0x800 = Segment creation deferred */
                                  /* 0x1000 = Segment creation immediate */
                /* from kkpac.h:                                             */
                /* LOCAL_INDEX          0x0001 = local partitioned index     */
                /* PREFIXED_INDEX       0x0002 = prefixed index              */
                /* NOALIGN_INDEX        0x0004 = local system part. index    */
                /*                               (alignment means nothing    */
                /*                                because there are          */
                /*                                no part. columns)          */
                /* DOMAIN_INDEX         0x0008 = local domain index          */
                /* COMPRESSED_INDEX     0x0010 = index partitions            */
                /*                               compressed by default       */
  defts_name    varchar2(30),                     /* default tablespace name */
  defblocksize  number,          /* blocksize in bytes of default TABLESPACE */
  defpctfree    number,                                   /* default PCTFREE */
  defpctused    number,                 /* default PCTUSED (N/A for indexes) */
  defpctthres   number,             /* default PCTTHRESHOLD (N/A for tables) */
  definitrans   number,                                  /* default INITRANS */
  defmaxtrans   number,                                  /* default MAXTRANS */
  definiexts    number,                       /* default INITIAL extent size */
  defextsize    number,                          /* default NEXT extent size */
  defminexts    number,                                /* default MINEXTENTS */
  defmaxexts    number,                                /* default MAXEXTENTS */
  defextpct     number,                               /* default PCTINCREASE */
  deflists      number,                           /* default FREELISTS value */
  defgroups     number,         /* default FREELIST GROUPS (N/A for indexes) */
  deflogging    number,           /* default logging attribute of the object */
  defbufpool    number,                         /* default BUFFER_POOL value */
  spare2        number,                              /* subpartitioning info */
  /* from dpart.bsq:                              */
  /* 5 bytes of spare2 are currently spoken for */
  /* byte 0   : subparttype - non-zero implies Composite partitioning */
  /*            (1 - Range, 2 - Hash, 3 - System, 4 - List); */
  /* byte 1   : subpartkeycols; */
  /* bytes 2-3: defsubpartcnt */
  /* byte 4   : compression attribute of the partition */
  /*            following bit patterns are possible: */
  /*            00000000 : Compression not specified */
  /*            00000001 : Compression enabled for direct load operations */
  /*            00000010 : Compression disabled      */
  /*            00000101 : Compression enabled for all operations */
  /*            00001001 : Archive Compression: level 1 */
  /*            00010001 : Archive Compression: level 2 */
  /*            00011001 : Archive Compression: level 3 */
  /*            00100001 : Archive Compression: level 4 */
  /*            00101001 : Archive Compression: level 5 */
  /*            00110001 : Archive Compression: level 6 */
  /*            00111001 : Archive Compression: level 7 */
  /*            All other bit patterns are incorrect. */
  spare3        number,                                     /* spare column  */
  /* byte 1 of spare3 stores dtydef of interval (either DTYNUM, DTYIYM, or
   *  DTYIDS)
   */
  definclcol    number,                          /* default iot include col# */
  defparameters varchar2(1000),                       /* from indpart_param$ */
  /* interval_str and interval_bival new in 11g                              */
  interval_str varchar2(1000),                   /* string of interval value */
  interval_bival raw(200),              /* binary representation of interval */
  insert_ts_list ku$_insert_ts_list_t,      /* store-in list for interval pt */
  defmaxsize    number                                    /* default MAXSIZE */
)
/

grant execute on ku$_partobj_t to public
/

-- view for partitioned objects
create or replace force view ku$_partobj_view 
  of ku$_partobj_t with object identifier (obj_num) as
  select po.obj#, po.parttype, po.partcnt,
         po.partkeycols,
         po.flags, 
         -- hoist the next 2 queries up here because po.defts# may be null
         -- and this avoids an outer join which is slooooow
         (select ts.name from ts$ ts where po.defts# = ts.ts#),
         (select ts.blocksize from ts$ ts where po.defts# = ts.ts#),
         po.defpctfree, po.defpctused, po.defpctthres,
         po.definitrans, po.defmaxtrans, po.deftiniexts, po.defextsize, 
         po.defminexts, po.defmaxexts, po.defextpct, po.deflists,
         po.defgroups, po.deflogging, po.spare1,
         -- Convert 'spare2' to a value that the pre-11.2 xsl stylesheet
         -- can process: if archive compressed and version < 11.2,
         -- turn off compression.  The block format for archive compression
         -- is not supported pre-11.2, so the compression bits must be
         -- set to NOCOMPRESS.
         case when bitand(floor(po.spare2/4294967296),8+16+32)=0 then po.spare2
              when dbms_metadata.get_version >= '11.02.00.00.00' then po.spare2
              else floor(po.spare2/4294967296) + 2*4294967296
         end,
         po.spare3,
         po.definclcol, po.parameters,
         po.interval_str, po.interval_bival,
         case when po.interval_str is not null then
          cast( multiset( select * from ku$_insert_ts_view it
                          where it.base_obj_num=po.obj#
                          order by it.base_obj_num,it.position_num
                        ) as ku$_insert_ts_list_t
              )
         else null end,
         po.defmaxsize
  from partobj$ po
/
grant select on ku$_partobj_view to select_catalog_role
/

-- ADT for partitioned tables

create or replace type ku$_tab_partobj_t as object
(
  obj_num       number,                         /* obj# of partitioned table */
  partobj       ku$_partobj_t,                     /* Base partitioning info */
  partcols      ku$_part_col_list_t,         /* list of partitioning columns */
  subpartcols   ku$_part_col_list_t,      /* list of subpartitioning columns */
  part_list     ku$_tab_part_list_t,                 /* table partition list */
  compart_list  ku$_tab_compart_list_t,    /* table composite partition list */
  tsubparts     ku$_tab_tsubpart_list_t        /* template subpartition list */
)
/
grant execute on ku$_tab_partobj_t to public
/
create or replace force view ku$_tab_partobj_view 
  of ku$_tab_partobj_t with object identifier (obj_num) as
  select po.obj_num, value(po),
         cast(multiset(select * from ku$_tab_part_col_view pc
                       where pc.obj_num = po.obj_num
                        order by pc.pos_num
                      ) as ku$_part_col_list_t
             ),
         cast(multiset(select * from ku$_tab_subpart_col_view sc
                       where sc.obj_num = po.obj_num
                        order by sc.pos_num
                      ) as ku$_part_col_list_t
             ),
         cast(multiset(select * from ku$_tab_part_view tp
                       where tp.base_obj_num = po.obj_num
                        order by tp.part_num
                      ) as ku$_tab_part_list_t
             ),
         cast(multiset(select * from ku$_tab_compart_view tcp
                       where tcp.base_obj_num = po.obj_num
                        order by tcp.part_num
                      ) as ku$_tab_compart_list_t
             ),
         cast(multiset(select * from ku$_tab_tsubpart_view ttsp
                       where ttsp.base_objnum = po.obj_num
                        order by ttsp.spart_pos
                      ) as ku$_tab_tsubpart_list_t
             )
  from ku$_partobj_view po
/
grant select on ku$_tab_partobj_view to select_catalog_role
/
-- ADT for partitioned indexes;

create or replace type ku$_ind_partobj_t as object
(
  obj_num       number,                 /* obj# of partitioned table */
  partobj       ku$_partobj_t,          /* Base partitioning info */
  partcols      ku$_part_col_list_t,         /* list of partitioning columns */
  subpartcols   ku$_part_col_list_t,      /* list of subpartitioning columns */
  part_list     ku$_ind_part_list_t,                 /* index partition list */
  compart_list  ku$_ind_compart_list_t    /* index composite partition list */
)
/
grant execute on ku$_ind_partobj_t to public
/
create or replace force view ku$_ind_partobj_view 
  of ku$_ind_partobj_t with object identifier (obj_num) as
  select po.obj_num, value(po),
         cast(multiset(select * from ku$_ind_part_col_view pc
                       where pc.obj_num = i.obj#
                        order by pc.pos_num
                      ) as ku$_part_col_list_t
             ),
         cast(multiset(select * from ku$_ind_subpart_col_view sc
                       where sc.obj_num = i.obj#
                        order by sc.pos_num
                      ) as ku$_part_col_list_t
             ),
         cast(multiset(select * from ku$_ind_part_view ip
                       where ip.base_obj_num = po.obj_num
                        order by ip.part_num
                      ) as ku$_ind_part_list_t
             ),
         cast(multiset(select * from ku$_ind_compart_view icp
                       where icp.base_obj_num = po.obj_num
                        order by icp.part_num
                      ) as ku$_ind_compart_list_t
             )
  from ind$ i, ku$_partobj_view po
        where i.obj#=po.obj_num
/
grant select on ku$_ind_partobj_view to select_catalog_role
/
-------------------------------------------------------------------------------
--                              DOMAIN INDEX
-------------------------------------------------------------------------------
-- UDT/view for domain index's secondary tables
create or replace type ku$_domidx_2ndtab_t as object
(
  obj_num       number,                            /* object number of index */
  secobj_num    number,                 /* object number of secondary object */
  schema_obj    ku$_schemaobj_t                          /* secondary object */
)
/
grant execute on ku$_domidx_2ndtab_t to public
/
create or replace type ku$_domidx_2ndtab_list_t
  as table of ku$_domidx_2ndtab_t
/
grant execute on ku$_domidx_2ndtab_list_t to public
/
create or replace force view ku$_domidx_2ndtab_view of ku$_domidx_2ndtab_t
  with object identifier (obj_num, secobj_num) as
  select s.obj#, s.secobj#, value(o)
  from sys.ku$_schemaobj_view o, sys.secobj$ s
  where o.obj_num = s.secobj#
    and o.type_num = 2
    and dbms_metadata.oktoexp_2ndary_table(s.secobj#)!= 0
/
grant select on ku$_domidx_2ndtab_view to select_catalog_role
/

-- The next view is used by dbms_metadata.oktoexp_2ndary_table

create or replace force view ku$_2ndtab_info_view (
  obj_num, index_name, index_schema, type_name, type_schema, interface_vrsn, 
  flags ) as
  select distinct 
        o.obj#, 
        o1.name, 
        u1.name,
        o2.name,
        u2.name,
        it.interface_version#,
        0
   from obj$ o, obj$ o1, obj$ o2, ind$ i, user$ u1, user$ u2, indtypes$ it,
        secobj$ s
   where o.obj#=s.secobj#
         AND o1.obj#=s.obj#
         AND o1.obj# = i.obj#
         AND i.type# = 9
         AND o1.owner# = u1.user#
         AND i.indmethod# = it.obj#
         AND o2.obj# = it.implobj#
         AND o2.owner# = u2.user#
         AND bitand(i.property, 2) != 2         /* non-partitioned */
   UNION ALL
  select o.obj#, 
        o1.name, 
        u1.name,
        o2.name,
        u2.name,
        it.interface_version#,
        DECODE(BITAND (i.property, 512), 512, 64,0)+   /*0x200=iot di*/
        DECODE(BITAND(po.flags, 1), 1, 1, 0) +          /* 1 = local */
        DECODE(po.parttype, 1, 2, 2, 4, 0)    /* 1 = range, 2 = hash */
   from obj$ o, obj$ o1, obj$ o2, ind$ i, user$ u1, user$ u2, 
        partobj$ po, indtypes$ it, secobj$ s
   where o.obj#=s.secobj#
         AND o1.obj#=s.obj#
         AND o1.obj# = i.obj#
         AND i.type# = 9
         AND o1.owner# = u1.user#
         AND i.indmethod# = it.obj#
         AND o2.obj# = it.implobj#
         AND o2.owner# = u2.user#
         AND bitand(po.flags, 8) = 8            /* domain index */
         AND po.obj# = i.obj#
         AND bitand(i.property, 2) = 2          /* partitioned */
/
grant select on ku$_2ndtab_info_view to public
/

-- ADT for domain index plsql code
create or replace type ku$_domidx_plsql_t as object
(
  obj_num       number,                 /* object # */
  plsql         ku$_procobj_lines       /* plsql code */
)
/
grant execute on  ku$_domidx_plsql_t to public
/

-- view for domain index plsql code
create or replace force view ku$_domidx_plsql_view of ku$_domidx_plsql_t
  with object identifier(obj_num) as
  select i.obj#,
        sys.dbms_metadata.get_domidx_metadata(o.name, u.name,
                o2.name, u2.name, it.interface_version#, 0)
   from obj$ o, obj$ o2, ind$ i, user$ u, user$ u2, indtypes$ it
   where i.type# = 9
         AND o.obj# = i.obj#
         AND o.owner# = u.user#
         AND i.indmethod# = it.obj#
         AND o2.obj# = it.implobj#
         AND o2.owner# = u2.user#
         AND bitand(i.property, 2) != 2         /* non-partitioned */
   UNION ALL
  select i.obj#,
        sys.dbms_metadata.get_domidx_metadata(o.name, u.name,
                o2.name, u2.name,
                it.interface_version#, 
                DECODE(BITAND (i.property, 512), 512, 64,0)+   /*0x200=iot di*/
                DECODE(BITAND(po.flags, 1), 1, 1, 0) +          /* 1 = local */
                DECODE(po.parttype, 1, 2, 2, 4, 0)    /* 1 = range, 2 = hash */
                )
   from obj$ o, obj$ o2, ind$ i, user$ u, user$ u2, partobj$ po, indtypes$ it
   where i.type# = 9
         AND o.obj# = i.obj#
         AND o.owner# = u.user#
         AND i.indmethod# = it.obj#
         AND o2.obj# = it.implobj#
         AND o2.owner# = u2.user#
         AND bitand(po.flags, 8) = 8            /* domain index */
         AND po.obj# = i.obj#
         AND bitand(i.property, 2) = 2          /* partitioned */
/
grant select on ku$_domidx_plsql_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              INDEX
-------------------------------------------------------------------------------

-- UDTs/views for bitmap join index information

create or replace type ku$_jijoin_table_t as object
(
  obj_num       number,                                          /* object # */
  tabobj_num    number,                                  /* table obj number */
  owner_name    varchar2(30),                                 /* table owner */
  name          varchar2(30)                                 /* table name  */
)
/
grant execute on ku$_jijoin_table_t to public
/
create or replace type ku$_jijoin_table_list_t as table of  ku$_jijoin_table_t
/
grant execute on ku$_jijoin_table_list_t to public
/
create or replace force view ku$_jijoin_table_view of ku$_jijoin_table_t
  with object identifier(obj_num,tabobj_num)
  as select j.obj#, o.obj_num, o.owner_name, o.name
  from sys.ku$_schemaobj_view o, sys.jijoin$ j
  where o.obj_num in (j.tab1obj#, j.tab2obj#)
  group by j.obj#, o.obj_num, o.owner_name, o.name
  order by o.obj_num
/
grant select on ku$_jijoin_table_view to select_catalog_role
/

create or replace type ku$_jijoin_t as object
(
  obj_num       number,                                          /* object # */
  tab1obj_num   number,                                /* table 1 obj number */
  tab1col_num   number,                /* internal column number for table 1 */
  tab2obj_num   number,                                /* table 2 obj number */
  tab2col_num   number,                /* internal column number for table 2 */
  tab1col       ku$_simple_col_t,                          /* table 1 column */
  tab2col       ku$_simple_col_t,                          /* table 2 column */
  joinop        number,                /* Op code as defined in opndef.h (=) */
  flags         number,                                        /* misc flags */
  tab1inst_num  number,           /* instance of table 1 (for multiple refs) */
  tab2inst_num  number            /* instance of table 2 (for multiple refs) */
)
/
grant execute on ku$_jijoin_t to public
/
create or replace type ku$_jijoin_list_t as table of ku$_jijoin_t
/
grant execute on ku$_jijoin_list_t to public
/
create or replace force view ku$_jijoin_view of ku$_jijoin_t
  with object identifier(obj_num,tab1obj_num,tab1col_num,tab2obj_num,tab2col_num)
  as select j.obj#, j.tab1obj#, j.tab1col#, j.tab2obj#, j.tab2col#,
            (select value(c) from sys.ku$_simple_col_view c
             where c.obj_num = j.tab1obj# and c.intcol_num = j.tab1col#),
            (select value(c) from sys.ku$_simple_col_view c
             where c.obj_num = j.tab2obj# and c.intcol_num = j.tab2col#),
            j.joinop, j.flags, j.tab1inst#, tab2inst#
  from sys.jijoin$ j
  order by j.tab1obj#, j.tab1col#
/
grant select on ku$_jijoin_view to select_catalog_role
/

-- UDT for indexes
create or replace type ku$_index_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                          /* object # */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  col_list      ku$_index_col_list_t,               /* list of index columns */
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  dataobj_num   number,                          /* data layer object number */
  base_obj_num  number,                                     /* base object # */
  base_obj      ku$_schemaobj_t,                              /* base object */
  anc_obj       ku$_schemaobj_t,           /* Ancestor object - if available */
  indmethod_num number,             /* object # for cooperative index method */
  indtype_name  varchar2(30),                              /* indextype name */
  indtype_owner varchar2(30),                             /* indextype owner */
  secobjs       ku$_domidx_2ndtab_list_t,                /* secondary tables */
  plsql_code    ku$_domidx_plsql_t,               /* domain index plsql code */
  jijoin_tabs   ku$_jijoin_table_list_t, /* jijoin tables if bitmap join idx */
  jijoin        ku$_jijoin_list_t,       /* jijoin data if bitmap join index */
  cols          number,                                 /* number of columns */
  pct_free      number,          /* minimum free space percentage in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                    /* maximum number of transactions */
  pct_thres     number,           /* iot overflow threshold, null if not iot */
  type_num      number,                       /* what kind of index is this? */
  flags         number,                                     /* mutable flags */
  property      number,             /* immutable flags for life of the index */
  blevel        number,                                       /* btree level */
  leafcnt       number,                                  /* # of leaf blocks */
  distkey       number,                                   /* # distinct keys */
  lblkkey       number,                          /* avg # of leaf blocks/key */
  dblkkey       number,                          /* avg # of data blocks/key */
  clufac        number,                                 /* clustering factor */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  rowcnt        number,                       /* number of rows in the index */
  intcols       number,                        /* number of internal columns */
  degree        number,           /* # of parallel query slaves per instance */
  instances     number,             /* # of OPS instances for parallel query */
  trunccnt      number,                        /* re-used for iots 'inclcol' */
  numcolsdep    number,         /* number of columns depended on, >= intcols */
  numkeycols    number,             /* # of key columns in compressed prefix */
  part_obj      ku$_ind_partobj_t,                /* null if not partitioned */
  spare3        number,
  spare4        varchar2(1000),     /* used for parameter str for domain idx */
  spare5        varchar2(1000),
  spare6        varchar2(19),
  for_pkoid     number,                     /* 1 = enabled index for a pkoid */
  for_refpar    number,      /* 1 = used for ref partition parent constraint */
  oid_or_setid  number         /* !0 = hidden unique index on OID column (1) */
                                  /* or nested tbl column's SETID column (2) */
)
/

grant execute on ku$_index_t to public
/

create or replace type ku$_index_list_t as table of ku$_index_t;
/

grant execute on ku$_index_list_t to public
/

-- view for indexes
create or replace force view ku$_all_index_view of ku$_index_t
  with object identifier(obj_num) as
  select '1','5',
         i.obj#, value(o),
         cast(multiset(select * from ku$_index_col_view ic
                       where ic.obj_num = i.obj#
                        order by ic.pos_num
                      ) as ku$_index_col_list_t
             ),
         ts.name, ts.blocksize,
         (select value(s) from ku$_storage_view s
          where i.file#  = s.file_num
          and   i.block# = s.block_num
          and   i.ts#    = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = i.obj#),
         i.dataobj#, i.bo#,
         (select value(so) from ku$_schemaobj_view so
          where so.obj_num = i.bo#),
         (select value(ao) from ku$_schemaobj_view ao
          where ao.obj_num = dbms_metadata_util.get_anc(i.bo#,0)),
         i.indmethod#,
         (select o2.name from obj$ o2 where i.indmethod# = o2.obj#),
         (select u2.name from user$ u2 
                where u2.user# = (select o3.owner# from obj$ o3
                                        where i.indmethod# = o3.obj#)),
         -- include domain index info if type# = 9 (cooperative index method)
         decode(i.type#, 9, 
           cast(multiset(select * from ku$_domidx_2ndtab_view so
                        where so.obj_num=i.obj#
                        ) as ku$_domidx_2ndtab_list_t
                ),
           null),
         decode(i.type#, 9, 
           (select value(pl) from ku$_domidx_plsql_view pl
                where pl.obj_num = i.obj#),
           null),
         -- include bitmap join index info if this is a bji
         decode(bitand(i.property, 1024), 1024,
           cast(multiset(select * from ku$_jijoin_table_view j
                        where j.obj_num = i.obj#
                        ) as ku$_jijoin_table_list_t
                ),
           null),
         decode(bitand(i.property, 1024), 1024,
           cast(multiset(select * from ku$_jijoin_view j
                        where j.obj_num = i.obj#
                        ) as ku$_jijoin_list_t
                ),
           null),
         i.cols, i.pctfree$,
         i.initrans, i.maxtrans, i.pctthres$, i.type#, i.flags, i.property,
         i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
         to_char(i.analyzetime,'YYYY/MM/DD HH24:MI:SS'), i.samplesize, i.rowcnt, i.intcols, i.degree,
         i.instances, i.trunccnt, i.spare1, i.spare2,
         (select value(po) from ku$_ind_partobj_view po
          where i.obj# = po.obj_num),
         i.spare3, replace(i.spare4, chr(0)), i.spare5, to_char(i.spare6,'YYYY/MM/DD HH24:MI:SS'),
         nvl((select 1 from cdef$ c
              where c.enabled = i.obj# and
                    c.type# = 2 and
                    (select 1 from tab$ t
                     where t.obj# = c.obj# and
                     bitand(t.property, 4096) = 4096) = 1) ,0),
         -- and index is used for reference partitioning if it is used
         --  for a primary or unique key constraint and 0x400 is set in
         --  defer (ref par parent).
         nvl((select 1 from dual where
          (exists (select 1 from cdef$ c
              where c.enabled = i.obj# and
                    c.type# in(2, 3) and
                    (bitand(c.defer,1024)!=0)))),0),
         nvl((select ic.oid_or_setid from ku$_index_col_view ic
              where i.type#=1
              and i.intcols=1
              and ic.obj_num=i.obj#),0)
   from  ku$_schemaobj_view o, ind$ i, ts$ ts
   where o.obj_num = i.obj#
         AND  i.ts# = ts.ts#
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_all_index_view to public
/

-- For 11g, allow func. indexes to be exported along with mv
create or replace force view ku$_index_view of ku$_index_t
  with object identifier(obj_num) as
    select * from ku$_all_index_view
/
grant select on ku$_index_view to public
/

-- For 10.2, restrict func. indexes from being exported along with mv
create or replace force view ku$_10_2_index_view of ku$_index_t
  with object identifier(obj_num) as
    select * from ku$_all_index_view i
        where  BITAND(i.property, 8208) != 8208      /* remove Fn Ind on MV */
/
grant select on ku$_10_2_index_view to public
/

-------------------------------------------------------------------------------
--                              CONSTRAINTS
-------------------------------------------------------------------------------
-- type for columns in constraint.  Only includes attributes
-- required to generate appropriate DDL.
create or replace type ku$_constraint_col_t as object
(
  con_num       number,                                 /* constraint number */
  obj_num       number,                      /* object number of base object */
  intcol_num    number,                            /* internal column number */
  pos_num       number,                 /* column position number as created */
  spare1        number,                       /* additional constraint flags */
  oid_or_setid  number,   /* !0 = hidden unique constraint on OID column (1) */
                                  /* or nested tbl column's SETID column (2) */
  col           ku$_simple_col_t                                   /* column */
)
/

grant execute on ku$_constraint_col_t to public
/

create or replace type ku$_constraint_col_list_t
 as TABLE of ku$_constraint_col_t;
/

-- view to get columns in a constraint.
create or replace force view ku$_constraint_col_view of ku$_constraint_col_t
  with object identifier (obj_num,intcol_num) as
  select cc.con#, cc.obj#, cc.intcol#, cc.pos#, cc.spare1,
  decode(bitand(c.property,1024+2),0,0,2,1,1024,2,0),
  decode(bitand(c.property,2097152+1024),
         2097152,(select value(c1) from ku$_simple_pkref_col_view c1
                  where c1.obj_num    = cc.obj# and
                        c1.intcol_num = cc.intcol#),
            1024,(select value(c2) from ku$_simple_setid_col_view c2
                  where c2.obj_num    = cc.obj# and
                        c2.intcol_num = cc.intcol#),
            value(c))
  from ku$_simple_col_view c, ccol$ cc
  where c.obj_num    = cc.obj#
    and c.intcol_num = cc.intcol#
/
grant select on ku$_constraint_col_view to select_catalog_role
/

grant execute on ku$_constraint_col_list_t to public
/

-- Types for non REF/pkREF table/view constraints. Based on con$ and cdef$.
--  (Does not include the spare columns in con$).
-- Ignored types: view WITH READ ONLY(6), cluster hash expr.(8), and
--                REF/pkREF (9,10,13) constraints.
-- We distinguish 3 types of table/view constraint:
-- (1) those which don't need key information to generate DDL
--     (column Not NULL, View WITH CHECK OPTION);
-- (2) those with one set of keys (columns) or a condition expression
--     (primary key, unique key, CHECK, SUpplemental Log Groups) --
--     this kind of constraint is implemented with an index for prim/unique.
--     (also includes the (keyless) Supplemental Log Data 'constraints').
-- (3) those with 2 sets of keys (columns) - referential.

create or replace type ku$_constraint0_t as object
(
  owner_num     number,                                      /* owner user # */
  name          varchar2(30),                             /* constraint name */
  con_num       number,                                 /* constraint number */
  obj_num       number,                  /* object number of base table/view */
  numcols       number,                   /* number of columns in constraint */
  contype       number,                                   /* constraint type */
  enabled       number,           /* is constraint enabled? NULL if disabled */
  intcols       number,              /* #  of internal columns in constraint */
  mtime         varchar2(19),  /* date this constraint was last enabled-disabled */
  flags         number                                              /* flags */
)
/

grant execute on ku$_constraint0_t to public
/

create or replace type ku$_constraint0_list_t as table of ku$_constraint0_t;
/

grant execute on ku$_constraint0_list_t to public
/

-- keyed/condition constraint

create or replace type ku$_constraint1_t as object
(
  owner_num     number,                                      /* owner user # */
  name          varchar2(30),                             /* constraint name */
  con_num       number,                                 /* constraint number */
  obj_num       number,                  /* object number of base table/view */
  property      number,                     /* properties of base table/view */
  numcols       number,                   /* number of columns in constraint */
  contype       number,                                   /* constraint type */
  enabled       number,           /* is constraint enabled? NULL if disabled */
  condlength    number,                 /* table check condition text length */
  condition     clob,                          /* table check condition text */
  parsed_cond   sys.xmltype,                 /* parsed table check condition */
  intcols       number,              /* #  of internal columns in constraint */
  mtime         varchar2(19), /* date this constraint was last enabled-disabled */
  flags         number,                                             /* flags */
  oid_or_setid  number,   /* !0 = hidden unique constraint on OID column (1) */
                                  /* or nested tbl column's SETID column (2) */
  col_list      ku$_constraint_col_list_t,                        /* columns */
  ind           ku$_index_t                                /* index metadata */
)
/

grant execute on ku$_constraint1_t to public
/

create or replace type ku$_constraint1_list_t as table of ku$_constraint1_t;
/

grant execute on ku$_constraint1_list_t to public
/

-- referential constraint

create or replace type ku$_constraint2_t as object
(
  owner_num     number,                                      /* owner user # */
  name          varchar2(30),                             /* constraint name */
  con_num       number,                                 /* constraint number */
  obj_num       number,                  /* object number of base table/view */
  numcols       number,                   /* number of columns in constraint */
  contype       number,                                   /* constraint type */
  robj_num      number,                 /* object number of referenced table */
  rcon_num      number,                 /* constraint# of referenced columns */
  rrules        varchar2(3),                 /* future: use this for pendant */
  match_num     number,                 /* referential constraint match type */
  refact        number,                                /* referential action */
  enabled       number,           /* is constraint enabled? NULL if disabled */
  intcols       number,              /* #  of internal columns in constraint */
  mtime         varchar2(19), /* date this constraint was last enabled-disabled */
  flags         number,                                             /* flags */
  schema_obj    ku$_schemaobj_t,                  /* referenced table object */
  src_col_list  ku$_constraint_col_list_t,                 /* source columns */
  tgt_col_list  ku$_constraint_col_list_t                  /* target columns */
)
/

grant execute on ku$_constraint2_t to public
/

create or replace type ku$_constraint2_list_t as table of ku$_constraint2_t;
/

grant execute on ku$_constraint2_list_t to public
/

-- views for constraints
-- Non keyed constraints.
create or replace force view ku$_constraint0_view of ku$_constraint0_t
   with object identifier(con_num) as
   select c.owner#, c.name, c.con#, cd.obj#, cd.cols, cd.type#,
          NVL(cd.enabled,0),
          cd.intcols, to_char(cd.mtime,'YYYY/MM/DD HH24:MI:SS'), cd.defer
   from con$ c, cdef$ cd
   where c.con# = cd.con#
     and cd.type# in (5,7,11)  -- view WITH CHECK OPTION (5)
                               -- NOT NULL on built-in datatyped column (7)
                               -- NOT NULL on ADT column (11)
/
grant select on ku$_constraint0_view to select_catalog_role
/

-- Keyed (one key list or a condition) constraints.
-- includes index metadata for primary key and unique constraints.
create or replace force view ku$_constraint1_view of ku$_constraint1_t
   with object identifier(con_num) as
   select c.owner#, c.name, c.con#, cd.obj#,
          nvl((select t.property from tab$ t where t.obj# = cd.obj#),0),
          cd.cols, cd.type#,
          nvl(cd.enabled,0),
          cd.condlength, 
          sys.dbms_metadata_util.long2clob(cd.condlength,
                                        'SYS.CDEF$',
                                        'CONDITION',
                                        cd.rowid),
          case when cd.type#=1 then
            (select sys.dbms_metadata.parse_condition(u.name,o.name,
                                                      cd.condlength,cd.rowid)
             from obj$ o, user$ u
             where o.obj#=cd.obj# and o.owner#=u.user#)
          else null end,
          cd.intcols, to_char(cd.mtime,'YYYY/MM/DD HH24:MI:SS'), nvl(cd.defer,0),
          nvl((select cc.oid_or_setid
               from ku$_constraint_col_view cc
                 where cd.type#=3
                 and cd.intcols=1
                 and cc.con_num=cd.con#),0),
          cast( multiset(select * from ku$_constraint_col_view col
                        where col.con_num = c.con#
                        order by col.pos_num
                        ) as ku$_constraint_col_list_t
                ),
          ( select value(i) from ku$_index_view i
                where i.obj_num=cd.enabled )
--              where i.schema_obj.owner_num=c.owner#
--                and i.schema_obj.name=c.name )
   from  con$ c, cdef$ cd
   where c.con# = cd.con#
     and cd.type# in (1,2,3,12,14,15,16,17)
                               -- table check (condition-no keys) (1),
                               -- primary key (2),
                               -- unique key (3),
                               -- supplemental log groups (w/ keys) (12),
                               -- supplemental log data (no keys) (14,15,16,17)
/
grant select on ku$_constraint1_view to select_catalog_role
/

-- Referential constraints
create or replace force view ku$_constraint2_view of ku$_constraint2_t
   with object identifier(con_num) as
   select c.owner#, c.name, c.con#, cd.obj#, cd.cols, cd.type#,
          cd.robj#, cd.rcon#, cd.rrules, cd.match#, cd.refact, 
          NVL(cd.enabled,0),
          cd.intcols, to_char(cd.mtime,'YYYY/MM/DD HH24:MI:SS'), cd.defer,
          (select value(o) from ku$_schemaobj_view o 
                where o.obj_num = cd.robj#),
          cast( multiset(select * from ku$_constraint_col_view col
                        where col.con_num = c.con#
                        order by col.pos_num
                        ) as ku$_constraint_col_list_t
                ),
          cast( multiset(select * from ku$_constraint_col_view col
                        where col.con_num = cd.rcon#
                        order by col.pos_num
                        ) as ku$_constraint_col_list_t
                )
   from con$ c, cdef$ cd
   where c.con# = cd.con#
     and cd.type# = 4           -- referential constraint
/
grant select on ku$_constraint2_view to select_catalog_role
/


-- REF/pkREF constraints
create or replace type ku$_pkref_constraint_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                                     /* column number */
  intcol_num    number,                            /* internal column number */
  reftyp        number,                                     /* REF type flag */
                                                     /* 0x01 = REF is scoped */
                                             /* 0x02 = REF stored with rowid */
                                             /* 0x04 = Primary key based ref */
                            /* 0x08 = Unscoped primary key based ref allowed */
  property      number,                     /* column properties (bit flags) */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000),/* name of type attr. column: null if != type */
  schema_obj    ku$_schemaobj_t,                         /* referenced table */
  foreignkey    number,               /* 1= scoped REF is also a foreign key */
  pk_col_list   ku$_simple_col_list_t   /* any pkREF refd. pkey constr. cols */
)
/
grant execute on ku$_pkref_constraint_t to public
/

create or replace type ku$_pkref_constraint_list_t
 as table of ku$_pkref_constraint_t;
/

grant execute on ku$_pkref_constraint_list_t to public
/

create or replace force view ku$_pkref_constraint_view
 of ku$_pkref_constraint_t with object identifier(obj_num, intcol_num) as
 select rf.obj#, rf.col#, rf.intcol#, rf.reftyp, c.property, c.name,
        (select a.name from attrcol$ a
                 where a.obj#=rf.obj# and a.intcol#=rf.intcol#),
        (select value(o) from ku$_schemaobj_view o, obj$ oo
                 where rf.stabid = oo.oid$
                    and oo.obj#  = o.obj_num),
        nvl((select 1
             from coltype$ fct, ccol$ fcc, cdef$ fcd  
             where fct.obj# = rf.obj# and
                   fct.intcol# = rf.intcol# and
                   fcc.obj# = rf.obj# and
                   fcc.intcol# =
                     UTL_RAW.CAST_TO_BINARY_INTEGER(
                       SUBSTRB(fct.intcol#s, 1, 2), 3) and
                   fcd.con# = fcc.con# and
                   fcd.type# = 4), 0),
        decode(bitand(rf.reftyp,4),
                       4, cast(multiset
                                (select rc.*
                                 from   ku$_simple_col_view rc, ccol$ rcc 
                                 where  rcc.con# =
                                            (select con#
                                             from   obj$ ro, cdef$ rcd
                                             where  ro.oid$ = rf.stabid and
                                                    rcd.obj# = ro.obj# and
                                                    rcd.type# = 2)       and
                                          rc.obj_num = rcc.obj# and
                                          rc.intcol_num = rcc.intcol#
                                  order by rcc.pos#
                                ) as ku$_simple_col_list_t),
                       null)
 from refcon$ rf, col$ c
 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
/
grant select on ku$_pkref_constraint_view to select_catalog_role
/

create or replace type ku$_constraint_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  con_num       number,                                 /* constraint number */
  owner_name    varchar2(30),                         /* owner of constraint */
  name          varchar2(30),                          /* name of constraint */
  flags         number,                                             /* flags */
  type_num      number,                                  /* constraint type: */
                            /* 1 = table check, 2 = primary key, 3 = unique, */
                             /* 4 = referential, 5 = view with CHECK OPTION, */
                                                 /* 6 = view READ ONLY check */
               /* 7 - table check constraint associated with column NOT NULL */
                                   /* 8 - hash expressions for hash clusters */
                                         /* 9 - Scoped REF column constraint */
                                    /* 10 - REF column WITH ROWID constraint */
                                  /* 11 - REF/ADT column with NOT NULL const */
                                 /* 12 - Log Groups for supplemental logging */
                                    /* 14 - Primary key supplemental logging */
                                     /* 15 - Unique key supplemental logging */
                                    /* 16 - Foreign key supplemental logging */
                                     /* 17 - All column supplemental logging */
  base_obj_num  number,                                     /* base object # */
  base_obj      ku$_schemaobj_t,            /* base table/view schema object */
  col           ku$_simple_col_t,        /* column info for con 0 constraint */
  con0          ku$_constraint0_t,                       /* con 0 constraint */
  con1          ku$_constraint1_t                        /* con 1 constraint */
)
/
grant execute on ku$_constraint_t to public
/

create or replace force view ku$_constraint_view
  of ku$_constraint_t with object identifier(con_num) as
  select '1', '2',
         c.con#,
         u.name,
         c.name, cd.defer, cd.type#, cd.obj#,
         (select value(sov) from ku$_schemaobj_view sov
          where sov.obj_num=cd.obj#),
         (select value(col) from ku$_simple_col_view col, sys.ccol$ cc
          where col.obj_num=cd.obj#
          and cc.obj#=cd.obj#
          and cc.con#=c.con#
          and cc.intcol#=col.intcol_num
          and cd.type# in (7,11)             /* not null constr*/
          and bitand(col.property,1+32)=0),  /* not adt attr and hidden col */
         (select value(con) from ku$_constraint0_view con
          where  con.con_num = c.con#),
         (select value(con) from ku$_constraint1_view con
          where  con.con_num = c.con#)
  from  obj$ o, con$ c, cdef$ cd, user$ u 
  where cd.obj# = o.obj# and
        c.con# = cd.con# and
        u.user# = c.owner# and
        cd.type# in (1,2,3,7,11,12,14,15,16,17)
                                   -- table check (1), primary key (2),
                                   -- unique key (3),
                                   -- not null (7),
                                   -- ref/udt col with not-null (11),
                                   -- supplemental log groups (12),
                                   -- supplemental log data (14,15,16,17)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_constraint_view to public
/

-- For stand alone (ALTER TABLE) referential (foreign key) constraints
create or replace type ku$_ref_constraint_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  con_num       number,                                 /* constraint number */
  owner_name    varchar2(30),                         /* owner of constraint */
  name          varchar2(30),                          /* name of constraint */
  flags         number,                                             /* flags */
  base_obj_num  number,                                     /* base object # */
  base_obj      ku$_schemaobj_t,            /* base table/view schema object */
  con2          ku$_constraint2_t                       /* type 2 constraint */
)
/
grant execute on ku$_ref_constraint_t to public
/

create or replace force view ku$_ref_constraint_view
  of ku$_ref_constraint_t with object identifier(con_num) as
  select '1', '1',
         c.con#,
         u.name,
         c.name, cd.defer, cd.obj#,
         (select value(sov) from ku$_schemaobj_view sov
          where sov.obj_num=cd.obj#),
         value(con)
  from  obj$ o, con$ c, cdef$ cd, user$ u,
        ku$_constraint2_view con
  where cd.obj# = o.obj# and
        c.con# = cd.con# and
        u.user# = c.owner# and
        con.con_num = c.con# and
        (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_ref_constraint_view to public
/

-- Import: Get hidden id constraints - name needed for ENABLE
create or replace type ku$_find_hidden_cons_t as object
(
  con_num       number,                                 /* constraint number */
  constr_name   varchar2(30),                             /* constraint name */
  owner_name    varchar2(30),                           /* object owner name */
  table_name    varchar2(30),                 /* object ([nested]table) name */
  intcol_num    number                   /* OID/SETID internal column number */
)
/
grant execute on ku$_find_hidden_cons_t to public
/

create or replace force view ku$_find_hidden_cons_view
  of ku$_find_hidden_cons_t with object identifier(con_num) as
  select  cd.con#, cn.name, u.name, o.name, cc.intcol#
  from    sys.obj$ o, sys.user$ u, sys.con$ cn, sys.ccol$ cc,
          sys.cdef$ cd, sys.col$ c
  where   cd.type#=3
          and cd.intcols=1
          and cn.con#=cd.con#
          and cc.con#=cd.con#
          and c.obj#=cd.obj#
          and c.intcol#=cc.intcol#
          and BITAND(c.property,1026)!=0
          and o.obj#=cd.obj#
          and u.user# = cn.owner#
          and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR
                 EXISTS ( SELECT * FROM sys.session_roles 
                          WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_find_hidden_cons_view to public
/

---
-------------------------------------------------------------------------------
--                              PRIMITIVE COLUMNS
-------------------------------------------------------------------------------

-- ADT for primitive columns (with builtin datatypes that are not LOBs)
create or replace type ku$_prim_column_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                          /* column number as created */
  intcol_num    number,                            /* internal column number */
  segcol_num    number,                          /* column number in segment */
  property      number,                     /* column properties (bit flags) */
  name          varchar2(30),                              /* name of column */
  type_num      number,                               /* data type of column */
  length        number,                         /* length of column in bytes */
  precision_num number,                                         /* precision */
  scale         number,                                             /* scale */
  not_null      number,                               /* 0 = nulls permitted */
                                                 /* > 0 = no NULLs permitted */
  deflength     number,                   /* default value expr. text length */
  default_val   varchar2(4000),             /* default value expression text */
  parsed_def    sys.xmltype,                    /* parsed default expression */
  binarydefval  varchar2(4000),          /* default replace null with clause */
  charsetid     number,                              /* NLS character set id */
  charsetform   number,                 
  base_intcol_num number,               /* for consistency with ku$_column_t */
  base_col_type number,                 /* for consistency with ku$_column_t */
  base_col_name varchar2(30),           /* for consistency with ku$_column_t */
  con           ku$_constraint0_t,                    /* not null constraint */
  spare1        number,                      /* fractional seconds precision */
  spare2        number,                  /* interval leading field precision */
  spare3        number,                 
  spare4        varchar2(1000),          /* NLS settings for this expression */
  spare5        varchar2(1000),
  spare6        varchar2(19)
)
/

grant execute on ku$_prim_column_t to public
/

create or replace type ku$_prim_column_list_t
 as table of ku$_prim_column_t
/
grant execute on ku$_prim_column_list_t to public
/

-- view to get all primitive columns (columns that are not LOBs or UDTs).
-- Each column has a constraint ADT embedded in it
-- if the column has a not-null constraint.  If there is no such constraint,
-- the constraint attribute evaluates to null.  Other constraints on columns
-- are in the table UDT.
create or replace force view ku$_prim_column_view of ku$_prim_column_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#, c.col#, c.intcol#, c.segcol#, c.property,
         c.name, c.type#, c.length,
         c.precision#, c.scale, c.null$, c.deflength,
         sys.dbms_metadata_util.long2varchar(c.deflength,
                                        'SYS.COL$',
                                        'DEFAULT$',
                                        c.rowid),
         case 
           when c.deflength is null or bitand(c.property,32+65536)=0
           then null
           else
             (select sys.dbms_metadata.parse_default(u.name,o.name,
                                                     c.deflength, c.rowid)
              from obj$ o, user$ u
              where o.obj#=c.obj# and o.owner#=u.user#)
         end,
         sys.dbms_metadata_util.binary2varchar(c.obj#,c.intcol# ),
         c.charsetid, c.charsetform,
         c.intcol#,0,NULL,
         ( select value(cv)
             from ku$_constraint_col_view ccv, ku$_constraint0_view cv
             where c.intcol# = ccv.intcol_num
             and c.obj# = ccv.obj_num
             and ccv.con_num = cv.con_num
             and cv.contype in (7,11)
         ),
         c.spare1, c.spare2, c.spare3, c.spare4, c.spare5, 
         to_char(c.spare6,'YYYY/MM/DD HH24:MI:SS')
  from col$ c
/
grant select on ku$_prim_column_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              TYPED COLUMNS
-------------------------------------------------------------------------------

-- UDTs for typed columns

create or replace type ku$_subcoltype_t as object
(
  obj_num       number,                               /* obj# of base object */
  intcol_num    number,                            /* internal column number */
  toid          raw(16),                                             /* toid */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  version       number,                      /* internal type version number */
  hashcode      raw(17),                                 /* Version hashcode */
  typeid        raw(16), /* short typeid value (for non final and sub types) */
  intcols       number,                        /* number of internal columns */
                                          /* storing the exploded ADT column */
  intcol_nums   raw(2000),            /* list of intcol#s of columns storing */
                          /* the unpacked ADT column; stored in packed form; */
                                          /* each intcol# is stored as a ub2 */
  flags         number)                                            /* flags */
                          /* 0x01 - This type was stated in the IS OF clause */
                          /* 0x02 - This type has ONLY in the IS OF clause   */
/
grant execute on ku$_subcoltype_t to public
/
create or replace type ku$_subcoltype_list_t as table of ku$_subcoltype_t
/
grant execute on ku$_subcoltype_list_t to public
/

create or replace force view ku$_subcoltype_view of ku$_subcoltype_t
  with object identifier (obj_num,intcol_num,toid) as
  select sct.obj#, sct.intcol#,
         sct.toid,
         value(o),           /* always get schema object */
         t.version#, 
         sys.dbms_metadata.get_hashcode(o.owner_name,o.name),
         t.typeid,
         sct.intcols, sct.intcol#s, sct.flags
    from ku$_schemaobj_view o, type$ t, subcoltype$ sct
    where o.oid=sct.toid 
      and o.oid=t.toid
      and t.toid=t.tvoid     /* only the latest type */
/
grant select on ku$_subcoltype_view to select_catalog_role
/

create or replace type ku$_coltype_t as object
(
  obj_num       number,                               /* obj# of base object */
  col_num       number,                                     /* column number */
  intcol_num    number,                            /* internal column number */
  flags         number,                                             /* flags */
  toid          raw(16),                                             /* toid */
  version       number,                      /* internal type version number */
  packed        number,                          /* 0 = unpacked, 1 = packed */
  intcols       number,                        /* number of internal columns */
                                          /* storing the exploded ADT column */
  intcol_nums   raw(2000),            /* list of intcol#s of columns storing */
                          /* the unpacked ADT column; stored in packed form; */
                                          /* each intcol# is stored as a ub2 */
  hashcode      raw(17),                                 /* Version hashcode */
  has_tstz      char(1),        /* 'Y' = this is a varray with TSTZ elements */
  typidcol_num  number,           /* intcol# of the type discriminant column */
  synobj_num    number,              /* obj# of type synonym of the col type */
  syn_name      varchar2(30),                       /* type synonym (if any) */
  syn_owner     varchar2(30),                               /* synonym owner */
  subtype_list  ku$_subcoltype_list_t,                   /* subtype metadata */
  schema_obj    ku$_schemaobj_t                             /* schema object */
)
/
grant execute on ku$_coltype_t to public
/

-- view for typed column metadata
create or replace force view ku$_coltype_view
  of ku$_coltype_t with object identifier(obj_num, intcol_num) as
  select ct.obj#, ct.col#, ct.intcol#, ct.flags, ct.toid,
         ct.version#, ct.packed, ct.intcols, ct.intcol#s,
         (select sys.dbms_metadata.get_hashcode(o.owner_name,o.name)
                 from ku$_schemaobj_view o, obj$ oo
                 where ct.toid = oo.oid$
                 and o.obj_num = oo.obj#),
         (select sys.dbms_metadata_util.has_tstz_elements(o.owner_name,o.name)
                 from ku$_schemaobj_view o, obj$ oo
                 where ct.toid = oo.oid$
                 and o.obj_num = oo.obj#),
         ct.typidcol#, ct.synobj#,
         (select sy.name from obj$ sy where sy.obj#=ct.synobj#),
         (select u.name from user$ u, obj$ o 
          where o.obj#=ct.synobj# and u.user#=o.owner#),
         /* look up stuff in subcoltype$ only if column is substitutable */
         decode(bitand(ct.flags, 512), 512,
           cast(multiset(select sct.* from ku$_subcoltype_view sct
                where ct.obj#    = sct.obj_num
                and   ct.intcol# = sct.intcol_num
                       ) as ku$_subcoltype_list_t
                ),
           null),
        (select value(o) from ku$_schemaobj_view o, obj$ oo
         where ct.toid = oo.oid$
         and o.obj_num = oo.obj#)
    from coltype$ ct
/

grant select on ku$_coltype_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              XML SCHEMA / OPAQUE TYPE
-------------------------------------------------------------------------------

-- For reasons having to do with compatibility, the XDB objects
-- can't be created by catproc.sql; they must instead be created
-- by a separate script catqm.sql.  Since catmeta.sql is run
-- by catproc.sql, we here create real UDTs for ku$_xmlschema_t
-- and ku$_xmlschema_elmt_t but the corresponding object views
-- are fake.  The real object views are defined in catmetx.sql
-- which is invoked by catqm.sql.

-- UDT for XML Schema
create or replace type ku$_xmlschema_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  owner_num     number,                                 /* owner user number */
  owner_name    varchar2(30 char),                             /* owner name */
  url           varchar2(700 char),                            /* schema URL */
-- The int_objname will be needed when Data Pump supports XML schemas
-- Fetched by (see catxdbv.sql)
--   xdb.xdb$Extname2Intname(s.xmldata.schema_url,s.xmldata.schema_owner)
--  int_objname varchar2(30),                         /* object name in obj$ */
  schemaoid     raw(16),                                       /* schema OID */
  local         number,        /* used as flags: 1 = set if local            */
                               /*                2 = set if stored as binary */
  schema_level  number,          /* depth of dependence on other xml schemas */
  schema_val    clob,                                /* the XMLSchema itself */
  stripped_val  clob                 /* the XMLSchema with username stripped */
)
/
grant execute on ku$_xmlschema_t to public
/
-- fake object view
-- Need to specify a clob (versus NULL for the clobs, else an ora-00932
-- error occurs if you try to do a select of stripped_val or schema_val from
-- this view before xdb is installed. It works fine after xdb is installed.
create or replace force view ku$_xmlschema_view of ku$_xmlschema_t
  with object identifier (owner_name, url) as 
  select '1','0', 0, NULL, NULL, NULL, 0, 0, et.param_clob, et.param_clob
    from dual, sys.external_tab$ et where 1=0
/
grant select on ku$_xmlschema_view to public
/

create or replace force view ku$_exp_xmlschema_view of ku$_xmlschema_t
  with object identifier (owner_name, url) as 
  select '1','0', 0, NULL, NULL, NULL, 0, 0, et.param_clob, et.param_clob
    from dual, sys.external_tab$ et where 1=0
/
grant select on ku$_exp_xmlschema_view to public
/

-- UDT for XML Schema element in opaque column
create or replace type ku$_xmlschema_elmt_t as object
(
  schemaoid     raw(16),                                   /* schema oid col */
  xmlschema     varchar2(700),                     /* The name of the schema */
  elemnum       number,                                    /* element number */
  element_name  varchar2(256)                     /* The name of the element */
)
/
grant execute on ku$_xmlschema_elmt_t to public
/
-- fake object view
create or replace view ku$_xmlschema_elmt_view
  of ku$_xmlschema_elmt_t with object identifier(schemaoid, elemnum) as
  select NULL, NULL, 0, NULL  
    from dual where 1=0
/
grant select on ku$_xmlschema_elmt_view to select_catalog_role
/

-- Special view with xml document for a dummy xmlschema which is used by
-- Data Pump import and the metadata API to generate a special
-- registerschema call with bind arguments, versus the standard call
-- with the .xsd document as a string. This is necessary to handle .xsd
-- documents which exceed 32kb in size.

create or replace force view ku$_xmlschema_special_view as select 
'<?xml version="1.0"?><ROWSET><ROW> <XMLSCHEMA_T> <VERS_MAJOR>1</VERS_MAJOR> <VERS_MINOR>0 </VERS_MINOR> </XMLSCHEMA_T> </ROW></ROWSET>'
xmlschema_xml_doc from dual
/
grant select on ku$_xmlschema_special_view to public
/

-- UDT for opaque type
create or replace type ku$_opqtype_t as object
(
  obj_num       number,                               /* obj# of base object */
  intcol_num    number,                            /* internal column number */
  type          number,                            /* The opaque type - type */
                                                           /* 0x01 - XMLType */
  flags         number,                         /* flags for the opaque type */
                              /* -------------- XMLType flags ---------
                               * 0x0001 (1) -- XMLType stored as object
                               * 0x0002 (2) -- XMLType schema is specified
                               * 0x0004 (4) -- XMLType stored as lob 
                               * 0x0008 (8) -- XMLType stores extra column
                               * 
                               * 0x0020 (32)-- XMLType table is out-of-line 
                               * 0x0040 (64)-- XMLType stored as binary
                               * 0x0080 (128)- XMLType binary ANYSCHEMA
                               * 0x0100 (256)- XMLType binary NO non-schema
                               */
  /* Flags for XMLType (type == 0x01). Override them when necessary  */
  lobcol        number,                                        /* lob column */
  objcol        number,                                    /* obj rel column */
  extracol      number,                                    /* extra info col */
  schemaoid     raw(16),                                   /* schema oid col */
  elemnum       number,                                    /* element number */
  schema_elmt   ku$_xmlschema_elmt_t
)
/
grant execute on ku$_opqtype_t to public
/
create or replace force view ku$_opqtype_view of ku$_opqtype_t
  with object identifier(obj_num, intcol_num) as
  select opq.obj#, opq.intcol#, opq.type, opq.flags, opq.lobcol,
         opq.objcol, opq.extracol, opq.schemaoid, opq.elemnum,
         decode(bitand(opq.flags,2),0,NULL,
           (select value (xe) from ku$_xmlschema_elmt_view xe
                where opq.schemaoid = xe.schemaoid
                  and opq.elemnum   = xe.elemnum))
  from sys.opqtype$ opq
/
grant select on ku$_opqtype_view to select_catalog_role
/

------------------------------------------------------------------------------
--              bug 6938028: Database Vault Protected Schema.
--              Database Vault Protected Schema (DVPS) Interface
--                       for Datapump export/import
--
-- The real Database Vault object views can't be created by catproc.sql; they 
-- must instead be created during the Database Vault installation, because
-- they must be created within the Protected Schema.  Since catmeta.sql is 
-- run by catproc.sql, here we create dummy UDTs (with the names:
-- ku$_dummy_isr_t, ku$_dummy_isrm_t, ku$_dummy_realm_t, 
-- ku$_dummy_realm_member_t, ku$_dummy_realm_auth_t, ku$_dummy_rule_t,
-- ku$_dummy_rule_set_t, ku$_dummy_rule_set_member_t, 
-- ku$_dummy_command_rule_t, ku$_dummy_role_t, ku$_dummy_factor_t,
-- ku$_dummy_factor_link_t, ku$_dummy_factor_type_t, ku$_dummy_identity_t 
-- and ku$_dummy_identity_map_t) and the corresponding dummy object views.
-- The real object views are defined in catmacc.sql, which is invoked by 
-- the Database Vault installation, and are registered in metaview$ by
-- $SRCHOME/rdbms/admin/catmacdd.sql.
-- Note: it's necessary to grant select privilege to the SELECT_CATALOG_ROLE,
-- otherwise the short regression will fail when tkzdicz1.sql runs. This
-- privilege will not be granted on the real views (created by catmacc.sql),
-- as they myst remain accessible only to users with the DV_OWNER role.
------------------------------------------------------------------------------
create or replace type ku$_dummy_isr_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1)                              /* UDT minor version # */
)
/
grant execute on ku$_dummy_isr_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_isr_view
       of ku$_dummy_isr_t
  with object identifier (vers_major) as
  select '0','0'
    from dual
   where 1=0      -- return 0 rows, indicating no Import Staging Realm exists
/

show errors;

grant select on ku$_dummy_isr_view to select_catalog_role
/

-- The attribute "schema_name" must be included in type ku$_dummy_isrm_t,
-- as we have an entry in the metafilter$ table for the 
-- DVPS_STAGING_REALM_MEMBERSHIP type.
create or replace type ku$_dummy_isrm_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  schema_name   varchar2(30)     /* schema to be protected by Staging Realm */
)
/
grant execute on ku$_dummy_isrm_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_isrm_view
       of ku$_dummy_isrm_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_isrm_view to select_catalog_role
/

-- The attribute "name" must be included in type ku$_dummy_realm_t,
-- as we have an entry in the metafilter$ table for the DVPS_REALM type.
create or replace type ku$_dummy_realm_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  name          varchar2(90)                /* name of database vault realm */
)
/
grant execute on ku$_dummy_realm_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_realm_view
       of ku$_dummy_realm_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_realm_view to select_catalog_role
/

-- The attribute "name" must be included in type ku$_dummy_realm_member_t,
-- as we have an entry in the metafilter$ table for 
-- the DVPS_REALM_MEMBERSHIP type.
create or replace type ku$_dummy_realm_member_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  name          varchar2(90)                /* name of database vault realm */
)
/
grant execute on ku$_dummy_realm_member_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_realm_member_view
       of ku$_dummy_realm_member_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_realm_member_view to select_catalog_role
/

-- The attribute "realm_name" must be included in type ku$_dummy_realm_auth_t,
-- as we have an entry in the metafilter$ table for 
-- the DVPS_REALM_AUTHORIZATION type.
create or replace type ku$_dummy_realm_auth_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  realm_name    varchar2(90)                /* name of database vault realm */
)
/
grant execute on ku$_dummy_realm_auth_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_realm_auth_view
       of ku$_dummy_realm_auth_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_realm_auth_view to select_catalog_role
/

-- The attribute "rule_name" must be included in type ku$_dummy_rule_t,
-- as we have an entry in the metafilter$ table for the DVPS_RULE type.
create or replace type ku$_dummy_rule_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  rule_name     varchar2(90)                                /* name of Rule */
)
/
grant execute on ku$_dummy_rule_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_rule_view
       of ku$_dummy_rule_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_rule_view to select_catalog_role
/

-- Attribute "rule_set_name" must be included in type ku$_dummy_rule_set_t,
-- as we have an entry in the metafilter$ table for the DVPS_RULE_SET type.
create or replace type ku$_dummy_rule_set_t as object
(
  vers_major      char(1),                           /* UDT major version # */
  vers_minor      char(1),                           /* UDT minor version # */
  rule_set_name   varchar2(90)                          /* name of Rule Set */
)
/
grant execute on ku$_dummy_rule_set_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_rule_set_view
       of ku$_dummy_rule_set_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_rule_set_view to select_catalog_role
/

-- The attribute "rule_set_name" must be included in 
-- type ku$_dummy_rule_set_member_t, as we have an entry in 
-- the metafilter$ table for the DVPS_RULE_SET_MEMBERSHIP type.
create or replace type ku$_dummy_rule_set_member_t as object
(
  vers_major      char(1),                           /* UDT major version # */
  vers_minor      char(1),                           /* UDT minor version # */
  rule_set_name   varchar2(90)                          /* name of Rule Set */
)
/
grant execute on ku$_dummy_rule_set_member_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_rule_set_member_view
       of ku$_dummy_rule_set_member_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_rule_set_member_view to select_catalog_role
/

-- The attribute "rule_set_name" must be included in 
-- type ku$_dummy_command_rule_t, as we have an entry in 
-- the metafilter$ table for the DVPS_COMMAND_RULE type.
create or replace type ku$_dummy_command_rule_t as object
(
  vers_major      char(1),                           /* UDT major version # */
  vers_minor      char(1),                           /* UDT minor version # */
  rule_set_name   varchar2(90)                          /* name of Rule Set */
)
/
grant execute on ku$_dummy_command_rule_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_command_rule_view
       of ku$_dummy_command_rule_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_command_rule_view to select_catalog_role
/

-- The attribute "role" must be included in
-- type ku$_dummy_role_t, as we have an entry in
-- the metafilter$ table for the DVPS_ROLE type.
create or replace type ku$_dummy_role_t as object
(
  vers_major           char(1),                      /* UDT major version # */
  vers_minor           char(1),                      /* UDT minor version # */
  role                 varchar2(30)                            /* Role name */
)
/
grant execute on ku$_dummy_role_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_role_view
       of ku$_dummy_role_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual
   where 1=0      -- return 0 rows
/

grant select on ku$_dummy_role_view to select_catalog_role
/

-- The attribute "factor_name" must be included in 
-- type ku$_dummy_factor_t, as we have an entry in 
-- the metafilter$ table for the DVPS_FACTOR type.
create or replace type ku$_dummy_factor_t as object
(
  vers_major           char(1),                      /* UDT major version # */
  vers_minor           char(1),                      /* UDT minor version # */
  factor_name          varchar2(30)                          /* Factor name */
)
/
grant execute on ku$_dummy_factor_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_factor_view
       of ku$_dummy_factor_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual 
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_factor_view to select_catalog_role
/ 

-- The attribute "parent_factor_name" must be included in 
-- type ku$_dummy_factor_link_t, as we have an entry in 
-- the metafilter$ table for the DVPS_FACTOR_LINK type.
create or replace type ku$_dummy_factor_link_t as object
(
  vers_major           char(1),                      /* UDT major version # */
  vers_minor           char(1),                      /* UDT minor version # */
  parent_factor_name   varchar2(30)                   /* Parent Factor name */
)
/
grant execute on ku$_dummy_factor_link_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_factor_link_view
       of ku$_dummy_factor_link_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual 
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_factor_link_view to select_catalog_role
/ 

-- The attribute "name" must be included in 
-- type ku$_dummy_factor_type_t, as we have an entry in 
-- the metafilter$ table for the DVPS_FACTOR_TYPE type.
create or replace type ku$_dummy_factor_type_t as object
(
  vers_major           char(1),                      /* UDT major version # */
  vers_minor           char(1),                      /* UDT minor version # */
  name                 varchar2(90)                     /* Factor type name */
)
/
grant execute on ku$_dummy_factor_type_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_factor_type_view
       of ku$_dummy_factor_type_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual 
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_factor_type_view to select_catalog_role
/ 

-- The attribute "factor_name" must be included in 
-- type ku$_dummy_identity_t, as we have an entry in 
-- the metafilter$ table for the DVPS_IDENTITY type.
create or replace type ku$_dummy_identity_t as object
(
  vers_major           char(1),                      /* UDT major version # */
  vers_minor           char(1),                      /* UDT minor version # */
  factor_name          varchar2(30)                     /* Factor type name */
)
/
grant execute on ku$_dummy_identity_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_identity_view
       of ku$_dummy_identity_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual 
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_identity_view to select_catalog_role
/ 

-- The attribute "identity_factor_name" must be included in 
-- type ku$_dummy_identity_map_t, as we have an entry in 
-- the metafilter$ table for the DVPS_IDENTITY_MAP type.
create or replace type ku$_dummy_identity_map_t as object
(
  vers_major               char(1),                  /* UDT major version # */
  vers_minor               char(1),                  /* UDT minor version # */
  identity_factor_name     varchar2(30)            /* Factor the map is for */
)
/
grant execute on ku$_dummy_identity_map_t to public
/

-- bug 6938028: Dummy object view for Database Vault Protected Schema.
create or replace force view ku$_dummy_identity_map_view
       of ku$_dummy_identity_map_t
  with object identifier (vers_major) as
  select '0','0',NULL
    from dual 
   where 1=0      -- return 0 rows
/

show errors;

grant select on ku$_dummy_identity_map_view to select_catalog_role
/ 
-------------------------------------------------------------------------------
--         view to identify xmlschemas for tables 
--          (for tablespace transportable of xmltype tables)
-------------------------------------------------------------------------------
create or replace force view ku$_table_xmlschema_view as
  select opq.obj#, opq.schemaoid
  from sys.opqtype$ opq
/
grant select on ku$_table_xmlschema_view  to select_catalog_role
/

-------------------------------------------------------------------------------
--                              OID INDEX
-------------------------------------------------------------------------------

-- ADT for OID index (for object tables)
create or replace type ku$_oidindex_t as object
(
  obj_num       number,                              /* obj# of owning table */
  intcol_num    number,                            /* internal column number */
  name          varchar2(30),                                  /* index name */
  flags         number,                     /* psuedo constraint defer flags */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number                      /* maximum number of transaction */
)
/

grant execute on ku$_oidindex_t to public
/

-- view for OID index
create or replace force view ku$_oidindex_view
  of ku$_oidindex_t with object identifier(obj_num, intcol_num) as
       select i.bo#, ic.intcol#, o.name,
              decode(substr(o.name,1,5),'SYS_C',8,0),     -- mimic constr defer
              ( select value(s) 
                from ku$_storage_view s
                where i.file#  = s.file_num
                and   i.block# = s.block_num
                and   i.ts#    = s.ts_num),
              (select value(s) from ku$_deferred_stg_view s
               where s.obj_num = i.obj#),
              ts.name, ts.blocksize,
              i.pctfree$,i.initrans,i.maxtrans
       from   sys.obj$ o, sys.ind$ i, sys.icol$ ic, sys.ts$ ts
       where  i.type# = 1
              and i.intcols = 1
              and ic.obj# = i.obj#
              and ic.intcol# = (select c.intcol#   -- Only 1 OID col per table
                                from sys.col$ c
                                where c.obj#=i.bo#
                                and bitand(c.property,2)=2)
              and o.obj# = i.obj#
              and ts.ts# = i.ts#
/

grant select on ku$_oidindex_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              COLUMNS
-------------------------------------------------------------------------------

-- ADT for columns
create or replace type ku$_column_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                          /* column number as created */
  segcol_num    number,                          /* column number in segment */
  segcollength  number,                      /* length of the segment column */
  offset        number,                                  /* offset of column */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000),/* name of type attr. column: null if != type */
  fullattrname  varchar2(4000),      /* expanded attrname for DTYNAR columns */
  type_num      number,                               /* data type of column */
  length        number,                         /* length of column in bytes */
  fixedstorage  number,             /* flags: 0x01 = fixed, 0x02 = read-only */
  precision_num number,                                         /* precision */
  scale         number,                                             /* scale */
  not_null      number,                               /* 0 = nulls permitted */
                                                 /* > 0 = no NULLs permitted */
  deflength     number,                   /* default value expr. text length */
  default_val   varchar2(4000),             /* default value expression text */
  parsed_def    sys.xmltype,                    /* parsed default expression */
  binarydefval  varchar2(4000),          /* default replace null with clause */
  intcol_num    number,                            /* internal column number */
  base_intcol_num number,    /* internal column number of base column, i.e., */
                           /* the intcol# of the first column with this col# */
  base_col_type number, /* base column type: 1 = UDT, 2 = XMLType OR or CSX, */
                        /*                   3 = XMLType as CLOB,  0 = other */
  base_col_name varchar2(30),      /* for any xmltype, name of xmltype column*/
  property      number,                     /* column properties (bit flags) */
  charsetid     number,                              /* NLS character set id */
  charsetform   number,                 
  con           ku$_constraint0_t,                    /* not null constraint */
  typemd        ku$_coltype_t,     /* type metadata. null if not a typed col */
  lobmd         ku$_lob_t,            /* lob metadata. null if not a lob col */
  opqmd         ku$_opqtype_t,   /* opaque metadata. null if not type opaque */
  oidindex      ku$_oidindex_t,   /*oidindex if col is OID$ col of obj table */
  spare1        number,                      /* fractional seconds precision */
  spare2        number,                  /* interval leading field precision */
  spare3        number,                 
  spare4        varchar2(1000),          /* NLS settings for this expression */
  spare5        varchar2(1000),
  spare6        varchar2(19)
)
/
grant execute on ku$_column_t to public
/

create or replace type ku$_column_list_t as table of ku$_column_t;
/
grant execute on ku$_column_list_t to public
/

-- view to get all columns.  Each column has a constraint ADT embedded in it
-- if the column has a not-null constraint.  If there is no such constraint,
-- the constraint attribute evaluates to null.  Other constraints on columns
-- are in the table ADT.
create or replace force view ku$_column_view of ku$_column_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#, c.col#, c.segcol#,
         c.segcollength, c.offset, c.name,
         sys.dbms_metadata_util.get_attrname( 
                        c.obj#, c.intcol#), 
         sys.dbms_metadata_util.get_fullattrname( 
                        c.obj#, c.col#, c.intcol#, c.type#), 
         c.type#, c.length, c.fixedstorage,
         c.precision#, c.scale, c.null$, c.deflength,
         sys.dbms_metadata_util.long2varchar(c.deflength,
                                        'SYS.COL$',
                                        'DEFAULT$',
                                        c.rowid),
         case 
           when c.deflength is null or bitand(c.property,32+65536)=0
           then null
           else
             (select sys.dbms_metadata.parse_default(u.name,o.name,
                                                     c.deflength, c.rowid)
              from obj$ o, user$ u
              where o.obj#=c.obj# and o.owner#=u.user#)
         end,
         sys.dbms_metadata_util.binary2varchar(c.obj#,c.intcol#),
         c.intcol#,
         case c.col# when c.intcol# then c.intcol#
          else sys.dbms_metadata_util.get_base_intcol_num(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         case c.col# when c.intcol# then 0
          else 
            sys.dbms_metadata_util.get_base_col_type(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         case c.col# when c.intcol# then NULL
          else 
            sys.dbms_metadata_util.get_base_col_name(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         c.property, c.charsetid, c.charsetform,
         ( select value(cv)
             from ku$_constraint0_view cv, ku$_constraint_col_view ccv
             where c.intcol# = ccv.intcol_num
             and c.obj# = ccv.obj_num
             and ccv.con_num = cv.con_num
             and cv.contype in (7,11)
         ),
         ( select value(ctv)
             from ku$_coltype_view ctv
             where c.type# in ( 121,    -- DTYADT  (user-defined type)
                                122,    -- DTYNTB  (nested table)
                                123,    -- DTYNAR  (varray)
                                111,    -- DTYIREF (REF)
                                 58)    -- DTYOPQ  (opaque type)
             and   c.obj#  = ctv.obj_num
             and   c.intcol# = ctv.intcol_num
         ),
         ( select value(lv)
             from ku$_lob_view lv
             where (c.type# in (112,    -- CLOB
                                113,    -- BLOB
                                123)    -- DTYNAR  (varray)
                    and   c.obj#  = lv.obj_num
                    and   c.intcol# = lv.intcol_num)
             or    (c.type# = 58        -- DTYOPQ (XML type)
                    and   c.obj#  = lv.obj_num 
                    and   lv.intcol_num = 
                          (select op.lobcol from sys.opqtype$ op
                                    where op.obj# = c.obj#
                                    and   bitand(op.flags,4) != 0
                                    and   op.intcol# = c.intcol#)
                    )
             or    (c.type# = 58        -- DTYOPQ (opaque type)
                    and   c.obj#  = lv.obj_num 
                    and   c.intcol# = lv.intcol_num
                    and   EXISTS ( 
                          SELECT  1
                          FROM    sys.opqtype$ op
                          WHERE  op.obj# = c.obj#
                                 and   op.intcol# = c.intcol#
                                 and   op.type = 0 )
                    )
         ),
         ( select value(opq) from sys.ku$_opqtype_view opq
             where c.type# = 58        -- DTYOPQ (opaque type)
             and   c.obj# = opq.obj_num
             and   c.intcol# = opq.intcol_num
         ),
         ( select value(oi)
             from ku$_oidindex_view oi
             where bitand(c.property, 2) = 2
             and   c.obj# = oi.obj_num
             and   c.intcol# = oi.intcol_num
         ),
         c.spare1, c.spare2, c.spare3, c.spare4, c.spare5, 
         to_char(c.spare6,'YYYY/MM/DD HH24:MI:SS')
  from col$ c
/

grant select on ku$_column_view to select_catalog_role
/

-- ADT for columns in partitioned tables
create or replace type ku$_pcolumn_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                          /* column number as created */
  segcol_num    number,                          /* column number in segment */
  segcollength  number,                      /* length of the segment column */
  offset        number,                                  /* offset of column */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000),/* name of type attr. column: null if != type */
  type_num      number,                               /* data type of column */
  length        number,                         /* length of column in bytes */
  fixedstorage  number,             /* flags: 0x01 = fixed, 0x02 = read-only */
  precision_num number,                                         /* precision */
  scale         number,                                             /* scale */
  not_null      number,                               /* 0 = nulls permitted */
                                                 /* > 0 = no NULLs permitted */
  deflength     number,                   /* default value expr. text length */
  default_val   varchar2(4000),             /* default value expression text */
  binarydefval  varchar2(4000),          /* default replace null with clause */
  intcol_num    number,                            /* internal column number */
  base_intcol_num number,    /* internal column number of base column, i.e., */
                           /* the intcol# of the first column with this col# */
  base_col_type number, /* base column type: 1 = UDT, 2 = XMLType OR or CSX, */
                        /*                   3 = XMLType as CLOB,  0 = other */
  base_col_name varchar2(30),      /* for any xmltype, name of xmltype column*/
  property      number,                     /* column properties (bit flags) */
  charsetid     number,                              /* NLS character set id */
  charsetform   number,                 
  con           ku$_constraint0_t,                    /* not null constraint */
  typemd        ku$_coltype_t,     /* type metadata. null if not a typed col */
  lobmd         ku$_lob_t,            /* lob metadata. null if not a lob col */
  plobmd        ku$_partlob_t,   /* part lob metadata. null if not a lob col */
  opqmd         ku$_opqtype_t,   /* opaque metadata. null if not type opaque */
  oidindex      ku$_oidindex_t,   /*oidindex if col is OID$ col of obj table */
  spare1        number,                      /* fractional seconds precision */
  spare2        number,                  /* interval leading field precision */
  spare3        number,                 
  spare4        varchar2(1000),          /* NLS settings for this expression */
  spare5        varchar2(1000),
  spare6        varchar2(19)
)
/
grant execute on ku$_pcolumn_t to public
/

create or replace type ku$_pcolumn_list_t as table of ku$_pcolumn_t;
/
grant execute on ku$_pcolumn_list_t to public
/

-- view to get all columns.  Each column has a constraint ADT embedded in it
-- if the column has a not-null constraint.  If there is no such constraint,
-- the constraint attribute evaluates to null.  Other constraints on columns
-- are in the table ADT.
create or replace force view ku$_pcolumn_view of ku$_pcolumn_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#, c.col#, c.segcol#,
         c.segcollength, c.offset, c.name,
         (select a.name from attrcol$ a where
                        a.obj#=c.obj# and a.intcol#=c.intcol#),
         c.type#, c.length, c.fixedstorage,
         c.precision#, c.scale, c.null$, c.deflength,
         sys.dbms_metadata_util.long2varchar(c.deflength,
                                        'SYS.COL$',
                                        'DEFAULT$',
                                        c.rowid),
         sys.dbms_metadata_util.binary2varchar(c.obj#, c.intcol#),
         c.intcol#,
         case c.col# when c.intcol# then c.intcol#
          else sys.dbms_metadata_util.get_base_intcol_num(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         case c.col# when c.intcol# then 0
          else 
            sys.dbms_metadata_util.get_base_col_type(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         case c.col# when c.intcol# then NULL
          else 
            sys.dbms_metadata_util.get_base_col_name(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         c.property, c.charsetid, c.charsetform,
         ( select value(cv)
             from ku$_constraint0_view cv, ku$_constraint_col_view ccv
             where c.intcol# = ccv.intcol_num
             and c.obj# = ccv.obj_num
             and ccv.con_num = cv.con_num
             and cv.contype in (7,11)
         ),
         ( select value(ctv)
             from ku$_coltype_view ctv
             where c.type# in ( 121,    -- DTYADT  (user-defined type)
                                122,    -- DTYNTB  (nested table)
                                123,    -- DTYNAR  (varray)
                                111,    -- DTYIREF (REF)
                                 58)    -- DTYOPQ  (opaque type)
             and   c.obj#  = ctv.obj_num
             and   c.intcol# = ctv.intcol_num
         ),
         ( select value(lv)
             from ku$_lob_view lv
             where (c.type# in (112,    -- CLOB
                                113,    -- BLOB
                                123)    -- DTYNAR  (varray)
                    and   c.obj#  = lv.obj_num
                    and   c.intcol# = lv.intcol_num)
             or    (c.type# = 58        -- DTYOPQ (XML type)
                    and   c.obj#  = lv.obj_num 
                    and   lv.intcol_num = 
                          (select op.lobcol from sys.opqtype$ op
                                    where op.obj# = c.obj#
                                    and   bitand(op.flags,4) != 0
                                    and   op.intcol# = c.intcol#)
                    )
             or    (c.type# = 58        -- DTYOPQ (opaque type)
                    and   c.obj#  = lv.obj_num 
                    and   c.intcol# = lv.intcol_num
                    and   EXISTS ( 
                          SELECT  1
                          FROM    sys.opqtype$ op
                          WHERE  op.obj# = c.obj#
                                 and   op.intcol# = c.intcol#
                                 and   op.type = 0 )
                    )
         ),
         ( select value(lv)
             from ku$_partlob_view lv
             where (c.type# in (112,    -- CLOB
                                113,    -- BLOB
                                123)    -- DTYNAR  (varray)
                    and   c.obj#  = lv.obj_num
                    and   c.intcol# = lv.intcol_num)
             or    (c.type# = 58        -- DTYOPQ (XML type)
                    and   c.obj#  = lv.obj_num 
                    and   lv.intcol_num = 
                          (select op.lobcol from sys.opqtype$ op
                                    where op.obj# = c.obj#
                                    and   bitand(op.flags,4) != 0
                                    and   op.intcol# = c.intcol#)
                    )
             or    (c.type# = 58        -- DTYOPQ (opaque type)
                    and   c.obj#  = lv.obj_num 
                    and   c.intcol# = lv.intcol_num
                    and   EXISTS ( 
                          SELECT  1
                          FROM    sys.opqtype$ op
                          WHERE  op.obj# = c.obj#
                                 and   op.intcol# = c.intcol#
                                 and   op.type = 0 )
                    )
         ),
         ( select value(opq) from sys.ku$_opqtype_view opq
             where c.type# = 58        -- DTYOPQ (opaque type)
             and   c.obj# = opq.obj_num
             and   c.intcol# = opq.intcol_num
         ),
         ( select value(oi)
             from ku$_oidindex_view oi
             where bitand(c.property, 2) = 2
             and   c.obj# = oi.obj_num
             and   c.intcol# = oi.intcol_num
         ),
         c.spare1, c.spare2, c.spare3, c.spare4, c.spare5, 
         to_char(c.spare6, 'YYYY/MM/DD HH24:MI:SS')
  from col$ c
/

grant select on ku$_pcolumn_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              NESTED TABLE
-------------------------------------------------------------------------------


-- ADT for IOT overflow table
create or replace type ku$_ov_table_t as object
(
  obj_num       number,                                              /* obj# */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number                                              /* flags */
)
/
grant execute on ku$_ov_table_t to public
/

-- view for IOT overflow table
create or replace force view ku$_ov_table_view of ku$_ov_table_t 
  with object OID(obj_num)
  as select t.obj#, t.dataobj#, t.bobj#,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags
  from  tab$ t, ts$ ts
  where bitand(t.property,512) = 512
        and t.ts# = ts.ts#
/
grant select on ku$_ov_table_view to select_catalog_role
/

-- ADT for IOT MAPPING table
create or replace type ku$_map_table_t as object
(
  obj_num       number,                                              /* obj# */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  storage       ku$_storage_t,                                    /* storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number                                              /* flags */
)
/
grant execute on ku$_map_table_t to public
/
-- view for IOT MAPPING table 
create or replace force view ku$_map_table_view of ku$_map_table_t
  with object OID(obj_num)
  as select t.obj#, t.dataobj#, t.bobj#,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         ts.name, ts.blocksize,
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags
  from  tab$ t, ts$ ts
  where bitand(t.flags,536870912) = 536870912
        and t.ts# = ts.ts#
/
grant select on ku$_map_table_view to select_catalog_role
/

-- UDT for table data for heap nested table
create or replace type ku$_hnt_t as object
(
  obj_num       number,                              /* obj# of nested table */
  property      number,                                  /* table properties */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number,                                             /* flags */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  pkref_list    ku$_pkref_constraint_list_t  /* list of table ref constraints*/
)
/
grant execute on ku$_hnt_t to public
/

-- view for table data for heap nested table
create or replace force view ku$_hnt_view
  of ku$_hnt_t with object identifier(obj_num) as
  select t.obj#, t.property,
        (select value(s) from ku$_storage_view s
         where     t.file#  = s.file_num
             and   t.block# = s.block_num
             and   t.ts#    = s.ts_num),
        (select value(s) from ku$_deferred_stg_view s
         where s.obj_num = t.obj#),
        (select ts.name from ts$ ts where t.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where t.ts# = ts.ts#),
        t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             )
  from tab$ t where bitand(t.property,64+512) = 0 -- skip IOT and overflow segs
/
grant select on ku$_hnt_view to select_catalog_role
/

-- UDT for table data for index organized nested table
create or replace type ku$_iont_t as object
(
  obj_num       number,                              /* obj# of nested table */
  property      number,                                  /* table properties */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number,                                             /* flags */
  pct_thresh    number,                            /* pctthreshold for IOTs. */
  numkeycols    number,      /* # of key columns in compressed prefix (IOTs) */
  inclcol_name  varchar(30),/* column where IOT splits into overflow segment */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  pkref_list    ku$_pkref_constraint_list_t, /* list of table ref constraints*/
  iov           ku$_ov_table_t                             /* overflow table */
)
/
grant execute on ku$_iont_t to public
/

-- view for table data for index organized nested table
create or replace force view ku$_iont_view
  of ku$_iont_t with object identifier(obj_num) as
  select t.obj#, t.property,
        (select value(s) from ku$_storage_view s
         where     i.file#  = s.file_num
             and   i.block# = s.block_num
             and   i.ts#    = s.ts_num),
        (select value(s) from ku$_deferred_stg_view s
         where s.obj_num = i.obj#),
        (select ts.name from ts$ ts where i.ts# = ts.ts#),
        (select ts.blocksize from ts$ ts where i.ts# = ts.ts#),
        i.pctfree$, i.initrans, i.maxtrans, t.flags,
        mod(i.pctthres$,256), i.spare2,
        (select c.name from col$ c
                 where c.obj# = i.bo#
                 and   c.col# = i.trunccnt and i.trunccnt != 0),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
        (select value(ov) from ku$_ov_table_view ov
         where ov.bobj_num = t.obj#
         and bitand(t.property, 128) = 128)  -- IOT has overflow
  from tab$ t, ind$ i
  where bitand(t.property,64+512) = 64  -- IOT but not overflow
    and t.pctused$ = i.obj#             -- for IOTs, pctused has index obj#
/
grant select on ku$_iont_view to select_catalog_role
/

-- UDT for nested table
create or replace type ku$_nt_t as object
(
  obj_num       number,                                /* obj# of base table */
  intcol_num    number,              /* internal column number in base table */
  ntab_num      number,              /* object number of nested table object */
  schema_obj    ku$_schemaobj_t,           /* schema object for nested table */
  col           ku$_simple_col_t,                                  /* column */
  property      number,                                  /* table properties */
  flags         number,                                             /* flags */
  hnt           ku$_hnt_t,                                /* heap table data */
  iont          ku$_iont_t,                                      /* iot data */
  col_list      ku$_column_list_t                         /* list of columns */
)
/
grant execute on ku$_nt_t to public
/
create or replace type ku$_nt_list_t as table of ku$_nt_t
/
grant execute on ku$_nt_list_t to public
/

-- UDT for collection of nested tables of a parent table
create or replace type ku$_nt_parent_t as object
(
  obj_num       number,                                /* obj# of base table */
  nts           ku$_nt_list_t                               /* nested tables */
)
/
grant execute on ku$_nt_parent_t to public
/

-- view for collection of nested tables of a parent table
create or replace force view ku$_nt_parent_view
  of ku$_nt_parent_t with object identifier(obj_num) as
  select t.obj#,
    cast(multiset(select
                nt.obj#, nt.intcol#, nt.ntab#,
                (select value(o) from ku$_schemaobj_view o
                 where o.obj_num = nt.ntab#),
                (select value(c) from ku$_simple_col_view c
                 where c.obj_num = nt.obj#
                 and   c.intcol_num = nt.intcol#),
                (select t.property from tab$ t where t.obj# = nt.ntab#),
                (select ct.flags from coltype$ ct
                        where ct.obj# = nt.obj#
                        and   ct.intcol# = nt.intcol#),
                (select value(h) from ku$_hnt_view h
                 where h.obj_num = nt.ntab#),
                (select value(i) from ku$_iont_view i
                 where i.obj_num = nt.ntab#),
                (cast(multiset(select * from ku$_column_view c 
                                where c.obj_num = nt.ntab#
                                order by c.col_num, c.intcol_num
                        ) as ku$_column_list_t
                        ))
          from ntab$ nt start with nt.obj#=t.obj#
                        connect by prior nt.ntab#=nt.obj#
                ) as ku$_nt_list_t
        )
  from tab$ t where bitand(t.property,4) = 4    -- has nested table columns
/
grant select on ku$_nt_parent_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              CLUSTERED TABLE
-------------------------------------------------------------------------------
-- UDT for table clustering info
create or replace type ku$_tabcluster_t as object
(
  obj_num       number,                            /* object number of table */
  schema_obj    ku$_schemaobj_t,                  /* cluster's schema object */
  col_list      ku$_simple_col_list_t           /* list of clustered columns */
)
/
grant execute on ku$_tabcluster_t to public
/

create or replace force view ku$_tabcluster_col_view of ku$_simple_col_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#,
         c.col#,
         c.intcol#,
         c.segcol#,
         c.property,
         c.name,
         (select a.name from attrcol$ a where
                        a.obj#=c.obj# and a.intcol#=c.intcol#),
         c.type#,
         c.deflength, '', null
  from col$ c, col$ cc, tab$ t
  where c.obj#  = t.obj#
    and cc.obj# = t.bobj#
    and cc.segcol# = c.segcol#
/
grant select on ku$_tabcluster_col_view to select_catalog_role
/

create or replace force view ku$_tabcluster_view of ku$_tabcluster_t
  with object identifier (obj_num) as
  select t.obj#,
         value(cl),
         cast(multiset(select * from ku$_tabcluster_col_view c
                       where c.obj_num = t.obj#
                        order by c.segcol_num
                      ) as ku$_simple_col_list_t
             )
  from  ku$_schemaobj_view cl, sys.tab$ t
  where bitand(t.property,1024) = 1024          -- clustered table
    and cl.obj_num = t.bobj#
/
grant select on ku$_tabcluster_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              TABLE
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- Specialized table UDTs/views
-------------------------------------------------------------------------------

create or replace type ku$_extloc_t as object
(
  obj_num       number,                          /* base table object number */
  position      number,                               /* this location index */
  dir           varchar2(30),                   /* location directory object */
  name          varchar2(4000)                              /* location name */
)
/
grant execute on ku$_extloc_t to public
/ 

create or replace type ku$_extloc_list_t
 as table of ku$_extloc_t
/
grant execute on ku$_extloc_list_t to public
/

create or replace type ku$_exttab_t as object
(
  obj_num       number,                          /* base table object number */
  default_dir   varchar2(30),                           /* default directory */
  type          varchar2(30),                          /* access driver type */
  nr_locations  number,                               /* number of locations */
  reject_limit  number,                                      /* reject limit */
  par_type      number,             /* access parameter type: blob=1, clob=2 */
  param_clob    clob,                      /* access parameters in clob form */
  location      ku$_extloc_list_t                      /* external locations */
)
/
grant execute on ku$_exttab_t to public
/

create or replace force view ku$_exttab_view of ku$_exttab_t
  with object OID(obj_num)
  as select
        et.obj#,
        et.default_dir,
        et.type$,
        et.nr_locations,
        et.reject_limit,
        et.par_type,
        et.param_clob,
        cast( multiset(select el.obj#, el.position, el.dir, el.name
                       from   sys.external_location$ el
                       where  el.obj# = et.obj#
                       order by el.obj#,el.position
                      ) as ku$_extloc_list_t
              )
      from sys.external_tab$ et
/
grant select on ku$_exttab_view to public
/

-- ORGANIZATION CUBE Tables
create or replace type ku$_cube_fact_t as object
(
  obj_num number,                                   /* Parent table object # */
  colname varchar2(100),                                  /* SQL column name */
  pcolname varchar2(100),                          /* Parent SQL column name */
  ccolname varchar2(100),                           /* COUNT SQL column name */
  obj     varchar2(100),                                 /* Mapped AW object */
  qdr     varchar2(100),                          /* QDRing dimension object */
  qdrval  varchar2(100),                                      /* QDRed value */
  flags   number                                                    /* Flags */
)
/
grant execute on ku$_cube_fact_t to public
/
create or replace type ku$_cube_fact_list_t
 as table of ku$_cube_fact_t
/
grant execute on ku$_cube_fact_list_t to public
/

create or replace type ku$_cube_hier_t as object
(
  obj_num  number,                                  /* Parent table object # */
  rel      varchar2(100),                              /* Mapped AW relation */
  qdr      varchar2(100),                         /* QDRing dimension object */
  qdrval   varchar2(100),                                     /* QDRed value */
  levels   ku$_cube_fact_list_t,                      /* Levels in hierarchy */
  flags    number                                                   /* Flags */
)
/
grant execute on ku$_cube_hier_t to public
/
create or replace type ku$_cube_hier_list_t
 as table of ku$_cube_hier_t
/
grant execute on ku$_cube_hier_list_t to public
/

create or replace type ku$_cube_dim_t as object
(
  obj_num       number,                             /* Parent table object # */
  colname       varchar2(100),                           /* Base data column */
  obj           varchar2(100),                           /* Mapped AW object */
  dimusing      varchar2(100),                    /* USING rel for native dt */
  gid           ku$_cube_fact_list_t,                                 /* GID */
  pgid          ku$_cube_fact_list_t,                          /* Parent GID */
  attrs         ku$_cube_fact_list_t,                          /* Attributes */
  levels        ku$_cube_fact_list_t,                              /* Levels */
  hiers         ku$_cube_hier_list_t,                         /* Hierarchies */
  flags         number                                              /* Flags */
)
/
grant execute on ku$_cube_dim_t to public
/
create or replace type ku$_cube_dim_list_t
 as table of ku$_cube_dim_t
/
grant execute on ku$_cube_dim_list_t to public
/

create or replace type ku$_cube_tab_t as object
(
  obj_num       number,                             /* Parent table object # */
  awname        varchar2(100),                         /* Underlying AW name */
  flags         number,                                             /* Flags */
  dims          ku$_cube_dim_list_t,                           /* Dimensions */
  facts         ku$_cube_fact_list_t,                            /* Measures */
  cgid          ku$_cube_fact_list_t                             /* Cube GID */
)
/
grant execute on ku$_cube_tab_t to public
/

create or replace force view ku$_cube_fact_view 
  as select ot.awseq#, ot.obj#, ao1.objname, oc.col#, oc.pcol#,
            (select col1.name from sys.col$ col1
             where col1.obj#=oc.obj# and col1.col#=oc.col#) colname,
            (select col2.name from sys.col$ col2
             where col2.obj#=oc.obj# and col2.col#=oc.pcol#) pcolname,
            oc.coltype,
            (select ao2.objname qdr
             from sys.aw_obj$ ao2, 
             (select max(rowid) keep (dense_rank last order by gen#) rid
              from aw_obj$ group by awseq#, oid) aor2
             where ao2.oid = oc.qdroid and ao2.awseq#=ot.awseq#
               and ao2.rowid = aor2.rid) qdr, oc.qdrval, oc.hier#,
            oc.flags
     from sys.olap_tab$ ot, sys.olap_tab_col$ oc, sys.aw_obj$ ao1, 
          (select max(rowid) keep (dense_rank last order by gen#) rid
           from aw_obj$ group by awseq#, oid) aor1
     where oc.obj# = ot.obj#
       and ao1.awseq#=ot.awseq# and ao1.rowid=aor1.rid and ao1.oid=oc.oid
     order by oc.col#
/
grant select on ku$_cube_fact_view to select_catalog_role
/

create or replace view ku$_cube_tab_view of ku$_cube_tab_t
  with object OID(obj_num)
  as select ot.obj#, aw.awname, ot.flags,
    cast( multiset(select ofv.obj#, ofv.colname, ofv.objname,
                    (select ol.objname                     /*dimusing*/
                     from ku$_cube_fact_view ol
                     where ol.obj#=ot.obj#
                     and ol.coltype=10
                     and ol.pcol#=ofv.col#),
                    cast( multiset(select ol.obj#,              /*gid*/
                                          ol.colname, ol.pcolname, null,
                                          ol.objname, ol.qdr,
                                          ol.qdrval, ol.flags
                                     from ku$_cube_fact_view ol
                                     where ol.obj#=ot.obj#
                                     and ol.coltype=5
                                     and ol.pcol#=ofv.col#
                                   ) as ku$_cube_fact_list_t
                        ),
                    cast( multiset(select ol.obj#,              /*pgid*/
                                          ol.colname, ol.pcolname, null,
                                          ol.objname, ol.qdr,
                                          ol.qdrval, ol.flags
                                     from ku$_cube_fact_view ol
                                     where ol.obj#=ot.obj#
                                     and ol.coltype=6
                                     and ol.pcol#=ofv.col#
                                  ) as ku$_cube_fact_list_t
                        ),
                    cast( multiset(select ol.obj#,              /*attr*/
                                          ol.colname, ol.pcolname, null,
                                          ol.objname, ol.qdr,
                                          ol.qdrval, ol.flags
                                     from ku$_cube_fact_view ol
                                     where ol.obj#=ot.obj#
                                     and ol.coltype=4
                                     and ol.pcol#=ofv.col#
                                   ) as ku$_cube_fact_list_t
                        ),
                    cast( multiset(select ol.obj#,              /*lvls*/
                                          ol.colname, ol.pcolname, null,
                                          ol.objname, ol.qdr,
                                          ol.qdrval, ol.flags
                                     from ku$_cube_fact_view ol
                                     where ol.obj#=ot.obj#
                                     and ol.coltype=3
                                     and ol.pcol#=ofv.col#
                                  ) as ku$_cube_fact_list_t
                        ),
                    cast( multiset(select ol.obj#, ol.objname, ol.qdr,
                                          ol.qdrval,
                                          cast( multiset(select
                                                           lvl.obj#,
                                                           lvl.colname,
                                                           lvl.pcolname,
                                                           null,
                                                           lvl.objname,
                                                           lvl.qdr,
                                                           lvl.qdrval,
                                                           oh.flags
                                            from ku$_cube_fact_view lvl,
                                                 sys.olap_tab_hier$ oh
                                            where oh.hier#=ol.hier#
                                              and oh.obj#=ol.obj#
                                              and lvl.obj#=oh.obj#
                                              and (lvl.pcol#=ofv.col#
                                               or (lvl.col#=ofv.col#
                                               and (oh.flags=1)))
                                              and lvl.colname=
                           (select col.name from sys.col$ col
                              where col.obj#=oh.obj# and col.col#=oh.col#)
                                            order by oh.ord
                                                ) as ku$_cube_fact_list_t
                                              ),
                                          ol.flags
                                     from ku$_cube_fact_view ol
                                     where ol.obj#=ot.obj#
                                     and ol.coltype=7
                                     and ol.pcol#=ofv.col#
                                   ) as ku$_cube_hier_list_t
                        ),
                    ofv.flags /* flags */
                    from ku$_cube_fact_view ofv
                    where ofv.coltype=2 and ofv.obj#=ot.obj#
                  ) as ku$_cube_dim_list_t
        ),
    /* FACTs */
    cast( multiset(select ofv.obj#, ofv.colname, ofv.pcolname,
                          (select col.name from sys.col$ col        /* COUNT */
                             where col.obj#=ofv.obj# and col.col#=
                               (select otc.col# from olap_tab_col$ otc
                                  where otc.obj#=ofv.obj# and
                                        otc.pcol#=ofv.col# and
                                        otc.coltype=9)),
                          ofv.objname, ofv.qdr, ofv.qdrval, ofv.flags
                     from ku$_cube_fact_view ofv
                     where ofv.coltype=1 and ofv.obj#=ot.obj#
                  ) as ku$_cube_fact_list_t
        ),
    /* CGID */
    cast( multiset(select ofv.obj#, ofv.colname, ofv.pcolname, null,
                          ofv.objname, ofv.qdr, ofv.qdrval, ofv.flags
                     from ku$_cube_fact_view ofv
                     where ofv.coltype=8 and ofv.obj#=ot.obj#
                     order by ofv.col#
                  ) as ku$_cube_fact_list_t
        )
  from sys.olap_tab$ ot, sys.aw$ aw
    where aw.awseq#=ot.awseq#
/
grant select on ku$_cube_tab_view to select_catalog_role
/

-- flashback archived table info for a table
-- (a subset of info from sys_fba_fa and sys_fba_trackedtables)
create or replace type ku$_fba_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                        /* table obj# */
  fa_num        number,                               /* flashback archive # */
  fa_name       varchar2(255)                      /* flashback archive name */
)
/
grant execute on ku$_fba_t to public
/

create or replace force view ku$_fba_view of ku$_fba_t 
  with object OID(obj_num)
  as select '1','0',
            ft.obj#,
            ft.fa#,
            fba.faname
  from sys_fba_fa fba, sys_fba_trackedtables ft
  where ft.fa#=fba.fa#
/
grant select on ku$_fba_view to select_catalog_role
/

-- ADT for primitive, non-partitioned Heap TABLEs
create or replace type ku$_htable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t,         /* base object (if secondary table) */
  anc_obj       ku$_schemaobj_t,     /* ancestor object (if secondary table) */
  parent_obj    ku$_schemaobj_t,          /* parent object (if refpar child) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  tab_num       number,                  /* # in cluster, null if !clustered */
  cols          number,                                      /* # of columns */
  clucols       number,                 /* # of clustered cols, if clustered */
  tabcluster    ku$_tabcluster_t,        /* cluster info, null if !clustered */
  fba           ku$_fba_t, /* flashback archive info, null if not fb enabled */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number,                                             /* flags */
  audit_val     varchar2(38),                            /* auditing options */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  avgspc_flb    number,       /* avg avail free space of blocks on free list */
  flbcnt        number,                             /* free list block count */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  degree        number,                       /* # of PQ slaves per instance */
  instances     number,                         /* # of OPS instances for PQ */
  intcols       number,                             /* # of internal columns */
  kernelcols    number,                   /* number of REAL (kernel) columns */
  property      number,                                  /* table properties */
  property2     number,                             /* more table properties */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  xmlcolset     ku$_XmlColSet_t,        /* OR intcolnums for xmltype stoarge */
  trigflag      number,                              /* inline trigger flags */
  spare1        number,                       /* used to store hakan_kqldtvc */
  spare2        number,         /* committed partition # used by drop column */
  spare3        number,                           /* summary sequence number */
  spare4        varchar2(1000),         /* committed RID used by drop column */
  spare5        varchar2(1000),         
  spare6        varchar2(19),                               /* dml timestamp */
  encalg        number,  /* encryption algorithm id if a column is encrypted */
  intalg        number,   /* integrity algorithm id if a column is encrypted */
  col_list      ku$_prim_column_list_t,                   /* list of columns */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  exttab        ku$_exttab_t,                     /* external table metadata */
  cubetab       ku$_cube_tab_t,                /* organization cube metadata */
  refpar_level  number                          /* reference partition level */
)
/
grant execute on ku$_htable_t to public
/

--
-- Bug 6635956: Replace NULL chars in audit$ column with '-' when creating
-- object views since audit$ columns in tab$, view$, seq$, procedure$, dir$,
-- type_misc$, library$, or user$ can contain NULL chars in some cases.
-- We did the same for all object views which reference audit$ columns in
-- these tables.
--
create or replace force view ku$_htable_view of ku$_htable_t 
  with object OID(obj_num)
  as select '1','3',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.dataobj#, t.bobj#, t.tab#, t.cols,
         t.clucols,
         (select value(cl) from ku$_tabcluster_view cl
          where cl.obj_num = t.obj#),
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         'N', (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         NULL, t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         cast( multiset(select * from ku$_prim_column_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_prim_column_list_t
              ),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         0
  from  ku$_schemaobj_view o, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND bitand(t.property,1607983103)     -- mask off bits 0x20282000
                in (0,1024,8192)              -- can be clustered table (1024)
                                              -- or nested table (8192)
        AND t.ts# = ts.ts#
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_htable_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_htable_view of ku$_htable_t 
  with object OID(obj_num)
  as select t.* from ku$_htable_view t
  where bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_htable_view to public
/

-- ADT for primitive, Partitioned Heap TABLEs
create or replace type ku$_phtable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t,         /* base object (if secondary table) */
  anc_obj       ku$_schemaobj_t,     /* ancestor object (if secondary table) */
  parent_obj    ku$_schemaobj_t,          /* parent object (if refpar child) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  tab_num       number,                  /* # in cluster, null if !clustered */
  cols          number,                                      /* # of columns */
  clucols       number,                 /* # of clustered cols, if clustered */
  tabcluster    ku$_tabcluster_t,        /* cluster info, null if !clustered */
  fba           ku$_fba_t, /* flashback archive info, null if not fb enabled */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number,                                             /* flags */
  audit_val     varchar2(38),                            /* auditing options */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  avgspc_flb    number,       /* avg avail free space of blocks on free list */
  flbcnt        number,                             /* free list block count */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  degree        number,                       /* # of PQ slaves per instance */
  instances     number,                         /* # of OPS instances for PQ */
  intcols       number,                             /* # of internal columns */
  kernelcols    number,                   /* number of REAL (kernel) columns */
  property      number,                                  /* table properties */
  property2     number,                             /* more table properties */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  xmlcolset     ku$_XmlColSet_t,        /* OR intcolnums for xmltype stoarge */
  trigflag      number,                              /* inline trigger flags */
  spare1        number,                       /* used to store hakan_kqldtvc */
  spare2        number,         /* committed partition # used by drop column */
  spare3        number,                           /* summary sequence number */
  spare4        varchar2(1000),         /* committed RID used by drop column */
  spare5        varchar2(1000),         
  spare6        varchar2(19),                               /* dml timestamp */
  encalg        number,  /* encryption algorithm id if a column is encrypted */
  intalg        number,   /* integrity algorithm id if a column is encrypted */
  col_list      ku$_prim_column_list_t,                   /* list of columns */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  part_obj      ku$_tab_partobj_t,                         /* partition info */
  exttab        ku$_exttab_t,                     /* external table metadata */
  cubetab       ku$_cube_tab_t,                /* organization cube metadata */
  refpar_level  number                          /* reference partition level */
)
/
grant execute on ku$_phtable_t to public
/

create or replace force view ku$_phtable_view of ku$_phtable_t 
  with object OID(obj_num)
  as select '1','2',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.dataobj#, t.bobj#, t.tab#, t.cols,
         t.clucols,
         (select value(cl) from ku$_tabcluster_view cl
          where cl.obj_num = t.obj#),
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         'N', (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         NULL, t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         cast( multiset(select * from ku$_prim_column_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_prim_column_list_t
              ),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         (select value(po) from ku$_tab_partobj_view po
          where t.obj# = po.obj_num),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         0
  from  ku$_schemaobj_view o, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND bitand(t.property,1607983103)     -- mask off bits 0x20282000
                in (32,32+8192)         /* simple, partitioned tables */
                                        /* no CLOBs, UDTs, nested cols*/
                                        /* (but can be nested table) */
        AND not exists( select * from partobj$ po 
                        where po.obj# = t.obj# and po.parttype = 5)
        AND t.ts# = ts.ts#
        AND     (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_phtable_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_phtable_view of ku$_phtable_t 
  with object OID(obj_num)
  as select t.* from ku$_phtable_view t
  where bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_phtable_view to public
/


-- ADT for Full (i.e., non-primitive), non-partitioned Heap TABLEs
create or replace type ku$_fhtable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t,         /* base object (if secondary table) */
  anc_obj       ku$_schemaobj_t,     /* ancestor object (if secondary table) */
  parent_obj    ku$_schemaobj_t,          /* parent object (if refpar child) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  tab_num       number,                  /* # in cluster, null if !clustered */
  cols          number,                                      /* # of columns */
  clucols       number,                 /* # of clustered cols, if clustered */
  tabcluster    ku$_tabcluster_t,        /* cluster info, null if !clustered */
  fba           ku$_fba_t, /* flashback archive info, null if not fb enabled */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number,                                             /* flags */
  audit_val     varchar2(38),                            /* auditing options */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  avgspc_flb    number,       /* avg avail free space of blocks on free list */
  flbcnt        number,                             /* free list block count */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  degree        number,                       /* # of PQ slaves per instance */
  instances     number,                         /* # of OPS instances for PQ */
  intcols       number,                             /* # of internal columns */
  kernelcols    number,                   /* number of REAL (kernel) columns */
  property      number,                                  /* table properties */
  property2     number,                             /* more table properties */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  xmlcolset     ku$_XmlColSet_t,        /* OR intcolnums for xmltype stoarge */
  trigflag      number,                              /* inline trigger flags */
  spare1        number,                       /* used to store hakan_kqldtvc */
  spare2        number,         /* committed partition # used by drop column */
  spare3        number,                           /* summary sequence number */
  spare4        varchar2(1000),         /* committed RID used by drop column */
  spare5        varchar2(1000),         
  spare6        varchar2(19),                               /* dml timestamp */
  encalg        number,  /* encryption algorithm id if a column is encrypted */
  intalg        number,   /* integrity algorithm id if a column is encrypted */
  col_list      ku$_column_list_t,                        /* list of columns */
  nt            ku$_nt_parent_t,                            /* nested tables */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  pkref_list    ku$_pkref_constraint_list_t, /* list of table ref constraints*/
  exttab        ku$_exttab_t,                     /* external table metadata */
  cubetab       ku$_cube_tab_t,                /* organization cube metadata */
  refpar_level  number                          /* reference partition level */
)
/
grant execute on ku$_fhtable_t to public
/

create or replace force view ku$_fhtable_view of ku$_fhtable_t 
  with object OID(obj_num)
  as select '2','5',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.dataobj#, t.bobj#, t.tab#, t.cols,
         t.clucols,
         (select value(cl) from ku$_tabcluster_view cl
          where cl.obj_num = t.obj#),
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         case when (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1))                      /* xmltype col */
              then dbms_metadata_util.get_xmlcolset(o.obj_num)
              else NULL end,
         t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         cast( multiset(select * from ku$_column_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_column_list_t
              ),
         (select value(nt) from ku$_nt_parent_view nt
          where nt.obj_num = t.obj#),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         0
  from ku$_schemaobj_view o, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND t.ts# = ts.ts#
        AND bitand(t.property, 32+64+128+256+512) = 0
                                                /* not IOT, partitioned   */
        AND bitand(t.property,1607983103)     -- mask off bits 0x20282000
                NOT in (0,1024,8192) -- don't include those in ku$_htable_view
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_fhtable_view to public
/

-- The view, ku$_10_2_fhtable_view, excludes column attributes that are part 
-- of the subtype, sql_plan_allstat_row_type. In 11g, SQL Tuning introduced 
-- this new subtype as well as the ability for customers to export a SQL Tuning
-- Set(STS) to 10.2.  To support this new feature, expdp must not export this
-- new subtype to 10.2 since it does not exist in 10.2.
--
-- The view definition below is identical to the above definition, 
-- ku$_fhtable_view, except for the following:
--    dbms_metadata.is_attr_valid_on_10(t.obj#,c.intcol_num)=1
-- This routine is called when building the column list.

create or replace force view ku$_10_2_fhtable_view of ku$_fhtable_t 
  with object OID(obj_num)
  as select '2','5',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.dataobj#, t.bobj#, t.tab#, t.cols,
         t.clucols,
         (select value(cl) from ku$_tabcluster_view cl
          where cl.obj_num = t.obj#),
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         case when (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1))                      /* xmltype col */
              then dbms_metadata_util.get_xmlcolset(o.obj_num)
              else NULL end,
         t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         cast(multiset(select * from ku$_column_view c where
                       c.obj_num = t.obj# and
                       dbms_metadata.is_attr_valid_on_10(t.obj#,c.intcol_num)=1
                       order by c.col_num, c.intcol_num
                      ) as ku$_column_list_t
              ),
         (select value(nt) from ku$_nt_parent_view nt
          where nt.obj_num = t.obj#),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         0
  from ku$_schemaobj_view o, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND t.ts# = ts.ts#
        AND bitand(t.property, 32+64+128+256+512) = 0
                                                /* not IOT, partitioned   */
        AND bitand(t.property,1607983103)     -- mask off bits 0x20282000
                NOT in (0,1024,8192) -- don't include those in ku$_htable_view
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_10_2_fhtable_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_fhtable_view of ku$_fhtable_t 
  with object OID(obj_num)
  as select t.* from ku$_fhtable_view t
  where bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_fhtable_view to public
/

-- ADT for Partitioned, Full (i.e., non-primitive) Heap TABLEs
create or replace type ku$_pfhtable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t,         /* base object (if secondary table) */
  anc_obj       ku$_schemaobj_t,     /* ancestor object (if secondary table) */
  parent_obj    ku$_schemaobj_t,          /* parent object (if refpar child) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  tab_num       number,                  /* # in cluster, null if !clustered */
  cols          number,                                      /* # of columns */
  clucols       number,                 /* # of clustered cols, if clustered */
  tabcluster    ku$_tabcluster_t,        /* cluster info, null if !clustered */
  fba           ku$_fba_t, /* flashback archive info, null if not fb enabled */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number,                                             /* flags */
  audit_val     varchar2(38),                            /* auditing options */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  avgspc_flb    number,       /* avg avail free space of blocks on free list */
  flbcnt        number,                             /* free list block count */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  degree        number,                       /* # of PQ slaves per instance */
  instances     number,                         /* # of OPS instances for PQ */
  intcols       number,                             /* # of internal columns */
  kernelcols    number,                   /* number of REAL (kernel) columns */
  property      number,                                  /* table properties */
  property2     number,                             /* more table properties */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  xmlcolset     ku$_XmlColSet_t,        /* OR intcolnums for xmltype stoarge */
  trigflag      number,                              /* inline trigger flags */
  spare1        number,                       /* used to store hakan_kqldtvc */
  spare2        number,         /* committed partition # used by drop column */
  spare3        number,                           /* summary sequence number */
  spare4        varchar2(1000),         /* committed RID used by drop column */
  spare5        varchar2(1000),         
  spare6        varchar2(19),                               /* dml timestamp */
  encalg        number,  /* encryption algorithm id if a column is encrypted */
  intalg        number,   /* integrity algorithm id if a column is encrypted */
  col_list      ku$_pcolumn_list_t,                       /* list of columns */
  nt            ku$_nt_parent_t,                            /* nested tables */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  pkref_list    ku$_pkref_constraint_list_t, /* list of table ref constraints*/
  part_obj      ku$_tab_partobj_t,                         /* partition info */
  exttab        ku$_exttab_t,                     /* external table metadata */
  cubetab       ku$_cube_tab_t,                /* organization cube metadata */
  refpar_level  number                          /* reference partition level */
)
/
grant execute on ku$_pfhtable_t to public
/

create or replace force view ku$_pfhtable_view of ku$_pfhtable_t 
  with object OID(obj_num)
  as select '2','5',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.dataobj#, t.bobj#, t.tab#, t.cols,
         t.clucols,
         (select value(cl) from ku$_tabcluster_view cl
          where cl.obj_num = t.obj#),
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         case when (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1))                      /* xmltype col */
              then dbms_metadata_util.get_xmlcolset(o.obj_num)
              else NULL end,
         t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         cast( multiset(select * from ku$_pcolumn_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_pcolumn_list_t
              ),
         (select value(nt) from ku$_nt_parent_view nt
          where nt.obj_num = t.obj#),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
         (select value(po) from ku$_tab_partobj_view po
          where t.obj# = po.obj_num),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
        0
  from ku$_schemaobj_view o, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND t.ts# = ts.ts#
        AND bitand(t.property, 32+64+128+256+512) = 32
                                                /* partitioned (32)       */
                                                /* but not IOT            */
        AND bitand(t.property,1607983103)     -- mask off bits 0x20282000
             not in (32,32+8192)  /* Mutually exclusive of ku$_phtable_view */
        AND not exists( select * from partobj$ po 
                        where po.obj# = t.obj# and po.parttype = 5)
        AND     (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_pfhtable_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_pfhtable_view of ku$_pfhtable_t 
  with object OID(obj_num)
  as select t.* from ku$_pfhtable_view t
  where bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_pfhtable_view to public
/

-- view used for reference partition levels
create or replace view ku$_ref_par_level_view
  (obj#,lvl)
  as select obj#, level
     from cdef$
     start with robj# IN (select obj# from partobj$
                         where parttype != 5 AND bitand(flags, 32) != 0)
                               AND type# = 4 AND bitand(defer, 512) != 0
     connect by prior obj# = robj#
                AND type# = 4 AND bitand(defer, 512) != 0 
/
grant select on ku$_ref_par_level_view to public
/
-- query for reference partitioned child tables. These need special treatment 
-- for proper ordering.
-- GET THIS HACK---
-- Part of the special treatment is naming the view so it some last in a sort
-- by view name (done as part of hetero object srcipt loading!
create or replace force view ku$_acptable_view of ku$_pfhtable_t 
  with object OID(obj_num)
 as select '2','3',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         (select value(po) from ku$_schemaobj_view po
           where 
            po.obj_num=sys.dbms_metadata_util.ref_par_parent(t.obj#)),
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.dataobj#, t.bobj#, t.tab#, t.cols,
         t.clucols,
         (select value(cl) from ku$_tabcluster_view cl
          where cl.obj_num = t.obj#),
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         case when (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1))                      /* xmltype col */
              then dbms_metadata_util.get_xmlcolset(o.obj_num)
              else NULL end,
         t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         cast( multiset(select * from ku$_pcolumn_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_pcolumn_list_t
              ),
         (select value(nt) from ku$_nt_parent_view nt
          where nt.obj_num = t.obj#),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
         (select value(po) from ku$_tab_partobj_view po
          where t.obj# = po.obj_num),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         sys.dbms_metadata_util.ref_par_level(t.obj#)
  from ku$_schemaobj_view o, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND t.ts# = ts.ts#
        AND bitand(t.property, 32+64+128+256+512) = 32
                                                /* partitioned (32)       */
                                                /* but not IOT            */
        /* mutually exclusive with ku$_phtable and ku$_pfhtable */
        AND exists( select * from partobj$ po   
                    where po.obj# = t.obj# and po.parttype = 5)
        AND     (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_acptable_view to public
/

-- ADT for non-partitioned Index-Organized TABLEs
create or replace type ku$_iotable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t,         /* base object (if secondary table) */
  anc_obj       ku$_schemaobj_t,     /* ancestor object (if secondary table) */
  parent_obj    ku$_schemaobj_t,    /* parent object (if refpar child table) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  tab_num       number,                  /* # in cluster, null if !clustered */
  cols          number,                                      /* # of columns */
  fba           ku$_fba_t, /* flashback archive info, null if not fb enabled */
  clucols       number,                 /* # of clustered cols, if clustered */
  pct_free      number,                   /* min. free space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  pct_thresh    number,                            /* pctthreshold for IOTs. */
  numkeycols    number,      /* # of key columns in compressed prefix (IOTs) */
  flags         number,                                             /* flags */
  audit_val     varchar2(38),                            /* auditing options */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  avgspc_flb    number,       /* avg avail free space of blocks on free list */
  flbcnt        number,                             /* free list block count */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  degree        number,                       /* # of PQ slaves per instance */
  instances     number,                         /* # of OPS instances for PQ */
  intcols       number,                             /* # of internal columns */
  kernelcols    number,                   /* number of REAL (kernel) columns */
  property      number,                                  /* table properties */
  property2     number,                             /* more table properties */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  xmlcolset     ku$_XmlColSet_t,        /* OR intcolnums for xmltype stoarge */
  trigflag      number,                              /* inline trigger flags */
  spare1        number,                       /* used to store hakan_kqldtvc */
  spare2        number,         /* committed partition # used by drop column */
  spare3        number,                           /* summary sequence number */
  spare4        varchar2(1000),         /* committed RID used by drop column */
  spare5        varchar2(1000),         
  spare6        varchar2(19),                               /* dml timestamp */
  encalg        number,  /* encryption algorithm id if a column is encrypted */
  intalg        number,   /* integrity algorithm id if a column is encrypted */
  inclcol_name  varchar(30),/* column where IOT splits into overflow segment */
  col_list      ku$_column_list_t,                        /* list of columns */
  nt            ku$_nt_parent_t,                            /* nested tables */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  pkref_list    ku$_pkref_constraint_list_t, /* list of table ref constraints*/
  iov           ku$_ov_table_t,                            /* overflow table */
  maptab        ku$_map_table_t,                            /* mapping table */
  exttab        ku$_exttab_t,                     /* external table metadata */
  cubetab       ku$_cube_tab_t,                /* organization cube metadata */
  refpar_level  number                          /* reference partition level */
)
/
grant execute on ku$_iotable_t to public
/

create or replace force view ku$_iotable_view of ku$_iotable_t 
  with object OID(obj_num)
  as select '2','5',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where i.file# = s.file_num
          and i.block#  = s.block_num
          and i.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         i.dataobj#, t.bobj#, t.tab#, t.cols,
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.clucols, i.pctfree$, i.initrans, i.maxtrans, 
         mod(i.pctthres$,256), i.spare2, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         case when (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1))                      /* xmltype col */
              then dbms_metadata_util.get_xmlcolset(o.obj_num)
              else NULL end,
         t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         (select c.name from col$ c
                 where c.obj# = t.obj#
                 and   c.col# = i.trunccnt and i.trunccnt != 0
                 and   bitand(c.property,1)=0
                 and   bitand(c.property,256)=0),
         cast( multiset(select * from ku$_column_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_column_list_t
              ),
         (select value(nt) from ku$_nt_parent_view nt
          where nt.obj_num = t.obj#),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
         (select value(ov) from ku$_ov_table_view ov
          where ov.bobj_num = t.obj#
          and bitand(t.property, 128) = 128),  -- IOT has overflow
         (select value(mp) from ku$_map_table_view mp
          where mp.bobj_num = t.obj#),  -- IOT has Mapping table
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         0
  from ku$_schemaobj_view o, tab$ t, ind$ i, ts$ ts
  where t.obj# = o.obj_num
        and t.pctused$ = i.obj#          -- For IOTs, pctused has index obj#
        and bitand(t.property, 32+64+512) = 64  -- IOT but not overflow
                                                -- or partitioned (32)
        and  i.ts# = ts.ts#
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_iotable_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_iotable_view of ku$_iotable_t 
  with object OID(obj_num)
  as select t.* from ku$_iotable_view t
  where bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_iotable_view to public
/

-- ADT for partitioned IOT overflow table partition
create or replace type ku$_ov_tabpart_t as object
(
  obj_num       number,                                              /* obj# */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  part_num      number,                                  /* partition number */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  pct_free      number,                   /* min. free space %age in a block */
  pct_used      number,                   /* min. used space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  flags         number                                              /* flags */
)
/
grant execute on ku$_ov_tabpart_t to public
/
create or replace type ku$_ov_tabpart_list_t as table of ku$_ov_tabpart_t;
/
grant execute on ku$_ov_tabpart_list_t to public
/

create or replace force view ku$_ov_tabpart_view of ku$_ov_tabpart_t 
  with object OID(obj_num)
  as select t.obj#, t.dataobj#, t.bo#, t.part#,
         (select value(s) from ku$_storage_view s
          where t.file# = s.file_num
          and t.block#  = s.block_num
          and t.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = t.obj#),
         ts.name, ts.blocksize,
         t.pctfree$, t.pctused$, t.initrans, t.maxtrans, t.flags
  from  tabpart$ t, ts$ ts
  where t.ts# = ts.ts#
/
grant select on ku$_ov_tabpart_view to select_catalog_role
/

-- ADT for partitioned IOTs

create or replace type ku$_iot_partobj_t as object
(
  obj_num       number,                                     /* obj# of table */
  tabpartobj    ku$_partobj_t,                       /* table partition info */
  partcols      ku$_part_col_list_t,         /* list of partitioning columns */
  subpartcols   ku$_part_col_list_t,      /* list of subpartitioning columns */
  indpartobj    ku$_partobj_t,                       /* index partition info */
  ovpartobj     ku$_partobj_t,                    /* overflow partition info */
  part_list     ku$_piot_part_list_t,                      /* partition list */
  iov_list      ku$_ov_tabpart_list_t            /* overflow part table list */
)
/
grant execute on ku$_iot_partobj_t to public
/
create or replace force view ku$_iot_partobj_view of ku$_iot_partobj_t
  with object identifier (obj_num) as
  select t.obj#,
         (select value (tpo) from ku$_partobj_view tpo
          where t.obj# = tpo.obj_num),
         cast(multiset(select * from ku$_tab_part_col_view pc
                       where pc.obj_num = t.obj#
                        order by pc.pos_num
                      ) as ku$_part_col_list_t
             ),
         cast(multiset(select * from ku$_tab_subpart_col_view sc
                       where sc.obj_num = t.obj#
                        order by sc.pos_num
                      ) as ku$_part_col_list_t
             ),
         (select value (ipo) from ku$_partobj_view ipo
          where i.obj# = ipo.obj_num),
         (select value (ovpo) from ku$_partobj_view ovpo
          where t.bobj# = ovpo.obj_num),
         cast(multiset(select * from ku$_piot_part_view ip
                       where ip.base_obj_num = i.obj#
                        order by ip.part_num
                      ) as ku$_piot_part_list_t
             ),
         cast(multiset(select * from ku$_ov_tabpart_view ovp
                       where ovp.bobj_num = t.bobj#
                        order by ovp.part_num
                      ) as ku$_ov_tabpart_list_t
             )
  from tab$ t, ind$ i 
  where i.bo#=t.obj#
    and i.type#=4                       -- iot index
    and bitand(t.property,32)=32        -- partitioned table
/
grant select on ku$_iot_partobj_view to select_catalog_role
/

-- ADT for Partitioned Index-Organized TABLEs
create or replace type ku$_piotable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t,         /* base object (if secondary table) */
  anc_obj       ku$_schemaobj_t,     /* ancestor object (if secondary table) */
  parent_obj    ku$_schemaobj_t,    /* parent object (if refpar child table) */
  storage       ku$_storage_t,                                    /* storage */
  deferred_stg  ku$_deferred_stg_t,                      /* deferred storage */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  dataobj_num   number,                                /* data layer object# */
  bobj_num      number,                           /* base obj# (cluster/iot) */
  tab_num       number,                  /* # in cluster, null if !clustered */
  cols          number,                                      /* # of columns */
  fba           ku$_fba_t, /* flashback archive info, null if not fb enabled */
  clucols       number,                 /* # of clustered cols, if clustered */
  pct_free      number,                   /* min. free space %age in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  pct_thresh    number,                            /* pctthreshold for IOTs. */
  numkeycols    number,      /* # of key columns in compressed prefix (IOTs) */
  flags         number,                                             /* flags */
  audit_val     varchar2(38),                            /* auditing options */
  rowcnt        number,                                    /* number of rows */
  blkcnt        number,                                  /* number of blocks */
  empcnt        number,                            /* number of empty blocks */
  avgspc        number,                      /* average available free space */
  chncnt        number,                            /* number of chained rows */
  avgrln        number,                                /* average row length */
  avgspc_flb    number,       /* avg avail free space of blocks on free list */
  flbcnt        number,                             /* free list block count */
  analyzetime   varchar2(19),                /* timestamp when last analyzed */
  samplesize    number,                 /* number of rows sampled by Analyze */
  degree        number,                       /* # of PQ slaves per instance */
  instances     number,                         /* # of OPS instances for PQ */
  intcols       number,                             /* # of internal columns */
  kernelcols    number,                   /* number of REAL (kernel) columns */
  property      number,                                  /* table properties */
  property2     number,                             /* more table properties */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  xmlcolset     ku$_XmlColSet_t,        /* OR intcolnums for xmltype stoarge */
  trigflag      number,                              /* inline trigger flags */
  spare1        number,                       /* used to store hakan_kqldtvc */
  spare2        number,         /* committed partition # used by drop column */
  spare3        number,                           /* summary sequence number */
  spare4        varchar2(1000),         /* committed RID used by drop column */
  spare5        varchar2(1000),         
  spare6        varchar2(19),                               /* dml timestamp */
  encalg        number,  /* encryption algorithm id if a column is encrypted */
  intalg        number,   /* integrity algorithm id if a column is encrypted */
  inclcol_name  varchar(30),/* column where IOT splits into overflow segment */
  col_list      ku$_pcolumn_list_t,                       /* list of columns */
  nt            ku$_nt_parent_t,                            /* nested tables */
  con0_list     ku$_constraint0_list_t,               /* list of constraints */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t,               /* list of constraints */
  pkref_list    ku$_pkref_constraint_list_t, /* list of table ref constraints*/
  iov           ku$_ov_table_t,                            /* overflow table */
  part_obj      ku$_iot_partobj_t,                         /* partition info */
  exttab        ku$_exttab_t,                     /* external table metadata */
  cubetab       ku$_cube_tab_t,                /* organization cube metadata */
  refpar_level  number                          /* reference partition level */
)
/
grant execute on ku$_piotable_t to public
/
create or replace force view ku$_piotable_view of ku$_piotable_t 
  with object OID(obj_num)
  as select '2','5',
         t.obj#,
         value(o),
         -- if this is a secondary table, get base obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         null,
         (select value(s) from ku$_storage_view s
          where i.file# = s.file_num
          and i.block#  = s.block_num
          and i.ts#     = s.ts_num),
         (select value(s) from ku$_deferred_stg_view s
          where s.obj_num = i.obj#),
         ts.name, ts.blocksize,
         i.dataobj#, t.bobj#, t.tab#, t.cols,
         (select value(fb) from ku$_fba_view fb where fb.obj_num = t.obj#),
         t.clucols, i.pctfree$, i.initrans, i.maxtrans, 
         mod(i.pctthres$,256), i.spare2, t.flags,
         replace(t.audit$,chr(0),'-'), t.rowcnt, t.blkcnt, t.empcnt,
         t.avgspc, t.chncnt, t.avgrln, t.avgspc_flb, t.flbcnt, 
         to_char(t.analyzetime,'YYYY/MM/DD HH24:MI:SS'),
         t.samplesize, t.degree, t.instances, t.intcols, t.kernelcols,
         bitand(t.property, 4294967295),
         trunc(t.property / power(2, 32)),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         case when (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1))                      /* xmltype col */
              then dbms_metadata_util.get_xmlcolset(o.obj_num)
              else NULL end,
         t.trigflag,
         t.spare1, t.spare2, t.spare3, t.spare4, t.spare5, 
         to_char(t.spare6,'YYYY/MM/DD HH24:MI:SS'),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.encalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         decode(bitand(t.trigflag, 65536), 65536, 
           (select e.intalg from sys.enc$ e where e.obj#=t.obj#),
           null),
         (select c.name from col$ c
                 where c.obj# = t.obj#
                 and   c.col# = i.trunccnt and i.trunccnt != 0
                 and   bitand(c.property,1)=0),
         cast( multiset(select * from ku$_pcolumn_view c 
                        where c.obj_num = t.obj#
                        order by c.col_num, c.intcol_num
                        ) as ku$_pcolumn_list_t
              ),
         (select value(nt) from ku$_nt_parent_view nt
          where nt.obj_num = t.obj#),
         cast( multiset(select * from ku$_constraint0_view con
                        where con.obj_num = t.obj#
                        and con.contype not in (7,11)
                       ) as ku$_constraint0_list_t
             ),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = t.obj#
                       ) as ku$_constraint2_list_t
             ),
         cast( multiset(select * from ku$_pkref_constraint_view con
                        where con.obj_num = t.obj#
                       ) as ku$_pkref_constraint_list_t
             ),
         (select value(ov) from ku$_ov_table_view ov
          where ov.bobj_num = t.obj#),
         (select value (po) from ku$_iot_partobj_view po
          where t.obj# = po.obj_num),
         (select value(etv) from ku$_exttab_view etv
                        where etv.obj_num = o.obj_num),
         (select value(otv) from ku$_cube_tab_view otv
                        where otv.obj_num = o.obj_num),
         0
  from ku$_schemaobj_view o, tab$ t, ind$ i, ts$ ts
  where t.obj# = o.obj_num
        and t.pctused$ = i.obj#          -- For IOTs, pctused has index obj#
        and bitand(t.property, 32+64+512)  = 32+64  -- PIOT but not overflow
        and  i.ts# = ts.ts#
        AND     (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_piotable_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_piotable_view of ku$_piotable_t 
  with object OID(obj_num)
  as select t.* from ku$_piotable_view t
  where bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_piotable_view to public
/

-------------------------------------------------------------------------------
--                     TABLE_OBJNUM, TABLE_TYPES, DOMIDX_OBJNUM
-------------------------------------------------------------------------------

create or replace type ku$_table_objnum_t as object
(
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  base_obj      ku$_schemaobj_t            /* base object (if nested table) */
)
/
grant execute on ku$_table_objnum_t to public
/

-- Views for fetching table object numbers -- used by heterogeneous object types.
-- This is a UNION of two views, one for top-level tables, one for
-- nested tables.  This allows a BASE_OBJECT_NAME filter to fetch both the
-- top-level table and its nested tables (required for table_export).
-- The "o.owner_name NOT IN(...)" clause does not necessarily list all
-- schemas excluded by sys.ku_noexp_tab, but this is harmless: the goal
-- is to improve performance by reducing the number of objects returned by
-- this view (and subsequently filtered by the query WHERE clause).
-- By the way, rewriting the view to explicitly reference sys.ku_noexp_tab
-- (e.g., o.owner_name NOT IN (select name from sys.ku_noexp_tab where
--  obj_type = 'SCHEMA')) results in a significant drop in performance.
-- Bug 3540185: Don't exclude tables from SYS schema.

create or replace force view ku$_htable_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select t.obj#, value(o), value(o)
  from ku$_schemaobj_view o, sys.tab$ t
  where o.obj_num=t.obj#
  AND bitand(t.property,8192)=0      /* is not a nested table */
  AND bitand(t.flags,536870912)=0    /* not an IOT mapping table */
  AND bitand(trunc(t.property/power(2,32)),2)=0 /* not FBA internal table */
  and (o.owner_name NOT IN ('ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_htable_objnum_view to public
/
create or replace force view ku$_ntable_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select t.obj#, value(o), value(bo)
  from ku$_schemaobj_view o, ku$_schemaobj_view bo, sys.tab$ t
  where o.obj_num=t.obj#
  AND bitand(t.property,8192)!=0      /* is a nested table */
  and bo.obj_num=dbms_metadata_util.get_anc(t.obj#)
  and bo.obj_num!=t.obj#
  and (o.owner_name NOT IN ('ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_ntable_objnum_view to public
/
create or replace force view ku$_table_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select * from ku$_htable_objnum_view
  UNION ALL
  select * from ku$_ntable_objnum_view
/
grant select on ku$_table_objnum_view to public
/

-- nested or ordered collection tables used for xmltype object relational storage
-- are not exported (table or table_data object types). But other dependent object
-- such as indexes should be exported - this view is used to augment table object
-- numbers with xdb storage tables.
create or replace force view ku$_xdb_ntable_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select t.obj#, value(o), value(o)
  from ku$_schemaobj_view o, sys.tab$ t
  where o.obj_num=t.obj#
  AND bitand(t.property,8192)!=0      /* is a nested table */
  and dbms_metadata_util.get_anc(t.obj#,2)
        in (select * from table(dbms_metadata.fetch_objnums))
  and (o.owner_name NOT IN ('ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_xdb_ntable_objnum_view to public
/

-------------------------------------------------------------------------------
--                     DEPENDENT_TABLE_OBJNUM
-------------------------------------------------------------------------------


-- Views for fetching dependent table object numbers -- used by heterogeneous
-- object types, adding to table objnum's.
-- This is a UNION of two views, one for top-level tables, one for
-- nested tables, as dependent tables may have nested tables. Filter allowed
-- are minimal (essentially, nonexistent), as the user should be unaware of 
-- dependent tables.

create or replace force view ku$_hdeptable_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select exdo.d_obj#, value(po), value(do)
  from expdepobj$ exdo, ku$_schemaobj_view po, ku$_schemaobj_view do
  where exdo.p_obj# = po.obj_num 
  AND exdo.d_obj# = do.obj_num
  AND do.TYPE_name='TABLE'
  AND (bitand(do.flags,16)!=16)
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (po.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_hdeptable_objnum_view to public
/
-- here we have 3 related objects (all tables): a parent object (po),
--  a dependent object, and a nested table of the dependent object.
create or replace force view ku$_ndeptable_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select exdo.d_obj#, value(po), value(do)
  from ku$_schemaobj_view po, ku$_schemaobj_view do, 
       ku$_schemaobj_view ndo, sys.tab$ t, expdepobj$ exdo
  where ndo.obj_num=t.obj#
  AND bitand(t.property,8192)!=0      /* ndo is a nested table */
  AND do.obj_num=dbms_metadata_util.get_anc(t.obj#)
  AND exdo.p_obj# = po.obj_num 
  AND exdo.d_obj# = do.obj_num
  AND (bitand(do.flags,16)!=16)
  AND do.TYPE_name='TABLE'
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (po.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on  ku$_ndeptable_objnum_view to public
/
create or replace force view ku$_deptable_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select * from ku$_hdeptable_objnum_view
  UNION ALL
  select * from ku$_ndeptable_objnum_view
/
grant select on ku$_deptable_objnum_view to public
/

-- View for fetching types of top level columns of a table
-- (used by transportable_export)

create or replace view ku$_table_types_view (
 tabobjno, tabname, tabownerno, tabowner, typeobjno, typename, typeowner)
as
 select unique o.obj#,o.name,o.owner#,u.name, d.p_obj#, tyo.name, ou.name
from obj$ o, obj$ tyo, type$ dt, user$ u, user$ ou, dependency$ d, type$ t,
     sys.coltype$ c
where t.toid = c.toid
  and bitand(t.properties,2128)=0     /* not system-generated type */
  and o.obj# = c.obj#
  and o.type# = 2
  and o.owner# != 0                   /* not SYS-owned table */
  and o.owner# = u.user#
  and tyo.owner# = ou.user#
  and o.obj# = d.d_obj#
  and tyo.obj# = d.p_obj#
  and tyo.type# = 13
  and tyo.owner# != 0                 /* not SYS-owned type */
  and tyo.oid$ = dt.toid
  and dt.toid = dt.tvoid    /* only the latest type */
/
grant select on ku$_table_types_view to select_catalog_role
/

-- View for fetching types required for xmlschemas
--   Registering xmlschemas creates types, but on import we must import
--   the type, rather than allowing them to be recreated.
--   This is a dummy definition, which works if XDB is not loaded.
-- (used by transportable_export)

create or replace view ku$_xmlschema_types_view (
 tabobjno,  typeobjno, typename, typeowner)
as
 select 0, 0, NULL, NULL 
    from dual where 1=0
/
grant select on ku$_xmlschema_types_view to select_catalog_role
/

-- View for fetching types required for transportable export
-- (used by transportable_export)

create or replace view ku$_tts_types_view (
 tabobjno, typeobjno, typename, typeowner)
as
    select tabobjno, typeobjno, typename, typeowner
    from  ku$_table_types_view
  UNION ALL
    select tabobjno, typeobjno, typename, typeowner
    from  ku$_xmlschema_types_view
/
grant select on ku$_tts_types_view to select_catalog_role
/


-- View for fetching domain index object numbers 
--   used by heterogeneous object types.
-- See ku$_htable_objnum_view, above.

create or replace force view ku$_domidx_objnum_view of ku$_table_objnum_t
  with object identifier(obj_num) as
  select i.obj#, value(o), value(bo)
  from ku$_schemaobj_view o, ku$_schemaobj_view bo, sys.ind$ i
  where o.obj_num=i.obj#
  and   bo.obj_num=i.bo#
  and   i.type#=9            /* domain index */
  and (o.owner_name NOT IN ('SYS', 'ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_domidx_objnum_view to public
/

-------------------------------------------------------------------------------
--                     TABLE, MVIEW, MVIEW_LOG PROPERTIES
-------------------------------------------------------------------------------

-- View to retrieve table properties; dbms_metadata.get_object uses
--  this to figure out which object_flags to set for a table
-- Note that the order of tables in the from-clause is important:
-- putting tab$ last avoids a full scan of user$ for queries of
-- the form 'schema not in (...)'

create or replace force view ku$_tabprop_view
 (obj_num,name,schema,flags,property)
 as
 select o.obj#, o.name, u.name, o.flags, t.property
 from obj$ o, user$ u, tab$ t
 where o.owner# = u.user#
 and   o.obj#   = t.obj#
 and  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_tabprop_view to public
/

-- need special views to account for reference partitioned tables

create or replace force view sys.ku$_pfhtabprop_view
 (obj_num,name,schema,flags,property)
 as
 select t.obj_num,t.name,t.schema,t.flags,t.property from ku$_tabprop_view t
 where bitand(t.property,32+64+128+256+512)=32 
 and not exists( select * from partobj$ po
             where po.obj# = t.obj_num and po.parttype = 5)
/
grant select on sys.ku$_pfhtabprop_view to public
/

create or replace force view sys.ku$_refparttabprop_view
 (obj_num,name,schema,flags,property)
 as
 select t.obj_num,t.name,t.schema,t.flags,t.property from ku$_tabprop_view t
 where bitand(t.property,32+64+128+256+512)=32 
 and exists( select * from partobj$ po
             where po.obj# = t.obj_num and po.parttype = 5)
/
grant select on sys.ku$_refparttabprop_view to public
/


-- View to do the same for materialized views.

create or replace force view sys.ku$_mvprop_view
 (obj_num,name,schema,flags,property)
 as
 select o.obj#, o.name, u.name, o.flags, t.property
 from obj$ o, tab$ t, user$ u, snap$ s
 where o.owner# = u.user#
 and   o.obj#   = t.obj#
 and   s.sowner = u.name
 and   s.tname  = o.name
 and  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_mvprop_view to public
/

-- ...and for materialized view logs.

create or replace force view sys.ku$_mvlprop_view
 (obj_num,name,schema,flags,property)
 as
 select o.obj#, m.master, m.mowner, o.flags, t.property
 from obj$ o, tab$ t, user$ u, mlog$ m
 where o.owner# = u.user#
 and   o.obj#   = t.obj#
 and   m.mowner = u.name
 and   m.log = o.name
 and  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_mvlprop_view to public
/

-------------------------------------------------------------------------------
--                      TABLES (and other objects) BY TABLESPACE
-------------------------------------------------------------------------------

-- Partitioned and non-partitioned tables in tablespaces.
-- This view is used to implement the TABLESPACE filter.
--
-- tab$.property bits:
--      32      table is partitioned
--      64      index only table
--      512     IOT overflow segment

create or replace view sys.ku$_tts_view ( owner_num, obj_num, ts_name ) as
  select o.owner#, t.obj#, ts.name              -- unpartitioned heap tables
  from   sys.obj$ o, sys.tab$ t, sys.ts$ ts
  where  t.ts#  = ts.ts#
  and    o.obj# = t.obj#
  and    bitand(t.property, 32+64+512) = 0
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- simple partitions
  from   sys.obj$ o, sys.tab$ t, sys.tabpart$ tp, sys.ts$ ts
  where  tp.ts# = ts.ts#
  and    t.obj# = tp.bo#
  and    o.obj# = t.obj#
  and    bitand(t.property, 32+64+512) = 32
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- composite partitions
  from   sys.obj$ o, sys.tab$ t,
         sys.tabcompart$ tcp, sys.tabsubpart$ tsp, sys.ts$ ts
  where  tsp.ts#  = ts.ts#
  and    tcp.obj# = tsp.pobj#
  and    t.obj#   = tcp.bo#
  and    o.obj# = t.obj#
  and    bitand(t.property, 32+64+512) = 32
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- unpartitioned IOTs
  from   sys.obj$ o, sys.tab$ t, sys.ind$ i, sys.ts$ ts
  where  i.ts#    = ts.ts#
    and  i.obj#   = t.pctused$
  and    o.obj# = t.obj#
  and    bitand(t.property, 32+64+512) = 64
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- PIOTs
  from   sys.obj$ o, sys.tab$ t, sys.indpart$ ip, sys.ts$ ts
  where  ip.ts#   = ts.ts#
    and  ip.bo#   = t.pctused$
  and    o.obj# = t.obj#
  and    bitand(t.property, 32+64+512) = 32 + 64
/
grant select on sys.ku$_tts_view to select_catalog_role;

create or replace view sys.ku$_tab_ts_view ( owner_num, obj_num, ts_name ) as
  select t.owner_num, t.obj_num, t.ts_name
  from   sys.ku$_tts_view t
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (t.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_tab_ts_view to public
/

-- Partitioned and non-partitioned indexes in tablespaces.
-- This view is used to implement the TABLESPACE filter.
--
-- ind$.property bits:
--      2       index is partitioned

create or replace view sys.ku$_tts_ind_view ( owner_num, obj_num, ts_name ) as
  select o.owner#, i.obj#, ts.name              -- unpartitioned indexes
  from   sys.obj$ o, sys.ind$ i, sys.ts$ ts
  where  i.ts#  = ts.ts#
  and    o.obj# = i.obj#
  and    bitand(i.property, 2) = 0
 UNION ALL
  select o.owner#, i.obj#, ts.name              -- partitioned indexes
  from   sys.obj$ o, sys.ind$ i, sys.indpart$ ip, sys.ts$ ts
  where  ip.ts# = ts.ts#
  and    i.obj# = ip.bo#
  and    o.obj# = i.obj#
  and    bitand(i.property, 2) = 2
 UNION ALL
  select o.owner#, i.obj#, ts.name              -- composite partitioned indexes
  from   sys.obj$ o, sys.ind$ i,
         sys.indcompart$ icp, sys.indsubpart$ isp, sys.ts$ ts
  where  isp.ts#  = ts.ts#
  and    icp.obj# = isp.pobj#
  and    i.obj#   = icp.bo#
  and    o.obj#   = i.obj#
  and    bitand(i.property, 2) = 2
/
grant select on sys.ku$_tts_ind_view to select_catalog_role;

create or replace view sys.ku$_ind_ts_view ( owner_num, obj_num, ts_name ) as
  select i.owner_num, i.obj_num, i.ts_name
  from   sys.ku$_tts_ind_view i
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (i.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_ind_ts_view to public
/

create or replace view sys.ku$_clu_ts_view ( owner_num, obj_num, ts_name ) as
  select o.owner#, cl.obj#, ts.name
  from   sys.obj$ o, sys.clu$ cl, sys.ts$ ts
  where  cl.ts#  = ts.ts#
  and    o.obj# = cl.obj#
  and  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_clu_ts_view to public
/

-- materialized views

create or replace view sys.ku$_tts_mv_view ( owner_num, obj_num, ts_name ) as
  select o.owner#, t.obj#, ts.name              -- unpartitioned heap tables
  from   sys.obj$ o, sys.tab$ t, sys.user$ u, sys.snap$ s, sys.ts$ ts
  where  s.sowner = u.name
  and    s.tname  = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    t.ts#    = ts.ts#
  and    bitand(t.property, 32+64+512) = 0
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- simple partitions
  from   sys.obj$ o, sys.tab$ t, sys.tabpart$ tp,
         sys.user$ u, sys.snap$ s, sys.ts$ ts
  where  s.sowner = u.name
  and    s.tname  = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    bitand(t.property, 32+64+512) = 32
  and    t.obj#   = tp.bo#
  and    tp.ts#   = ts.ts#
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- composite partitions
  from   sys.obj$ o, sys.tab$ t,
         sys.tabcompart$ tcp, sys.tabsubpart$ tsp,
         sys.user$ u, sys.snap$ s, sys.ts$ ts
  where  s.sowner = u.name
  and    s.tname  = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    bitand(t.property, 32+64+512) = 32
  and    t.obj#   = tcp.bo#
  and    tcp.obj# = tsp.pobj#
  and    tsp.ts#  = ts.ts#
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- IOTs
  from   sys.obj$ o, sys.tab$ t, sys.ind$ i,
         sys.user$ u, sys.snap$ s, sys.ts$ ts
  where  s.sowner = u.name
  and    s.tname  = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    bitand(t.property, 32+64+512) = 64
  and    i.ts#    = ts.ts#
  and    i.obj#   = t.pctused$
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- PIOTs
  from   sys.obj$ o, sys.tab$ t, sys.indpart$ ip,
         sys.user$ u, sys.snap$ s, sys.ts$ ts
  where  s.sowner = u.name
  and    s.tname  = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    bitand(t.property, 32+64+512) = 32 + 64
  and    ip.ts#   = ts.ts#
  and    ip.bo#   = t.pctused$
/
grant select on sys.ku$_tts_mv_view to select_catalog_role
/
create or replace view sys.ku$_mv_ts_view ( owner_num, obj_num, ts_name ) as
  select t.owner_num, t.obj_num, t.ts_name
  from   sys.ku$_tts_mv_view t
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (t.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_mv_ts_view to public
/
-------------------------------------------------------------------------------
--                     MV_DEPTBL_OBJNUM
-- mv_deptbl_objnum view is used to find materialized view temp log tables
--  which must be exported with mv logs in transportable mode.
-------------------------------------------------------------------------------

create or replace type ku$_mv_deptbl_objnum_t as object
(
  obj_num       number                                             /* obj# */
)
/
grant execute on ku$_mv_deptbl_objnum_t to public
/
create or replace view sys.ku$_mv_deptbl_objnum_view of ku$_mv_deptbl_objnum_t
  with object identifier(obj_num) as
  select tlo.obj_num
  from sys.ku$_schemaobj_view mo, sys.ku$_schemaobj_view tlo, sys.mlog$ ml
  where mo.owner_name = ml.mowner and
        mo.name = ml.master and
        mo.owner_num = tlo.owner_num and
        tlo.name = ml.temp_log and
        mo.obj_num in (SELECT * FROM TABLE(DBMS_METADATA.FETCH_OBJNUMS)) and
        (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (mo.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_mv_deptbl_objnum_view to public
/

-- materialized view logs

create or replace view sys.ku$_tts_mvl_view ( owner_num, obj_num, ts_name ) as
  select o.owner#, t.obj#, ts.name              -- unpartitioned heap tables
  from   sys.obj$ o, sys.tab$ t, sys.user$ u, sys.mlog$ m, sys.ts$ ts
  where  m.mowner = u.name
  and    m.log    = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    t.ts#    = ts.ts#
  and    bitand(t.property, 32) = 0
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- simple partitions
  from   sys.obj$ o, sys.tab$ t, sys.tabpart$ tp,
         sys.user$ u, sys.mlog$ m, sys.ts$ ts
  where  m.mowner = u.name
  and    m.log    = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    bitand(t.property, 32) = 32
  and    t.obj#   = tp.bo#
  and    tp.ts#   = ts.ts#
 UNION ALL
  select o.owner#, t.obj#, ts.name              -- composite partitions
  from   sys.obj$ o, sys.tab$ t,
         sys.tabcompart$ tcp, sys.tabsubpart$ tsp,
         sys.user$ u, sys.mlog$ m, sys.ts$ ts
  where  m.mowner = u.name
  and    m.log    = o.name
  and    o.owner# = u.user#
  and    o.type#  = 2
  and    o.obj#   = t.obj#
  and    bitand(t.property, 32) = 32
  and    t.obj#   = tcp.bo#
  and    tcp.obj# = tsp.pobj#
  and    tsp.ts#  = ts.ts#
/
grant select on sys.ku$_tts_mvl_view to select_catalog_role
/
create or replace view sys.ku$_mvl_ts_view ( owner_num, obj_num, ts_name ) as
  select t.owner_num, t.obj_num, t.ts_name
  from   sys.ku$_tts_mvl_view t
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (t.owner_num,0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_mvl_ts_view to public
/

-------------------------------------------------------------------------------
--                              TABLE DATA
-------------------------------------------------------------------------------

-- View to determine if external tables unload method is required and if so, if
-- parallel ET will be allowed on unload.

create or replace force view ku$_unload_method_view
   (obj_num, unload_method, et_parallel)
   as select t.obj#,
      decode (
           -- Condition 1: Table has FGAC for SELECT enabled?
        (select count(*) from rls$ r where r.obj#=t.obj#
                and r.enable_flag=1 and bitand(r.stmt_type,1)=1)
        +  -- Condition 2 and 3: Encrypted cols or queue table?
        bitand(t.trigflag, 65536+8388608)
        + -- Condition 4a: BFILE columns?
        bitand(t.property, 32768)
        + -- Condition 4b: Opaque columns?
        (select count(*) FROM opqtype$ o where o.obj# = t.obj#)
        + -- Condition 5: Cols of evolved types that need upgrading?
        (select count(*) FROM coltype$ c where c.obj#=t.obj# and
                bitand(c.flags,128)>0)
        + -- Condition 6: Any LONG or LONG RAW columns that are not last?
        (select count(*) from col$ c where c.obj#=t.obj# and c.type# IN (8,24)
                and c.segcol# != 
                (select MAX(c2.segcol#) from col$ c2 where c2.obj#=t.obj#) )
        + -- Condition 7: Columns with embedded opaques?
        (select count(*) from coltype$ c, type$ ty where c.obj#=t.obj# and
                c.toid=ty.toid and bitand(ty.properties, 4096) > 0)
        + -- Condition 8: table with column added that has NOT NULL and 
          -- DEFAULT VALUE specified
        (select count(*) from ecol$ e where e.tabobj# = t.obj#)
        + -- Condition 9: target is 10g instance and table contains subtype,
          -- sql_plan_allstat_row_type.  This subtype does not exist in 10.2.
        (select count(*) from subcoltype$ sc where sc.obj# = t.obj# and
                              sc.toid = '00000000000000000000000000020215' and
                              dbms_metadata.get_version < '11.00.00.00.00') 
       , 0, 1, 4),
--
-- NOTE: The values 1 and 4 from the decode above correspond to the constants
-- prefer_direct and require_external from the package kupd$data_int defined in
-- datapump/dml/prvthpdi. If these values ever change in the package, they must
-- be changed here as well. Can't use pkg's constants because catmeta executes
-- before pkg header is installed.
--
  --
  -- Ext. Tbls. cannot unload in parallel if:
  -- 1. FGAC (row level security) is enabled (Why? see comment below...)
  -- 2. It's a nested table
  -- 3. Table contains a LOB (possible with columns of type adt, refs,
  --    varray or lob).
  --
  -- The data layer must execute as invoker's rights for unload on FGAC-enabled
  -- tables so the security of the caller is enforced (security hole if SYS
  -- as definer unloaded the table). But, kxfp processes started in response to
  -- a parallel ET unload would also run as the unprived invoker and they then
  -- fail calling our internal definer's pkg's like queueing and file mgt.
  -- Forcing parallel=1 in this case stays in the context of the worker process
  -- which *can* see the internal pkgs because they share the same owner (SYS).
  --
      decode (
        (select count(*) from rls$ r where r.obj#=t.obj# and r.enable_flag=1)
        +
        bitand(t.property, 2+8+16+8192+262144)
        , 0, 1, 0)  -- 1: Can do ET parallel unload  0: Can't
   from tab$ t
/
grant select on ku$_unload_method_view to select_catalog_role;

--  UDT/view for bytes allocated/table or partition

create or replace type ku$_bytes_alloc_t as object
(
  file_num      number,                        /* segment header file number */
  block_num     number,                       /* segment header block number */
  ts_num        number,                       /* tablespace for this segment */
  bytes_alloc   number                     /* total number of bytes allocated */
)
/
grant execute on ku$_bytes_alloc_t to public
/
create or replace force view ku$_bytes_alloc_view of ku$_bytes_alloc_t
  with object OID(file_num,block_num,ts_num)
  as select s.file_num,s.block_num,ts.ts#,
       case when ts.bitmapped=0
            then ts.blocksize*s.blocks
            else (select sum(ts.blocksize*e.ktfbueblks)
                  from sys.x$ktfbue e
                  where e.ktfbuesegtsn = ts.ts#
                    and e.ktfbuesegfno = s.file_num
                    and e.ktfbuesegbno = s.block_num)
        end
  from ku$_storage_view s, ts$ ts
  where ts.ts#     = s.ts_num
/
grant select on ku$_bytes_alloc_view to select_catalog_role
/
create or replace type ku$_tab_bytes_alloc_t as object
(
  obj_num       number,                                /* table object number */
  bytes_alloc   number                     /* total number of bytes allocated */
)
/
grant execute on ku$_tab_bytes_alloc_t to public
/

-- UDTs/views for the TABLE_DATA object type.

create or replace type ku$_table_data_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  dataobj_num   number,                                /* data layer object# */
                                       /* hashed partitioned tables use obj# */
  name          varchar2(30),                                 /* object name */
  part_name     varchar2(30), /* partition name (if object is a subpartition)*/
  parttype      number,                               /* (sub)partition type */
  property      number,                                    /* table property */
  trigflag      number,                   /* the other table property column */
  xmltype_fmts  number,  /* formats of XMLType columns: 0x01=CLOB; 0x02=BLOB */
  xmlschemacols char(1),          /* 'Y' = table has xmlschema-based columns */
  xml_outofline char(1),          /* 'Y' = table has xmlschema-based columns
                                    and table data is out of line (max is 1) */
  longcol       char(1),         /* 'Y' = table has a long column (max is 1) */
  nft_varray    char(1), /*'Y' = table has varray column with non-final type */
  nonscoped_ref char(1),       /* 'Y' = table has column with non-scoped ref */
  tstz_cols     char(1),                        /* 'Y' = table has TSTZ data */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  ts_name       varchar2(30),                             /* tablespace name */
  blocksize     number,                            /* size of block in bytes */
  bytes_alloc   number,                   /* total number of bytes allocated */
  base_obj      ku$_schemaobj_t,            /* base table/view schema object */
  domidx_obj    ku$_schemaobj_t,        /* domain index (if secondary table) */
  anc_obj       ku$_schemaobj_t, /* base obj of dom idx (if secondary table) */
  unload_method number,              /* Direct Path preferred or ET required */
  et_parallel   number,                /* ET parallel unload possible or not */
  fgac          number,                               /* FGAC enabled or not */
  refpar_level  number                       /* reference partitioning level */
)
/
grant execute on ku$_table_data_t to public
/

-- unpartitioned heap tables

create or replace force view ku$_htable_bytes_alloc_view
                          of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
  as select t.obj#,
            (select b.bytes_alloc from ku$_bytes_alloc_view b
             where b.ts_num = t.ts#
               and b.file_num = t.file#
               and b.block_num = t.block#)
          +decode(bitand(t.property,2048+262144),0,0,   -- add lob storage
            (select sum(b.bytes_alloc) from ku$_bytes_alloc_view b, lob$ l
             where b.ts_num = l.ts#
               and b.file_num = l.file#
               and b.block_num = l.block#
               and l.obj#=t.obj#))
  from tab$ t
/
grant select on ku$_htable_bytes_alloc_view to select_catalog_role
/
create or replace force view ku$_htable_data_view of ku$_table_data_t
  with object OID(obj_num)
  as select '1','2',
         t.obj#, o.dataobj_num,
         o.name,
         NULL,
         0,  /* not partitioned */
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*)                      /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         decode((select count(*) from col$ where obj#=t.obj#
                 and type# in (8,24)),        /* long col - long or long raw */
                 1,'Y','N'),
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         value(o),
         ts.name, ts.blocksize, b.bytes_alloc,
         value(o),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         0
  from  ku$_htable_bytes_alloc_view b, ku$_schemaobjnum_view o, 
        ku$_unload_method_view um, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND t.obj# = um.obj_num
        AND bitand(t.property, 
                   32+64+128+256+512+8192+4194304+8388608+2147483648) = 0
                                                /* not IOT, partitioned,    */
                                                /* nested, temporary or     */
                                                /* external table           */
        AND bitand(trunc(t.property/power(2,32)),2)=0 
                                                /* not FBA internal table   */
        AND bitand(t.flags,536870912)=0         /* not an IOT mapping table */
        AND t.ts# = ts.ts#
        AND b.obj_num=t.obj#
        AND (bitand(o.flags,16)!=16
             OR sys.dbms_metadata.oktoexp_2ndary_table(o.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_htable_data_view to public
/

-- partitions

create or replace force view ku$_htpart_bytes_alloc_view of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
  as select tp.obj#,
            (select b.bytes_alloc from ku$_bytes_alloc_view b
             where b.ts_num = tp.ts#
               and b.file_num = tp.file#
               and b.block_num = tp.block#)
          +decode(bitand(t.property,2048+262144),0,0,   -- add lob storage
            (select sum(b.bytes_alloc) from ku$_bytes_alloc_view b, lobfrag$ l
             where b.ts_num = l.ts#
               and b.file_num = l.file#
               and b.block_num = l.block#
               and l.tabfragobj#=tp.obj#))
  from tab$ t, tabpart$ tp
  where t.obj#=tp.bo#
/
grant select on ku$_htpart_bytes_alloc_view to select_catalog_role
/

-- Note: bug #8692663
--   hashed partitioned tables required obj# rather than dataobj#. This is
--   evident during network imports of a hpart table in which there has been
--   a partition added. To minimize the work (i.e., end of release cycle) we 
--   return obj# in dataobj# field. This allows supporting pieces to work
--   without modification.
create or replace force view ku$_htpart_data_view of ku$_table_data_t
  with object OID(obj_num)
  as select '1','2',
         tp.obj#, tp.obj#,
         o.subname,
         NULL,
         po.parttype,
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*)                      /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         'N',     /* partitioned table cannot have column with LONG datatype */
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         'N',                              /* default 'has_tstz_cols' to 'N' */
         value(o),
         ts.name, ts.blocksize, b.bytes_alloc,
         value(bo),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where bo.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where bo.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         sys.dbms_metadata_util.ref_par_level(bo.obj_num,t.property)
  from ku$_htpart_bytes_alloc_view b,ku$_schemaobj_view o,
       ku$_schemaobjnum_view bo, ku$_unload_method_view um,
       tab$ t, tabpart$ tp, ts$ ts, partobj$ po
  where tp.obj# = o.obj_num
        AND bo.obj_num = po.obj#
        AND t.obj#=tp.bo#
        AND t.obj# = um.obj_num
        AND bitand(t.property, 32+64+128+256+512+8192) = 32
                                                /* partitioned (32)       */
                                                /* but not IOT            */
                                                /* or nested table        */
        AND bitand(t.flags,536870912)=0         /* not an IOT mapping table */
        AND tp.ts# = ts.ts#
        AND b.obj_num=tp.obj#
        AND bo.obj_num=tp.bo#
        AND (bitand(bo.flags,16)!=16
             OR sys.dbms_metadata.oktoexp_2ndary_table(bo.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_htpart_data_view to public
/


-- subpartitions

create or replace force view ku$_htspart_bytes_alloc_view
  of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
  as select tsp.obj#,
            (select b.bytes_alloc from ku$_bytes_alloc_view b
             where b.ts_num = tsp.ts#
               and b.file_num = tsp.file#
               and b.block_num = tsp.block#)
          +decode(bitand(t.property,2048+262144),0,0,   -- add lob storage
            (select sum(b.bytes_alloc) from ku$_bytes_alloc_view b, lobfrag$ l
             where b.ts_num = l.ts#
               and b.file_num = l.file#
               and b.block_num = l.block#
               and l.tabfragobj#=tsp.obj#))
  from tab$ t, tabcompart$ tcp, tabsubpart$ tsp
  where t.obj#=tcp.bo#
    AND tcp.obj# = tsp.pobj#
/
grant select on ku$_htspart_bytes_alloc_view to select_catalog_role
/
-- Note: bug #8692663
--   hashed partitioned tables required obj# rather than dataobj#. This is
--   evident during network imports of a hpart table in which there has been
--   a partition added. To minimize the work (i.e., end of release cycle) we 
--   return obj# in dataobj# field. This allows supporting pieces to work
--   without modification.
create or replace force view ku$_htspart_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as select '1','2',
         tsp.obj#, tsp.obj#,
         o.subname,
         (select po.subname from obj$ po where po.obj#=tsp.pobj#),
         po.parttype,
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*)                      /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         'N',     /* partitioned table cannot have column with LONG datatype */
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         'N',                              /* default 'has_tstz_cols' to 'N' */
         value(o),
         ts.name, ts.blocksize, b.bytes_alloc,
         value(bo),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where bo.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where bo.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         sys.dbms_metadata_util.ref_par_level(bo.obj_num,t.property)
  from ku$_htspart_bytes_alloc_view b,
        ku$_schemaobj_view o, ku$_schemaobjnum_view bo,
        ku$_unload_method_view um, tab$ t, tabcompart$ tcp,
        tabsubpart$ tsp, ts$ ts, partobj$ po
  where tsp.obj# = o.obj_num
        AND bo.obj_num = po.obj#
        AND t.obj#=tcp.bo#
        AND t.obj# = um.obj_num
        AND bitand(t.property, 32+64+128+256+512+8192) = 32
                                                /* partitioned (32)       */
                                                /* but not IOT            */
                                                /* or nested table        */
        AND bitand(t.flags,536870912)=0         /* not an IOT mapping table */
        AND tsp.ts# = ts.ts#
        AND tcp.obj# = tsp.pobj#
        AND b.obj_num=tsp.obj#
        AND bo.obj_num=tcp.bo#
        AND (bitand(bo.flags,16)!=16
             OR sys.dbms_metadata.oktoexp_2ndary_table(bo.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_htspart_data_view to public
/

-- IOTs

create or replace force view ku$_iotable_bytes_alloc_view
 of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
  as select t.obj#,
            (select b.bytes_alloc from ku$_bytes_alloc_view b
             where b.ts_num = i.ts#
               and b.file_num = i.file#
               and b.block_num = i.block#)
          +decode(bitand(t.property,2048+262144),0,0,   -- add lob storage
            (select sum(b.bytes_alloc) from ku$_bytes_alloc_view b, lob$ l
             where b.ts_num = l.ts#
               and b.file_num = l.file#
               and b.block_num = l.block#
               and l.obj#=t.obj#))
  from ind$ i, tab$ t
  where t.pctused$ = i.obj#          -- For IOTs, pctused has index obj#
/
grant select on ku$_iotable_bytes_alloc_view to select_catalog_role
/

create or replace force view ku$_iotable_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as select '1','2',
         t.obj#, o.dataobj_num,
         o.name,
         NULL,
         0,
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*)                      /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         'N',                   /* IOT can't contain long or long raw column */
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         value(o),
         ts.name, ts.blocksize, b.bytes_alloc,
         value(o),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where o.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(o.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where o.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         0
  from  ku$_iotable_bytes_alloc_view b,
        ku$_schemaobjnum_view o, ku$_unload_method_view um, tab$ t, ind$ i, ts$ ts
  where t.obj# = o.obj_num
        AND t.obj# = um.obj_num
        and bitand(t.property, 64+512) = 64  -- IOT but not overflow
        and bitand(t.property, 32+8192) = 0     /* but not partitioned    */
                                                /* or nested table        */
        and t.pctused$ = i.obj#          -- For IOTs, pctused has index obj#
        AND i.ts# = ts.ts#
        AND b.obj_num=t.obj#
        AND (bitand(o.flags,16)!=16
             OR sys.dbms_metadata.oktoexp_2ndary_table(o.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_iotable_data_view to public
/

-- PIOT partitions

create or replace force view ku$_iotpart_bytes_alloc_view
  of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
  as select ip.obj#,
            (select b.bytes_alloc from ku$_bytes_alloc_view b
             where b.ts_num = ip.ts#
               and b.file_num = ip.file#
               and b.block_num = ip.block#)
          +decode(bitand(t.property,2048+262144),0,0,   -- add lob storage
            (select sum(b.bytes_alloc)
             from ku$_bytes_alloc_view b, lob$ l,lobfrag$ lf
             where lf.frag#=ip.part# and t.obj#=l.obj# and l.lobj#=lf.parentobj#
               and b.ts_num = lf.ts#
               and b.file_num = lf.file#
               and b.block_num = lf.block#))
  from ind$ i, indpart$ ip, tab$ t
  where i.bo#=t.obj#
    and ip.bo#=i.obj#
    and i.type#=4           -- iot index
/
grant select on ku$_iotpart_bytes_alloc_view to select_catalog_role
/

-- dataobj_num is used in network mode to select a partition;
-- for IOTs this should be the obj# of the index partition whose
-- base object name = the table name (other data is for the index partition
-- whose base object name is the associated index)
-- Note: type# check is done to eliminate different object types which
--       have the same name as the baseobj.
create or replace force view ku$_iotpart_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as select '1','2',
         ip.obj#,
         (select o1.obj# 
          from obj$ o1
          where o1.name=bo.name
            and o1.subname=o.subname
            and o1.owner#=o.owner_num
            and o1.type# in (19,34)),                         /* see note above */
         o.subname,
         NULL,
         po.parttype,
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*)                      /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         'N',     /* partitioned table cannot have column with LONG datatype */
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         'N',                              /* default 'has_tstz_cols' to 'N' */
         value(o),
         ts.name, ts.blocksize, b.bytes_alloc,
         value(bo),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where bo.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where bo.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         0   -- note: piot cannot be ref partitioned
  from  ku$_iotpart_bytes_alloc_view b,
        ku$_schemaobj_view o, ku$_schemaobjnum_view bo,
        ku$_unload_method_view um, tab$ t,
        ind$ i, indpart$ ip, ts$ ts, partobj$ po
  where ip.obj# = o.obj_num
        AND o.type_num = 20     -- index partition
        AND bo.obj_num = po.obj#
        AND ip.bo#=i.obj#
        AND i.type#=4           -- iot index
        AND i.bo#=t.obj#
        AND t.obj# = um.obj_num
        AND ip.ts# = ts.ts#
        AND b.obj_num=ip.obj#
        AND bo.obj_num=i.bo#
        AND (bitand(bo.flags,16)!=16
             OR sys.dbms_metadata.oktoexp_2ndary_table(bo.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_iotpart_data_view to public
/

-- nested tables
create or replace force view ku$_ntable_bytes_alloc_view
 of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
  as select case when bitand(t.property,64)=0
                 then (select value(b1) from ku$_htable_bytes_alloc_view b1
                       where b1.obj_num = t.obj#)
                 else (select value(b2) from ku$_iotable_bytes_alloc_view b2
                       where b2.obj_num = t.obj#)
                 end
  from tab$ t
/
grant select on ku$_ntable_bytes_alloc_view to select_catalog_role
/

create or replace force view ku$_ntable_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as select '1','2',
         t.obj#, o.dataobj_num,
         o.name,
         NULL,
         0,
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*)                      /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         'N',                    /* nested table can't have long or long raw */
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         value(o),
         ts.name, ts.blocksize, 
	(select b.bytes_alloc from ku$_ntable_bytes_alloc_view b
	  where b.obj_num=t.obj#) bytes_alloc,
         value(bo),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where bo.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where bo.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         0
  from  ku$_schemaobj_view o, ku$_schemaobjnum_view bo,
        ku$_unload_method_view um, tab$ t, ts$ ts
  where t.obj# = o.obj_num
        AND t.obj# = um.obj_num
        AND bitand(t.property,8192)!=0      /* is a nested table */
        AND bitand(t.property,32) =0        /* is not partitioned */
        AND t.ts# = ts.ts#
        AND bo.obj_num=dbms_metadata_util.get_anc(t.obj#)
        AND (bitand(bo.flags,16)!=16
             OR sys.dbms_metadata.oktoexp_2ndary_table(bo.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_ntable_data_view to public
/
-- equipartition nested table
create or replace force view ku$_eqntable_bytes_alloc_view 
			of ku$_tab_bytes_alloc_t
  with object OID(obj_num)
as select tp.obj#,
            (select b.bytes_alloc from ku$_bytes_alloc_view b
             where b.ts_num = tp.ts#
               and b.file_num = tp.file#
               and b.block_num = tp.block#)
  from tab$ t, tabpart$ tp
  where t.obj#=tp.bo# 
        and bitand(t.property, 32+8192+536870912)=536879136
        
/
grant select on ku$_eqntable_bytes_alloc_view to select_catalog_role
/

create or replace force view ku$_eqntable_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as select '1','2',
         tp.obj#,  o.dataobj_num,
         o.subname,
         NULL,
         0,
         t.property,
         t.trigflag,
         dbms_metadata_util.get_xmltype_fmts(t.obj#),
         decode((select 1 from dual where 
                 (exists (select q.obj# from sys.opqtype$ q
                          where q.obj#=t.obj#
                          and q.type=1                        /* xmltype col */
                          and bitand(q.flags,2+64)!=0))),       /* CSX or SB */
                1,'Y','N'),
         decode((select count(*) 	             /* outofline xml table */
                    from sys.opqtype$ q 
                    where q.obj# = t.obj# and
                          bitand(q.flags, 32) = 32 ),
                1,'Y','N'),
         'N',                    /* nested table can't have long or long raw */
         decode((select count(*) from sys.type$ ty, sys.coltype$ ct
                 where ty.toid=ct.toid and ty.version#=ct.version#
                 and ct.obj#=t.obj#
                 /* 0x00008000 =   32768 = contains varray attribute */
                 /* 0x00100000 = 1048576 = has embedded non final type */
                 and bitand(ty.properties,1081344)=1081344),
                 0,'N','Y'),
         decode((select count(*) from sys.refcon$ rf, sys.col$ c
                 where c.obj#=rf.obj# and c.intcol#=rf.intcol# 
                 and c.obj#=t.obj#
                 and bitand(rf.reftyp,1)=0),            /* ref is non-scoped */
                 0,'N','Y'),
         (select sys.dbms_metadata_util.has_tstz_cols(t.obj#) from dual),
         value(o),
         ts.name, ts.blocksize, b.bytes_alloc,
         value(bo),
         -- if this is a secondary table, get domidx obj and ancestor obj
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, secobj$ s
              where bo.obj_num=s.secobj#
                and oo.obj_num=s.obj#
                and rownum < 2),
           null),
         decode(bitand(bo.flags, 16), 16, 
           (select value(oo) from ku$_schemaobj_view oo, ind$ i, secobj$ s
              where bo.obj_num=s.secobj#
                and i.obj#=s.obj#
                and oo.obj_num=i.bo#
                and rownum < 2),
           null),
         um.unload_method,
         um.et_parallel,
         (select count(*) from rls$ r
          where r.obj#=t.obj# and r.enable_flag=1 and bitand(r.stmt_type,1)=1),
         sys.dbms_metadata_util.ref_par_level(tp.bo#,t.property)
  from ku$_eqntable_bytes_alloc_view b,ku$_schemaobj_view o,
       ku$_schemaobjnum_view bo, ku$_unload_method_view um,
       tab$ t, ntab$ nt, tabpart$ tp, ts$ ts
  where tp.obj# = o.obj_num
        AND t.obj#=tp.bo#
        AND t.obj# = um.obj_num
        AND bitand(t.property, 32+8192+536870912)=536879136
        AND tp.ts# = ts.ts#
        AND b.obj_num=tp.obj#
	AND nt.ntab#=tp.bo#  
        AND bo.obj_num=dbms_metadata_util.get_anc(t.obj#)
        AND (bitand(bo.flags,16)!=16
            OR sys.dbms_metadata.oktoexp_2ndary_table(bo.obj_num)=1)
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_eqntable_data_view to public
/

-- UNION

create or replace force view ku$_table_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as 
  select * from ku$_htable_data_view
  UNION ALL
  select * from ku$_htpart_data_view
  UNION ALL
  select * from ku$_htspart_data_view
  UNION ALL
  select * from ku$_ntable_data_view
  UNION ALL  
  select * from ku$_eqntable_data_view   
  UNION ALL
  select * from ku$_iotable_data_view
  UNION ALL
  select * from ku$_iotpart_data_view
/
grant select on ku$_table_data_view to public
/

-- 10_2 view excludes tables with reference partitioning
--  (but includes equipartitioned nested tables -- the user should
--   be able to move the data to a non-partitioned NT on the target;
--   nested table partitions always have refpar > 0)

create or replace force view ku$_10_2_table_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as 
  select t.* from ku$_htable_data_view t
  where refpar_level = 0
  UNION ALL
  select t.* from ku$_htpart_data_view t
  where refpar_level = 0
  UNION ALL
  select t.* from ku$_htspart_data_view t
  where refpar_level = 0
  UNION ALL
  select t.* from ku$_ntable_data_view t
  where refpar_level = 0
  UNION ALL  
  select * from ku$_eqntable_data_view   
  UNION ALL
  select t.* from ku$_iotable_data_view t
  where refpar_level = 0
  UNION ALL
  select t.* from ku$_iotpart_data_view t
  where refpar_level = 0
/
grant select on ku$_10_2_table_data_view to public
/

-- 10_1 view excludes tables with encrypted columns.

create or replace force view ku$_10_1_table_data_view of ku$_table_data_t 
  with object OID(obj_num)
  as 
  select t.* from ku$_htable_data_view t
  where refpar_level = 0 and bitand(t.trigflag,65536+131072)=0
  UNION ALL
  select t.* from ku$_htpart_data_view t
  where refpar_level = 0 and bitand(t.trigflag,65536+131072)=0
  UNION ALL
  select t.* from ku$_htspart_data_view t
  where refpar_level = 0 and bitand(t.trigflag,65536+131072)=0
  UNION ALL
  select t.* from ku$_ntable_data_view t
  where refpar_level = 0 and bitand(t.trigflag,65536+131072)=0
  UNION ALL  
  select t.* from ku$_eqntable_data_view t
  where bitand(t.trigflag,65536+131072)=0
  UNION ALL
  select t.* from ku$_iotable_data_view t
  where refpar_level = 0 and bitand(t.trigflag,65536+131072)=0
  UNION ALL
  select t.* from ku$_iotpart_data_view t
  where refpar_level = 0 and bitand(t.trigflag,65536+131072)=0
/
grant select on ku$_10_1_table_data_view to public
/

--
-- Create a view to fetch the partition and subpartition names of partitioned
-- and subpartitioned tables.
--
create or replace view ku$_tab_subname_view (
    tab_owner, tab_name, tab_part_name, tab_subpart_name, tsname) as
  --
  -- Select partition names if the table is partitioned
  --
  SELECT sov.owner_name, sov.name, sov.subname, NULL, ts$.name
  FROM   sys.ku$_schemaobj_view sov, tabpart$ tp, ts$
  WHERE  sov.obj_num=tp.obj# AND
         tp.ts# = ts$.ts# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (sov.owner_num, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
UNION ALL
  SELECT sov.owner_name, sov.name, bo.subname, sov.subname, ts$.name
  FROM   sys.ku$_schemaobj_view sov, sys.obj$ bo, tabsubpart$ tsp,
         tabcompart$ tcp, ts$
  WHERE  tsp.obj# = sov.obj_num AND
         tcp.obj# = tsp.pobj# AND
         tcp.obj# = bo.obj# AND
         tsp.ts# = ts$.ts# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (sov.owner_num, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles
                   WHERE role='SELECT_CATALOG_ROLE' ))
UNION ALL
  SELECT sov.owner_name, sov.name, sov.subname, NULL, ts$.name
  FROM   sys.ku$_schemaobj_view sov, indpart$ ip, ind$ i, ts$
  WHERE  ip.obj# = sov.obj_num AND
         ip.bo# = i.obj# AND
         i.type# = 4 AND
         ip.ts# = ts$.ts# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (sov.owner_num, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_tab_subname_view to public;

--
-- Create a view to fetch the partition and subpartition names of partitioned
-- and subpartitioned global indexes.
--
create or replace view ku$_ind_subname_view (
    tab_owner, ind_owner, tab_name, ind_name, tab_part_name, ind_part_name,
    tab_subpart_name, ind_subpart_name, tsname) as
  --
  -- Select partition names if the table is partitioned
  --
  SELECT tsov.owner_name, isov.owner_name, tsov.name, isov.name, tsov.subname,
         isov.subname, NULL, NULL, ts$.name
  FROM   sys.ku$_schemaobj_view tsov, sys.ku$_schemaobj_view isov, tabpart$ tp,
         ind$ i, indpart$ ip, ts$
  WHERE  tsov.obj_num=tp.obj# AND
         isov.obj_num=ip.obj# AND
         i.obj# = ip.bo# AND
         i.bo# = tp.bo# AND
         ip.ts# = ts$.ts# AND
         ip.part# = tp.part# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (isov.owner_num, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
UNION ALL
  SELECT tsov.owner_name, isov.owner_name,  tsov.name, isov.name, tpo.subname,
         ipo.subname, tsov.subname, isov.subname, ts$.name
  FROM   sys.ku$_schemaobj_view tsov, sys.ku$_schemaobj_view isov,
         sys.obj$ tpo, sys.obj$ ipo, sys.tabsubpart$ tsp, sys.tabcompart$ tcp,
         sys.indcompart$ icp, sys.ind$ i, indsubpart$ isp, ts$
  WHERE  tsov.obj_num=tsp.obj# AND
         isov.obj_num=isp.obj# AND
         isp.pobj# = icp.obj# AND
         tsp.pobj# = tcp.obj# AND
         tpo.obj# = tcp.obj# AND
         isp.subpart# = tsp.subpart# AND
         icp.part# = tcp.part# AND
         icp.bo# = i.obj# AND
         i.bo# = tcp.bo# AND
         ipo.obj# = icp.obj# AND
         isp.ts# = ts$.ts# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (isov.owner_num, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_ind_subname_view to public;

-------------------------------------------------------------------------------
--                              POST_DATA_TABLE
-------------------------------------------------------------------------------

-- Do Post Data Table properties
--  initially, this is the 'minimize records_per_block' table property,
--      which affects bitmap indexes
--   metadata for this feature is bit 0x8000 set in tab$/spare1.
--
-- BUT! (based on mail 7/28/2009)
--  spare1 in tab$ stores the hakan flag . It is also overloaded (for reasons
--  that escape me) to store the obj# of the parent IOT for an IOT transient
--  table (a temporary IOT table created during ddl's on IOTs). So if flag
--  value 0x00100000 (KQLDTVNTF_IOTPMO) is not set in tab$/trigflag then
--  checking for 0x8000 set in tab$/spare1 is the way to know if minimize
--  records per block has been done.
create or replace type ku$_post_data_table_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                 /* obj# of base obj. */
  schema_obj    ku$_schemaobj_t,                           /* base obj. info */
  spare1        number   /* 32768 (0x8000) set if minimize records per block */
)
/

grant execute on ku$_post_data_table_t to public
/

-- View for post data table
create or replace force view ku$_post_data_table_view of ku$_post_data_table_t
  with object identifier (obj_num) as
  select '1','1',
         t.obj#, value(o), 
         t.spare1
  from sys.ku$_schemaobj_view o, sys.tab$ t
  where t.obj#=o.obj_num and
        bitand(t.spare1,32768)!=0 and
        bitand(t.trigflag,1048576)=0 and
        (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/

grant select on ku$_post_data_table_view to public
/

-------------------------------------------------------------------------------
--                              DPSTREAM_TABLE
-------------------------------------------------------------------------------

-- Table metadata needed for the DataPump data layer.

create or replace type ku$_strmsubcoltype_t as object
(
  obj_num       number,                               /* obj# of base object */
  intcol_num    number,                            /* internal column number */
  owner_name    varchar2(30),                                  /* owner name */
  name          varchar2(30),                                 /* object name */
  toid          raw(16),                                             /* toid */
  version       number,                      /* internal type version number */
  hashcode      raw(17),                                 /* Version hashcode */
  typeid        raw(16)  /* short typeid value (for non final and sub types) */
)
/
grant execute on ku$_strmsubcoltype_t to public
/
create or replace type ku$_strmsubcoltype_list_t
 as table of ku$_strmsubcoltype_t
/
grant execute on ku$_strmsubcoltype_list_t to public
/
create or replace force view ku$_strmsubcoltype_view of ku$_strmsubcoltype_t
  with object identifier (obj_num,intcol_num,toid) as
  select sct.obj#, sct.intcol#,
         o.owner_name, o.name,
         sct.toid,
         t.version#,
         sys.dbms_metadata.get_hashcode(o.owner_name,o.name),
         t.typeid
    from ku$_schemaobj_view o, type$ t, subcoltype$ sct
    where o.oid=sct.toid and o.oid=t.toid
/
grant select on ku$_strmsubcoltype_view to select_catalog_role
/
create or replace type ku$_strmcoltype_t as object
(
  obj_num       number,                               /* obj# of base object */
  col_num       number,                                     /* column number */
  intcol_num    number,                            /* internal column number */
  owner_name    varchar2(30),                                  /* owner name */
  name          varchar2(30),                                 /* object name */
  flags         number,                                             /* flags */
                     /* flags to indicate whether column type is ADT, Array, */
                                                      /* REF or Nested table */
                           /* 0x02 - adt column                              */
                           /* 0x04 - nested table column                     */
                           /* 0x08 - varray column                           */
                           /* 0x10 - ref column                              */
                           /* 0x20 - retrieve collection out-of-line         */
                           /* 0x20 - don't strip the null image              */
                           /* 0x40 - don't chop null image                   */
                           /* 0x40 - collection storage specified            */
                           /* 0x80 - column stores an old (8.0) format image */
                          /* 0x100 - data for this column not yet upgraded   */
                          /* 0x200 - ADT column is substitutable             */
                          /* 0x400 - NOT SUBSTITUTABLE specified explicitly  */
                          /* 0x800 - SUBSTITUTABLE specified explicitly      */
                         /* 0x1000 - implicitly not substitutable            */
                         /* 0x2000 - The typeid column stores the toid       */
                         /* 0x4000 - The column is an opaque type column     */
                         /* 0x8000 - nested table name is system generated   */
  opqflags      number,                         /* flags for the opaque type */
                              /* -------------- XMLType flags ---------
                               * 0x0001 (1) -- XMLType stored as object
                               * 0x0002 (2) -- XMLType schema is specified
                               * 0x0004 (4) -- XMLType stored as lob 
                               * 0x0008 (8) -- XMLType stores extra column
                               * 0x0020 (32)-- XMLType table is out-of-line 
                               * 0x0040 (64)-- XMLType store as binary xml
                               */
  toid          raw(16),                                             /* toid */
  version       number,                      /* internal type version number */
  hashcode      raw(17),                                 /* Version hashcode */
  typidcol_num  number,           /* intcol# of the type discriminant column */
  subtype_list  ku$_strmsubcoltype_list_t                /* subtype metadata */
)
/
grant execute on ku$_strmcoltype_t to public
/
create or replace force view ku$_strmcoltype_view
  of ku$_strmcoltype_t with object identifier(obj_num, intcol_num) as
  select ct.obj#, ct.col#, ct.intcol#,
         o.owner_name, o.name,
         ct.flags,
         (select opq.flags from sys.opqtype$ opq
          where opq.obj#=ct.obj# and opq.intcol#=ct.intcol#),
         ct.toid,
         ct.version#,
         sys.dbms_metadata.get_hashcode(o.owner_name,o.name),
         ct.typidcol#,
         /* look up stuff in subcoltype$ only if column is substitutable */
         decode(bitand(ct.flags, 512), 512,
           cast(multiset(select sct.* from ku$_strmsubcoltype_view sct
                where ct.obj#    = sct.obj_num
                and   ct.intcol# = sct.intcol_num
                       ) as ku$_strmsubcoltype_list_t
                ),
           null)
    from ku$_schemaobj_view o, obj$ oo, coltype$ ct
         where ct.toid = oo.oid$
         and o.obj_num = oo.obj#
/
grant select on ku$_strmcoltype_view to select_catalog_role
/
--
-- strmsubcoltype_view for 10g compatibility
-- Exclude subtype SYS.SQL_PLAN_ALLSTAT_ROW_TYPE from 10.2 dump file.
-- This subtype is not defined on 10.2, and including it in the stream metadata
-- will cause 10g import to fail.  
-- For a full description of the problem, see the routine header for 
-- dbms_metadata_int.is_att_valid_on_10 in prvtmeti.sql.
--
create or replace force view ku$_10_2_strmsubcoltype_view of 
                                                     ku$_strmsubcoltype_t
  with object identifier (obj_num,intcol_num,toid) as
  select sct.obj#, sct.intcol#,
         o.owner_name, o.name,
         sct.toid,
         t.version#,
         sys.dbms_metadata.get_hashcode(o.owner_name,o.name),
         t.typeid
    from ku$_schemaobj_view o,type$ t, subcoltype$ sct
    where o.oid=sct.toid and o.oid=t.toid and
         NOT(o.name = 'SQL_PLAN_ALLSTAT_ROW_TYPE' and 
             o.owner_name = 'SYS') 
/
grant select on ku$_10_2_strmsubcoltype_view to select_catalog_role
/
--
-- strmcoltype for 10g compatibility
--
create or replace type ku$_10_2_strmcoltype_t as object
(
  obj_num       number,                               /* obj# of base object */
  col_num       number,                                     /* column number */
  intcol_num    number,                            /* internal column number */
  owner_name    varchar2(30),                                  /* owner name */
  name          varchar2(30),                                 /* object name */
  flags         number,                                             /* flags */
                     /* flags to indicate whether column type is ADT, Array, */
                                                      /* REF or Nested table */
                           /* 0x02 - adt column                              */
                           /* 0x04 - nested table column                     */
                           /* 0x08 - varray column                           */
                           /* 0x10 - ref column                              */
                           /* 0x20 - retrieve collection out-of-line         */
                           /* 0x20 - don't strip the null image              */
                           /* 0x40 - don't chop null image                   */
                           /* 0x40 - collection storage specified            */
                           /* 0x80 - column stores an old (8.0) format image */
                          /* 0x100 - data for this column not yet upgraded   */
                          /* 0x200 - ADT column is substitutable             */
                          /* 0x400 - NOT SUBSTITUTABLE specified explicitly  */
                          /* 0x800 - SUBSTITUTABLE specified explicitly      */
                         /* 0x1000 - implicitly not substitutable            */
                         /* 0x2000 - The typeid column stores the toid       */
                         /* 0x4000 - The column is an opaque type column     */
                         /* 0x8000 - nested table name is system generated   */
  /* opqflags not present in 10g */
  toid          raw(16),                                             /* toid */
  version       number,                      /* internal type version number */
  hashcode      raw(17),                                 /* Version hashcode */
  typidcol_num  number,           /* intcol# of the type discriminant column */
  subtype_list  ku$_strmsubcoltype_list_t                /* subtype metadata */
)
/
grant execute on ku$_10_2_strmcoltype_t to public
/
create or replace force view ku$_10_2_strmcoltype_view
  of ku$_10_2_strmcoltype_t with object identifier(obj_num, intcol_num) as
  select ct.obj#, ct.col#, ct.intcol#,
         o.owner_name, o.name,
         ct.flags,
--
-- opq.flags not present in 10g
--         (select opq.flags from sys.opqtype$ opq
--          where opq.obj#=ct.obj# and opq.intcol#=ct.intcol#),
         ct.toid,
         ct.version#,
         sys.dbms_metadata.get_hashcode(o.owner_name,o.name),
         ct.typidcol#,
         /* look up stuff in subcoltype$ only if column is substitutable */
         decode(bitand(ct.flags, 512), 512,
           cast(multiset(select sct.* from ku$_10_2_strmsubcoltype_view sct
                where ct.obj#    = sct.obj_num
                and   ct.intcol# = sct.intcol_num
                       ) as ku$_strmsubcoltype_list_t
                ),
           null)
    from ku$_schemaobj_view o, obj$ oo, coltype$ ct
         where ct.toid = oo.oid$
         and o.obj_num = oo.obj#
/
grant select on ku$_10_2_strmcoltype_view to select_catalog_role
/
create or replace type ku$_strmcol_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                          /* column number as created */
  intcol_num    number,                            /* internal column number */
  segcol_num    number,                          /* column number in segment */
  col_sortkey   number,                              /* sort key for columns */
  base_intcol_num number,    /* internal column number of base column, i.e., */
                           /* the intcol# of the first column with this col# */
  base_col_type number, /* base column type: 1 = UDT, 2 = XMLType OR or CSX, */
                        /*                   3 = XMLType as CLOB,  4 = NTB,
                                             0 = other */          
  property      number,                     /* column properties (bit flags) */
                /* 0x0400 =    1024 = nested table columns setid             */
            /* 0x00800000 = 8388608 = string column measured in characters   */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000),/* name of type attr. column: null if != type */
  type_num      number,                               /* data type of column */
  length        number,                         /* length of column in bytes */
  precision_num number,                                         /* precision */
  scale         number,                                             /* scale */
  not_null      number,                               /* 0 = nulls permitted */
                                                 /* > 0 = no NULLs permitted */
  charsetid     number,                              /* NLS character set id */
  charsetform   number,                 
  charlength    number,            /* maximum number of characters in string */
  lob_property  number,                    /* lob$.property if column is lob */
                                /* 0x0200 = LOB data in little endian format */
  typemd        ku$_strmcoltype_t,
  base_col_name varchar2(30)
)
/
grant execute on ku$_strmcol_t to public
/
create or replace type ku$_strmcol_list_t as table of ku$_strmcol_t
/
grant execute on ku$_strmcol_list_t to public
/
create or replace force view ku$_strmcol_view of ku$_strmcol_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#, c.col#, c.intcol#, c.segcol#,
         /* column sortkey: in principle we want to sort by segcol#. 
            segcol# for xmltype is 0
            so replace it with the segcol# of the lob that
            contains the data */
         case when (c.segcol# = 0 and c.type# = 58) then
          NVL((select cc.segcol# from col$ cc, opqtype$ opq
              where opq.obj#=c.obj# 
                and opq.intcol#=c.intcol#
                and opq.type=1
                and cc.intcol#=opq.lobcol
                and cc.obj#=c.obj#),0)
          else c.segcol#
         end,
         case c.col# when c.intcol# then c.intcol#
          else sys.dbms_metadata_util.get_base_intcol_num(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         case c.col# when c.intcol# then 0
          else 
            sys.dbms_metadata_util.get_base_col_type(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         -- get column  properties
         sys.dbms_metadata_util.get_col_property(c.obj#,c.intcol#),
         c.name,
         decode(bitand(c.property,1024),0,
         (select a.name from attrcol$ a where
                        a.obj#=c.obj# and a.intcol#=c.intcol#),
           (select a.name from attrcol$ a where c.intcol#>1 and
                        a.obj#=c.obj# and a.intcol#=c.intcol#-1)),
         c.type#, c.length,
         c.precision#, c.scale, c.null$,
         c.charsetid, c.charsetform, c.spare3,
         -- get lob property if type# = 112 (DTYCLOB)
         decode(c.type#,112,
                 sys.dbms_metadata_util.get_lob_property(c.obj#,c.intcol#),
                 null),
         -- get type metadata if type# = 121 (DTYADT)
         --                              123 (DTYNAR)
         --                               58 (DTYOPQ)
         ( select value(ctv) from ku$_strmcoltype_view ctv
                     where c.obj#  = ctv.obj_num
                     and   c.intcol# = ctv.intcol_num
           and   c.type# in (121,123,58) ),
        case c.col# when c.intcol# then NULL
          else 
            sys.dbms_metadata_util.get_base_col_name(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end
  from col$ c
/
grant select on ku$_strmcol_view to select_catalog_role
/
--
-- strmcol for 10g compatibility
--
create or replace type ku$_10_2_strmcol_t as object
(
  obj_num       number,                      /* object number of base object */
  col_num       number,                          /* column number as created */
  intcol_num    number,                            /* internal column number */
  segcol_num    number,                          /* column number in segment */
  /* col_sortkey, base_intcol_num not present on 10g */
  /* base_col_type, base_col_name added for bug fix on 10g */
  base_col_type number, /* base column type: 1 = UDT, 2 = XMLType OR or CSX, */
                        /*                   3 = XMLType as CLOB,  0 = other */
  base_col_name varchar2(30),      /* for any xmltype, name of xmltype column*/
  property      number,                     /* column properties (bit flags) */
                /* 0x0400 =    1024 = nested table columns setid             */
            /* 0x00800000 = 8388608 = string column measured in characters   */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000),/* name of type attr. column: null if != type */
  type_num      number,                               /* data type of column */
  length        number,                         /* length of column in bytes */
  precision_num number,                                         /* precision */
  scale         number,                                             /* scale */
  not_null      number,                               /* 0 = nulls permitted */
                                                 /* > 0 = no NULLs permitted */
  charsetid     number,                              /* NLS character set id */
  charsetform   number,                 
  charlength    number,            /* maximum number of characters in string */
  lob_property  number,                    /* lob$.property if column is lob */
                                /* 0x0200 = LOB data in little endian format */
  typemd        ku$_10_2_strmcoltype_t
)
/
grant execute on ku$_10_2_strmcol_t to public
/
create or replace type ku$_10_2_strmcol_list_t as table of ku$_10_2_strmcol_t
/
grant execute on ku$_10_2_strmcol_list_t to public
/
create or replace force view ku$_10_2_strmcol_view of ku$_10_2_strmcol_t 
  with object identifier (obj_num,intcol_num) as
  select c.obj#, c.col#, c.intcol#, c.segcol#,
         -- col_sortkey, base_intcol_num not present on 10g 
         -- base_col_type, base_col_name added for bug fix on 10g 
         case c.col# when c.intcol# then 0
          else 
            sys.dbms_metadata_util.get_base_col_type(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         case c.col# when c.intcol# then NULL
          else 
            sys.dbms_metadata_util.get_base_col_name(c.obj#,c.col#,
                                                          c.intcol#,c.type#)
         end,
         -- get column  properties
         sys.dbms_metadata_util.get_col_property(c.obj#,c.intcol#),
         c.name,
         decode(bitand(c.property,1024),0,
         (select a.name from attrcol$ a where
                        a.obj#=c.obj# and a.intcol#=c.intcol#),
           (select a.name from attrcol$ a where c.intcol#>1 and
                        a.obj#=c.obj# and a.intcol#=c.intcol#-1)),
         c.type#, c.length,
         c.precision#, c.scale, c.null$,
         c.charsetid, c.charsetform, c.spare3,
         -- get lob property if type# = 112 (DTYCLOB)
         decode(c.type#,112,
                 sys.dbms_metadata_util.get_lob_property(c.obj#,c.intcol#),
                 null),
         -- get type metadata if type# = 121 (DTYADT)
         --                              123 (DTYNAR)
         --                               58 (DTYOPQ)
         ( select value(ctv) from ku$_10_2_strmcoltype_view ctv
                     where c.obj#  = ctv.obj_num
                     and   c.intcol# = ctv.intcol_num
           and   c.type# in (121,123,58) )
  from col$ c where dbms_metadata.is_attr_valid_on_10(c.obj#,c.intcol#)=1
/
grant select on ku$_10_2_strmcol_view to select_catalog_role
/
create or replace type ku$_strmtable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  vers_dpapi    number,                           /* direct path API version */
  endianness    number,                 /* 1 = big-endian, 2 = little-endian */
  charset       varchar2(64),                            /* db character set */
  ncharset      varchar2(64),                           /* db ncharacter set */
  dbtimezone    varchar2(64),                          /* database time zone */
  fdo           raw(100),               /* platform Format Descriptor Object */
  obj_num       number,                                              /* obj# */
  owner_name    varchar2(30),                                  /* owner name */
  name          varchar2(30),                                 /* object name */
  pname         varchar2(30),                              /* partition name */
  property      number,                                  /* table properties */
  col_list      ku$_strmcol_list_t                        /* list of columns */
)
/
grant execute on ku$_strmtable_t to public
/
create or replace force view ku$_strmtable_view of ku$_strmtable_t
  with object OID(obj_num)
  as select '1','2',
         (select dbms_metadata_util.get_vers_dpapi from dual),
         (select dbms_metadata_util.get_endianness from dual),
         (select value from v$nls_parameters
                 where parameter='NLS_CHARACTERSET'),
         (select value from v$nls_parameters
                 where parameter='NLS_NCHAR_CHARACTERSET'),
         (select dbtimezone from dual),
         (select utl_xml.getfdo from dual),
         t.obj#,
         o.owner_name, o.name, o.subname,
         t.property, 
         cast( multiset(select * from ku$_strmcol_view c 
                        where c.obj_num = t.obj#
                        and bitand(c.property,32768)=0  -- unused column
                        /* exclude storage columns for xmltype */
                        and sys.dbms_metadata_util.isXml(t.obj#,c.intcol_num)=0
                        /* exclude xmltype heirarchy security (non-portable)
                          for tables having XMLTYPE, and hidden columns
                          named 'ACLOID' or 'OWNERID'  */
                        and not
                            ((exists (select q.obj# from sys.opqtype$ q
                               where q.obj#=t.obj#
                                 and q.type=1)) and           /* xmltype col */
                             (bitand(c.property,32)!=0) and
                             (c.name='OWNERID' or c.name='ACLOID'))
                        order by c.col_sortkey
                        ) as ku$_strmcol_list_t
              )
  from  ku$_schemaobj_view o, tab$ t
  where t.obj# = o.obj_num
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_strmtable_view to public
/
--
-- strmtable for 10g:
--   use 10g strmcol list
--
create or replace type ku$_10_2_strmtable_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  vers_dpapi    number,                           /* direct path API version */
  endianness    number,                 /* 1 = big-endian, 2 = little-endian */
  charset       varchar2(64),                            /* db character set */
  ncharset      varchar2(64),                           /* db ncharacter set */
  dbtimezone    varchar2(64),                          /* database time zone */
  fdo           raw(100),               /* platform Format Descriptor Object */
  obj_num       number,                                              /* obj# */
  owner_name    varchar2(30),                                  /* owner name */
  name          varchar2(30),                                 /* object name */
  pname         varchar2(30),                              /* partition name */
  property      number,                                  /* table properties */
  col_list      ku$_10_2_strmcol_list_t                   /* list of columns */
)
/
grant execute on ku$_10_2_strmtable_t to public
/
--
-- strmtable view for 10g:
--   minor version # = 0
--   use 10g strmcol view
--
create or replace force view ku$_10_2_strmtable_view of ku$_10_2_strmtable_t
  with object OID(obj_num)
  as select '1','0',
         (select dbms_metadata_util.get_vers_dpapi from dual),
         (select dbms_metadata_util.get_endianness from dual),
         (select value from v$nls_parameters
                 where parameter='NLS_CHARACTERSET'),
         (select value from v$nls_parameters
                 where parameter='NLS_NCHAR_CHARACTERSET'),
         (select dbtimezone from dual),
         (select utl_xml.getfdo from dual),
         t.obj#,
         o.owner_name, o.name, o.subname,
         t.property, 
         cast( multiset(select * from ku$_10_2_strmcol_view c 
                        where c.obj_num = t.obj#
                        and bitand(c.property,32768)=0  -- unused column
                        -- 10.2 view does not have base_col_type
                        -- and c.base_col_type<2
                        order by c.segcol_num
                        ) as ku$_10_2_strmcol_list_t
              )
  from  ku$_schemaobj_view o, tab$ t
  where t.obj# = o.obj_num
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_10_2_strmtable_view to public
/

-------------------------------------------------------------------------------
--                              PROC./FUNC./PACKAGE
-------------------------------------------------------------------------------

-- common adt for procedures, functions, packages and package bodies
create or replace type ku$_proc_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  type_num      number,                                       /* type number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  source_lines  ku$_source_list_t                           /* source lines */
)
/
grant execute on ku$_proc_t to public
/

-- base view for procedures, functions, packages and package bodies

create or replace force view ku$_base_proc_view of ku$_proc_t
  with object identifier (obj_num) as
  select '1','1',
         oo.obj#,
         oo.type#,
         value(o),
         sys.dbms_metadata_util.get_source_lines(oo.name,oo.obj#,oo.type#)
  from  sys.ku$_edition_schemaobj_view o, sys.ku$_edition_obj_view oo
  where (oo.type# = 7 or oo.type# = 8 or oo.type# = 9 or oo.type# = 11)
    and oo.obj#  = o.obj_num and oo.linkname is NULL
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_base_proc_view to select_catalog_role
/
-- particular views for procedures, functions, packages and package bodies

create or replace force view ku$_proc_view of ku$_proc_t
  with object identifier (obj_num) as
  select t.vers_major, t.vers_minor, t.obj_num, t.type_num,
         t.schema_obj, t.source_lines
  from ku$_base_proc_view t
  where t.type_num = 7
/
grant select on ku$_proc_view to public
/

create or replace force view ku$_func_view of ku$_proc_t
  with object identifier (obj_num) as
  select t.vers_major, t.vers_minor, t.obj_num, t.type_num,
         t.schema_obj, t.source_lines
  from ku$_base_proc_view t
  where t.type_num = 8
/
grant select on ku$_func_view to public
/

create or replace force view ku$_pkg_view of ku$_proc_t
  with object identifier (obj_num) as
  select t.vers_major, t.vers_minor, t.obj_num, t.type_num,
         t.schema_obj, t.source_lines
  from ku$_base_proc_view t
  where t.type_num = 9
/
grant select on ku$_pkg_view to public
/

create or replace force view ku$_pkgbdy_view of ku$_proc_t
  with object identifier (obj_num) as
  select t.vers_major, t.vers_minor, t.obj_num, t.type_num,
         t.schema_obj, t.source_lines
  from ku$_base_proc_view t
  where t.type_num = 11
/
grant select on ku$_pkgbdy_view to public
/

create or replace type ku$_full_pkg_t as object
(
  vers_major            char(1),                      /* UDT major version # */
  vers_minor            char(2),                      /* UDT minor version # */
  obj_num               number,                             /* object number */
  schema_obj            ku$_schemaobj_t,                    /* schema object */
  package_t             ku$_proc_t,                        /* package header */
  package_body_t        ku$_proc_t                           /* package body */
)
/

grant execute on ku$_full_pkg_t to public
/

create or replace force view ku$_full_pkg_view of ku$_full_pkg_t
  with object identifier (obj_num) as
  select '1','1',
         oo.obj#,
         value(o),
         value(p),
         (select value(pb) from ku$_pkgbdy_view pb
          where oo.name  = pb.schema_obj.name
          and o.owner_name  = pb.schema_obj.owner_name)
  from   sys.ku$_edition_obj_view oo, ku$_edition_schemaobj_view o, ku$_pkg_view p
  where oo.type# = 9
    and oo.obj#  = o.obj_num
    and oo.obj#  = p.schema_obj.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_full_pkg_view to public
/

-- type and view used by export
-- includes base_obj_num (obj# of the pkg_spec) so that the base_obj_num
-- can be used as a filter

create or replace type ku$_exp_pkg_body_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  base_obj_num  number,                                /* base object number */
  obj_num       number,                                     /* object number */
  type_num      number,                                       /* type number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  source_lines  ku$_source_list_t,                           /* source lines */
  compiler_info ku$_switch_compiler_t
)
/
grant execute on ku$_exp_pkg_body_t to public
/

create or replace force view ku$_exp_pkg_body_view of ku$_exp_pkg_body_t
  with object identifier (obj_num) as
  select '1','1',
       (select o1.obj# from sys.ku$_edition_obj_view o1 where o1.type#=9
               and o1.name=o2.name and o1.owner#=o2.owner#
               and o1.linkname is NULL),
       o2.obj#,o2.type#,
       (select value(o) from sys.ku$_edition_schemaobj_view o where o.obj_num=o2.obj#),
       sys.dbms_metadata_util.get_source_lines(o2.name,o2.obj#,o2.type#),
       (select value(c) from sys.ku$_switch_compiler_view c 
                 where c.obj_num = o2.obj#)
  from sys.ku$_edition_obj_view o2
  where o2.type#=11
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o2.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_exp_pkg_body_view to public
/

-- UDT and views for alter procedure/function/package compile ...

create or replace type ku$_alter_proc_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  type_num      number,                                       /* type number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  compiler_info ku$_switch_compiler_t
)
/
grant execute on ku$_alter_proc_t to public
/
create or replace force view ku$_alter_proc_view of ku$_alter_proc_t
  with object identifier (obj_num) as
  select '1','0',
         oo.obj#,
         oo.type#,
         value(o),
         (select value (c) 
                 from ku$_switch_compiler_view c where c.obj_num = oo.obj#)
  from  sys.ku$_edition_schemaobj_view o, sys.obj$ oo
  where oo.type# = 7
    and oo.obj#  = o.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_alter_proc_view to public
/
create or replace force view ku$_alter_func_view of ku$_alter_proc_t
  with object identifier (obj_num) as
  select '1','0',
         oo.obj#,
         oo.type#,
         value(o),
         (select value (c) 
                 from ku$_switch_compiler_view c where c.obj_num = oo.obj#)
  from  sys.ku$_edition_schemaobj_view o, sys.obj$ oo
  where oo.type# = 8
    and oo.obj#  = o.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_alter_func_view to public
/
create or replace force view ku$_alter_pkgspc_view of ku$_alter_proc_t
  with object identifier (obj_num) as
  select '1','0',
         oo.obj#,
         oo.type#,
         value(o),
         (select value (c) 
                 from ku$_switch_compiler_view c where c.obj_num = oo.obj#)
  from  sys.ku$_edition_schemaobj_view o, sys.obj$ oo
  where oo.type# = 9
    and oo.obj#  = o.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_alter_pkgspc_view to public
/
create or replace force view ku$_alter_pkgbdy_view of ku$_alter_proc_t
  with object identifier (obj_num) as
  select '1','0',
         oo.obj#,
         oo.type#,
         value(o),
         (select value (c) 
                 from ku$_switch_compiler_view c where c.obj_num = oo.obj#)
  from  sys.ku$_edition_schemaobj_view o, sys.obj$ oo
  where oo.type# = 11
    and oo.obj#  = o.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_alter_pkgbdy_view to public
/

-------------------------------------------------------------------------------
--                              OPERATOR
-------------------------------------------------------------------------------

-- ADT for operator arguments
create or replace type ku$_oparg_t as object
(
  obj_num       number,                            /* operator object number */
  bind_num      number,                      /* binding this arg. belongs to */
  position      number,                   /* position of the arg in the bind */
  type          varchar2(61)                          /* datatype of the arg */
)
/
grant execute on ku$_oparg_t to public
/
create or replace type ku$_oparg_list_t as TABLE of ku$_oparg_t
/
grant execute on ku$_oparg_list_t to public
/
-- NOTE: We don't need a view of ku$_oparg_t's because they're instantiated
-- directly from sys.oparg$ in the higher level views that follow.

-- Simplified ADT for listing primary operators for ancillary operators
create or replace type ku$_opancillary_t as object
(
  obj_num       number,                  /* object number of ANCILLARY oper. */
  bind_num      number,                  /* bind number for the ancillary op */
  primop_num    number,          /* object number of PRIMARY for this ancil. */
  primop_obj    ku$_schemaobj_t,                /* schema object for PRIMARY */
  args          ku$_oparg_list_t               /* arguments for this primary */
)
/
grant execute on ku$_opancillary_t to public
/
create or replace type ku$_opancillary_list_t as TABLE of ku$_opancillary_t
/
grant execute on ku$_opancillary_list_t to public
/

-- View for primaries of ancillaries
create or replace force view ku$_opancillary_view of ku$_opancillary_t
  with object identifier (obj_num, bind_num, primop_num) as
  select oa.obj#, oa.bind#, oa.primop#,
         (select value(o) from sys.ku$_schemaobj_view o
                 where o.obj_num=oa.primop#),
         cast(multiset(select * from sys.oparg$ arg
                       where arg.obj#=oa.primop# and arg.bind#=oa.primbind#
                       order by arg.position
                      ) as ku$_oparg_list_t
             )
  from sys.opancillary$ oa
/
grant select on ku$_opancillary_view to select_catalog_role
/
-- ADT for operator bindings
create or replace type ku$_opbinding_t as object
(
  obj_num       number,                            /* operator object number */
  bind_num      number,                            /* number of this binding */
  functionname  varchar2(92),                /* func that impl. this binding */
  returnschema  varchar2(30),              /* schema of return type (if ADT) */
  returntype    varchar2(30),                     /* return type of function */
  impschema     varchar2(30),             /* indextype implementation schema */
  imptype       varchar2(30),               /* indextype implementation type */
  property      number,                                    /* property flags */
  spare1        varchar2(30),
  spare2        varchar2(30),
  spare3        number,
  args          ku$_oparg_list_t,              /* arguments for this binding */
  ancillaries   ku$_opancillary_list_t  /* list of primary ops for this ancil*/
)
/
grant execute on ku$_opbinding_t to public
/
create or replace type ku$_opbinding_list_t as TABLE of ku$_opbinding_t
/
grant execute on ku$_opbinding_list_t to public
/

-- View for operator bindings
create or replace force view ku$_opbinding_view of ku$_opbinding_t
  with object identifier(obj_num, bind_num) as
  select ob.obj#, ob.bind#, ob.functionname, ob.returnschema, 
         ob.returntype, ob.impschema, ob.imptype, ob.property, 
         ob.spare1, ob.spare2, ob.spare3,
         cast(multiset(select * from sys.oparg$ oa
                       where oa.obj#=ob.obj# and oa.bind#=ob.bind#
                       order by oa.position
                      ) as ku$_oparg_list_t
             ),
         cast(multiset(select value(a) from sys.ku$_opancillary_view a
                       where ob.obj#=a.obj_num and ob.bind#=a.bind_num
                      ) as ku$_opancillary_list_t
             )
  from sys.opbinding$ ob
/
grant select on ku$_opbinding_view to select_catalog_role
/

-- ADT for operators
create or replace type ku$_operator_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                            /* operator object number */
  schema_obj    ku$_schemaobj_t,                    /* base schema obj. info */
  property      number,                                    /* property flags */
  bindings      ku$_opbinding_list_t       /* List of bindings for this oper */
)
/
grant execute on ku$_operator_t to public
/
-- View for operators
create or replace force view ku$_operator_view of ku$_operator_t
  with object identifier(obj_num) as
  select '1','0',
         op.obj#, value(o), op.property,
         cast(multiset(select value(ob) from ku$_opbinding_view ob
                       where ob.obj_num=op.obj#
                       order by ob.bind_num
                      ) as ku$_opbinding_list_t
             )
  from  ku$_schemaobj_view o, sys.operator$ op
  where op.obj#=o.obj_num
        and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_operator_view to public
/

-------------------------------------------------------------------------------
--                              INDEXTYPE OPERATORS
-------------------------------------------------------------------------------

-- ADT for operators supported by indextypes. This is significantly
-- simplified from the full-blown ku$_operator_t above.
create or replace type ku$_indexop_t as object
(
  obj_num       number,                          /* obj# of parent indextype */
  oper_num      number,                 /* obj# of operator for this binding */
  bind_num      number,                            /* number of this binding */
  property      number,                                    /* property flags */
                                          /* 0x01 - INEXACT match use filter */
                        /* 0x02 -  invoke rewrite when indexed join is found */
                                    /* 0x04 - this is an "order-by" operator */
  oper_obj      ku$_schemaobj_t,             /* sch. info. for this operator */
  args          ku$_oparg_list_t           /* arguments for this op. binding */
)
/
grant execute on ku$_indexop_t to public
/
create or replace type ku$_indexop_list_t as TABLE of ku$_indexop_t
/
grant execute on ku$_indexop_list_t to public
/

create or replace force view ku$_indexop_view of ku$_indexop_t
  with object identifier(obj_num, oper_num, bind_num) as
  select io.obj#, io.oper#, io.bind#, io.property,
         (select value(o) from sys.ku$_schemaobj_view o
          where io.oper#=o.obj_num),
         cast(multiset(select * from sys.oparg$ oa
                       where oa.obj#=io.oper# and oa.bind#=io.bind#
                       order by oa.position
                      ) as ku$_oparg_list_t
             )
  from sys.indop$ io
/
grant select on ku$_indexop_view to select_catalog_role
/

create or replace type ku$_indarraytype_t as object
(
  obj_num       number,                                 /* obj# of indextype */
  type_num      number,                       /* data type of indexed column */
                                           /* for ADT column, type# = DTYADT */
  basetype_obj  ku$_schemaobj_t,                        /* user-defined type */
  arraytype_obj ku$_schemaobj_t                           /* collection type */
)
/
grant execute on ku$_indarraytype_t to public
/
create or replace type ku$_indarraytype_list_t as table of ku$_indarraytype_t
/
grant execute on ku$_indarraytype_list_t to public
/
create or replace force view ku$_indarraytype_view of ku$_indarraytype_t
  with object identifier(obj_num) as
  select ia.obj#, ia.type,
         (select value(o1) from ku$_schemaobj_view o1
               where o1.obj_num=ia.basetypeobj#),
         (select value(o2) from ku$_schemaobj_view o2
               where o2.obj_num=ia.arraytypeobj#)
  from sys.indarraytype$ ia
/
grant select on ku$_indarraytype_view to select_catalog_role
/

create or replace type ku$_indextype_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                 /* obj# of indextype */
  schema_obj    ku$_schemaobj_t,                    /* base schema obj. info */
  impl_obj      ku$_schemaobj_t,        /* sch. info for implementation type */
  property      number,                                         /* property */
                                              /* 0x0001 WITHOUT_COLUMN_DATA */
                                                   /* 0x0002 WITH_ARRAY_DML */ 
                                              /* 0x0004 WITH_REBUILD_ONLINE */
                                                     /* 0x0008 HAS_ORDER_BY */
                                       /* 0x0010 WITH LOCAL_RANGE_PARTITION */
                                        /* 0x0020 WITH LOCAL_HASH_PARTITION */ 
                                                      /* 0x0040 WITHOUT_DML */ 
                                              /* 0x0080 AUTHID_CURRENT_USER */ 
  operators     ku$_indexop_list_t,
  indarray      ku$_indarraytype_list_t
)
/
grant execute on ku$_indextype_t to public
/
create or replace force view ku$_indextype_view of ku$_indextype_t
  with object identifier(obj_num) as
  select '1','1',
         it.obj#, value(o),
         (select value(oit) from sys.ku$_schemaobj_view oit
          where it.implobj#=oit.obj_num),
         it.property,
          cast(multiset(select value(io) from sys.ku$_indexop_view io
                        where it.obj#=io.obj_num
                        /* the following order-by clause exists solely
                           to assure repeatable regression tests results */
                        order by io.oper_obj.owner_name, io.oper_obj.name
                       ) as ku$_indexop_list_t
              ),
          cast(multiset(select value(ia) from sys.ku$_indarraytype_view ia
                        where it.obj#=ia.obj_num
                       ) as ku$_indarraytype_list_t
              )
  from  sys.ku$_schemaobj_view o, sys.indtypes$ it
  where it.obj#=o.obj_num
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_indextype_view to public
/

-------------------------------------------------------------------------------
--                              OBJECT_GRANT
-------------------------------------------------------------------------------

-- Do Object Grants
create or replace type ku$_11_1_objgrant_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                 /* obj# of base obj. */
  base_obj      ku$_schemaobj_t,                           /* base obj. info */
  long_name     varchar2(4000),
  grantor       varchar2(30),
  grantee       varchar2(30),
  privname      varchar2(40),
  sequence      number,                        /* Unique seq# for this grant */
  wgo           number,                             /* with grant option = 1 */
                                                /* with hierarchy option = 2 */
  colname       varchar2(30))          /* column name if col grant else null */
/

grant execute on ku$_11_1_objgrant_t to public
/

-- View for object grants
create or replace force view ku$_11_1_objgrant_view of ku$_11_1_objgrant_t
  with object identifier (sequence) as
  select '1','2',
         g.obj#, value(o), 
         (select j.longdbcs from sys.javasnm$ j where j.short = o.name),
         u1.name, u2.name, p.name, g.sequence#,
         NVL(g.option$,0),
         (select c.name from sys.col$ c where g.obj#=c.obj# and g.col#=c.col#
          and bitand(c.property, 1) = 0           -- exclude ADT attribute column
          and bitand(c.property, 1024) = 0        -- exclude Nested table column
          and bitand(c.property, 416) = 0)    /* exclude system generated,
                                               hidden and stored in lob cols */ 
  from sys.ku$_schemaobj_view o, sys.objauth$ g, sys.user$ u1, sys.user$ u2,
       sys.table_privilege_map p
  where g.obj#=o.obj_num and
        g.grantor#=u1.user# and
        g.grantee#=u2.user# and
        g.privilege#=p.privilege and
        (o.type_num != 2 or                          /* not a table or...  */
         exists (select 1 from tab$ t                /* not a nested table */
                 where t.obj#=o.obj_num
                 and bitand(t.property,8192)!=8192))
        and
        (SYS_CONTEXT('USERENV','CURRENT_USERID')
                IN (g.grantor#, g.grantee#, o.owner_num, 0) OR
                g.grantee#=1 OR
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
-- The security clause allows a non-privileged user the same access
-- as the catalog views. Note comment on ALL_TAB_PRIVS:
-- 'Grants on objects for which the user is the grantor, grantee, owner, 
-- or an enabled role or PUBLIC is the grantee'

grant select on ku$_11_1_objgrant_view to public
/

-- Bulk Object Grants for version 11.2
create or replace type ku$_privname_t as object
(
  privname      varchar2(40))
/
grant execute on ku$_privname_t to public
/

create or replace type ku$_privname_list_t
 as table of ku$_privname_t
/
grant execute on ku$_privname_list_t to public
/

--
-- Create a type that describes unique grants on a single object from one
-- schema to one other schema.
--
-- So if user a granted both select and insert to user b for object c, one
-- entry would be fetched describing that user a granted at least something on
-- c to user b.
--
-- Name is SameGrantoR to SameGranteE
--
create or replace type ku$_sgr_sge_t as object
(
 obj_num        number,
 grantor_num    number,
 grantee_num    number,
 colnum         number,
 wgo            number,
 min_sequence   number);
/
grant execute on ku$_sgr_sge_t to public
/

create or replace force view ku$_sgr_sge_view of ku$_sgr_sge_t
  with object identifier (min_sequence) as
  select unique g.obj#, g.grantor#, g.grantee#, g.col#,
         NVL(g.option$,0),
         (select min(g2.sequence#) from objauth$ g2
          where g2.obj# = g.obj# and g2.grantor# = g.grantor# and
                g2.grantee# = g.grantee# and 
               ((g2.col# = g.col#) or (g2.col# is null and g.col# is null)))
  from objauth$ g
/
grant select on ku$_sgr_sge_view to select_catalog_role
/

--
-- Now create the major grant type that has all of the object information and a
-- list of grant names for this object.
--
create or replace type ku$_objgrant_t as object
(
  vers_major    char(2),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                 /* obj# of base obj. */
  base_obj      ku$_schemaobj_t,                           /* base obj. info */
  long_name     varchar2(4000),
  grantor       varchar2(30),
  grantee       varchar2(30),
  wgo           number,
  colname       varchar2(30),
  sequence      number,
  privs         ku$_privname_list_t)
/
grant execute on ku$_objgrant_t to public
/

-- View for object grants for version 11.2
create or replace force view ku$_objgrant_view of ku$_objgrant_t
  with object identifier (sequence) as
  select '2','0', o.obj_num, value(o),
         (select j.longdbcs from sys.javasnm$ j where j.short = o.name),
         u1.name, u2.name, g.wgo,
         (select c.name from sys.col$ c
          where g.obj_num = c.obj# and g.colnum = c.col# and
                bitand(c.property, 1) = 0 and       -- exclude ADT attribute cols
                bitand(c.property, 1024) = 0 and    -- exclude Nested table columns
                bitand(c.property, 416) = 0),   /* exclude system generated,
                                                hidden and stored in lob cols */
         g.min_sequence,
         cast(multiset(select p.name
                       from   sys.table_privilege_map p, sys.objauth$ g2
                       where  g.obj_num = g2.obj# and
                              g.grantor_num = g2.grantor# and
                              g.grantee_num = g2.grantee# and
                              g2.privilege# = p.privilege order by p.privilege)
                as ku$_privname_list_t)
  from ku$_sgr_sge_view g, sys.ku$_schemaobj_view o, sys.user$ u1, sys.user$ u2
  where u1.user# = g.grantor_num and
        u2.user# = g.grantee_num and
        o.obj_num = g.obj_num and
        (o.type_num != 2 or                          /* not a table or...  */
         exists (select 1 from tab$ t                /* not a nested table */
                 where t.obj#=o.obj_num
                 and bitand(t.property,8192)!=8192))
        and
        (SYS_CONTEXT('USERENV','CURRENT_USERID')
                IN (g.grantor_num, g.grantee_num, o.owner_num, 0) OR
                g.grantee_num=1 OR
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
-- see comment above on security clause in ku$_11_1_objgrant_view

grant select on ku$_objgrant_view to public
/

-------------------------------------------------------------------------------
--                              SYSTEM_GRANT
-------------------------------------------------------------------------------

create or replace type ku$_sysgrant_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  privilege     number,                       /* numeric privilege type code */
  grantee       varchar2(30),
  privname      varchar2(40),
  sequence      number,
  wgo           number)
/
grant execute on ku$_sysgrant_t to public
/

-- View for system priv. grants
create or replace force view ku$_sysgrant_view of ku$_sysgrant_t
  with object identifier (sequence) as
  select '1','1',
         p.privilege,
         u.name, p.name, g.sequence#, NVL(g.option$,0)
  from sys.sysauth$ g, sys.user$ u, sys.system_privilege_map p
  where g.grantee#=u.user# and
        g.privilege#=p.privilege and
        bitand(p.property, 1) != 1         /* Don't show non-SQL sys. grants */
        and
        (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (g.grantee#, 0) OR 
                g.grantee#=1 OR
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
-- The security clause allows a non-privileged user *almost* the same access
-- as the catalog views DBA/USER_SYS_PRIVS: system privs granted to user
-- or to PUBLIC.
-- The exception is that the catalog views include grants with
-- the "no-export" property.

-- Do we need the roles enumerated in exu8spv in catexp excluded in
-- the above where clause?

grant select on ku$_sysgrant_view to public
/

-- 10_1 view excludes privileges unknown in 10.1 (bug 4338348)

create or replace force view ku$_10_1_sysgrant_view of ku$_sysgrant_t
  with object identifier (sequence) as
  select * from ku$_sysgrant_view t
  where t.privilege != -233
    and t.privilege >  -276
/
grant select on ku$_10_1_sysgrant_view to public
/


-------------------------------------------------------------------------------
--                              TRIGGERS
-------------------------------------------------------------------------------
create or replace type ku$_triggercol_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                   /* obj# of trigger */
  col_num       number,                                     /* column number */
  type_num      number,                          /* type of column reference */
     /* 6 = OLD IN-ARG, 5 = NEW IN-ARG, 9 = NEW OUT-VAR, 13 = NEW IN/OUT-VAR */
                                                  /* 0x14 = 20 PARENT IN-ARG */
  position_num  number,                               /* position in trigger */
  intcol_num    number,                            /* internal column number */
  name          varchar2(30),                              /* name of column */
  attrname      varchar2(4000) /* name of type attr. column: null if != type */
)
/
grant execute on ku$_triggercol_t to public
/
create or replace type ku$_triggercol_list_t
 as table of ku$_triggercol_t
/
grant execute on ku$_triggercol_list_t to public
/
create or replace force view ku$_triggercol_view of ku$_triggercol_t
  with object identifier(obj_num,intcol_num,type_num) as
  select '1','0',
         tc.obj#, tc.col#, tc.type#, tc.position#, tc.intcol#, c.name,
         (select a.name from attrcol$ a where
                        a.obj#=tc.obj# and a.intcol#=tc.intcol#)
  from col$ c, triggercol$ tc, trigger$ t
  where tc.obj#=t.obj#
    and c.obj#=t.baseobject
    and c.intcol#=tc.intcol#
/
grant select on ku$_triggercol_view to select_catalog_role
/
create or replace type ku$_triggerdep_t as object
(
  vers_major  char(1),                                /* UDT major version # */
  vers_minor  char(2),                                /* UDT minor version # */
  obj_num     number,                                     /* obj# of trigger */
  p_trgowner  varchar2(30),                          /* parent trigger owner */
  p_trgname   varchar2(30),                           /* parent trigger name */
  flag        number                              /* 0x01 FOLLOWS dependency */
                                                 /* 0x02 PRECEDES dependency */
                                  /* 0x04 - schema user not specified in ddl */
)
/
grant execute on ku$_triggerdep_t to public
/
create or replace type ku$_triggerdep_list_t
 as table of ku$_triggerdep_t
/
grant execute on ku$_triggerdep_list_t to public
/
create or replace force view ku$_triggerdep_view of ku$_triggerdep_t
  with object identifier(obj_num, p_trgowner, p_trgname) as
  select '1','0', td.obj#, td.p_trgowner, td.p_trgname, td.flag
  from triggerdep$ td
/
grant select on ku$_triggerdep_view to select_catalog_role
/
create or replace type ku$_trigger_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                   /* obj# of trigger */
  schema_obj    ku$_schemaobj_t,                 /* object info. for trigger */
  base_obj_num  number,                                  /* obj# of base obj */
  base_obj_schema varchar2(30),         /* schema name - for schema triggers */
  base_obj      ku$_schemaobj_t,    /* object info. for base obj: May be null*/
  xdb_generated number,                     /* 1 if xdb generated, else NULL */
  type_num      number,                                     /* trigger type: */
   /* 0=before table, 1=before row, 2=after table, 3=after row, 4=instead of */
  act_update    number,                                    /* fire on update */
  act_insert    number,                                    /* fire on insert */
  act_delete    number,                                    /* fire on delete */
  refoldname    varchar2(30),                        /* old referencing name */
  refnewname    varchar2(30),                        /* new referencing name */
  definition    varchar2(4000),                /* text of trigger definition */
  parsed_def    ku$_source_t,          /* definition with name offset/length */
  whenclause    varchar2(4000),                       /* text of when clause */
  body          clob,                                /* text of trigger body */
  body_vcnt     ku$_vcnt,                            /* text of trigger body */
  body_len      number,                            /* length of trigger body */
  enabled       number,                         /* 0 = DISABLED, 1 = ENABLED */
  property      number,                                /* trigger properties */
                                                /* 0x01 = baseobject is view */
                                                /* 0x02 = Call style trigger */
                                                /* 0x04 = Java Trigger       */
                                            /* 0x08 = baseobject is database */
                                              /* 0x10 = baseobject is schema */
                                              /* 0x20 = Nested table trigger */
                                                 /* 0x40 = baseobject is IOT */
                              /* 0x80 = fire-once-only (fire one place only) */
  sys_evts      number,                         /* system events for trigger */
  nttrigcol     number,               /* intcol# on which trigger is defined */
  nttrigatt     number,                    /* attribute number within column */
  ntname        varchar2(30),                   /* nested table trigger name */
  refprtname    varchar2(30),                     /* PARENT referencing name */
  actionlineno  number,                         /* action line number offset */
  cols          ku$_triggercol_list_t,      /* columns referenced by trigger */
  trigdeps      ku$_triggerdep_list_t,               /* trigger dependencies */
  compiler_info ku$_switch_compiler_t 
)
/
grant execute on ku$_trigger_t to public
/
-- This version of the view uses long2clob to populate the body attribute.
-- long2clob can return view text of arbitrary length;
-- the old body_vcnt attribute is retained for compatibility
-- but is always set to NULL.
create or replace force view ku$_trigger_view of ku$_trigger_t
  with object identifier(obj_num) as
  select '1','3',
         t.obj#, value(o), t.baseobject,
         (select u.name from user$ u 
          where u.user#=t.baseobject
            and bitand(t.property,16)!=0),
         (select value(bo) from ku$_schemaobj_view bo
          where t.baseobject = bo.obj_num
            and bitand(t.property,8+16)=0),
         (SELECT unique 1 FROM sys.rls$ r,  ku$_schemaobj_view bo
          WHERE t.baseobject = bo.obj_num and bo.TYPE_NAME='TABLE' AND
              r.obj# = t.baseobject and
              r.PFSCHMA = 'XDB' AND
              r.PPNAME='DBMS_XDBZ0' AND
              (o.NAME like '%$xd' or
               o.NAME like '%$dl')),
         t.type#, t.update$, t.insert$, t.delete$,
         t.refoldname, t.refnewname,
         -- bug 4352110: strip nulls from definition, whenclause
         replace(t.definition,chr(0)),
         sys.dbms_metadata_util.parse_trigger_definition(o.owner_name,o.name,
                                         replace(t.definition,chr(0))),
         replace(t.whenclause,chr(0)),
         sys.dbms_metadata_util.long2clob(t.actionsize,
                                        'SYS.TRIGGER$',
                                        'ACTION#',
                                        t.rowid),
         NULL,
         t.actionsize,                          
         t.enabled, t.property, t.sys_evts,
         t.nttrigcol, t.nttrigatt,
         (select ntcol.name from sys.viewtrcol$ ntcol
          where bitand(t.property, 63)>= 32 and t.baseobject = ntcol.obj#
          and t.nttrigcol = ntcol.intcol# and t.nttrigatt = ntcol.attribute#),
         t.refprtname, t.actionlineno,
         cast(multiset(select * from ku$_triggercol_view tv
                        where tv.obj_num=t.obj#
                      ) as ku$_triggercol_list_t
             ),
         cast(multiset(select * from ku$_triggerdep_view td
                        where td.obj_num=t.obj#
                      ) as ku$_triggerdep_list_t
             ),
         (select value(c) from ku$_switch_compiler_view c 
                 where c.obj_num =o.obj_num)
 from   sys.ku$_edition_schemaobj_view o, sys.trigger$ t
  where  t.obj# = o.obj_num AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_trigger_view to public
/

-- 10.2 view excludes FORWARD, REVERSE, CROSSEDITION, FOLLOWS, and 
-- PRECEDES triggers
create or replace force view ku$_10_2_trigger_view of ku$_trigger_t
  with object identifier(obj_num) as
    select * from ku$_trigger_view t
    /* 8192 = crossedition, 16384 = follows, 32768 = precedes, 65536 = forward 
       131072 = reverse */
    where bitand(t.property, 8192+16384+32768+65536+131072) = 0
    and t.type_num != 5                                  /* compound trigger */
/
grant select on ku$_10_2_trigger_view to public
/

-------------------------------------------------------------------------------
--                              VIEWS
-------------------------------------------------------------------------------

create or replace type ku$_view_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                              /* obj# */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  audit_val     varchar2(38),                            /* auditing options */
  cols          number,                                      /* # of columns */
  intcols       number,                             /* # of internal columns */
  property      number,                                  /* table properties */
                /* 0x0001 =       1 = this is typed view                     */
                /* 0x0002 =       2 = view has ADT column(s)                 */
                /* 0x0004 =       4 = view has nested table column(s)        */
                /* 0x0008 =       8 = view has REF column(s)                 */
                /* 0x0010 =      16 = view has array column(s)               */
                /* 0x1000 =    4096 = view has primary key-based oid         */
                /* 0x4000 =   16384 = view is read-only                      */
            /* 0x08000000 =         = view is a sub view                     */
            /* 0x10000000 =         = view is packed object view             */
  flags         number,                                             /* flags */
                /* 0x0800 =    2048 = view/table has security policy         */
                /* 0x1000 =    4096 = view is insertable via trigger         */
                /* 0x2000 =    8192 = view is updatable via trigger          */
                /* 0x4000 =   16384 = view is deletable via trigger          */
             /* 0x0400000 =         = view has sub views defined under it    */
  textlength    number,                               /* length of view text */
  text          clob,                                           /* view text */
  parsed_text   sys.xmltype,                             /* parsed view text */
  with_option   ku$_constraint0_t,      /* check with option constraint name */
  textvcnt      ku$_vcnt,            /* (retained for backward compatibility */
  col_list      ku$_simple_col_list_t,    /* list of relational view columns */
  col_list2     ku$_column_list_t,            /* list of object view columns */
  owner_name    varchar2(30),                           /* owner of row type */
  name          varchar2(30),                            /* name of row type */
  typetextlength  number,                         /* length of row type text */
  typetext        varchar2(4000),                               /* type text */
  oidtextlength   number,                              /* length of oid text */
  oidtext         varchar2(4000),                                /* oid text */
  transtextlength number,                 /* length of transformed view text */
  transtext       varchar2(4000),
  undertextlength number,       /* length of under clause text for sub-views */
  undertext       varchar2(4000),         /* under clause text for sub-views */
  con1_list     ku$_constraint1_list_t,               /* list of constraints */
  con2_list     ku$_constraint2_list_t                /* list of constraints */
)
/
grant execute on ku$_view_t to public
/

-- This version of the view uses long2clob to populate the text attribute.
-- long2clob can return view text of arbitrary length;
-- the old textvcnt attribute is retained for compatibility
-- but is always set to NULL.
create or replace force view ku$_view_view of ku$_view_t
  with object identifier (obj_num) as
  select '1','3',
         v.obj#,
         value(o),
         replace(v.audit$,chr(0),'-'),
         v.cols, v.intcols, v.property, v.flags, v.textlength,
         sys.dbms_metadata_util.long2clob(v.textlength,
                                        'SYS.VIEW$',
                                        'TEXT',
                                        v.rowid),
         sys.dbms_metadata.parse_query(o.owner_name,
                                       v.textlength,
                                       'SYS.VIEW$',
                                       'TEXT',
                                       v.rowid,
                                       bitand(v.property,16384),
                                       (select 
                                        case
                                         when exists
                                         (select cd.con# from cdef$ cd
                                          where cd.obj# = v.obj#
                                            and cd.type# = 5) then 1
                                          else 0
                                        end from dual)),
         (select value (t) 
                 from sys.ku$_constraint0_view t, cdef$ cd 
                  where cd.obj# = v.obj# and
                        t.con_num = cd.con# and 
                        cd.type# = 5),
         NULL,
         cast(multiset(select * from ku$_simple_col_view c
                       where c.obj_num = v.obj#
                         and (bitand(v.property,1)=0)
                        order by c.intcol_num
                      ) as ku$_simple_col_list_t
             ),
         cast(multiset(select * from ku$_column_view c
                       where c.obj_num = v.obj#
                         and (bitand(v.property,1)=1)
                        order by c.intcol_num
                      ) as ku$_column_list_t
             ),
         tv.typeowner, tv.typename, tv.typetextlength, tv.typetext,
         tv.oidtextlength, tv.oidtext, tv.transtextlength,
         sys.dbms_metadata_util.long2varchar(tv.transtextlength,
                                        'SYS.TYPED_VIEW$',
                                        'TRANSTEXT',
                                        tv.rowid),
         tv.undertextlength,
         sys.dbms_metadata_util.long2varchar(tv.undertextlength,
                                        'SYS.TYPED_VIEW$',
                                        'UNDERTEXT',
                                        tv.rowid),
         cast( multiset(select * from ku$_constraint1_view con
                        where con.obj_num = v.obj#
                       ) as ku$_constraint1_list_t
             ),
         cast( multiset(select * from ku$_constraint2_view con
                        where con.obj_num = v.obj#
                       ) as ku$_constraint2_list_t
             )
  from sys.ku$_edition_schemaobj_view o, sys.obj$ oo, sys.view$ v, sys.typed_view$ tv
  where oo.obj# = o.obj_num
    and oo.obj# = v.obj#
    and oo.obj# = tv.obj# (+)
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_view_view to public
/

-- View for fetching view object numbers -- used by heterogeneous object types.
-- The "o.owner_name NOT IN(...)" clause does not necessarily list all
-- schemas excluded by sys.ku_noexp_tab, but this is harmless: the goal
-- is to improve performance by reducing the number of objects returned by
-- this view (and subsequently filtered by the query WHERE clause).
-- By the way, rewriting the view to explicitly reference sys.ku_noexp_tab
-- (e.g., o.owner_name NOT IN (select name from sys.ku_noexp_tab where
--  obj_type = 'SCHEMA')) results in a significant drop in performance.
--
-- This view also excludes olap cube views. These views can only be 
-- created by procedural calls, which are generated through procedural actions.

create or replace force view ku$_view_objnum_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select value(o) from ku$_edition_schemaobj_view o, sys.view$ v
  where o.obj_num=v.obj#
  and (o.owner_name NOT IN ('SYS', 'ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
  and not exists (SELECT 1 FROM SYS.OLAP_AW_VIEWS$ V
            WHERE O.OBJ_NUM = V.VIEW_OBJ# AND V.VIEW_TYPE = 1)
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_view_objnum_view to public
/

-- get dependency information needed to sort views

create or replace view ku$_depviews_base_view(
 viewobjno, viewname, viewownerno, viewowner, dobjno, dname)
as
 select unique o.obj#,o.name,o.owner#,u.name, d.d_obj#, do.name
from obj$ o, obj$ do, user$ u, dependency$ d, view$ v
where o.obj# = v.obj#
  and bitand(o.flags,16)!=16          /* not secondary object */
  and o.owner# != 0                   /* not owned by SYS */
  and o.owner# = u.user#
  and o.obj# = d.p_obj#
  and do.obj# = d.d_obj#
  and bitand(d.property,1)=1          /* only hard dependency */
  and do.type# = 4
union
 select o.obj#,o.name,o.owner#,u.name,0,NULL
from obj$ o, user$ u, view$ v
where o.obj# = v.obj#
  and bitand(o.flags,16)!=16          /* not secondary object */
  and o.owner# != 0                   /* not owned by SYS */
  and o.owner# = u.user#
  and not exists (select * from obj$ do, dependency$ d
                  where o.obj# = d.p_obj#
                  and do.obj# = d.d_obj#
                  and do.type# = 4
                  and bitand(d.property,1)=1 )
/
grant select on ku$_depviews_base_view to select_catalog_role
/
create or replace view ku$_depviews_view(
 viewobjno, viewname, viewownerno, viewowner, dobjno, dname)
as
 select b.viewobjno, b.viewname, b.viewownerno, b.viewowner, b.dobjno, b.dname
 from ku$_depviews_base_view b
 where (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (b.viewownerno, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_depviews_view to public
/

-------------------------------------------------------------------------------
--                              OUTLINES
-------------------------------------------------------------------------------
-- Types and views to support OUTLINEs

create or replace type ku$_outline_hint_t as object
( name              varchar2(30),                           /* outline name */
  hint              number,               /* which hint for a given outline */
  category          varchar2(30),               /* collection/grouping name */
  hint_type         number,                                 /* type of hint */
  hint_text         varchar2(512),             /* hint specific information */
  stage             number,            /* stage of hint generation/applic'n */
  node              number,                                  /* QBC node id */
  table_name        varchar2(30),                       /* for ORDERED hint */
  table_tin         number,                        /* table instance number */
  table_pos         number,                             /* for ORDERED hint */
  ref_id            number,        /* node id that this hint is referencing */
  user_table_name   varchar2(30),  /* table name to which this hint applies */
  cost              double precision,    /* optimizer estimated cost of the
                                                           hinted operation */
  cardinality       double precision,    /* optimizer estimated cardinality
                                                    of the hinted operation */
  bytes             double precision,     /* optimizer estimated byte count
                                                    of the hinted operation */
  hint_textoff      number,             /* offset into the SQL statement to
                                                    which this hint applies */
  hint_textlen      number,     /* length of SQL to which this hint applies */
  join_pred         varchar2(2000)      /* join predicate (applies only for 
                                                         join method hints) */
)
/
grant execute on ku$_outline_hint_t to public
/
create or replace type ku$_outline_hint_list_t
 as table of ku$_outline_hint_t
/
grant execute on ku$_outline_hint_list_t to public
/
create or replace type ku$_outline_node_t as object
(
  name          varchar2(30),                              /* outline name  */
  category      varchar2(30),                           /* outline category */
  node          number,                              /* qbc node identifier */
  parent        number,      /* node id of the parent node for current node */ 
  node_type     number,                                    /* qbc node type */
  node_textlen  number,         /* length of SQL to which this node applies */ 
  node_textoff  number       /* offset into the SQL statement to which this
                                                               node applies */
)
/
grant execute on ku$_outline_node_t to public
/
create or replace type ku$_outline_node_list_t
 as table of ku$_outline_node_t
/
grant execute on ku$_outline_node_list_t to public
/
create or replace type ku$_outline_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  name              varchar2(30),         /* named is potentially generated */
  sql_text          varchar2(4000),          /* the SQL stmt being outlined */
  textlen           number,                           /* length of SQL stmt */
  signature         raw(16),                       /* signature of sql_text */
  hash_value        number,                  /* KGL's calculated hash value */
  category          varchar2(30),                          /* category name */
  version           varchar2(64),          /* db version @ outline creation */
  creator           varchar2(30),         /* user from whom outline created */
  timestamp         varchar2(19),                       /* time of creation */
  flags             number,              /* e.g. everUsed, bindVars, dynSql */
  hintcount         number,               /* number of hints on the outline */
  hints             ku$_outline_hint_list_t,/* list of hints for this outln */
  nodes             ku$_outline_node_list_t           /* list of qbc blocks */
)
/
grant execute on ku$_outline_t to public
/
create or replace force view ku$_outline_view of ku$_outline_t
  with object identifier(name) as
  select '1','0',
         ol.ol_name,
         sys.dbms_metadata_util.long2varchar(ol.textlen,
                                    'OUTLN.OL$',
                                    'SQL_TEXT',
                                    ol.rowid),
         ol.textlen, ol.signature, ol.hash_value, ol.category, ol.version,
         ol.creator, to_char(ol.timestamp,'YYYY/MM/DD HH24:MI:SS'), ol.flags, ol.hintcount,
         cast(multiset(select ol_name,hint#,category,hint_type,hint_text,
                              stage#,node#,table_name,table_tin,table_pos,
                              ref_id,user_table_name,cost,cardinality,
                              bytes,hint_textoff,hint_textlen,join_pred 
                       from outln.ol$hints h
                       where h.ol_name = ol.ol_name order by h.stage#,h.node#
                      ) as ku$_outline_hint_list_t
             ),
         cast(multiset(select ol_name,category,node_id,parent_id,node_type,
                              node_textlen,node_textoff
                       from outln.ol$nodes n
                       where n.ol_name = ol.ol_name
                      ) as ku$_outline_node_list_t
             )
  from outln.ol$ ol, sys.user$ u
  where ol.creator=u.name
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_outline_view to public
/

-------------------------------------------------------------------------------
--                              SYNONYMS
-------------------------------------------------------------------------------
-- 
create or replace type ku$_synonym_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                             /* synonym object number */
  schema_obj    ku$_schemaobj_t,                    /* synonym schema object */
  syn_long_name varchar2(4000),                         /* synonym long name */
  db_link       varchar2(128),                                /* object node */
  owner_name    varchar2(30),                                /* object owner */
  name          varchar2(30),                                 /* object name */
  obj_long_name varchar2(4000)                           /* object long name */
)
/
grant execute on ku$_synonym_t to public
/
create or replace force view ku$_synonym_view of ku$_synonym_t
  with object identifier(obj_num) as
  select '1','0',
         s.obj#, value(o),
         -- syn_long_name defaults to name
         nvl((select j.longdbcs from sys.javasnm$ j where j.short = o.name),
             o.name),
         s.node, s.owner, s.name,
         (select j.longdbcs from sys.javasnm$ j where j.short = s.name)
  from  sys.ku$_edition_schemaobj_view o, sys.syn$ s
  where s.obj# = o.obj_num AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                o.owner_name='PUBLIC' or
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_synonym_view to public
/

-------------------------------------------------------------------------------
--                              DIRECTORY
-------------------------------------------------------------------------------
-- 
create or replace type ku$_directory_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                           /* directory object number */
  schema_obj    ku$_schemaobj_t,                  /* directory schema object */
  audit_val     varchar2(38),                            /* auditing options */
  os_path       varchar2(4000)                             /* OS path string */
)
/
grant execute on ku$_directory_t to public
/
create or replace force view ku$_directory_view of ku$_directory_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj#, value(sov),
         replace(d.audit$,chr(0),'-'),
         d.os_path
  from   sys.obj$ o, sys.ku$_schemaobj_view sov, sys.dir$ d
  where  o.obj# = sov.obj_num AND
         o.obj# = d.obj#
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID')= 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_directory_view to public
/

-------------------------------------------------------------------------------
--                           ROLLBACK SEGMENTS
-------------------------------------------------------------------------------
-- 
create or replace type ku$_rollback_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  us_num        number,                               /* undo segment number */
  name          varchar2(30),                       /* rollback segment name */
  user_num      number,                /* Owner: 0 = SYS(PRIVATE) 1 = PUBLIC */
  optimal       number,                                     /* optimal value */
  iniexts       number,                               /* initial extent size */
  minexts       number,                         /* minimum number of extents */
  maxexts       number,                         /* maximum number of extents */
  extsize       number,                          /* current next extent size */
                                           /* zero for bitmapped tablespaces */
  tablespace    ku$_tablespace_t                   /* tablespace information */
)
/
grant execute on ku$_rollback_t to public
/
create or replace force view ku$_rollback_view of ku$_rollback_t
  with object identifier(us_num) as
  select '1','0',
         u.us#,
         u.name,
         u.user#,
         (select r.optsize from v$rollstat r where r.usn=u.us#),
         s.iniexts,
         s.minexts,
         s.maxexts,
         s.extsize,
         value(tsv)
  from   sys.ku$_tablespace_view tsv, sys.seg$ s, sys.undo$ u
  where  u.status$ != 1
    and  u.ts# = tsv.ts_num
    and  u.file#  = s.file#
    and  u.block# = s.block#
    and  u.ts#    = s.ts#
    and (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_rollback_view to public
/

-------------------------------------------------------------------------------
--                           DATABASE LINKS
-------------------------------------------------------------------------------
-- 
create or replace type ku$_dblink_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  owner_name    varchar2(30),
  owner_num     number,
  name          varchar2(128),
  ctime         varchar2(19),
  host          varchar2(2000),
  userid        varchar2(30),
  password      varchar2(30),
  flag          number,
  authusr       varchar2(30),
  authpwd       varchar2(30),
  passwordx     raw(128),
  authpwdx      raw(128)
)
/
grant execute on ku$_dblink_t to public
/

-- If a user
--   (a) owns the object or
--   (b) is SYS or
--   (c) has EXP_FULL_DATABASE role
-- the user can see all metadata for the object including passwords.
-- Otherwise, if the user has SELECT_CATALOG_ROLE
-- the user can see all metadata for the object except passwords.

create or replace force view ku$_dblink_view of ku$_dblink_t
  with object identifier(owner_num,name) as
  select '1','1',
         u.name,
         l.owner#, l.name, to_char(l.ctime,'YYYY/MM/DD HH24:MI:SS'), 
         l.host, l.userid,
         l.password, l.flag, l.authusr, l.authpwd,
         l.passwordx, l.authpwdx
  from   sys.user$ u, sys.link$ l
  where  u.user# = l.owner#
     AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='EXP_FULL_DATABASE' ))
UNION
  select '1','1',
         u.name,
         l.owner#, l.name, to_char(l.ctime,'YYYY/MM/DD HH24:MI:SS'), 
         l.host, l.userid,
         NULL, l.flag, l.authusr, NULL,
         NULL, NULL
  from   sys.user$ u, sys.link$ l
  where  u.user# = l.owner#
     AND (SYS_CONTEXT('USERENV','CURRENT_USERID') NOT IN (u.user#, 0)) 
     AND NOT (EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='EXP_FULL_DATABASE' ))
     AND (EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_dblink_view to public
/

-- 10_1 view excludes dblinks with stored password.  These were upgraded
-- in 10gR2 to obfuscate the password; no downgrade is possible.

create or replace force view ku$_10_1_dblink_view of ku$_dblink_t
  with object identifier(owner_num,name) as
  select t.* from ku$_dblink_view t
  where NVL(t.userid,'CURRENT_USER')='CURRENT_USER'
    and t.authusr is NULL
/
grant select on ku$_10_1_dblink_view to public
/

-------------------------------------------------------------------------------
--                           TRUSTED LINKS
-------------------------------------------------------------------------------
-- 
create or replace type ku$_trlink_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  name          varchar2(132),                          /* trusted link name */
  function      varchar2(45),                                    /* function */
  type          number                               /* type of trusted link */
)
/
grant execute on ku$_trlink_t to public
/
create or replace force view ku$_trlink_view of ku$_trlink_t
  with object identifier(name) as
  select '1','0',
         tl.dbname,
         decode(tl.dbname, '+*', 'DBMS_DISTRIBUTED_TRUST_ADMIN.ALLOW_ALL',
                           '-*', 'DBMS_DISTRIBUTED_TRUST_ADMIN.DENY_ALL',
                fdef.function),
         decode(tl.dbname, '+*', 0, '-*', 0, 1)
  from   sys.trusted_list$ tl,
         ( select  decode (dbname,
                           '+*', 'DBMS_DISTRIBUTED_TRUST_ADMIN.DENY_SERVER',
                           '-*', 'DBMS_DISTRIBUTED_TRUST_ADMIN.ALLOW_SERVER')
                           function
           from    sys.trusted_list$
           where   dbname like '%*') fdef
  where (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_trlink_view to public
/

-------------------------------------------------------------------------------
--                           Fine Grained Auditing
-------------------------------------------------------------------------------
-- 

-- Each FGA relevant Column type
create or replace type ku$_fga_rel_col_t as object
(
    audit_column varchar2(30)
)
/
grant execute on ku$_fga_rel_col_t to public
/
-- FGA relevant column LIST
create or replace type ku$_fga_rel_col_list_t
  as table of ku$_fga_rel_col_t;
/
grant execute on ku$_fga_rel_col_list_t to public
/
create or replace type ku$_fga_policy_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                              /* parent object number */
  name          varchar2(30),                              /* name of policy */
  ptxt          clob,                                    /* policy predicate */
  pfschema      varchar2(30),                     /* schema of event handler */
  ppname        varchar2(30),                          /* event package name */
  pfname        varchar2(30),                         /* event funciton name */
  pcol          ku$_fga_rel_col_list_t,              /* relevent column List */
  enable_flag   number,                         /* 0 = disabled, 1 = enabled */
  stmt_type     number,              /* statement type default is 1 = select */ 
  audit_trail   number,              /* audit trail 0 = DB_EXTENDED, 64 = DB */
  pcol_opt      number,           /* audit_column_options 0 = any, 128 = all */
  base_obj      ku$_schemaobj_t,                       /* base Schema object */
  powner        varchar2(30)                              /* owner of policy */
)
/
grant execute on ku$_fga_policy_t to public
/
create or replace force view ku$_fga_policy_view of ku$_fga_policy_t
  with object identifier(obj_num, pfschema, name) as
  SELECT '1','2',
         f.obj#,
         f.pname,
         TO_CLOB(replace ((f.ptxt), '''', '''''')),
         f.pfschma, f.ppname, f.pfname,
         cast(multiset(select c.name from sys.col$ c, sys.fgacol$ fc where
                       fc.obj# = f.obj# and
                       fc.pname = f.pname and
                       fc.obj#  = c.obj# and fc.intcol# = c.intcol#
                       )
              as ku$_fga_rel_col_list_t),
         f.enable_flag,
         BITAND(NVL(f.stmt_type, 1),15),  
         BITAND(NVL(f.stmt_type, 0),64),  
         BITAND(NVL(f.stmt_type, 1),128),
         value(sov),
         u.name
  FROM   sys.ku$_schemaobj_view sov, sys.fga$ f, sys.user$ u
  WHERE  f.obj# = sov.obj_num  AND
         u.user# = f.powner# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 OR
          EXISTS ( SELECT * FROM sys.session_roles
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_fga_policy_view to public
/


-------------------------------------------------------------------------------
--              Fine Grained Access Control Administrative Interface
-------------------------------------------------------------------------------

create or replace type ku$_rls_sec_rel_col_t as object
(
  sec_rel_col varchar2(30)
)
/
grant execute on ku$_rls_sec_rel_col_t to public
/
create or replace type ku$_rls_sec_rel_col_list_t
  as table of ku$_rls_sec_rel_col_t;
/
grant execute on ku$_rls_sec_rel_col_list_t to public
/

create or replace type ku$_rls_policy_objnum_t as object
(
  obj_num       number,                               /* parent object number */
  name          varchar2(30),                         /* name of policy */
  pfschma       varchar2(30),               /* name of policy function schema */
  ppname        varchar2(30),               /* name of policy package */
  pfname        varchar2(30),               /* name of policy function name */
  base_obj      ku$_schemaobj_t                       /* base schema object */
)
/
grant execute on ku$_rls_policy_objnum_t to public
/

create or replace force view ku$_rls_policy_objnum_view
   of ku$_rls_policy_objnum_t
   with object identifier (obj_num,name) as
  select  
          r.obj#, r.pname, r.pfschma, r.ppname, r.pfname,
          value(sov)
  from    ku$_schemaobj_view sov, sys.rls$ r
  where   r.obj# = sov.obj_num and
          (SYS_CONTEXT('USERENV','CURRENT_USERID') in (sov.owner_num, 0) OR
          EXISTS ( SELECT * FROM sys.session_roles
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_rls_policy_objnum_view to PUBLIC
/

create or replace type ku$_rls_policy_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  base_obj      ku$_schemaobj_t,                       /* base schema object */
  obj_num       number,                              /* parent object number */
  gname         varchar2(30),                        /* name of policy group */
  name          varchar2(30),                              /* name of policy */
  stmt_type     number,                        /* applicable statement type: */
  check_opt     number,                                 /* with check option */
  enable_flag   number,                         /* 0 = disabled, 1 = enabled */
  pfschma       varchar2(30),                   /* schema of policy function */
  ppname        varchar2(30),                         /* policy package name */
  pfname        varchar2(30),                        /* policy function name */
  policy_type   varchar2(35),                                 /* policy type */
  long_pred     number,                           /* 32K long predicate size */
  rel_cols      ku$_rls_sec_rel_col_list_t,     /* security relevant columns */
  rel_cols_opt  number                   /* security relevant columns option */
)
/
grant execute on ku$_rls_policy_t to public
/

create or replace force view ku$_rls_policy_view of ku$_rls_policy_t
  with object identifier (obj_num,name) as
  select '1','1',
          value(sov),
          r.obj#, r.gname, r.pname,
          BITAND(r.stmt_type,15)+BITAND(r.stmt_type,2048),
          r.check_opt, r.enable_flag, r.pfschma, r.ppname, r.pfname,
          case bitand(r.stmt_type,16+64+128+256+8192+16384+32768)
            when 16 then 'dbms_rls.STATIC'
            when 64 then 'dbms_rls.SHARED_STATIC'
            when 128 then 'dbms_rls.CONTEXT_SENSITIVE'
            when 256 then 'dbms_rls.SHARED_CONTEXT_SENSITIVE'
            when 8192 then 'dbms_rls.XDS1'
            when 16384 then 'dbms_rls.XDS2'
            when 32768 then 'dbms_rls.XDS3'
            else 'dbms_rls.DYNAMIC'
          end,
          BITAND(r.stmt_type,512),
          cast(multiset(select c.name from col$ c, rls_sc$ sc where
                        sc.obj#=r.obj# and
                        sc.gname=r.gname and
                        sc.pname=r.pname and
                        sc.obj#=c.obj# and sc.intcol#=c.intcol#
                       )
               as ku$_rls_sec_rel_col_list_t),
          BITAND(r.stmt_type, 4096)
  from    ku$_schemaobj_view sov, sys.rls$ r
  where   r.obj# = sov.obj_num and
          (SYS_CONTEXT('USERENV','CURRENT_USERID') in (sov.owner_num, 0) OR
          EXISTS ( SELECT * FROM sys.session_roles
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_rls_policy_view to PUBLIC
/

create or replace type ku$_rls_group_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  base_obj      ku$_schemaobj_t,                       /* base schema object */
  obj_num       number,                              /* parent object number */
  name          varchar2(30)                         /* name of policy group */
)
/
grant execute on ku$_rls_group_t to public
/

create or replace force view ku$_rls_group_view of ku$_rls_group_t
  with object identifier (name,obj_num) as
  select '1','0',
          value(sov),
          rg.obj# , rg.gname
  from    ku$_schemaobj_view sov, sys.rls_grp$ rg
  where   rg.obj# = sov.obj_num
      and (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 OR
           EXISTS ( SELECT * FROM sys.session_roles
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_rls_group_view to PUBLIC
/

create or replace type ku$_rls_context_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  base_obj      ku$_schemaobj_t,                       /* base schema object */
  obj_num       number,                              /* parent object number */
  name          varchar2(30),                                   /* namespace */
  attr          varchar2(30)                                    /* attribute */
)
/
grant execute on ku$_rls_context_t to public
/

create or replace force view ku$_rls_context_view of ku$_rls_context_t
  with object identifier (name,obj_num) as
  select '1','0',
          value(sov),
          rc.obj# ,rc.ns ,rc.attr 
  from    ku$_schemaobj_view sov, sys.rls_ctx$ rc
  where   rc.obj# = sov.obj_num
      and (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 OR
              EXISTS ( SELECT * FROM sys.session_roles
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_rls_context_view to PUBLIC
/

-------------------------------------------------------------------------------
--                           Materialized View
-------------------------------------------------------------------------------
--
create or replace type ku$_m_view_scm_t as object
(
  snacol            varchar2(30),                 /* name of snapshot column */
  mascol            varchar2(30),                      /* master column name */
  maspos            number,            /* position of master column (intcol) */
  colrole           number,                       /* how is this column used */
  snapos            integer             /* position of col in snapshot table */
)
/
grant execute on ku$_m_view_scm_t to public
/
create or replace type ku$_m_view_scm_list_t
  as table of ku$_m_view_scm_t
/
grant execute on ku$_m_view_scm_list_t to public
/
create or replace type ku$_m_view_srt_t as object
(
  tablenum          number,           /* order of Master table in snap query */
  snaptime          varchar2(21),          /* time of last refresh for table */
  mowner            varchar2(30),                     /* owner of this table */
  master            varchar2(30),                      /* name of this table */
  masflag           number,                 /* additional master information */
  masobj_num        number,                    /* obj number of master table */
  loadertime        varchar2(21),      /* last refresh w.r.t. SQL*Loader log */
  refscn            number, /* scn of latest info used to refresh this table */
  lastsuccess       varchar2(21),   /* time of last known successful refresh */
  fcmaskvec         raw(255),                  /* filter columns mask vector */
  ejmaskvec         raw(255),               /* equi-join columns mask vector */
  sub_handle        number,            /* subscription handle (if using CDC) */
  change_view       varchar2(30),         /* change view name (if using CDC) */
  scm_count         number,
  scm_list          ku$_m_view_scm_list_t
)
/
grant execute on ku$_m_view_srt_t to public
/

create or replace type ku$_m_view_srt_list_t
  as table of ku$_m_view_srt_t
/
grant execute on ku$_m_view_srt_list_t to public
/

create or replace type ku$_m_view_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  tname             varchar2(30),                              /* Table name */
  mowner            varchar2(30),                         /* owner of master */
  master            varchar2(30),                          /* name of master */
  mlink             varchar2(128),           /* database link to master site */
  snapshot          varchar2(21), /* used by V7 masters to identify snapshot */
  snapid            integer,  /* used by V8 masters to identify the snapshot */
  auto_fast         varchar2(8),      /* date function for automatic refresh */
  auto_fun          varchar2(200),                  /* next time for refresh */
  auto_date         varchar2(19),                  /* start time for refresh */
  uslog             varchar2(30),             /* log for updatable snapshots */
  status            integer,                           /* refresh operations */
  master_version    integer,            /* Oracle version of the master site */
  tables            integer,                 /* Number of tables in snapshot */
  flag              number,
  flag2             number,
  flag3             number,
  lobmaskvec        raw(255),                     /* lob columns mask vector */
  mas_roll_seg      varchar2(30),            /* master-side rollback segment */
  rscn              number,                              /* last refresh scn */
  instsite          integer,                           /* instantiating site */
  flavor_id         number,                                     /* flavor id */
  objflag           number,                 /* object properties of snapshot */
  sna_type_owner    varchar2(30),                    /* object MV type owner */
  sna_type_name     varchar2(30),                     /* object MV type name */
  mas_type_owner    varchar2(30),          /* master object table type owner */
  mas_type_name     varchar2(30),           /* master object table type name */
  parent_sowner     varchar2(30),                   /* parent snapshot owner */
  parent_vname      varchar2(30),                    /* parent snapshot name */
  query_len         number,                                  /* query length */
  query_txt         clob,              /* query which this view instantiates */
  parsed_query_txt  sys.xmltype,                         /* parsed query_txt */
  query_vcnt        ku$_vcnt,          /* store the query when length > 4000 */
  rel_query         clob,              /* relational transformation of query */
  loc_roll_seg      varchar2(30),             /* local side rollback segment */
  global_db_name    varchar2(4000),                  /* Global database Name */
  syn_count         number,                /* Number of synonyms in snapshot */
  srt_list          ku$_m_view_srt_list_t
)
/
grant execute on ku$_m_view_t to public
/

create or replace type ku$_m_view_h_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  mview             ku$_m_view_t,
  mview_tab         ku$_htable_t,
  mview_idx_list    ku$_index_list_t
)
/
grant execute on ku$_m_view_h_t to public
/

create or replace type ku$_m_view_ph_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  mview             ku$_m_view_t,
  mview_tab         ku$_phtable_t,
  mview_idx_list    ku$_index_list_t
)
/
grant execute on ku$_m_view_ph_t to public
/

create or replace type ku$_m_view_fh_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  mview             ku$_m_view_t,
  mview_tab         ku$_fhtable_t,
  mview_idx_list    ku$_index_list_t
)
/
grant execute on ku$_m_view_fh_t to public
/

create or replace type ku$_m_view_pfh_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  mview             ku$_m_view_t,
  mview_tab         ku$_pfhtable_t,
  mview_idx_list    ku$_index_list_t
)
/
grant execute on ku$_m_view_pfh_t to public
/

create or replace type ku$_m_view_iot_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  mview             ku$_m_view_t,
  mview_tab         ku$_iotable_t,
  mview_idx_list    ku$_index_list_t
)
/
grant execute on ku$_m_view_iot_t to public
/

create or replace type ku$_m_view_piot_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  sowner            varchar2(30),                       /* Owner of snapshot */
  vname             varchar2(30),                        /* name of snapshot */
  mview             ku$_m_view_t,
  mview_tab         ku$_piotable_t,
  mview_idx_list    ku$_index_list_t
)
/
grant execute on ku$_m_view_piot_t to public
/
create or replace force view ku$_m_view_view of ku$_m_view_t
  with object identifier (sowner, vname) as
  select '2',
         case when dbms_metadata.get_version >= '11.02.00.00.00' then '3' 
              when dbms_metadata.get_version >= '11.00.00.00.00' then '2' 
              when dbms_metadata.get_version >= '10.00.00.00.00' then '1' 
              else '0' 
         end,
         s.sowner,
         s.vname,
         s.tname,
         s.mowner,
         s.master,
         s.mlink,
         TO_CHAR(s.snapshot,'YYYY-MM-DD HH24:MI:SS'),
         s.snapid,
         DECODE(s.auto_fast, 'C', 'COMPLETE', 'F', 'FAST', '?', 'FORCE',
                NULL, 'FORCE', 'N', 'NEVER', 'ERROR'),
         s.auto_fun,
         to_char(s.auto_date,'YYYY/MM/DD HH24:MI:SS'),
         s.uslog,
         s.status,
         s.master_version,
         s.tables,
         s.flag,
         s.flag2,
         case when dbms_metadata.get_version >= '11.02.00.00.00' 
           then NVL(s.flag3, 0)
           else 0
         end,
         s.lobmaskvec,
         s.mas_roll_seg,
         s.rscn,
         s.instsite,
         NVL(s.flavor_id, 0),
         s.objflag,
         s.sna_type_owner,
         s.sna_type_name,
         s.mas_type_owner,
         s.mas_type_name,
         s.parent_sowner,
         s.parent_vname,
         s.query_len,
         sys.dbms_metadata_util.long2clob(s.query_len, 'sys.snap$',
                                            'query_txt', s.rowid),
         sys.dbms_metadata.parse_query(s.sowner, s.query_len, 'sys.snap$',
                                       'query_txt', s.rowid),
--         sys.dbms_metadata_util.long2vcnt(s.query_len, 'sys.snap$',
--                                            'query_txt', s.rowid),
         NULL,
         s.rel_query,
         (select rg.rollback_seg
          from   sys.rgroup$ rg
          where  rg.owner = s.sowner
             and rg.name = s.vname),
         p.value$,
         s.syn_count,
         cast(multiset(select srt.tablenum,
                              TO_CHAR(srt.snaptime,'YYYY-MM-DD HH24:MI:SS'),
                              srt.mowner,
                              srt.master,
                              srt.masflag,
                              srt.masobj#,
                              TO_CHAR(srt.loadertime,'YYYY-MM-DD HH24:MI:SS'),
                              srt.refscn,
                              TO_CHAR(srt.lastsuccess,'YYYY-MM-DD HH24:MI:SS'),
                              srt.fcmaskvec,
                              srt.ejmaskvec,
                              srt.sub_handle,
                              srt.change_view,
                              (select count(*)
                               from   sys.snap_colmap$ scm
                               where  srt.vname = scm.vname
                               and    srt.sowner = scm.sowner
                               and    srt.instsite = scm.instsite
                               and    srt.tablenum = scm.tabnum),
                              cast(multiset(select scm.snacol,
                                                   scm.mascol,
                                                   scm.maspos,
                                                   scm.colrole,
                                                   scm.snapos
                                            from   sys.snap_colmap$ scm
                                            where  srt.vname = scm.vname
                                            and    srt.sowner = scm.sowner
                                            and    srt.instsite = scm.instsite
                                            and    srt.tablenum = scm.tabnum
                                            order by scm.maspos)
                                            as ku$_m_view_scm_list_t)
                       from   sys.snap_reftime$ srt
                       where  s.vname    = srt.vname
                          and s.sowner   = srt.sowner
                          and s.instsite = srt.instsite
                       order by srt.tablenum, srt.mowner, srt.master)
                       as ku$_m_view_srt_list_t)
  from   snap$ s, sys.props$ p
  where  p.name  = 'GLOBAL_DB_NAME'
  /* for < 11.2, exclude MVs using scn-based refresh */
  and (dbms_metadata.get_version >= '11.02.00.00.00' 
       or
       (dbms_metadata.get_version < '11.02.00.00.00' and bitand(s.flag3, 1)=0))
  order by parent_vname nulls last
-- bug 6750821: list secondary MVs first, so that when ALTER MV COMPILE is done
-- on primary MVs during import, their secondary MVs are already present
/
grant select on ku$_m_view_view to public
/

create or replace force view ku$_m_view_h_view of ku$_m_view_h_t
  with object identifier (sowner,vname) as
  select '2','0',
         mvv.sowner,
         mvv.vname,
         value(mvv),
         value(htv),
         cast(multiset(select value(iv) from sys.ku$_all_index_view iv, sys.ind$ i
                       where i.bo# = ot.obj# and
                             bitand(i.property,8192) = 8192 and
                             iv.obj_num = i.obj#) as ku$_index_list_t)
  from   sys.obj$ ot, sys.user$ u, sys.ku$_htable_view htv,
         sys.ku$_m_view_view mvv
  where  ot.name     = mvv.tname
     and ot.owner#   = u.user#
     and u.name      = mvv.sowner
     and ot.type#    = 2
     and htv.obj_num = ot.obj#
     and BITAND(mvv.flag,33554432) != 33554432
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ot.owner#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_h_view to public
/
create or replace force view ku$_m_view_ph_view of ku$_m_view_ph_t
  with object identifier (sowner, vname) as
  select '2','0',
         mvv.sowner,
         mvv.vname,
         value(mvv),
         value(phtv),
         cast(multiset(select value(iv) from sys.ku$_all_index_view iv, sys.ind$ i
                       where i.bo# = ot.obj# and
                             bitand(i.property,8192) = 8192 and
                             iv.obj_num = i.obj#) as ku$_index_list_t)
  from   sys.obj$ ot, sys.user$ u, sys.ku$_phtable_view phtv,
         sys.ku$_m_view_view mvv
  where  ot.name     = mvv.tname
     and ot.owner#   = u.user#
     and u.name      = mvv.sowner
     and ot.type#    = 2
     and phtv.obj_num = ot.obj#
     and BITAND(mvv.flag,33554432) != 33554432
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ot.owner#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_ph_view to public
/
create or replace force view ku$_m_view_fh_view of ku$_m_view_fh_t
  with object identifier (sowner, vname) as
  select '2','0',
         mvv.sowner,
         mvv.vname,
         value(mvv),
         value(fhtv),
         cast(multiset(select value(iv) from sys.ku$_all_index_view iv, sys.ind$ i
                       where i.bo# = ot.obj# and
                             bitand(i.property,8192) = 8192 and
                             iv.obj_num = i.obj#) as ku$_index_list_t)
  from   sys.obj$ ot, sys.user$ u, sys.ku$_fhtable_view fhtv,
         sys.ku$_m_view_view mvv
  where  ot.name     = mvv.tname
     and ot.owner#   = u.user#
     and u.name      = mvv.sowner
     and ot.type#    = 2
     and fhtv.obj_num = ot.obj#
     and BITAND(mvv.flag,33554432) != 33554432
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ot.owner#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_fh_view to public
/
create or replace force view ku$_m_view_pfh_view of ku$_m_view_pfh_t
  with object identifier (sowner, vname) as
  select '2','1',
         mvv.sowner,
         mvv.vname,
         value(mvv),
         value(pfhtv),
         cast(multiset(select value(iv) from sys.ku$_all_index_view iv, sys.ind$ i
                       where i.bo# = ot.obj# and
                             bitand(i.property,8192) = 8192 and
                             iv.obj_num = i.obj#) as ku$_index_list_t)
  from   sys.obj$ ot, sys.user$ u, sys.ku$_pfhtable_view pfhtv,
         sys.ku$_m_view_view mvv
  where  ot.name     = mvv.tname
     and ot.owner#   = u.user#
     and u.name      = mvv.sowner
     and ot.type#    = 2
     and pfhtv.obj_num = ot.obj#
     and BITAND(mvv.flag,33554432) != 33554432
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ot.owner#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_pfh_view to public
/
create or replace force view ku$_m_view_iot_view of ku$_m_view_iot_t
  with object identifier (sowner, vname) as
  select '2','0',
         mvv.sowner,
         mvv.vname,
         value(mvv),
         value(iotv),
         cast(multiset(select value(iv) from sys.ku$_all_index_view iv, sys.ind$ i
                       where i.bo# = ot.obj# and
                             bitand(i.property,8192) = 8192 and
                             iv.obj_num = i.obj#) as ku$_index_list_t)
  from   sys.obj$ ot, sys.user$ u, sys.ku$_iotable_view iotv,
         sys.ku$_m_view_view mvv
  where  ot.name     = mvv.tname
     and ot.owner#   = u.user#
     and u.name      = mvv.sowner
     and ot.type#    = 2
     and iotv.obj_num = ot.obj#
     and BITAND(mvv.flag,33554432) = 33554432
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ot.owner#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_iot_view to public
/
create or replace force view ku$_m_view_piot_view of ku$_m_view_piot_t
  with object identifier (sowner, vname) as
  select '2','1',
         mvv.sowner,
         mvv.vname,
         value(mvv),
         value(piotv),
         cast(multiset(select value(iv) from sys.ku$_all_index_view iv, sys.ind$ i
                       where i.bo# = ot.obj# and
                             bitand(i.property,8192) = 8192 and
                             iv.obj_num = i.obj#) as ku$_index_list_t)
  from   sys.obj$ ot, sys.user$ u, sys.ku$_piotable_view piotv,
         sys.ku$_m_view_view mvv
  where  ot.name     = mvv.tname
     and ot.owner#   = u.user#
     and u.name      = mvv.sowner
     and ot.type#    = 2
     and piotv.obj_num = ot.obj#
     and BITAND(mvv.flag,33554432) = 33554432
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ot.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_piot_view to public
/

-------------------------------------------------------------------------------
--                             Materialized View Log
-------------------------------------------------------------------------------
--
create or replace type ku$_refcol_t as object
(
  colname         varchar2(30),                  /* master table column name */
  oldest          varchar2(21),  /* maximum age of information in the column */
  flag            number                          /* column meta information */
)
/
grant execute on ku$_refcol_t to public
/
create or replace type ku$_refcol_list_t
  as table of ku$_refcol_t
/
grant execute on ku$_refcol_list_t to public
/

create or replace type ku$_slog_t as object
(
  snapid          integer,                        /* identifies V8 snapshots */
  snaptime        varchar2(21),                       /* when last refreshed */
  tscn            number                                 /* last refresh scn */
)
/
grant execute on ku$_slog_t to public
/
create or replace type ku$_slog_list_t
  as table of ku$_slog_t
/
grant execute on ku$_slog_list_t to public
/

create or replace type ku$_m_view_log_t as object
(
  vers_major      char(1),                            /* UDT major version # */
  vers_minor      char(1),                            /* UDT minor version # */
  mowner          varchar2(30),                           /* owner of master */
  master          varchar2(30),                            /* name of master */
  oldest          varchar2(19),  /* maximum age of rowid information in the log */
  oldest_pk       varchar2(21),  /* maximum age of PK information in the log */
  oscn            number,                                   /* scn of oldest */
  youngest        varchar2(21),             /* most recent snaptime assigned */
  yscn            number,                                      /* set-up scn */
  log             varchar2(30),                               /* name of log */
  trig            varchar2(30),                 /* trigger on master for log */
  flag            number,    /* 0x01, rowid         0x02, primary key values */
                             /* 0x04, column values 0x08, log is imported    */
                             /* 0x10, log is created with temp table         */
  mtime           varchar2(21),                     /* DDL modification time */
  temp_log        varchar2(30),      /* temp table as updatable snapshot log */
  oldest_oid      varchar2(21), /* maximum age of OID information in the log */
  oldest_new      varchar2(21),      /* maximum age of new values in the log */
  oldest_seq      varchar2(21), /* maximum age of sequence values in the log */
  global_db_name  varchar2(4000),                    /* Global database Name */
  purge_start     varchar2(21),                          /* purge start date */
  purge_next      varchar2(200),               /* purge next date expression */
  fc_count        number,                        /* number of filter columns */
  fc_list         ku$_refcol_list_t,                   /* filter column list */
  lm_count        number,                         /* number of local masters */
  lm_list         ku$_slog_list_t                       /* local master list */
)
/
grant execute on ku$_m_view_log_t to public
/

create or replace type ku$_m_view_log_h_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  tabobj_num        number,                       /* log table object number */
  mviewlog          ku$_m_view_log_t,
  mviewlog_tab      ku$_htable_t
)
/
grant execute on ku$_m_view_log_h_t to public
/

create or replace type ku$_m_view_log_ph_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  tabobj_num        number,                       /* log table object number */
  mviewlog          ku$_m_view_log_t,
  mviewlog_tab      ku$_phtable_t
)
/
grant execute on ku$_m_view_log_ph_t to public
/

create or replace type ku$_m_view_log_fh_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  tabobj_num        number,                       /* log table object number */
  mviewlog          ku$_m_view_log_t,
  mviewlog_tab      ku$_fhtable_t
)
/
grant execute on ku$_m_view_log_fh_t to public
/

create or replace type ku$_m_view_log_pfh_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  tabobj_num        number,                       /* log table object number */
  mviewlog          ku$_m_view_log_t,
  mviewlog_tab      ku$_pfhtable_t
)
/
grant execute on ku$_m_view_log_pfh_t to public
/

create or replace force view ku$_m_view_log_view of ku$_m_view_log_t
  with object identifier (mowner,master) as
  select '1',
         case when dbms_metadata.get_version >= '11.02.00.00.00' then '1' 
              else '0' 
         end,
         m.mowner, m.master, 
         to_char(m.oldest,'YYYY-MM-DD HH24:MI:SS'),
         TO_CHAR(m.oldest_pk, 'YYYY-MM-DD HH24:MI:SS'),
         m.oscn,
         TO_CHAR(m.youngest, 'YYYY-MM-DD HH24:MI:SS'),
         m.yscn, m.log, m.trig, 
         case when dbms_metadata.get_version >= '11.02.00.00.00'
           then m.flag
           else bitand(m.flag,65535)  /* pre-11.2, flag was a ub2 */
         end,
         TO_CHAR(m.mtime, 'YYYY-MM-DD HH24:MI:SS'),
         m.temp_log,
         TO_CHAR(m.oldest_oid, 'YYYY-MM-DD HH24:MI:SS'),
         TO_CHAR(m.oldest_new, 'YYYY-MM-DD HH24:MI:SS'),
         TO_CHAR(m.oldest_seq, 'YYYY-MM-DD HH24:MI:SS'),
         p.value$,
         case when dbms_metadata.get_version >= '11.02.00.00.00' 
           then TO_CHAR(m.purge_start, 'YYYY-MM-DD HH24:MI:SS')
           else NULL
         end,
         case when dbms_metadata.get_version >= '11.02.00.00.00' 
           then m.purge_next
           else NULL
         end,
         (select count(*)
                       from   sys.mlog_refcol$ r
                       where  m.mowner = r.mowner
                          and m.master = r.master),
         cast(multiset(select r.colname,
                              to_char(r.oldest, 'YYYY-MM-DD HH24:MI:SS'),
                              r.flag
                       from   sys.mlog_refcol$ r
                       where  m.mowner = r.mowner
                          and m.master = r.master)
                       as ku$_refcol_list_t),
         (select count(*)
                       from   sys.slog$ s
                       where  m.mowner = s.mowner
                          and m.master = s.master),
         cast(multiset(select s.snapid,
                              to_char(s.snaptime, 'YYYY-MM-DD HH24:MI:SS'),
                              case when 
                                dbms_metadata.get_version >= '11.02.00.00.00'
                                then s.tscn
                                else NULL
                              end
                       from   sys.slog$ s
                       where  m.mowner = s.mowner
                          and m.master = s.master)
                       as ku$_slog_list_t)
  from   sys.mlog$ m, sys.props$ p
  where  p.name  = 'GLOBAL_DB_NAME'
  /* for < 11.2, exclude MV logs with async_purge, sched_purge, commit scn */
  and (dbms_metadata.get_version >= '11.02.00.00.00' 
       or
       (dbms_metadata.get_version < '11.02.00.00.00' 
        and bitand(m.flag, 16384+32768+65536)=0))
/
grant select on ku$_m_view_log_view to select_catalog_role;
/

create or replace force view ku$_m_view_log_h_view of ku$_m_view_log_h_t
  with object identifier (tabobj_num) as
  select '1','0',
         htv.obj_num,
         value(mvlv),
         value(htv)
  from   obj$ o, user$ u, sys.ku$_htable_view htv, ku$_m_view_log_view mvlv
  where  mvlv.mowner = u.name
     and mvlv.log    = o.name
     and o.owner#    = u.user#
     and o.type#     = 2
     and o.obj#      = htv.schema_obj.obj_num
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR
          EXISTS ( SELECT * FROM sys.session_roles
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_log_h_view to public
/

create or replace force view ku$_m_view_log_ph_view of ku$_m_view_log_ph_t
  with object identifier (tabobj_num) as
  select '1','0',
         phtv.obj_num,
         value(mvlv),
         value(phtv)
  from   obj$ o, user$ u, sys.ku$_phtable_view phtv, ku$_m_view_log_view mvlv
  where  mvlv.mowner = u.name
     and mvlv.log    = o.name
     and o.owner#    = u.user#
     and o.type#     = 2
     and o.obj#      = phtv.schema_obj.obj_num
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_log_ph_view to public
/

create or replace force view ku$_m_view_log_fh_view of ku$_m_view_log_fh_t
  with object identifier (tabobj_num) as
  select '1','0',
         fhtv.obj_num,
         value(mvlv),
         value(fhtv)
  from   obj$ o, user$ u, sys.ku$_fhtable_view fhtv, ku$_m_view_log_view mvlv
  where  mvlv.mowner = u.name
     and mvlv.log    = o.name
     and o.owner#    = u.user#
     and o.type#     = 2
     and o.obj#      = fhtv.schema_obj.obj_num
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR 
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_log_fh_view to public
/

create or replace force view ku$_m_view_log_pfh_view of ku$_m_view_log_pfh_t
  with object identifier (tabobj_num) as
  select '1','1',
         pfhtv.obj_num,
         value(mvlv),
         value(pfhtv)
  from   obj$ o, user$ u, sys.ku$_pfhtable_view pfhtv, ku$_m_view_log_view mvlv
  where  mvlv.mowner = u.name
     and mvlv.log    = o.name
     and o.owner#    = u.user#
     and o.type#     = 2
     and o.obj#      = pfhtv.schema_obj.obj_num
     and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0) OR
          EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_m_view_log_pfh_view to public
/

-------------------------------------------------------------------------------
--                              LIBRARY
-------------------------------------------------------------------------------
-- 
create or replace type ku$_library_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                             /* library object number */
  schema_obj    ku$_schemaobj_t,                    /* library schema object */
  filespec      varchar2(2000),                                  /* filename */
  lib_audit     varchar2(2000),
  property      number
)
/
grant execute on ku$_library_t to public
/
create or replace force view ku$_library_view of ku$_library_t
  with object identifier(obj_num) as
  select '1','0',
         lb.obj#, value(o),
         lb.filespec, 
         replace(lb.audit$,chr(0),'-'),
         lb.property
  from sys.ku$_edition_schemaobj_view o, sys.library$ lb
  where o.type_num=22 AND
        lb.obj# = o.obj_num AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_library_view to public
/
-------------------------------------------------------------------------------
--                              USER
-------------------------------------------------------------------------------
-- 
create or replace type ku$_user_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  user_id       number,                                         /* user id  */
  name          varchar2(30),                               /* name of user */
  type_num      number ,                              /* 0 = role, 1 = user */
  password      varchar2(30),                         /* encrypted password */
  datats        varchar2(30),                    /* user default tablespace  */
  tempts        varchar2(30),     /* default tablespace for temporary tables */
  ctime         varchar2(19),                  /* user account creation time */
  ptime         varchar2(19),                        /* password change time */
  exptime       varchar2(19),             /* actual password expiration time */
  ltime         varchar2(19),                 /* time when account is locked */
  profnum       number,                                 /* resource profile# */
  profname         varchar2(30),                            /* profile name  */
  user_audit        varchar2(38),                     /* user audit options */
  defrole       number,                           /* default role indicator: */
  defgrp_num       number,                             /* default undo group */
  defgrp_seq_num   number,             /* global sequence number for the grp */
  astatus       number,                             /* status of the account */
  lcount        number,                    /* count of failed login attempts */
  defschclass   varchar2(30),                      /* initial consumer group */
  ext_username  varchar2(400),                          /* external username */
  spare1        number,
  spare2        number,
  spare3        number,
  spare4        varchar2(1000),
  spare5        varchar2(1000),
  spare6        varchar2(19)
)
/
grant execute on ku$_user_t to public
/
-- If the caller (i.e., the user querying the view)
--   (a) is SYS or
--   (b) has EXP_FULL_DATABASE role
-- the caller can see all metadata for the user including passwords.
-- Otherwise, if the caller has SELECT_CATALOG_ROLE
-- the caller can see all metadata for the user except passwords.

create or replace force view ku$_user_view of ku$_user_t
  with object identifier(user_id) as
  select '1','0',
          u.user#,
          u.name,
          u.type#,
          u.password,
          ts1.name,
          ts2.name,
          to_char(u.ctime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.exptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ltime,'YYYY/MM/DD HH24:MI:SS'),
          u.resource$,
          p.name,
          replace(u.audit$,chr(0),'-'),
          u.defrole,
          u.defgrp#,
          u.defgrp_seq#,
          u.astatus,
          u.lcount,
          NVL((select cgm.consumer_group
                        from sys.resource_group_mapping$ cgm
                        where cgm.attribute = 'ORACLE_USER' 
                        and cgm.status = 'ACTIVE' 
                        and cgm.value = u.name), u.defschclass),
          u.ext_username,
          u.spare1,
          u.spare2,
          u.spare3,
          u.spare4,
          u.spare5,
          to_char(u.spare6,'YYYY/MM/DD HH24:MI:SS')
  from sys.user$ u,        
       sys.ts$ ts1, sys.ts$ ts2, sys.profname$ p
  where   u.datats# = ts1.ts# AND
          u.tempts# = ts2.ts# AND
          u.type# = 1 AND
          u.resource$ = p.profile# 
          AND (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='EXP_FULL_DATABASE' ))
UNION
  select '1','0',
          u.user#,
          u.name,
          u.type#,
          NULL,
          ts1.name,
          ts2.name,
          to_char(u.ctime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.exptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ltime,'YYYY/MM/DD HH24:MI:SS'),
          u.resource$,
          p.name,
          replace(u.audit$,chr(0),'-'),
          u.defrole,
          u.defgrp#,
          u.defgrp_seq#,
          u.astatus,
          u.lcount,
          NVL((select cgm.consumer_group
               from sys.resource_group_mapping$ cgm
               where cgm.attribute = 'ORACLE_USER' 
                 and cgm.status = 'ACTIVE' 
                 and cgm.value = u.name), u.defschclass),
          u.ext_username,
          u.spare1,
          u.spare2,
          u.spare3,
          NULL,
          u.spare5,
          to_char(u.spare6,'YYYY/MM/DD HH24:MI:SS')
  from sys.user$ u,        
       sys.ts$ ts1, sys.ts$ ts2, sys.profname$ p
  where   u.datats# = ts1.ts# AND
          u.tempts# = ts2.ts# AND
          u.type# = 1 AND
          u.resource$ = p.profile# 
     AND (SYS_CONTEXT('USERENV','CURRENT_USERID') != 0 ) 
     AND NOT (EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='EXP_FULL_DATABASE' ))
     AND (EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))

/
grant select on ku$_user_view to public
/
-------------------------------------------------------------------------------
--                              ROLE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_role_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  user_id       number,                                          /* role id  */
  name          varchar2(30),                                /* name of role */
  type_num      number ,                              /* 0 = role, 1 = user */
  password      varchar2(30),                                   /*  password */
  ctime         varchar2(19),                  /* user account creation time */
  ptime         varchar2(19),                        /* password change time */
  exptime       varchar2(19),             /* actual password expiration time */
  ltime         varchar2(19),                 /* time when account is locked */
  profnum       number,                                 /* resource profile# */
  user_audit        varchar2(38),                     /* user audit options */
  defrole       number,                           /* default role indicator: */
  defgrp_num       number,                             /* default undo group */
  defgrp_seq_num   number,             /* global sequence number for the grp */
  astatus       number,                             /* status of the account */
  lcount        number,                    /* count of failed login attempts */
  ext_username  varchar2(400),                          /* external username */
  spare1        number,
  spare2        number,
  spare3        number,
  spare4        varchar2(1000),
  spare5        varchar2(1000),
  spare6        varchar2(19),
  schema        varchar2(30),                                      /* schema */
  package       varchar2(30)                                      /* package */
)
/
grant execute on ku$_role_t to public
/
-- If the caller (i.e., the user querying the view)
--   (a) is SYS or
--   (b) has EXP_FULL_DATABASE role
-- the caller can see all metadata for the role including passwords.
-- Otherwise, if the caller has SELECT_CATALOG_ROLE
-- the caller can see all metadata for the role except passwords.

create or replace force view ku$_role_view of ku$_role_t
  with object identifier(user_id) as
  select '1','1',
        u.user#,
        u.name,
        u.type#,
        u.password,
          to_char(u.ctime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.exptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ltime,'YYYY/MM/DD HH24:MI:SS'),
          u.resource$,
          replace(u.audit$,chr(0),'-'),
          u.defrole,
          u.defgrp#,
          u.defgrp_seq#,
          u.astatus,
          u.lcount,
          u.ext_username,
          u.spare1,
          u.spare2,
          u.spare3,
          u.spare4,
          u.spare5,
          to_char(u.spare6,'YYYY/MM/DD HH24:MI:SS'),
        (select r.schema from sys.approle$ r  where r.role#=u.user#), 
        (select r.package from sys.approle$ r  where r.role#=u.user#)
  from sys.user$ u 
  where   u.type# = 0 
  AND (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
        OR EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='EXP_FULL_DATABASE' ))
UNION
  select '1','1',
        u.user#,
        u.name,
        u.type#,
        NULL,
          to_char(u.ctime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.exptime,'YYYY/MM/DD HH24:MI:SS'),
          to_char(u.ltime,'YYYY/MM/DD HH24:MI:SS'),
          u.resource$,
          replace(u.audit$,chr(0),'-'),
          u.defrole,
          u.defgrp#,
          u.defgrp_seq#,
          u.astatus,
          u.lcount,
          u.ext_username,
          u.spare1,
          u.spare2,
          u.spare3,
          NULL,
          u.spare5,
          to_char(u.spare6,'YYYY/MM/DD HH24:MI:SS'),
        (select r.schema from sys.approle$ r  where r.role#=u.user#), 
        (select r.package from sys.approle$ r  where r.role#=u.user#)
  from sys.user$ u 
  where   u.type# = 0 
     AND (SYS_CONTEXT('USERENV','CURRENT_USERID') != 0 ) 
     AND NOT (EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='EXP_FULL_DATABASE' ))
     AND (EXISTS ( SELECT * FROM sys.session_roles 
                   WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_role_view to public
/
-------------------------------------------------------------------------------
--                              PROFILE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_profile_attr_t as object
(
  profile_id    number,                                       /* profile id  */
  resource_num  number,                                        /* resource id*/
  resname       varchar2(30),                               /* resource name */
  type_num              number,                                      /* type */
  limit_num             number                                      /* limit */
)
/
grant execute on ku$_profile_attr_t to public
/ 
create or replace type ku$_profile_list_t as TABLE of ku$_profile_attr_t
/
create or replace force view ku$_profile_attr_view of ku$_profile_attr_t
  with object identifier(profile_id) as
  select  p.profile#,
          p.resource#, 
          r.name, 
          p.type#, 
          p.limit# 
  from sys.resource_map r, sys.profile$ p 
  where p.resource# = r.resource# and p.type# = r.type# 
/
grant select on ku$_profile_attr_view to select_catalog_role
/ 
grant execute on ku$_profile_list_t to public
/ 
create or replace type ku$_profile_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  profile_id    number,                                       /* profile id  */
  profile_name  varchar2(30),                                /* profile name */
  pass_func_name varchar2(30),                   /* password verify function */
  profile_list  ku$_profile_list_t                     /* profile attributes */
)
/
grant execute on ku$_profile_t to public
/
create or replace force view ku$_profile_view of ku$_profile_t
  with object identifier(profile_id) as
  select '1','0',
        n.profile#,
        n.name, 
        (select distinct o.name
            from    sys.obj$ o, sys.ku$_profile_attr_view p
            where   o.type# = 8 AND
                    o.owner# = 0 AND
                    o.obj# = p.limit_num and
                    p.profile_id = n.profile# and
                    p.resource_num =4 and    -- res# 4, type# 1 =
                    p.type_num =1 ),         -- PASSWORD_VERIFY_FUNCTION
        cast(multiset (select * from ku$_profile_attr_view pl
            where pl.profile_id = n.profile# ) as ku$_profile_list_t 
        )
  from sys.profname$ n 
  where (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_profile_view to public
/
-------------------------------------------------------------------------------
--                              DEFAULT_ROLE
-------------------------------------------------------------------------------
--
create or replace type ku$_defrole_item_t as object
(
  user_id       number,                                          /* user id  */
  user_name     varchar2(30),                                   /* user name */
  role          varchar2(30),                            /* role source name */
  role_id       number                                            /* role id */
)
/
grant execute on ku$_defrole_item_t to public
/
create or replace type ku$_defrole_list_t as TABLE of ku$_defrole_item_t
/
create or replace force view ku$_defrole_list_view of ku$_defrole_item_t
  with object identifier(user_id) as
  select  d$.user#, u$.name, u1$.name, d$.role#
  from    sys.user$ u$, sys.user$ u1$, sys.defrole$ d$
  where   u$.user# = d$.user# AND
          u1$.user# = d$.role#
/
grant select on ku$_defrole_list_view to select_catalog_role
/ 
grant execute on ku$_defrole_list_t to public
/ 
create or replace type ku$_defrole_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  user_id       number,                                       /* profile id  */
  user_name     varchar2(30),                                   /* user name */
  user_type     number,                                /* 0 = role, 1 = user */
  defrole       number,                                 /* default role type */
  role_list     ku$_defrole_list_t                              /* role list */
)
/
grant execute on ku$_defrole_t to public
/
create or replace force view ku$_defrole_view of ku$_defrole_t
  with object identifier(user_id) as
  select '1','0',
          u.user#,
          u.name,
          u.type#,
          u.defrole,
          cast(multiset (select * from ku$_defrole_list_view df
                where df.user_id = u.user#) as ku$_defrole_list_t 
                )
  from sys.user$ u 
  where (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_defrole_view to public
/
-------------------------------------------------------------------------------
--                              PROXY
-------------------------------------------------------------------------------
--
create or replace type ku$_proxy_role_item_t as object
(
  role_id       number,                                           /* role id */
  client        varchar2(30),                                 /* client name */
  proxy         varchar2(30),                                  /* proxy name */
  role          varchar2(30)                                 /* role context */
)
/
grant execute on ku$_proxy_role_item_t to public
/
create or replace type ku$_proxy_role_list_t as TABLE of ku$_proxy_role_item_t
/
create or replace force view ku$_proxy_role_list_view of ku$_proxy_role_item_t
  with object identifier(client, proxy, role_id) as
  select  prd.role#, uc.name, up.name, ur.name
  from    sys.user$ ur, sys.user$ uc, 
          sys.user$ up ,sys.proxy_role_info$ prd
  where   prd.role#   = ur.user# AND
                prd.client# = uc.user# AND
                prd.proxy#  = up.user#
/
grant select on ku$_proxy_role_list_view to select_catalog_role
/ 
grant execute on ku$_proxy_role_list_t to public
/ 
create or replace type ku$_proxy_t as object
(
  user_id       number,                                           /* role id */
  client_name   varchar2(30),                                 /* client name */
  proxy_name    varchar2(30),                                  /* proxy name */
  flags         number,               /* Mask flags of associated with entry */
  cred_type     number,                /* Type of credential passed by proxy */
  proxy_role_list  ku$_proxy_role_list_t                  /* proxy role list */
)
/
grant execute on ku$_proxy_t to public
/
create or replace force view ku$_proxy_view of ku$_proxy_t
  with object identifier(user_id) as
  select  u.user#, u.name, up.name, pi.flags,
          pi.credential_type#,
          cast(multiset (select * from ku$_proxy_role_list_view pr
                where pr.client= u.name AND pr.proxy=up.name) 
                as ku$_proxy_role_list_t) 
  from   sys.user$ u, sys.user$ up, sys.proxy_info$ pi
  where  pi.client# = u.user# AND
         pi.proxy# = up.user#(+)
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_proxy_view to public
/ 

-- 10_1 view excludes enterprise user proxies.  No downgrade possible.

create or replace force view ku$_10_1_proxy_view of ku$_proxy_t
  with object identifier(user_id) as
  select t.* from ku$_proxy_view t
  where bitand(t.flags,16)=0
/
grant select on ku$_10_1_proxy_view to public
/ 

-- 
-------------------------------------------------------------------------------
--                              ROLE_GRANT
-------------------------------------------------------------------------------
--
create or replace type ku$_rogrant_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  grantee_id    number,                                         /* user id  */
  grantee       varchar2(30),                                    /* grantee */
  role          varchar2(30),                                       /* role */
  role_id       number,                                          /* role id */
  admin         number,                                    /*  admin option */
  sequence      number                             /* unique grant sequence */
)
/
grant execute on ku$_rogrant_t to public
/
create or replace force view ku$_rogrant_view of ku$_rogrant_t
  with object identifier(grantee_id, role_id) as
  select '1','0',
          u1.user#, u1.name, u2.name, u2.user#, NVL(g.option$, 0), g.sequence#
  from    sys.user$ u1, sys.user$ u2, sys.sysauth$ g
  where   u1.user# = g.grantee# AND
          u2.user# = g.privilege# AND
          g.privilege# > 0 
          AND (SYS_CONTEXT('USERENV','CURRENT_USERID') =0 
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_rogrant_view to public
/
-------------------------------------------------------------------------------
--                              TABLESPACE_QUOTA
-------------------------------------------------------------------------------
-- 
create or replace type ku$_tsquota_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  user_id       number,                                          /* user id  */
  user_name     varchar2(30),                                /* name of user */
  ts_name       varchar2(30),                             /* tablespace name */
  ts_id         number,                                     /* tablespace id */
  maxblocks     number,                                        /* max blocks */
  blocksize     number,                                       /* blocks size */
  grantor_num   number,                                        /* grantor id */
  grantor       varchar2(30),                                /* grantor name */
  blocks        number,                  /* number of blocks charged to user */
  priv1         number,                     /* reserved for future privilege */
  priv2         number,                     /* reserved for future privilege */
  priv3         number                      /* reserved for future privilege */
)
/
grant execute on ku$_tsquota_t to public
/
create or replace force view ku$_tsquota_view of ku$_tsquota_t
  with object identifier(user_id, ts_id) as
  select  '1','0',
          u.user#, u.name, t.name, q.ts#, q.maxblocks, t.blocksize, q.grantor#,
          'SYSTEM', q.blocks, q.priv1, q.priv2, q.priv3
  from    sys.user$ u, sys.tsq$ q, sys.ts$ t
  where   q.user# = u.user# AND 
          q.ts# = t.ts# AND
          q.maxblocks != 0 AND
          t.online$ IN (1, 2, 4) AND 
          bitand(t.flags,2048) = 0 AND
          (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_tsquota_view to public
/
-------------------------------------------------------------------------------
--                              RESOURCE_COST 
-------------------------------------------------------------------------------
-- 
create or replace type ku$_resocost_item_t as object
(
  resource_id       number,                                   /* resource id */
  resource_name     varchar2(30),                                /* resource */
  resource_type     number,                                          /* type */
  unit_cost         number                                      /* unit cost */
)
/
grant execute on ku$_resocost_item_t to public
/
create or replace type ku$_resocost_list_t as TABLE of ku$_resocost_item_t
/
create or replace force view ku$_resocost_list_view of ku$_resocost_item_t
  with object identifier(resource_id) as
  select  m.resource#, m.name,m.type#, c.cost
  from    sys.resource_cost$ c, sys.resource_map m
  where   c.resource# = m.resource#
/
grant select on ku$_resocost_list_view to select_catalog_role
/
grant execute on ku$_resocost_list_t to public
/
create or replace type ku$_resocost_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  cost_list     ku$_resocost_list_t                   /* resource cost info */
)
/ 
grant execute on ku$_resocost_t to public
/
create or replace force view ku$_resocost_view of ku$_resocost_t
  with object identifier (vers_major) as 
  select '1','0',
         cast(multiset (select * from  ku$_resocost_list_view
             ) as  ku$_resocost_list_t
         )
  from dual
/
grant select on ku$_resocost_view to  select_catalog_role
/
-------------------------------------------------------------------------------
--                              SEQUENCE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_sequence_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                            /* sequence object number */
  schema_obj    ku$_schemaobj_t,                   /* sequence schema object */
  incre         number,                     /* the sequence number increment */
  minvalue      varchar2(28),                   /* minimum value of sequence */
  maxvalue      varchar2(28),                   /* maximum value of sequence */
  cycle         number,                               /* 0 = FALSE, 1 = TRUE */
  seq_order     number,                               /* 0 = FALSE, 1 = TRUE */
  cache         number,                          /* how many to cache in sga */
  highwater     varchar2(28),                        /* disk high water mark */
  seq_audit     varchar2(38),                            /* auditing options */
  flags         number                               /* 0x08 LOGICAL STANDBY */
)
/
grant execute on ku$_sequence_t to public
/
create or replace force view ku$_sequence_view of ku$_sequence_t
  with object identifier(obj_num) as
  select '1','0',
         s.obj#, value(o), 
         s.increment$, TO_CHAR(s.minvalue), TO_CHAR(s.maxvalue),
         s.cycle#, s.order$, s.cache, 
         TO_CHAR(s.highwater),  replace(s.audit$,chr(0),'-'), s.flags
  from  sys.ku$_schemaobj_view o, sys.seq$ s
  where s.obj# = o.obj_num AND
        (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
         EXISTS ( SELECT * FROM sys.session_roles 
         WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_sequence_view to public
/
-------------------------------------------------------------------------------
--                              CONTEXT
-------------------------------------------------------------------------------
-- 
create or replace type ku$_context_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                            /* context object number */
  schema_obj    ku$_schemaobj_t,                   /* context schema object */
  schema_name   varchar2(30),                                 /* schema name */
  package_name  varchar2(30),                                /* package name */
  flags         number
)
/
grant execute on ku$_context_t to public
/
create or replace force view ku$_context_view of ku$_context_t
  with object identifier(obj_num) as
  select '1','0',
         c.obj#, value(o),
         c.schema, c.package, c.flags
  from   sys.ku$_schemaobj_view o, sys.context$ c
  where  o.obj_num = c.obj# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 OR 
          SYS_CONTEXT('USERENV','SESSION_USER') = c.schema OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_context_view to public
/
-------------------------------------------------------------------------------
--                              DIMENSION
-------------------------------------------------------------------------------
-- 
create or replace type ku$_dimension_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                           /* dimension object number */
  schema_obj    ku$_schemaobj_t,                  /* dimension schema object */
  dimtextlen    number,                                 /* length of dimtext */
  dimtext       clob                      /* store the dimension when length */
)
/
grant execute on ku$_dimension_t to public
/
create or replace force view ku$_dimension_view of ku$_dimension_t
  with object identifier(obj_num) as
  select '1','0',
         d.obj#, value(o),
         d.dimtextlen,
         sys.dbms_metadata_util.long2clob(d.dimtextlen,
                                        'SYS.DIM$',
                                        'DIMTEXT',
                                        d.rowid)
  from sys.ku$_schemaobj_view o, sys.dim$ d
  where d.obj# = o.obj_num  AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_dimension_view to public
/
-------------------------------------------------------------------------------
--                              ASSOCIATION
-------------------------------------------------------------------------------
create or replace type ku$_assoc_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                              /* association object # */
  base_obj      ku$_schemaobj_t,                              /* base object */
  obj_type      number,                                  /* association type */
  objcol        varchar2(30),                          /* association column */
  stats_obj     ku$_schemaobj_t,                            /* statistic obj */
  selectivity   number,                                       /* selectivity */
  cpu_cost      number,                                           /* cpu cost*/
  io_cost       number,                                           /* io cost */
  net_cost      number,                                          /* net cost */
  interface_version number,
  spare2        number
) 
/
grant execute on ku$_assoc_t to public
/
create or replace force view ku$_assoc_view of ku$_assoc_t
  with object identifier(obj_num) as
  select '1','0',
        a.obj#,
        value(so),
        a.property,
        (select c.name from  sys.col$ c where c.obj# = a.obj# and
           c.intcol# = a.intcol#),
        (select value(ss) from ku$_schemaobj_view ss where
                   ss.obj_num = a.statstype#), 
        NVL(a.default_selectivity, 0), NVL(a.default_cpu_cost, 0),
        NVL(a.default_io_cost, 0), NVL(a.default_net_cost, 0),
        a.interface_version#, a.spare2
   from  sys.ku$_schemaobj_view so,
         sys.association$ a
   where   a.obj# =so.obj_num
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID')=0  or
              EXISTS ( SELECT * FROM sys.session_roles 
                      WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_assoc_view to public
/
-------------------------------------------------------------------------------
--                              PASSWORD_VERIFY_FUNCTION 
-------------------------------------------------------------------------------
--
create or replace force view ku$_pwdvfc_view of ku$_proc_t
  with object identifier (obj_num) as
  select t.vers_major, t.vers_minor, t.obj_num, t.type_num,
         t.schema_obj, t.source_lines
  from ku$_base_proc_view t, profile$ p
  where t.type_num = 8 and t.obj_num = p.limit#
                        and p.resource# =4 and p.type# =1 
/
grant select on ku$_pwdvfc_view to select_catalog_role 
/
-------------------------------------------------------------------------------
--                              COMMENT
-------------------------------------------------------------------------------
-- 
create or replace type ku$_comment_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  base_obj      ku$_schemaobj_t,                       /* base schema object */
  property      number,                                  /* table properties */
  colno         number,                                         /* column id */
  colname       varchar2(30),                                 /* column name */
  cmnt          clob                                         /* comment text */
)
/
grant execute on ku$_comment_t to public
/
create or replace force view ku$_comment_view of ku$_comment_t
  with object identifier(obj_num) as
  select '1','0',
         cm.obj#, value(o),
         (select t.property from sys.tab$ t where t.obj#=cm.obj#),
         cm.col#,
         (select c.name 
                 from  sys.col$ c 
                 where  c.obj#=cm.obj# and c.intcol# = cm.col# ),
         TO_CLOB(replace(cm.comment$,'''',''''''))
  from   sys.ku$_schemaobj_view o, 
                sys.com$ cm 
  where  o.obj_num = cm.obj# AND
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
             EXISTS ( SELECT * FROM sys.session_roles 
                WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_comment_view to public
/

-- 10_1 view excludes comments on indextypes and operators
-- (type# 32,33) - support added in 10gR2

create or replace force view ku$_10_1_comment_view of ku$_comment_t
  with object identifier(obj_num) as
  select t.* from ku$_comment_view t
  where t.base_obj.type_num not in (32,33)
/
grant select on ku$_10_1_comment_view to public
/


-------------------------------------------------------------------------------
--                              CLUSTER
-------------------------------------------------------------------------------
--
create or replace type ku$_cluster_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                  /* cluster object # */
  schema_obj    ku$_schemaobj_t,                       /* cluster schema obj */
  col_list      ku$_column_list_t,
  ts_name       varchar2(30),                                  /* tablespace */
  blocksize     number,                            /* size of block in bytes */
  tsno          number,                                 /* tablespace number */
  fileno        number,                        /* segment header file number */
  blockno       number,                       /* segment header block number */
  pct_free      number,          /* minimum free space percentage in a block */
  pct_used      number,          /* minimum used space percentage in a block */
  initrans      number,                     /* initial number of transaction */
  maxtrans      number,                     /* maximum number of transaction */
  size_t        number,
  hashfunc      varchar2(30),              /* if hashed, function identifier */
  hashkeys      number,                                    /* hash key count */
  function      number, /* function: 0 (key is function), 1 (system default) */
  extind        number,             /* extent index value of fixed hash area */
  flags         number,                                      /* 0x08 = CACHE */
                                          /* 0x010000 = Single Table Cluster */
                                                /* 0x00800000 = DEPENDENCIES */
  degree        number,      /* number of parallel query slaves per instance */
  instances     number,       /*  number of OPS instances for parallel query */
  avgchn        number,          /* average chain length - previously spare4 */
  funclen       number, 
  functxt       varchar2(4000),
  func_vcnt     ku$_vcnt,
  func_clob     clob,  
  storage       ku$_storage_t,
  spare1        number,
  spare2        number,
  spare3        number,
  spare4        number,
  spare5        varchar2(1000),
  spare6        varchar2(1000),
  spare7        varchar2(19)
)
/
grant execute on ku$_cluster_t to public
/
create or replace force view ku$_cluster_view of ku$_cluster_t
  with object identifier(obj_num) as
  select '1','3',
        o.obj_num,
        value(o),
        cast(multiset(select * from ku$_column_view col
                       where col.obj_num = c.obj#
                        order by col.col_num, col.intcol_num
                      ) as ku$_column_list_t
        ),
        ts.name, ts.blocksize,
        ts.ts#, c.file#, c.block#,
        c.pctfree$, c.pctused$, c.initrans, c.maxtrans,NVL(c.size$, -1), 
        c.hashfunc, NVL(c.hashkeys, 0), NVL(c.func, 1), c.extind, 
        c.flags,
        NVL(c.degree, 1), NVL(c.instances, 1),
        NVL(c.avgchn, -1),
        (select condlength from sys.cdef$ co  where co.obj# = c.obj#),
        NULL,    /* functxt  */
        NULL,    /* func_vcnt */
        (select sys.dbms_metadata_util.long2clob(cd.condlength,
                                        'SYS.CDEF$',
                                        'CONDITION',
                                        cd.rowid)
              from sys.cdef$ cd  where cd.obj# = c.obj#),
        (select value(s) from  ku$_storage_view s 
             where s.file_num = c.file#  and  s.block_num= c.block#
                 and s.ts_num = c.ts#),
        c.spare1, c.spare2, c.spare3, c.spare4, c.spare5, c.spare6, 
        to_char(c.spare7,'YYYY/MM/DD HH24:MI:SS')
   from     sys.ku$_schemaobj_view o, sys.ts$ ts, sys.clu$ c
   where    o.obj_num = c.obj# AND
                c.ts# = ts.ts# AND
            (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
             EXISTS ( SELECT * FROM sys.session_roles 
                WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_cluster_view to public;
/
-------------------------------------------------------------------------------
--                              AUDIT
-------------------------------------------------------------------------------
create or replace type ku$_audit_t as object
(
  vers_major    char(1),
  vers_minor    char(1),        
  user_num      number,                            /* user identifier number */
  user_name     varchar2(30),                                   /* user name */
  proxy_num     number,                             /* UID of the proxy user */
  audit_option  varchar2(40),                             /* auditing option */
  property      number,                   /* 0x01 = do not export this audit */
  success       number,                                 /* audit on success? */
  failure       number,                                 /* audit on failure? */
  option_num    number                              /* option# in option map */
)
/
grant execute on ku$_audit_t to public
/
create or replace force view ku$_audit_view of ku$_audit_t
  with object identifier(user_num) as
  select '1','0',
        a.user#,
        u.name,
        a.proxy#,
        m.name, m.property, 
        NVL(a.success, 0), 
        NVL(a.failure, 0),
        a.option#
  from     sys.audit$ a, sys.stmt_audit_option_map m,
           sys.user$ u 
  where    a.user# = u.user# and
           a.option# = m.option# 
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_audit_view to public;
/

-- 10_1 view excludes option#s not defined in the 10.1 release.

create or replace force view ku$_10_1_audit_view of ku$_audit_t
  with object identifier(user_num) as
  select t.* from ku$_audit_view t
  where t.option_num in 
         ( 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,
          23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
          43,44,45,46,47,48,49,50,54,57,58,60,61,62,63,65,66,67,68,69,
          71,72,73,77,80,81,82,83,84,85,86,87,90,91,92,103, 104, 105, 
          106, 107, 108, 109, 111, 115, 120, 121, 125, 126, 127, 128, 
          130, 131, 135, 138, 139, 140, 141, 142, 143, 144, 146, 147, 
          151, 152, 153, 154, 157, 158, 160, 161, 162, 163, 165, 167, 
          172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 
          184, 185, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
          197, 198, 199, 210, 211, 214, 215, 216, 217, 218, 219, 220, 
          221, 222, 223, 224, 225, 226, 234, 235, 236, 237, 238, 239, 
          240, 241, 242, 243, 244, 255, 256, 262, 263, 264, 265, 266, 
          267, 268, 269, 270, 271, 272, 273, 274, 275 )
/
grant select on ku$_10_1_audit_view to public
/
-------------------------------------------------------------------------------
--                              AUDIT_OBJ
-------------------------------------------------------------------------------
create or replace type ku$_audit_obj_t as object
(
  vers_major    char(1),
  vers_minor    char(1),        
  obj_num       number,                                     /* object number */
  base_obj      ku$_schemaobj_t,                          /* base obj schema */
  audit_val     varchar2(38),                            /* auditing options */
  audit_list    sys.ku$_audit_list_t                           /* audit list */
)
/
grant execute on ku$_audit_obj_t to public
/
create or replace force view ku$_audit_obj_base_view of ku$_audit_obj_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num,
         value(o), 
         case when o.type_num = 2 
        then (SELECT replace(t.audit$,chr(0),'-') from sys.tab$ t
              where t.obj# = o.obj_num)
        when o.type_num = 4
        then (SELECT replace(v.audit$,chr(0),'-') from sys.view$ v
              where v.obj# = o.obj_num)
        when o.type_num = 6
        then (SELECT replace(s.audit$,chr(0),'-') from sys.seq$ s
              where s.obj# = o.obj_num)
        when o.type_num = 7
        then (SELECT replace(p.audit$,chr(0),'-') from sys.procedure$ p
              where p.obj# = o.obj_num)
        when o.type_num = 13
        then (SELECT replace(ty.audit$,chr(0),'-') from sys.type_misc$ ty
              where ty.obj#= o.obj_num)
        when o.type_num = 22
        then (SELECT replace(l.audit$,chr(0),'-') from sys.library$ l
              where l.obj# = o.obj_num)
        when o.type_num = 23
        then (SELECT replace(d.audit$,chr(0),'-') from sys.dir$ d
              where d.obj# = o.obj_num)
        else null end,
         sys.dbms_metadata_util.get_audit(o.obj_num,o.type_num)
  from   ku$_schemaobj_view o 
  where  bitand(o.flags,4)=0            -- exclude system-generated objects
/
grant select on sys.ku$_audit_obj_base_view to select_catalog_role;
/
create or replace force view ku$_audit_obj_view of ku$_audit_obj_t
  with object identifier(obj_num) as
  select value(ku$) from sys.ku$_audit_obj_base_view ku$
  where trim('-' from ku$.audit_val) IS NOT NULL
  and  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ku$.base_obj.owner_num, 0)
        OR    EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on sys.ku$_audit_obj_view to public;
/
-------------------------------------------------------------------------------
--                              AUDIT_DEFAULT
-------------------------------------------------------------------------------
create or replace type ku$_audit_default_t as object
(
  vers_major       char(1),
  vers_minor       char(1),
  obj_num          number,                                /* object number */
  audit_val        varchar2(38),                       /* auditing options */
  aud_default_list sys.ku$_audit_default_list_t              /* audit list */
)
/
grant execute on ku$_audit_default_t to public
/
create or replace force view ku$_audit_default_view of ku$_audit_default_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj#,
         t.audit$,
         sys.dbms_metadata_util.get_audit_default(o.obj#)
  from   tab$ t, obj$ o
  where  o.name = '_default_auditing_options_'
    and  o.owner# = 0
    and  t.obj# = o.obj#
    and  trim('-' from replace(t.audit$,chr(0),'-')) IS NOT NULL
/
grant select on sys.ku$_audit_default_view to select_catalog_role
/

-------------------------------------------------------------------------------
--                              JAVA_OBJNUM
-------------------------------------------------------------------------------
-- Used to fetch object numbers of java objects - used by heterogeneous
--  object types.  See comments on ku$_view_objnum_view, above.

create or replace force view ku$_java_objnum_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select value(o) from ku$_schemaobj_view o
  where o.type_num in (28,29,30)
  and bitand(o.flags,16)!= 16       -- exclude secondary objects
  and (o.owner_name NOT IN ('SYS', 'ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
 and    (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_java_objnum_view to public
/

-------------------------------------------------------------------------------
--                              JAVA_SOURCE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_java_source_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         /* java source object number */
  schema_obj    ku$_schemaobj_t,                /* java source schema object */
  long_name     varchar2(4000),                              /* synlong name */
  source_lines  ku$_source_list_t,                           /* source lines */
  java_resource sys.ku$_java_t                             /* export source  */
)
/
grant execute on ku$_java_source_t to public
/
create or replace force view ku$_java_source_view of ku$_java_source_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, value(o),
         nvl((select j.longdbcs from sys.javasnm$ j where j.short = o.name),
             o.name),
         cast(multiset(select s.joxftobn, s.joxftlno, 
                              NULL,NULL,NULL,NULL,NULL, s.joxftsrc
                from  x$joxfs s
                       where s.joxftobn = o.obj_num order by s.joxftlno
                       ) as ku$_source_list_t
             ),
         sys.dbms_metadata.get_java_metadata (o.name, 
                                                   o.owner_name, o.type_num)
  from sys.ku$_schemaobj_view o
  where o.type_num = 28 and
            (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
             OR EXISTS ( SELECT * FROM sys.session_roles 
                WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_java_source_view to public
/
-------------------------------------------------------------------------------
--                              AQ_QUEUE_TABLE
-------------------------------------------------------------------------------
--
-- QUEUE_TABLE storage clause info 
create or replace type ku$_qtab_storage_t as object
(
  obj_num       number,                         /* queue table object number */
  property      number,
  ts_num        number,                         
  ts_name       varchar2(30),
  pct_free      number,
  pct_used       number,
  initrans      number,
  maxtrans      number
)
/
grant execute on ku$_qtab_storage_t to public
/
create or replace force view ku$_qtab_storage_view of ku$_qtab_storage_t
  with object identifier(obj_num) as
  select  tab.obj#,tab.property,
          ts.ts#,ts.name,
          tab.pctfree$,tab.pctused$,
          tab.initrans,tab.maxtrans
  from tab$ tab, ts$ ts
  where tab.ts# =ts.ts#
/
grant select on ku$_qtab_storage_view to select_catalog_role
/

create or replace type ku$_queue_table_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         /* queue table object number */
  schema_obj    ku$_schemaobj_t,                    /* object of queue table */
  storage_clause ku$_qtab_storage_t,                  /* storage_clause info */
  udata_type    number,                                     /* userdata type */
  object_type   varchar2(61),                          /* userdata type name */
  sort_cols     number,                            /* sort order for dequeue */
  flags         number,                            /* queue table properties */
  table_comment         varchar2(2000),                      /* user comment */
  primary_instance      number,                /*  primary owner instance-id */
  secondary_instance    number,               /* secondary owner instance-id */
  owner_instance        number                  /* current owner instance-id */
)
/
grant execute on ku$_queue_table_t to public
/
create or replace force view ku$_queue_table_view of ku$_queue_table_t
  with object identifier(obj_num) as
  select '1','1',
          t.objno, 
          (select value(qo) from  sys.ku$_schemaobj_view qo where 
             qo.obj_num=t.objno),
          (select value(s) from sys.ku$_qtab_storage_view s where
             s.obj_num = t.objno),  
          t.udata_type,
         (select u.name || '.' || o.name  
            from sys.ku$_schemaobj_view o, sys.user$ u,
                 sys.col$ c, sys.coltype$ ct  
             where c.intcol# = ct.intcol# 
                and c.obj# = ct.obj# 
                and c.name = 'USER_DATA' 
                and t.objno = c.obj# 
                and o.oid = ct.toid
                and o.type_num = 13
                and o.owner_num = u.user#),
         t.sort_cols,
         t.flags,
         t.table_comment,
         aft.primary_instance,
         aft.secondary_instance,
         aft.owner_instance
  from   system.aq$_queue_tables t, 
         sys.aq$_queue_table_affinities aft
  where  t.objno = aft.table_objno 
/
grant select on ku$_queue_table_view to public
/
-------------------------------------------------------------------------------
--                              AQ_QUEUE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_queues_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         /* queue table object number */
  qid           number,                            /* queue obj number */ 
  schema_obj    ku$_schemaobj_t,                      /* queue object schema */
  base_obj      ku$_schemaobj_t,                   /* queue table obj schema */
  tflags        number,                            /* queue table properties */
  usage         number,                                /* usage of the queue */
  max_retries   number,                         /* maximum number of retries */
  retry_delay   number,                      /* delay before retrying (secs) */
  enqueue_enabled number,                                 /*  queue enabled? */
  properties    number,                      /*  various properties of queue */
  retention     number,                       /* retention time (in seconds) */
  queue_comment  varchar2(2000)                              /* user comment */
)
/
grant execute on ku$_queues_t to public
/
create or replace force view ku$_queues_view of ku$_queues_t
  with object identifier(obj_num) as
  select '1','0',
        t.objno, 
        q.eventid,
     (select value(o) from sys.ku$_schemaobj_view o where o.obj_num=q.eventid),
     (select value(b) from sys.ku$_schemaobj_view b where b.obj_num=t.objno),
        t.flags,
        q.usage, q.max_retries, q.retry_delay,
        q.enable_flag, 
        q.properties, q.ret_time, q.queue_comment
  from system.aq$_queues q, system.aq$_queue_tables t
  where   q.table_objno = t.objno 
/
grant select on ku$_queues_view to public
/
--
-------------------------------------------------------------------------------
--                              AQ_TRANSFORM
-------------------------------------------------------------------------------
-- 
create or replace type ku$_qtrans_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  transformation_id    number,                          /* transformation id */
  schema_name          varchar2(30),                               /* schema */
  transform_name       varchar2(30),                  /* transformation name */
  from_obj             ku$_schemaobj_t,                   /* from obj schema */
  to_obj               ku$_schemaobj_t,                     /* to obj schema */
  attribute_num        number,                                  
  sql_expression       clob
)
/
grant execute on ku$_qtrans_t to public
/
create or replace force view ku$_qtrans_view of ku$_qtrans_t
  with object identifier(transformation_id) as
  select '1','0',
          t.transformation_id,
          u.name, t.name, 
          (select value (f) from ku$_schemaobj_view f where f.oid=t.from_toid),
          (select value (o) from ku$_schemaobj_view o where o.oid=t.to_toid),
          at.attribute_number,
          TO_CLOB(replace(at.sql_expression, '''', ''''''))
  from sys.user$ u , transformations$ t, attribute_transformations$ at
  where  u.name = t.owner and t.transformation_id = at.transformation_id
/
grant select on ku$_qtrans_view to       public
/
--
-------------------------------------------------------------------------------
--                              JOB
-------------------------------------------------------------------------------
-- 
create or replace type ku$_job_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  powner_id     number,                                          /* owner id */
  powner        varchar2(30),                                  /* owner name */
  lowner        varchar2(30),                              /* logged in user */
  cowner        varchar2(30),                                    /* parsing  */
  job_id        number,                                           /* job id  */
  last_date     varchar2(19),                /* when this job last succeeded */
  this_date     varchar2(19),   /* when current execute started,usually null */
  next_date     varchar2(19),                /* when to execute the job next */
  flag          number,                          /* 0x01, this job is broken */
  failures      number,             /* number of failures since last success */
  interval_num  varchar2(400),                /* function for next next_date */
  what          clob,                        /* PL/SQL text, what is the job */
  nlsenv        clob,                                      /* nls parameters */
  env           raw(32),                      /* other environment variables */
  field1        number,            /* instance number restricted to run  job */
  charenv       varchar2(4000)                /* Reserved for Trusted Oracle */
)
/
grant execute on ku$_job_t to public
/
create or replace force view ku$_job_view of ku$_job_t
  with object identifier(powner_id) as
  select '1','0',
         u.user#, j.powner, j.lowner, j.cowner, j.job,
         TO_CHAR(j.last_date, 'YYYY-MM-DD HH24:MI:SS'),
         TO_CHAR(j.this_date, 'YYYY-MM-DD HH24:MI:SS'),
         TO_CHAR(j.next_date, 'YYYY-MM-DD HH24:MI:SS'),
         j.flag, j.failures,
         REPLACE(j.interval#, '''', ''''''),
         TO_CLOB(REPLACE(j.what, '''', '''''')),
         TO_CLOB(REPLACE(j.nlsenv, '''', '''''')),
         j.env, j.field1, j.charenv
  from   sys.job$ j, sys.user$ u
  where  j.powner = u.name
/
grant select on ku$_job_view to public
/

--
-------------------------------------------------------------------------------
--                      TABLE/INDEX/CLUSTER STATISTICS
-------------------------------------------------------------------------------
--
create or replace type ku$_histgrm_t as object
(
  obj_num           number,             -- histogram object number
  intcol_num        number,             -- internal object number
  bucket            number,             -- bucket information
  endpoint          number,             -- endpoint value
  epvalue           VARCHAR2(4000),     -- ep value
  spare1            number              -- sample number of distinct values
)
/
grant execute on ku$_histgrm_t to public
/

create or replace type ku$_histgrm_list_t
  as table of ku$_histgrm_t
/
grant execute on ku$_histgrm_list_t to public
/

-- Note: this view calls the function dbms_metadata_util.nulltochr0
-- to replace embedded \0 in epvalue characters with CHR(0).
-- In the worst case, this could dramatically increase the
-- size of epvalue; most likely, though, the column will only
-- have one or two \0 characters.  Since histgrm$.epvalue 
-- has a length of 1000 characters, we allocate a VARCHAR2(4000)
-- in the UDT, and that should be big enough for all but
-- pathological cases.

create or replace force view ku$_histgrm_view of ku$_histgrm_t
  with object identifier (obj_num, intcol_num, bucket, endpoint) as
   select  obj#, intcol#, bucket, endpoint,
           dbms_metadata_util.nulltochr0(epvalue),
           spare1
   from    sys.histgrm$
   order by obj#, intcol#, bucket
/
grant select on ku$_histgrm_view to select_catalog_role
/

-- Get the minimum histogram values for 10.1 compatibility
create or replace force view ku$_10_1_histgrm_min_view of ku$_histgrm_t
  with object identifier (obj_num, intcol_num, endpoint) as
   select  obj#, intcol#, 0, minimum, NULL, NULL
   from    sys.hist_head$
   where   bucket_cnt = 1
/
grant select on ku$_10_1_histgrm_min_view to select_catalog_role
/

-- Get the maximum histogram values for 10.1 compatibility
create or replace force view ku$_10_1_histgrm_max_view of ku$_histgrm_t
  with object identifier (obj_num, intcol_num, endpoint) as
   select  obj#, intcol#, 1, maximum, NULL, NULL
   from    sys.hist_head$
   where   bucket_cnt = 1
/
grant select on ku$_10_1_histgrm_max_view to select_catalog_role
/

--
-- type for column statistics
--
create or replace type ku$_col_stats_t as object
(
  obj_num           number,             -- table/partition/subpartition objnum
  intcol_num        number,             -- internal column number
  distcnt           number,             -- distinct count
  lowval            raw(32),            -- low value
  hival             raw(32),            -- high value
  density           number,             -- density
  null_cnt          number,             -- null count
  avgcln            number,             -- average column length
  cflags            number,             -- flags
  eav               number,
  sample_size       number,
  minimum           number,
  maximum           number,
  spare1            number,             -- sample number of distinct values
  hist_gram_list    ku$_histgrm_list_t  -- histogram list
)
/
grant execute on ku$_col_stats_t to public
/
create or replace type ku$_col_stats_list_t
  as table of ku$_col_stats_t
/
grant execute on ku$_col_stats_list_t to public
/

--
-- type for column statistics for 10_1 compatiblity
--
create or replace type ku$_10_1_col_stats_t as object
(
  tab_obj_num       number,             -- table object number
  p_obj_num         number,             -- partition object number
  colname           VARCHAR2(30),       -- column name
  intcol_num        number,             -- internal column number
  distcnt           number,             -- distinct count
  lowval            raw(32),            -- low value
  hival             raw(32),            -- high value
  density           number,             -- density
  null_cnt          number,             -- null count
  avgcln            number,             -- average column length
  cflags            number,             -- flags
  eav               number,             --
  hist_gram_list    ku$_histgrm_list_t, -- histogram list
  hist_gram_min     ku$_histgrm_t,      -- minimum histogram
  hist_gram_max     ku$_histgrm_t       -- maximum histogram
)
/
grant execute on ku$_10_1_col_stats_t to public
/
create or replace type ku$_10_1_col_stats_list_t
  as table of ku$_10_1_col_stats_t
/
grant execute on ku$_10_1_col_stats_list_t to public
/

--
-- view for column statistics
--
-- Note:  this view used to filter out columns that didn't have a distcnt > 0
--        or spare2 that without bit 1 or 2 set.  This was wrong and was fixed.
--
create or replace force view ku$_col_stats_view of ku$_col_stats_t
  with object identifier (obj_num) as
  select  obj#, intcol#, distcnt, lowval, hival, density, null_cnt, avgcln,
          bitand(spare2, 3), bitand(spare2, 4), sample_size,
          minimum, maximum, spare1,
          cast(multiset(select value(hv)
                        from   sys.ku$_histgrm_view hv
                        where  hv.obj_num = hh.obj#
                           and hv.intcol_num = hh.intcol#)
                        as ku$_histgrm_list_t)
  from    sys.hist_head$ hh
/
grant select on ku$_col_stats_view to select_catalog_role
/

--
-- view for table column statistics for 10.1 compatibility
--
create or replace force view ku$_10_1_tab_col_stats_view of
        ku$_10_1_col_stats_t
  with object identifier (tab_obj_num) as
  select  c.obj#, hh.obj#, c.name, hh.intcol#, hh.distcnt, hh.lowval,
          hh.hival, hh.density, hh.null_cnt, hh.avgcln,
          bitand(hh.spare2, 3), bitand(hh.spare2, 4),
          cast(multiset(select value(hv)
                        from   sys.ku$_histgrm_view hv
                        where  hv.obj_num = hh.obj#
                           and hv.intcol_num = hh.intcol#)
                        as ku$_histgrm_list_t),
          (select value(hminv)
           from   sys.ku$_10_1_histgrm_min_view hminv
           where  hminv.obj_num = hh.obj#
              and hminv.intcol_num = hh.intcol#),
          (select value(hmaxv)
           from   sys.ku$_10_1_histgrm_max_view hmaxv
           where  hmaxv.obj_num = hh.obj#
              and hmaxv.intcol_num = hh.intcol#)
  from    sys.col$ c, sys.hist_head$ hh
  where   hh.obj# = c.obj# and
          hh.intcol# = c.intcol# and
          -- Need to remove rows for user defined stats.  Look in qosp.h
          -- for macros likeQOS_IS_*_STATS_EXTN.  This is where the next 3
          -- lines were taken from.
          NOT (BITAND(c.property,65576) = 65576 AND
               LENGTH(c.name) > 6 AND
               SUBSTR(c.name, 1, 6) = 'SYS_ST')
/
grant select on ku$_10_1_tab_col_stats_view to select_catalog_role
/

--
-- view for partition column statistics for 10.1 compatibility
--

create or replace force view ku$_10_1_ptab_col_stats_view of
        ku$_10_1_col_stats_t
  with object identifier (tab_obj_num) as
  select  c.obj#, hh.obj#, c.name, hh.intcol#, hh.distcnt, hh.lowval,
          hh.hival, hh.density, hh.null_cnt, hh.avgcln,
          bitand(hh.spare2, 3), bitand(hh.spare2, 4),
          cast(multiset(select value(hv)
                        from   sys.ku$_histgrm_view hv
                        where  hv.obj_num = hh.obj#
                           and hv.intcol_num = hh.intcol#)
                        as ku$_histgrm_list_t),
          (select value(hminv)
           from   sys.ku$_10_1_histgrm_min_view hminv
           where  hminv.obj_num = hh.obj#
              and hminv.intcol_num = hh.intcol#),
          (select value(hmaxv)
           from   sys.ku$_10_1_histgrm_max_view hmaxv
           where  hmaxv.obj_num = hh.obj#
              and hmaxv.intcol_num = hh.intcol#)
  from    sys.col$ c, sys.tabpart$ tp, sys.hist_head$ hh
  where   hh.obj# = tp.obj# AND
          tp.bo# = c.obj# AND
          hh.intcol# = c.intcol# and
          -- Need to remove rows for user defined stats.  Look in qosp.h
          -- for macros likeQOS_IS_*_STATS_EXTN.  This is where the next 3
          -- lines were taken from.
          NOT (BITAND(c.property,65576) = 65576 AND
               LENGTH(c.name) > 6 AND
               SUBSTR(c.name, 1, 6) = 'SYS_ST')
UNION ALL
  select  c.obj#, hh.obj#, c.name, hh.intcol#, hh.distcnt, hh.lowval,
          hh.hival, hh.density, hh.null_cnt, hh.avgcln,
          bitand(hh.spare2, 3), bitand(hh.spare2, 4),
          cast(multiset(select value(hv)
                        from   sys.ku$_histgrm_view hv
                        where  hv.obj_num = hh.obj#
                           and hv.intcol_num = hh.intcol#)
                        as ku$_histgrm_list_t),
          (select value(hminv)
           from   sys.ku$_10_1_histgrm_min_view hminv
           where  hminv.obj_num = hh.obj#
              and hminv.intcol_num = hh.intcol#),
          (select value(hmaxv)
           from   sys.ku$_10_1_histgrm_max_view hmaxv
           where  hmaxv.obj_num = hh.obj#
              and hmaxv.intcol_num = hh.intcol#)
  from    sys.col$ c, sys.hist_head$ hh,  sys.tabcompart$ tcp,
          sys.tabsubpart$ tsp
  where   hh.obj# = tsp.obj# AND
          tsp.pobj# = tcp.obj# AND
          tcp.bo# = c.obj# AND
          hh.intcol# = c.intcol# and
          -- Need to remove rows for user defined stats.  Look in qosp.h
          -- for macros likeQOS_IS_*_STATS_EXTN.  This is where the next 3
          -- lines were taken from.
          NOT (BITAND(c.property,65576) = 65576 AND
               LENGTH(c.name) > 6 AND
               SUBSTR(c.name, 1, 6) = 'SYS_ST')
/
grant select on ku$_10_1_ptab_col_stats_view to select_catalog_role
/

create or replace type ku$_cached_stats_t as object
(
  obj_num       number,
  cachedblk     number,
  cachehit      number
)
/
grant execute on ku$_cached_stats_t to public
/

create or replace force view ku$_tab_cache_stats_view of ku$_cached_stats_t
    with object identifier (obj_num) as
  select obj#, cachedblk, cachehit from sys.tab_stats$
/
grant select on ku$_tab_cache_stats_view to select_catalog_role
/

create or replace force view ku$_ind_cache_stats_view of ku$_cached_stats_t
    with object identifier (obj_num) as
  select obj#, cachedblk, cachehit from sys.ind_stats$
/
grant select on ku$_ind_cache_stats_view to select_catalog_role
/

--
-- table and partition specific statistic data
--
create or replace type ku$_tab_ptab_stats_t as object
(
  obj_num           number,             -- table object number
  trigflag          number,             -- table trigflag
  tabname           VARCHAR2(30),       -- table/nested table name
  partname          VARCHAR2(30),       -- Partition name
  subpartname       VARCHAR2(30),       -- subpartition name
  bobj_num          number,             -- base object number for part. tabs
  sysgen_cols       number,             -- system generated columns?
  blkcnt            number,             -- block count
  rowcnt            number,             -- row count
  avgrln            number,             -- average row length
  flags             number,             -- global/user spec. stats
  sample_size       number,             -- number of rows sampled by Analyze
  analyzetime       varchar2(19),       -- timestamp when last analyzed
  cache_info        ku$_cached_stats_t, -- cached stats information
  col_stats         ku$_col_stats_list_t-- column stats list for table (part)
)
/
grant execute on ku$_tab_ptab_stats_t to public
/

--
-- Type list for partition specific statistic data
--
create or replace type ku$_ptab_stats_list_t
  as table of ku$_tab_ptab_stats_t
/
grant execute on ku$_ptab_stats_list_t to public
/

--
-- table and partition specific statistic data for 10.1 compatibility
--
create or replace type ku$_10_1_tab_ptab_stats_t as object
(
  obj_num           number,             -- table object number
  trigflag          number,             -- table trigflag
  schema_obj        ku$_schemaobj_t,    -- table schema object
  bobj_num          number,             -- base object number for part. tabs
  sysgen_cols       number,             -- system generated columns?
  blkcnt            number,             -- block count
  rowcnt            number,             -- row count
  avgrln            number,             -- average row length
  flags             number,             -- global/user spec. stats
  cache_info        ku$_cached_stats_t, -- cached stats information
  col_stats         ku$_10_1_col_stats_list_t
                                        -- column stats list for table (part)
)
/
grant execute on ku$_10_1_tab_ptab_stats_t to public
/

--
-- Type list for partition specific statistic data for 10.1 compatibility
--
create or replace type ku$_10_1_ptab_stats_list_t
  as table of ku$_10_1_tab_ptab_stats_t
/
grant execute on ku$_10_1_ptab_stats_list_t to public
/

--
-- view for table specific statistic data
--
create or replace force view ku$_tab_only_stats_view of ku$_tab_ptab_stats_t
  with object identifier (obj_num) as
  select  t.obj#, t.trigflag, o.name, null, null, null,
          bitand(t.property, 2097152), t.blkcnt, t.rowcnt, t.avgrln,
          decode(bitand(t.flags, 768),
                 786, 3,            /* user specified stats and global stats */
                 512, 2,                                /* global stats only */
                 256, 1,                        /* user specified stats only */
                 /* Bug 8794227: t.flags values 768,512,256 gives info about
                    stats type but not about whether table is analyzed or not.
                    To find whether table analyzed or not, one more decode
                    function is added with value 16. */
                 0, decode(bitand(t.flags,16),
                           16,0,                        /* Table is analyzed */
                           4),      /* Table never analyzed or stats deleted */
                 0),
           t.samplesize, TO_CHAR(t.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(csv)
                        from   sys.ku$_col_stats_view csv
                        where  csv.obj_num = t.obj#)
                        as ku$_col_stats_list_t)
  from    sys.obj$ o, sys.tab$ t
  where   o.obj# = t.obj# AND
          NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#)
/
grant select on ku$_tab_only_stats_view to select_catalog_role
/

--
-- view for table specific statistic data for 10.1 compatibility
--
create or replace force view ku$_10_1_tab_only_stats_view of
        ku$_10_1_tab_ptab_stats_t
  with object identifier (obj_num) as
  select  t.obj#, t.trigflag,
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = t.obj#),
          null, bitand(t.property, 2097152), t.blkcnt, t.rowcnt, t.avgrln,
          decode(bitand(t.flags, 768),
                 786, 3,            /* user specified stats and global stats */
                 512, 2,                                /* global stats only */
                 256, 1,                        /* user specified stats only */
                 /* Bug 8794227: t.flags values 768,512,256 gives info about 
                    stats type but not about whether table is analyzed or not.
                    To find whether table analyzed or not, one more decode 
                    function is added with value 16. */
                 0, decode(bitand(t.flags,16),
                           16,0,                        /* Table is analyzed */
                              4),   /* Table never analyzed or stats deleted */
                 0),
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(tcsv)
                        from   sys.ku$_10_1_tab_col_stats_view tcsv
                        where  tcsv.tab_obj_num = t.obj# and
                               bitand(t.property, 2097152) = 0 )
                        as ku$_10_1_col_stats_list_t)
  from    sys.tab$ t
  where   NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#)
/
grant select on ku$_10_1_tab_only_stats_view to select_catalog_role
/

create or replace force view ku$_ptab_stats_view of ku$_tab_ptab_stats_t
  with object identifier (obj_num) as
  select  /*+ no_merge */
          t.obj#, bt.trigflag, o.name, o.subname, null, t.bo#,
          bitand(bt.property, 2097152), t.blkcnt, t.rowcnt, t.avgrln,
          decode(bitand(t.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          t.samplesize, TO_CHAR(t.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(csv)
                        from   sys.ku$_col_stats_view csv
                        where  csv.obj_num = t.obj#)
                        as ku$_col_stats_list_t)
  from    sys.obj$ o, sys.tab$ bt, sys.tabpart$ t
  where   o.obj# = t.obj# and
          t.bo# = bt.obj# AND
          NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#) AND
          BITAND(t.flags,2) != 0
UNION ALL
  select  /*+ no_merge */
          t.obj#, bt.trigflag, op.name, op.subname, null, t.bo#,
          bitand(bt.property, 2097152), t.blkcnt, t.rowcnt,
          t.avgrln,
          decode(bitand(t.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          t.samplesize, TO_CHAR(t.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(csv)
                        from   sys.ku$_col_stats_view csv
                        where  csv.obj_num = t.obj#)
                        as ku$_col_stats_list_t)
  from    sys.obj$ op, sys.tab$ bt, sys.tabcompart$ t
  where   op.obj# = t.obj# and
          t.bo# = bt.obj# AND
          NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#) AND
          BITAND(t.flags,2) != 0
UNION ALL
  select  /*+ no_merge */
          tsp.obj#, bt.trigflag, ot.name, op.subname, ot.subname, t.bo#,
          bitand(bt.property, 2097152), tsp.blkcnt, tsp.rowcnt,
          tsp.avgrln,
          decode(bitand(tsp.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          t.samplesize, TO_CHAR(t.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(csv)
                        from   sys.ku$_col_stats_view csv
                        where  csv.obj_num = tsp.obj#)
                        as ku$_col_stats_list_t)
  from    sys.obj$ ot, sys.obj$ op, sys.tab$ bt, sys.tabcompart$ t,
          sys.tabsubpart$ tsp
  where   ot.obj# = tsp.obj# and
          tsp.pobj# = t.obj# AND
          t.obj# = op.obj# AND
          t.bo# = bt.obj# AND
          NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#) AND
          BITAND(tsp.flags,2) != 0
/
grant select on ku$_ptab_stats_view to select_catalog_role
/

--
-- Partition view for 10_1 compability
--
create or replace force view ku$_10_1_ptab_stats_view of
        ku$_10_1_tab_ptab_stats_t
  with object identifier (obj_num) as
  select  t.obj#, bt.trigflag,
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = t.obj#),
          t.bo#, bitand(bt.property, 2097152), t.blkcnt, t.rowcnt, t.avgrln,
          decode(bitand(t.flags, 24), 24, 3, 16, 2, 8, 1, 0), 
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(pcsv)
                        from   sys.ku$_10_1_ptab_col_stats_view pcsv
                        where  pcsv.tab_obj_num = bo# and
                               pcsv.p_obj_num = t.obj# and
                               bitand(bt.property, 2097152) = 0)
                        as ku$_10_1_col_stats_list_t)
  from    sys.tab$ bt, sys.tabpart$ t
  where   t.bo# = bt.obj# AND
          NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#) AND
          BITAND(t.flags,2) != 0
UNION ALL
  select  tsp.obj#, bt.trigflag,
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = tsp.obj#),
          t.bo#, bitand(bt.property, 2097152), tsp.blkcnt, tsp.rowcnt,
          tsp.avgrln,
          decode(bitand(tsp.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          (select value(tcsv) from sys.ku$_tab_cache_stats_view tcsv
           where t.obj# = tcsv.obj_num),
          cast(multiset(select value(pcsv)
                        from   sys.ku$_10_1_ptab_col_stats_view pcsv
                        where  pcsv.tab_obj_num = bo# and
                               pcsv.p_obj_num = tsp.obj# and
                               bitand(bt.property, 2097152) = 0)
                        as ku$_10_1_col_stats_list_t)
  from    sys.tab$ bt, sys.tabcompart$ t, sys.tabsubpart$ tsp
  where   tsp.pobj# = t.obj# AND
          t.bo# = bt.obj# AND
          NOT EXISTS (                   /* table does not have associations */
                SELECT 1
                FROM   sys.association$ a
                where  a.obj# = t.obj#) and
          NOT EXISTS (           /* type in table does not have associations */
                SELECT  1
                FROM    sys.obj$ tt, sys.coltype$ ct, sys.association$ a
                WHERE   t.obj# = ct.obj# AND
                        ct.toid = tt.oid$ AND
                        tt.obj# = a.obj#) AND
          BITAND(tsp.flags,2) != 0
/
grant select on ku$_10_1_ptab_stats_view to select_catalog_role
/
--
-- This type changed in 11.1.0.7, but just added columns that won't be used
-- in anything prior to 11.1.0.7, so it can be used when compatibility is set
-- prior to 11.1.0.7.
--
create or replace type ku$_tab_col_t as object
(
  obj_num           number,             -- histogram object number
  colname           VARCHAR2(30),       -- column name
  name              VARCHAR2(30),       -- column name (backward compatibility)
  intcol_num        number,             -- internal column number
  col_num           number,             -- column number
  property          number,             -- column property
  nested_table      number,             -- 0 if no, 1 if yes
  attr_colname      varchar2(4000),     -- col name from attrcol$
  default_val       varchar2(4000)      -- virtual column expression text
)
/
grant execute on ku$_tab_col_t to public
/

create or replace type ku$_tab_col_list_t
  as table of ku$_tab_col_t
/
grant execute on ku$_tab_col_list_t to public
/

create or replace force view ku$_tab_col_view of ku$_tab_col_t
  with object identifier (obj_num, intcol_num) as
   select  obj#, name, name, intcol#, col#, property,
           decode(c.property, 1056, 1, 0),   -- if nested table, 1, otherwise 0
           decode(c.property , 1056,         -- if nested table get intcol - 1
             (select name from attrcol$ a    -- else get incol info
              where a.obj# = c.obj# AND a.intcol# = c.intcol# - 1),
              (NVL((select name from attrcol$ a
                  where a.obj# = c.obj# AND a.intcol# = c.intcol#), NULL))),
           sys.dbms_metadata_util.long2varchar(c.deflength,
                                               'SYS.COL$',
                                               'DEFAULT$',
                                               c.rowid)
   from    sys.col$ c
   where   BITAND(c.property, 12) != 12 AND
           --
           -- DataPump doesn't support xdp repository columns.  This foolows
           -- the same "hack" that is done in ku$_strmtable_view.  This needs
           -- to be fixed with fusion security.  Basically, 2 columns can't
           -- be imported so the stats for these 2 columns should not be
           -- exported.
           --
           NOT EXISTS (SELECT c1.obj#
                       FROM   sys.col$ c1
                       WHERE  c1.obj# = c.obj# AND
                              c1.intcol# = c.intcol# AND
                              bitand(c.property,32) != 0 AND
                              c.name IN ('OWNERID', 'ACLOID'))
   order by intcol#
/
grant select on ku$_tab_col_view to select_catalog_role
/

create or replace force view ku$_10_2_tab_col_view of ku$_tab_col_t
  with object identifier (obj_num, intcol_num) as
   select  obj#, name, name, intcol#, col#, property,
           decode(c.property, 1056, 1, 0),   -- if nested table, 1, otherwise 0
           decode(c.property , 1056,         -- if nested table get intcol - 1
             (select name from attrcol$ a    -- else get incol info
              where a.obj# = c.obj# AND a.intcol# = c.intcol# - 1),
              (NVL((select name from attrcol$ a
                  where a.obj# = c.obj# AND a.intcol# = c.intcol#), NULL))),
           sys.dbms_metadata_util.long2varchar(c.deflength,
                                               'SYS.COL$',
                                               'DEFAULT$',
                                               c.rowid)
   from    sys.col$ c
   where   BITAND(c.property, 12) != 12 AND
          -- Need to remove rows for user defined stats.  Look in qosp.h
          -- for macros likeQOS_IS_*_STATS_EXTN.  This is where the next 3
          -- lines were taken from.
           NOT (BITAND(c.property,65576) = 65576 AND
               LENGTH(c.name) > 6 AND
               SUBSTR(c.name, 1, 6) = 'SYS_ST') AND
           --
           -- DataPump doesn't support xdp repository columns.  This foolows
           -- the same "hack" that is done in ku$_strmtable_view.  This needs
           -- to be fixed with fusion security.  Basically, 2 columns can't
           -- be imported so the stats for these 2 columns should not be
           -- exported.
           --
           NOT EXISTS (SELECT c1.obj#
                       FROM   sys.col$ c1
                       WHERE  c1.obj# = c.obj# AND
                              c1.intcol# = c.intcol# AND
                              bitand(c.property,32) != 0 AND
                              c.name IN ('OWNERID', 'ACLOID'))
   order by intcol#
/
grant select on ku$_10_2_tab_col_view to select_catalog_role
/
--
-- type for full table statistics
--
create or replace type ku$_tab_stats_t as object
(
  vers_major        char(1),                    -- UDT major version #
  vers_minor        char(1),                    -- UDT minor version #
  obj_num           number,                     -- object number for table
  base_obj          ku$_schemaobj_t,            -- table information
  nested_tab_name   varchar2(30),               -- nested table name
  column_list       ku$_tab_col_list_t,         -- column list
  tab_info          ku$_tab_ptab_stats_t,       -- table statistics
  ptab_info_list    ku$_ptab_stats_list_t       -- partitioned statistics
)
/
grant execute on ku$_tab_stats_t to public
/

--
-- type for full table statistics for 10.1 compatibility
--
create or replace type ku$_10_1_tab_stats_t as object
(
  vers_major        char(1),                    -- UDT major version #
  vers_minor        char(1),                    -- UDT minor version #
  obj_num           number,                     -- object number for table
  base_obj          ku$_schemaobj_t,            -- table information
  tab_info          ku$_10_1_tab_ptab_stats_t,  -- table statistics
  ptab_info_list    ku$_10_1_ptab_stats_list_t  -- partitioned statistics
)
/
grant execute on ku$_10_1_tab_stats_t to public
/

--
-- view for complete table analyzed statistics
--
create or replace force view ku$_tab_stats_view of ku$_tab_stats_t
  with object identifier (obj_num) as
  select  '2', '1', o.obj#,
          -- if this is a nested table, get parent table, otherwise get table.
         decode(bitand(t.property , 8192), 8192,
           (select value(oo) from ku$_schemaobj_view oo
            where  oo.obj_num = dbms_metadata_util.get_anc(o.obj#)),
           (select value(sov) from ku$_schemaobj_view sov
            where sov.obj_num = o.obj#)),
          decode(bitand(t.property , 8192), 8192, o.name, null),
          cast(multiset(select value(tcv) from sys.ku$_tab_col_view tcv
                        where tcv.obj_num = o.obj#)
               as ku$_tab_col_list_t),
          value(tosv),
          cast(multiset(select value(psv)
                        from   sys.ku$_ptab_stats_view psv
                        where  psv.bobj_num = o.obj#)
                        as ku$_ptab_stats_list_t)
  from    sys.obj$ o, sys.tab$ t, ku$_tab_only_stats_view tosv
  where   tosv.obj_num = o.obj# and
          o.obj# = t.obj# and
          o.type# = 2 and
          -- Bug 8794227: Get the table stats info when stats deleted
          -- but locked based on trigflag value.
          BITAND(t.property, 512) = 0 AND -- NOT AN IOT MAPPING TABLE
          (BITAND(t.flags, 16) != 0 or
           BITAND(t.trigflag,67108864) != 0)
      and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_tab_stats_view to public
/

--
-- view for complete table analyzed statistics
--
create or replace force view ku$_10_2_tab_stats_view of ku$_tab_stats_t
  with object identifier (obj_num) as
  select  '2', '1', o.obj#,
          -- if this is a nested table, get parent table, otherwise get table.
         decode(bitand(t.property , 8192), 8192,
           (select value(oo) from ku$_schemaobj_view oo
            where  oo.obj_num = dbms_metadata_util.get_anc(o.obj#)),
           (select value(sov) from ku$_schemaobj_view sov
            where sov.obj_num = o.obj#)),
          decode(bitand(t.property , 8192), 8192, o.name, null),
          cast(multiset(select value(tcv) from sys.ku$_10_2_tab_col_view tcv
                        where tcv.obj_num = o.obj#)
               as ku$_tab_col_list_t),
          value(tosv),
          cast(multiset(select value(psv)
                        from   sys.ku$_ptab_stats_view psv
                        where  psv.bobj_num = o.obj#)
                        as ku$_ptab_stats_list_t)
  from    sys.obj$ o, sys.tab$ t, ku$_tab_only_stats_view tosv
  where   tosv.obj_num = o.obj# and
          o.obj# = t.obj# and
          o.type# = 2 and
          -- Bug 8794227: Get the table stats info when stats deleted
          -- but locked based on trigflag value.
          BITAND(t.property, 512) = 0 AND -- NOT AN IOT MAPPING TABLE
          (BITAND(t.flags, 16) != 0 or
           bitand(t.trigflag,67108864) != 0)
      and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_10_2_tab_stats_view to public
/

--
-- view for complete table analyzed statistics for 10.1 compatibility
--
create or replace force view ku$_10_1_tab_stats_view of
        ku$_10_1_tab_stats_t
  with object identifier (obj_num) as
  select  '1', '0', o.obj#,
          -- if this is a nested table, get parent table, otherwise get table.
         decode(bitand(t.property , 8192), 8192,
           (select value(oo) from ku$_schemaobj_view oo
            where  oo.obj_num = dbms_metadata_util.get_anc(o.obj#)),
           (select value(sov) from ku$_schemaobj_view sov
            where sov.obj_num = o.obj#)),
          value(tosv),
          cast(multiset(select value(psv)
                        from   sys.ku$_10_1_ptab_stats_view psv
                        where  psv.bobj_num = o.obj#)
                        as ku$_10_1_ptab_stats_list_t)
  from    sys.obj$ o, sys.tab$ t, ku$_10_1_tab_only_stats_view tosv
  where   tosv.obj_num = o.obj# and
          o.obj# = t.obj# and
          o.type# = 2 and
          -- Bug 8794227: Get the table stats info when stats deleted
          -- but locked based on trigflag value.
          BITAND(t.property, 512) = 0 AND -- NOT AN IOT MAPPING TABLE
          (BITAND(t.flags, 16) != 0 or
           bitand(t.trigflag,67108864) != 0)
      and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_10_1_tab_stats_view to public
/

--
-- type for index stats values
--
-- type for subpartition portion of index information
--
create or replace type ku$_spind_stats_t as object
(
  obj_num           number,
  partname          varchar2(30),
  subpartname       varchar2(30),
  bobj_num          number,
  rowcnt            number,
  leafcnt           number,
  distkey           number,
  lblkkey           number,
  dblkkey           number,
  clufac            number,
  blevel            number,
  ind_flags         number,
  obj_flags         number,
  sample_size       number,
  analyzetime       varchar2(19),       -- timestamp when last analyzed
  cache_info        ku$_cached_stats_t              -- cached stats information
)
/
grant execute on ku$_spind_stats_t to public
/
create or replace type ku$_spind_stats_list_t
  as table of ku$_spind_stats_t
/
grant execute on ku$_spind_stats_list_t to public
/

--
-- type for subpartition portion of index information for 10.1 compatibility
--
create or replace type ku$_10_1_spind_stats_t as object
(
  obj_num           number,
  schema_obj        ku$_schemaobj_t,
  bobj_num          number,
  rowcnt            number,
  leafcnt           number,
  distkey           number,
  lblkkey           number,
  dblkkey           number,
  clufac            number,
  blevel            number,
  ind_flags         number,
  obj_flags         number,
  cache_info        ku$_cached_stats_t              -- cached stats information
)
/
grant execute on ku$_10_1_spind_stats_t to public
/
create or replace type ku$_10_1_spind_stats_list_t
  as table of ku$_10_1_spind_stats_t
/
grant execute on ku$_10_1_spind_stats_list_t to public
/

--
-- Create view for subpartition information
--
create or replace force view ku$_spind_stats_view of ku$_spind_stats_t
  with object identifier (obj_num) as
  select  o.obj#, op.subname,  o.subname, i.pobj#, i.rowcnt, i.leafcnt,
          i.distkey, i.lblkkey, i.dblkkey, i.clufac, i.blevel,
          decode(bitand(i.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          o.flags, i.samplesize,
          TO_CHAR(i.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num)
  from    sys.obj$ o, sys.obj$ op, sys.indsubpart$ i
  where   i.obj# = o.obj# and
          i.pobj# = op.obj# and
          bitand(i.flags,2) = 2                         /* index is analyzed */
/
grant select on ku$_spind_stats_view to select_catalog_role
/

--
-- Create view for subpartition information for 10.1 compatibility
--
create or replace force view ku$_10_1_spind_stats_view of
        ku$_10_1_spind_stats_t
  with object identifier (obj_num) as
  select  i.obj#,
          (select value(sov) from sys.ku$_schemaobj_view sov
           where sov.obj_num = i.obj#),
          i.pobj#, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          o.flags,
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num)
  from    sys.obj$ o, sys.indsubpart$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2                         /* index is analyzed */
/
grant select on ku$_10_1_spind_stats_view to select_catalog_role
/

--
-- type for partition portion of index information
--
create or replace type ku$_pind_stats_t as object
(
  obj_num           number,
  partname          VARCHAR2(30),
  bobj_num          number,
  rowcnt            number,
  leafcnt           number,
  distkey           number,
  lblkkey           number,
  dblkkey           number,
  clufac            number,
  blevel            number,
  ind_flags         number,
  obj_flags         number,
  sample_size       number,
  analyzetime       varchar2(19),       -- timestamp when last analyzed
  cache_info        ku$_cached_stats_t, -- cached stats information
  subpartition_list ku$_spind_stats_list_t
)
/
grant execute on ku$_pind_stats_t to public
/
create or replace type ku$_pind_stats_list_t
  as table of ku$_pind_stats_t
/
grant execute on ku$_pind_stats_list_t to public
/

--
-- type for partition portion of index information for 10.1 compatibility
--
create or replace type ku$_10_1_pind_stats_t as object
(
  obj_num           number,
  schema_obj        ku$_schemaobj_t,
  bobj_num          number,
  rowcnt            number,
  leafcnt           number,
  distkey           number,
  lblkkey           number,
  dblkkey           number,
  clufac            number,
  blevel            number,
  ind_flags         number,
  obj_flags         number,
  cache_info        ku$_cached_stats_t, -- cached stats information
  subpartition_list ku$_10_1_spind_stats_list_t
)
/
grant execute on ku$_10_1_pind_stats_t to public
/
create or replace type ku$_10_1_pind_stats_list_t
  as table of ku$_10_1_pind_stats_t
/
grant execute on ku$_10_1_pind_stats_list_t to public
/

create or replace force view ku$_pind_stats_view of ku$_pind_stats_t
  with object identifier (obj_num) as
  select  i.obj#, o.subname,
          i.bo#, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          o.flags, i.samplesize,
          TO_CHAR(i.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num), NULL
  from    sys.obj$ o, sys.indpart$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2                         /* index is analyzed */
UNION ALL
  select  i.obj#, o.subname,
          i.bo#, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          o.flags, i.samplesize,
          TO_CHAR(i.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num),
          cast(multiset(select value(sisv)
                        from   sys.ku$_spind_stats_view sisv
                        where  sisv.bobj_num = o.obj#)
                        as ku$_spind_stats_list_t)
  from    sys.obj$ o, sys.indcompart$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2                         /* index is analyzed */
/
grant select on ku$_pind_stats_view to select_catalog_role
/

-- view for 10.1 compatibility
create or replace force view ku$_10_1_pind_stats_view of
        ku$_10_1_pind_stats_t
  with object identifier (obj_num) as
  select  i.obj#,
          (select value(sov) from sys.ku$_schemaobj_view sov
           where sov.obj_num = i.obj#),
          i.bo#, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          o.flags,
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num), NULL
  from    sys.obj$ o, sys.indpart$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2                         /* index is analyzed */
UNION ALL
  select  i.obj#,
          (select value(sov) from sys.ku$_schemaobj_view sov
           where sov.obj_num = i.obj#),
          i.bo#, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 24), 24, 3, 16, 2, 8, 1, 0),
          o.flags,
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num),
          cast(multiset(select value(sisv)
                        from   sys.ku$_10_1_spind_stats_view sisv
                        where  sisv.bobj_num = o.obj#)
                        as ku$_10_1_spind_stats_list_t)
  from    sys.obj$ o, sys.indcompart$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2                         /* index is analyzed */
/
grant select on ku$_10_1_pind_stats_view to select_catalog_role
/

create or replace force view ku$_ind_col_view of ku$_tab_col_t
  with object identifier (obj_num,intcol_num) as
  select  i.obj#, c.name, c.name, i.intcol#, i.col#, c.property,
          decode(c.property, 1056, 1, 0),
          decode(c.property , 1056,
            (select name from attrcol$ a
             where a.obj# = c.obj# AND a.intcol# = c.intcol# - 1),
             (NVL((select name from attrcol$ a
                 where a.obj# = c.obj# AND a.intcol# = c.intcol#), NULL))),
          sys.dbms_metadata_util.long2varchar(c.deflength,
                                              'SYS.COL$',
                                              'DEFAULT$',
                                              c.rowid)
  from    col$ c, icol$ i
  where   i.bo# = c.obj# and
          i.intcol# = c.intcol#
/
grant select on ku$_ind_col_view to select_catalog_role
/

create or replace type ku$_ind_stats_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  obj_num           number,                                   /* Index obj # */
  base_obj_num      number,                                   /* Table obj # */
  base_tab_obj      ku$_schemaobj_t,
  base_ind_obj      ku$_schemaobj_t,
  type_num          number,                   /* what kind of index is this? */
  property          number,         /* immutable flags for life of the index */
  cols              number,
  rowcnt            number,
  leafcnt           number,
  distkey           number,
  lblkkey           number,
  dblkkey           number,
  clufac            number,
  blevel            number,
  ind_flags         number,
  obj_flags         number,
  sample_size       number,
  analyzetime       varchar2(19),       -- timestamp when last analyzed
  cache_info        ku$_cached_stats_t, -- cached stats information
  partition_list    ku$_pind_stats_list_t,
  cnst_col_list     ku$_tab_col_list_t
)
/
grant execute on ku$_ind_stats_t to public
/

-- type for 10.1 compatibility
create or replace type ku$_10_1_ind_stats_t as object
(
  vers_major        char(1),                          /* UDT major version # */
  vers_minor        char(1),                          /* UDT minor version # */
  obj_num           number,                                   /* Index obj # */
  base_obj_num      number,                                   /* Table obj # */
  base_tab_obj      ku$_schemaobj_t,
  base_ind_obj      ku$_schemaobj_t,
  type_num          number,                   /* what kind of index is this? */
  property          number,         /* immutable flags for life of the index */
  cols              number,
  rowcnt            number,
  leafcnt           number,
  distkey           number,
  lblkkey           number,
  dblkkey           number,
  clufac            number,
  blevel            number,
  ind_flags         number,
  obj_flags         number,
  cache_info        ku$_cached_stats_t, -- cached stats information
  partition_list    ku$_10_1_pind_stats_list_t,
  cnst_col_list     ku$_tab_col_list_t
)
/
grant execute on ku$_10_1_ind_stats_t to public
/
-- view for Index stats after version 11.1.0.6 compatibility
create or replace force view ku$_ind_stats_view of ku$_ind_stats_t
  with object identifier (obj_num) as
  select  '2', '1',
          i.obj#, i.bo#,
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = i.bo#),
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = i.obj#),
          i.type#, i.property,
          i.intcols, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 2112), 2112, 3, 2048, 2, 64, 1, 0),
          o.flags, i.samplesize,
          TO_CHAR(i.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num),
          cast(multiset(select value(psv)
                        from   sys.ku$_pind_stats_view psv
                        where  psv.bobj_num = i.obj#)
                        as ku$_pind_stats_list_t),
          cast(multiset(select value(icv)
                        from   sys.ku$_ind_col_view icv
                        where  icv.obj_num = i.obj# and
                               bitand(o.flags,4) = 4 and /* system generated */
                               bitand(i.property,1) = 1) /* constraint index */
                        as ku$_tab_col_list_t)
  from    sys.obj$ o, sys.ind$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2 and
          i.type# != 8 and                                 /* no lob indexes */
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_ind_stats_view to public
/

-- view for 10.2 and 11.1.0.6 compatibility
create or replace force view ku$_10_2_ind_stats_view of ku$_ind_stats_t
  with object identifier (obj_num) as
  select  '2', '0',
          i.obj#, i.bo#,
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = i.bo#),
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = i.obj#),
          i.type#, i.property,
          i.intcols, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 2112), 2112, 3, 2048, 2, 64, 1, 0),
          o.flags, i.samplesize,
          TO_CHAR(i.analyzetime, 'YYYY-MM-DD HH24:MI:SS'),
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num),
          cast(multiset(select value(psv)
                        from   sys.ku$_pind_stats_view psv
                        where  psv.bobj_num = i.obj#)
                        as ku$_pind_stats_list_t),
          cast(multiset(select value(icv)
                        from   sys.ku$_ind_col_view icv
                        where  icv.obj_num = i.obj# and
                               bitand(o.flags,4) = 4 and /* system generated */
                               bitand(i.property,1) = 1) /* constraint index */
                        as ku$_tab_col_list_t)
  from    sys.obj$ o, sys.ind$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2 and
          i.type# != 8 and                               /* no lob indexes */
          NOT EXISTS (SELECT 1 FROM SYS.COL$ C WHERE     /* no indexes with */
            C.OBJ# = I.BO# AND                           /* system generated */
            BITAND(C.PROPERTY,32) = 32 AND               /* column names */
            BITAND(O.FLAGS, 4) = 4) AND                  /* and index names */
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_10_2_ind_stats_view to public
/

-- view for 10.1 compatibility
create or replace force view ku$_10_1_ind_stats_view of
        ku$_10_1_ind_stats_t
  with object identifier (obj_num) as
  select  '1', '0',
          i.obj#, i.bo#,
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = i.bo#),
          (select value(sov) from ku$_schemaobj_view sov
           where sov.obj_num = i.obj#),
          i.type#, i.property,
          i.cols, i.rowcnt, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey,
          i.clufac, i.blevel,
          decode(bitand(i.flags, 2112), 2112, 3, 2048, 2, 64, 1, 0),
          o.flags,
          (select value(icsv) from sys.ku$_ind_cache_stats_view icsv
           where i.obj# = icsv.obj_num),
          cast(multiset(select value(psv)
                        from   sys.ku$_10_1_pind_stats_view psv
                        where  psv.bobj_num = i.obj#)
                        as ku$_10_1_pind_stats_list_t),
          cast(multiset(select value(icv)
                        from   sys.ku$_ind_col_view icv
                        where  icv.obj_num = i.obj# and
                               bitand(o.flags,4) = 4 and /* system generated */
                               bitand(i.property,1) = 1) /* constraint index */
                        as ku$_tab_col_list_t)
  from    sys.obj$ o, sys.ind$ i
  where   i.obj# = o.obj# and
          bitand(i.flags,2) = 2 and
          i.type# != 8 and                              /* no lob indexes */
          NOT EXISTS (SELECT 1 FROM SYS.COL$ C WHERE    /* no indexes with */
            C.OBJ# = I.BO# AND                          /* system generated */
            BITAND(C.PROPERTY,32) = 32) AND             /* column names */
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_10_1_ind_stats_view to public
/

--
-- These types and views are used in the kustat.xsl style sheet to determine
-- the index name when an index is system generated.
--

--
-- type for system generated index column information
--
create or replace type ku$_sgi_col_t as object
(
  obj_num           number,                 -- index object number
  con_num           number,                 -- constraint number if constraint
  name              varchar2(30)            -- column name
)
/
grant execute on ku$_sgi_col_t to public
/
create or replace type ku$_sgi_col_list_t
  as table of ku$_sgi_col_t
/
grant execute on ku$_sgi_col_list_t to public
/

--
-- Create view to fetch constraint columns.
--
create or replace force view ku$_find_sgc_cols_view 
  of ku$_sgi_col_t with object identifier (con_num) as
  select 0, cc.con#, c.name
  from   ccol$ cc, col$ c
  where  cc.obj# = c.obj# AND
         cc.col# = c.col#;
grant select on ku$_find_sgc_cols_view to select_catalog_role;

--
-- Create view to fetch index columns.
--
create or replace force view ku$_find_sgi_cols_view 
  of ku$_sgi_col_t with object identifier (obj_num, name) as
  select  i.obj#, 0, c.name
  from    col$ c, icol$ i
  where   i.bo# = c.obj# and
          i.intcol# = c.intcol#
/
grant select on ku$_find_sgi_cols_view to select_catalog_role;

create or replace type ku$_find_sgc_t as object
(
  obj_num               number,                           /* index obj # */
  num_cols              number,                           /* #cols in index */
  index_owner           varchar2(30),
  index_name            varchar2(30),
  table_owner           varchar2(30),
  table_name            varchar2(30),
  col_list              ku$_sgi_col_list_t
)
/
grant execute on ku$_find_sgc_t to public
/

create or replace force view ku$_find_sgc_view of ku$_find_sgc_t
  with object identifier (obj_num) as
  select  oi.obj#, cdef$.cols, ui.name, oi.name, ut.name, ot.name,
          cast(multiset(select value(sgcc)
                        from   sys.ku$_find_sgc_cols_view sgcc
                        where  sgcc.con_num = cdef$.con#)
                        as ku$_sgi_col_list_t)
  from    sys.cdef$, sys.obj$ oi, sys.obj$ ot, sys.con$, sys.user$ ui,
          sys.user$ ut
  where   cdef$.obj# = ot.obj# and
          cdef$.con# = con$.con# and
          oi.obj# = cdef$.enabled and
          ot.owner# = ut.user# and
          oi.owner# = ui.user# and
          bitand(cdef$.defer,8) = 8 and                  /* system generated */
          cdef$.type# = 3 and                           /* unique constraint */
          con$.name != oi.name and
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (ui.user#,ut.user#,0) OR
              EXISTS ( SELECT * FROM sys.session_roles
                       WHERE role='SELECT_CATALOG_ROLE' ))
UNION ALL
  select  i.obj#, i.intcols, ui.name, o.name, ut.name, ot.name,
          cast(multiset(select value(sgic)
                        from   sys.ku$_find_sgi_cols_view sgic
                        where  sgic.obj_num = i.obj# and
                               bitand(o.flags,4) = 4 and /* system generated */
                               bitand(i.property,1) = 1) /* constraint index */
                        as ku$_sgi_col_list_t)
  from    sys.obj$ o, sys.obj$ ot, sys.ind$ i, sys.user$ ui, sys.user$ ut
  where   i.obj# = o.obj# and
          i.bo# = ot.obj# and
          o.owner# = ui.user# and
          ot.owner# = ut.user# and
          i.type# != 8 and                              /* no lob indexes */
          bitand(o.flags,4) = 4 and                     /* system generated */
          bitand(i.property,1) = 1 and                  /* constraint index */
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR
              EXISTS ( SELECT * FROM sys.session_roles
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_find_sgc_view to public
/

create or replace force view ku$_find_sgcol_view (
    owner_name, table_name, col_name, col_default) AS
  select  u.name, o.name, c.name, c.default$
  from    sys.col$ c, sys.obj$ o, user$ u
  where   c.obj# = o.obj# and o.owner# = u.user# and default$ IS NOT NULL and
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR
              EXISTS ( SELECT * FROM sys.session_roles
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_find_sgcol_view to public
/

create or replace force view ku$_find_attrcol_view (
    owner_name, table_name, col_name, attr_colname) AS
  select  u.name, o.name, c.name, a.name
  from    sys.col$ c, sys.obj$ o, user$ u, sys.attrcol$ a
  where   c.obj# = o.obj# and
          o.owner# = u.user# and
          c.intcol# = a.intcol# and
          a.obj# = c.obj# and
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR
              EXISTS ( SELECT * FROM sys.session_roles
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_find_attrcol_view to public
/

create or replace force view ku$_find_ntab_attrcol_view (
     owner_name, table_name, col_name, attr_colname) AS
  select  u.name, o.name, c.name, a.name
  from    sys.col$ c, sys.obj$ o, user$ u, sys.attrcol$ a
  where   c.obj# = o.obj# and
          o.owner# = u.user# and
          c.intcol# - 1 = a.intcol# and
          a.obj# = c.obj# and
          bitand(c.property, 1056) = 1056 and
          (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR
              EXISTS ( SELECT * FROM sys.session_roles
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_find_ntab_attrcol_view to public
/

-------------------------------------------------------------------------------
--                              USER PREFERENCE STATS
-------------------------------------------------------------------------------
-- 
create or replace type ku$_up_stats_t as object
(
  obj_num            number,                    -- object number for table
  pname              varchar2(30),
  valnum             number,
  valchar            varchar2(1000),
  chgtime            varchar2(19),
  spare1             NUMBER)
/
grant execute on ku$_up_stats_t to public
/

create or replace type ku$_up_stats_list_t
  as table of ku$_up_stats_t
/
grant execute on ku$_up_stats_list_t to public
/

create or replace force view ku$_up_stats_view of ku$_up_stats_t
  with object identifier (obj_num) as
  select obj#, pname, valnum, valchar,
         TO_CHAR(chgtime, 'YYYY-MM-DD HH24:MI:SS'), spare1
  from   sys.optstat_user_prefs$
/
grant select on ku$_up_stats_view to select_catalog_role
/

create or replace type ku$_user_pref_stats_t as object
(
  vers_major        char(1),                    -- UDT major version #
  vers_minor        char(1),                    -- UDT minor version # */
  obj_num            number,                    -- object number for table
  base_obj           ku$_schemaobj_t,           -- table information
  up_stats_list      ku$_up_stats_list_t);
/
grant execute on ku$_user_pref_stats_t to public
/

create or replace force view ku$_user_pref_stats_view of ku$_user_pref_stats_t
  with object identifier (obj_num) as
  select '1', '0', o.obj#,
         (select value(sov) from ku$_schemaobj_view sov
          where sov.obj_num = o.obj#),
          cast(multiset(select value(usv) from ku$_up_stats_view usv
                        where usv.obj_num = o.obj#
                       ) as ku$_up_stats_list_t
              )
  from   sys.obj$ o
  where  exists (select 1 from sys.optstat_user_prefs$ opt
                 where o.obj# = opt.obj#) and 
         (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_user_pref_stats_view to public
/

-------------------------------------------------------------------------------
--                              JAVA_CLASS
-------------------------------------------------------------------------------
-- 
create or replace type ku$_java_class_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         /* java source object number */
  schema_obj    ku$_schemaobj_t,                /* java source schema object */
  long_name     varchar2(4000),                         /* synonym long name */
  java_resource sys.ku$_java_t                               /* source lines */
)
/
grant execute on ku$_java_class_t to public
/
create or replace force view ku$_java_class_view of ku$_java_class_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, value(o),
         nvl((select j.longdbcs from sys.javasnm$ j where j.short = o.name),
             o.name),
         sys.dbms_metadata.get_java_metadata (o.name, 
                                                   o.owner_name, o.type_num)
  from sys.ku$_schemaobj_view o
  where o.type_num = 29 and
            (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
             OR EXISTS ( SELECT * FROM sys.session_roles 
                WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_java_class_view to public
/
-------------------------------------------------------------------------------
--                              JAVA_RESOURCE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_java_resource_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         /* java source object number */
  schema_obj    ku$_schemaobj_t,                /* java source schema object */
  long_name     varchar2(4000),                         /* synonym long name */
  java_resource sys.ku$_java_t                               /* source lines */
)
/
grant execute on ku$_java_resource_t to public
/
create or replace force view ku$_java_resource_view of ku$_java_resource_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, value(o),
         nvl((select j.longdbcs from sys.javasnm$ j where j.short = o.name),
             o.name),
         sys.dbms_metadata.get_java_metadata (o.name, 
                                                   o.owner_name, o.type_num)
  from sys.ku$_schemaobj_view o
  where o.type_num = 30 and
            (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
             OR EXISTS ( SELECT * FROM sys.session_roles 
                WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_java_resource_view to public
/
-------------------------------------------------------------------------------
--                      REFRESH_GROUP
-------------------------------------------------------------------------------
create or replace type ku$_add_snap_t as object
(
  REFGROUP       number,                          /* number of refresh group */
  ref_add_user   varchar2(2000),          /* dbms_refresh.add execute string */
  ref_add_dba    varchar2(2000)          /* dbms_irefresh.add execute string */
)
/
grant execute on ku$_add_snap_t to public
/
create or replace type ku$_add_snap_list_t as TABLE of ku$_add_snap_t;
/
grant execute on ku$_add_snap_list_t to public
/
create or replace force view ku$_add_snap_view of ku$_add_snap_t
  with object identifier (refgroup) as
  select  r.refgroup, 
  sys.dbms_metadata_util.get_refresh_add_user(rc.owner,
                                        rc.name,rc.type#,rc.instsite) ,
  sys.dbms_metadata_util.get_refresh_add_dba(rc.owner,
                                        rc.name,rc.type#,rc.instsite) 
  from rgroup$ r, rgchild$ rc 
  where  r.refgroup = rc.refgroup 
/
grant select on ku$_add_snap_view to select_catalog_role
/
create or replace type ku$_refgroup_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  refname       varchar2(30),                       /* name of refresh group */
  owner_num     number,                                 /* owner user number */
  refowner      varchar2(30),                      /* owner of refresh group */
  refgroup      number,                           /* number of refresh group */
  ref_make_user varchar2(2000),     /* executing string of dbms_refresh.make */
  ref_make_dba  varchar2(2000),    /* executing string of dbms_irefresh.make */
  ref_child     ku$_add_snap_list_t              /* refresh group child info */
                                          /* dbms_refresh.add execute string */
)
/
grant execute on ku$_refgroup_t to public
/
create or replace force view ku$_refgroup_view of ku$_refgroup_t
  with object identifier (refname) as
  select  '1','0', r.name, u.user#, r.owner, r.refgroup,
          sys.dbms_metadata_util.get_refresh_make_user (r.refgroup),           
          sys.dbms_metadata_util.get_refresh_make_dba (r.refgroup),           
          cast(multiset(select value(s) from ku$_add_snap_view s
             where s.refgroup =r.refgroup)
                as ku$_add_snap_list_t
          )
  from sys.user$ u, sys.rgroup$  r 
  where  u.name=r.owner
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (r.owner, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_refgroup_view to public
/
-- 
-------------------------------------------------------------------------------
--                      MONITORING
-------------------------------------------------------------------------------
create or replace type ku$_monitor_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(2),                              /* UDT minor version # */
  obj_num       number,                                /* base object number */
  base_obj      ku$_schemaobj_t,                       /* base schema object */
  monitor       number                              /* 1: enable, 0: disable */
)
/
grant execute on ku$_monitor_t to  select_catalog_role
/
create or replace force view ku$_monitor_view of ku$_monitor_t
  with object identifier (obj_num) as
  select '1','0',
         o.obj_num,
         value(o),
         decode(bitand(nvl(t.flags, 0), 2097152), 2097152, 1, 0)
  from ku$_schemaobj_view o, sys.tab$ t
  where   t.obj# = o.obj_num and bitand(nvl(t.flags, 0), 2097152) != 0 
        AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/ 
grant select on ku$_monitor_view to public
/
--
-------------------------------------------------------------------------------
--                      RMGR_PLAN
-------------------------------------------------------------------------------
-- 
create or replace type ku$_rmgr_plan_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         
  schema_obj    ku$_schemaobj_t,
  cpu_method    varchar2(30), /* CPU resource allocation method for the plan */
  mast_method   varchar2(30),     /* maximum active sessions target resource */
                                  /* allocation method for the plan          */
  pdl_method    varchar2(30),              /* parallel degree limit resource */
                                           /* allocation method for the plan */
  num_plan_directives   number,    /* Number of plan directives for the plan */
  description   varchar2(2000),                  /* Text comment on the plan */
  que_method    varchar2(30),                  /* queueing method for groups */
  status        varchar2(30),                           /* PENDING or ACTIVE */
  mandatory     number                      /* Whether the plan is mandatory */
)
/
grant execute on ku$_rmgr_plan_t to public
/
create or replace force view ku$_rmgr_plan_view of ku$_rmgr_plan_t
  with object identifier(obj_num) as
  select '1','0',
        r.obj#,
        (select value(o) from  sys.ku$_schemaobj_view o where 
             o.obj_num=r.obj#),
        r.mgmt_method, r.mast_method,
        r.pdl_method, r.num_plan_directives,
        r.description,  r.que_method,
        r.status, r.mandatory
  from resource_plan$ r
/
grant select on ku$_rmgr_plan_view to select_catalog_role
/
--
-------------------------------------------------------------------------------
--                      RMGR_PLAN_DIRECTIVE
-------------------------------------------------------------------------------
-- 
create or replace type ku$_rmgr_plan_direct_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         
  base_obj      ku$_schemaobj_t,
  group_or_subplan  varchar2(30),    /* Name of the consumer group or sub-plan 
                                                                 referred to */
  type          number,                     /* 1: plan , 0: GROUP_OR_SUBPLAN */
  cpu_p1        number,           /* 1st parameter for CPU allocation method */
  cpu_p2        number,           /* 2nd parameter for CPU allocation method */
  cpu_p3        number,           /* 3rd parameter for CPU allocation method */
  cpu_p4        number,           /* 4th parameter for CPU allocation method */
  cpu_p5        number,           /* 5th parameter for CPU allocation method */
  cpu_p6        number,           /* 6th parameter for CPU allocation method */
  cpu_p7        number,           /* 7th parameter for CPU allocation method */
  cpu_p8        number,           /* 8th parameter for CPU allocation method */
  active_sess_pool_p1   number,       /* 1st parameter for max active sessions 
                                                    target allocation method */
  queueing_p1           number,     /* 1st parameter for the queueing method */
  parallel_degree_limit_p1 number,   /* 1st parameter for the parallel degree
                                            limit resource allocation method */
  switch_group          varchar2(30),   /* group to switch to once switch time 
                                                                  is reached */
  switch_time           number,       /* switch time limit for execution within
                                                                     a group */
  switch_estimate       number,   /* use execution estimate to determine 
                                                                      group? */
  max_est_exec_time     number,      /* use of max. estimated execution time */
  undo_pool             number,  /* max. undo allocation for consumer groups */
  comments              varchar(2000), /* Text comment on the plan directive */
  status                varchar2(30),                 /* PENDING  or ACTIVE  */
  mandatory             number                               /* 1 yes, 0 no  */
)
/
grant execute on ku$_rmgr_plan_direct_t to public
/
create or replace force view ku$_rmgr_plan_direct_view of ku$_rmgr_plan_direct_t
  with object identifier(obj_num) as
  select '1','0',
         r.obj#,
         (select value(o) from  sys.ku$_schemaobj_view o where 
             o.obj_num=r.obj#),
         r.group_or_subplan,
         r.is_subplan,
         decode(r.mgmt_p1,4294967295,0,r.mgmt_p1), 
         decode(r.mgmt_p2,4294967295,0,r.mgmt_p2), 
         decode(r.mgmt_p3,4294967295,0,r.mgmt_p3), 
         decode(r.mgmt_p4,4294967295,0,r.mgmt_p4),
         decode(r.mgmt_p5,4294967295,0,r.mgmt_p5), 
         decode(r.mgmt_p6,4294967295,0,r.mgmt_p6),
         decode(r.mgmt_p7,4294967295,0,r.mgmt_p7), 
         decode(r.mgmt_p8,4294967295,0,r.mgmt_p8),
         decode(r.active_sess_pool_p1,4294967295,0,r.active_sess_pool_p1),
         decode(r.queueing_p1,4294967295,0,r.queueing_p1),
         decode(r.parallel_degree_limit_p1,4294967295,0,
                r.parallel_degree_limit_p1),
         r.switch_group,
         decode(r.switch_time,4294967295,0,r.switch_time),
         decode(r.switch_estimate,4294967295,0,r.switch_estimate),
         decode(r.max_est_exec_time,4294967295,0,r.max_est_exec_time),
         decode(r.undo_pool,4294967295,0,r.undo_pool),
         r.description, r.status, r.mandatory 
  from resource_plan_directive$ r
/
grant select on ku$_rmgr_plan_direct_view to select_catalog_role
/
--
-------------------------------------------------------------------------------
--                      RMGR_CONSUMER_GROUP
-------------------------------------------------------------------------------
-- 
create or replace type ku$_rmgr_consumer_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                         
  schema_obj    ku$_schemaobj_t,
  cpu_method    varchar2(30),      /* CPU resource alloc method for the plan */
  description   varchar2(2000),        /* Text comment on the consumer group */
  status        varchar2(30),                           /* pending or active */
  mandatory     number                                      /* 1:yes , 0: no */
)
/
grant execute on ku$_rmgr_consumer_t to public
/
create or replace force view ku$_rmgr_consumer_view of ku$_rmgr_consumer_t
  with object identifier(obj_num) as
  select '1','0',
        r.obj#,
        (select value(o) from  sys.ku$_schemaobj_view o where 
                o.obj_num=r.obj#),
        r.mgmt_method, 
        r.description,
        r.status, r.mandatory
  from resource_consumer_group$ r
/
grant select on ku$_rmgr_consumer_view to select_catalog_role
/
--
-------------------------------------------------------------------------------
--                      RMGR_INITIAL_CONSUMER_GROUP
-------------------------------------------------------------------------------
-- 
create or replace type ku$_rmgr_init_consumer_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  user_num      number,                         
  grantee       varchar2(30),
  granted_group varchar2(30), /* consumer groups to which the user can switch */
  grant_option  number,                 /* mod(a.option$) =1 yes, others no */ 
                       /* whether the user can grant the privilege to others */
  defschclass   VARCHAR2(30)                                /* initial group */
)
/
grant execute on ku$_rmgr_init_consumer_t to public
/
create or replace force view ku$_rmgr_init_consumer_view of ku$_rmgr_init_consumer_t
  with object identifier(user_num) as
  select '1','0',
        ue.user#,
        ue.name, g.name, 
        a.option$,
        ue.defschclass
  from sys.user$ ue, sys.resource_consumer_group$ g, sys.objauth$ a
  where a.obj# = g.obj# and a.grantee# = ue.user#
/
grant select on ku$_rmgr_init_consumer_view to select_catalog_role
/
--
-------------------------------------------------------------------------------
--                      PASSWORD_HISTORY
-------------------------------------------------------------------------------
-- 
create or replace type ku$_psw_hist_item_t as object
(
  user_id       number,                    /* pws history user object number */
  uname         varchar2(30),                                   /* user name */
  password      varchar2(30),                                    /* password */
  password_date varchar2(19)                                   /* start date */
)
/
grant execute on ku$_psw_hist_item_t to public
/
create or replace type ku$_psw_hist_list_t as TABLE of ku$_psw_hist_item_t
/
create or replace force view ku$_psw_hist_list_view of ku$_psw_hist_item_t
  with object identifier(user_id) as
  select  h.user#,
          u.name,
          h.password,
          to_char(h.password_date,'YYYY/MM/DD HH24:MI:SS')
  from    sys.user_history$ h, sys.user$ u
  where   h.user# = u.user# 
/
grant select on ku$_psw_hist_list_view to EXP_FULL_DATABASE
/
grant execute on ku$_psw_hist_list_t to public
/
create or replace type ku$_psw_hist_t as object
(
  vers_major    char(1),                             /* UDT major version # */
  vers_minor    char(1),                             /* UDT minor version # */
  user_id       number,
  name          varchar2(30),
  hist_list     ku$_psw_hist_list_t                     /* password history */
)
/ 
grant execute on ku$_psw_hist_t to public
/
create or replace force view ku$_psw_hist_view of ku$_psw_hist_t
  with object identifier (user_id) as 
  select '1','0', u.user#, u.name,
         cast(multiset (select * from  ku$_psw_hist_list_view p 
                where p.user_id = u.user# ) as  ku$_psw_hist_list_t
         )
  from sys.user$ u
  where exists (select 1 from sys.user_history$ h where h.user# = u.user#)
/
grant select on ku$_psw_hist_view to EXP_FULL_DATABASE
/
--
-------------------------------------------------------------------------------
--                      PROC_SYSTEM_GRANT
-- (procedural system privilege grant)
-- corresponds to the grant_sysprivs_exp function of a package in exppkgobj$
-------------------------------------------------------------------------------
--
create or replace type ku$_objpkg_t as object
(
  package       varchar2(30),                     /* procedural package name */
  schema        varchar2(30)                               /* package schema */
)
/
grant execute on ku$_objpkg_t to public
/
create or replace force view ku$_objpkg_view of ku$_objpkg_t
  with object identifier(package) as
  select distinct p.package, p.schema
  FROM  sys.exppkgobj$ p
  WHERE (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 OR 
         SYS_CONTEXT('USERENV','SESSION_USER') = p.schema OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_objpkg_view to public 
/
create or replace type ku$_objpkg_privs_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  package       varchar2(30),                  /* procedural package objects */
  schema        varchar2(30),                              /* package schema */
  plsql         ku$_procobj_lines      /* PL/SQL code for proc sys privilege */
)
/
grant execute on ku$_objpkg_privs_t to public
/
create or replace force view ku$_proc_grant_view of ku$_objpkg_privs_t
  with object identifier(package) as
  select '1','0',
         p.package, p.schema, 
         sys.dbms_metadata.get_sysprivs 
                (p.package, p.schema,'GRANT_SYSPRIVS_EXP')
  from  sys.ku$_objpkg_view p
/
grant select on ku$_proc_grant_view to select_catalog_role 
/
--
-------------------------------------------------------------------------------
--                      PROC_AUDIT
-- (procedural system privilege audit) - corresponds to
-- the audit_sysprivs_exp function of a package in exppkgobj$
-------------------------------------------------------------------------------
--
create or replace force view ku$_proc_audit_view of ku$_objpkg_privs_t
  with object identifier(package) as
  select '1','0',
        p.package, p.schema, 
        sys.dbms_metadata.get_sysprivs
                ( p.package, p.schema,'AUDIT_SYSPRIVS_EXP')
  from  sys.ku$_objpkg_view p
/
grant select on ku$_proc_audit_view to select_catalog_role 
/
--
-------------------------------------------------------------------------------
--                      PROCOBJ
-- (system/schema procedural objects) - corresponds to the create_exp function
-- of a package in exppkgobj$ where the class is 1 (system) or 2 (schema)
-------------------------------------------------------------------------------
--
create or replace type ku$_procobj_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                              /* schema object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  class         number,                         /* 1:sys,2:schema,3:instance */
  prepost       number,                         /* 0:preaction, 1:postaction */
  type_num      number,                                           /* type id */
  level_num     number,                                             /* level */
  package       varchar2(30),                          /* procedural package */
  pkg_schema    varchar2(30),                              /* package schema */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procobj_t to public
/
create or replace force view ku$_procobj_view of ku$_procobj_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, 
         value(o),
         (select p.class from sys.exppkgobj$ p where p.type#=o.type_num
               and (p.class=1 or p.class=2)),
         (select p.prepost from sys.exppkgobj$ p where p.type#=o.type_num
               and (p.class=1 or p.class=2)),
         o.type_num,
         (select p.level# from sys.exppkgobj$ p where p.type#=o.type_num
               and (p.class=1 or p.class=2)),
         (select p.package from sys.exppkgobj$ p where p.type#=o.type_num
               and (p.class=1 or p.class=2)),
         (select p.schema from sys.exppkgobj$ p where p.type#=o.type_num
               and (p.class=1 or p.class=2)),
         (select sys.dbms_metadata.get_procobj
                ( p.package, p.schema,'CREATE_EXP', o.obj_num, 
                  (select 1 from dual 
                   where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                   OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
                from sys.exppkgobj$ p where p.type#=o.type_num
                   and (p.class=1 or p.class=2))
  from   sys.ku$_schemaobj_view o
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/ 
grant select on ku$_procobj_view to public
/ 

-- Used to fetch object numbers of procedural objects - used by heterogeneous
--  object types.  See comments on ku$_view_objnum_view, above.
--  Note that we do not exclude procedural objects in SYS.
--

create or replace force view ku$_procobj_objnum_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select value(o) from ku$_schemaobj_view o
  where o.type_num in (select p.type# from sys.exppkgobj$ p)
  and (o.owner_name NOT IN ('ORDSYS', 'MDSYS', 'CTXSYS', 'ORDPLUGINS',
                            'LBACSYS', 'XDB', 'SI_INFORMTN_SCHEMA',
                            'EXFSYS', 'DMSYS', 'DVSYS', 'DVF', 'DIP', 
                            'DBSNMP', 'WMSYS', 'ORACLE_OCM', 'ANONYMOUS', 
                            'XS$NULL', 'TSMSYS', 'APPQOSSYS','MGDSYS'))
  and bitand(o.flags,16)!=16          /* not secondary object */
 and    (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
        OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_procobj_objnum_view to public
/


--
-------------------------------------------------------------------------------
--                      PROCOBJ_GRANT
-- (grants on system/schema procedural objects) - corresponds to the
-- grant_exp function of a package in exppkgobj$ where the class is 1 (system)
-- or 2 (schema).
-------------------------------------------------------------------------------
--
create or replace type ku$_procobj_grant_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                              /* schema object number */
  base_obj      ku$_schemaobj_t,                            /* schema object */
  class         number,                         /* 1:sys,2:schema,3:instance */
  prepost       number,                         /* 0:preaction, 1:postaction */
  type_num      number,                                           /* type id */
  level_num     number,                                             /* level */
  package       varchar2(30),                          /* procedural package */
  pkg_schema    varchar2(30),                              /* package schema */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procobj_grant_t to public
/
create or replace force view ku$_procobj_grant_view of ku$_procobj_grant_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj#,
         (select value(o1) from sys.ku$_schemaobj_view o1
          where o1.obj_num=o.obj#),
         (select p.class from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select p.prepost from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         o.type#,
         (select p.level# from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select p.package from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select p.schema from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select sys.dbms_metadata.get_procobj_grant
                ( p.package, p.schema,'GRANT_EXP', o.obj#, 
                  (select 1 from dual 
                   where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                   OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
                from sys.exppkgobj$ p where p.type#=o.type#
                   and (p.class=1 or p.class=2))
  from   obj$ o
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/ 
grant select on ku$_procobj_grant_view to public
/ 
--
-------------------------------------------------------------------------------
--                      PROCOBJ_AUDIT
-- (audits on system/schema procedural objects) - corresponds to the
-- audit_exp function of a package in exppkgobj$ where the class is 1 (system)
-- or 2 (schema).
-------------------------------------------------------------------------------
--
create or replace type ku$_procobj_audit_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                              /* schema object number */
  base_obj      ku$_schemaobj_t,                            /* schema object */
  class         number,                      /* 1: sys, 2:schema, 3:instance */
  prepost       number,                          /* 0:praction, 1:postaction */
  type_num      number,                                           /* type id */
  level_num     number,                                             /* level */
  package       varchar2(30),                          /* procedural package */
  pkg_schema    varchar2(30),                              /* package schema */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procobj_audit_t to public
/
create or replace force view ku$_procobj_audit_view of ku$_procobj_audit_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj#,
         (select value(o1) from sys.ku$_schemaobj_view o1
          where o1.obj_num=o.obj#),
         (select p.class from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select p.prepost from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         o.type#,
         (select p.level# from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select p.package from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select p.schema from sys.exppkgobj$ p where p.type#=o.type#
               and (p.class=1 or p.class=2)),
         (select sys.dbms_metadata.get_procobj
                (p.package, p.schema,'AUDIT_EXP', o.obj#, 
                  (select 1 from dual 
                   where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                   OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
                from sys.exppkgobj$ p where p.type#=o.type#
                   and (p.class=1 or p.class=2))
  from   obj$ o
  where  (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner#, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
/ 
grant select on ku$_procobj_audit_view to public 
/ 
--
-------------------------------------------------------------------------------
--                      PROCDEPOBJ
-- (instance procedural objects) - corresponds to the create_exp function
-- of a package in exppkgobj$ where the class is 3 (instance)
-- and where there is a corresponding row in expdepobj$.
-------------------------------------------------------------------------------
--
create or replace type ku$_procdepobj_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  schema_obj    ku$_schemaobj_t,                            /* schema object */
  class         number,                                             /* class */
  prepost       number,                         /* 0:preaction, 1:postaction */
  type_num      number,                                              /* type */
  level_num     number,                                             /* level */
  package       varchar2(30),                                     /* package */
  pkg_schema    varchar2(30),                              /* package schema */
  base_obj_num  number,                                /* base object number */
  base_obj      ku$_schemaobj_t,                          /* base schema obj */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procdepobj_t to public
/
create or replace force view ku$_procdepobj_view of ku$_procdepobj_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, 
         value(o),
         p.class, p.prepost, p.type#, p.level#, p.package, p.schema, 
         oo.obj_num, 
         value(oo),
         sys.dbms_metadata.get_procobj
                ( p.package, p.schema,'CREATE_EXP', o.obj_num,
                  (select 1 from dual 
                   where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                   OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
  from   sys.ku$_schemaobj_view o, sys.ku$_schemaobj_view oo, 
         sys.exppkgobj$ p, sys.expdepobj$ d
  where  p.class = 3 and p.type# = o.type_num and
                d.d_obj# = o.obj_num AND
                d.p_obj# = oo.obj_num 
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
  order  by p.level#, p.type#
/
grant select on ku$_procdepobj_view to public
/
--
-------------------------------------------------------------------------------
--                      PROCDEPOBJ_GRANT
-- (grants on instance procedural objects) - corresponds to the
-- grant_exp function of a package in exppkgobj$ where the class is 3 (instance)
-- and where there is a corresponding row in expdepobj$.
-------------------------------------------------------------------------------
--
create or replace type ku$_procdepobjg_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  base_obj      ku$_schemaobj_t,                            /* base object */
  class         number,                                             /* class */
  prepost       number,                         /* 0:preaction, 1:postaction */
  type_num      number,                                              /* type */
  level_num     number,                                             /* level */
  package       varchar2(30),                                     /* package */
  pkg_schema    varchar2(30),                              /* package schema */
  anc_obj       ku$_schemaobj_t,                      /* ancestor schema obj */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procdepobjg_t to public
/
create or replace force view ku$_procdepobj_grant_view of ku$_procdepobjg_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, 
         value(o),
         p.class, p.prepost, p.type#, p.level#, p.package, p.schema, 
         value(oo),
         sys.dbms_metadata.get_procobj_grant
               ( p.package, p.schema,'GRANT_EXP', o.obj_num,
                (select 1 from dual 
                 where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
  from   sys.ku$_schemaobj_view o, sys.ku$_schemaobj_view oo, 
         sys.exppkgobj$ p, sys.expdepobj$ d
  where  p.class = 3 and p.type# = o.type_num and
                d.d_obj# = o.obj_num AND
                d.p_obj# = oo.obj_num 
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
  order  by p.level#, p.type#
/
grant select on ku$_procdepobj_grant_view to public
/
--
-------------------------------------------------------------------------------
--                      PROCDEPOBJ_AUDIT
-- (audits on instance procedural objects) - corresponds to the
-- audit_exp function of a package in exppkgobj$ where the class is 3 (instance)
-- and where there is a corresponding row in expdepobj$.
-------------------------------------------------------------------------------
--
create or replace type ku$_procdepobja_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  base_obj      ku$_schemaobj_t,                            /* base object */
  class         number,                                             /* class */
  prepost       number,                         /* 0:preaction, 1:postaction */
  type_num      number,                                              /* type */
  level_num     number,                                             /* level */
  package       varchar2(30),                                     /* package */
  pkg_schema    varchar2(30),                              /* package schema */
  anc_obj       ku$_schemaobj_t,                      /* ancestor schema obj */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procdepobja_t to public
/
create or replace force view ku$_procdepobj_audit_view of ku$_procdepobja_t
  with object identifier(obj_num) as
  select '1','0',
         o.obj_num, 
         value(o),
         p.class, p.prepost, p.type#, p.level#, p.package, p.schema, 
         value(oo),
         sys.dbms_metadata.get_procobj
          ( p.package, p.schema,'AUDIT_EXP', o.obj_num,
            (select 1 from dual 
                where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
  from   sys.ku$_schemaobj_view o, sys.ku$_schemaobj_view oo, 
         sys.exppkgobj$ p, sys.expdepobj$ d
  where  p.class = 3 and p.type# = o.type_num and
                d.d_obj# = o.obj_num AND
                d.p_obj# = oo.obj_num 
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0) OR 
              EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))
  order by p.level#, p.type#
/
grant select on ku$_procdepobj_audit_view to public
/
--
-------------------------------------------------------------------------------
--                      PROCACT_SYSTEM
-- (system procedural actions) - corresponds to the system_info_exp function
-- of a package in exppkgact$ where the class is 1 (system).
------------------------------------------------------------------------------
--
-- Create a dummy view with two rows: 0 and 1
create or replace view ku$_prepost_view(prepost) as
 select 0 from dual
 union
 select 1 from dual
/
grant select on ku$_prepost_view to select_catalog_role
/

create or replace type ku$_procobjact_t as object
(
  package       varchar2(30),                     /* procedural package name */
  schema       varchar2(30)                               /* package schema */
)
/
grant execute on ku$_procobjact_t to public
/
create or replace force view ku$_procobjact_view of ku$_procobjact_t
  with object identifier(package) as
  select distinct p.package, p.schema
  FROM  sys.exppkgact$ p
  WHERE (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0 OR 
         SYS_CONTEXT('USERENV','SESSION_USER') = p.schema OR 
                EXISTS ( SELECT * FROM sys.session_roles 
                        WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_procobjact_view to public
/
create or replace type ku$_procact_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  package       varchar2(30),                          /* procedural package */
  schema       varchar2(30),                              /* package schema */
  level_num     number,                                             /* level */
  class         number,                                             /* class */
  prepost       number,                         /* 0:preaction, 1:postaction */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procact_t to public
/
create or replace force view ku$_procact_sys_view of ku$_procact_t
  with object identifier(schema,package) as
  select '1','0',
  p.package, p.schema,
  p.level#, p.class, pr.prepost,
  case
   when p.class=1 then sys.dbms_metadata.get_action_sys
        ( p.package, p.schema,'SYSTEM_INFO_EXP', pr.prepost)
   else null
  end
  FROM  sys.exppkgact$ p , ku$_prepost_view pr
  where p.class =1 
  order by p.level#
/
grant select on ku$_procact_sys_view to select_catalog_role
/
--
------------------------------------------------------------------------------
---                     PROCACT_SCHEMA
-- (schema procedural actions) - corresponds to the schema_info_exp function
-- of a package in exppkgact$ where the class is 2 (schema)
-------------------------------------------------------------------------------
--
create or replace type ku$_procact_schema_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  user_name     varchar2(30),                                   /* user name */
  package       varchar2(30),                          /* procedural package */
  schema        varchar2(30),                            /* procedual schema */
  level_num     number,                                             /* level */
  class         number,                                             /* class */
  prepost       number,                         /* 0:preaction, 1:postaction */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procact_schema_t to public
/
create or replace force view ku$_procact_schema_view of ku$_procact_schema_t
  with object identifier(user_name) as
  select '1','0',
  u.name,
  p.package, p.schema,
  p.level#, p.class, pr.prepost,
  case
   when p.class=2 then
    sys.dbms_metadata.get_action_schema
        ( p.package, p.schema,'SCHEMA_INFO_EXP',u.name, pr.prepost,
        (select 1 from dual where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
   else null
  end
  FROM   sys.user$ u, sys.exppkgact$ p, ku$_prepost_view pr
  where p.class=2  and u.type# = 1
  and p.package !='DBMS_RULE_EXP_RULES' -- current is a problem, need to remove
                                        -- once the problem is fixed
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0)  OR 
              EXISTS ( SELECT * FROM sys.session_roles  
                       WHERE role='SELECT_CATALOG_ROLE' ))
  order by p.level#
/
grant select on ku$_procact_schema_view to public 
/
--
-------------------------------------------------------------------------------
--                      PROCACT_INSTANCE
-- (instance procedural actions) - corresponds to the instance_info_exp function
-- of a package in exppkgact$ where the class is 3 (instance) and where there is
-- a corresponding row in expdepact$.  
-------------------------------------------------------------------------------
--
create or replace type ku$_procact_instance_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,                                     /* object number */
  base_obj      ku$_schemaobj_t,                            /* schema object */
  level_num     number,                                             /* level */
  package       varchar2(30),                          /* procedural package */
  pkg_schema    varchar2(30),                              /* package schema */
  class         number,                                             /* class */
  prepost       number,                        /* 0: preaction, 1:postaction */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_procact_instance_t to public
/
create or replace force view ku$_procact_instance_view
  of ku$_procact_instance_t
  with object identifier(obj_num) as
  select '1','0',
     d.obj#,
     value(o),
     p.level#, p.package, p.schema, p.class, pr.prepost,
     case 
       when p.class =3
       then
       sys.dbms_metadata.get_action_instance
            (p.package, p.schema, 'INSTANCE_INFO_EXP', 
             o.name, o.owner_name, 0, 0, pr.prepost,
             (select 1 from dual 
                where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                       WHERE role='SELECT_CATALOG_ROLE' ))))
       when p.class =4
       then
         sys.dbms_metadata.get_action_instance
            (p.package, p.schema, 'INSTANCE_EXTENDED_INFO_EXP',
             o.name, o.owner_name, o.namespace, o.type_num, pr.prepost,
             (select 1 from dual 
                where  (SYS_CONTEXT('USERENV','CURRENT_USERID') = 0
                OR EXISTS ( SELECT * FROM sys.session_roles 
                      WHERE role='SELECT_CATALOG_ROLE' ))))
       else null
       end
   FROM  sys.ku$_schemaobj_view o,
         sys.exppkgact$ p,
         sys.expdepact$ d,
         ku$_prepost_view pr
   WHERE d.obj# = o.obj_num AND d.package = p.package 
         and d.schema = p.schema and ((p.class = 3) OR (p.class = 4))
         and p.package !='DBMS_RULE_EXP_RULES'
         and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
   ORDER   by p.level# 
/
grant select on ku$_procact_instance_view to public
/
--
-------------------------------------------------------------------------------
--                      PRE_TABLE_ACTION
-------------------------------------------------------------------------------
--
create or replace view ku$_expact_view (owner, name, prepost)
as select distinct owner,name,code from expact$
/
grant select on ku$_expact_view to select_catalog_role
/
create or replace type ku$_prepost_table_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  obj_num       number,
  base_obj      ku$_schemaobj_t,
  action_str    sys.ku$_taction_list_t
)
/
grant execute on ku$_prepost_table_t to public
/
create or replace force view ku$_pre_table_view of ku$_prepost_table_t
  with object identifier(obj_num) as
  select '1','0',
          o.obj_num,
          value(o),
          sys.dbms_metadata.get_prepost_table_act
                (e.prepost, o.owner_name, o.name)
  from  sys.ku$_schemaobj_view o,
        sys.tab$ t,
        ku$_expact_view e
  where o.obj_num = t.obj#
    and e.prepost=1
    and e.owner=o.owner_name and e.name=o.name
/
grant select on ku$_pre_table_view to public
/
--
-------------------------------------------------------------------------------
--                      POST_TABLE_ACTION
-------------------------------------------------------------------------------
--
create or replace force view ku$_post_table_view of ku$_prepost_table_t
  with object identifier(obj_num) as
  select '1','0',
          o.obj_num,
          value(o),
          sys.dbms_metadata.get_prepost_table_act
                (e.prepost, o.owner_name, o.name)
  from  sys.ku$_schemaobj_view o,
        sys.tab$ t,
        ku$_expact_view e
  where o.obj_num = t.obj#
    and e.prepost=2
    and e.owner=o.owner_name and e.name=o.name
/
grant select on ku$_post_table_view to public
/
--

-------------------------------------------------------------------------------
--                      (SYSTEM, SCHEMA, INSTANCE) CALLOUT
--                      TRANSPORTABLE CALLS TO DBMS_PLUGTS
------------------------------------------------------------------------------

-- views use a common UDT

create or replace type ku$_callout_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  user_name     varchar2(30),                                   /* user name */
  obj_num       number,                                     /* object number */
  base_obj      ku$_schemaobj_t,                            /* schema object */
  package       varchar2(30),                          /* procedural package */
  pkg_schema    varchar2(30),                              /* package schema */
  level_num     number,                                             /* level */
  class         number,                                             /* class */
  prepost       number,                         /* 0:preaction, 1:postaction */
  -- for dbms_plugts
  ts_name       varchar2(30),                             /* tablespace name */
  incl_const    number,
  incl_trig     number,
  incl_grant    number,
  tts_full_chk  number,
  tts_closure_chk number
)
/
grant execute on ku$_callout_t to public
/

-- system_callout view

create or replace force view ku$_syscallout_view of ku$_callout_t
  with object identifier(pkg_schema,package) as
  select '1','0',
  null, null, null,
  p.package, p.schema,
  p.level#, p.class, pr.prepost,
  null, null, null, null, null, null
  FROM  sys.exppkgact$ p , ku$_prepost_view pr
  where p.class =5 
  order by p.level#
/
grant select on ku$_syscallout_view to select_catalog_role
/

-- schema_callout view

create or replace force view ku$_schema_callout_view of ku$_callout_t
  with object identifier(user_name) as
  select '1','0',
  u.name, null, null,
  p.package, p.schema,
  p.level#, p.class, pr.prepost,
  null, null, null, null, null, null
  FROM   sys.user$ u, sys.exppkgact$ p, ku$_prepost_view pr
  where p.class=6 and u.type# = 1
         AND (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (u.user#, 0)  OR 
              EXISTS ( SELECT * FROM sys.session_roles  
                       WHERE role='SELECT_CATALOG_ROLE' ))
  order by p.level#
/
grant select on ku$_schema_callout_view to public
/

-- instance_callout view

create or replace force view ku$_instance_callout_view of ku$_callout_t
  with object identifier(obj_num) as
  select '1','0',
     null, d.obj#,
     value(o), 
     p.package, p.schema, p.level#, p.class, pr.prepost,
     null, null, null, null, null, null
   FROM  sys.ku$_schemaobj_view o,
         sys.exppkgact$ p,
         sys.expdepact$ d,
         ku$_prepost_view pr
   WHERE d.obj# = o.obj_num AND d.package = p.package 
         and d.schema = p.schema and p.class = 7
         and (SYS_CONTEXT('USERENV','CURRENT_USERID') IN (o.owner_num, 0)  
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
   ORDER   by p.level# 
/
grant select on ku$_instance_callout_view to public
/

--
-- Views for partition transportable.  They are used to get the
-- tablespace set to cover a specified set of table partitions or table
-- subpartitions.
--
-- partition transportable - tables
--
--    non-partitioned tables
create or replace view ku$_tts_tabview (
        obj_num, partobj, ts_name ) AS
    SELECT t.obj#, value(o), ts.name
    FROM  sys.ku$_schemaobj_view o, sys.tab$ t, sys.ts$ ts  
    WHERE  (BITAND (t.property,32)!=32) and
           o.obj_num = t.obj# and
           t.ts# = ts.ts#
  UNION ALL
    SELECT t.obj#, value(o), ts.name
    FROM  sys.ku$_schemaobj_view o, sys.tab$ t, 
          sys.lobfrag$ lf, sys.ts$ ts  
    WHERE  (BITAND (t.property,32)!=32) and
           o.obj_num = t.obj# and
           lf.tabfragobj# = t.obj# and
           lf.ts# = ts.ts#;

grant select on ku$_tts_tabview to select_catalog_role
/
--    simple partitioned tables
create or replace view ku$_tts_tabpartview (
        obj_num, partobj, ts_name ) AS
    SELECT tp.bo#, value(po), ts.name
    FROM  sys.ku$_schemaobj_view po, sys.tabpart$ tp, sys.ts$ ts  
    WHERE  po.obj_num = tp.obj# and
           tp.ts# = ts.ts#;

grant select on ku$_tts_tabpartview to select_catalog_role
/
--    composite partitioned tables
create or replace view ku$_tts_tabsubpartview (
        obj_num, partobj, ts_name ) AS
    SELECT tp.bo#, value(po), ts.name
    FROM  sys.ku$_schemaobj_view po, sys.tabcompart$ tp, 
          sys.tabsubpart$ tsp, sys.ts$ ts  
    WHERE  po.obj_num = tsp.obj# and
           tp.obj# = tsp.pobj# and
           tsp.ts# = ts.ts#;
grant select on ku$_tts_tabsubpartview to select_catalog_role
/
--    lobs for simple partitioned tables
create or replace view ku$_tts_partlobview (
        obj_num, partobj, ts_name ) AS
    SELECT tp.bo#,value(po), ts.name
    FROM  sys.ku$_schemaobj_view po, sys.tabpart$ tp, 
          sys.lobfrag$ lf, sys.ts$ ts  
    WHERE  po.obj_num = tp.obj# and
           lf.tabfragobj# = tp.obj# and
           lf.ts# = ts.ts#;

grant select on ku$_tts_partlobview to select_catalog_role
/
--    lobs for composite partitioned tables
create or replace view ku$_tts_subpartlobview (
        obj_num, partobj, ts_name ) AS
    SELECT tp.bo#, value(po), ts.name
    FROM  sys.ku$_schemaobj_view po, sys.tabcompart$ tp, 
          sys.tabsubpart$ tsp, sys.lobfrag$ lf, sys.ts$ ts  
    WHERE  po.obj_num = tsp.obj# and
           tp.obj# = tsp.pobj# and
           lf.tabfragobj# = tsp.obj# and
           lf.ts# = ts.ts#; 

grant select on ku$_tts_subpartlobview to select_catalog_role
/

--
-- The partition and subpartition table views and lob views both return the
-- same columns.  Combine them here into one view.
-- 
create or replace view ku$_tts_tab_tablespace_view (
        obj_num, partobj, ts_name ) AS
    SELECT * FROM ku$_tts_tabview
  UNION ALL
    SELECT * FROM ku$_tts_tabpartview
  UNION ALL
    SELECT * FROM ku$_tts_tabsubpartview
  UNION ALL
    SELECT * FROM ku$_tts_partlobview
  UNION ALL
    SELECT * FROM ku$_tts_subpartlobview;

grant select on ku$_tts_tab_tablespace_view to select_catalog_role
/
--
-- partition transportable - indexes
--
--    non-partitioned indexes
create or replace view ku$_tts_idxview (
        obj_num, partobj, ts_name ) AS
    SELECT i.bo#, NULL, ts.name
    FROM  sys.ind$ i, sys.ts$ ts  
    WHERE  (BITAND (i.property,2)!=2) and
           i.ts# = ts.ts#;
grant select on ku$_tts_idxview to select_catalog_role
/
-- simple partitioned indexes (not partition selected)
create or replace view ku$_tts_indpartview (
         obj_num, partobj, ts_name ) AS
    SELECT i.bo#, NULL, ts.name
    from  (     sys.indpart$ ip
     inner join sys.ind$     i  on i.obj#=ip.bo#
     inner join sys.ts$      ts on ip.ts#=ts.ts#);
grant select on ku$_tts_indpartview to select_catalog_role
/
-- simple partitioned indexes (partition selected)
create or replace view ku$_ttsp_indpartview (
         obj_num, partobj, ts_name, poflags ) AS
    SELECT i.bo#, value(tpo), ts.name, po.flags
    from  (     sys.ku$_schemaobj_view tpo
     inner join sys.tabpart$    tp  on tpo.obj_num = tp.obj# 
     inner join sys.ind$        i   on tp.bo#=i.bo# 
     inner join sys.partobj$    po  on po.obj# = i.obj# 
     inner join sys.indpart$    ip  on i.obj#=ip.bo# and  tp.part#=ip.part#
     inner join sys.ts$         ts  on ip.ts#=ts.ts#
  );
grant select on ku$_ttsp_indpartview to select_catalog_role
/
-- composite partitioned indexes (not partition selected)
create or replace view ku$_tts_indsubpartview (
         obj_num, partobj, ts_name ) AS
    SELECT i.bo#, NULL, ts.name
    from  (     sys.indsubpart$ isp
     inner join sys.indcompart$ ip  on isp.pobj# = ip.obj#
     inner join sys.ind$        i   on i.obj#=ip.bo#
     inner join sys.ts$         ts  on isp.ts#=ts.ts#
  );
grant select on ku$_tts_indsubpartview to select_catalog_role
/
-- composite partitioned indexes (partition selected)
create or replace view ku$_ttsp_indsubpartview (
         obj_num, partobj, ts_name, poflags ) AS
    SELECT i.bo#, value(tspo), ts.name, po.flags
    from  (
                sys.ku$_schemaobj_view tspo
     inner join sys.tabsubpart$ tsp  on tspo.obj_num = tsp.obj# 
     inner join sys.tabcompart$ tp  on tsp.pobj#=tp.obj#
     inner join sys.ind$        i   on tp.bo#=i.bo# 
     inner join sys.partobj$    po  on po.obj# = i.obj# 
     inner join sys.indcompart$ ip  on i.obj#=ip.bo# and  tp.part#=ip.part#
     inner join sys.indsubpart$ isp on isp.pobj# = ip.obj# and tsp.subpart#=isp.subpart# 
     inner join sys.ts$         ts  on isp.ts#=ts.ts#
  );
grant select on ku$_ttsp_indsubpartview to select_catalog_role
/

--
-- The partition and subpartition index views return the same columns.  Combine
-- them here into one view.
-- (not partition selected)
create or replace view ku$_tts_idx_tablespace_view (
         obj_num, partobj, ts_name ) AS
    SELECT * FROM ku$_tts_indpartview
  UNION ALL
    SELECT * FROM ku$_tts_indsubpartview;
grant select on ku$_tts_idx_tablespace_view to select_catalog_role
/
-- (partition selected)
create or replace view ku$_ttsp_idx_tablespace_view (
         obj_num, partobj, ts_name, poflags ) AS
    SELECT * FROM ku$_ttsp_indpartview
  UNION ALL
    SELECT * FROM ku$_ttsp_indsubpartview;
grant select on ku$_ttsp_idx_tablespace_view to select_catalog_role
/


-- PLUGTS_BEGIN
-- view for begin export
create or replace force view ku$_plugts_begin_view of ku$_callout_t
  with object identifier(pkg_schema,package) as
  select '1','0',
  null, null, null,
  'DBMS_PLUGTS','SYS',
  0,
  100,
  0,
  null, null, null, null, null, null
  FROM dual
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_begin_view to public
/

-- PLUGTS_TSNAME_TABLE
-- view for begin exp tablespace
 create or replace force view ku$_plugts_tsname_table_view of ku$_callout_t
  with object identifier(user_name) as
  select '1','0',
  null, tts.obj_num, tts.partobj,
  'DBMS_PLUGTS','SYS',
  0,
  101,
  0,
  tts.ts_name,
  null, null, null, null, null
  FROM sys.ku$_tts_tab_tablespace_view tts
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_tsname_table_view to public
/

-- PLUGTS_TSNAME_INDEX/PLUGTS_TSNAME_INDEXP
-- view for begin exp tablespace
--(not partition selected)
 create or replace force view ku$_plugts_tsname_index_view of ku$_callout_t
  with object identifier(user_name) as
  select '1','0',
  null, tts.obj_num, NULL,
  'DBMS_PLUGTS','SYS',
  0,
  101,
  0,
  tts.ts_name,
  null, null, null, null, null
  FROM sys.ku$_tts_idx_tablespace_view tts
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_tsname_index_view to public
/
--(partition selected)
-- partition selection only works on local indexes, so this view checks the 
-- partobj$.flags for local index.
 create or replace force view ku$_plugts_tsname_indexp_view of ku$_callout_t
  with object identifier(user_name) as
  select '1','0',
  null, tts.obj_num, tts.partobj,
  'DBMS_PLUGTS','SYS',
  0,
  101,
  0,
  tts.ts_name,
  null, null, null, null, null
  FROM sys.ku$_ttsp_idx_tablespace_view tts
  where bitand(tts.poflags,1)=1 and
        (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_tsname_indexp_view to public
/

-- PLUGTS_TSNAME
-- view for begin exp tablespace
create or replace force view ku$_plugts_tsname_view of ku$_callout_t
  with object identifier(user_name) as
  select '1','0',
  null, null, null,
  'DBMS_PLUGTS','SYS',
  0,
  101,
  0,
  ts.name,
  null, null, null, null, null
  FROM sys.ts$ ts
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_tsname_view to public
/

-- PLUGTS_CHECKPL
-- view for checkPluggable
create or replace force view ku$_plugts_checkpl_view of ku$_callout_t
  with object identifier(pkg_schema,package) as
  select '1','0',
  null, null, null,
  'DBMS_PLUGTS','SYS',
  0,
  102,
  0,
  null,
  p1.prepost,p2.prepost,p3.prepost,p4.prepost,p5.prepost
  from ku$_prepost_view p1, ku$_prepost_view p2, ku$_prepost_view p3,
       ku$_prepost_view p4, ku$_prepost_view p5
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_checkpl_view to public
/

-- PLUGTS_BLK

create or replace type ku$_plugts_blk_t as object
(
  vers_major    char(1),                              /* UDT major version # */
  vers_minor    char(1),                              /* UDT minor version # */
  prepost       number,                        /* 0: preaction, 1:postaction */
  plsql         ku$_procobj_lines      /* PL/SQL code for procedural objects */
)
/
grant execute on ku$_plugts_blk_t to public
/
create or replace force view ku$_plugts_blk_view of ku$_plugts_blk_t
 with object identifier(prepost) as
  select '1','0',
  pr.prepost,
  (select sys.dbms_metadata.get_plugts_blk(pr.prepost) from dual)
  from ku$_prepost_view pr
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_plugts_blk_view to public
/
create or replace force view ku$_end_plugts_blk_view of ku$_plugts_blk_t
 with object identifier(prepost) as
  select '1','0',
  1,
  (select sys.dbms_metadata.get_plugts_blk(1) from dual)
  from sys.dual
  where (SYS_CONTEXT('USERENV','CURRENT_USERID')=0
                 OR EXISTS ( SELECT * FROM sys.session_roles 
                    WHERE role='SELECT_CATALOG_ROLE' ))
/
grant select on ku$_end_plugts_blk_view to public
/


-- POPULATE THE DICTIONARY TABLES WITH THE ORACLE MODEL INFORMATION
-- The Metadata API is table-driven. The following inserts set up the ORACLE
-- object model of the dictionary. Other models (eg, CWM, ANSI, etc) can be
-- plugged in by emulating what we do here.
-- To support upgrade/downgrade all inserts must specify a column list.
-- First, clear out old stuff.
--
DELETE FROM sys.metaview$               WHERE model='ORACLE';
DELETE FROM sys.metafilter$             WHERE model='ORACLE';
DELETE FROM sys.metaxslparam$           WHERE model='ORACLE';
DELETE FROM sys.metaxsl$                WHERE model='ORACLE';
DELETE FROM sys.metastylesheet          WHERE model='ORACLE';
DELETE FROM sys.metascript$             WHERE model='ORACLE';
DELETE FROM sys.metascriptfilter$       WHERE model='ORACLE';
DELETE FROM sys.metanametrans$          WHERE model='ORACLE';
DELETE FROM sys.metapathmap$            WHERE model='ORACLE';

-- Populate metaview$: This table identifies which view (object or relational)
-- to generate a SELECT against for a given object type. Might be multiple rows
-- in this table per object type if the object type's space has been
-- partitioned into multiple views. We did this for tables for performance:
-- Simple, relational, non-partitioned tables are in a high performance object
-- view with a relatively simple UDT.

-- The metaview$.properties column has the following defined bit values:
-- 0x00000001 1         schema object
-- 0x00000002 2         heterogeneous object type
-- 0x00000004 4         internal object type
-- 0x00000008 8         soft connect (do ALTER SESSION SET CURRENT_SCHEMA
--                              before creating object)
-- 0x00000010 16        hard connect (connect to schema before creating object)
-- 0x00000020 32        callout type
-- 0x00000040 64        dbms_sql.execute needed after dbms_sql.parse
-- 0x00000080 128       Object can be loaded in parallel
-- 0x00000100 256       object number fetch, no xml returned
-- 0x00000200 512       object number, dependent obj# fetch, no xml returned
-- 0x00000400 1024      Don't use rule base optimizer
-- 0x00000800 2048      object number, object name fetch, no xml returned
--                   for objects requiring name for unique ID (e.g., RLS_POICY)
-- NOTE: The following table flags are internal to the mdAPI and do *not*
-- correspond to the 'property' bits in tab$.

rem  table flags:   1 = heap tables
rem                 2 = index-organized tables
rem                 4 = unused
rem                 8 = unused
rem                16 = non-partitioned tables
rem                32 = partitioned tables
rem                64 = unused
rem               128 = unused
rem               256 = relational tables
rem               512 = object tables
rem              1024 = unused
rem              2048 = unused
rem              4096 = tables with builtin, non-LOB datatypes
rem              8192 = tables with LOB columns
rem             16384 = tables with UDT columns
rem
rem  The next flags designate the particular view.  This allows a filter
rem  to explicitly specify a desired set of views.
rem
rem             65536 = HTABLE
rem            131072 = FHTABLE
rem            262144 = PHTABLE
rem            524288 = PFHTABLE
rem           1048576 = IOTABLE
rem           2097152 = PIOTABLE
rem           4194304 = CPFHTABLE

rem Like tables, materialized views and materialized view logs
rem have multiple UDTs and views. Each mv and mvl UDT contains
rem one of the table UDTs. Note that not all table types are represented.

rem ku$_*table_view used for version 10.2.0 and later
rem ku$_10_1_*table_view used for prior versions

rem heap, non-partitioned, relational, no LOB or UDT columns
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',1+16+64+256+4096+65536,1,'ORACLE',1002000000,'TABLE_T',
         'KU$_HTABLE_T','SYS','KU$_HTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',1+16+64+256+4096+65536,1,'ORACLE',0801000000,'TABLE_T',
         'KU$_HTABLE_T','SYS','KU$_10_1_HTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('MATERIALIZED_VIEW_LOG',1+16+256+4096+65536,0,'ORACLE',0801000000,
         'M_VIEW_LOG_T', 'KU$_M_VIEW_LOG_H_T','SYS','KU$_M_VIEW_LOG_H_VIEW');

rem heap, non-partitioned, relational or object, any datatype
rem FHTABLE_VIEW does NOT set the bit for builtin, non-LOB types so that it
rem will be mutually exclusive of view HTABLE_VIEW. In other words, we DON'T
rem want this view used for simple relational tables because it's slow.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
       ('TABLE',1+16+256+512+8192+16384+131072,1,'ORACLE',1100000000,'TABLE_T',
         'KU$_FHTABLE_T','SYS','KU$_FHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
       ('TABLE',1+16+256+512+8192+16384+131072,1,'ORACLE',1002000000,'TABLE_T',
         'KU$_FHTABLE_T','SYS','KU$_10_2_FHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
       ('TABLE',1+16+256+512+8192+16384+131072,1,'ORACLE',0801000000,'TABLE_T',
         'KU$_FHTABLE_T','SYS','KU$_10_1_FHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
     ('MATERIALIZED_VIEW',1+16+256+512+8192+16384+131072,16+1,'ORACLE',
       0801000000, 'M_VIEW_T','KU$_M_VIEW_FH_T','SYS','KU$_M_VIEW_FH_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
 ('MATERIALIZED_VIEW_LOG',1+16+256+512+8192+16384+131072,0,'ORACLE',0801000000,
         'M_VIEW_LOG_T','KU$_M_VIEW_LOG_FH_T','SYS','KU$_M_VIEW_LOG_FH_VIEW');

rem heap, partitioned, relational, no LOB or UDT columns
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',1+32+256+4096+262144,1,'ORACLE',1002000000,'TABLE_T',
         'KU$_PHTABLE_T','SYS','KU$_PHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',1+32+256+4096+262144,1,'ORACLE',0801000000,'TABLE_T',
         'KU$_PHTABLE_T','SYS','KU$_10_1_PHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('MATERIALIZED_VIEW_LOG',1+32+256+4096+262144,0,'ORACLE',0801000000,
         'M_VIEW_LOG_T', 'KU$_M_VIEW_LOG_PH_T','SYS','KU$_M_VIEW_LOG_PH_VIEW');

rem heap, partitioned, relational or object, any datatype
rem PFHTABLE_VIEW does NOT set the bit for builtin, non-LOB types so that it
rem will be mutually exclusive of view PHTABLE_VIEW. In other words, we DON'T
rem want this view used for simple, partitioned tables because it's slow.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
       ('TABLE',1+32+256+512+8192+16384+524288,1,'ORACLE',1002000000,'TABLE_T',
         'KU$_PFHTABLE_T','SYS','KU$_PFHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
       ('TABLE',1+32+256+512+8192+16384+524288,1,'ORACLE',0801000000,'TABLE_T',
         'KU$_PFHTABLE_T','SYS','KU$_10_1_PFHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
     ('MATERIALIZED_VIEW',1+32+256+512+8192+16384+524288,16+1,
         'ORACLE',0801000000,
         'M_VIEW_T', 'KU$_M_VIEW_PFH_T','SYS','KU$_M_VIEW_PFH_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('MATERIALIZED_VIEW_LOG',1+32+256+512+8192+16384+524288,0,
         'ORACLE',0801000000,
         'M_VIEW_LOG_T', 'KU$_M_VIEW_LOG_PFH_T','SYS',
         'KU$_M_VIEW_LOG_PFH_VIEW');

-- all child reference partionioned tables - includes both primitive
-- and full tables, as this view orders by level across those types.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
       ('TABLE',1+32+256+512+8192+16384+4194304,1,'ORACLE',1100000000,'TABLE_T',
         'KU$_CPFHTABLE_T','SYS','KU$_ACPTABLE_VIEW');

rem IOT, non-partitioned, relational, any datatype
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',2+16+256+512+4096+8192+16384+1048576,1,'ORACLE',
         1002000000,'TABLE_T',
         'KU$_IOTABLE_T','SYS','KU$_IOTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',2+16+256+512+4096+8192+16384+1048576,1,'ORACLE',
         0801000000,'TABLE_T',
         'KU$_IOTABLE_T','SYS','KU$_10_1_IOTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('MATERIALIZED_VIEW',2+16+256+512+4096+8192+16384+1048576,16+1,
         'ORACLE', 0801000000,'M_VIEW_T','KU$_M_VIEW_IOT_T','SYS',
          'KU$_M_VIEW_IOT_VIEW');

rem IOT, partitioned, relational, any datatype
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',2+32+256+512+4096+8192+16384+2097152,1,'ORACLE',
         1002000000,'TABLE_T',
         'KU$_PIOTABLE_T','SYS','KU$_PIOTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('TABLE',2+32+256+512+4096+8192+16384+2097152,1,'ORACLE',
         0801000000,'TABLE_T',
         'KU$_PIOTABLE_T','SYS','KU$_10_1_PIOTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values 
        ('MATERIALIZED_VIEW',2+32+256+512+4096+8192+16384+2097152,16+1,
         'ORACLE', 0801000000,'M_VIEW_T', 'KU$_M_VIEW_PIOT_T','SYS',
         'KU$_M_VIEW_PIOT_VIEW');


insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_OBJNUM',0,256,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_TABLE_OBJNUM_VIEW');

-- used to augment table object numbers with xdb storage tables.
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XDB_NTABLE_OBJNUM',0,256,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_XDB_NTABLE_OBJNUM_VIEW');

-- used set table attributes after data is loaded.
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('POST_DATA_TABLE',0,0,'ORACLE',1102000000,
  'POST_DATA_TABLE_T', 'KU$_POST_DATA_TABLE_T','SYS', 'KU$_POST_DATA_TABLE_VIEW');

-- mv_deptbl_objnum view is used to find materialized view temp log tables
--  which must be exported with mv logs in transportable mode.
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('MV_DEPTBL_OBJNUM',0,256,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_MV_DEPTBL_OBJNUM_T','SYS','KU$_MV_DEPTBL_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DEPTABLE_OBJNUM',0,256,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_DEPTABLE_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABTYPE_OBJNUM',0,256,'ORACLE',0801000000,
  'TABTYPEOBJNUM_T',NULL,'SYS','KU$_TTS_TYPES_VIEW');


rem
rem  type flags:  1 = type specification
rem               2 = type body
rem

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE',1,1,'ORACLE',0801000000,
  'TYPE_T','KU$_TYPE_T','SYS','KU$_TYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE',2,1,'ORACLE',0801000000,
  'TYPE_BODY_T','KU$_TYPE_BODY_T','SYS','KU$_TYPE_BODY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE',3,1,'ORACLE',0801000000,
  'FULL_TYPE_T','KU$_FULL_TYPE_T','SYS','KU$_FULL_TYPE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE_SPEC',0,1,'ORACLE',0801000000,
  'TYPE_T','KU$_TYPE_T','SYS','KU$_TYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE_BODY',0,1,'ORACLE',0801000000,
  'TYPE_BODY_T', 'KU$_EXP_TYPE_BODY_T','SYS','KU$_EXP_TYPE_BODY_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INC_TYPE',0,1,'ORACLE',0902000000,
  'INC_TYPE_T', 'KU$_SCHEMAOBJ_T','SYS','KU$_INC_TYPE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SORT_TYPES',0,512,'ORACLE',0902000000,
  'SORT_TYPES_T', NULL,'SYS','KU$_DEPTYPES_VIEW');


rem
rem  package flags:  1 = package specification
rem                  2 = package body
rem

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
               ('PACKAGE',1,1+8,'ORACLE',0801000000,'PACKAGE_T',
                      'KU$_PROC_T','SYS','KU$_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
               ('PACKAGE',2,1+8,'ORACLE',0801000000,'PACKAGE_BODY_T',
                      'KU$_PROC_T','SYS','KU$_PKGBDY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PACKAGE',3,1+8,'ORACLE',0801000000,
  'FULL_PACKAGE_T','KU$_FULL_PKG_T','SYS','KU$_FULL_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PACKAGE_SPEC',0,1+8,'ORACLE',0801000000,
  'PACKAGE_T','KU$_PROC_T','SYS','KU$_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PACKAGE_BODY',0,1+8+128,'ORACLE',0801000000,
  'PACKAGE_BODY_T','KU$_EXP_PKG_BODY_T','SYS','KU$_EXP_PKG_BODY_VIEW');


insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX',0,1024+64+16+1,'ORACLE',0801000000,'INDEX_T',
  'KU$_INDEX_T','SYS','KU$_10_2_INDEX_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX',0,1024+64+16+1,'ORACLE',1100000000,'INDEX_T',
  'KU$_INDEX_T','SYS','KU$_INDEX_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DOMIDX_OBJNUM',0,256,'ORACLE',0801000000,
  'DOMIDXOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_DOMIDX_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCEDURE',0,1+8,'ORACLE',0801000000,'PROCEDURE_T',
  'KU$_PROC_T','SYS','KU$_PROC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('FUNCTION',0,1+8,'ORACLE',0801000000,'FUNCTION_T',
  'KU$_PROC_T','SYS','KU$_FUNC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_PROCEDURE',0,1+8,'ORACLE',0902000000,'ALTER_PROCEDURE_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_PROC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_FUNCTION',0,1+8,'ORACLE',0902000000,'ALTER_FUNCTION_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_FUNC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_PACKAGE_SPEC',0,1+8,'ORACLE',0902000000,'ALTER_PACKAGE_SPEC_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_PKGSPC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_PACKAGE_BODY',0,1+8,'ORACLE',0902000000,'ALTER_PACKAGE_BODY_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_PKGBDY_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OPERATOR',0,1,'ORACLE',0801000000,'OPERATOR_T',
  'KU$_OPERATOR_T','SYS','KU$_OPERATOR_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEXTYPE',0,1,'ORACLE',0801000000,'INDEXTYPE_T',
  'KU$_INDEXTYPE_T','SYS','KU$_INDEXTYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OBJECT_GRANT',0,16,'ORACLE',1102000000,
  'OBJGRANT_T','KU$_OBJGRANT_T','SYS','KU$_OBJGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OBJECT_GRANT',0,16,'ORACLE',0801000000,
  'OBJGRANT_T','KU$_OBJGRANT_T','SYS','KU$_11_1_OBJGRANT_VIEW');

rem ku$_sysgrant_view used for version 10.2.0 and later
rem ku$_10_1_sysgrant_view used for prior versions

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_GRANT',0,16,'ORACLE',1002000000,
  'SYSGRANT_T','KU$_SYSGRANT_T','SYS','KU$_SYSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_GRANT',0,16,'ORACLE',0801000000,
  'SYSGRANT_T','KU$_SYSGRANT_T','SYS','KU$_10_1_SYSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRIGGER',0,1+8,'ORACLE',0801000000,'TRIGGER_T',
  'KU$_TRIGGER_T','SYS','KU$_10_2_TRIGGER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRIGGER',0,1+8,'ORACLE',1100000000,'TRIGGER_T',
  'KU$_TRIGGER_T','SYS','KU$_TRIGGER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('VIEW',0,1+8,'ORACLE',0801000000,'VIEW_T',
  'KU$_VIEW_T','SYS','KU$_VIEW_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('VIEW_OBJNUM',0,1+256,'ORACLE',0801000000,
  'VIEWOBJNUM_T','KU$_SCHEMAOBJ_T','SYS','KU$_VIEW_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SORT_VIEWS',0,512,'ORACLE',0902000000,
  'SORT_VIEWS_T', NULL,'SYS','KU$_DEPVIEWS_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OUTLINE',0,0,'ORACLE',0801000000,'OUTLINE_T',
  'KU$_OUTLINE_T','SYS','KU$_OUTLINE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYNONYM',0,1,'ORACLE',0801000000,'SYNONYM_T',
  'KU$_SYNONYM_T','SYS','KU$_SYNONYM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DIRECTORY',0,0,'ORACLE',0801000000,
  'DIRECTORY_T', 'KU$_DIRECTORY_T','SYS', 'KU$_DIRECTORY_VIEW');
rem
rem bug 6938028: Database Vault Protected Schema.
rem Insert the rows into metaview$ for the dummy Data Pump types.
rem
rem Note that these type registrations are for the dummy types 
rem (defined in the SYS schema), and not the real types (those are 
rem defined in the DVSYS schema). The dummy type names contain the string
rem "DUMMY_" instead of "DV_", to distinguish them from the real types.
rem
rem The use of the "version" attribute allows us to ensure that the rows 
rem in metaview$ for the new Database Vault object types always correspond 
rem to valid existing UDTs and views, whether or not Database Vault is 
rem installed.
rem
rem Here, the version is set to 0801000000 for the dummy types, which allows
rem them to be used as long as the real types do not exist.
rem
rem Once the real types are registered by $SRCHOME/rdbms/admin/catmacdd.sql
rem during the Database Vault installation (with a version of 1002000200), 
rem they will be used instead of the dummy types, even though the dummy 
rem type registration (with version 0801000000) remains present.
rem
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_REALM',0,0,'ORACLE',0801000000,
  'DVPS_REALM_T',
  'KU$_DUMMY_REALM_T','SYS','KU$_DUMMY_REALM_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_REALM_MEMBERSHIP',0,0,'ORACLE',0801000000,
  'DVPS_REALM_MEMBERSHIP_T',
  'KU$_DUMMY_REALM_MEMBER_T','SYS','KU$_DUMMY_REALM_MEMBER_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_REALM_AUTHORIZATION',0,0,'ORACLE',0801000000,
  'DVPS_REALM_AUTHORIZATION_T',
  'KU$_DUMMY_REALM_AUTH_T','SYS','KU$_DUMMY_REALM_AUTH_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_IMPORT_STAGING_REALM',0,0,'ORACLE',0801000000,
  'DVPS_IMPORT_STAGING_REALM_T',
  'KU$_DUMMY_ISR_T','SYS','KU$_DUMMY_ISR_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_STAGING_REALM_MEMBERSHIP',0,0,'ORACLE',0801000000,
  'DVPS_STAGING_REALM_MEMBERSHP_T',
  'KU$_DUMMY_ISRM_T','SYS','KU$_DUMMY_ISRM_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DROP_IMPORT_STAGING_REALM',0,0,'ORACLE',0801000000,
  'DVPS_DISR_T',
  'KU$_DUMMY_ISR_T','SYS','KU$_DUMMY_ISR_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_RULE',0,0,'ORACLE',0801000000,
  'DVPS_RULE_T',
  'KU$_DUMMY_RULE_T','SYS','KU$_DUMMY_RULE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_RULE_SET',0,0,'ORACLE',0801000000,
  'DVPS_RULE_SET_T',
  'KU$_DUMMY_RULE_SET_T','SYS','KU$_DUMMY_RULE_SET_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_RULE_SET_MEMBERSHIP',0,0,'ORACLE',0801000000,
  'DVPS_RULE_SET_MEMBERSHIP_T',
  'KU$_DUMMY_RULE_SET_MEMBER_T','SYS','KU$_DUMMY_RULE_SET_MEMBER_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_COMMAND_RULE',0,0,'ORACLE',0801000000,
  'DVPS_COMMAND_RULE_T',
  'KU$_DUMMY_COMMAND_RULE_T','SYS','KU$_DUMMY_COMMAND_RULE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_ROLE',0,0,'ORACLE',0801000000,
  'DVPS_ROLE_T',
  'KU$_DUMMY_ROLE_T','SYS','KU$_DUMMY_ROLE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_FACTOR',0,0,'ORACLE',0801000000,
  'DVPS_FACTOR_T',
  'KU$_DUMMY_FACTOR_T','SYS','KU$_DUMMY_FACTOR_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_FACTOR_LINK',0,0,'ORACLE',0801000000,
  'DVPS_FACTOR_LINK_T',
  'KU$_DUMMY_FACTOR_LINK_T','SYS','KU$_DUMMY_FACTOR_LINK_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_FACTOR_TYPE',0,0,'ORACLE',0801000000,
  'DVPS_FACTOR_TYPE_T',
  'KU$_DUMMY_FACTOR_TYPE_T','SYS','KU$_DUMMY_FACTOR_TYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_IDENTITY',0,0,'ORACLE',0801000000,
  'DVPS_IDENTITY_T',
  'KU$_DUMMY_IDENTITY_T','SYS','KU$_DUMMY_IDENTITY_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_IDENTITY_MAP',0,0,'ORACLE',0801000000,
  'DVPS_IDENTITY_MAP_T',
  'KU$_DUMMY_IDENTITY_MAP_T','SYS','KU$_DUMMY_IDENTITY_MAP_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLESPACE',0,0,'ORACLE',0801000000,
 'TABLESPACE_T', 'KU$_TABLESPACE_T','SYS', 'KU$_TABLESPACE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLLBACK_SEGMENT',0,0,'ORACLE',0801000000,
  'ROLLBACK_T', 'KU$_ROLLBACK_T', 'SYS', 'KU$_ROLLBACK_VIEW');

--
-- ku$_dblink_view used for version 10.2.0 and later
-- ku$_10_1_dblink_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DB_LINK',0,1+16,'ORACLE',1002000000, 'DBLINK_T',
  'KU$_DBLINK_T','SYS', 'KU$_DBLINK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DB_LINK',0,1+16,'ORACLE',0801000000, 'DBLINK_T',
  'KU$_DBLINK_T','SYS', 'KU$_10_1_DBLINK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRUSTED_DB_LINK',0,64,'ORACLE',0801000000,
  'TRLINK_T', 'KU$_TRLINK_T','SYS', 'KU$_TRLINK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('FGA_POLICY',0,64,'ORACLE',0801000000,
  'FGA_POLICY_T', 'KU$_FGA_POLICY_T','SYS', 'KU$_FGA_POLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_POLICY_OBJNUM',0,2048,'ORACLE',0801000000,
  'RLS_POLICY_OBJNUM_T', NULL,'SYS','KU$_RLS_POLICY_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_POLICY',0,64,'ORACLE',0801000000,
  'RLS_POLICY_T', 'KU$_RLS_POLICY_T','SYS', 'KU$_RLS_POLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_GROUP',0,64,'ORACLE',0801000000,
  'RLS_GROUP_T', 'KU$_RLS_GROUP_T','SYS', 'KU$_RLS_GROUP_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_CONTEXT',0,64,'ORACLE',0801000000,
  'RLS_CONTEXT_T', 'KU$_RLS_CONTEXT_T','SYS', 'KU$_RLS_CONTEXT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CONSTRAINT',0,1+1024,'ORACLE',0801000000,
  'CONSTRAINT_T', 'KU$_CONSTRAINT_T','SYS', 'KU$_CONSTRAINT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('REF_CONSTRAINT',0,1,'ORACLE',0801000000,
  'REF_CONSTRAINT_T', 'KU$_REF_CONSTRAINT_T','SYS', 'KU$_REF_CONSTRAINT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('LIBRARY',0,1,'ORACLE',0801000000,'LIBRARY_T',
  'KU$_LIBRARY_T','SYS','KU$_LIBRARY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROFILE',0,0,'ORACLE',0801000000,'PROFILE_T',
  'KU$_PROFILE_T','SYS','KU$_PROFILE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLE',0,0,'ORACLE',0801000000,'ROLE_T',
  'KU$_ROLE_T','SYS','KU$_ROLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('USER',0,16,'ORACLE',0801000000,'USER_T',
  'KU$_USER_T','SYS','KU$_USER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DEFAULT_ROLE',0,16,'ORACLE',0801000000,
  'DEFROLE_T','KU$_DEFROLE_T','SYS','KU$_DEFROLE_VIEW');

--
-- ku$_proxy_view used for version 10.2.0 and later
-- ku$_10_1_proxy_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROXY',0,0,'ORACLE',1002000000,
  'PROXY_T','KU$_PROXY_T','SYS','KU$_PROXY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROXY',0,0,'ORACLE',0801000000,
  'PROXY_T','KU$_PROXY_T','SYS','KU$_10_1_PROXY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLE_GRANT',0,16,'ORACLE',0801000000,
  'ROGRANT_T','KU$_ROGRANT_T','SYS','KU$_ROGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLESPACE_QUOTA',0,16,'ORACLE',0801000000,
  'TSQUOTA_T','KU$_TSQUOTA_T','SYS','KU$_TSQUOTA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RESOURCE_COST',0,64+16,'ORACLE',0801000000,
  'RESOCOST_T','KU$_RESOCOST_T','SYS','KU$_RESOCOST_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SEQUENCE',0,1,'ORACLE',0801000000,'SEQUENCE_T',
  'KU$_SEQUENCE_T','SYS','KU$_SEQUENCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CONTEXT',0,0,'ORACLE',0801000000,'CONTEXT_T',
  'KU$_CONTEXT_T','SYS','KU$_CONTEXT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DIMENSION',0,1,'ORACLE',0801000000,
  'DIMENSION_T','KU$_DIMENSION_T','SYS','KU$_DIMENSION_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ASSOCIATION',0,0,'ORACLE',0801000000,'ASSOC_T',
  'KU$_ASSOC_T','SYS','KU$_ASSOC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PASSWORD_VERIFY_FUNCTION',0, 16,'ORACLE', 0801000000,
  'PWDVFC_T','KU$_PROC_T','SYS','KU$_PWDVFC_VIEW');

--
-- ku$_comment_view used for version 10.2.0 and later
-- ku$_10_1_comment_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('COMMENT',0,0,'ORACLE',1002000000,
  'COMMENT_T','KU$_COMMENT_T','SYS','KU$_COMMENT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('COMMENT',0,0,'ORACLE',0801000000,
  'COMMENT_T','KU$_COMMENT_T','SYS','KU$_10_1_COMMENT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CLUSTER',0,1,'ORACLE',0801000000,
  'CLUSTER_T','KU$_CLUSTER_T','SYS','KU$_CLUSTER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT',0,0,'ORACLE',1002000000,
  'AUDIT_T','KU$_AUDIT_T','SYS','KU$_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT',0,0,'ORACLE',0801000000,
  'AUDIT_T','KU$_AUDIT_T','SYS','KU$_10_1_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT_OBJ',0,0,'ORACLE',0801000000,
  'AUDITOBJ_T','KU$_AUDIT_OBJ_T','SYS','KU$_AUDIT_OBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT_DEFAULT',0,0,'ORACLE',0801000000,
  'AUDITDEF_T','KU$_AUDIT_DEFAULT_T','SYS','KU$_AUDIT_DEFAULT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AQ_QUEUE_TABLE',0,64,'ORACLE',0801000000,
  'QUETAB_T','KU$_QUEUE_TABLE_T','SYS','KU$_QUEUE_TABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AQ_QUEUE',0,65,'ORACLE',0801000000,
  'QUEUES_T','KU$_QUEUES_T','SYS','KU$_QUEUES_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AQ_TRANSFORM',0,65,'ORACLE',0801000000,
  'QTRANS_T','KU$_QTRANS_T','SYS','KU$_QTRANS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JOB',0,65,'ORACLE',0801000000,
  'JOB_T','KU$_JOB_T','SYS','KU$_JOB_VIEW');

--
-- ku$_tab_stats_view for version 11.1.0.6 and later
-- ku$_ind_stats_view for version 11.1.0.7 and later
-- ku$_10_2_ind_stats_view for version 10.2 to 11.1.0.6
-- ku$_10_2_tab_stats_view for version 10.2.0 ONLY
-- ku$_10_1_tab_stats_view and ku$_10_1_ind_stats_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64,'ORACLE',1100000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64,'ORACLE',1002000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_10_2_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64,'ORACLE',0801000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_10_1_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('USER_PREF_STATISTICS',0,64,'ORACLE',1100000000,
  'T_USER_PREF_STAT_T', 'KU$_USER_PREF_STATS_T','SYS',
  'KU$_USER_PREF_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',1101000700,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_IND_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',1002000000,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_10_2_IND_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',0801000000,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_10_1_IND_STATS_VIEW');
--
-- Don't set the 'schema object' properties bit for TABLE_DATA;
-- it causes undesirable defaulting behavior.
--
-- ku$_table_data_view used for version 11.1.0 and later.
-- ku$_10_2_table_data_view used for version 10.2.0
-- ku$_10_1_table_data_view used for prior versions
--
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_DATA',0,0,'ORACLE',1100000000,
  'TABLE_DATA_T','KU$_TABLE_DATA_T','SYS','KU$_TABLE_DATA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_DATA',0,0,'ORACLE',1002000000,
  'TABLE_DATA_T','KU$_TABLE_DATA_T','SYS','KU$_10_2_TABLE_DATA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_DATA',0,0,'ORACLE',0801000000,
  'TABLE_DATA_T','KU$_TABLE_DATA_T','SYS','KU$_10_1_TABLE_DATA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_OBJNUM',0,1+256,'ORACLE',0801000000,
  'JAVAOBJNUM_T','KU$_SCHEMAOBJ_T','SYS','KU$_JAVA_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_SOURCE',0,1+8+64,'ORACLE',0801000000,
  'JAVASRC_T','KU$_JAVA_SOURCE_T','SYS','KU$_JAVA_SOURCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_RESOURCE',0,1+8+64,'ORACLE',0801000000,
  'JAVARESRC_T','KU$_JAVA_RESOURCE_T','SYS','KU$_JAVA_RESOURCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_CLASS',0,1+8+64,'ORACLE',0801000000,
  'JAVACLASS_T','KU$_JAVA_CLASS_T','SYS','KU$_JAVA_CLASS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_PLAN',0,65,'ORACLE',0801000000,
  'RMGR_PLAN_T','KU$_RMGR_PLAN_T','SYS','KU$_RMGR_PLAN_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_PLAN_DIRECTIVE',0,64,'ORACLE',0801000000,
  'RMGR_PLAN_DIRECT_T','KU$_RMGR_PLAN_DIRECT_T','SYS',
  'KU$_RMGR_PLAN_DIRECT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_CONSUMER_GROUP',0,65,'ORACLE',0801000000, 
  'RMGR_CONSUMER_T','KU$_RMGR_CONSUMER_T','SYS',
  'KU$_RMGR_CONSUMER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_INITIAL_CONSUMER_GROUP',0,64,'ORACLE', 0801000000,
  'RMGR_INIT_CONSUMER_T','KU$_RMGR_INIT_CONSUMER_T',
  'SYS','KU$_RMGR_INIT_CONSUMER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PASSWORD_HISTORY',0,64,'ORACLE',0801000000,
  'PSW_HIST_T','KU$_PSW_HIST_T','SYS','KU$_PSW_HIST_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('REFRESH_GROUP',0,65+16,'ORACLE',0801000000,
  'REFGROUP_T','KU$_REFGROUP_T','SYS','KU$_REFGROUP_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('MONITORING',0,0,'ORACLE',0801000000,
                'MONITOR_T','KU$_MONITOR_T','SYS','KU$_MONITOR_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROC_SYSTEM_GRANT',0,80,'ORACLE',0801000000,
  'PROCGRANT_T','KU$_PROC_GRANT_T','SYS','KU$_PROC_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROC_AUDIT',0,80,'ORACLE',0801000000,
  'PROCAUDIT_T','KU$_PROC_AUDIT_T','SYS','KU$_PROC_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ',0,81,'ORACLE',0801000000,
  'PROCOBJ_T','KU$_PROCOBJ_T','SYS','KU$_PROCOBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ_OBJNUM',0,1+16+256,'ORACLE',0801000000,
  'PROCOBJNUM_T','KU$_SCHEMAOBJ_T','SYS','KU$_PROCOBJ_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ_GRANT',0,80,'ORACLE',0801000000,'PROCOBJG_T',
  'KU$_PROCOBJ_GRANT_T','SYS','KU$_PROCOBJ_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ_AUDIT',0,80,'ORACLE',0801000000,'PROCOBJA_T',
  'KU$_PROCOBJ_AUDIT_T','SYS','KU$_PROCOBJ_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCDEPOBJ',0,81+1024,'ORACLE',0801000000,
  'PROCDEPOBJ_T', 'KU$_PROCDEPOBJ_T','SYS', 'KU$_PROCDEPOBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCDEPOBJ_GRANT',0,80,'ORACLE',0801000000,
  'PROCDEPOBJG_T', 'KU$_PROCDEPOBJG_T','SYS', 'KU$_PROCDEPOBJ_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCDEPOBJ_AUDIT',0,80,'ORACLE',0801000000,
  'PROCDEPOBJA_T', 'KU$_PROCDEPOBJA_T','SYS', 'KU$_PROCDEPOBJ_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_SYSTEM',0,80,'ORACLE',0801000000,
  'PROCACTSYS_T','KU$_PROCACT_T','SYS','KU$_PROCACT_SYS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_SCHEMA',0,81,'ORACLE',0801000000,
  'PROCACTSCHEMA_T','KU$_PROCACT_SCHEMA_T','SYS','KU$_PROCACT_SCHEMA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_INSTANCE',0,80,'ORACLE',0801000000,
  'PROCACTINS_T', 'KU$_PROCACT_INSTANCE_T','SYS', 'KU$_PROCACT_INSTANCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PRE_TABLE_ACTION',0,8+64,'ORACLE',0801000000,'PRE_TABLE_T',
  'KU$_PREPOST_TABLE_T','SYS','KU$_PRE_TABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('POST_TABLE_ACTION',0,8+64,'ORACLE',0801000000,'POST_TABLE_T',
  'KU$_PREPOST_TABLE_T','SYS','KU$_POST_TABLE_VIEW');
-- new in 9.2
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XMLSCHEMA',0,64+16,'ORACLE',0900000000,
  'XMLSCHEMA_T', 'KU$_XMLSCHEMA_T','SYS','KU$_XMLSCHEMA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('EXP_XMLSCHEMA',0,64+16,'ORACLE',0900000000,
  'XMLSCHEMA_T', 'KU$_XMLSCHEMA_T','SYS','KU$_EXP_XMLSCHEMA_VIEW');
--
-- ku$_strmtable_view used for version 11.1.0 and later.
-- ku$_10_2_strmtable_view used for prior versions.
--
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DPSTREAM_TABLE',0,1,'ORACLE',1100000000,
  'STRMTABLE_T','KU$_STRMTABLE_T','SYS','KU$_STRMTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DPSTREAM_TABLE',0,1,'ORACLE',0801000000,
  'STRMTABLE_T','KU$_10_2_STRMTABLE_T','SYS','KU$_10_2_STRMTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_CALLOUT',0,32,'ORACLE',0900000000,
  'SYSCALLOUT_T','KU$_CALLOUT_T','SYS','KU$_SYSCALLOUT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SCHEMA_CALLOUT',0,32,'ORACLE',0900000000,
  'SCHEMA_CALLOUT_T','KU$_CALLOUT_T','SYS','KU$_SCHEMA_CALLOUT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag, 
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_TABLE',0,32,'ORACLE',110000000,
  'PLUGTS_TSNAME_TABLE_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_TABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag, 
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_INDEX',0,32,'ORACLE',110000000,
  'PLUGTS_TSNAME_INDEX_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_INDEX_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag, 
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_INDEXP',0,32,'ORACLE',110000000,
  'PLUGTS_TSNAME_INDEX_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_INDEXP_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INSTANCE_CALLOUT',0,32,'ORACLE',0900000000,
  'INSTANCE_CALLOUT_T','KU$_CALLOUT_T','SYS','KU$_INSTANCE_CALLOUT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_BEGIN', 0,96,'ORACLE',0900000000,
  'PLUGTS_BEGIN_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_BEGIN_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME', 0,96,'ORACLE',0900000000,
  'PLUGTS_TSNAME_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_CHECKPL', 0,96,'ORACLE',0900000000,
  'PLUGTS_CHECKPL_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_CHECKPL_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_BLK', 0,64,'ORACLE',0900000000,
  'PLUGTS_BLK_T','KU$_PLUGTS_BLK_T','SYS','KU$_PLUGTS_BLK_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('END_PLUGTS_BLK', 0,64,'ORACLE',0900000000,
  'PLUGTS_BLK_T','KU$_PLUGTS_BLK_T','SYS','KU$_END_PLUGTS_BLK_VIEW');

-- Populate metafilter$: This table defines all the valid SELECT filters for
-- dictionary object types that can be set through the SET_FILTER interface.
-- Common filters used by many object types are NAME / SCHEMA. grants support
-- GRANTOR / GRANTEE. Tables support TABLESPACE, HEAP or IOT, RELATIONAL or
-- OBJECT, etc. Each one of these turns into a WHERE clause predicate on the
-- SELECT stmts built against the views in metaview$. The attrname field
-- specifies the UDT attribute or rel. column used in the where clause.
--
-- The 'properties' flags have the following meanings:
--
-- 0x00000001 1         boolean filter
-- 0x00000002 2         expression filter
-- 0x00000004 4         custom filter
-- 0x00000008 8         has default
-- 0x00000010 16        numeric filter
-- 0x00000020 32        filter leaf types (e.g., BEGIN_WITH)
-- 0x00000040 64        filter branch (e.g., INCLUDE_PATH_EXPR)
-- 0x00000080 128       ORDERED filter
-- 0x00000100 256       TOTAL_ORDER filter
-- 0x00000200 512       NOT NULL filter
-- 0x00000400 1024      ORDER_OBJNUMS filter
-- 0x00000800 2048      special boolean filter
-- 0x00001000 4096      bind variable filter (value bound at cursor OPEN)
-- 0x00002000 8192      ORDER_OBJNUMS_NOB (i.e., no ORDER BY) filter
-- 0x00004000 16384     OBJNUM plus name

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_FUNCTION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_PACKAGE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_PACKAGE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_PROCEDURE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AQ_QUEUE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AQ_QUEUE_TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AQ_TRANSFORM', 'ORACLE', 4096, 0, 'TRANSFORM_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'CLUSTER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'CONSTRAINT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'CONTEXT', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DB_LINK', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DIMENSION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DIRECTORY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem properties 4096 means a bind variable filter (value bound at cursor OPEN)
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_REALM', 'ORACLE', 4096, 0,
  'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_REALM_MEMBERSHIP', 'ORACLE', 4096, 0,
  'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_REALM_AUTHORIZATION', 'ORACLE', 4096, 0,
  'REALM_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_RULE', 'ORACLE', 4096, 0,
  'RULE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_RULE_SET', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_RULE_SET_MEMBERSHIP', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_COMMAND_RULE', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_ROLE', 'ORACLE', 4096, 0,
  'ROLE', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_FACTOR', 'ORACLE', 4096, 0,
  'FACTOR_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_FACTOR_LINK', 'ORACLE', 4096, 0,
  'PARENT_FACTOR_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_FACTOR_TYPE', 'ORACLE', 4096, 0,
  'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_IDENTITY', 'ORACLE', 4096, 0,
  'FACTOR_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_IDENTITY_MAP', 'ORACLE', 4096, 0,
  'IDENTITY_FACTOR_NAME', NULL);

rem     
rem bug 6938028: Database Vault Protected Schema.
rem These correspond to the following lines in prvtmetd.sql in "de_users":
rem   inh_noexp_filter(h2);
rem   inh_total_order_filter(h2);
rem Properties "2" means "expression filter".
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''DVPS_STAGING_REALM_MEMBERSHIP'' ' ||
 'AND A.NAME=KU$.SCHEMA_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_NAME', 0);



insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.NAME',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem The "NAME" filter for the DVPS_STAGING_REALM_MEMBERSHIP type, which means
rem "filter based on the SCHEMA_NAME attribute of the ku$_dv_srm_t UDT", is
rem needed because of the "inh_name_filters" added to "de_users" in 
rem prvtmetd.sql for exporting the DVPS_STAGING_REALM_MEMBERSHIP type along 
rem with the USER type when the DE_USER heterogeneous type is exported.
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 0, 0, 'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DPSTREAM_TABLE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'FUNCTION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INC_TYPE', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INDEX', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INDEXTYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_CLASS', 'ORACLE', 4096, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_RESOURCE', 'ORACLE', 4096, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_OBJNUM', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_SOURCE', 'ORACLE', 4096, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'LIBRARY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'MATERIALIZED_VIEW', 'ORACLE', 4096, 0, 'MVIEW.VNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 4096, 0, 'MVIEWLOG.LOG', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'OPERATOR', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'OUTLINE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCDEPOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCEDURE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCOBJ_OBJNUM', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROFILE', 'ORACLE', 4096, 0, 'PROFILE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'REFRESH_GROUP', 'ORACLE', 4096, 0, 'REFNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'REF_CONSTRAINT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'RMGR_CONSUMER_GROUP', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'RMGR_PLAN', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ROLE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ROLLBACK_SEGMENT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SEQUENCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SORT_TYPES', 'ORACLE', 0, 0, 'TYPENAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SORT_VIEWS', 'ORACLE', 0, 0, 'VIEWNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SYNONYM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLESPACE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLE_DATA', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLE_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TRIGGER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TRUSTED_DB_LINK', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TYPE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TYPE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'USER', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'VIEW', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'VIEW_OBJNUM', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XMLSCHEMA', 'ORACLE', 4096, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'EXP_XMLSCHEMA', 'ORACLE', 4096, 0, 'URL',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0, 'TRANSFORM_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'CLUSTER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'CONTEXT', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DB_LINK', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DIMENSION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DIRECTORY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem The "NAME_EXPR" filter for the DVPS_STAGING_REALM_MEMBERSHIP type, which 
rem means "filter based on the SCHEMA_NAME attribute of the ku$_dv_srm_t UDT", 
rem is needed because of the "inh_name_filters" added to "de_users" in 
rem prvtmetd.sql for exporting the DVPS_STAGING_REALM_MEMBERSHIP type along 
rem with the USER type when the DE_USER heterogeneous type is exported.
rem
rem The other "NAME_EXPR" filters are to allow only a specific named instance 
rem of a type to be exported, e.g. to export only the Identities whose Factor
rem Name is 'Application_Domain', the parameter to expdp would be escaped 
rem as follows:
rem   INCLUDE=DVPS_IDENTITY:\"= \(\'Application_Domain\'\)\" \
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
  'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_REALM', 'ORACLE', 2, 0,
  'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
  'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_REALM_AUTHORIZATION', 'ORACLE', 2, 0,
  'REALM_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_RULE', 'ORACLE', 2, 0,
  'RULE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_RULE_SET', 'ORACLE', 2, 0,
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_RULE_SET_MEMBERSHIP', 'ORACLE', 2, 0, 
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_COMMAND_RULE', 'ORACLE', 2, 0,
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_ROLE', 'ORACLE', 2, 0,
  'ROLE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_FACTOR', 'ORACLE', 2, 0,
  'FACTOR_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_FACTOR_LINK', 'ORACLE', 2, 0,
  'PARENT_FACTOR_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_FACTOR_TYPE', 'ORACLE', 2, 0,
  'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_IDENTITY', 'ORACLE', 2, 0,
  'FACTOR_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_IDENTITY_MAP', 'ORACLE', 2, 0,
  'IDENTITY_FACTOR_NAME',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'FUNCTION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INC_TYPE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INDEX', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'LIBRARY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0, 'MVIEW.VNAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 4096, 0, 'MVIEWLOG.LOG', 
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'OPERATOR', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'OUTLINE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCEDURE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROFILE', 'ORACLE', 2, 0, 'PROFILE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0, 'REFNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ROLE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ROLLBACK_SEGMENT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SEQUENCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0, 'TYPENAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0, 'VIEWNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLESPACE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TRUSTED_DB_LINK', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'USER', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'VIEW', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0, 'URL',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0,
 'NOT (KU$.TRANSFORM_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'CLUSTER', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'CONTEXT', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DB_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DIMENSION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DIRECTORY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem The "EXCLUDE_NAME_EXPR" filter for the DVPS_STAGING_REALM_MEMBERSHIP type
rem is needed because of the "inh_name_filters" added to "de_users" in 
rem prvtmetd.sql for exporting the DVPS_STAGING_REALM_MEMBERSHIP type along 
rem with the USER type when the DE_USER heterogeneous type is exported.
rem
rem The other "EXCLUDE_NAME_EXPR" filters are to allow a specific named 
rem instance of a type to be excluded from the export, e.g. to avoid exporting
rem Identities with the Factor Name 'Application_Domain', the parameter to 
rem expdp would be escaped as follows:
rem   EXCLUDE=DVPS_IDENTITY:\"= \(\'Application_Domain\'\)\" \
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_REALM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_REALM_AUTHORIZATION', 'ORACLE', 2, 0,
 'NOT (KU$.REALM_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_RULE', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_RULE_SET', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_SET_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_RULE_SET_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_SET_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_ROLE', 'ORACLE', 2, 0,
 'NOT (KU$.ROLE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_FACTOR', 'ORACLE', 2, 0,
 'NOT (KU$.FACTOR_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_FACTOR_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.PARENT_FACTOR_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_FACTOR_TYPE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_IDENTITY', 'ORACLE', 2, 0,
 'NOT (KU$.FACTOR_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_IDENTITY_MAP', 'ORACLE', 2, 0,
 'NOT (KU$.IDENTITY_FACTOR_NAME :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'FUNCTION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INC_TYPE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INDEX', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'LIBRARY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEW.VNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEWLOG.LOG :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'OPERATOR', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'OUTLINE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0, 
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCEDURE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCOBJ', 'ORACLE', 2, 0, 
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROFILE', 'ORACLE', 2, 0,
 'NOT (KU$.PROFILE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0, 
 'NOT (KU$.REFNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0, 
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0, 
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ROLE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ROLLBACK_SEGMENT', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SEQUENCE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0,
 'NOT (KU$.TYPENAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0,
 'NOT (KU$.VIEWNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLESPACE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TRUSTED_DB_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TYPE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'USER', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'VIEW', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT (KU$.URL :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT (KU$.URL :1)',NULL);


REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_FUNCTION', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_PACKAGE_BODY', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_PACKAGE_SPEC', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_PROCEDURE', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'AQ_QUEUE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'AQ_QUEUE_TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'AQ_TRANSFORM', 'ORACLE', 4096, 0, 'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'CLUSTER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'CONSTRAINT', 'ORACLE', 4096, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'DB_LINK', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'DIMENSION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'DPSTREAM_TABLE', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'FUNCTION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INC_TYPE', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INDEX', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INDEXTYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_CLASS', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_OBJNUM', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_RESOURCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_SOURCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JOB', 'ORACLE', 4096, 0, 'POWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'LIBRARY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'MATERIALIZED_VIEW', 'ORACLE', 4096, 0, 'MVIEW.SOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 4096, 0, 'MVIEWLOG.MOWNER', 
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'OPERATOR', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCACT_SCHEMA', 'ORACLE', 4096, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCDEPOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCEDURE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCOBJ_OBJNUM', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'REF_CONSTRAINT', 'ORACLE', 4096, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'REFRESH_GROUP', 'ORACLE', 4096, 0, 'REFOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'RMGR_CONSUMER_GROUP', 'ORACLE', 4096, 0,
        'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'RMGR_PLAN', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SCHEMA_CALLOUT', 'ORACLE', 0, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SEQUENCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SORT_TYPES', 'ORACLE', 0, 0, 'TYPEOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SORT_VIEWS', 'ORACLE', 0, 0, 'VIEWOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SYNONYM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TABLE_DATA', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TABLE_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TRIGGER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TYPE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TYPE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'VIEW', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'VIEW_OBJNUM', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'XMLSCHEMA', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'EXP_XMLSCHEMA', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'AQ_QUEUE_TABLE','ORACLE', 2, 0,'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0, 'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'CLUSTER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'DB_LINK', 'ORACLE', 2, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'DIMENSION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'FUNCTION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INC_TYPE', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INDEX', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JOB', 'ORACLE', 2, 0, 'POWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'LIBRARY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0, 'MVIEW.SOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0, 'MVIEWLOG.MOWNER', 
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'OPERATOR', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCACT_SCHEMA', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCEDURE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0, 'REFOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SEQUENCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0, 'TYPEOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0, 'VIEWOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SYNONYM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TRIGGER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'VIEW', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'CLUSTER', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'DB_LINK', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'DIMENSION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'FUNCTION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INC_TYPE', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INDEX', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JOB', 'ORACLE', 2, 0, 
  'NOT (KU$.POWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'LIBRARY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEW.SOWNER :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEWLOG.MOWNER :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'OPERATOR', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCACT_SCHEMA', 'ORACLE', 2, 0,
  'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCEDURE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0, 
  'NOT (KU$.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0, 
  'NOT (KU$.REFOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0, 
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0,
  'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SEQUENCE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0,
  'NOT (KU$.TYPEOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0,
  'NOT (KU$.VIEWOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SYNONYM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TYPE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'VIEW', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'PACKAGE', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'PACKAGE_SPEC', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'TYPE', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'TYPE_SPEC', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'PACKAGE', 'ORACLE', 1, 2, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'PACKAGE_BODY', 'ORACLE', 1, 2, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'TYPE', 'ORACLE', 1, 2, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'TYPE_BODY', 'ORACLE', 1, 2, NULL,NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'TABLE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'TABLE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'TABLE_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'PLUGTS_TSNAME', 'ORACLE', 0, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'PLUGTS_TSNAME', 'ORACLE', 2, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'CLUSTER', 'ORACLE', 0, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'CLUSTER', 'ORACLE', 2, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  'NOT (EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  'NOT (EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_CLUSTER_TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_CLU_TS_VIEW CTS ' ||
  'WHERE CTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND CTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_CLUSTER_TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_CLU_TS_VIEW CTS ' ||
  'WHERE CTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND CTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'MATERIALIZED_VIEW', 'ORACLE', 0, 0,
  '(KU$.MVIEW_TAB.OBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MV_TS_VIEW KU2$ WHERE KU2$.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
  '(KU$.MVIEW_TAB.OBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MV_TS_VIEW KU2$ WHERE KU2$.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  '(KU$.TABOBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MVL_TS_VIEW KU2$ ' ||
  ' WHERE KU2$.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  '(KU$.TABOBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MVL_TS_VIEW KU2$ ' ||
  'WHERE KU2$.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'TABLE_DATA', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE', 'TABLE_DATA', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'PROCACT_INSTANCE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'PROCDEPOBJ', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'POST_TABLE_ACTION', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'OBJECT_GRANT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'MONITORING', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'MONITORING', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_TAB_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_TAB_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_BI_TABLESPACE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  '(NOT EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_BI_TABLESPACE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  '(NOT EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'CONSTRAINT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'TABLE_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'USER_PREF_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'COMMENT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'COMMENT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'AUDIT_OBJ', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'REF_CONSTRAINT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'TRIGGER', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE', 'TABLE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE_EXPR', 'TABLE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLESPACE', 'TABLE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLESPACE_EXPR', 'TABLE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_CONTEXT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_GROUP', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_POLICY', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_POLICY_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'FGA_POLICY', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
Rem
Rem  PRIMARY/SECONDARY filters (alphabetical by object type)
Rem  these must be defined for all schema objects and their dependent objects
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'AUDIT_OBJ', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'AUDIT_OBJ', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'CLUSTER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'CLUSTER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'COMMENT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'COMMENT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'DIMENSION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'DIMENSION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'FGA_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'FGA_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEX', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEX', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEXTYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEXTYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEX_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_TAB_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEX_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_TAB_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'JAVA_CLASS', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'JAVA_CLASS', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'JAVA_RESOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'JAVA_RESOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'JAVA_SOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'JAVA_SOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'LIBRARY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'LIBRARY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'OBJECT_GRANT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'OBJECT_GRANT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'OPERATOR', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'OPERATOR', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'REF_CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'REF_CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_CONTEXT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_CONTEXT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_GROUP', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_GROUP', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_POLICY_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_POLICY_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'SEQUENCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'SEQUENCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'SYNONYM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'SYNONYM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE_DATA', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE_DATA', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'USER_PREF_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'USER_PREF_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TRIGGER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TRIGGER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TYPE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TYPE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TYPE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TYPE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'VIEW', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'VIEW', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'VIEW_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'VIEW_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.FLAGS,16)=16)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NESTED', 'TABLE',  'ORACLE', 9, 0,
  '(BITAND (KU$.PROPERTY,8192)=8192)',0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROC_SYSTEM_GRANT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROC_AUDIT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCOBJ',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCOBJ_GRANT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCOBJ_AUDIT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCDEPOBJ',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCDEPOBJ_GRANT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCDEPOBJ_AUDIT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCACT_SYSTEM',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCACT_SCHEMA',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCACT_INSTANCE',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PLUGTS_BLK',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'END_PLUGTS_BLK',  'ORACLE', 9+512, 0,
  'PLSQL',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCL_CONSTRAINTS', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'INCL_CONST', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCL_TRIGGERS', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'INCL_TRIG', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCL_GRANTS', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'INCL_GRANT', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_FULL_CHECK', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'TTS_FULL_CHK', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_CLOSURE_CHECK', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'TTS_CLOSURE_CHK', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'INDEX', 'ORACLE', 2, 0, 'TYPE_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0, 'TYPE_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  '(KU$.CON1.CONTYPE NOT IN (5) OR KU$.CON1.IND.TYPE_NUM :1)',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AQ_QUEUE', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AQ_QUEUE_TABLE', 'ORACLE', 0,0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'ASSOCIATION', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AUDIT', 'ORACLE', 0, 0, 'AUDIT_OPTION',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AUDIT_OBJ', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'COMMENT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'FGA_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INDEX', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INDEX_STATISTICS', 'ORACLE', 0, 0, 'BASE_TAB_OBJ.NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  'MVIEWLOG.MASTER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'POST_TABLE_ACTION', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCACT_INSTANCE', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCDEPOBJ', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCOBJ_AUDIT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCOBJ_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'REF_CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_CONTEXT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_GROUP', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('POLICY_NAME', 'RLS_POLICY', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_POLICY_OBJNUM', 'ORACLE', 0,0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('POLICY_NAME', 'RLS_POLICY_OBJNUM', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 0, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE', 'ORACLE', 0, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE_DATA', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE_STATISTICS', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'USER_PREF_STATISTICS', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TRIGGER', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AUDIT', 'ORACLE', 2, 0, 'AUDIT_OPTION',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'COMMENT', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INDEX', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_TAB_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  'MVIEWLOG.MASTER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'OBJECT_GRANT','ORACLE',2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_CONTEXT', 'ORACLE',2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.AUDIT_OPTION :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'COMMENT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INDEX', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_TAB_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
 'NOT (KU$.MVIEWLOG.MASTER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'OBJECT_GRANT','ORACLE',2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_CONTEXT', 'ORACLE',2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);

Rem
Rem  Ancestor and domain index object filters
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0, 'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0, 'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'TABLE', 'ORACLE', 0, 0, 'ANC_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'TABLE_DATA', 'ORACLE', 0, 0, 'ANC_OBJ.NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE',2, 0,'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE',2, 0,'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0, 'ANC_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'ANC_OBJ.NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.ANC_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.ANC_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.ANC_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0, 
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0, 
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'TABLE', 'ORACLE', 0, 0, 'ANC_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'TABLE_DATA', 'ORACLE', 0, 0,
  'ANC_OBJ.OWNER_NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0, 
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0, 
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'ANC_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'ANC_OBJ.OWNER_NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0, 
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0, 
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_NAME', 'TABLE_DATA', 'ORACLE', 0, 0, 'DOMIDX_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'DOMIDX_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_DOMIDX_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.DOMIDX_OBJ.NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_SCHEMA', 'TABLE_DATA', 'ORACLE', 0, 0,
  'DOMIDX_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'DOMIDX_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_DOMIDX_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.DOMIDX_OBJ.OWNER_NAME :1)', NULL);


Rem
Rem  Base index filters
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_NAME', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  'BASE_IND_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_IND_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_INDEX_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_IND_OBJ.NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'AQ_QUEUE', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'AQ_QUEUE_TABLE', 'ORACLE', 0, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'ASSOCIATION', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'AUDIT_OBJ', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'COMMENT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
   NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'FGA_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INDEX', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  'BASE_TAB_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  'MVIEWLOG.MOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
   NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'POST_TABLE_ACTION', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCACT_INSTANCE', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCDEPOBJ', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCOBJ_AUDIT', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCOBJ_GRANT', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'REF_CONSTRAINT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_CONTEXT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_GROUP', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_POLICY', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_POLICY_OBJNUM', 'ORACLE', 0, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE', 'ORACLE', 0, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.OWNER_NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE_DATA','ORACLE',0,0,'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE_OBJNUM', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE_STATISTICS', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'USER_PREF_STATISTICS', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TRIGGER', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0, 
 'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'COMMENT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INDEX', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_TAB_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  'MVIEWLOG.MOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0, 
 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.OWNER_NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'AQ_QUEUE', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0, 
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'ASSOCIATION', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'AUDIT_OBJ', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'COMMENT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'CONSTRAINT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'FGA_POLICY', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INDEX', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_TAB_OBJ.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0, 
  'NOT (KU$.MVIEWLOG.MOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'POST_TABLE_ACTION', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCACT_INSTANCE', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCDEPOBJ', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCOBJ_GRANT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'REF_CONSTRAINT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_CONTEXT', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_GROUP', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_POLICY', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE_DATA', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TRIGGER', 'ORACLE', 2, 0, 
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'AQ_QUEUE', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'AQ_QUEUE_TABLE', 'ORACLE', 0, 0,
  'SCHEMA_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'ASSOCIATION', 'ORACLE',0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'AUDIT_OBJ', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'COMMENT', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'FGA_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INDEX', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  'BASE_TAB_OBJ.TYPE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0, 
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'OBJECT_GRANT', 'ORACLE',0,0, 'BASE_OBJ.TYPE_NAME',NUL