/* to do
 1. add capture parameter _ASMJOB_MAX_INTERVAL, default 5 mintues, positive only, finite, dynamic
    done.
    tested.
 2. merge script: start original propagation before start original capture. check split script
    done.
 3. when add a subscriber, submit a new job if not already exist.
    done.
 4. confirm by test: disable split job after split and become not splittable.
    tested.
 5. add error handler for release_lock, ignore return code 4?
    lock_handle is not null, when capture aborted, release_lock get return code 4?
    done.
 6. show job next run time in dba_streams_split_merge
    done: also added script status
    tested.
 7. next run clear last error in view, split job row.
    yes. confirmed.
 8. if merge error will set error in split job row?
    no. confirmed.
 9. merge_streams_job_internal: succeed case and error case update view conditions are different.
    done.
10. dblink for sys
    done: use dbms_sys_sql.parse_as_user for auto split.
    tested.
11. add dba_streams_split_merge_hist
    done.
12. add action_type_monitor
    done.
13. change the merge_threshold/max_interval of an original capture should also change 
    all its cloned captures.
    done.
14. changing max interval should change existing split/merge job next run time.
    done.
15. write error to trace no matter tracing on or not.
    write summary of error to alter log, give trace file name 
    done.
16. write to alter log: start/end of split/merge, with all names, if write_alter_log.
    done.
17. both split/merge progress show in monitor row, and wrapper error
    done.
18. cloned capture and job should always on, but make sure no auto merge job for manual merge.
    only for cca.  for non-cca, use should start cloned capture.
    done.
19. don't drop split/merge script.  need to change script_exists()
    done. 
20. auto merge job disable itself if cloned capture is down.  make sure not during merge
    done.
21. add wrapper in dbms_streams_auto_int, print error stack in script for auto split.
    done. don't need wrapper for autosplit.
22. block number in comment of split/merge script
    done.
23. add split job status: nonsplittable, no error for this case.
    done.
24. confirm: clone_propagation does not call enable_auto_split?
    done. move enabling code from prvtbstr to prvtbprp.
25. new error for can not get lock. action: will automatically retry.
    how about capture not on/nonsplittable
    done.
26. check all release_object_lock, add comment, handle not null
    done.
27. asmjob_max_interval => sm_job_max_interval
    done.
28. show split row in both views if merge is not done.
    done.
29. add script comment, make sure all names are available, for both manual/auto
    done
30. downstreams capture, real_time_mining
    done
31. remove dbms_streams_sm.recover_operation?
    removed.  delete generating code in error handler.
32. make sure all hidden parameter copied when clone capture
    yes.  copied if set by user
33. ready_to_split_ccac should check capture server not active, but not inactive?
    done. change to not active
34. test for downstreams capture
35. preserve propagation status when split
36. extra path in performance advisor when merge local apply
37. missing prop name in v$propagation_sender after merge
38. check first scn of clone_capture
39. cca: always keep inactive_time in capture_server, even acknowledged.
40. Test: cca with hard error (instance shutdown, prop trans error)
    direct_apply=Auto
    instance shutdown
     capture server inactive immediately (after dml?), prop remains enabled, no failure,
     even after dml.
     time out to acknowledge split
     next time nothing to split
     manual split works, then start cloned capture: cloned propagation get failures!!!
41. break crash test into 2 tests
42. rollback error script immediate?
43. when drop capture, drop split/merge jobs, (clean view? how about unfinished split/merge?)
44. when start capture, if cloned, should check split view, if no merge row, insert
45. if not ready to split/merge, clear script_id if any?
46. if script exists, set status spliting/merging, or like 42, script only use once?
47. think about crash test case, consider script, job, view status in each step.
*/
/* questions
 1. fine tune of next run time.  how to change when set thresholds? 
    don't know how long already waiting, use status_update_time?
 3. what to do if split/merge script errors? should be handled in current run. 
    should roll back, what if can not roll back? what if keeping error and rollback?
 4. change original capture's max interval also change all cloned capture?
 5. monitor row show script id?
 6. detail of clean up function: (script, view, inconsistent situation).
*/
CREATE OR REPLACE PACKAGE BODY dbms_streams_auto_int wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
16b86 40fb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/
show error
