/* ------------------------------------------------------------------------- 
   DBMS_WORKLOAD_CAPTURE_LIB - For all kernel trusted callouts from
                              DBMS_WORKLOAD_CAPTURE
 * ------------------------------------------------------------------------- */
CREATE OR REPLACE LIBRARY dbms_workload_capture_lib wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
16
35 6d
UH4eKy5Dq8rW/YAFMA7EoEEnRowwg04I9Z7AdBjDWqGXYkqWcpaX//quWfSu3FYWPmLy8HL6
WQnnvZ6yy1IyzKV0K+fLUnQI9WHJpqb4vvMt

/
/* ------------------------------------------------------------------------- 
   DBMS_WORKLOAD_REPLAY_LIB - For all kernel trusted callouts from
                              DBMS_WORKLOAD_REPLAY
 * ------------------------------------------------------------------------- */
CREATE OR REPLACE LIBRARY dbms_workload_replay_lib wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
16
34 6d
mwIiTINxyX1QO1YSBoqMBkOIsV8wg04I9Z7AdBjDWqGXYkqWcpaX//quWfSW8mKFodhfcvpZ
Cee9nrLLUjLMpXQr58tSdAj1YcmmpsFc8/I=

/
/*
    *************************
    DBMS_WRR_INTERNAL package
    *************************
    Define the DBMS_WRR_INTERNAL package that implements 
    various features and utility functions used by both the 
    CAPTURE and the REPLAY infrastructure, such as FILTERS.
    NOTE: This needs to be defined before the packages that
          uses this one.
 */
create or replace package dbms_wrr_internal wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
419a ec3
vJX/uGR4wObCzVTrTJ6Nvpo/I5Qwg826miBo39O8F7WUohKpDWfTV58lHeBoHepRn5Me6qKX
HoGZ7rQSsQZoFFQFzUR9LKoaWqEU6d4+rfpqa5lqWjTkQIJq7keAJ8PdpeHiL1P4pQUd+Aud
F50/z2jNJBloHVpKSqYRqt8B9Ij/FsWCdXzDp5ON4Qi9Tl9pdcymzg+nTTa7+b2HQUFukJCQ
BeEElT7gUofoyKwz671TRgFTQEPepZJdkahddoCz2SEQvlWsgZLS15iOne9dtI4SN+ZvhkZI
mdvmVFDlomFUB3Eq8dllbIlNWo9vMFrI71WXGkJGU2QVGhjPiczvMgEnvX2X6qyr3t6MKTY+
YoLi8S/zwFVRansma8DM2lUaGhilAp/YDoTxBCdqbWUPjXyBNwprYTa5DsU1h56Fa2GmBAlu
F4fhXWm6pnge0weFgKmrJwzntl9lxR+GaTTfhBJlm18K5gxPdcGEzHkYpo9+Q+cZLqsIljih
ge0aoUwGdKcFeyjYXSuqEOI1C244wjxLjFBepJexraJG9bTMfTFCrjh5HkrmmleOuUuMUMR7
w+BURpaT8WTLNarAZ+klNWytNnMHvFny8kYMYUY2+3OCxUNdcdar9CWq9JSJHvDjLNLDB+Vs
M26BWQerQjGq9ESgTsIo0s2pA05Dcl/olWtuxKaBKwr2TKNX33WjklGif7x7FAzj4BI8uUIN
fhsjjs8FN71sisHP+maJj3cXyf85dHwCDHyOIGLOWTe+W1dAhH7zVpqRTM0EtjVhRlGgB7AM
CUZBMFRMiDDcupt7RsYISZlKJNOaLLf+vTC0AKwFE3LQrvikU3PS9apbIj8jNiyfj+4IybVT
mB0orsTEmAcHqgBVmqpCREqvT6rF0ovr+ST+T0i5Z02Pv53ypZZ4nbvd18aWj0756wf4VSAo
ZHYjm1St2MEDd6CgVr9PuyC8X9UxCgRCQvddfOBRHO4B6eknBPBfGhzyh0xjofYhte/Qp6AO
sbIAfumg4Rnnx9DE5O9XOI5zZ6p9VKgOsR6/0ns9bNOHZVJA8QjjEPYpPRW00CSjM9Rc6FQd
/9FOmduh2/ieTrI+MxLxBx83zmwerf/YipsG5zDPNre3tew+cB1/pC9LTUSJ48Ev+NXuDXsA
gFFWFh7yicqHC3Y8gel4SvxGWQjXFdLHrrfntuLwVKvm/wW0ChmxFZSq/JZSvxzeGA/w51jg
5gvjM6UJs86BrlYMV4Lu7uZparFuFv8N3BRpPUoJyLbFyx3xTuWbv6kj1sl+ttfwdXyubTbM
jkKzACo8b9OEh53vJJvRxoPTzjfpvf57aE0txkAXGBcS6PDWp3J8Uz6Twz0BI8NQLMQSnxLr
WD2P6bmBxgMHxlvEHHrHwWwAim6j/4eczCF0a38ClAg9OKj4E2FQxNOrCzRs0kcm5tRyh5Xs
T6ImTe29qyI7EmywQKvk7YGJIunEHNTbrEjLD7bOctUfzYISRQG1GZrP+UM9uZ3QLFmaqoTW
PVFTimK8kO34TBe7CGnx8KfVYAwEUaYa49iiI0joNpltKG3N9ug6FgmO2qYtU4QpiVBddLHi
V9YpkVnZKhtw0TgJqLF6bU61ttaRpKNu2rH06z8U8Z1qZWQpVtlZtfq9BdDUiRU0EShFzytc
CroBD19+jGDp73bQo+HvRKDH/ccriJCtKY/Yc0KB1xSqkyOlRBXzJCCVS/JNRbieR7WrPyF9
k0HHm409izHA6m5Gd8HeWrE1x1eV1lHsJHsB9JFqA8uLlebj/JVqDgrDp5vfZxOCBgdph5KB
swa13HMR/1Fs7cvOOErpoBzEuOHQipP88NiXWaZHLjF1Kbb+cbq3OPIanmPMbgAmtV+cesAN
HqEgFNGvWdXpfNeAZRWADRoltj7ncOmLR/QVeuaCPDZjkSpyJKJ6RX3v6c7w13iZ6Vp1N63z
F+invTw9ketfx2SIREihZVRZ23mKpAEne26LzeZV87+FtgTGRgMzJ4KJafZkrmdybS86Po9o
ENUkHm5p1TFZFQdfj/YhsSB6NbCmelvXfXH1lBUUqHKE/QOugIxCESPp3c9kUqBDoD4RUvvm
QQffF0+pYAGhOc0ipuImRY055WblZGDDGw6tAvqx+lsPPn/OkedLuAFXlTG604Z8F6zFPDjU
WL/aYnRhMeiTNHvYRATJT6cQzWypceb1bJYCxdMhmuP09bKAjtuTbsSynjf/Rhtj5g6ukOp3
Eo1DkO0UBOG/yJTafeU0FOfdD/WBE7M9Ohq3W0DNo5Zyb05aj78Ublh+lspeYva4VpeC0kzj
xTHJa7RdXio7BRRZmjDufasXHxu4ZkqvGIv5W4m7P0u9TiEy2O2auQEutrSOTD0uTYfwX2Ya
UR12gNmG83+bPwf0SWUuBsAY+uUUCHuuEYhThigCYYYXLGzJT2bJHMpBUp91Nir6/oq2ajZw
QE0wj9hQXs7CtMjNGl6pPro1btfhG0IFzWWyVN0YDoXhSszbQFd1+x4GydGoFvYdD+iRBsgh
AggzlwMf2X4zQRRYlX7xJrXSG/HNRH6+Y+M2gSCGm89uRYMJJ0VCPn0baP/x70dveCasZEXC
dQU94WtgLBxWJfW/Hbk9Xt2QJJTC2AYEDbHG8VfBBpssRqG80l3d6YGceHsgTc3KT2y/SROL
uyMyWLjTXAbyjq4SzguHlJ8Sx4OKMwLu9SHAa9d+uI0812iEkxua4+guw+LIfSCHQB9+kI77
JM9RyFFN+bw/rCHMrVKKuhjcD8Rfa1+PWlT8iOMK82CQiXjejqk0Z2x+59LSSKiMMsl7aFoI
PLYLsc4zf8i8HHmM819BIOvHdKthydgX8oNdISngDRt/+lDo/xdVVdmgzW+WThHVRZgX3Usc
EB1Dwoec+R1FAQK3uUjtvFRruGMPl1NqRVUwkFnwJolCqBLF4UXYTjK7iMKya2yxWtv4IVT+
TZjiFItOR7SuOa5bZi7f8Ig10Jk6kTlK3PNiUrRoC0JM6/RJwmKo/ofOEb0TSo0+fOxvHUsI
OR8x4iXKKEW2sAu5NoKQgpokTkzSdJaBpD27TGkphI7lkgi83FToGyrwU3pJLCPaxXHvh1ke
yawd17Df798gAkKtDk0pRShm+dn1vsP/MTdRD03swKIkP1CASk7SP+H9JZcm4RcEUW4yKEnf
V6sy1pgHYLyaZoM67En77R44tZLIH34r0R3gP4y/D5a3kgFtB26SxVyQkDSUTRKpgbFnuNlB
HxyHPZxli2tYj/aRV5S33DQbI9iYoX5eqObYgI+5SqvflzSTe13h15Len9oV9MamQk936hfw
CPCUtojyH475ocyrVpKyzl0GpFtSesCId3bwphEom3NjwwKjFtOcQoOrjqtWARRvfvv8xWN3
CIdbqUWap7EYRYInoCRIVALK0hPETNFPPcCWJbQRQVIrEYMRgYdKKGBDaSA6hNyknr3p34sH
RmKPEkZGEvlID/zQjp0l8qo7MkvWBRYVQqNnMZMsoIPtMwxl8M1kN7XOo/kpITqwvKTEVW0e
h4YMpw4MOpL3wTBmmnJsQYZDujlmZez2Y68Jj1MMyPXwH+HMWxjTD/Edehq+TzsGBA9EVSqJ
uzsXsDdNE3kltnILiMtKaFbpHoNcxOdK8bRc2x8zDpK8ngkRIonE8sOkVe01mbEe0kr5OpKB
eMYSuAbdRzsRd8HutmYb1BForG3mk9uuST73loIm9rxOnXMofZkTew==

/
show errors;
/*
    ******************************
    DBMS_WRR_INTERNAL package body
    ******************************
    Define the DBMS_WRR_INTERNAL package that implements 
    various features and utility functions used by both the 
    CAPTURE and the REPLAY infrastructure, such as FILTERS.
 */
create or replace package body dbms_wrr_internal wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
1b4f3 6250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/
show errors;
/* *********************************
   DBMS_WORKLOAD_CAPTURE package body
   *********************************
 */
CREATE OR REPLACE PACKAGE BODY dbms_workload_capture wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
9e06 26e4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/
show errors;
/* *********************************
   DBMS_WORKLOAD_REPLAY package body
   *********************************
 */
CREATE OR REPLACE PACKAGE BODY dbms_workload_replay wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
49078 100c4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/
show errors;
/*    *****************
      AS_REPLAY package 
      *****************
      Defines functions to set up the database for an AS replay. 
      Mostly reuses the dbms_wrr_internal procedures, with some 
      AS Replay specific twists for: 
      - Setting the replay_type as 'AS' (as opposed to 'DB')
      - Preprocessing/Initializing/Preparing using ECIDs
      - Starting an AS replay without waiting for replay client to connect
*/
create or replace package as_replay wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
30a 17d
pukz5QFKLZN8w0BvFMEgV8LOLz8wg2PxLUjhf3Rn2prqMBrTHc2XkcBIchWcotysNgzbUPD7
DV61vDcdy1WUow0rGrSh0tLTxoyTBtWvM++dnc2/Ba7dplxEULJk/2mQialigGDusgF0k/qZ
4klQ1zHgDFBEulRr7DmBQiPK5I5J5teeCxWGNKsjdgMvy9M5EFYMtldseMqdUKVNFubxAisU
F6kuzayOJyOvFC2JZh9rN7aUFYFqRg0q8HvZ/V+KipXe7m4vp5J08OwRI3JyV/b623a+Y3Z0
nq/dZAcA18m/ky04mHb3+dcVjkzf3A0w+c3xgBNuz0jZUjMVGsSVvLs1400tu912YCQHfhAN
D1xjQLw/zuFBogpQ

/
show errors;
create or replace package body as_replay wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
8de 367
eR7woDpZQF1f9tnu9m4dDltcUfowg2Ncr0oTfC/NWGR18o3hXMPNM/LEJdt0bZQL7wV+ie1U
En07B+UAgbv21qGpZ0UTQ8ipAD9OenJOaMoFhu+v3JSAMDqGP7XOgU5DlhRoZ+GmodM/2Stl
2Y02SHacaMCO5FieB9TeJzYcNbd5DdIW8i+XSN6ipSi3b2DQfh6kKXpZuX332ahHyMrJNyYr
g9LHb4C+oOXG4x1jKw212hFzPsl4Uotp9xvQC7NhORxwggZFodSOpgH7c+AX0LICcCETeojx
p8g5PJq8ahA5YWZCoxy/o1F8icbMmxE0drzgRj15LFDX4o7RB11xi2DVYOke/rhKAAfoHTj0
Kq9pdjDm18V3D8R8Ve6btqie4u7TZv36PD62821MeWg1Ke1pVKLfD2CO703qGKCif6hFELIK
HlkgQOfx5qcdbsNUFva8Fmf+yVnnC7QwAD4CzsIJNLU8nTXw5si4rEFadNn4yams8n4CgU/m
cYW4YIfD4I97L6QIaP/CkuB0DVNo7peTfs+rd4wYNSdK8VyjoflfkGLSuojstaBYUPvqlQvy
8pqb/5vsbjgW58kyrdZVmlVMlcKUnPiZGr8LOPaNC/IecC54ecILhoPUPSJueKy3h0lvDZ3I
IgQl7AcaWMRkZ4y/5fqtca187VFSOlnXsYj6MoiaSn+cu0znC7MZihyZIwE6Nhp5nqAhvDd6
FymJ0TR1t1qEVdcX2BvYpJY0adsw7sUhPSFlGUw4byIi9SK4RfDg9x7sBQL9sCCLk9A567on
yap4J9onQyoKk3p4cwav3wv8iAYY9M6FugNliUf4sVbNNnwUAPuBY05Orc/OW+7PKZU=

/
GRANT EXECUTE ON as_replay TO execute_catalog_role, dba
/
show errors;
