SET SERVEROUTPUT ON
BEGIN
    $IF DBMS_DB_VERSION.VER_LE_10_1 $THEN
       DBMS_OUTPUT.PUT_LINE('This package is only working on Oracle RDBMS versions 10.2, 11.1, and 11.2.');
       RAISE_APPLICATION_ERROR(-31061, 'Unsupported Oracle RDBMS version');
    $ELSIF DBMS_DB_VERSION.VER_LE_10_2 $THEN
       DBMS_OUTPUT.PUT_LINE('INSTALLING SCRIPT FOR VERSION 10.2.');
    $ELSIF DBMS_DB_VERSION.VER_LE_11_1 $THEN
       DBMS_OUTPUT.PUT_LINE('INSTALLING SCRIPT FOR VERSION 11.1.');
    $ELSIF DBMS_DB_VERSION.VER_LE_11_2 $THEN
       DBMS_OUTPUT.PUT_LINE('INSTALLING SCRIPT FOR VERSION 11.2.');
    $ELSE
       DBMS_OUTPUT.PUT_LINE('This package is only working on Oracle RDBMS versions 10.2, 11.1, and 11.2.');
       RAISE_APPLICATION_ERROR(-31061, 'Unsupported Oracle RDBMS version'); 
    $END
END;
/
BEGIN
   DBMS_LOCK.SLEEP(2);
END;
/
SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
DECLARE
  table_exists EXCEPTION;
  PRAGMA EXCEPTION_INIT(table_exists, -955);
BEGIN
execute immediate '
create table XDB.XDB_INDEX_DDL_CACHE
(
  ROOT_TABLE_NAME          VARCHAR2(128), --the parent (user input)
                                          --xmltype table/relational table
  ROOT_TABLE_OWNER         VARCHAR2(32),  --the paretn table owner
  ROOT_COL_NAME            VARCHAR2(128), --the relational column name 
                                          -- NULL for xmltype tables
  TABLE_NAME               VARCHAR2(128), --table name (inlcuding nested 
                                          --and OOL tables
  TABLE_OWNER              VARCHAR2(32),  --table owner
  IDX_OWNER                VARCHAR2(30),  --index owner
  IDX_TABLE_NAME           VARCHAR2(30),  --table on which the index is
  IDX_NAME                 VARCHAR2(30),  
  IDX_TYPE                 VARCHAR2(27),  
  CONSTR_NAME              VARCHAR2(30),
  CONSTR_OWNER             VARCHAR2(30) 
) 
';

EXCEPTION
     when table_exists then null;
     when others then raise;
END;
/
grant select,insert,delete on XDB.XDB_INDEX_DDL_CACHE to public
/
ALTER SESSION set CURRENT_SCHEMA = SYS;
grant select on  sys.obj$ to xdb;
grant select on  sys.ntab$ to xdb;
grant select on  sys.col$ to xdb;
grant select on  sys.coltype$ to xdb;
grant select on  sys.user$ to xdb;
grant select on  sys.attrcol$ to xdb;
ALTER SESSION set CURRENT_SCHEMA = XDB;
create or replace package body XDB.DBMS_XDB_CONSTANTS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
ffc 2cd
lvaPFzlB5v5hlVFJN/rzTDw/Ysgwgw2nLvEayi9gF0ywj55e87Z/8+3mWnngjnTdiPaVcyCz
TeM9+VDDt4ajmu/XXdZBwiSg+wk++co0/F/9QkN18dQJ3rJri58KW/rYafGpkRiZMVOvPJ36
wYDWpKAUqibJu8OavVuZRbYJBNV1xsi6zw2sYIWBHd9qaBg/TtP5n4vkSV1y+GTaSoLdZaAV
TaejtSPi0iWIobPy4g12J3ugb7CDpgwwbM3d0ok3XuzCb+g+Fv5IVh9EvQ05jDnXpoxdjY1s
M5khiqR7GMpK2FYDtSQR+IUDwm4M6rhua2qTJL72CD+bl5cqba1yBhGUWOo8DIIA6Sdiqxpr
h3C+lcfMsVfNy0toLg09X0sKMyoshH6I9DXEtdlVxWAX6y1+6/ZNlVMNWozotPKdb66Ytcgb
ATjC92QNXmEkkJQwKb4ItpsEHYzudSbCm7KulwvTX2BwOQx3bV0OAiZ3dCrDKyIMpyLG3YXM
Xmxheq1IOFjYSIed983XwWj1S4rLf4k4D9ZsOCIZjp6/v0BOMKiEiKCWR1DmH9QFrKDi0/H8
gDcw+1Pd2aCjBHmhDev+WJdy7WIe/P9TPhCnvmAKa6reRtFMgvxpsRRY5ZvV3cg2dyZAowrp
KlQWsaJ3JuMm4iA49TOzhGt9iA1T5NpyRVUpW4sFwrcDjlluGJNzhh0ni/uI

/
show errors
CREATE OR REPLACE PUBLIC SYNONYM DBMS_XDB_CONSTANTS 
          for XDB.DBMS_XDB_CONSTANTS;
/
CREATE OR REPLACE PACKAGE body XDB.DBMS_XMLSCHEMA_ANNOTATE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
165ac 1f04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/
SHOW ERRORS;
grant execute on XDB.DBMS_XMLSCHEMA_ANNOTATE to public;
/  
SHOW ERRORS;
CREATE OR REPLACE PUBLIC SYNONYM DBMS_XMLSCHEMA_ANNOTATE 
     for XDB.DBMS_XMLSCHEMA_ANNOTATE;
create or replace package XDB.PRVT_DBMS_MANAGE_XMLSTORAGE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
137 eb
/e0W8RAwooIABognR9LW5cxkuoowg5BKAMvWfHQC2seeKKQYwzJ9l5GsOsy3yHs5Avr+nem2
RmmxPCX95OQ6MfvXmVus3QoRsUVNyxDfIa39AYtlalRcpnMG8FkDBzfbR9FU8sJEZgxKNLQ+
8kD/RUQAymKJZYFpiQsMD2p4RxSZElpM+IVFHFkxs/EKJeTHJLz+BFT31+PkNGq56YLxaus7
qs8aZpoqnCh8LK4R

/
grant execute on XDB.PRVT_DBMS_MANAGE_XMLSTORAGE to public;
show errors
create or replace package body XDB.PRVT_DBMS_MANAGE_XMLSTORAGE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
2693 6b7
JNDO4vPeNR5AYMqQj3C+Njr9h7cwg1Wj2cCMey/t9rzmbZipxZwfv0JMk4Xm1HdwcMilkSvk
tQ9fh6kURhxKglKVXCYErKOwurCuxAUpqJL71XT/TDr90mqQ3EM6YOj9fjFVKXM8L4Oy5Pta
wlaYX2JRMrHhtP5TYlLWIFNjLi4RP093PduWNVWsSBqP7XosMXKdRy9zVYbe3R8I/vQcZUu1
Ra59o3hj3sCaK+4DKnB7yzsXgd4ymZ3+S2IgpE5Wu0kIEpMW4rSHj74Ta/bq71bmtK6bZn25
t6gv5MfbzeHgvOQFfOVr/RICNTS19aaWWX3Kkl9sXYjqMtlhbEdWUaY15uovvvOkrCZSkLot
hvZ5nKj3+PYSXjBIpd+bxC1rKprgfpN8kKek+caDeCUSh13LGA3oSN5bWWTbc9lQVWetFUBS
Z4YYOl2ho5cEltyT7GDbpCxL38NQEF8uySWh95GYMbUgQQFCr/7llmdCMMMMvU29Edqegy3e
pu3gQrS66zN7SEpE8VhduxrNrc+AbBIk/CVLD339VzTJBVch9QsJUwYVBJc61vaxFR76UZAo
+OD0LWqKSZLvpMLP06PkdYJFGh7UIrFEv9+YTs73m/jyMdc8DlLKVabFWWw/P8OjzI+So+ae
N1epXPnJCpfePpF9pkY2E68WptOZqkwIqZMwlq3F3f1TasnbrScYKON0usA4j/NkZOxbLrGB
8+TxxV9KBv5J9xiEoeg9jGI92Qn2M90UH7339lJxJW3Y0mXmCabg81/YNu9yygTMNrpzWlEE
QgAYY8TZlqLRvOYJFbmQVhlilcYRxy2zLPy7iNa0rZyCltBL3jCzdwqcMUGb8ui6hcF5jxV5
tyVoUUbLlA+CTgvGbAduNLovAihNhwYdEU55kjoD/3Ot+vJhpFaHUPaclJmIzWffCmnnfMKm
ZFf1U3oNK0xl/reIXgaZgsdLucvkuUvyPexMRE0aLZTyXJ5Waqzpetcm/z+OBKc7mzE4XA0n
XCqV7luNOwmX6GVsoTzlqdhYxqXq6Up4HVU7IKXav0yaiQ0bmyjrdo4ccQ6siQ7A8qlZELqR
4yRSyQnvn8xYACDAgxyx+Z/ut6AkxusCWZmp1p9vOPt3Vtu9cPH8RPFeTZpvNe6EOkP8xNaV
mZIMPXL0apnql3UfO7aYEuJDvAqNEZpXivfmzTDNCXhTCe0lFhzJEA6LgEao0fOsLcosX+lx
ywCwJuPj8lnoRAusIgS3dRQQ5rEGIy2DdZU3dP4qkwQRWa6GI1gQSgwjdm1tRwotwneM4mPY
dxyTeKm6FZLWfUWnQpGX0Z//F+/4+S61T4+iCGk28SfolnQUbHT9AefbrNvUZryKuZNaTca8
uA6JuFRRL+c5GLJgkaGaTLUu9hClJno+DSSJfdretT1iZ8/jhYao8vM3pKEw9P/KwkCw52qC
GhXvHJrtEIXkf8iQAsFrFFL1n++YTu+BAcIz988cqFeLDJLjrDfCQGDjwHhh1l/repmjnQLr
By8SD6+txt929MEsI0r4HW95DCqICe+Nj6ZaT2Imj47ApndNZmtWvhx3nZUMBDn3T+Aa4bm4
Z+pX5L/jlz4tSg7VvK8BARV9hXg3g0fHd/QetfdwZHLg5xQ6jK7FiR4gcL2EYZHxOm7AgS6/
5Ik7gUxOaICrgqAinjEcb05rm+8zflKSwSituaXp

/
SHOW ERRORS;
create or replace package body XDB.DBMS_XMLSTORAGE_MANAGE wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
11780 2d73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/
SHOW ERRORS;
grant execute on XDB.DBMS_XMLSTORAGE_MANAGE to public;
CREATE OR REPLACE PUBLIC SYNONYM DBMS_XMLSTORAGE_MANAGE
     for XDB.DBMS_XMLSTORAGE_MANAGE;
