--
-- Copyright (c) 1998-2009 by Oracle Corporation. All Rights Reserved.
--
-- NAME
--   helpus.sql
--
-- DESCRIPTION
--   Inserts SQL*Plus HELP text in English
--
-- NOTES
--   This script is called from helpbld.sql

SET AUTOCOMMIT 100

INSERT INTO HELP VALUES ('@', 1, NULL);
INSERT INTO HELP VALUES ('@', 2, ' @ ("at" sign)');
INSERT INTO HELP VALUES ('@', 3, ' -------------');
INSERT INTO HELP VALUES ('@', 4, ' Runs the SQL*Plus statements in the specified script. The script can be');
INSERT INTO HELP VALUES ('@', 5, ' called from the local file system or a web server.');
INSERT INTO HELP VALUES ('@', 6, NULL);
INSERT INTO HELP VALUES ('@', 7, ' @ {url|file_name[.ext]} [arg ...]');
INSERT INTO HELP VALUES ('@', 8, NULL);
INSERT INTO HELP VALUES ('@', 9, ' where url supports HTTP and FTP protocols in the form:');
INSERT INTO HELP VALUES ('@', 10, NULL);
INSERT INTO HELP VALUES ('@', 11, '    http://host.domain/script.sql');
INSERT INTO HELP VALUES ('@', 12, NULL);
INSERT INTO HELP VALUES ('@@', 1, NULL);
INSERT INTO HELP VALUES ('@@', 2, ' @@ (double "at" sign)');
INSERT INTO HELP VALUES ('@@', 3, ' ---------------------');
INSERT INTO HELP VALUES ('@@', 4, NULL);
INSERT INTO HELP VALUES ('@@', 5, ' Runs the specified script. This command is almost identical to');
INSERT INTO HELP VALUES ('@@', 6, ' the @ command. It is useful for running nested scripts because it');
INSERT INTO HELP VALUES ('@@', 7, ' has the additional functionality of looking for the nested script');
INSERT INTO HELP VALUES ('@@', 8, ' in the same url or path as the calling script.');
INSERT INTO HELP VALUES ('@@', 9, NULL);
INSERT INTO HELP VALUES ('@@', 10, ' @@ {url|file_name[.ext]} [arg ...]');
INSERT INTO HELP VALUES ('@@', 11, NULL);
INSERT INTO HELP VALUES ('/', 1, NULL);
INSERT INTO HELP VALUES ('/', 2, ' / (slash)');
INSERT INTO HELP VALUES ('/', 3, ' ---------');
INSERT INTO HELP VALUES ('/', 4, NULL);
INSERT INTO HELP VALUES ('/', 5, ' Executes the most recently executed SQL command or PL/SQL block');
INSERT INTO HELP VALUES ('/', 6, ' which is stored in the SQL buffer. Use slash (/) at the command');
INSERT INTO HELP VALUES ('/', 7, ' prompt or line number prompt in SQL*Plus command line. The buffer');
INSERT INTO HELP VALUES ('/', 8, ' has no command history and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('/', 9, NULL);
INSERT INTO HELP VALUES ('/', 10, ' /');
INSERT INTO HELP VALUES ('/', 11, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 1, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 2, ' ACCEPT');
INSERT INTO HELP VALUES ('ACCEPT', 3, ' ------');
INSERT INTO HELP VALUES ('ACCEPT', 4, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 5, ' Reads a line of input and stores it in a given substitution variable.');
INSERT INTO HELP VALUES ('ACCEPT', 6, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 7, ' ACC[EPT] variable [NUM[BER] | CHAR | DATE | BINARY_FLOAT | BINARY_DOUBLE]');
INSERT INTO HELP VALUES ('ACCEPT', 8, ' [FOR[MAT] format] [DEF[AULT] default] [PROMPT text | NOPR[OMPT]] [HIDE]');
INSERT INTO HELP VALUES ('ACCEPT', 9, NULL);
INSERT INTO HELP VALUES ('APPEND', 1, NULL);
INSERT INTO HELP VALUES ('APPEND', 2, ' APPEND');
INSERT INTO HELP VALUES ('APPEND', 3, ' ------');
INSERT INTO HELP VALUES ('APPEND', 4, NULL);
INSERT INTO HELP VALUES ('APPEND', 5, ' Adds text to the end of the current line in the SQL buffer.');
INSERT INTO HELP VALUES ('APPEND', 6, NULL);
INSERT INTO HELP VALUES ('APPEND', 7, ' A[PPEND] text');
INSERT INTO HELP VALUES ('APPEND', 8, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 1, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 2, ' ARCHIVE LOG');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 3, ' -----------');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 4, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 5, ' Displays information about redo log files.');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 6, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 7, ' ARCHIVE LOG LIST');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 8, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 1, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 2, ' ATTRIBUTE');
INSERT INTO HELP VALUES ('ATTRIBUTE', 3, ' ---------');
INSERT INTO HELP VALUES ('ATTRIBUTE', 4, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 5, ' Specifies display characteristics for a given attribute of an Object Type');
INSERT INTO HELP VALUES ('ATTRIBUTE', 6, ' column, such as the format of NUMBER data. Columns and attributes should');
INSERT INTO HELP VALUES ('ATTRIBUTE', 7, ' not have the same names as they share a common namespace. Lists the');
INSERT INTO HELP VALUES ('ATTRIBUTE', 8, ' current display characteristics for a single attribute or all attributes.');
INSERT INTO HELP VALUES ('ATTRIBUTE', 9, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 10, ' ATTRIBUTE [type_name.attribute_name [option ... ]]');
INSERT INTO HELP VALUES ('ATTRIBUTE', 11, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 12, ' where option represents one of the following terms or clauses:');
INSERT INTO HELP VALUES ('ATTRIBUTE', 13, '     ALI[AS] alias');
INSERT INTO HELP VALUES ('ATTRIBUTE', 14, '     CLE[AR]');
INSERT INTO HELP VALUES ('ATTRIBUTE', 15, '     FOR[MAT] format');
INSERT INTO HELP VALUES ('ATTRIBUTE', 16, '     LIKE {type_name.attribute_name | alias}');
INSERT INTO HELP VALUES ('ATTRIBUTE', 17, '     ON|OFF');
INSERT INTO HELP VALUES ('ATTRIBUTE', 18, NULL);
INSERT INTO HELP VALUES ('BREAK', 1, NULL);
INSERT INTO HELP VALUES ('BREAK', 2, ' BREAK');
INSERT INTO HELP VALUES ('BREAK', 3, ' -----');
INSERT INTO HELP VALUES ('BREAK', 4, NULL);
INSERT INTO HELP VALUES ('BREAK', 5, ' Specifies where changes occur in a report and the formatting');
INSERT INTO HELP VALUES ('BREAK', 6, ' action to perform, such as:');
INSERT INTO HELP VALUES ('BREAK', 7, ' - suppressing display of duplicate values for a given column');
INSERT INTO HELP VALUES ('BREAK', 8, ' - skipping a line each time a given column value changes');
INSERT INTO HELP VALUES ('BREAK', 9, ' - printing computed figures each time a given column value');
INSERT INTO HELP VALUES ('BREAK', 10, '   changes or at the end of the report.');
INSERT INTO HELP VALUES ('BREAK', 11, ' Enter BREAK with no clauses to list the current BREAK definition.');
INSERT INTO HELP VALUES ('BREAK', 12, NULL);
INSERT INTO HELP VALUES ('BREAK', 13, ' BRE[AK] [ON report_element [action [action]]] ...');
INSERT INTO HELP VALUES ('BREAK', 14, NULL);
INSERT INTO HELP VALUES ('BREAK', 15, ' where report_element has the following syntax:');
INSERT INTO HELP VALUES ('BREAK', 16, '     {column | expression | ROW | REPORT}');
INSERT INTO HELP VALUES ('BREAK', 17, NULL);
INSERT INTO HELP VALUES ('BREAK', 18, ' and where action has the following syntax:');
INSERT INTO HELP VALUES ('BREAK', 19, '     [SKI[P] n | [SKI[P]] PAGE] [NODUP[LICATES] | DUP[LICATES]]');
INSERT INTO HELP VALUES ('BREAK', 20, NULL);
INSERT INTO HELP VALUES ('BTITLE', 1, NULL);
INSERT INTO HELP VALUES ('BTITLE', 2, ' BTITLE');
INSERT INTO HELP VALUES ('BTITLE', 3, ' ------');
INSERT INTO HELP VALUES ('BTITLE', 4, NULL);
INSERT INTO HELP VALUES ('BTITLE', 5, ' Places and formats a specified title at the bottom of each report');
INSERT INTO HELP VALUES ('BTITLE', 6, ' page, or lists the current BTITLE definition.');
INSERT INTO HELP VALUES ('BTITLE', 7, NULL);
INSERT INTO HELP VALUES ('BTITLE', 8, ' BTI[TLE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('BTITLE', 9, NULL);
INSERT INTO HELP VALUES ('BTITLE', 10, ' where printspec represents one or more of the following clauses:');
INSERT INTO HELP VALUES ('BTITLE', 11, NULL);
INSERT INTO HELP VALUES ('BTITLE', 12, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('BTITLE', 13, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('BTITLE', 14, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('BTITLE', 15, NULL);
INSERT INTO HELP VALUES ('CHANGE', 1, NULL);
INSERT INTO HELP VALUES ('CHANGE', 2, ' CHANGE');
INSERT INTO HELP VALUES ('CHANGE', 3, ' ------');
INSERT INTO HELP VALUES ('CHANGE', 4, NULL);
INSERT INTO HELP VALUES ('CHANGE', 5, ' Changes the first occurrence of the specified text on the current');
INSERT INTO HELP VALUES ('CHANGE', 6, ' line of the SQL buffer. The buffer has no command history list and');
INSERT INTO HELP VALUES ('CHANGE', 7, ' does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('CHANGE', 8, NULL);
INSERT INTO HELP VALUES ('CHANGE', 9, ' C[HANGE] sepchar old [sepchar [new[sepchar]]]');
INSERT INTO HELP VALUES ('CHANGE', 10, NULL);
INSERT INTO HELP VALUES ('CLEAR', 1, NULL);
INSERT INTO HELP VALUES ('CLEAR', 2, ' CLEAR');
INSERT INTO HELP VALUES ('CLEAR', 3, ' -----');
INSERT INTO HELP VALUES ('CLEAR', 4, NULL);
INSERT INTO HELP VALUES ('CLEAR', 5, ' Resets or erases the current value or setting for the specified option.');
INSERT INTO HELP VALUES ('CLEAR', 6, NULL);
INSERT INTO HELP VALUES ('CLEAR', 7, ' CL[EAR] option ...');
INSERT INTO HELP VALUES ('CLEAR', 8, NULL);
INSERT INTO HELP VALUES ('CLEAR', 9, ' where option represents one of the following clauses:');
INSERT INTO HELP VALUES ('CLEAR', 10, '     BRE[AKS]');
INSERT INTO HELP VALUES ('CLEAR', 11, '     BUFF[ER]');
INSERT INTO HELP VALUES ('CLEAR', 12, '     COL[UMNS]');
INSERT INTO HELP VALUES ('CLEAR', 13, '     COMP[UTES]');
INSERT INTO HELP VALUES ('CLEAR', 14, '     SCR[EEN]');
INSERT INTO HELP VALUES ('CLEAR', 15, '     SQL');
INSERT INTO HELP VALUES ('CLEAR', 16, '     TIMI[NG]');
INSERT INTO HELP VALUES ('CLEAR', 17, NULL);
INSERT INTO HELP VALUES ('COLUMN', 1, NULL);
INSERT INTO HELP VALUES ('COLUMN', 2, ' COLUMN');
INSERT INTO HELP VALUES ('COLUMN', 3, ' ------');
INSERT INTO HELP VALUES ('COLUMN', 4, NULL);
INSERT INTO HELP VALUES ('COLUMN', 5, ' Specifies display attributes for a given column, such as:');
INSERT INTO HELP VALUES ('COLUMN', 6, '     - text for the column heading');
INSERT INTO HELP VALUES ('COLUMN', 7, '     - alignment for the column heading');
INSERT INTO HELP VALUES ('COLUMN', 8, '     - format for NUMBER data');
INSERT INTO HELP VALUES ('COLUMN', 9, '     - wrapping of column data');
INSERT INTO HELP VALUES ('COLUMN', 10, ' Also lists the current display attributes for a single column');
INSERT INTO HELP VALUES ('COLUMN', 11, ' or all columns.');
INSERT INTO HELP VALUES ('COLUMN', 12, NULL);
INSERT INTO HELP VALUES ('COLUMN', 13, ' COL[UMN] [{column | expr} [option ...] ]');
INSERT INTO HELP VALUES ('COLUMN', 14, NULL);
INSERT INTO HELP VALUES ('COLUMN', 15, ' where option represents one of the following clauses:');
INSERT INTO HELP VALUES ('COLUMN', 16, '     ALI[AS] alias');
INSERT INTO HELP VALUES ('COLUMN', 17, '     CLE[AR]');
INSERT INTO HELP VALUES ('COLUMN', 18, '     ENTMAP {ON|OFF}');
INSERT INTO HELP VALUES ('COLUMN', 19, '     FOLD_A[FTER]');
INSERT INTO HELP VALUES ('COLUMN', 20, '     FOLD_B[EFORE]');
INSERT INTO HELP VALUES ('COLUMN', 21, '     FOR[MAT] format');
INSERT INTO HELP VALUES ('COLUMN', 22, '     HEA[DING] text');
INSERT INTO HELP VALUES ('COLUMN', 23, '     JUS[TIFY] {L[EFT] | C[ENTER] | R[IGHT]}');
INSERT INTO HELP VALUES ('COLUMN', 24, '     LIKE {expr | alias}');
INSERT INTO HELP VALUES ('COLUMN', 25, '     NEWL[INE]');
INSERT INTO HELP VALUES ('COLUMN', 26, '     NEW_V[ALUE] variable');
INSERT INTO HELP VALUES ('COLUMN', 27, '     NOPRI[NT] | PRI[NT]');
INSERT INTO HELP VALUES ('COLUMN', 28, '     NUL[L] text');
INSERT INTO HELP VALUES ('COLUMN', 29, '     OLD_V[ALUE] variable');
INSERT INTO HELP VALUES ('COLUMN', 30, '     ON|OFF');
INSERT INTO HELP VALUES ('COLUMN', 31, '     WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED]');
INSERT INTO HELP VALUES ('COLUMN', 32, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 1, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 2, ' COMPUTE');
INSERT INTO HELP VALUES ('COMPUTE', 3, ' -------');
INSERT INTO HELP VALUES ('COMPUTE', 4, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 5, ' In combination with the BREAK command, calculates and prints');
INSERT INTO HELP VALUES ('COMPUTE', 6, ' summary lines using various standard computations. Also lists');
INSERT INTO HELP VALUES ('COMPUTE', 7, ' all COMPUTE definitions.');
INSERT INTO HELP VALUES ('COMPUTE', 8, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 9, ' COMP[UTE] [function [LAB[EL] text] ...');
INSERT INTO HELP VALUES ('COMPUTE', 10, '   OF {expr|column|alias} ...');
INSERT INTO HELP VALUES ('COMPUTE', 11, '   ON {expr|column|alias|REPORT|ROW} ...]');
INSERT INTO HELP VALUES ('COMPUTE', 12, NULL);
INSERT INTO HELP VALUES ('CONNECT', 1, NULL);
INSERT INTO HELP VALUES ('CONNECT', 2, ' CONNECT');
INSERT INTO HELP VALUES ('CONNECT', 3, ' -------');
INSERT INTO HELP VALUES ('CONNECT', 4, NULL);
INSERT INTO HELP VALUES ('CONNECT', 5, ' Connects a given username to the Oracle Database. When you run a');
INSERT INTO HELP VALUES ('CONNECT', 6, ' CONNECT command, the site profile, glogin.sql, and the user profile,');
INSERT INTO HELP VALUES ('CONNECT', 7, ' login.sql, are processed in that order. CONNECT does not reprompt');
INSERT INTO HELP VALUES ('CONNECT', 8, ' for username or password if the initial connection does not succeed.');
INSERT INTO HELP VALUES ('CONNECT', 9, NULL);
INSERT INTO HELP VALUES ('CONNECT', 10, ' CONN[ECT] [{logon|/|proxy} [AS {SYSOPER|SYSDBA|SYSASM}] [edition=value]]');
INSERT INTO HELP VALUES ('CONNECT', 11, NULL);
INSERT INTO HELP VALUES ('CONNECT', 12, ' where logon has the following syntax:');
INSERT INTO HELP VALUES ('CONNECT', 13, '     username[/password][@connect_identifier]');
INSERT INTO HELP VALUES ('CONNECT', 14, NULL);
INSERT INTO HELP VALUES ('CONNECT', 15, ' where proxy has the syntax:');
INSERT INTO HELP VALUES ('CONNECT', 16, '     proxyuser[username][/password][@connect_identifier]');
INSERT INTO HELP VALUES ('CONNECT', 17, ' NOTE: Brackets around username in proxy are required syntax');
INSERT INTO HELP VALUES ('CONNECT', 18, NULL);
INSERT INTO HELP VALUES ('COPY', 1, NULL);
INSERT INTO HELP VALUES ('COPY', 2, ' COPY');
INSERT INTO HELP VALUES ('COPY', 3, ' ----');
INSERT INTO HELP VALUES ('COPY', 4, NULL);
INSERT INTO HELP VALUES ('COPY', 5, ' Copies data from a query to a table in the same or another');
INSERT INTO HELP VALUES ('COPY', 6, ' database. COPY supports CHAR, DATE, LONG, NUMBER and VARCHAR2.');
INSERT INTO HELP VALUES ('COPY', 7, NULL);
INSERT INTO HELP VALUES ('COPY', 8, ' COPY {FROM database | TO database | FROM database TO database}');
INSERT INTO HELP VALUES ('COPY', 9, '            {APPEND|CREATE|INSERT|REPLACE} destination_table');
INSERT INTO HELP VALUES ('COPY', 10, '            [(column, column, column, ...)] USING query');
INSERT INTO HELP VALUES ('COPY', 11, NULL);
INSERT INTO HELP VALUES ('COPY', 12, ' where database has the following syntax:');
INSERT INTO HELP VALUES ('COPY', 13, '     username[/password]@connect_identifier');
INSERT INTO HELP VALUES ('COPY', 14, NULL);
INSERT INTO HELP VALUES ('DEFINE', 1, NULL);
INSERT INTO HELP VALUES ('DEFINE', 2, ' DEFINE');
INSERT INTO HELP VALUES ('DEFINE', 3, ' ------');
INSERT INTO HELP VALUES ('DEFINE', 4, NULL);
INSERT INTO HELP VALUES ('DEFINE', 5, ' Specifies a substitution variable and assigns a CHAR value to it, or');
INSERT INTO HELP VALUES ('DEFINE', 6, ' lists the value and variable type of a single variable or all variables.');
INSERT INTO HELP VALUES ('DEFINE', 7, NULL);
INSERT INTO HELP VALUES ('DEFINE', 8, ' DEF[INE] [variable] | [variable = text]');
INSERT INTO HELP VALUES ('DEFINE', 9, NULL);
INSERT INTO HELP VALUES ('DEL', 1, NULL);
INSERT INTO HELP VALUES ('DEL', 2, ' DEL');
INSERT INTO HELP VALUES ('DEL', 3, ' ---');
INSERT INTO HELP VALUES ('DEL', 4, NULL);
INSERT INTO HELP VALUES ('DEL', 5, ' Deletes one or more lines of the SQL buffer. The buffer has no');
INSERT INTO HELP VALUES ('DEL', 6, ' command history list and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('DEL', 7, NULL);
INSERT INTO HELP VALUES ('DEL', 8, ' DEL [n | n m | n * | n LAST | * | * n | * LAST | LAST]');
INSERT INTO HELP VALUES ('DEL', 9, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 1, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 2, ' DESCRIBE');
INSERT INTO HELP VALUES ('DESCRIBE', 3, ' --------');
INSERT INTO HELP VALUES ('DESCRIBE', 4, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 5, ' Lists the column definitions for a table, view, or synonym,');
INSERT INTO HELP VALUES ('DESCRIBE', 6, ' or the specifications for a function or procedure.');
INSERT INTO HELP VALUES ('DESCRIBE', 7, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 8, ' DESC[RIBE] {[schema.]object[@connect_identifier]}');
INSERT INTO HELP VALUES ('DESCRIBE', 9, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 1, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 2, ' DISCONNECT');
INSERT INTO HELP VALUES ('DISCONNECT', 3, ' ----------');
INSERT INTO HELP VALUES ('DISCONNECT', 4, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 5, ' Commits pending changes to the database and logs the current');
INSERT INTO HELP VALUES ('DISCONNECT', 6, ' user out of Oracle, but does not exit SQL*Plus.');
INSERT INTO HELP VALUES ('DISCONNECT', 7, ' In SQL*Plus command line, use EXIT or QUIT to log out of Oracle');
INSERT INTO HELP VALUES ('DISCONNECT', 8, ' and return control to your computer''s operating system.');
INSERT INTO HELP VALUES ('DISCONNECT', 9, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 10, ' DISC[ONNECT]');
INSERT INTO HELP VALUES ('DISCONNECT', 11, NULL);
INSERT INTO HELP VALUES ('EDIT', 1, NULL);
INSERT INTO HELP VALUES ('EDIT', 2, ' EDIT');
INSERT INTO HELP VALUES ('EDIT', 3, ' ----');
INSERT INTO HELP VALUES ('EDIT', 4, NULL);
INSERT INTO HELP VALUES ('EDIT', 5, ' Invokes an operating system text editor on the contents of the');
INSERT INTO HELP VALUES ('EDIT', 6, ' specified file or on the contents of the SQL buffer. The buffer');
INSERT INTO HELP VALUES ('EDIT', 7, ' has no command history list and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('EDIT', 8, NULL);
INSERT INTO HELP VALUES ('EDIT', 9, ' ED[IT] [file_name[.ext]]');
INSERT INTO HELP VALUES ('EDIT', 10, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 1, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 2, ' EXECUTE');
INSERT INTO HELP VALUES ('EXECUTE', 3, ' -------');
INSERT INTO HELP VALUES ('EXECUTE', 4, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 5, ' Executes a single PL/SQL statement or runs a stored procedure.');
INSERT INTO HELP VALUES ('EXECUTE', 6, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 7, ' EXEC[UTE] statement');
INSERT INTO HELP VALUES ('EXECUTE', 8, NULL);
INSERT INTO HELP VALUES ('EXIT', 1, NULL);
INSERT INTO HELP VALUES ('EXIT', 2, ' EXIT');
INSERT INTO HELP VALUES ('EXIT', 3, ' ----');
INSERT INTO HELP VALUES ('EXIT', 4, NULL);
INSERT INTO HELP VALUES ('EXIT', 5, ' Commits or rolls back all pending changes, logs out of Oracle,');
INSERT INTO HELP VALUES ('EXIT', 6, ' terminates SQL*Plus and returns control to the operating system.');
INSERT INTO HELP VALUES ('EXIT', 7, NULL);
INSERT INTO HELP VALUES ('EXIT', 8, ' {EXIT|QUIT} [SUCCESS|FAILURE|WARNING|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('EXIT', 9, '   [COMMIT|ROLLBACK]');
INSERT INTO HELP VALUES ('EXIT', 10, NULL);
INSERT INTO HELP VALUES ('GET', 1, NULL);
INSERT INTO HELP VALUES ('GET', 2, ' GET');
INSERT INTO HELP VALUES ('GET', 3, ' ---');
INSERT INTO HELP VALUES ('GET', 4, NULL);
INSERT INTO HELP VALUES ('GET', 5, ' Loads a SQL statement or PL/SQL block from a script into the SQL buffer.');
INSERT INTO HELP VALUES ('GET', 6, ' The buffer has no command history list and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('GET', 7, NULL);
INSERT INTO HELP VALUES ('GET', 8, ' GET [FILE] file_name[.ext] [LIST | NOLIST]');
INSERT INTO HELP VALUES ('GET', 9, NULL);
INSERT INTO HELP VALUES ('HELP', 1, NULL);
INSERT INTO HELP VALUES ('HELP', 2, ' HELP');
INSERT INTO HELP VALUES ('HELP', 3, ' ----');
INSERT INTO HELP VALUES ('HELP', 4, NULL);
INSERT INTO HELP VALUES ('HELP', 5, ' Accesses this command line help system. Enter HELP INDEX or ? INDEX');
INSERT INTO HELP VALUES ('HELP', 6, ' for a list of topics.');
INSERT INTO HELP VALUES ('HELP', 7, NULL);
INSERT INTO HELP VALUES ('HELP', 8, ' You can view SQL*Plus resources at');
INSERT INTO HELP VALUES ('HELP', 9, '     http://www.oracle.com/technology/tech/sql_plus/');
INSERT INTO HELP VALUES ('HELP', 10, ' and the Oracle Database Library at');
INSERT INTO HELP VALUES ('HELP', 11, '     http://www.oracle.com/technology/documentation/');
INSERT INTO HELP VALUES ('HELP', 12, NULL);
INSERT INTO HELP VALUES ('HELP', 13, ' HELP|? [topic]');
INSERT INTO HELP VALUES ('HELP', 14, NULL);
INSERT INTO HELP VALUES ('HOST', 1, NULL);
INSERT INTO HELP VALUES ('HOST', 2, ' HOST');
INSERT INTO HELP VALUES ('HOST', 3, ' ----');
INSERT INTO HELP VALUES ('HOST', 4, NULL);
INSERT INTO HELP VALUES ('HOST', 5, ' Executes an operating system command without leaving SQL*Plus.');
INSERT INTO HELP VALUES ('HOST', 6, ' Enter HOST without command to display an operating system prompt.');
INSERT INTO HELP VALUES ('HOST', 7, ' You can then enter multiple operating system commands.');
INSERT INTO HELP VALUES ('HOST', 8, NULL);
INSERT INTO HELP VALUES ('HOST', 9, ' HO[ST] [command]');
INSERT INTO HELP VALUES ('HOST', 10, NULL);
INSERT INTO HELP VALUES ('INDEX', 1, NULL);
INSERT INTO HELP VALUES ('INDEX', 2, 'Enter Help [topic] for help.');
INSERT INTO HELP VALUES ('INDEX', 3, NULL);
INSERT INTO HELP VALUES ('INDEX', 4, ' @             COPY         PAUSE                    SHUTDOWN');
INSERT INTO HELP VALUES ('INDEX', 5, ' @@            DEFINE       PRINT                    SPOOL');
INSERT INTO HELP VALUES ('INDEX', 6, ' /             DEL          PROMPT                   SQLPLUS');
INSERT INTO HELP VALUES ('INDEX', 7, ' ACCEPT        DESCRIBE     QUIT                     START');
INSERT INTO HELP VALUES ('INDEX', 8, ' APPEND        DISCONNECT   RECOVER                  STARTUP');
INSERT INTO HELP VALUES ('INDEX', 9, ' ARCHIVE LOG   EDIT         REMARK                   STORE');
INSERT INTO HELP VALUES ('INDEX', 10, ' ATTRIBUTE     EXECUTE      REPFOOTER                TIMING');
INSERT INTO HELP VALUES ('INDEX', 11, ' BREAK         EXIT         REPHEADER                TTITLE');
INSERT INTO HELP VALUES ('INDEX', 12, ' BTITLE        GET          RESERVED WORDS (SQL)     UNDEFINE');
INSERT INTO HELP VALUES ('INDEX', 13, ' CHANGE        HELP         RESERVED WORDS (PL/SQL)  VARIABLE');
INSERT INTO HELP VALUES ('INDEX', 14, ' CLEAR         HOST         RUN                      WHENEVER OSERROR');
INSERT INTO HELP VALUES ('INDEX', 15, ' COLUMN        INPUT        SAVE                     WHENEVER SQLERROR');
INSERT INTO HELP VALUES ('INDEX', 16, ' COMPUTE       LIST         SET                      XQUERY');
INSERT INTO HELP VALUES ('INDEX', 17, ' CONNECT       PASSWORD     SHOW');
INSERT INTO HELP VALUES ('INDEX', 18, NULL);
INSERT INTO HELP VALUES ('INPUT', 1, NULL);
INSERT INTO HELP VALUES ('INPUT', 2, ' INPUT');
INSERT INTO HELP VALUES ('INPUT', 3, ' -----');
INSERT INTO HELP VALUES ('INPUT', 4, NULL);
INSERT INTO HELP VALUES ('INPUT', 5, ' Adds one or more new lines of text after the current line in the');
INSERT INTO HELP VALUES ('INPUT', 6, ' SQL buffer. The buffer has no command history list and does not');
INSERT INTO HELP VALUES ('INPUT', 7, ' record SQL*Plus commands.');
INSERT INTO HELP VALUES ('INPUT', 8, NULL);
INSERT INTO HELP VALUES ('INPUT', 9, ' I[NPUT] [text]');
INSERT INTO HELP VALUES ('INPUT', 10, NULL);
INSERT INTO HELP VALUES ('LIST', 1, NULL);
INSERT INTO HELP VALUES ('LIST', 2, ' LIST');
INSERT INTO HELP VALUES ('LIST', 3, ' ----');
INSERT INTO HELP VALUES ('LIST', 4, NULL);
INSERT INTO HELP VALUES ('LIST', 5, ' Lists one or more lines of the most recently executed SQL command');
INSERT INTO HELP VALUES ('LIST', 6, ' or PL/SQL block which is stored in the SQL buffer. Enter LIST with');
INSERT INTO HELP VALUES ('LIST', 7, ' no clauses to list all lines. In SQL*Plus command-line you can also');
INSERT INTO HELP VALUES ('LIST', 8, ' use ";" to list all the lines in the SQL buffer. The buffer has no');
INSERT INTO HELP VALUES ('LIST', 9, ' command history list and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('LIST', 10, NULL);
INSERT INTO HELP VALUES ('LIST', 11, ' L[IST] [n | n m | n  * | n LAST | * | * n | * LAST | LAST]');
INSERT INTO HELP VALUES ('LIST', 12, NULL);
INSERT INTO HELP VALUES ('MENU', 1, NULL);
INSERT INTO HELP VALUES ('MENU', 2, ' Menu');
INSERT INTO HELP VALUES ('MENU', 3, ' ----');
INSERT INTO HELP VALUES ('MENU', 4, NULL);
INSERT INTO HELP VALUES ('MENU', 5, ' Enter HELP INDEX for a list of help topics.');
INSERT INTO HELP VALUES ('MENU', 6, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 1, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 2, ' PASSWORD');
INSERT INTO HELP VALUES ('PASSWORD', 3, ' --------');
INSERT INTO HELP VALUES ('PASSWORD', 4, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 5, ' Allows you to change a password without displaying it on an input device.');
INSERT INTO HELP VALUES ('PASSWORD', 6, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 7, ' PASSW[ORD] [username]');
INSERT INTO HELP VALUES ('PASSWORD', 8, NULL);
INSERT INTO HELP VALUES ('PAUSE', 1, NULL);
INSERT INTO HELP VALUES ('PAUSE', 2, ' PAUSE');
INSERT INTO HELP VALUES ('PAUSE', 3, ' -----');
INSERT INTO HELP VALUES ('PAUSE', 4, NULL);
INSERT INTO HELP VALUES ('PAUSE', 5, ' Displays the specified text then waits for the user to press RETURN.');
INSERT INTO HELP VALUES ('PAUSE', 6, NULL);
INSERT INTO HELP VALUES ('PAUSE', 7, ' PAU[SE] [text]');
INSERT INTO HELP VALUES ('PAUSE', 8, NULL);
INSERT INTO HELP VALUES ('PRINT', 1, NULL);
INSERT INTO HELP VALUES ('PRINT', 2, ' PRINT');
INSERT INTO HELP VALUES ('PRINT', 3, ' -----');
INSERT INTO HELP VALUES ('PRINT', 4, NULL);
INSERT INTO HELP VALUES ('PRINT', 5, ' Displays the current values of bind variables, or lists all bind');
INSERT INTO HELP VALUES ('PRINT', 6, ' variables.');
INSERT INTO HELP VALUES ('PRINT', 7, NULL);
INSERT INTO HELP VALUES ('PRINT', 8, ' PRI[NT] [variable ...]');
INSERT INTO HELP VALUES ('PRINT', 9, NULL);
INSERT INTO HELP VALUES ('PROMPT', 1, NULL);
INSERT INTO HELP VALUES ('PROMPT', 2, ' PROMPT');
INSERT INTO HELP VALUES ('PROMPT', 3, ' ------');
INSERT INTO HELP VALUES ('PROMPT', 4, NULL);
INSERT INTO HELP VALUES ('PROMPT', 5, ' Sends the specified message or a blank line to the user''s screen.');
INSERT INTO HELP VALUES ('PROMPT', 6, NULL);
INSERT INTO HELP VALUES ('PROMPT', 7, ' PRO[MPT] [text]');
INSERT INTO HELP VALUES ('PROMPT', 8, NULL);
INSERT INTO HELP VALUES ('QUIT', 1, NULL);
INSERT INTO HELP VALUES ('QUIT', 2, ' QUIT (Identical to EXIT)');
INSERT INTO HELP VALUES ('QUIT', 3, ' ----');
INSERT INTO HELP VALUES ('QUIT', 4, NULL);
INSERT INTO HELP VALUES ('QUIT', 5, ' Commits or rolls back all pending changes, logs out of Oracle,');
INSERT INTO HELP VALUES ('QUIT', 6, ' terminates SQL*Plus and returns control to the operating system.');
INSERT INTO HELP VALUES ('QUIT', 7, NULL);
INSERT INTO HELP VALUES ('QUIT', 8, ' {QUIT|EXIT} [SUCCESS|FAILURE|WARNING|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('QUIT', 9, '   [COMMIT|ROLLBACK]');
INSERT INTO HELP VALUES ('QUIT', 10, NULL);
INSERT INTO HELP VALUES ('RECOVER', 1, NULL);
INSERT INTO HELP VALUES ('RECOVER', 2, ' RECOVER');
INSERT INTO HELP VALUES ('RECOVER', 3, ' -------');
INSERT INTO HELP VALUES ('RECOVER', 4, NULL);
INSERT INTO HELP VALUES ('RECOVER', 5, ' Performs media recovery on one or more tablespaces, one or more');
INSERT INTO HELP VALUES ('RECOVER', 6, ' datafiles, or the entire database.');
INSERT INTO HELP VALUES ('RECOVER', 7, NULL);
INSERT INTO HELP VALUES ('RECOVER', 8, ' RECOVER {general | managed} | BEGIN BACKUP | END BACKUP}');
INSERT INTO HELP VALUES ('RECOVER', 9, NULL);
INSERT INTO HELP VALUES ('RECOVER', 10, ' where the general clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 11, '   [AUTOMATIC] [FROM location]');
INSERT INTO HELP VALUES ('RECOVER', 12, '   { {full_database_recovery | partial_database_recovery |LOGFILE filename}');
INSERT INTO HELP VALUES ('RECOVER', 13, '   [ {TEST | ALLOW integer CORRUPTION | parallel_clause}');
INSERT INTO HELP VALUES ('RECOVER', 14, '   [TEST | ALLOW integer CORRUPTION | parallel_clause] ...]');
INSERT INTO HELP VALUES ('RECOVER', 15, '   |CONTINUE [DEFAULT]|CANCEL}');
INSERT INTO HELP VALUES ('RECOVER', 16, NULL);
INSERT INTO HELP VALUES ('RECOVER', 17, '   where the full_database_recovery clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 18, '     [STANDBY] DATABASE');
INSERT INTO HELP VALUES ('RECOVER', 19, '     [{ UNTIL {CANCEL | TIME date | CHANGE integer}');
INSERT INTO HELP VALUES ('RECOVER', 20, '      | USING BACKUP CONTROLFILE}');
INSERT INTO HELP VALUES ('RECOVER', 21, '      [ UNTIL {CANCEL | TIME date | CHANGE integer}');
INSERT INTO HELP VALUES ('RECOVER', 22, '      | USING BACKUP CONTROLFILE] ...]');
INSERT INTO HELP VALUES ('RECOVER', 23, NULL);
INSERT INTO HELP VALUES ('RECOVER', 24, '   where the partial_database_recovery clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 25, '     {TABLESPACE tablespace [, tablespace] ...');
INSERT INTO HELP VALUES ('RECOVER', 26, '      | DATAFILE filename | filenumber} [,filename | filenumber] ...');
INSERT INTO HELP VALUES ('RECOVER', 27, '      | STANDBY');
INSERT INTO HELP VALUES ('RECOVER', 28, '       {TABLESPACE tablespace [, tablespace] ...');
INSERT INTO HELP VALUES ('RECOVER', 29, '       | DATAFILE filename | filenumber} [,filename | filenumber] ...}');
INSERT INTO HELP VALUES ('RECOVER', 30, '     UNTIL [CONSISTENT WITH] CONTROLFILE }');
INSERT INTO HELP VALUES ('RECOVER', 31, NULL);
INSERT INTO HELP VALUES ('RECOVER', 32, ' where the parallel clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 33, '   {NOPARALLEL | PARALLEL [integer]}');
INSERT INTO HELP VALUES ('RECOVER', 34, NULL);
INSERT INTO HELP VALUES ('RECOVER', 35, ' where the managed clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 36, '   MANAGED STANDBY DATABASE recover_clause | cancel_clause | finish_clause');
INSERT INTO HELP VALUES ('RECOVER', 37, NULL);
INSERT INTO HELP VALUES ('RECOVER', 38, ' where the recover_clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 39, '   {{DISCONNECT [FROM SESSION] | {TIMEOUT integer | NOTIMEOUT} }');
INSERT INTO HELP VALUES ('RECOVER', 40, '    |{NODELAY | DEFAULT DELAY | DELAY integer} | NEXT integer');
INSERT INTO HELP VALUES ('RECOVER', 41, '    |{EXPIRE integer | NO EXPIRE} | parallel_clause');
INSERT INTO HELP VALUES ('RECOVER', 42, '    | USING CURRENT LOGFILE | UNTIL CHANGE integer');
INSERT INTO HELP VALUES ('RECOVER', 43, '    | THROUGH {[THREAD integer] SEQUENCE integer');
INSERT INTO HELP VALUES ('RECOVER', 44, '              | ALL ARCHIVELOG  | {ALL | LAST | NEXT } SWITCHOVER} }');
INSERT INTO HELP VALUES ('RECOVER', 45, '      [DISCONNECT [FROM SESSION ]  | {TIMEOUT integer | NOTIMEOUT}');
INSERT INTO HELP VALUES ('RECOVER', 46, '       | {NODELAY | DEFAULT DELAY | DELAY integer} | NEXT integer');
INSERT INTO HELP VALUES ('RECOVER', 47, '       | {EXPIRE integer | NO EXPIRE} | parallel_clause');
INSERT INTO HELP VALUES ('RECOVER', 48, '       | USING CURRENT LOGFILE | UNTIL CHANGE integer');
INSERT INTO HELP VALUES ('RECOVER', 49, '       | THROUGH {[THREAD integer] SEQUENCE integer');
INSERT INTO HELP VALUES ('RECOVER', 50, '                 | ALL ARCHIVELOG  | {ALL | LAST | NEXT } SWITCHOVER} ]...');
INSERT INTO HELP VALUES ('RECOVER', 51, NULL);
INSERT INTO HELP VALUES ('RECOVER', 52, ' where the cancel_clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 53, '   CANCEL [IMMEDIATE] [WAIT | NOWAIT]');
INSERT INTO HELP VALUES ('RECOVER', 54, NULL);
INSERT INTO HELP VALUES ('RECOVER', 55, ' where the finish_clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 56, '   [DISCONNECT [FROM SESSION]] [parallel_clause]');
INSERT INTO HELP VALUES ('RECOVER', 57, '   FINISH [SKIP [STANDBY LOGFILE]] [WAIT | NOWAIT]');
INSERT INTO HELP VALUES ('RECOVER', 58, NULL);
INSERT INTO HELP VALUES ('RECOVER', 59, ' where the parallel_clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 60, '   {NOPARALLEL | PARALLEL [integer] }');
INSERT INTO HELP VALUES ('RECOVER', 61, NULL);
INSERT INTO HELP VALUES ('REMARK', 1, NULL);
INSERT INTO HELP VALUES ('REMARK', 2, ' REMARK');
INSERT INTO HELP VALUES ('REMARK', 3, ' ------');
INSERT INTO HELP VALUES ('REMARK', 4, NULL);
INSERT INTO HELP VALUES ('REMARK', 5, ' Begins a comment in a script. SQL*Plus does not interpret the comment');
INSERT INTO HELP VALUES ('REMARK', 6, ' as a command.');
INSERT INTO HELP VALUES ('REMARK', 7, NULL);
INSERT INTO HELP VALUES ('REMARK', 8, ' REM[ARK]');
INSERT INTO HELP VALUES ('REMARK', 9, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 1, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 2, ' REPFOOTER');
INSERT INTO HELP VALUES ('REPFOOTER', 3, ' ---------');
INSERT INTO HELP VALUES ('REPFOOTER', 4, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 5, ' Places and formats a footer at the bottom of a report, or lists the');
INSERT INTO HELP VALUES ('REPFOOTER', 6, ' REPFOOTER definition.');
INSERT INTO HELP VALUES ('REPFOOTER', 7, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 8, ' REPF[OOTER] [PAGE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('REPFOOTER', 9, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 10, ' where printspec represents one or more of the following clauses:');
INSERT INTO HELP VALUES ('REPFOOTER', 11, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('REPFOOTER', 12, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('REPFOOTER', 13, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('REPFOOTER', 14, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 1, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 2, ' REPHEADER');
INSERT INTO HELP VALUES ('REPHEADER', 3, ' ---------');
INSERT INTO HELP VALUES ('REPHEADER', 4, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 5, ' Places and formats a header at the top of a report, or lists the');
INSERT INTO HELP VALUES ('REPHEADER', 6, ' REPHEADER definition.');
INSERT INTO HELP VALUES ('REPHEADER', 7, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 8, ' REPH[EADER] [PAGE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('REPHEADER', 9, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 10, ' where printspec represents one or more of the following clauses:');
INSERT INTO HELP VALUES ('REPHEADER', 11, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('REPHEADER', 12, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('REPHEADER', 13, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('REPHEADER', 14, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 1, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 2, ' RESERVED WORDS (SQL)');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 3, ' --------------------');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 4, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 5, ' SQL Reserved Words have special meaning in SQL, and may not be used for');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 6, ' identifier names unless enclosed in "quotes".');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 7, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 8, ' An asterisk (*) indicates words are also ANSI Reserved Words.');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 9, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 10, ' Oracle prefixes implicitly generated schema object and subobject names');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 11, ' with "SYS_". To avoid name resolution conflict, Oracle discourages you');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 12, ' from prefixing your schema object and subobject names with "SYS_".');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 13, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 14, ' ACCESS          DEFAULT*         INTEGER*        ONLINE          START');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 15, ' ADD*            DELETE*          INTERSECT*      OPTION*         SUCCESSFUL');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 16, ' ALL*            DESC*            INTO*           OR*             SYNONYM');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 17, ' ALTER*          DISTINCT*        IS*             ORDER*          SYSDATE');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 18, ' AND*            DROP*            LEVEL*          PCTFREE         TABLE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 19, ' ANY*            ELSE*            LIKE*           PRIOR*          THEN*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 20, ' AS*             EXCLUSIVE        LOCK            PRIVILEGES*     TO*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 21, ' ASC*            EXISTS           LONG            PUBLIC*         TRIGGER');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 22, ' AUDIT           FILE             MAXEXTENTS      RAW             UID');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 23, ' BETWEEN*        FLOAT*           MINUS           RENAME          UNION*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 24, ' BY*             FOR*             MLSLABEL        RESOURCE        UNIQUE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 25, ' CHAR*           FROM*            MODE            REVOKE*         UPDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 26, ' CHECK*          GRANT*           MODIFY          ROW             USER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 27, ' CLUSTER         GROUP*           NOAUDIT         ROWID           VALIDATE');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 28, ' COLUMN          HAVING*          NOCOMPRESS      ROWNUM          VALUES*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 29, ' COMMENT         IDENTIFIED       NOT*            ROWS*           VARCHAR*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 30, ' COMPRESS        IMMEDIATE*       NOWAIT          SELECT*         VARCHAR2');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 31, ' CONNECT*        IN*              NULL*           SESSION*        VIEW*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 32, ' CREATE*         INCREMENT        NUMBER          SET*            WHENEVER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 33, ' CURRENT*        INDEX            OF*             SHARE           WHERE');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 34, ' DATE*           INITIAL          OFFLINE         SIZE*           WITH*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 35, ' DECIMAL*        INSERT*          ON*             SMALLINT*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 36, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 1, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 2, ' RESERVED WORDS (PL/SQL)');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 3, ' -----------------------');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 4, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 5, ' PL/SQL Reserved Words have special meaning in PL/SQL, and may not be used');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 6, ' for identifier names (unless enclosed in "quotes").');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 7, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 8, ' An asterisk (*) indicates words are also SQL Reserved Words.');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 9, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 10, ' ALL*            DESC*           JAVA            PACKAGE         SUBTYPE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 11, ' ALTER*          DISTINCT*       LEVEL*          PARTITION       SUCCESSFUL*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 12, ' AND*            DO              LIKE*           PCTFREE*        SUM');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 13, ' ANY*            DROP*           LIMITED         PLS_INTEGER     SYNONYM*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 14, ' ARRAY           ELSE*           LOCK*           POSITIVE        SYSDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 15, ' AS*             ELSIF           LONG*           POSITIVEN       TABLE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 16, ' ASC*            END             LOOP            PRAGMA          THEN*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 17, ' AT              EXCEPTION       MAX             PRIOR*          TIME');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 18, ' AUTHID          EXCLUSIVE*      MIN             PRIVATE         TIMESTAMP');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 19, ' AVG             EXECUTE         MINUS*          PROCEDURE       TIMEZONE_ABBR');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 20, ' BEGIN           EXISTS*         MINUTE          PUBLIC*         TIMEZONE_HOUR');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 21, ' BETWEEN*        EXIT            MLSLABEL*       RAISE           TIMEZONE_MINUTE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 22, ' BINARY_INTEGER  EXTENDS         MOD             RANGE           TIMEZONE_REGION');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 23, ' BODY            EXTRACT         MODE*           RAW*            TO*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 24, ' BOOLEAN         FALSE           MONTH           REAL            TRIGGER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 25, ' BULK            FETCH           NATURAL         RECORD          TRUE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 26, ' BY*             FLOAT*          NATURALN        REF             TYPE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 27, ' CHAR*           FOR*            NEW             RELEASE         UI');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 28, ' CHAR_BASE       FORALL          NEXTVAL         RETURN          UNION*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 29, ' CHECK*          FROM*           NOCOPY          REVERSE         UNIQUE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 30, ' CLOSE           FUNCTION        NOT*            ROLLBACK        UPDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 31, ' CLUSTER*        GOTO            NOWAIT*         ROW*            USE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 32, ' COALESCE        GROUP*          NULL*           ROWID*          USER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 33, ' COLLECT         HAVING*         NULLIF          ROWNUM*         VALIDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 34, ' COMMENT*        HEAP            NUMBER*         ROWTYPE         VALUES*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 35, ' COMMIT          HOUR            NUMBER_BASE     SAVEPOINT       VARCHAR*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 36, ' COMPRESS*       IF              OCIROWID        SECOND          VARCHAR2*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 37, ' CONNECT*        IMMEDIATE*      OF*             SELECT*         VARIANCE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 38, ' CONSTANT        IN*             ON*             SEPERATE        VIEW*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 39, ' CREATE*         INDEX*          OPAQUE          SET*            WHEN');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 40, ' CURRENT*        INDICATOR       OPEN            SHARE*          WHENEVER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 41, ' CURRVAL         INSERT*         OPERATOR        SMALLINT*       WHERE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 42, ' CURSOR          INTEGER*        OPTION*         SPACE           WHILE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 43, ' DATE*           INTERFACE       OR*             SQL             WITH*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 44, ' DAY             INTERSECT*      ORDER*          SQLCODE         WORK');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 45, ' DECIMAL*        INTERVAL        ORGANIZATION    SQLERRM         WRITE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 46, ' DECLARE         INTO*           OTHERS          START*          YEAR');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 47, ' DEFAULT*        IS*             OUT             STDDEV          ZONE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 48, ' DELETE*         ISOLATION');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 49, NULL);
INSERT INTO HELP VALUES ('RUN', 1, NULL);
INSERT INTO HELP VALUES ('RUN', 2, ' RUN');
INSERT INTO HELP VALUES ('RUN', 3, ' ---');
INSERT INTO HELP VALUES ('RUN', 4, NULL);
INSERT INTO HELP VALUES ('RUN', 5, ' Lists and executes the most recently executed SQL command or');
INSERT INTO HELP VALUES ('RUN', 6, ' PL/SQL block which is stored in the SQL buffer. The buffer has');
INSERT INTO HELP VALUES ('RUN', 7, ' no command history list and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('RUN', 8, NULL);
INSERT INTO HELP VALUES ('RUN', 9, ' R[UN]');
INSERT INTO HELP VALUES ('RUN', 10, NULL);
INSERT INTO HELP VALUES ('SAVE', 1, NULL);
INSERT INTO HELP VALUES ('SAVE', 2, ' SAVE');
INSERT INTO HELP VALUES ('SAVE', 3, ' ----');
INSERT INTO HELP VALUES ('SAVE', 4, NULL);
INSERT INTO HELP VALUES ('SAVE', 5, ' Saves the contents of the SQL buffer in a script. The');
INSERT INTO HELP VALUES ('SAVE', 6, ' buffer has no command history list and does not record SQL*Plus commands.');
INSERT INTO HELP VALUES ('SAVE', 7, NULL);
INSERT INTO HELP VALUES ('SAVE', 8, ' SAV[E] [FILE] file_name[.ext] [CRE[ATE] | REP[LACE] | APP[END]]');
INSERT INTO HELP VALUES ('SAVE', 9, NULL);
INSERT INTO HELP VALUES ('SET', 1, NULL);
INSERT INTO HELP VALUES ('SET', 2, ' SET');
INSERT INTO HELP VALUES ('SET', 3, ' ---');
INSERT INTO HELP VALUES ('SET', 4, NULL);
INSERT INTO HELP VALUES ('SET', 5, ' Sets a system variable to alter the SQL*Plus environment settings');
INSERT INTO HELP VALUES ('SET', 6, ' for your current session. For example, to:');
INSERT INTO HELP VALUES ('SET', 7, '     -   set the display width for data');
INSERT INTO HELP VALUES ('SET', 8, '     -   customize HTML formatting');
INSERT INTO HELP VALUES ('SET', 9, '     -   enable or disable printing of column headings');
INSERT INTO HELP VALUES ('SET', 10, '     -   set the number of lines per page');
INSERT INTO HELP VALUES ('SET', 11, NULL);
INSERT INTO HELP VALUES ('SET', 12, ' SET system_variable value');
INSERT INTO HELP VALUES ('SET', 13, NULL);
INSERT INTO HELP VALUES ('SET', 14, ' where system_variable and value represent one of the following clauses:');
INSERT INTO HELP VALUES ('SET', 15, NULL);
INSERT INTO HELP VALUES ('SET', 16, '   APPI[NFO]{OFF|ON|text}                   NEWP[AGE] {1|n|NONE}');
INSERT INTO HELP VALUES ('SET', 17, '   ARRAY[SIZE] {15|n}                       NULL text');
INSERT INTO HELP VALUES ('SET', 18, '   AUTO[COMMIT] {OFF|ON|IMM[EDIATE]|n}      NUMF[ORMAT] format');
INSERT INTO HELP VALUES ('SET', 19, '   AUTOP[RINT] {OFF|ON}                     NUM[WIDTH] {10|n}');
INSERT INTO HELP VALUES ('SET', 20, '   AUTORECOVERY {OFF|ON}                    PAGES[IZE] {14|n}');
INSERT INTO HELP VALUES ('SET', 21, '   AUTOT[RACE] {OFF|ON|TRACE[ONLY]}         PAU[SE] {OFF|ON|text}');
INSERT INTO HELP VALUES ('SET', 22, '     [EXP[LAIN]] [STAT[ISTICS]]             RECSEP {WR[APPED]|EA[CH]|OFF}');
INSERT INTO HELP VALUES ('SET', 23, '   BLO[CKTERMINATOR] {.|c|ON|OFF}           RECSEPCHAR {_|c}');
INSERT INTO HELP VALUES ('SET', 24, '   CMDS[EP] {;|c|OFF|ON}                    SERVEROUT[PUT] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 25, '   COLSEP {_|text}                            [SIZE {n | UNLIMITED}]');
INSERT INTO HELP VALUES ('SET', 26, '   CON[CAT] {.|c|ON|OFF}                      [FOR[MAT]  {WRA[PPED] |');
INSERT INTO HELP VALUES ('SET', 27, '   COPYC[OMMIT] {0|n}                          WOR[D_WRAPPED] |');
INSERT INTO HELP VALUES ('SET', 28, '   COPYTYPECHECK {ON|OFF}                      TRU[NCATED]}]');
INSERT INTO HELP VALUES ('SET', 29, '   DEF[INE] {&|c|ON|OFF}                    SHIFT[INOUT] {VIS[IBLE] |');
INSERT INTO HELP VALUES ('SET', 30, '   DESCRIBE [DEPTH {1|n|ALL}]                 INV[ISIBLE]}');
INSERT INTO HELP VALUES ('SET', 31, '     [LINENUM {OFF|ON}] [INDENT {OFF|ON}]   SHOW[MODE] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 32, '   ECHO {OFF|ON}                            SQLBL[ANKLINES] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 33, '   EDITF[ILE] file_name[.ext]               SQLC[ASE] {MIX[ED] |');
INSERT INTO HELP VALUES ('SET', 34, '   EMB[EDDED] {OFF|ON}                        LO[WER] | UP[PER]}');
INSERT INTO HELP VALUES ('SET', 35, '   ERRORL[OGGING] {ON|OFF}                  SQLCO[NTINUE] {> | text}');
INSERT INTO HELP VALUES ('SET', 36, '     [TABLE [schema.]tablename]             SQLN[UMBER] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 37, '     [TRUNCATE] [IDENTIFIER identifier]     SQLPLUSCOMPAT[IBILITY] {x.y[.z]}');
INSERT INTO HELP VALUES ('SET', 38, '   ESC[APE] {\|c|OFF|ON}                    SQLPRE[FIX] {#|c}');
INSERT INTO HELP VALUES ('SET', 39, '   ESCCHAR {@|?|%|$|OFF}                    SQLP[ROMPT] {SQL>|text}');
INSERT INTO HELP VALUES ('SET', 40, '   EXITC[OMMIT] {ON|OFF}                    SQLT[ERMINATOR] {;|c|ON|OFF}');
INSERT INTO HELP VALUES ('SET', 41, '   FEED[BACK] {6|n|ON|OFF}                  SUF[FIX] {SQL|text}');
INSERT INTO HELP VALUES ('SET', 42, '   FLAGGER {OFF|ENTRY|INTERMED[IATE]|FULL}  TAB {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 43, '   FLU[SH] {ON|OFF}                         TERM[OUT] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 44, '   HEA[DING] {ON|OFF}                       TI[ME] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 45, '   HEADS[EP] {||c|ON|OFF}                   TIMI[NG] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 46, '   INSTANCE [instance_path|LOCAL]           TRIM[OUT] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 47, '   LIN[ESIZE] {80|n}                        TRIMS[POOL] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 48, '   LOBOF[FSET] {1|n}                        UND[ERLINE] {-|c|ON|OFF}');
INSERT INTO HELP VALUES ('SET', 49, '   LOGSOURCE [pathname]                     VER[IFY] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 50, '   LONG {80|n}                              WRA[P] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 51, '   LONGC[HUNKSIZE] {80|n}                   XQUERY {BASEURI text|');
INSERT INTO HELP VALUES ('SET', 52, '   MARK[UP] HTML [OFF|ON]                     ORDERING{UNORDERED|');
INSERT INTO HELP VALUES ('SET', 53, '     [HEAD text] [BODY text] [TABLE text]              ORDERED|DEFAULT}|');
INSERT INTO HELP VALUES ('SET', 54, '     [ENTMAP {ON|OFF}]                        NODE{BYVALUE|BYREFERENCE|');
INSERT INTO HELP VALUES ('SET', 55, '     [SPOOL {OFF|ON}]                              DEFAULT}|');
INSERT INTO HELP VALUES ('SET', 56, '     [PRE[FORMAT] {OFF|ON}]                   CONTEXT text}');
INSERT INTO HELP VALUES ('SET', 57, NULL);
INSERT INTO HELP VALUES ('SHOW', 1, NULL);
INSERT INTO HELP VALUES ('SHOW', 2, ' SHOW');
INSERT INTO HELP VALUES ('SHOW', 3, ' ----');
INSERT INTO HELP VALUES ('SHOW', 4, NULL);
INSERT INTO HELP VALUES ('SHOW', 5, ' Shows the value of a SQL*Plus system variable, or the current');
INSERT INTO HELP VALUES ('SHOW', 6, ' SQL*Plus environment. SHOW SGA requires a DBA privileged login.');
INSERT INTO HELP VALUES ('SHOW', 7, NULL);
INSERT INTO HELP VALUES ('SHOW', 8, ' SHO[W] option');
INSERT INTO HELP VALUES ('SHOW', 9, NULL);
INSERT INTO HELP VALUES ('SHOW', 10, ' where option represents one of the following terms or clauses:');
INSERT INTO HELP VALUES ('SHOW', 11, '     system_variable');
INSERT INTO HELP VALUES ('SHOW', 12, '     ALL');
INSERT INTO HELP VALUES ('SHOW', 13, '     BTI[TLE]');
INSERT INTO HELP VALUES ('SHOW', 14, '     ERR[ORS] [{FUNCTION | PROCEDURE | PACKAGE | PACKAGE BODY | TRIGGER');
INSERT INTO HELP VALUES ('SHOW', 15, '        | VIEW | TYPE | TYPE BODY | DIMENSION | JAVA CLASS} [schema.]name]');
INSERT INTO HELP VALUES ('SHOW', 16, '     LNO');
INSERT INTO HELP VALUES ('SHOW', 17, '     PARAMETERS [parameter_name]');
INSERT INTO HELP VALUES ('SHOW', 18, '     PNO');
INSERT INTO HELP VALUES ('SHOW', 19, '     RECYC[LEBIN] [original_name]');
INSERT INTO HELP VALUES ('SHOW', 20, '     REL[EASE]');
INSERT INTO HELP VALUES ('SHOW', 21, '     REPF[OOTER]');
INSERT INTO HELP VALUES ('SHOW', 22, '     REPH[EADER]');
INSERT INTO HELP VALUES ('SHOW', 23, '     SGA');
INSERT INTO HELP VALUES ('SHOW', 24, '     SPOO[L]');
INSERT INTO HELP VALUES ('SHOW', 25, '     SPPARAMETERS [parameter_name]');
INSERT INTO HELP VALUES ('SHOW', 26, '     SQLCODE');
INSERT INTO HELP VALUES ('SHOW', 27, '     TT[ITLE]');
INSERT INTO HELP VALUES ('SHOW', 28, '     USER');
INSERT INTO HELP VALUES ('SHOW', 29, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 1, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 2, ' SHUTDOWN');
INSERT INTO HELP VALUES ('SHUTDOWN', 3, ' --------');
INSERT INTO HELP VALUES ('SHUTDOWN', 4, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 5, ' Shuts down a currently running Oracle Database instance, optionally');
INSERT INTO HELP VALUES ('SHUTDOWN', 6, ' closing and dismounting a database.');
INSERT INTO HELP VALUES ('SHUTDOWN', 7, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 8, ' SHUTDOWN [ABORT|IMMEDIATE|NORMAL|TRANSACTIONAL [LOCAL]]');
INSERT INTO HELP VALUES ('SHUTDOWN', 9, NULL);
INSERT INTO HELP VALUES ('SPOOL', 1, NULL);
INSERT INTO HELP VALUES ('SPOOL', 2, ' SPOOL');
INSERT INTO HELP VALUES ('SPOOL', 3, ' -----');
INSERT INTO HELP VALUES ('SPOOL', 4, NULL);
INSERT INTO HELP VALUES ('SPOOL', 5, ' Stores query results in a file, or optionally sends the file to a printer.');
INSERT INTO HELP VALUES ('SPOOL', 6, NULL);
INSERT INTO HELP VALUES ('SPOOL', 7, ' SPO[OL] [file_name[.ext] [CRE[ATE] | REP[LACE] | APP[END]] | OFF | OUT]');
INSERT INTO HELP VALUES ('SPOOL', 8, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 1, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 2, ' SQLPLUS');
INSERT INTO HELP VALUES ('SQLPLUS', 3, ' -------');
INSERT INTO HELP VALUES ('SQLPLUS', 4, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 5, ' Starts SQL*Plus from the operating system prompt.');
INSERT INTO HELP VALUES ('SQLPLUS', 6, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 7, ' SQLPLUS [ [option] [logon|/NOLOG] [start] ]');
INSERT INTO HELP VALUES ('SQLPLUS', 8, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 9, ' where option has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 10, '     -H[ELP]');
INSERT INTO HELP VALUES ('SQLPLUS', 11, '     | -V[ERSION]');
INSERT INTO HELP VALUES ('SQLPLUS', 12, '     | [[-C[OMPATIBILITY] x.y[.z]] [-L[OGON]]');
INSERT INTO HELP VALUES ('SQLPLUS', 13, '        [-M[ARKUP] markup_option] [-R[ESTRICT] {1|2|3}] [-S[ILENT]]]');
INSERT INTO HELP VALUES ('SQLPLUS', 14, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 15, ' and where markup_option has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 16, '     HTML [ON|OFF] [HEAD text] [BODY text] [TABLE text]');
INSERT INTO HELP VALUES ('SQLPLUS', 17, '          [ENTMAP {ON|OFF}] [SPOOL {ON|OFF}] [PRE[FORMAT] {ON|OFF}]');
INSERT INTO HELP VALUES ('SQLPLUS', 18, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 19, ' and where logon has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 20, '     {username[/password][@connect_identifier] | /}');
INSERT INTO HELP VALUES ('SQLPLUS', 21, '     [AS {SYSOPER|SYSDBA|SYSASM}] [edition=value]');
INSERT INTO HELP VALUES ('SQLPLUS', 22, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 23, ' and where start has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 24, '     @{url|filename[.ext]} [arg ...]');
INSERT INTO HELP VALUES ('SQLPLUS', 25, NULL);
INSERT INTO HELP VALUES ('START', 1, NULL);
INSERT INTO HELP VALUES ('START', 2, ' START');
INSERT INTO HELP VALUES ('START', 3, ' -----');
INSERT INTO HELP VALUES ('START', 4, NULL);
INSERT INTO HELP VALUES ('START', 5, ' Runs the SQL*Plus statements in the specified script. The script can be');
INSERT INTO HELP VALUES ('START', 6, ' called from the local file system or a web server.');
INSERT INTO HELP VALUES ('START', 7, NULL);
INSERT INTO HELP VALUES ('START', 8, ' STA[RT] {url|file_name[.ext]} [arg ...]');
INSERT INTO HELP VALUES ('START', 9, NULL);
INSERT INTO HELP VALUES ('START', 10, ' where url supports HTTP and FTP protocols in the form:');
INSERT INTO HELP VALUES ('START', 11, NULL);
INSERT INTO HELP VALUES ('START', 12, '    http://host.domain/script.sql');
INSERT INTO HELP VALUES ('START', 13, NULL);
INSERT INTO HELP VALUES ('STARTUP', 1, NULL);
INSERT INTO HELP VALUES ('STARTUP', 2, ' STARTUP');
INSERT INTO HELP VALUES ('STARTUP', 3, ' -------');
INSERT INTO HELP VALUES ('STARTUP', 4, NULL);
INSERT INTO HELP VALUES ('STARTUP', 5, ' Starts an Oracle instance with several options, including mounting,');
INSERT INTO HELP VALUES ('STARTUP', 6, ' and opening a database.');
INSERT INTO HELP VALUES ('STARTUP', 7, NULL);
INSERT INTO HELP VALUES ('STARTUP', 8, ' STARTUP options | upgrade_options');
INSERT INTO HELP VALUES ('STARTUP', 9, NULL);
INSERT INTO HELP VALUES ('STARTUP', 10, ' where options has the following syntax:');
INSERT INTO HELP VALUES ('STARTUP', 11, '    [FORCE] [RESTRICT] [PFILE=filename] [QUIET] [ MOUNT [dbname] |');
INSERT INTO HELP VALUES ('STARTUP', 12, '    [ OPEN [open_options] [dbname] ] |');
INSERT INTO HELP VALUES ('STARTUP', 13, '    NOMOUNT ]');
INSERT INTO HELP VALUES ('STARTUP', 14, NULL);
INSERT INTO HELP VALUES ('STARTUP', 15, ' where open_options has the following syntax:');
INSERT INTO HELP VALUES ('STARTUP', 16, '    READ {ONLY | WRITE [RECOVER]} | RECOVER');
INSERT INTO HELP VALUES ('STARTUP', 17, NULL);
INSERT INTO HELP VALUES ('STARTUP', 18, ' and where upgrade_options has the following syntax:');
INSERT INTO HELP VALUES ('STARTUP', 19, '    [PFILE=filename] {UPGRADE | DOWNGRADE} [QUIET]');
INSERT INTO HELP VALUES ('STARTUP', 20, NULL);
INSERT INTO HELP VALUES ('STORE', 1, NULL);
INSERT INTO HELP VALUES ('STORE', 2, ' STORE');
INSERT INTO HELP VALUES ('STORE', 3, ' -----');
INSERT INTO HELP VALUES ('STORE', 4, NULL);
INSERT INTO HELP VALUES ('STORE', 5, ' Saves attributes of the current SQL*Plus environment in a script.');
INSERT INTO HELP VALUES ('STORE', 6, NULL);
INSERT INTO HELP VALUES ('STORE', 7, ' STORE {SET} file_name[.ext] [CRE[ATE] | REP[LACE] | APP[END]]');
INSERT INTO HELP VALUES ('STORE', 8, NULL);
INSERT INTO HELP VALUES ('TIMING', 1, NULL);
INSERT INTO HELP VALUES ('TIMING', 2, ' TIMING');
INSERT INTO HELP VALUES ('TIMING', 3, ' ------');
INSERT INTO HELP VALUES ('TIMING', 4, NULL);
INSERT INTO HELP VALUES ('TIMING', 5, ' Records timing data for an elapsed time period, lists the current');
INSERT INTO HELP VALUES ('TIMING', 6, ' timer''s name and timing data, or lists the number of active timers.');
INSERT INTO HELP VALUES ('TIMING', 7, NULL);
INSERT INTO HELP VALUES ('TIMING', 8, ' TIMI[NG] [START text|SHOW|STOP]');
INSERT INTO HELP VALUES ('TIMING', 9, NULL);
INSERT INTO HELP VALUES ('TTITLE', 1, NULL);
INSERT INTO HELP VALUES ('TTITLE', 2, ' TTITLE');
INSERT INTO HELP VALUES ('TTITLE', 3, ' ------');
INSERT INTO HELP VALUES ('TTITLE', 4, NULL);
INSERT INTO HELP VALUES ('TTITLE', 5, ' Places and formats a title at the top of each report page.');
INSERT INTO HELP VALUES ('TTITLE', 6, ' Enter TTITLE with no clause to list its current definition.');
INSERT INTO HELP VALUES ('TTITLE', 7, NULL);
INSERT INTO HELP VALUES ('TTITLE', 8, ' The old form of TTITLE is used if only a single word or');
INSERT INTO HELP VALUES ('TTITLE', 9, ' a string in quotes follows the TTITLE command.');
INSERT INTO HELP VALUES ('TTITLE', 10, NULL);
INSERT INTO HELP VALUES ('TTITLE', 11, ' TTI[TLE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('TTITLE', 12, NULL);
INSERT INTO HELP VALUES ('TTITLE', 13, ' where printspec represents one or more of the following clauses:');
INSERT INTO HELP VALUES ('TTITLE', 14, NULL);
INSERT INTO HELP VALUES ('TTITLE', 15, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('TTITLE', 16, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('TTITLE', 17, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('TTITLE', 18, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 1, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 2, ' UNDEFINE');
INSERT INTO HELP VALUES ('UNDEFINE', 3, ' --------');
INSERT INTO HELP VALUES ('UNDEFINE', 4, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 5, ' Deletes one or more substitution variables that you defined either');
INSERT INTO HELP VALUES ('UNDEFINE', 6, ' explicitly (with the DEFINE command), or implicitly (with a START');
INSERT INTO HELP VALUES ('UNDEFINE', 7, ' command argument).');
INSERT INTO HELP VALUES ('UNDEFINE', 8, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 9, ' UNDEF[INE] variable ...');
INSERT INTO HELP VALUES ('UNDEFINE', 10, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 1, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 2, ' VARIABLE');
INSERT INTO HELP VALUES ('VARIABLE', 3, ' --------');
INSERT INTO HELP VALUES ('VARIABLE', 4, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 5, ' Declares a bind variable that can be referenced in PL/SQL, or');
INSERT INTO HELP VALUES ('VARIABLE', 6, ' lists the current display characteristics for a single variable');
INSERT INTO HELP VALUES ('VARIABLE', 7, ' or all variables.');
INSERT INTO HELP VALUES ('VARIABLE', 8, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 9, 'VAR[IABLE] [variable [type]]');
INSERT INTO HELP VALUES ('VARIABLE', 10, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 11, ' where type represents one of the following:');
INSERT INTO HELP VALUES ('VARIABLE', 12, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 13, '     NUMBER         CHAR          CHAR (n [CHAR|BYTE])');
INSERT INTO HELP VALUES ('VARIABLE', 14, '     NCHAR          NCHAR (n)     VARCHAR2 (n [CHAR|BYTE])');
INSERT INTO HELP VALUES ('VARIABLE', 15, '     NVARCHAR2 (n)  CLOB          NCLOB');
INSERT INTO HELP VALUES ('VARIABLE', 16, '     REFCURSOR      BINARY_FLOAT  BINARY_DOUBLE');
INSERT INTO HELP VALUES ('VARIABLE', 17, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 1, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 2, ' WHENEVER OSERROR');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 3, ' ----------------');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 4, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 5, ' Performs the specified action (exits SQL*Plus by default) if an');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 6, ' operating system error occurs (such as a file writing error).');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 7, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 8, ' WHENEVER OSERROR {EXIT [SUCCESS|FAILURE|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 9, '                   [COMMIT|ROLLBACK] | CONTINUE [COMMIT|ROLLBACK|NONE]}');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 10, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 1, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 2, ' WHENEVER SQLERROR');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 3, ' -----------------');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 4, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 5, ' Performs the specified action (exits SQL*Plus by default) if a');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 6, ' SQL command or PL/SQL block generates an error.');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 7, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 8, ' WHENEVER SQLERROR {EXIT [SUCCESS|FAILURE|WARNING|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 9, '                    [COMMIT|ROLLBACK] | CONTINUE [COMMIT|ROLLBACK|NONE]}');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 10, NULL);
INSERT INTO HELP VALUES ('XQUERY', 1, NULL);
INSERT INTO HELP VALUES ('XQUERY', 2, ' XQUERY');
INSERT INTO HELP VALUES ('XQUERY', 3, ' ------');
INSERT INTO HELP VALUES ('XQUERY', 4, NULL);
INSERT INTO HELP VALUES ('XQUERY', 5, ' Performs an XQuery 1.0 query on a specified database. Attempting to use');
INSERT INTO HELP VALUES ('XQUERY', 6, ' XQUERY on a database earlier than Oracle Database 10g (Release 2) generates');
INSERT INTO HELP VALUES ('XQUERY', 7, ' an error.');
INSERT INTO HELP VALUES ('XQUERY', 8, NULL);
INSERT INTO HELP VALUES ('XQUERY', 9, ' XQUERY xquery_statement');
INSERT INTO HELP VALUES ('XQUERY', 10, NULL);
INSERT INTO HELP VALUES ('TOPICS', 1, NULL);
INSERT INTO HELP VALUES ('TOPICS', 2, ' Help is available on the following topics:');
INSERT INTO HELP VALUES ('TOPICS', 3, NULL);

COMMIT;
